/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LED;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroupData;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroupLegacy;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroupXml;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

public class LedGroupManager
implements VoDataListener {
    private boolean ledGroupAlreadySet = false;
    private LedPanel ledPanel = null;
    private VerticalLedPanel verticalLedPanel = null;
    private LedGroup ledGroupLegacy;
    final List<LedGroup> ledGroups = new ArrayList<LedGroup>();
    final VoData voData;

    public LedGroupManager(JPanel jPanel, VoData voData) {
        if (jPanel instanceof LedPanel) {
            this.ledPanel = (LedPanel)jPanel;
        } else if (jPanel instanceof VerticalLedPanel) {
            this.verticalLedPanel = (VerticalLedPanel)jPanel;
        }
        this.voData = voData;
        voData.addVoDataListener(this);
        NameValue nameValue = voData.getPropertyValue("ledDataGroups");
        if (nameValue != null) {
            Object object = nameValue.getValue();
            List<LedGroupData> list = LedGroupData.getListOfLedGroupData(object);
            for (LedGroupData ledGroupData : list) {
                this.ledGroups.add(new LedGroupXml(ledGroupData));
            }
            this.voDataChanged(voData, 0);
        } else {
            this.ledGroupLegacy = new LedGroupLegacy();
            this.ledGroupLegacy.updateLedGroup(voData);
            this.setLedGroup(this.ledGroupLegacy);
            this.ledGroupAlreadySet = true;
        }
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        if (!this.ledGroupAlreadySet) {
            for (LedGroup ledGroup : this.ledGroups) {
                ledGroup.updateLedGroup(voData);
                Collection<LED> collection = ledGroup.getLeds().values();
                if (!this.allLedsHasValues(collection) || !this.applicableLedExists(collection)) continue;
                this.setLedGroup(ledGroup);
                this.ledGroupAlreadySet = true;
                break;
            }
        }
    }

    private boolean allLedsHasValues(Collection collection) {
        boolean bl = true;
        for (LED lED : collection) {
            if (lED.getStatusType() != -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean applicableLedExists(Collection collection) {
        boolean bl = false;
        for (LED lED : collection) {
            if (lED.getStatusType() == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void setLedGroup(LedGroup ledGroup) {
        if (this.ledPanel != null) {
            this.ledPanel.setLedGroup(ledGroup);
        } else if (this.verticalLedPanel != null) {
            this.verticalLedPanel.setLedGroup(ledGroup);
        }
    }

    public LedGroup getLedGroup() {
        LedGroup ledGroup = null;
        if (this.ledPanel != null) {
            ledGroup = this.ledPanel.getLedGroup();
        }
        return ledGroup;
    }
}

