/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.BoardView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.RbsLookAndFeel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StatePanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalStateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VerticalStatePanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerModel;

public class SectorViewerPhysicalView
extends JComponent {
    final AbstractSectorViewerModel model;
    List branchNames;
    private boolean[] showSectorView;
    private String[] sectorBranchShown;
    final Container topComponent;
    final BasicStroke branchStroke;
    final BasicStroke cascadedStroke;
    final Container scrollPane;

    public SectorViewerPhysicalView(AbstractSectorViewerModel abstractSectorViewerModel) {
        this.model = abstractSectorViewerModel;
        String[] stringArray = abstractSectorViewerModel.getSectorNames();
        if (stringArray != null) {
            this.showSectorView = new boolean[stringArray.length];
            this.sectorBranchShown = new String[stringArray.length];
        }
        this.topComponent = abstractSectorViewerModel.getTopContainer().getParent();
        this.scrollPane = abstractSectorViewerModel.getScrollPane();
        this.branchStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{16.0f, 8.0f}, 0.0f);
        this.cascadedStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
    }

    public void setShowSectorView(String string, boolean bl) {
        String[] stringArray = this.model.getSectorNames();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || !string2.equals(string)) continue;
            this.showSectorView[i] = bl;
            this.repaint();
            break;
        }
    }

    public void setShowSectorBranch(String string, String string2) {
        String[] stringArray = this.model.getSectorNames();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || !string3.equals(string)) continue;
            this.sectorBranchShown[i] = string2;
            this.repaint();
            break;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.topComponent.getX();
        int n2 = this.topComponent.getY() * -1;
        int n3 = this.topComponent.getWidth();
        int n4 = this.topComponent.getHeight();
        Area area = new Area(new Rectangle2D.Double(n, n2, n3, n4));
        String[] stringArray = this.model.getSectorNames();
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList<GreyedOutRectangle> arrayList = new ArrayList<GreyedOutRectangle>();
        for (int i = 0; i < stringArray.length; ++i) {
            String object = stringArray[i];
            if (!this.showSectorView[i]) continue;
            this.branchNames = this.model.getSectorBranchNames(object);
            for (String string : this.branchNames) {
                List<VoView> list = this.model.getListOfVoViews(object, string);
                if (list == null || list.isEmpty()) continue;
                for (VoView voView : list) {
                    boolean bl;
                    if (voView instanceof StateOrLedPanel || voView instanceof StatePanel || voView instanceof VerticalStateOrLedPanel || voView instanceof VerticalStatePanel) continue;
                    Rectangle rectangle = this.getRelativeBounds(voView, string);
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    rectangle2.grow(5, 5);
                    String string2 = this.model.getSequenceNumber(object, string, voView);
                    boolean bl2 = bl = string2 != null && string2.length() > 0;
                    if (bl) {
                        rectangle2.grow(1, 7);
                        rectangle2.translate(1, 5);
                        area.subtract(new Area(rectangle2));
                        boolean bl3 = voView instanceof BoardView;
                        GreyedOutRectangle greyedOutRectangle = new GreyedOutRectangle(rectangle2, string2, bl3);
                        arrayList.add(greyedOutRectangle);
                    } else {
                        area.subtract(new Area(rectangle2));
                    }
                    if (this.model.isCascaded(object, string, voView)) {
                        this.drawCascaded(graphics2D, rectangle);
                        if (!this.model.isCrossConnected(object, string, voView) || string.equals("") || !this.sectorBranchShown[i].equals(string)) continue;
                        this.drawBranchOnCascaded(graphics2D, rectangle);
                        continue;
                    }
                    if (string.equals("") || !this.sectorBranchShown[i].equals(string)) continue;
                    this.drawBranch(graphics2D, rectangle);
                }
            }
        }
        for (GreyedOutRectangle greyedOutRectangle : arrayList) {
            this.clearCascadedSequenceNumber(graphics2D, greyedOutRectangle);
        }
        for (GreyedOutRectangle greyedOutRectangle : arrayList) {
            this.drawCascadedSequenceNumber(graphics2D, greyedOutRectangle);
        }
        if (this.isSectorViewerActive()) {
            Color color = new Color(0.0f, 0.0f, 0.0f, 0.4f);
            graphics2D.setColor(color);
            graphics2D.fill(area);
        }
    }

    public boolean isSectorViewerActive() {
        String[] stringArray = this.model.getSectorNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.showSectorView[i]) continue;
            return true;
        }
        return false;
    }

    private void drawBranch(Graphics2D graphics2D, Rectangle rectangle) {
        if (rectangle != null) {
            rectangle.grow(1, 1);
            graphics2D.setStroke(this.branchStroke);
            graphics2D.setColor(RbsLookAndFeel.COLOR_BRANCH);
            graphics2D.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width, rectangle.height);
        }
    }

    private void drawBranchOnCascaded(Graphics2D graphics2D, Rectangle rectangle) {
        if (rectangle != null) {
            rectangle.grow(4, 4);
            graphics2D.setStroke(this.branchStroke);
            graphics2D.setColor(RbsLookAndFeel.COLOR_BRANCH);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void drawCascaded(Graphics2D graphics2D, Rectangle rectangle) {
        if (rectangle != null) {
            rectangle.grow(-3, -3);
            graphics2D.setStroke(this.cascadedStroke);
            graphics2D.setColor(RbsLookAndFeel.COLOR_CASCADED);
            int n = rectangle.x + 1;
            int n2 = rectangle.y + 1;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    private void clearCascadedSequenceNumber(Graphics2D graphics2D, GreyedOutRectangle greyedOutRectangle) {
        Rectangle rectangle = greyedOutRectangle.getRectangle();
        if (graphics2D == null || rectangle == null) {
            return;
        }
        Color color = greyedOutRectangle.getBackgroundColor();
        graphics2D.setBackground(color);
        int n = greyedOutRectangle.getHeight();
        graphics2D.clearRect(rectangle.x, rectangle.y + rectangle.height - 11, rectangle.width, n);
    }

    private void drawCascadedSequenceNumber(Graphics2D graphics2D, GreyedOutRectangle greyedOutRectangle) {
        Rectangle rectangle = greyedOutRectangle.getRectangle();
        String string = greyedOutRectangle.getSequenceNo();
        if (graphics2D == null || rectangle == null || string == null) {
            return;
        }
        int n = rectangle.x + 6;
        int n2 = rectangle.y + rectangle.height - 3;
        graphics2D.setColor(greyedOutRectangle.getColor());
        graphics2D.setBackground(greyedOutRectangle.getBackgroundColor());
        if (greyedOutRectangle.isCascadedBoard()) {
            Font font = graphics2D.getFont();
            graphics2D.setFont(font.deriveFont(font.getSize2D() - 3.0f));
            graphics2D.drawString("Sq" + string, n, n2);
            graphics2D.setFont(font);
        } else {
            graphics2D.drawString("Sq" + string, n, n2);
        }
    }

    private Rectangle getRelativeBounds(JComponent jComponent, String string) {
        return this.getRelativeBounds(jComponent, jComponent.getBounds(), string);
    }

    private Rectangle getRelativeBounds(Container container, Rectangle rectangle, String string) {
        if (this.topComponent == null || container == null) {
            return null;
        }
        if (this.topComponent.equals(container)) {
            rectangle.x -= this.scrollPane.getX();
            rectangle.y -= this.scrollPane.getY();
            return rectangle;
        }
        Container container2 = container.getParent();
        if (container2 instanceof JLayeredPane) {
            return this.getRelativeBounds(container2, rectangle, string);
        }
        Rectangle rectangle2 = container2.getBounds();
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        return this.getRelativeBounds(container2, rectangle, string);
    }

    class GreyedOutRectangle {
        public static final int DEFAULT_HEIGHT = 9;
        public static final int BOARD_DEFAULT_HEIGHT = 11;
        private final Rectangle rectangle;
        private final String sequenceNo;
        private final boolean cascadedBoard;

        public GreyedOutRectangle(Rectangle rectangle, String string, boolean bl) {
            this.rectangle = rectangle;
            this.sequenceNo = string;
            this.cascadedBoard = bl;
        }

        public Color getColor() {
            return RbsLookAndFeel.COLOR_SEQUENCE_NUMBER;
        }

        public Color getBackgroundColor() {
            return this.cascadedBoard ? RbsLookAndFeel.COLOR_INSTALLED : RbsLookAndFeel.COLOR_EMPTY;
        }

        public int getHeight() {
            return this.cascadedBoard ? 11 : 9;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public String getSequenceNo() {
            return this.sequenceNo;
        }

        public boolean isCascadedBoard() {
            return this.cascadedBoard;
        }
    }
}

