/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class SubrackLayout
implements LayoutManager2 {
    public static final String NAME = "SUBRACK_LAYOUT";
    final List slotComponents = new ArrayList();
    final List slotWidth = new ArrayList();
    private int[] customSlotOrder;

    public SubrackLayout() {
    }

    public SubrackLayout(int[] nArray) {
        this.customSlotOrder = nArray;
    }

    public void setSlotWidth(int n, int n2) {
        this.ensureSize(n);
        this.slotWidth.set(n, new Integer(n2));
    }

    public void setupWideSlot(int n, int n2) {
        this.ensureSize(n);
        this.slotWidth.set(n, new Integer(n2));
        if (n2 > 1) {
            for (int i = 0; i < n2 - 1; ++i) {
                int n3 = n + 1 + i;
                this.addLayoutComponent(new JPanel(), new Integer(n3));
                this.slotWidth.set(n3, new Integer(0));
            }
        }
    }

    public int getNumberOfSlots() {
        int n = this.slotComponents.size() - 1;
        if (n < 0) {
            return 0;
        }
        return n;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Integer)) {
            throw new Error("constraint must be an Integer representing the slot number ");
        }
        int n = (Integer)object;
        if (n == 0) {
            n = 1;
        }
        this.ensureSize(n);
        ArrayList<Component> arrayList = (ArrayList<Component>)this.slotComponents.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<Component>();
        }
        arrayList.add(component);
        this.slotComponents.set(n, arrayList);
        int n2 = (Integer)this.slotWidth.get(n);
        if (arrayList.size() > n2) {
            this.setSlotWidth(n, arrayList.size());
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(1000, 1000);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("addLayoutComponent(String, Component) not supported");
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.slotComponents.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 1; i < this.slotComponents.size(); ++i) {
            int n = (Integer)this.slotWidth.get(i);
            List list = (List)this.slotComponents.get(i);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                d3 += (double)n;
                Component component = (Component)list.get(j);
                if (component == null) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.getWidth() > d) {
                    d = dimension.getWidth();
                }
                if (!(dimension.getHeight() > d2)) continue;
                d2 = dimension.getHeight();
            }
        }
        d *= d3;
        d = d + (double)container.getInsets().left + (double)container.getInsets().right;
        d2 = d2 + (double)container.getInsets().top + (double)container.getInsets().bottom;
        Dimension dimension = new Dimension((int)d, (int)d2);
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4 = this.slotComponents.size();
        double d = 0.0;
        for (n3 = 1; n3 < n4; ++n3) {
            int n5 = (Integer)this.slotWidth.get(n3);
            d += (double)n5;
        }
        n3 = 0;
        double d2 = container.getSize().getWidth();
        double[] dArray = new double[n4];
        for (n2 = 1; n2 < n4; ++n2) {
            n = (Integer)this.slotWidth.get(n2);
            int n6 = (int)((double)n * d2 / d);
            dArray[n2] = n6;
            n3 += n6;
        }
        n = 1;
        for (n2 = (int)container.getSize().getWidth() - n3; n < n4 && n2 > 0; --n2) {
            int n7 = n++;
            dArray[n7] = dArray[n7] + 1.0;
        }
        if (this.customSlotOrder != null) {
            this.layoutSlots(container, this.customSlotOrder, dArray);
        } else {
            this.layoutSlots(container, n4, dArray);
        }
    }

    private void layoutSlots(Container container, int[] nArray, double[] dArray) {
        double d = container.getSize().getHeight();
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            List list = (List)this.slotComponents.get(nArray[i]);
            if (list == null) {
                d2 += dArray[nArray[i]];
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                double d3 = dArray[nArray[i]] / (double)list.size();
                Dimension dimension = new Dimension((int)d3, (int)d);
                Point point = new Point((int)d2, n);
                Component component = (Component)list.get(j);
                if (component != null) {
                    component.setSize(dimension);
                    component.setLocation(point);
                }
                d2 += d3;
            }
        }
    }

    private void layoutSlots(Container container, int n, double[] dArray) {
        double d = container.getSize().getHeight();
        double d2 = 0.0;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            List list = (List)this.slotComponents.get(i);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                double d3 = dArray[i] / (double)list.size();
                Dimension dimension = new Dimension((int)d3, (int)d);
                Point point = new Point((int)d2, n2);
                Component component = (Component)list.get(j);
                if (component != null) {
                    component.setSize(dimension);
                    component.setLocation(point);
                }
                d2 += d3;
            }
        }
    }

    private void ensureSize(int n) {
        int n2;
        int n3 = this.slotComponents.size() - 1;
        if (n3 <= n) {
            for (n2 = n3; n2 < n; ++n2) {
                this.slotComponents.add(null);
            }
        }
        if ((n3 = this.slotWidth.size() - 1) <= n) {
            for (n2 = n3; n2 < n; ++n2) {
                this.slotWidth.add(new Integer(1));
            }
        }
    }
}

