/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class VTextIcon
implements Icon,
PropertyChangeListener {
    static final int LOCATION_STANDARD = 0;
    static final int LOCATION_ON_TOPRIGHT = 1;
    static final int LOCATION_ON_FAR_TOPRIGHT = 2;
    static final int NOT_ROTATE = 1;
    static final int LEFT_ROTATE = 2;
    static final int RIGHT_ROTATE = 4;
    static final int RIGHT_OR_LEFT_ROTATE = 6;
    static final int ROTATE = 7;
    static final double ANGLE = Math.toRadians(90.0);
    static final int spacebuf = 5;
    static final String string1 = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String string2 = "\u3001\u3002";
    Component fontComp;
    int[] char1;
    int[] char2;
    int heightOfIcon;
    int widthOfIcon;
    int heightOfChar;
    int rot;
    int des;
    String fontValue;
    String[] fontCharValue;

    public VTextIcon(Component component, String string, int n) {
        this.fontValue = string;
        this.rot = VTextIcon.verifyRotation(string, n);
        this.fontComp = component;
        this.calculateDimensions();
        this.fontComp.addPropertyChangeListener(this);
    }

    public VTextIcon(Component component, String string) {
        this(component, string, 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("font".equals(string)) {
            this.recalculateDimensions();
        }
    }

    public void setLabel(String string) {
        this.fontValue = string;
        this.rot = VTextIcon.verifyRotation(string, this.rot);
        this.recalculateDimensions();
    }

    void calculateDimensions() {
        FontMetrics fontMetrics = this.fontComp.getFontMetrics(this.fontComp.getFont());
        this.des = fontMetrics.getDescent();
        this.heightOfChar = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (this.rot == 1) {
            int n = this.fontValue.length();
            char[] cArray = new char[n];
            this.fontCharValue = new String[n];
            this.char1 = new int[n];
            this.char2 = new int[n];
            this.widthOfIcon = 0;
            this.fontValue.getChars(0, n, cArray, 0);
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                this.char1[i] = fontMetrics.charWidth(c);
                if (this.widthOfIcon < this.char1[i]) {
                    this.widthOfIcon = this.char1[i];
                }
                this.fontCharValue[i] = new String(cArray, i, 1);
                this.char2[i] = string2.indexOf(c) >= 0 ? 2 : (string1.indexOf(c) >= 0 ? 1 : 0);
            }
            this.heightOfIcon = this.heightOfChar * n + this.des;
        } else {
            this.widthOfIcon = this.heightOfChar;
            this.heightOfIcon = fontMetrics.stringWidth(this.fontValue) + 10;
        }
    }

    void recalculateDimensions() {
        int n = this.getIconHeight();
        int n2 = this.getIconWidth();
        this.calculateDimensions();
        if (n != this.getIconHeight() || n2 != this.getIconWidth()) {
            this.fontComp.invalidate();
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(component.getForeground());
        if (this.rot == 4) {
            graphics.translate(n, n2);
            ((Graphics2D)graphics).rotate(ANGLE);
            graphics.drawString(this.fontValue, 5, -this.des);
            ((Graphics2D)graphics).rotate(-ANGLE);
            graphics.translate(-n, -n2);
        } else if (this.rot == 1) {
            int n3 = n2 + this.heightOfChar;
            for (int i = 0; i < this.fontCharValue.length; ++i) {
                switch (this.char2[i]) {
                    case 2: {
                        int n4 = this.heightOfChar - this.heightOfChar / 3;
                        graphics.drawString(this.fontCharValue[i], n + n4 / 2, n3 - n4);
                        break;
                    }
                    case 1: {
                        int n4 = this.heightOfChar / 3;
                        graphics.drawString(this.fontCharValue[i], n + n4 / 2, n3 - n4);
                        break;
                    }
                    case 0: {
                        graphics.drawString(this.fontCharValue[i], n + (this.widthOfIcon - this.char1[i]) / 2, n3);
                        break;
                    }
                }
                n3 += this.heightOfChar;
            }
        } else if (this.rot == 2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(n + this.widthOfIcon, n2 + this.heightOfIcon);
            graphics2D.rotate(-ANGLE);
            graphics2D.drawString(this.fontValue, 5, -this.des);
            graphics2D.rotate(ANGLE);
            graphics.translate(-(n + this.widthOfIcon), -(n2 + this.heightOfIcon));
        }
    }

    @Override
    public int getIconHeight() {
        return this.heightOfIcon;
    }

    @Override
    public int getIconWidth() {
        return this.widthOfIcon;
    }

    public static int verifyRotation(String string, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (n2 = 0; n2 < n3; ++n2) {
            char c = cArray[n2];
            if (c >= '\u0700' && c <= '\u074f' || c >= '\u0600' && c <= '\u06ff' || c >= '\u0590' && c <= '\u05ff') {
                bl = true;
            }
            if (!(c >= '\u30a0' && c <= '\u30ff' || c >= '\uf900' && c <= '\ufaff' || c >= '\u3400' && c <= '\u4dff' || c >= '\u4e00' && c <= '\u9fff') && (c < '\u3040' || c > '\u309f')) continue;
            bl2 = true;
        }
        if (bl2) {
            return 1;
        }
        int n4 = n2 = bl ? 6 : 7;
        if ((n & n2) > 0) {
            return n;
        }
        return bl ? 2 : 4;
    }
}

