/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class BlinkingLed
extends JPanel
implements Runnable {
    static final int SIZE = 15;
    private volatile boolean isStopped;
    private volatile Color color;
    private volatile boolean isBlinkingStopped;
    private Image dbImage;
    private int blinkState = 0;
    String regTestIsRunning = System.getProperty("REG_TEST_IS_RUNNING");

    public BlinkingLed(Color color) {
        this.color = color;
        this.isStopped = false;
        this.isBlinkingStopped = true;
        Thread thread = new Thread((Runnable)this, "Blinking led");
        thread.start();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.dbImage != null) {
            graphics.drawImage(this.dbImage, 0, 0, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        BlinkingLed blinkingLed = this;
        synchronized (blinkingLed) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlink() {
        BlinkingLed blinkingLed = this;
        synchronized (blinkingLed) {
            this.isBlinkingStopped = false;
            this.notifyAll();
        }
    }

    public void haltBlink() {
        this.isBlinkingStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            this.renderLed();
            this.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isBlinkingStopped || this.dbImage == null || this.regTestIsRunning != null) continue;
            this.blinkState = 1;
            this.renderLed();
            this.repaint();
            BlinkingLed blinkingLed = this;
            synchronized (blinkingLed) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (!this.isStopped);
    }

    private void renderLed() {
        if (this.dbImage == null) {
            this.dbImage = this.createImage(15, 15);
            if (this.dbImage == null) {
                return;
            }
        }
        Graphics2D graphics2D = (Graphics2D)this.dbImage.getGraphics();
        graphics2D.setColor(this.getBackground());
        graphics2D.drawRect(0, 0, 15, 15);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.blinkState % 2 == 0) {
            graphics2D.setColor(this.color.brighter());
        } else {
            graphics2D.setColor(this.color.darker());
        }
        ++this.blinkState;
        graphics2D.fillOval(0, 0, 10, 10);
    }
}

