/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.util.Comparator;
import java.util.StringTokenizer;

public class MimVersionComparator
implements Comparator {
    public static final String MIM_NAME_VERSION_DELIMETER = "^";
    public static final String MIM_VERSION_RELEASE_DELIMETER = ".";
    public static final int SAME_VERSION = 0;
    public static final int NEWER_VERSION = 1;
    public static final int OLDER_VERSION = -1;
    public static final int VERSION_SYNTAX_ERROR = Integer.MIN_VALUE;

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Integer.MIN_VALUE;
        }
        return this.compareString(object.toString(), object2.toString());
    }

    public int compareString(String string, String string2) {
        MimVersionData mimVersionData = new MimVersionData(string);
        MimVersionData mimVersionData2 = new MimVersionData(string2);
        return this.compareMimVersionData(mimVersionData, mimVersionData2);
    }

    private int compareMimVersionData(MimVersionData mimVersionData, MimVersionData mimVersionData2) {
        int n;
        String string = mimVersionData.getName();
        String string2 = mimVersionData2.getName();
        if (string == null && string2 != null || string != null && string2 == null) {
            return Integer.MIN_VALUE;
        }
        if (string != null && string2 != null) {
            n = string.compareTo(string2);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
        }
        if ((n = MimVersionComparator.compareVersionOrRelease(mimVersionData.getVersion(), mimVersionData2.getVersion())) == Integer.MIN_VALUE || n != 0) {
            return n;
        }
        int n2 = MimVersionComparator.compareVersionOrRelease(mimVersionData.getRelease(), mimVersionData2.getRelease());
        return n2;
    }

    private static int compareVersionOrRelease(String string, String string2) {
        if (string == null || string2 == null) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public class MimVersionData {
        private String name = null;
        private String version = null;
        private String release = null;

        public MimVersionData(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, MimVersionComparator.MIM_NAME_VERSION_DELIMETER);
            if (stringTokenizer.countTokens() == 2) {
                this.name = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                this.extractVersionAndRelease(string2);
            } else if (stringTokenizer.countTokens() == 1) {
                this.extractVersionAndRelease(string);
            }
        }

        public MimVersionData(String string, String string2) {
            this.name = string;
            this.extractVersionAndRelease(string2);
        }

        public MimVersionData(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            this.release = string3;
        }

        private void extractVersionAndRelease(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, MimVersionComparator.MIM_VERSION_RELEASE_DELIMETER);
            if (stringTokenizer.countTokens() != 2) {
                return;
            }
            this.version = stringTokenizer.nextToken();
            this.release = stringTokenizer.nextToken();
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRelease() {
            return this.release;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.name != null) {
                stringBuffer.append(this.name);
            }
            stringBuffer.append(MimVersionComparator.MIM_NAME_VERSION_DELIMETER);
            if (this.version != null) {
                stringBuffer.append(this.version);
            } else {
                stringBuffer.append("");
            }
            stringBuffer.append(MimVersionComparator.MIM_VERSION_RELEASE_DELIMETER);
            if (this.release != null) {
                stringBuffer.append(this.release);
            } else {
                stringBuffer.append("");
            }
            return stringBuffer.toString();
        }
    }
}

