/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.constraints.MoConstraint;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.PropertyElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.AbstractTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.AllChildren;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.Child;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.Parent;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.Reference;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.RepeatedReference;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.constraints.ConstraintsElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public abstract class Relationship
extends AbstractTemplate {
    private List moRelations = new ArrayList();
    private ConstraintsElement constraintsElement;
    private Map<String, String> storeAttributeAsProperty = new HashMap<String, String>();

    public Relationship(Hashtable hashtable, Node node) {
        super(new Hashtable(hashtable), node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("parent")) {
                this.moRelations.add(new Parent(this.getParams(), node2));
                continue;
            }
            if (string.equals("allChildren")) {
                this.moRelations.add(new AllChildren(this.getParams(), node2));
                continue;
            }
            if (string.equals("reference")) {
                this.moRelations.add(new Reference(this.getParams(), node2));
                continue;
            }
            if (string.equals("repeatedReference")) {
                this.moRelations.add(new RepeatedReference(this.getParams(), node2));
                continue;
            }
            if (string.equals("child")) {
                this.moRelations.add(new Child(this.getParams(), node2));
                continue;
            }
            if (string.equals("constraints")) {
                this.constraintsElement = new ConstraintsElement(this.getParams(), node2);
                continue;
            }
            if (!string.equals("storeAttributeAsProperty")) continue;
            ArrayList<String> arrayList = Helper.getValuesFromNode(null, node2, "attributeName");
            ArrayList<String> arrayList2 = Helper.getValuesFromNode(null, node2, "propertyName");
            if (arrayList == null || arrayList2 == null) continue;
            this.storeAttributeAsProperty.put((String)arrayList.get(0), (String)arrayList2.get(0));
        }
    }

    @Override
    public abstract VoTemplate createVoTemplate(CabinetViewerMimModel var1, Hashtable var2);

    public abstract MoRelationship createMoRelationship(CabinetViewerMimModel var1);

    public MoRelationship addMoRelationship(CabinetViewerMimModel cabinetViewerMimModel, MoRelationship moRelationship) {
        Object object;
        if (this.constraintsElement != null && (object = this.constraintsElement.createMoConstraint(moRelationship)) != null) {
            moRelationship.addConstraint((MoConstraint)object);
        }
        this.updateWithDynamicProperties(moRelationship);
        for (Object e : this.moRelations) {
            Relationship relationship = (Relationship)e;
            MoRelationship moRelationship2 = relationship.createMoRelationship(cabinetViewerMimModel);
            if (moRelationship2 == null) continue;
            moRelationship.addRelationship(moRelationship2);
        }
        return moRelationship;
    }

    protected MoRelationship updateWithProperties(MoRelationship moRelationship) {
        moRelationship.setStoreAttributeAsProperty(this.storeAttributeAsProperty);
        PropertyElement propertyElement = this.getProperty();
        if (propertyElement != null) {
            Hashtable hashtable = new Hashtable(propertyElement.getProperties());
            if (hashtable.containsKey("moId")) {
                moRelationship.setMoIdentity(hashtable.get("moId").toString());
                hashtable.remove("moId");
            }
            if (hashtable.containsKey("KEY_HIDDEN")) {
                moRelationship.setHidden(true);
                hashtable.remove("KEY_HIDDEN");
            }
            moRelationship.setProperties(hashtable);
        }
        return moRelationship;
    }
}

