/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlist.controller.impl;

import java.util.Properties;
import se.ericsson.cello.em.fm.alarmlist.controller.impl.AlarmListController;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.security.utils.EmLogger;

public class AlarmSuppressionConfigurator {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private String alarmSuppressionMoClass;
    private String displayCondition;
    private Properties properties;
    private boolean userSpecified = false;
    private AlarmListController alarmListController;
    private static String[] defaultLdns = new String[]{"ManagedElement=1,ENodeBFunction=1", "ManagedElement=1,NodeBFunction=1", "ManagedElement=1,NodeManagementFunction=1"};
    private static String ALARMSUPPRESSION_MO_CLASS = "ALARMSUPPRESSION_MO_CLASS";
    private static String ALARMSUPPRESSION_DISPLAY_CONDITION = "ALARMSUPPRESSION_DISPLAY_CONDITION";
    private static String NOT_SPECIFID = "Not Specified";
    private static String AS_DISPLAY_CONDITION = "alarmSuppressed=='true'";

    public boolean isUserSpecified() {
        return this.userSpecified;
    }

    public void setProperties(Properties props) {
        this.properties = props;
        if (props != null) {
            this.alarmSuppressionMoClass = this.properties.getProperty(ALARMSUPPRESSION_MO_CLASS, NOT_SPECIFID);
            this.displayCondition = this.properties.getProperty(ALARMSUPPRESSION_DISPLAY_CONDITION, NOT_SPECIFID);
            this.userSpecified = this.alarmSuppressionMoClass == null || this.alarmSuppressionMoClass.equalsIgnoreCase(NOT_SPECIFID) ? false : this.displayCondition != null && !this.displayCondition.equalsIgnoreCase(NOT_SPECIFID);
        } else {
            this.userSpecified = false;
            this.alarmSuppressionMoClass = null;
            this.displayCondition = null;
        }
    }

    public void setController(AlarmListController c) {
        this.alarmListController = c;
    }

    private Mo getConfiguredAlarmSuppressionMo() {
        Mo aMo = null;
        String aLdn = null;
        for (int i = 0; i < defaultLdns.length && (aMo = this.searchForMo(aLdn = defaultLdns[i])) == null; ++i) {
        }
        return aMo;
    }

    private Mo searchForMo(String aLdn) {
        LOG.finest("searchForMo: LDN:" + aLdn, new Object[0]);
        Mo mo = null;
        try {
            mo = this.alarmListController.getToolService().getNodeServices().getNode().getCmService().getMo(aLdn);
            if (!mo.exists()) {
                mo = null;
            }
        }
        catch (Exception e) {
            mo = null;
            String reason = "Can not get MO:  " + aLdn + "   \n" + e.getMessage();
            LOG.warning(reason, new Object[0]);
        }
        return mo;
    }

    public String getDisplayCondition() {
        String visibleCondition = null;
        visibleCondition = this.userSpecified ? this.displayCondition : AS_DISPLAY_CONDITION;
        return visibleCondition;
    }

    public String getAlarmSuppressionMoClass() {
        Mo autoFoundMo;
        String theMoClass = null;
        theMoClass = this.userSpecified ? this.alarmSuppressionMoClass : ((autoFoundMo = this.getConfiguredAlarmSuppressionMo()) != null ? autoFoundMo.getType() : null);
        return theMoClass;
    }
}

