/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common;

import java.util.Properties;
import se.ericsson.cello.em.fm.common.controller.ifc.ToolController;
import se.ericsson.cello.em.fm.common.factory.impl.ToolFactory;
import se.ericsson.cello.em.fm.common.utils.impl.FmEvent;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EmasException;
import se.ericsson.security.utils.EmLogger;

public abstract class AbstractTool
implements Launchable,
EKEY {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final String CUSTOM_APPL_NAME_KEY = "CUSTOM_APPL_NAME";
    private static final String LOG_NAME_KEY = "LOG_NAME";
    private static final String MANAGER_TITLE_KEY = "MANAGER_TITLE";
    private static final String DEFAULT_PROPERTY_VALUE = "unknown";
    private LauncherInterface launcher;
    private String applicationName;
    private String managerTitle;
    protected ToolController controller;

    public void run(String hostName, Properties properties, LauncherInterface launcher, Launchable parent) {
        this.launcher = launcher;
        this.applicationName = properties.getProperty(CUSTOM_APPL_NAME_KEY, DEFAULT_PROPERTY_VALUE);
        this.managerTitle = properties.getProperty(MANAGER_TITLE_KEY, DEFAULT_PROPERTY_VALUE);
        String logname = properties.getProperty(LOG_NAME_KEY, DEFAULT_PROPERTY_VALUE);
        FmType type = null;
        try {
            type = FmType.getFmType(logname);
        }
        catch (IllegalArgumentException e) {
            StringBuilder message = new StringBuilder();
            message.append("The tool ");
            message.append(this.applicationName);
            message.append(" could not be started. \n");
            message.append(e.getMessage());
            message.append(" \nThe parameter LOG_NAME in the tool configuration file may be faulty.");
            throw new IllegalArgumentException(message.toString(), e);
        }
        this.controller = ToolFactory.INSTANCE.createToolController(type, properties, launcher, this);
        try {
            this.controller.init();
        }
        catch (EmasException e) {
            e.set(APPLICATION, (Object)this.applicationName);
            MessageDialogFactory.createErrorDialog((Exception)((Object)e)).setVisible(true);
        }
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public void exit() {
        this.launcher.onExit((Launchable)this);
        LOG.info(this.applicationName + " closed successfully.", new Object[0]);
    }

    public String toString() {
        return this.managerTitle + " - " + this.applicationName;
    }

    public void sendEmNotification(String type, Object userData, Object source) {
        EmNotificationServiceInterface emNotificationService = null;
        if (this.launcher instanceof EmNotificationServiceInterface) {
            FmEvent fmEvent = new FmEvent(type, userData, source);
            emNotificationService = (EmNotificationServiceInterface)this.launcher;
            emNotificationService.sendNotification((EmEventInterface)fmEvent);
            LOG.info("Notification sent: " + type, new Object[0]);
        } else {
            LOG.info("Notification service not available. ", new Object[0]);
        }
    }
}

