/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExtendedEventType {
    ACK_STATE_CHANGED("x3", "Acknowledgement State Changed"),
    ALARM_LIST_REBUILT("x5", "Alarm List Rebuilt"),
    CHANGED_ALARM("x2", "Changed Alarm"),
    CLEARED_ALARM("x4", "Cleared Alarm"),
    NEW_ALARM("x1", "New Alarm"),
    NEW_EVENT("z1", "New Event"),
    UNKNOWN_EXTENDED_EVENT_TYPE("", "Unknown extended event type");

    private static final EmLogger LOG;
    public final String STATE;
    public final String PRESENTATION_STRING;

    private ExtendedEventType(String state, String presentationStr) {
        this.STATE = state;
        this.PRESENTATION_STRING = presentationStr;
    }

    public static ExtendedEventType getExtendedEventType(String state) {
        for (ExtendedEventType extendedEventType : ExtendedEventType.values()) {
            if (!extendedEventType.STATE.equals(state)) continue;
            return extendedEventType;
        }
        LOG.warning("Unknown extended event type: " + state, new Object[0]);
        return UNKNOWN_EXTENDED_EVENT_TYPE;
    }

    public String toString() {
        return this.PRESENTATION_STRING;
    }

    static {
        LOG = EmLogger.TROUBLE_SHOOTING;
    }
}

