/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.ipoam.DhcpMo;
import se.ericsson.cello.ipoam.EthernetLinkMoImpl;
import se.ericsson.cello.ipoam.IpHostLinkMoImpl;
import se.ericsson.cello.ipoam.IpOamMoImpl;
import se.ericsson.cello.ipoam.fropxy.OsaDhcprFroGetAttributeRsp;
import se.ericsson.cello.ipoam.fropxy.OsaDhcprFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaDhcprFroSetAttributeRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class DhcpMoImpl
extends CelloMao
implements DhcpMo {
    private MoData data;
    private static final String DHCP_ID_VALUE = "1";
    private static final int DHCPR_ENABLED = 1;
    private static final int REMOVE_IPADDRESSES = 0;
    private static final int ADD_IPADDRESSES = 1;
    private FroProxy dhcpProxy;
    private OsaDhcprFroMgmntProxy dhcprProxy = OsaDhcprFroMgmntProxy.instance();
    private static final int MO_DATA_REVISION_6000 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    static /* synthetic */ Class class$java$lang$String;

    protected DhcpMoImpl(FroProxy froProxy) throws MoNameAlreadyTakenException {
        super((ManagedObject)IpOamMoImpl.instance(), "Dhcp", DHCP_ID_VALUE, null);
        this.dhcpProxy = froProxy;
        this.registerData();
    }

    private void registerData() {
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
            this.data = new MoData(this.getLocalDistinguishedName(), "Dhcp", true, coordinator);
            this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
            this.data.setRevision(6000);
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            control.getTerminator().commit();
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)"start of Dhcp failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"start of Dhcp failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"start of Dhcp failed", (Throwable)inactiveTransactionException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"start of Dhcp failed", (Throwable)moAccessException);
        }
    }

    public DhcpMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.dhcpProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getType() {
        return "Dhcp";
    }

    public ManagedObject getManagedElementData() throws MoCanNotBeCreatedException {
        MoRepository moRepository = MoRepository.instance();
        MoIterator moIterator = moRepository.lookupType("ManagedElementData");
        if (moIterator != null) {
            if (moIterator.hasMoreElements()) {
                return (ManagedObject)moIterator.nextElement();
            }
            throw new MoCanNotBeCreatedException("Dhcp");
        }
        throw new MoCanNotBeCreatedException("Dhcp");
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String[] getDhcpServerAddresses(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (System.getProperty("SIM") == null) {
            long l = 0L;
            if (coordinator != null) {
                l = coordinator.getTransactionID();
            }
            long[] lArray = new long[]{5L, 4L, -1L};
            OsaDhcprFroGetAttributeRsp osaDhcprFroGetAttributeRsp = this.dhcprProxy.sendDhcprFroGetAttributeReq(l, lArray);
            this.checkSignal((Signal)osaDhcprFroGetAttributeRsp, "DHCPR fRO");
            this.checkDhcprFroResult(osaDhcprFroGetAttributeRsp.getResult(), "GetAttribute");
            long l2 = osaDhcprFroGetAttributeRsp.getNAddresses();
            String[] stringArray = new String[(int)l2];
            long[] lArray2 = osaDhcprFroGetAttributeRsp.getIpAddress();
            int n = 0;
            while ((long)n < l2) {
                stringArray[n] = new IpAddress((long)((int)lArray2[n])).toString();
                ++n;
            }
            return stringArray;
        }
        return new String[0];
    }

    public Struct actionGetDhcpData(int n, int[] nArray, String string, String string2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != nArray.length) {
            throw new IllegalAttributeValueException("GetDhcpData action has failed due to data mismatch in inparameters: numberOfRequestedDhcpOptions, listOfRequestedDhcpOptions.", "Dhcp");
        }
        if (!this.checkEthernetLink(coordinator, string2) && !this.checkIpHostLink(coordinator, string2)) {
            throw new OperationNotAllowedException(" neither IpHostLink nor EthernetLink exist for this ifName", "Dhcp");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StructImpl structImpl = null;
        arrayList.add(new UnsignedIntParameter("numberOfRequestedDhcpOptions", (long)n));
        arrayList.add(this.makeArrayParameter(nArray));
        arrayList.add(new StringParameter("hostId", string));
        arrayList.add(new StringParameter("ifName", string2));
        Map map = this.dhcpProxy.actionWithCfm(coordinator, 0, 1, arrayList);
        String[] stringArray = new String[]{"bootFileName", "clientHwAddress", "clientIpAddress", "dhcpOptions", "ifName", "relayAgentIpAddress", "serverHostName", "serverIpAddress", "yourIpAddress"};
        Object[] objectArray = new Object[]{((StringParameter)map.get("bootFileName")).getValue(), ((StringParameter)map.get("clientHwAddress")).getValue(), ((StringParameter)map.get("clientIpAddress")).getValue(), this.getArray((ArrayParameter)map.get("dhcpOptions")), map.get("ifName") != null ? ((StringParameter)map.get("ifName")).getValue() : string2, map.get("relayAgentIpAddress") != null ? ((StringParameter)map.get("relayAgentIpAddress")).getValue() : "0.0.0.0", map.get("serverHostName") != null ? ((StringParameter)map.get("serverHostName")).getValue() : "", ((StringParameter)map.get("serverIpAddress")).getValue(), ((StringParameter)map.get("yourIpAddress")).getValue()};
        structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    public void actionReleaseDhcpIf(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("ifName", string));
        this.dhcpProxy.actionWithCfm(coordinator, 0, 2, arrayList);
    }

    public boolean checkIpHostLink(Coordinator coordinator, String string) throws OperationNotAllowedException, MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("IpHostLink");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                String string2 = ((IpHostLinkMoImpl)managedObject).getInterfaceName(coordinator);
                String string3 = ((IpHostLinkMoImpl)managedObject).getIpAddress(coordinator);
                if (!string2.equalsIgnoreCase(string)) continue;
                if (!string3.equalsIgnoreCase("0.0.0.0")) {
                    throw new OperationNotAllowedException(" action is not allowed for this ifName because the ipAddress of the IpHostLink is not 0.0.0.0", "Dhcp");
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkEthernetLink(Coordinator coordinator, String string) throws OperationNotAllowedException, MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("EthernetLink");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                String string2 = ((EthernetLinkMoImpl)managedObject).getInterfaceName(coordinator);
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayParameter makeArrayParameter(int[] nArray) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("listOfReqestedDhcpOptions");
        for (int i = 0; i < nArray.length; ++i) {
            arrayParameter.add((Parameter)new UnsignedIntParameter("elementOfRequestedDhcpOptions", (long)nArray[i]));
        }
        return arrayParameter;
    }

    private int[] getArray(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter != null) {
            int[] nArray = new int[arrayParameter.size()];
            for (int i = 0; i < arrayParameter.size(); ++i) {
                nArray[i] = (int)((UnsignedIntParameter)arrayParameter.get(i)).getValue();
            }
            return nArray;
        }
        return null;
    }

    public void actionAddDhcpServerAddress(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (stringArray == null) {
            throw new ValueOutOfRangeException("Dhcp Server IP Address is Empty", "Dhcp");
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        if (stringArray.length != linkedHashSet.size()) {
            throw new IllegalAttributeValueException("dhcpServerAddresses", "Duplicated DHCP server address");
        }
        linkedHashSet = (LinkedHashSet<String>)new long[2];
        linkedHashSet[0] = 4L;
        linkedHashSet[1] = -1L;
        OsaDhcprFroGetAttributeRsp osaDhcprFroGetAttributeRsp = this.dhcprProxy.sendDhcprFroGetAttributeReq(0L, (long[])linkedHashSet);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Ipv4AddressValidation.isValidIpv4Address((String)stringArray[i])) {
                throw new IllegalAttributeValueException("Ip Address is not in proper Ipv4 Format", "Dhcp");
            }
            vector.add(stringArray[i]);
        }
        String[] stringArray2 = this.getDhcpServerAddresses(coordinator);
        for (n = 0; n < stringArray2.length; ++n) {
            if (!vector.contains(stringArray2[n])) continue;
            vector.remove(stringArray2[n]);
        }
        n = 0;
        this.checkSignal((Signal)osaDhcprFroGetAttributeRsp, "DHCPR fRO");
        if (osaDhcprFroGetAttributeRsp.getResult() != 1L) {
            throw new FroRequestFailedException("Dhcp", "dhcpGetAttribute", this.dhcprProxy.getResultMsg(osaDhcprFroGetAttributeRsp.getResult()), (int)osaDhcprFroGetAttributeRsp.getResult());
        }
        n = (int)osaDhcprFroGetAttributeRsp.getNAddresses();
        if (n + vector.size() > 10) {
            throw new OperationNotAllowedException("DHCP Server IP Address's should not exceed more than 10", "Dhcp");
        }
        if (n <= 0) {
            this.setEnable(1, coordinator);
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        if (stringArray3.length > 0) {
            this.configDhcpServerAddresses(1, stringArray3, coordinator);
        }
        Object[] objectArray = new Object[]{this.getDhcpServerAddresses(coordinator)};
        String[] stringArray4 = new String[]{"dhcpServerAddresses"};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray4, objectArray, coordinator);
    }

    public void actionRemoveDhcpServerAddress(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else {
            n = stringArray.length;
        }
        if (n == 0 || n == 1 && stringArray[0].equals("")) {
            return;
        }
        this.configDhcpServerAddresses(0, stringArray, coordinator);
        Object[] objectArray = new Object[]{this.getDhcpServerAddresses(coordinator)};
        String[] stringArray2 = new String[]{"dhcpServerAddresses"};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray, coordinator);
    }

    private void configDhcpServerAddresses(int n, String[] stringArray, Coordinator coordinator) throws MoAccessException {
        int n2 = stringArray.length;
        long[] lArray = new long[4];
        int n3 = 0;
        lArray[0] = 5L;
        lArray[1] = n;
        lArray[2] = n2;
        lArray[3] = -1L;
        long[] lArray2 = new long[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            lArray2[n3] = new IpAddress(stringArray[n3]).toLong();
        }
        OsaDhcprFroSetAttributeRsp osaDhcprFroSetAttributeRsp = this.dhcprProxy.sendDhcprFroSetAttributeReq((long)coordinator.getTransactionID(), lArray, lArray2);
        this.checkSignal((Signal)osaDhcprFroSetAttributeRsp, "DHCPR fRO");
        this.checkDhcprFroResult(osaDhcprFroSetAttributeRsp.getResult(), "SetAttribute");
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dhcpServerAddresses")) {
                objectArray[i] = this.getDhcpServerAddresses(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Dhcp");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? DhcpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Dhcp");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "Dhcp");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Dhcp", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }

    private void setEnable(int n, Coordinator coordinator) throws MoAccessException {
        long[] lArray = new long[]{0L, n, -1L};
        OsaDhcprFroSetAttributeRsp osaDhcprFroSetAttributeRsp = this.dhcprProxy.sendDhcprFroSetAttributeReq(coordinator.getTransactionID(), lArray);
        this.checkSignal((Signal)osaDhcprFroSetAttributeRsp, "DHCPR fRO");
        this.checkDhcprFroResult(osaDhcprFroSetAttributeRsp.getResult(), "SetAttribute");
    }

    private void checkSignal(Signal signal, String string) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("Dhcp", string);
        }
        if (signal instanceof OsaDhcprFroGetAttributeRsp && ((OsaDhcprFroGetAttributeRsp)signal).isUnknownTagFound()) {
            String string2 = "Unknown Tag from FRO at initReceive of OsaDhcprFroGetAttributeRsp: " + ((OsaDhcprFroGetAttributeRsp)signal).getUnknownTag();
            throw new NoSuchFieldException(string2);
        }
    }

    private void checkDhcprFroResult(long l, String string) throws MoAccessException {
        if (l != 1L) {
            String string2 = this.dhcprProxy.getResultMsg(l);
            throw new FroRequestFailedException("Dhcp", "Dhcpr fRO", string + ": " + string2, (int)l);
        }
    }
}

