/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import se.ericsson.security.login.codec.BASE64Provider;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactorySpi;
import se.ericsson.security.login.codec.PKCS5Provider;
import se.ericsson.security.login.codec.PKCS8Provider;
import se.ericsson.security.login.codec.X509Provider;

public class CodecFactory {
    private final CodecFactorySpi codecFacSpi;
    private final String type;
    private static CodecFactory base64;
    private static CodecFactory pkcs8;
    private static CodecFactory pkcs5;
    private static CodecFactory x509;

    private CodecFactory(CodecFactorySpi codecFactorySpi, String string) {
        this.type = string;
        this.codecFacSpi = codecFactorySpi;
    }

    public static final CodecFactory getInstance(String string) throws CodecException {
        if ("BASE64".equals(string)) {
            if (base64 == null) {
                base64 = new CodecFactory(new BASE64Provider(), string);
            }
            return base64;
        }
        if ("PKCS#8".equals(string)) {
            if (pkcs8 == null) {
                pkcs8 = new CodecFactory(new PKCS8Provider(), string);
            }
            return pkcs8;
        }
        if ("PKCS#5".equals(string)) {
            if (pkcs5 == null) {
                pkcs5 = new CodecFactory(new PKCS5Provider(), string);
            }
            return pkcs5;
        }
        if ("X509".equals(string)) {
            if (x509 == null) {
                x509 = new CodecFactory(new X509Provider(), string);
            }
            return x509;
        }
        throw new CodecException("No such codec Provider: " + string);
    }

    public final byte[] encode(Object object) throws CodecException {
        return this.codecFacSpi.engineEncode(object);
    }

    public final String encodeAsString(Object object) throws CodecException {
        return this.codecFacSpi.engineEncodeAsString(object);
    }

    public final byte[] encodeAndEncrypt(Object object, char[] cArray) throws CodecException {
        return this.codecFacSpi.engineEncodeAndEncrypt(object, cArray);
    }

    public final Object decode(byte[] byArray) throws CodecException {
        return this.codecFacSpi.engineDecode(byArray);
    }

    public final Object decode(String string) throws CodecException {
        return this.codecFacSpi.engineDecode(string);
    }

    public final Object decodeAndDecrypt(byte[] byArray, char[] cArray) throws CodecException {
        return this.codecFacSpi.engineDecodeAndDecrypt(byArray, cArray);
    }

    public final Object decodeAndDecrypt(String string, char[] cArray) throws CodecException {
        return this.codecFacSpi.engineDecodeAndDecrypt(string, cArray);
    }
}

