/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsFactorySpi;
import se.ericsson.security.login.creds.XMLCredentialsHandler;

class XMLCredentialsFactory
extends CredentialsFactorySpi {
    XMLCredentialsFactory() {
    }

    public Credentials engineGenerateCredentials(InputStream inputStream) throws CredentialsException {
        return this.engineGenerateCredentials(inputStream, null);
    }

    public Credentials engineGenerateCredentials(InputStream inputStream, char[] cArray) throws CredentialsException {
        try {
            Credentials credentials = new Credentials();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new XMLCredentialsHandler(credentials, cArray));
            return credentials;
        }
        catch (SAXException sAXException) {
            throw new CredentialsException("Failed to generate credentials", sAXException);
        }
        catch (IOException iOException) {
            throw new CredentialsException("Failed to generate credentials", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CredentialsException("Failed to generate credentials", parserConfigurationException);
        }
    }
}

