/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.security.empatcher.CommandLineParameters;
import se.ericsson.security.empatcher.FoundLaxFilesSet;
import se.ericsson.security.empatcher.JarFileWriter;
import se.ericsson.security.empatcher.Java14FileCopy;
import se.ericsson.security.empatcher.LaxFile;
import se.ericsson.security.empatcher.LaxFileParser;
import se.ericsson.security.empatcher.MsgBuffer;
import se.ericsson.security.launcher.cache.CacheException;

public class EmPatcherMain {
    public static final String PROGNAME = "EMPatcher";
    private final CommandLineParameters clp;
    private final SortedSet foundLaxFiles;
    private SortedSet modifiedLaxFileSet = new TreeSet();
    private SortedSet unmodifiedLaxFileSet = new TreeSet();
    private SortedSet commitedLaxFileSet = new TreeSet();
    private SortedSet uncommitedLaxFileSet = new TreeSet();
    private LaxFileParser laxFileParser;

    private EmPatcherMain(String[] args) {
        this.clp = new CommandLineParameters(args);
        System.out.println("\nSearching for LAX files at : " + Arrays.asList(this.clp.getLaxPaths()));
        this.foundLaxFiles = new FoundLaxFilesSet(this.clp.getLaxPaths());
        if (this.clp.isRollbackSet()) {
            String rollbackProblems;
            String reply = EmPatcherMain.ask("\nDo you want to rollback the modified files [y/n] ? ");
            if (!reply.startsWith("y")) {
                System.out.println("\nCancelling the rollback.");
                System.exit(1);
            }
            if ("".equals(rollbackProblems = this.rollbackModifications())) {
                System.out.println("\nDone.");
                System.exit(0);
            } else {
                System.out.println("ERROR! Problems found while rolling back.");
                System.out.println(rollbackProblems);
                System.exit(1);
            }
        }
        try {
            this.laxFileParser = new LaxFileParser(this.clp, this.foundLaxFiles);
        }
        catch (CacheException e) {
            System.out.println("\nERROR! Could not determine product number and revision for the new launcher.");
            System.exit(1);
        }
        String suggestedModifications = this.laxFileParser.parseLaxFiles();
        System.out.println("\nPreparing for the following modifications:");
        System.out.println(suggestedModifications);
        if (this.clp.isInformationSet()) {
            System.exit(1);
        }
        System.out.println("\n   Modifying LAX files:");
        SortedSet laxFilesToModify = this.laxFileParser.getLaxFiles();
        String reply = "";
        if (this.clp.isForceSet()) {
            reply = "a";
        }
        for (LaxFile laxFile : laxFilesToModify) {
            if (!"a".equals(reply)) {
                reply = EmPatcherMain.ask("\nDo you want to modify " + laxFile.getOriginalFile().getName() + " [ y/n/a] ? ");
            }
            String problems = null;
            if ("y".equals(reply) || "a".equals(reply)) {
                problems = laxFile.modifyFile();
                if (problems == null) {
                    this.modifiedLaxFileSet.add(laxFile);
                    continue;
                }
                System.out.println("\nERROR! Problems encountered while updating LAX files: ");
                System.out.println(problems);
                this.unmodifiedLaxFileSet.add(laxFile);
                continue;
            }
            this.unmodifiedLaxFileSet.add(laxFile);
        }
        if (this.modifiedLaxFileSet.size() > 0) {
            SortedSet targetDirs = this.laxFileParser.getDirsToWriteLauncherTo();
            System.out.println("\n   Writing launcher.jar to " + targetDirs.size() + " dirs : " + targetDirs);
            JarFileWriter jarFileWriter = new JarFileWriter();
            String problems = jarFileWriter.writeLaunchers(targetDirs);
            if (!"".equals(problems)) {
                System.out.println("   ERROR! Problems encountered while updating 'launcher.jar' files: ");
                System.out.println(problems);
                String reply2 = EmPatcherMain.ask("\nContinue anyway [y/n] ? ");
                if (!reply2.startsWith("y")) {
                    System.out.println("\nOK, terminating.");
                    System.exit(1);
                }
            }
        }
        if (this.modifiedLaxFileSet.size() > 0) {
            System.out.println("\n   Committing updates to modified LAX files");
            String problems = this.commitModifications();
            if (!"".equals(problems)) {
                System.out.println("\nERROR! Problems encountered while updating LAX files: ");
                System.out.println(problems);
                EmPatcherMain.ask("\nHit enter to exit : ");
            }
        }
        System.out.println("\nDone!\n");
    }

    private String commitModifications() {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        Iterator files = this.modifiedLaxFileSet.iterator();
        while (files.hasNext()) {
            LaxFile laxFile = null;
            File oldFile = null;
            File newFile = null;
            File bakFile = null;
            try {
                laxFile = (LaxFile)files.next();
                oldFile = laxFile.getOriginalFile();
                newFile = laxFile.getNewFile();
                bakFile = LaxFile.getBakFileFor(oldFile);
                if (bakFile.exists()) {
                    boolean successDelete = this.deleteFile(oldFile);
                    if (!successDelete) {
                        problemLog.nl("   Failed deleting old file '" + oldFile);
                    }
                } else {
                    boolean successRename = this.renameFile(oldFile, bakFile);
                    if (!successRename) {
                        problemLog.nl("   Failed renaming old file to .bak: '" + oldFile);
                    }
                }
                boolean success = newFile.renameTo(oldFile);
                if (success) {
                    this.commitedLaxFileSet.add(oldFile);
                    continue;
                }
                problemLog.nl("   Failed committing file '" + oldFile + "'!");
                this.uncommitedLaxFileSet.add(oldFile);
            }
            catch (Exception e) {
                problemLog.nl("   Failed committing file '" + oldFile + "'!");
                problemLog.nl().print(e.toString());
                this.uncommitedLaxFileSet.add(oldFile);
            }
        }
        return problemLog.toString();
    }

    private String rollbackModifications() {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        Iterator files = this.foundLaxFiles.iterator();
        while (files.hasNext()) {
            Object obj = null;
            File orgFile = null;
            File bakFile = null;
            try {
                obj = files.next();
                orgFile = obj;
                bakFile = LaxFile.getBakFileFor(orgFile);
                if (bakFile.exists()) {
                    MsgBuffer copyProblems = Java14FileCopy.copy(bakFile, orgFile);
                    problemLog.append(copyProblems);
                    continue;
                }
                problemLog.nl().print("Couldn't find backup file '" + bakFile + "'!");
            }
            catch (Exception e) {
                problemLog.nl().print("Failed restoring file '" + obj + "'!");
                problemLog.nl().print(e.toString());
            }
        }
        return problemLog.toString();
    }

    public static void main(String[] args) {
        new EmPatcherMain(args);
    }

    public static String ask(String question) {
        String s;
        System.out.print(question);
        System.out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            s = in.readLine().toLowerCase();
        }
        catch (IOException e) {
            s = "   " + e.toString();
            System.out.println(s);
        }
        return s;
    }

    private boolean renameFile(File fileToRename, File newFile) {
        for (int i = 0; i < 20; ++i) {
            if (fileToRename.renameTo(newFile)) {
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean deleteFile(File fileToDelete) {
        for (int i = 0; i < 20; ++i) {
            if (fileToDelete.delete()) {
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }
}

