/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.empatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import se.ericsson.security.empatcher.MsgBuffer;

public class Java14FileCopy {
    private static boolean okToCopyFiles(File sourceFile, File destFile, MsgBuffer problemLog) {
        boolean result = true;
        if (!sourceFile.exists()) {
            result = false;
            problemLog.nl().print("no such source file: " + sourceFile.getAbsolutePath());
        }
        if (!sourceFile.isFile()) {
            problemLog.nl().print("can not copy a directory: " + sourceFile.getAbsolutePath());
            result = false;
        }
        if (!sourceFile.canRead()) {
            problemLog.nl().print("source file is not readable: " + sourceFile.getAbsolutePath());
            result = false;
        }
        if (!destFile.getParentFile().isDirectory()) {
            problemLog.nl().print("no target directory for target file: " + destFile.getAbsolutePath());
            result = false;
        } else if (!destFile.getParentFile().canWrite()) {
            problemLog.nl().print("the target directory isn't writable for target file: " + destFile.getAbsolutePath());
            result = false;
        }
        if (!destFile.exists()) {
            try {
                destFile.createNewFile();
            }
            catch (IOException e) {
                problemLog.nl().print("could not create: " + destFile.getAbsolutePath());
                result = false;
            }
        }
        if (!destFile.canWrite()) {
            problemLog.nl().print("can not write to destination: " + destFile.getAbsolutePath());
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MsgBuffer copy(File sourceFile, File destFile) {
        MsgBuffer problemLog = new MsgBuffer();
        problemLog.setIndent("      ");
        if (Java14FileCopy.okToCopyFiles(sourceFile, destFile, problemLog)) {
            FileInputStream fromInput = null;
            FileOutputStream toOutput = null;
            try {
                int bytesRead;
                fromInput = new FileInputStream(sourceFile);
                toOutput = new FileOutputStream(destFile);
                byte[] bufferArray = new byte[4096];
                while ((bytesRead = fromInput.read(bufferArray)) != -1) {
                    toOutput.write(bufferArray, 0, bytesRead);
                }
            }
            catch (FileNotFoundException ex) {
                problemLog.nl().print("Could not find the file");
                ex.printStackTrace();
            }
            catch (IOException e) {
                problemLog.nl().print("Could not copy the file " + sourceFile.getAbsolutePath());
                e.printStackTrace();
            }
            finally {
                if (fromInput != null) {
                    try {
                        fromInput.close();
                    }
                    catch (IOException ex) {}
                }
                if (toOutput != null) {
                    try {
                        toOutput.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return problemLog;
    }
}

