/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import se.ericsson.security.launcher.SecurityException;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadManager;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

class SecurityState {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private boolean corbaSecurityIsOn = false;
    private String slsUrls = "";

    public SecurityState() {
        LOG.fine("Creating default securityState with security=OFF", new Object[0]);
        this.corbaSecurityIsOn = false;
    }

    public SecurityState(URL urlData) throws SecurityException {
        DownloadManager dm = new DownloadManager();
        PropertyManager pm = null;
        String path = null;
        Exception cause = null;
        try {
            pm = PropertyManager.getInstance(this.getClass().getClassLoader());
            path = pm.getString("se.ericsson.security.securitystatefile", true);
            URL url = new URL(urlData.getProtocol(), urlData.getHost(), urlData.getPort(), path);
            InputStream is = dm.downloadToInputStream(url);
            Properties props = new Properties();
            props.load(is);
            String stateStr = props.getProperty("CorbaSecurity");
            if (stateStr == null || stateStr.length() == 0) {
                LOG.warning("Assuming that CorbaSecurity=OFF", new Object[0]);
            } else {
                LOG.fine("CorbaSecurity=" + stateStr, new Object[0]);
            }
            props.clear();
            props = null;
            this.corbaSecurityIsOn = "ON".equalsIgnoreCase(stateStr);
            try {
                String slsPath = pm.getString("se.ericsson.security.launcher.sls_address_url", true);
                URL slsURL = new URL(urlData.getProtocol(), urlData.getHost(), urlData.getPort(), slsPath);
                InputStream sls_is = dm.downloadToInputStream(slsURL);
                BufferedReader br = new BufferedReader(new InputStreamReader(sls_is));
                this.slsUrls = br.readLine();
                if (this.slsUrls == null || this.slsUrls.length() == 0) {
                    this.slsUrls = "";
                    if (this.corbaSecurityIsOn) {
                        LOG.warning("SLS is not configured.", new Object[0]);
                    } else {
                        LOG.info("SLS is not configured.", new Object[0]);
                    }
                } else {
                    String sls = pm.getString("ssu.propertyname.slsurls", false);
                    System.setProperty(sls, this.slsUrls);
                    LOG.fine("slsUrls is " + this.slsUrls, new Object[0]);
                }
                return;
            }
            catch (MalformedURLException e) {
                LOG.warning("Cannot get SLS url since URL is malformed: " + e.getMessage(), new Object[0]);
                cause = e;
            }
            catch (IOException e) {
                LOG.warning("SLS urls, IOException: " + e.getMessage(), new Object[0]);
                cause = e;
            }
            catch (DownloadException e) {
                LOG.warning("Download exception: " + e.getMessage(), new Object[0]);
                cause = e;
            }
            if (this.corbaSecurityIsOn) {
                throw new SecurityException("Cannot get SLS urls from secure NE", (Throwable)cause);
            }
        }
        catch (MalformedURLException e) {
            LOG.warning("Cannot get securitystate since URL is malformed: " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            LOG.warning("IOException: " + e.getMessage(), new Object[0]);
        }
        catch (DownloadException e) {
            LOG.warning("Download exception: " + e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            String msg = "Unexpected Exception while constructructiong SecurityState!\n   URL  = \"" + urlData + "\"" + "\n   path = \"" + path + "\"" + "\n   props=\n" + pm;
            LOG.warning(msg, e);
            throw new SecurityException(msg, (Throwable)e);
        }
        this.corbaSecurityIsOn = false;
    }

    public boolean isSecurityEnabled() {
        return this.corbaSecurityIsOn;
    }

    public String getSLSUrls() {
        return this.slsUrls;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SecurityState)) {
            return false;
        }
        SecurityState s = (SecurityState)obj;
        if (s.isSecurityEnabled() != this.isSecurityEnabled()) {
            LOG.fine("state does not match", new Object[0]);
            return false;
        }
        if (!s.getSLSUrls().equals(this.getSLSUrls())) {
            LOG.warning("SLS urls do not match", new Object[0]);
        }
        return true;
    }
}

