/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.testmode;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import se.ericsson.security.launcher.ApplicationClassLoader;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.testmode.TmException;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmStarterInterface;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.CliArguments;
import se.ericsson.security.utils.EmLogger;

public class TmUtilitiesExt {
    private static final Class<?> THIS = TmUtilitiesExt.class;
    private static final EmLogger LOG = EmLogger.STARTER;
    private static final String STUB_STARTER = "se.ericsson.cello.mibparser.starter.StubStarter";

    public static void startStubbedWebServer() throws Exception {
        final EProps ep = new EProps();
        ep.put(EKEY.JAVA_METHOD, "TmUtilitiesExt.startStubbedWebServer");
        ep.append(EKEY.JAVA_METHOD, "cliArgProps      = " + CliArguments.CLI_ARGUMENTS.getProperties());
        ep.append(EKEY.JAVA_METHOD, "thread         = " + Thread.currentThread());
        ep.append(EKEY.JAVA_METHOD, "THIS           = " + THIS.getName());
        ep.append(EKEY.JAVA_METHOD, "classloader    = " + THIS.getClassLoader());
        ep.append(EKEY.JAVA_METHOD, "cl.parent      = " + THIS.getClassLoader().getParent());
        ep.append(EKEY.JAVA_METHOD, "TmProperty     = " + TmProperty.toStringAll());
        if (!TmProperty.HTTP_ROOT.isSet() || !TmProperty.SEMLA.isSet()) {
            LOG.finest("STRANGE. startStubbedWebServer called, but relevant TmProperties not set.", new TmException("", ep, null));
            return;
        }
        Thread webStarter = new Thread("StubbedWebServerStarter"){
            final String httpRoot;
            final ClassLoader parentClassLoader;
            final URL[] semlaJarUrl;
            final ClassLoader classloader;
            {
                super(x0);
                this.httpRoot = TmProperty.HTTP_ROOT.getValue();
                this.parentClassLoader = Thread.currentThread().getContextClassLoader();
                this.semlaJarUrl = TmUtilities.getSemlaUrlArray();
                this.classloader = new ApplicationClassLoader("StubedWebStarter", this.semlaJarUrl, this.parentClassLoader, (ClassLoader)null);
            }

            public void run() {
                try {
                    this.setContextClassLoader(this.classloader);
                    ClassLoader classloader = this.getContextClassLoader();
                    Class<?> clazz = Class.forName(TmUtilitiesExt.STUB_STARTER, true, classloader);
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("startStubbedWebServer", new Class[0]);
                    method.invoke(obj, new Object[0]);
                    this.setContextClassLoader(this.parentClassLoader);
                }
                catch (Exception e) {
                    String error = "Failed starting stubbed web server!";
                    ep.put(EKEY.PROBLEM_USER_LEVEL, "Unexpected error in EMAS (rellated to LauncherTestMode) detected at startup");
                    ep.put(EKEY.JAVA_PROBLEM, "TmUtilities failed to start the NanoHTTPD WebServer.");
                    ep.append(EKEY.JAVA_PROBLEM, "Used classloader : " + this.classloader);
                    TmException tme = new TmException(error, ep, e);
                    LOG.severe(TmUtilities.getLogMessage(error), tme);
                    throw tme;
                }
                LOG.finest(TmUtilities.getLogMessage("StubbedWebServer started for HTTP_ROOT=" + this.httpRoot), new Object[0]);
            }
        };
        webStarter.start();
        webStarter.join();
        LOG.finest(TmUtilities.getLogMessage("StubbedWebServer start completed - back to main thread."), new Object[0]);
    }

    public static TmStarterInterface findStubStarter(URLClassLoader commonCL) {
        EProps ep = new EProps();
        ep.put(EKEY.ENV_TESTMODE_CFG, TmProperty.toStringAll());
        ep.put(EKEY.JAVA_METHOD, "findStubStarter");
        ep.put(EKEY.JAVA_PARAMS, "Common classLoader=" + commonCL);
        TmStarterInterface stubStarterInstance = TmUtilities.getStubStarter();
        if (stubStarterInstance != null) {
            return stubStarterInstance;
        }
        try {
            stubStarterInstance = TmUtilitiesExt.newStubStarter(commonCL);
            TmUtilities.setStubStarter(stubStarterInstance);
            return stubStarterInstance;
        }
        catch (Throwable e) {
            if (TmProperty.SEMLA.isSet()) {
                String error = "Failed entering LauncherTestMode!";
                ep.put(EKEY.JAVA_PROBLEM, "ApplicationClassLoader failed to load StubStarter from SEMLA jar!");
                ep.put(EKEY.PROBLEM_USER_LEVEL, "Unexpected error in EMAS (rellated to LauncherTestMode) detected at startup");
                TmException tme = new TmException(error, ep, e);
                LOG.severe(TmUtilities.getLogMessage(error), tme);
                throw tme;
            }
            LOG.finest(TmUtilities.getLogMessage("StubStarter not yet present on class path (" + e.getMessage() + ")."), new Object[0]);
            return null;
        }
    }

    private static TmStarterInterface newStubStarter(ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(STUB_STARTER, false, classLoader);
        Object obj = clazz.newInstance();
        TmStarterInterface stubStarter = (TmStarterInterface)obj;
        LOG.finest(TmUtilities.getLogMessage("StubStarter present on class path."), new Object[0]);
        return stubStarter;
    }
}

