/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.commandlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.commandlog.ActionCmd;
import se.ericsson.cello.commandlog.CMD;
import se.ericsson.cello.commandlog.CmdFileMgr;
import se.ericsson.cello.commandlog.CreateCmd;
import se.ericsson.cello.commandlog.DeleteCmd;
import se.ericsson.cello.commandlog.SetCmd;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class AuditLogWriter {
    private static AuditLogWriter instanceOfAuditLogWriter;
    private CmdFileMgr filemanager = CmdFileMgr.instance();
    private Map objectMap = new HashMap();

    private AuditLogWriter() {
    }

    public static synchronized AuditLogWriter instance() {
        if (instanceOfAuditLogWriter == null) {
            instanceOfAuditLogWriter = new AuditLogWriter();
        }
        return instanceOfAuditLogWriter;
    }

    public synchronized void addResource(Coordinator coordinator) {
        int n;
        if (coordinator != null && !this.objectMap.containsKey(new Integer(n = coordinator.getTransactionID()))) {
            try {
                CommandTxResource commandTxResource = new CommandTxResource(new Integer(n));
                coordinator.registerResource((Resource)commandTxResource);
                this.objectMap.put(new Integer(n), commandTxResource);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.trace((int)5, this.getClass(), (String)("Register CommandTxResource failed: " + inactiveTransactionException.toString()));
            }
        }
    }

    public synchronized void removeObjectMapElement(Integer n) {
        this.objectMap.remove(n);
    }

    public synchronized void addCreateCmd(String string, String string2, AttrList attrList, String string3, String string4, Coordinator coordinator, String string5) {
        try {
            CreateCmd createCmd = new CreateCmd(string, string2, attrList, string3, string4, string5);
            this.addCommand(coordinator, createCmd);
        }
        catch (Throwable throwable) {
            MessageLog.trace((int)5, this.getClass(), (String)("Failed: " + throwable.toString()));
        }
    }

    public synchronized void addDeleteCmd(String string, String string2, Coordinator coordinator, String string3) {
        try {
            DeleteCmd deleteCmd = new DeleteCmd(string, string2, string3);
            this.addCommand(coordinator, deleteCmd);
        }
        catch (Throwable throwable) {
            MessageLog.trace((int)5, this.getClass(), (String)("Failed: " + throwable.toString()));
        }
    }

    public synchronized void addSetCmd(String string, AttrList attrList, String string2, Coordinator coordinator, String string3) {
        try {
            SetCmd setCmd = new SetCmd(string, attrList, string2, string3);
            this.addCommand(coordinator, setCmd);
        }
        catch (Throwable throwable) {
            MessageLog.trace((int)5, this.getClass(), (String)("Failed: " + throwable.toString()));
        }
    }

    public synchronized void addActionCmd(String string, Object[] objectArray, String string2, String string3, Object object, Coordinator coordinator, String string4) {
        try {
            ActionCmd actionCmd = new ActionCmd(string, objectArray, string2, string3, object, string4);
            this.addCommand(coordinator, actionCmd);
        }
        catch (Throwable throwable) {
            MessageLog.trace((int)5, this.getClass(), (String)("Failed: " + throwable.toString()));
        }
    }

    private synchronized void write(CMD cMD) {
        try {
            this.filemanager.addDataToFile(cMD);
        }
        catch (Throwable throwable) {
            MessageLog.trace((int)5, this.getClass(), (String)("Failed: " + throwable.toString()));
        }
    }

    private synchronized void addCommand(Coordinator coordinator, CMD cMD) {
        if (coordinator != null) {
            CommandTxResource commandTxResource = (CommandTxResource)this.objectMap.get(new Integer(coordinator.getTransactionID()));
            if (commandTxResource != null) {
                commandTxResource.addCommandData(new Integer(coordinator.getTransactionID()), cMD);
            } else {
                this.write(cMD);
            }
        } else {
            this.write(cMD);
        }
    }

    private class CommandTxResource
    implements Resource {
        List commandData = Collections.synchronizedList(new ArrayList());
        Iterator itr;
        Integer transactionId;
        CMD lastOperation = null;
        boolean inProgress = false;

        public CommandTxResource(Integer n) {
            this.transactionId = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCommandData(Integer n, CMD cMD) {
            if (this.inProgress) {
                this.lastOperation = cMD;
            } else {
                List list = this.commandData;
                synchronized (list) {
                    this.commandData.add(cMD);
                }
            }
        }

        public boolean prepare() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            this.inProgress = true;
            List list = this.commandData;
            synchronized (list) {
                this.itr = this.commandData.iterator();
                while (this.itr.hasNext()) {
                    CMD cMD = (CMD)this.itr.next();
                    if (cMD.exception == null) {
                        cMD.exception = "Transaction Rolled Back";
                    }
                    AuditLogWriter.this.write(cMD);
                }
                this.commandData.clear();
                if (this.lastOperation != null) {
                    AuditLogWriter.this.write(this.lastOperation);
                }
            }
            AuditLogWriter.this.removeObjectMapElement(this.transactionId);
            this.inProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            List list = this.commandData;
            synchronized (list) {
                this.itr = this.commandData.iterator();
                while (this.itr.hasNext()) {
                    AuditLogWriter.this.write((CMD)this.itr.next());
                }
                this.commandData.clear();
            }
            AuditLogWriter.this.removeObjectMapElement(this.transactionId);
        }
    }
}

