/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.Session;
import ConfigExtended.MIBChangeInfo;
import ConfigExtended.NotificationConsumer;
import ConfigExtended.NotificationProducer;
import ConfigExtended.NotificationProducerHelper;
import ConfigExtended.NotificationProducerPOA;
import ConfigExtended.NotificationProducerPackage.InvalidFilterConstraintsException;
import ConfigExtended.NotificationProducerPackage.NoTransactionException;
import ConfigExtended.NotificationProducerPackage.NotificationFilter;
import ConfigExtended.NotificationProducerPackage.NotificationFilterExt;
import ConfigExtended.NotificationProducerPackage.ToOldGenerationCount;
import org.omg.CORBA.IntHolder;
import se.ericsson.cello.configirpimpl.SessionImpl;
import se.ericsson.cello.csnotification.NotificationReporter;
import se.ericsson.cello.csnotification.SubscriptionMgr;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class NotificationProducerImpl
extends NotificationProducerPOA {
    private static final int SUPPORT_AVC = 1;
    private static final int SUPPORT_SDN = 0;
    private static NotificationProducerImpl theOneAndOnly;
    static final String serviceId = "NotificationProducer";

    public static synchronized NotificationProducerImpl instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new NotificationProducerImpl();
            CelloOrb.instance().connect(serviceId, theOneAndOnly);
        }
        return theOneAndOnly;
    }

    public void reinit() {
        if (theOneAndOnly != null) {
            CelloOrb.instance().connect(serviceId, theOneAndOnly);
        }
    }

    private NotificationProducerImpl() {
    }

    NotificationProducer getNotificationProducerRef() {
        return NotificationProducerHelper.narrow(CelloOrb.instance().addressDependentServantToReference(this));
    }

    public static void restoreSubscriptions() {
        SubscriptionMgr.restoreSubscriptions();
    }

    public void subscribe(NotificationConsumer notificationConsumer, NotificationFilter notificationFilter, int n, IntHolder intHolder) throws InvalidFilterConstraintsException {
        try {
            int n2;
            intHolder.value = n2 = SubscriptionMgr.startSubscription(notificationConsumer, SubscriptionMgr.convertToNewFilter(notificationFilter), n, 1);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe: ", (Throwable)error);
            throw error;
        }
    }

    public void subscribe_ext(NotificationConsumer notificationConsumer, NotificationFilterExt notificationFilterExt, int n, IntHolder intHolder) throws InvalidFilterConstraintsException {
        try {
            int n2;
            intHolder.value = n2 = SubscriptionMgr.startSubscription(notificationConsumer, notificationFilterExt, n, 1);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe_ext: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe_ext: ", (Throwable)error);
            throw error;
        }
    }

    public void subscribe_ext_v2(NotificationConsumer notificationConsumer, NotificationFilterExt notificationFilterExt, int n, IntHolder intHolder) throws InvalidFilterConstraintsException {
        try {
            int n2;
            intHolder.value = n2 = SubscriptionMgr.startSubscription(notificationConsumer, notificationFilterExt, n, 0);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe_ext: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"subscribe_ext: ", (Throwable)error);
            throw error;
        }
    }

    public void unsubscribe(int n) {
        try {
            SubscriptionMgr.terminateSubscription(n);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"unsubscribe: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"unsubscribe: ", (Throwable)error);
            throw error;
        }
    }

    public boolean get_subscription_status(int n) {
        try {
            return SubscriptionMgr.isSubscriptionActive(n);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"get_subscription_status: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"get_subscription_status: ", (Throwable)error);
            throw error;
        }
    }

    public void disable_notifications_for_transaction(int n, Session session) throws NoTransactionException {
        try {
            if (session == null) {
                throw new NoTransactionException();
            }
            Coordinator coordinator = ((SessionImpl)CelloOrb.instance().reference_to_servant(session)).getCoordinator();
            if (coordinator == null) {
                throw new NoTransactionException();
            }
            SubscriptionMgr.excludeTx(n, coordinator);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"disable_notifications_for_transaction: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"disable_notifications_for_transaction: ", (Throwable)error);
            throw error;
        }
    }

    public int get_generation_count() {
        return NotificationReporter.getGenerationCount();
    }

    public MIBChangeInfo[] get_MIB_changes(int n) throws ToOldGenerationCount {
        try {
            return NotificationReporter.getMIBChanges(n);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"get_MIB_changes: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError((Class)NotificationProducerImpl.class, (String)"get_MIB_changes: ", (Throwable)error);
            throw error;
        }
    }
}

