/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import java.util.GregorianCalendar;
import org.omg.CORBA.Any;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.AlarmEventLogHelper;
import se.ericsson.cello.faultmanagement.AlarmIRP_1Impl;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;

public class Event {
    private StructuredEvent event;
    private static final int NR_OF_DEFAULT_PROPERTIES = 7;
    private static final int CONVERT_MS_TO_100NS = 10000;
    private static final int EVENT_LOG_SIZE = 500000;
    private static final int MILLISEC = 1000;
    private static final int SEC = 60;
    private static final String SEPARATOR = ";";
    private static final String EMPTY_STRING = "";
    private static final String EVENT_LOG = "EVENT_LOG";
    private static final String EVENT_LOG_PATH = "alarm_event";
    private static AlarmEventLogHelper logHelper = new AlarmEventLogHelper("EVENT_LOG", 500000, "alarm_event");

    public Event(String string, String string2, String string3, String string4, String string5, String string6, AdditionalInfo[] additionalInfoArray) {
        Any any;
        EventHeader eventHeader;
        Object object;
        GregorianCalendar gregorianCalendar;
        String string7 = MibMgr.instance().getMib().getMibPrefix();
        int n = 0;
        short s = 0;
        StringBuffer stringBuffer = new StringBuffer("1z1");
        string = this.checkAndReplaceNullString(string);
        string2 = this.checkAndReplaceNullString(string2);
        string3 = this.checkAndReplaceNullString(string3);
        string4 = this.checkAndReplaceNullString(string4);
        string5 = this.checkAndReplaceNullString(string5);
        string6 = this.checkAndReplaceNullString(string6);
        if (string4 != null && string4.length() != 0) {
            try {
                int n2 = Integer.parseInt(string4.substring(0, 4));
                int n3 = Integer.parseInt(string4.substring(4, 6));
                int n4 = Integer.parseInt(string4.substring(6, 8));
                int n5 = Integer.parseInt(string4.substring(8, 10));
                int n6 = Integer.parseInt(string4.substring(10, 12));
                int n7 = Integer.parseInt(string4.substring(12, 14));
                gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            }
            catch (NumberFormatException numberFormatException) {
                MessageLog.traceError((Class)Event.class, (String)"Invalid Event Time parameters in Event", (Throwable)numberFormatException);
                gregorianCalendar = new GregorianCalendar();
            }
        } else {
            gregorianCalendar = new GregorianCalendar();
        }
        short s2 = (short)(gregorianCalendar.get(15) / 60000);
        int n8 = NotificationIRPImpl.instance().getNotificationId();
        long l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
        UtcT utcT = new UtcT(l, 0, s, s2);
        this.event = new StructuredEvent();
        this.event.filterable_data = additionalInfoArray != null ? new Property[7 + additionalInfoArray.length] : new Property[7];
        Any any2 = CelloOrb.instance().create_any();
        any2.insert_string(string);
        this.event.filterable_data[n++] = new Property("e", any2);
        Any any3 = CelloOrb.instance().create_any();
        any3.insert_string(string2);
        this.event.filterable_data[n++] = new Property("f", any3);
        Any any4 = CelloOrb.instance().create_any();
        any4.insert_long(n8);
        this.event.filterable_data[n++] = new Property("a", any4);
        Any any5 = CelloOrb.instance().create_any();
        UtcTHelper.insert(any5, utcT);
        this.event.filterable_data[n++] = new Property("c", any5);
        Any any6 = CelloOrb.instance().create_any();
        any6.insert_string(string7);
        this.event.filterable_data[n++] = new Property("d", any6);
        Any any7 = CelloOrb.instance().create_any();
        any7.insert_string(string5);
        this.event.filterable_data[n++] = new Property("z", any7);
        Any any8 = CelloOrb.instance().create_any();
        any8.insert_string(string6);
        this.event.filterable_data[n++] = new Property("j", any8);
        if (additionalInfoArray != null) {
            object = new Any[additionalInfoArray.length];
            for (int i = 0; i < additionalInfoArray.length; ++i) {
                object[i] = CelloOrb.instance().create_any();
                object[i].insert_string(additionalInfoArray[i].getValue());
                this.event.filterable_data[n++] = new Property(additionalInfoArray[i].getName(), object[i]);
            }
        }
        object = new EventType("1z1", string3);
        FixedEventHeader fixedEventHeader = new FixedEventHeader((EventType)object, "z1");
        this.event.header = eventHeader = new EventHeader(fixedEventHeader, new Property[0]);
        this.event.remainder_of_body = any = CelloOrb.instance().create_any();
        AlarmIRP_1Impl.instance().notifyAlarm(this.event);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string3);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append("z1");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string2);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(n8);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(utcT.time);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string7);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string5);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(string6);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(utcT.tdf);
        stringBuffer.append(SEPARATOR);
        if (additionalInfoArray != null) {
            stringBuffer.append(additionalInfoArray.length);
            stringBuffer.append(SEPARATOR);
            for (int i = 0; i < additionalInfoArray.length; ++i) {
                stringBuffer.append(additionalInfoArray[i].getName());
                stringBuffer.append(SEPARATOR);
                stringBuffer.append(additionalInfoArray[i].getValue());
                stringBuffer.append(SEPARATOR);
            }
        } else {
            stringBuffer.append("0");
            stringBuffer.append(SEPARATOR);
        }
        if (!Alarm.getSilentFmMode()) {
            logHelper.enqueue(stringBuffer.toString());
        }
    }

    static void createEventLog() {
        try {
            logHelper.lookupLogRef();
        }
        catch (LogInternalErrorException logInternalErrorException) {
            MessageLog.info((Class)Event.class, (String)("Failed to create/find the event log due to " + logInternalErrorException.getMessage() + ", another try is done later. "));
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)Event.class, (String)"Creating/finding the event log failed.", (Throwable)exception);
        }
    }

    private String checkAndReplaceNullString(String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        return string;
    }
}

