/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.csnotifications;

import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.NotificationElement;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber_v2;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscription;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.BlockingQueue;

public class TopologyAndAVCDistributor
extends Thread {
    private TopologyAndAVCSubscription subscription;
    private CSNotificationSubscriber subscriber;
    private static int counter = 1;
    private boolean deleted;

    public TopologyAndAVCDistributor(TopologyAndAVCSubscription topologyAndAVCSubscription, CSNotificationSubscriber cSNotificationSubscriber) {
        this.subscription = topologyAndAVCSubscription;
        this.subscriber = cSNotificationSubscriber;
        this.setName("TopologyAndAVCDistributor_" + counter++);
    }

    public void run() {
        try {
            while (!this.deleted) {
                NotificationElement notificationElement = this.subscription.dequeue();
                this.pushToSubscriber(notificationElement);
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            MessageLog.trace((int)5, this.getClass(), (String)"The subscription is terminated, and can not be notified");
        }
    }

    private void pushToSubscriber(NotificationElement notificationElement) {
        if (this.subscriber instanceof TopologyAndAVCSubscriber) {
            TopologyAndAVCSubscriber topologyAndAVCSubscriber = (TopologyAndAVCSubscriber)this.subscriber;
            MessageLog.trace((int)5, this.getClass(), (String)"Notifies Subscriber");
            switch (notificationElement.getNotificationType()) {
                case 2: {
                    topologyAndAVCSubscriber.moCreated(notificationElement.getLdn());
                    break;
                }
                case 1: {
                    topologyAndAVCSubscriber.moDeleted(notificationElement.getLdn());
                    break;
                }
                case 3: {
                    topologyAndAVCSubscriber.moChanged(notificationElement.getLdn(), notificationElement.getAttributeValues());
                    break;
                }
                case 5: {
                    if (!(topologyAndAVCSubscriber instanceof TopologyAndAVCSubscriber_v2)) break;
                    ((TopologyAndAVCSubscriber_v2)topologyAndAVCSubscriber).moChanged(notificationElement.getLdn(), notificationElement.getAttributes(), notificationElement.getDiff());
                    break;
                }
            }
        }
    }

    public void stopSubscription() {
        this.deleted = true;
    }
}

