/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasurementStatus;
import se.ericsson.cello.pms.generic.PmReporterPushXmlMgr;
import se.ericsson.cello.pms.generic.ValueContainer;
import se.ericsson.cello.pms.generic.ValueContainerUpdatable;
import se.ericsson.cello.pms.ne.NEInfoSupplier;
import se.ericsson.cello.pms.ne.NESupplier;
import se.ericsson.cello.support.util.XmlHelper;

public class MeasuredData {
    private static final int MAX_LOGGED_PUSHING_MOS = 40;
    public static final int SUSPECT_NULL_VALUE = -1;
    public static final int NON_SUSPECT_NULL_VALUE = -2;
    protected MeasurementStatus measurementStatus = MeasurementStatus.UNAVAILABLE;
    protected String[] attributes;
    protected Hashtable measuredValues = new Hashtable();

    public MeasuredData(String[] stringArray) {
        this.attributes = stringArray;
    }

    protected void setAttributes(String[] stringArray) {
        this.attributes = stringArray;
    }

    public MeasuredData(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        if (stringArray2 != null) {
            n2 = stringArray2.length;
        }
        this.attributes = new String[n + n2];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, this.attributes, n3, n);
            n3 = n;
        }
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, this.attributes, n3, n2);
        }
    }

    void appendNeId(StringBuffer stringBuffer) {
        stringBuffer.append("<neid>\n");
        stringBuffer.append("<neun>" + this.getNeun() + "</neun>\n");
        stringBuffer.append("<nedn>" + this.getNedn() + "</nedn>\n");
        stringBuffer.append("<nesw>" + this.getNesw() + "</nesw>\n");
        stringBuffer.append("</neid>\n");
    }

    void appendMtsGp(PrintWriter printWriter, String string, GranularityPeriod granularityPeriod) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMtsGp(stringBuffer, string, granularityPeriod);
        printWriter.write(stringBuffer.toString());
    }

    void appendAttributes(PrintWriter printWriter) {
        for (int i = 0; i < this.attributes.length; ++i) {
            printWriter.write("<mt>");
            printWriter.write(this.attributes[i]);
            printWriter.write("</mt>\n");
        }
    }

    void appendValues(PrintWriter printWriter) {
        Enumeration enumeration = this.measuredValues.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            ValueContainer valueContainer = (ValueContainer)enumeration.nextElement();
            printWriter.write("<mv>\n");
            printWriter.write("<moid>");
            printWriter.write(XmlHelper.encodeXml(valueContainer.getMoId()));
            printWriter.write("</moid>\n");
            long[] lArray = valueContainer.getLongValues();
            for (int i = 0; i < lArray.length; ++i) {
                printWriter.write("<r>");
                if (lArray[i] == -1L) {
                    bl = true;
                } else if (lArray[i] != -2L) {
                    printWriter.write(Long.toString(lArray[i]));
                }
                printWriter.write("</r>\n");
            }
            Object[] objectArray = valueContainer.getObjectValues();
            for (int i = 0; i < objectArray.length; ++i) {
                printWriter.write("<r>");
                if (objectArray[i] != null) {
                    int n;
                    Object[] objectArray2;
                    if (objectArray[i] instanceof Integer) {
                        if ((Integer)objectArray[i] == -1) {
                            bl = true;
                        } else if ((Integer)objectArray[i] != -2) {
                            printWriter.write(Integer.toString((Integer)objectArray[i]));
                        }
                    } else if (objectArray[i] instanceof Long) {
                        if ((Long)objectArray[i] == -1L) {
                            bl = true;
                        } else if ((Long)objectArray[i] != -2L) {
                            printWriter.write(Long.toString((Long)objectArray[i]));
                        }
                    } else if (objectArray[i] instanceof int[]) {
                        objectArray2 = (int[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            if (objectArray2[n] == -1) {
                                bl = true;
                            } else if (objectArray2[n] != -2) {
                                printWriter.write(Integer.toString(objectArray2[n]));
                            }
                            if (n + 1 >= objectArray2.length) continue;
                            printWriter.write(",");
                        }
                    } else if (objectArray[i] instanceof long[]) {
                        objectArray2 = (long[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            if (objectArray2[n] == -1L) {
                                bl = true;
                            } else if (objectArray2[n] != -2L) {
                                printWriter.write(Long.toString(objectArray2[n]));
                            }
                            if (n + 1 >= objectArray2.length) continue;
                            printWriter.write(",");
                        }
                    } else if (objectArray[i] instanceof String) {
                        printWriter.write(XmlHelper.encodeXml((String)objectArray[i]));
                    } else if (objectArray[i] instanceof ManagedObject) {
                        printWriter.write(((ManagedObject)objectArray[i]).getLocalDistinguishedName());
                    } else if (objectArray[i] instanceof ManagedObject[]) {
                        objectArray2 = (ManagedObject[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            printWriter.write(objectArray2[n].getLocalDistinguishedName());
                            if (n + 1 >= objectArray2.length) continue;
                            printWriter.write(", ");
                        }
                    } else if (objectArray[i] instanceof Object) {
                        printWriter.write(objectArray[i].toString());
                    } else {
                        bl = true;
                    }
                }
                printWriter.write("</r>\n");
            }
            if (valueContainer.getSuspectFlag() || bl) {
                printWriter.write("<sf>TRUE</sf>\n");
            }
            printWriter.write("</mv>\n");
        }
    }

    void printXml(PrintWriter printWriter, String string, GranularityPeriod granularityPeriod) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<md>\n");
        this.appendNeId(stringBuffer);
        stringBuffer.append("<mi>\n");
        printWriter.write(stringBuffer.toString());
        this.appendMtsGp(printWriter, string, granularityPeriod);
        this.appendAttributes(printWriter);
        this.appendValues(printWriter);
        printWriter.write("</mi>\n");
        printWriter.write("</md>\n");
    }

    void pushXml(String string, GranularityPeriod granularityPeriod) {
        PmReporterPushXmlMgr.getInstance().pushXml(granularityPeriod.inSeconds(), this.getXml(string, granularityPeriod));
    }

    private String getXml(String string, GranularityPeriod granularityPeriod) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<md>\n");
        this.appendNeId(stringBuffer);
        stringBuffer.append("<mi>\n");
        this.appendMtsGp(stringBuffer, string, granularityPeriod);
        this.appendAttributes(stringBuffer);
        this.appendValues(stringBuffer);
        stringBuffer.append("</mi>\n");
        stringBuffer.append("</md>\n");
        return stringBuffer.toString();
    }

    void appendMtsGp(StringBuffer stringBuffer, String string, GranularityPeriod granularityPeriod) {
        stringBuffer.append("<mts>");
        stringBuffer.append(string + "Z");
        stringBuffer.append("</mts>\n");
        stringBuffer.append("<gp>");
        stringBuffer.append(granularityPeriod.inSeconds());
        stringBuffer.append("</gp>\n");
    }

    void appendAttributes(StringBuffer stringBuffer) {
        for (int i = 0; i < this.attributes.length; ++i) {
            stringBuffer.append("<mt>");
            stringBuffer.append(this.attributes[i]);
            stringBuffer.append("</mt>\n");
        }
    }

    void appendValues(StringBuffer stringBuffer) {
        Enumeration enumeration = this.measuredValues.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            ValueContainer valueContainer = (ValueContainer)enumeration.nextElement();
            stringBuffer.append("<mv>\n");
            stringBuffer.append("<moid>");
            stringBuffer.append(XmlHelper.encodeXml(valueContainer.getMoId()));
            stringBuffer.append("</moid>\n");
            long[] lArray = valueContainer.getLongValues();
            for (int i = 0; i < lArray.length; ++i) {
                stringBuffer.append("<r>");
                if (lArray[i] == -1L) {
                    bl = true;
                } else if (lArray[i] != -2L) {
                    stringBuffer.append(Long.toString(lArray[i]));
                }
                stringBuffer.append("</r>\n");
            }
            Object[] objectArray = valueContainer.getObjectValues();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("<r>");
                if (objectArray[i] != null) {
                    int n;
                    Object[] objectArray2;
                    if (objectArray[i] instanceof Integer) {
                        if ((Integer)objectArray[i] == -1) {
                            bl = true;
                        } else if ((Integer)objectArray[i] != -2) {
                            stringBuffer.append(Integer.toString((Integer)objectArray[i]));
                        }
                    } else if (objectArray[i] instanceof Long) {
                        if ((Long)objectArray[i] == -1L) {
                            bl = true;
                        } else if ((Long)objectArray[i] != -2L) {
                            stringBuffer.append(Long.toString((Long)objectArray[i]));
                        }
                    } else if (objectArray[i] instanceof int[]) {
                        objectArray2 = (int[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            if (objectArray2[n] == -1) {
                                bl = true;
                            } else if (objectArray2[n] != -2) {
                                stringBuffer.append(Integer.toString(objectArray2[n]));
                            }
                            if (n + 1 >= objectArray2.length) continue;
                            stringBuffer.append(",");
                        }
                    } else if (objectArray[i] instanceof long[]) {
                        objectArray2 = (long[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            if (objectArray2[n] == -1L) {
                                bl = true;
                            } else if (objectArray2[n] != -2L) {
                                stringBuffer.append(Long.toString(objectArray2[n]));
                            }
                            if (n + 1 >= objectArray2.length) continue;
                            stringBuffer.append(",");
                        }
                    } else if (objectArray[i] instanceof String) {
                        stringBuffer.append(XmlHelper.encodeXml((String)objectArray[i]));
                    } else if (objectArray[i] instanceof ManagedObject) {
                        stringBuffer.append(((ManagedObject)objectArray[i]).getLocalDistinguishedName());
                    } else if (objectArray[i] instanceof ManagedObject[]) {
                        objectArray2 = (ManagedObject[])objectArray[i];
                        for (n = 0; n < objectArray2.length; ++n) {
                            stringBuffer.append(objectArray2[n].getLocalDistinguishedName());
                            if (n + 1 >= objectArray2.length) continue;
                            stringBuffer.append(", ");
                        }
                    } else if (objectArray[i] instanceof Object) {
                        stringBuffer.append(objectArray[i].toString());
                    } else {
                        bl = true;
                    }
                }
                stringBuffer.append("</r>\n");
            }
            if (valueContainer.getSuspectFlag() || bl) {
                stringBuffer.append("<sf>TRUE</sf>\n");
            }
            stringBuffer.append("</mv>\n");
        }
    }

    boolean isSampled(String string) {
        return this.measuredValues.containsKey(string);
    }

    protected void getMoIds(StringBuffer stringBuffer) {
        Enumeration enumeration = this.measuredValues.elements();
        for (int i = 0; enumeration.hasMoreElements() && i < 40; ++i) {
            ValueContainer valueContainer = (ValueContainer)enumeration.nextElement();
            stringBuffer.append(valueContainer.getMoId());
            stringBuffer.append(" ");
        }
    }

    protected String getFirstMoId() {
        Enumeration enumeration = this.measuredValues.elements();
        if (enumeration.hasMoreElements()) {
            ValueContainer valueContainer = (ValueContainer)enumeration.nextElement();
            return valueContainer.getMoId();
        }
        return "";
    }

    private String getNeun() {
        NEInfoSupplier nEInfoSupplier = NESupplier.instance().getNE();
        if (nEInfoSupplier != null) {
            return nEInfoSupplier.getUserName();
        }
        return "";
    }

    private String getNedn() {
        if (MibMgr.instance().getMib() == null) {
            return "";
        }
        return MibMgr.instance().getMib().getMibPrefix();
    }

    private String getNesw() {
        NEInfoSupplier nEInfoSupplier = NESupplier.instance().getNE();
        if (nEInfoSupplier != null) {
            return nEInfoSupplier.getSoftwareVersion();
        }
        return "";
    }

    MeasurementStatus status() {
        return this.measurementStatus;
    }

    static class ReusableValueContainer
    implements ValueContainerUpdatable {
        private String moId;
        private long[] longValues;
        private Object[] objValues;
        private boolean suspectFlag = false;
        private static Object[] emptyObjValues = new Object[0];
        private static long[] emptyLongValues = new long[0];

        ReusableValueContainer(String string, int n, int n2) {
            this.longValues = n > 0 ? new long[n] : emptyLongValues;
            this.objValues = n2 > 0 ? new Object[n2] : emptyObjValues;
            this.moId = string;
        }

        public void setObjectValues(Object[] objectArray) throws IllegalArgumentException {
            if (objectArray == null || objectArray.length != this.objValues.length) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(objectArray, 0, this.objValues, 0, objectArray.length);
        }

        public void setIntValues(int[] nArray) throws IllegalArgumentException {
            if (nArray == null || nArray.length != this.longValues.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.longValues[i] = nArray[i];
            }
        }

        public void setLongValues(long[] lArray) throws IllegalArgumentException {
            if (lArray == null || lArray.length != this.longValues.length) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(lArray, 0, this.longValues, 0, lArray.length);
        }

        public void setSuspectFlag(boolean bl) {
            this.suspectFlag = bl;
        }

        public String getMoId() {
            return this.moId;
        }

        public Object[] getObjectValues() {
            return this.objValues;
        }

        public int[] getIntValues() {
            int[] nArray = new int[this.longValues.length];
            for (int i = 0; i < this.longValues.length; ++i) {
                nArray[i] = (int)this.longValues[i];
            }
            return nArray;
        }

        public long[] getLongValues() {
            return this.longValues;
        }

        public boolean getSuspectFlag() {
            return this.suspectFlag;
        }
    }

    static class FixedValueContainer
    implements ValueContainer {
        private String moId;
        private long[] longValues;
        private Object[] objValues;
        private boolean suspectFlag = false;

        FixedValueContainer(String string, Object[] objectArray, boolean bl) {
            this.moId = string;
            this.longValues = new long[0];
            this.objValues = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.objValues[i] = objectArray[i];
            }
            this.suspectFlag = bl;
        }

        FixedValueContainer(String string, int[] nArray, Object[] objectArray, boolean bl) {
            int n;
            this.moId = string;
            if (nArray != null) {
                this.longValues = new long[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    this.longValues[n] = nArray[n];
                }
            } else {
                this.longValues = new long[0];
            }
            if (objectArray != null) {
                this.objValues = new Object[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    this.objValues[n] = objectArray[n];
                }
            } else {
                this.objValues = new Object[0];
            }
            this.suspectFlag = bl;
        }

        FixedValueContainer(String string, long[] lArray, Object[] objectArray, boolean bl) {
            int n;
            this.moId = string;
            if (lArray != null) {
                this.longValues = new long[lArray.length];
                for (n = 0; n < lArray.length; ++n) {
                    this.longValues[n] = lArray[n];
                }
            } else {
                this.longValues = new long[0];
            }
            if (objectArray != null) {
                this.objValues = new Object[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    this.objValues[n] = objectArray[n];
                }
            } else {
                this.objValues = new Object[0];
            }
            this.suspectFlag = bl;
        }

        public String getMoId() {
            return this.moId;
        }

        public Object[] getObjectValues() {
            return this.objValues;
        }

        public int[] getIntValues() {
            int[] nArray = new int[this.longValues.length];
            for (int i = 0; i < this.longValues.length; ++i) {
                nArray[i] = (int)this.longValues[i];
            }
            return nArray;
        }

        public long[] getLongValues() {
            return this.longValues;
        }

        public boolean getSuspectFlag() {
            return this.suspectFlag;
        }
    }
}

