/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.CounterBasedScanner;
import se.ericsson.cello.pms.generic.MeasurementStatus;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservedEntity;
import se.ericsson.cello.transaction.Coordinator;

class ObservedClass
extends ObservedEntity {
    private static final long serialVersionUID = -7765690391308522620L;
    private ObservationClass observationClass;
    private transient ManagedObject[] moRefs;

    ObservedClass(ObservationClass observationClass) {
        this.observationClass = observationClass;
    }

    protected String[] getAttributes() {
        return this.observationClass.class_attribute_list;
    }

    protected void setAttributes(String[] stringArray) {
        this.observationClass.class_attribute_list = stringArray;
    }

    public void clear() {
        this.createMeasuredData();
        this.moRefs = this.lookupInstances(this.observationClass.object_class_name);
    }

    public boolean measure(Coordinator coordinator, CounterBasedScanner counterBasedScanner) {
        boolean bl = true;
        for (int i = 0; i < this.moRefs.length; ++i) {
            if (counterBasedScanner.isTerminated()) {
                return bl;
            }
            ManagedObject managedObject = this.moRefs[i];
            if (this.getMeasuredData().isSampled(managedObject.getLocalDistinguishedName())) continue;
            ArrayList arrayList = new ArrayList();
            MeasurementStatus measurementStatus = this.fetch(managedObject, arrayList, coordinator, counterBasedScanner);
            Object[] objectArray = new Object[arrayList.size()];
            arrayList.toArray(objectArray);
            if (measurementStatus == MeasurementStatus.UNAVAILABLE) {
                bl = false;
                continue;
            }
            this.getMeasuredData().addMeasuredValues(managedObject.getLocalDistinguishedName(), objectArray, measurementStatus != MeasurementStatus.OK);
        }
        return bl;
    }

    private ManagedObject[] lookupInstances(String string) {
        Vector<ManagedObject> vector = new Vector<ManagedObject>();
        MoIterator moIterator = MoRepository.instance().lookupType(string);
        if (moIterator == null) {
            return new ManagedObject[0];
        }
        while (moIterator.hasMoreElements()) {
            vector.addElement(moIterator.nextMo());
        }
        Object[] objectArray = new ManagedObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

