/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationClassException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.MonitoringTask;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.NoSuchIdException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.ProcessingErrorException;
import se.ericsson.cello.pms.generic.ScannerRepository;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class PerformanceMonitoringFactory {
    private static PerformanceMonitoringFactory instance = new PerformanceMonitoringFactory();
    private PmsContext pmsContext;
    private boolean inService = false;

    public static PerformanceMonitoringFactory instance() {
        return instance;
    }

    private PerformanceMonitoringFactory() {
    }

    public int createPerformanceMonitoring(ObservationClass[] observationClassArray, int n, String string, PerformanceMonitoringState performanceMonitoringState) throws InvalidObservationClassException, InvalidGranularityPeriodException, NumberOfCountersExceededException, NumberOfMonitorsExceededException, OverloadException, GranularityPeriodNotSupportedException, GranularityAndAttributeActivationException, ParameterNotAcceptedException, ProcessingErrorException {
        int n2 = -1;
        try {
            return this.createPerformanceMonitoring(observationClassArray, new ObservationObject[0], n, string, performanceMonitoringState);
        }
        catch (InvalidObservationObjectListException invalidObservationObjectListException) {
            return n2;
        }
    }

    public int createPerformanceMonitoring(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, int n, String string, PerformanceMonitoringState performanceMonitoringState) throws InvalidObservationClassException, InvalidObservationObjectListException, InvalidGranularityPeriodException, NumberOfCountersExceededException, NumberOfMonitorsExceededException, OverloadException, GranularityPeriodNotSupportedException, GranularityAndAttributeActivationException, ParameterNotAcceptedException, ProcessingErrorException {
        if (!this.inService) {
            MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " - Create failed due to PMSI is not ready yet"));
            return -1;
        }
        this.checkObservationClass(observationClassArray);
        this.checkObservationObject(observationObjectArray);
        MonitoringTask monitoringTask = null;
        Control control = null;
        control = TransactionHelper.create();
        try {
            monitoringTask = MonitoringTaskMgr.instance().createMonitoringTask(observationClassArray, observationObjectArray, n, n, string, performanceMonitoringState, control.getCoordinator());
            control.getTerminator().commit();
            MessageLog.trace((int)8, this.getClass(), (String)("create (" + monitoringTask.getScannerId().intValue() + ")"));
            return monitoringTask.getScannerId().intValue();
        }
        catch (InvalidGranularityPeriodException invalidGranularityPeriodException) {
            TransactionHelper.rollback(control);
            throw invalidGranularityPeriodException;
        }
        catch (NumberOfCountersExceededException numberOfCountersExceededException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " - NumberOfCountersExceededException caught during create of performance monitoring, will raise an alarm and create the performance monitoring in state suspended."));
            this.pmsContext.createMinorAlarm();
            int n2 = this.createPerformanceMonitoring(observationClassArray, observationObjectArray, n, string, PerformanceMonitoringState.SUSPENDED);
            this.pmsContext.checkLoad();
            return n2;
        }
        catch (OverloadException overloadException) {
            TransactionHelper.rollback(control);
            throw overloadException;
        }
        catch (GranularityPeriodNotSupportedException granularityPeriodNotSupportedException) {
            TransactionHelper.rollback(control);
            throw granularityPeriodNotSupportedException;
        }
        catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
            TransactionHelper.rollback(control);
            throw granularityAndAttributeActivationException;
        }
        catch (ParameterNotAcceptedException parameterNotAcceptedException) {
            TransactionHelper.rollback(control);
            throw parameterNotAcceptedException;
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)inactiveTransactionException);
            throw new ProcessingErrorException();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)transactionRolledBackException);
            throw new ProcessingErrorException();
        }
        catch (Exception exception) {
            TransactionHelper.rollback(control);
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
            throw new ProcessingErrorException();
        }
    }

    public void deletePerformanceMonitoring(int n) throws NoSuchIdException, ProcessingErrorException, InvalidPerformanceMonitoringTypeException {
        if (!this.inService) {
            MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " - Deleting failed due to PMSI is not ready yet "));
            return;
        }
        MessageLog.trace((int)8, this.getClass(), (String)("delete request (" + n + ")"));
        Control control = null;
        try {
            Object object = ScannerRepository.instance().lookup(n);
            if (object == null) {
                throw new NoSuchIdException(n);
            }
            if (!(object instanceof MonitoringTask)) {
                throw new InvalidPerformanceMonitoringTypeException();
            }
            control = TransactionHelper.create();
            MonitoringTaskMgr.instance().deleteMonitoringTask((MonitoringTask)object, control.getCoordinator());
            control.getTerminator().commit();
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)inactiveTransactionException);
            throw new ProcessingErrorException();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"Processing failure due to inactive transaction.", (Throwable)transactionRolledBackException);
            throw new ProcessingErrorException();
        }
        catch (RuntimeException runtimeException) {
            TransactionHelper.rollback(control);
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
            throw new ProcessingErrorException();
        }
    }

    public MonitoringTaskInfo lookupPerformanceMonitoring(int n) throws NoSuchIdException, ProcessingErrorException {
        if (!this.inService) {
            MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " - Lookup failed due to PMSI is not ready yet"));
            return null;
        }
        MonitoringTaskInfo monitoringTaskInfo = null;
        try {
            Object object = ScannerRepository.instance().lookup(n);
            if (object == null) {
                throw new NoSuchIdException(n);
            }
            if (object instanceof MonitoringTask) {
                monitoringTaskInfo = ((MonitoringTask)object).getTaskInfo();
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)runtimeException);
            throw new ProcessingErrorException();
        }
        return monitoringTaskInfo;
    }

    public MonitoringTaskInfo[] listPerformanceMonitorings() {
        if (!this.inService) {
            MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " - List failed due to PMSI is not ready yet"));
            return null;
        }
        Object[] objectArray = null;
        Vector<MonitoringTaskInfo> vector = new Vector<MonitoringTaskInfo>();
        Object var3_3 = null;
        Enumeration enumeration = ScannerRepository.instance().lookupAll();
        while (enumeration.hasMoreElements()) {
            var3_3 = enumeration.nextElement();
            if (!(var3_3 instanceof MonitoringTask)) continue;
            vector.add(((MonitoringTask)var3_3).getTaskInfo());
        }
        objectArray = new MonitoringTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void ready() {
        this.inService = true;
    }

    void setPmsContext(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
    }

    private void checkObservationClass(ObservationClass[] observationClassArray) throws InvalidObservationClassException {
        LinkedList<ObservationClass> linkedList = new LinkedList<ObservationClass>();
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            if (MoFactoryMgr.instance().lookup(string) == null) {
                linkedList.add(observationClassArray[i]);
                continue;
            }
            String[] stringArray = this.checkAttributes(string, observationClassArray[i].class_attribute_list);
            if (stringArray.length == 0) continue;
            linkedList.add(new ObservationClass(string, stringArray));
        }
        if (linkedList.size() > 0) {
            ObservationClass[] observationClassArray2 = new ObservationClass[linkedList.size()];
            for (int i = 0; i < linkedList.size(); ++i) {
                observationClassArray2[i] = (ObservationClass)linkedList.get(i);
            }
            throw new InvalidObservationClassException(observationClassArray2);
        }
    }

    private void checkObservationObject(ObservationObject[] observationObjectArray) throws InvalidObservationObjectListException {
        LinkedList<ObservationObject> linkedList = new LinkedList<ObservationObject>();
        for (int i = 0; i < observationObjectArray.length; ++i) {
            String[] stringArray = observationObjectArray[i].instance_attribute_list;
            for (int j = 0; j < observationObjectArray[i].instance_list.length; ++j) {
                String string = observationObjectArray[i].instance_list[j];
                ManagedObject managedObject = MoRepository.instance().lookup(string);
                if (managedObject == null) {
                    linkedList.add(observationObjectArray[i]);
                    continue;
                }
                String[] stringArray2 = this.checkAttributes(managedObject.getType(), stringArray);
                if (stringArray2.length == 0) continue;
                linkedList.add(new ObservationObject(observationObjectArray[i].instance_list, stringArray));
            }
        }
        if (linkedList.size() > 0) {
            ObservationObject[] observationObjectArray2 = new ObservationObject[linkedList.size()];
            for (int i = 0; i < linkedList.size(); ++i) {
                observationObjectArray2[i] = (ObservationObject)linkedList.get(i);
            }
            throw new InvalidObservationObjectListException(observationObjectArray2);
        }
    }

    private String[] checkAttributes(String string, String[] stringArray) {
        return ObjectRepository.instance().checkAttributes(string, stringArray);
    }
}

