/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.Formatter;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.MeasuredDataReusable;
import se.ericsson.cello.pms.generic.ScannerInterrupter;
import se.ericsson.cello.pms.generic.ScannerTimer;
import se.ericsson.cello.pms.generic.Time;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;

final class PmDataConsumer {
    public static final int ROP_CLOSE_LIMIT = 240000;
    protected static Map consumers = new Hashtable();
    private DataConsumer callbackRef;
    private GranularityPeriod gperiod;
    protected List producers = new LinkedList();
    private Formatter formatter;
    private ScannerInterrupter interrupter;
    private PeriodHandler periodHandler;
    private boolean locked = true;
    private boolean pushNotAllowedAlreadyTraced = false;
    private Watchdog watchdog;
    private int seqNo = 0;
    private boolean stop;
    private boolean bIncompletePeriod = true;

    static synchronized PmDataConsumer getInstance(GranularityPeriod granularityPeriod, Formatter formatter, ScannerInterrupter scannerInterrupter) {
        PmDataConsumer pmDataConsumer = (PmDataConsumer)consumers.get(granularityPeriod);
        if (pmDataConsumer == null) {
            pmDataConsumer = new PmDataConsumer(granularityPeriod, formatter, scannerInterrupter);
            consumers.put(granularityPeriod, pmDataConsumer);
        }
        return pmDataConsumer;
    }

    synchronized DataConsumer getCallbackObject() {
        if (this.callbackRef == null) {
            this.callbackRef = new CallbackObject();
        }
        return this.callbackRef;
    }

    synchronized void reserve(Object object) {
        if (!this.producers.contains(object)) {
            this.producers.add(object);
        }
        if (this.producers.size() == 1) {
            this.start();
        }
    }

    synchronized void free(Object object) {
        if (this.producers.size() > 0) {
            this.producers.remove(object);
            if (this.producers.size() == 0) {
                this.stop();
                MessageLog.info(this.getClass(), (String)"No active scanners. Requesting premature stop of fileWorker thread");
                this.formatter.endFile(this.getSequenceNumber());
                this.seqNo = 0;
                this.locked = true;
            }
        }
    }

    void actionNewPeriod(ActionEvent actionEvent) {
        this.locked = false;
        this.pushNotAllowedAlreadyTraced = false;
        this.setSequenceNo();
        if (this.bIncompletePeriod) {
            MessageLog.trace((int)8, this.getClass(), (String)"First complete ROP period starts now.");
            this.bIncompletePeriod = false;
        }
        if (!actionEvent.getActionCommand().equals("stopped")) {
            this.watchdog = new Watchdog(240000, this.seqNo);
            Thread thread = new Thread((Runnable)this.watchdog, "Oms_pms_DC" + this.gperiod.inSeconds());
            thread.setPriority(thread.getThreadGroup().getMaxPriority());
            thread.start();
        }
        if (this.stop) {
            this.stop();
            this.stop = false;
        }
    }

    private PmDataConsumer(GranularityPeriod granularityPeriod, Formatter formatter, ScannerInterrupter scannerInterrupter) {
        this.gperiod = granularityPeriod;
        this.formatter = formatter;
        this.interrupter = scannerInterrupter;
    }

    private void start() {
        if (this.periodHandler == null) {
            this.periodHandler = new PeriodHandler();
        }
        this.periodHandler.start(this.gperiod);
    }

    private void stop() {
        if (this.periodHandler != null) {
            this.periodHandler.stop();
        }
    }

    protected static int calculateCurrentSeqNo() {
        int n = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Time.instance().getDate());
        int n2 = calendar.get(12);
        if (n2 >= 0 && n2 < 5) {
            n = 12;
        } else if (n2 >= 5 && n2 < 10) {
            n = 1;
        } else if (n2 >= 10 && n2 < 15) {
            n = 2;
        } else if (n2 >= 15 && n2 < 20) {
            n = 3;
        } else if (n2 >= 20 && n2 < 25) {
            n = 4;
        } else if (n2 >= 25 && n2 < 30) {
            n = 5;
        } else if (n2 >= 30 && n2 < 35) {
            n = 6;
        } else if (n2 >= 35 && n2 < 40) {
            n = 7;
        } else if (n2 >= 40 && n2 < 45) {
            n = 8;
        } else if (n2 >= 45 && n2 < 50) {
            n = 9;
        } else if (n2 >= 50 && n2 < 55) {
            n = 10;
        } else if (n2 >= 55) {
            n = 11;
        }
        return n;
    }

    private void setSequenceNo() {
        this.seqNo = PmDataConsumer.calculateCurrentSeqNo();
    }

    int getSequenceNumber() {
        return this.seqNo;
    }

    private int getDataSeqNoForManualTimeout(int n) {
        if (this.gperiod.equals(GranularityPeriod.MINUTES_5)) {
            if (n == 12) {
                return 1;
            }
            return n + 1;
        }
        if (this.gperiod.equals(GranularityPeriod.MINUTES_15)) {
            if (n == 12) {
                return 3;
            }
            return n + 3;
        }
        return 12;
    }

    void logPushNotAllowed(MeasuredData[] measuredDataArray) {
        String string = "unknown";
        if (measuredDataArray.length == 0) {
            MessageLog.trace((int)8, this.getClass(), (String)"Data Consumer has recieved an empty MeasuredData!");
        } else if (measuredDataArray[0] != null) {
            string = measuredDataArray[0].getFirstMoId();
        }
        MessageLog.info(this.getClass(), (String)("Push not allowed. Pushing MO is " + string));
        for (int i = 0; i < measuredDataArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            measuredDataArray[i].getMoIds(stringBuffer);
            MessageLog.trace((int)8, this.getClass(), (String)("Pushing MOs: " + stringBuffer.toString()));
        }
    }

    private class Watchdog
    implements Runnable {
        private int timeout;
        private int sequenceNo;

        Watchdog(int n, int n2) {
            this.timeout = n;
            this.sequenceNo = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Watchdog watchdog = this;
                synchronized (watchdog) {
                    try {
                        this.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                PmDataConsumer.this.locked = true;
                PmDataConsumer.this.formatter.storeMeasuredData(PmDataConsumer.this.interrupter.getMeasuredData(), this.sequenceNo);
                if (this.sequenceNo != 0) {
                    PmDataConsumer.this.formatter.endFile(this.sequenceNo);
                } else {
                    MessageLog.trace((int)8, this.getClass(), (String)"SeqNo is 0. No need to request fileWorker to stop");
                }
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
            }
        }
    }

    private class PeriodHandler
    implements ActionListener {
        private ScannerTimer timer;

        public void actionPerformed(ActionEvent actionEvent) {
            PmDataConsumer.this.actionNewPeriod(actionEvent);
        }

        PeriodHandler() {
        }

        void start(GranularityPeriod granularityPeriod) {
            if (this.timer == null) {
                this.timer = ScannerTimer.create(granularityPeriod);
                this.timer.addActionListener(this);
            }
        }

        void stop() {
            if (this.timer != null) {
                this.timer.removeActionListener(this);
                this.timer.stop();
                this.timer = null;
            }
        }

        boolean triggerTimeout() {
            return this.timer.triggerTimeout();
        }
    }

    private class CallbackObject
    implements DataConsumer {
        private CallbackObject() {
        }

        public synchronized void push(MeasuredData[] measuredDataArray, int n) {
            if (PmDataConsumer.this.bIncompletePeriod) {
                MessageLog.trace((int)8, this.getClass(), (String)("push() during incomplete period, ignoring, no data is stored. dataSeqNo = " + n));
                return;
            }
            if (!PmDataConsumer.this.locked && PmDataConsumer.this.seqNo == n) {
                for (int i = 0; i < measuredDataArray.length; ++i) {
                    if (!(measuredDataArray[i] instanceof MeasuredDataReusable)) continue;
                    ((MeasuredDataReusable)measuredDataArray[i]).lock();
                }
                PmDataConsumer.this.formatter.storeMeasuredData(measuredDataArray, n);
            } else {
                int n2 = PmDataConsumer.this.seqNo;
                if (PmDataConsumer.this.periodHandler.timer != null) {
                    if (PmDataConsumer.this.locked && PmDataConsumer.this.periodHandler.triggerTimeout()) {
                        if (n2 != 0) {
                            if (PmDataConsumer.this.getDataSeqNoForManualTimeout(n) == PmDataConsumer.this.seqNo || n == 0) {
                                PmDataConsumer.this.formatter.storeMeasuredData(measuredDataArray, PmDataConsumer.this.seqNo);
                                MessageLog.info(this.getClass(), (String)"Pushed data stored after manually triggered timeout.");
                            } else {
                                MessageLog.info(this.getClass(), (String)("Manually triggered timeout after push with incorrect sequence number, no data stored. Sequence number from scanner: " + n + ", sequence number in PmDataConsumer: " + n2));
                            }
                        } else {
                            MessageLog.info(this.getClass(), (String)"Manually triggered timeout after incomplete period (PmDataConsumer.seqNo==0), no data stored.");
                        }
                    } else if (PmDataConsumer.this.locked) {
                        if (!PmDataConsumer.this.pushNotAllowedAlreadyTraced) {
                            PmDataConsumer.this.logPushNotAllowed(measuredDataArray);
                            PmDataConsumer.this.pushNotAllowedAlreadyTraced = true;
                        }
                    } else if (n != 0) {
                        MessageLog.info(this.getClass(), (String)("Push with incorrect sequence number; sequence number from scanner: " + n + ", sequence number in PmDataConsumer: " + PmDataConsumer.this.seqNo));
                    }
                } else {
                    MessageLog.info(this.getClass(), (String)"Scanner is suspended/deleted.");
                }
            }
        }
    }
}

