/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.Time;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.AWTEventMulticaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.Alarm;

class ScannerTimer {
    static final String FIRST_TICK = "expired first time";
    static final String STOPPED = "stopped";
    private static Hashtable timers = new Hashtable();
    private GranularityPeriod granularityPeriod;
    private ActionListener observers;
    private int noOfListeners;
    private static final int LOWER_LIMIT = 10000;
    private static final int UPPER_LIMIT = 30000;
    private Alarm timer;
    private AlarmListener alarmListener;
    private boolean taskOngoing = false;
    static /* synthetic */ Class class$se$ericsson$cello$pms$generic$ScannerTimer$AlarmListener;

    static synchronized ScannerTimer create(GranularityPeriod granularityPeriod) {
        ScannerTimer scannerTimer = (ScannerTimer)timers.get(granularityPeriod);
        if (scannerTimer == null) {
            scannerTimer = new ScannerTimer(granularityPeriod);
            timers.put(granularityPeriod, scannerTimer);
        }
        return scannerTimer;
    }

    void stop() {
        if (this.noOfListeners > 0) {
            return;
        }
        this.stopTimer();
        ScannerTimer.remove(this.granularityPeriod);
    }

    void addActionListener(ActionListener actionListener) {
        if (this.timer == null) {
            throw new RuntimeException("Adding a listener to a stopped timer.");
        }
        ++this.noOfListeners;
        this.observers = AWTEventMulticaster.add((ActionListener)this.observers, (ActionListener)actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        --this.noOfListeners;
        this.observers = AWTEventMulticaster.remove((ActionListener)this.observers, (ActionListener)actionListener);
    }

    boolean triggerTimeout() {
        int n = this.calculateDelay();
        if (n > this.granularityPeriod.inSeconds() * 1000 - 240000 && !this.taskOngoing) {
            this.taskOngoing = true;
            this.notifyObservers(n);
            this.taskOngoing = false;
            return true;
        }
        return false;
    }

    private static void remove(GranularityPeriod granularityPeriod) {
        timers.remove(granularityPeriod);
    }

    private ScannerTimer(GranularityPeriod granularityPeriod) {
        this.granularityPeriod = granularityPeriod;
        this.alarmListener = new AlarmListener(this);
        this.startTimer(this.calculateDelay());
    }

    private void startTimer(int n) {
        this.stopTimer();
        this.timer = new Alarm(n, Alarm.ONE_SHOT);
        this.timer.addActionListener((ActionListener)this.alarmListener);
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private int calculateDelay() {
        Calendar calendar = Time.instance().getCalendar();
        int n = 60 - calendar.get(13);
        int n2 = 0;
        if (this.granularityPeriod.equals(GranularityPeriod.SECONDS_15)) {
            n = 15 - calendar.get(13) % 15;
        } else {
            n2 = this.granularityPeriod.equals(GranularityPeriod.MINUTES_5) ? 4 - calendar.get(12) % 5 : (this.granularityPeriod.equals(GranularityPeriod.MINUTES_15) ? 14 - calendar.get(12) % 15 : 59 - calendar.get(12));
        }
        return (n2 * 60 + n) * 1000;
    }

    void runTask() {
        int n = this.calculateDelay();
        if (n < this.granularityPeriod.inSeconds() * 1000 - 30000 && n > 10000) {
            MessageLog.info(this.getClass(), (String)("Unexpected time indication which cannot be handle correctly (" + this.granularityPeriod.inSeconds() + "/ " + new Date() + ")"));
        } else if (n <= 10000) {
            while (n < 10000) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = this.calculateDelay();
            }
        }
        this.notifyObservers(n);
    }

    private void notifyObservers(int n) {
        if (this.observers != null) {
            this.observers.actionPerformed(new ActionEvent((Object)this, 0, FIRST_TICK));
        }
        if (this.noOfListeners > 0) {
            this.startTimer(n);
        } else {
            this.stopTimer();
        }
    }

    private static class AlarmListener
    implements ActionListener {
        private ScannerTimer taskHandler;

        AlarmListener(ScannerTimer scannerTimer) {
            this.taskHandler = scannerTimer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("expired")) {
                if (!this.taskHandler.taskOngoing) {
                    this.taskHandler.taskOngoing = true;
                    this.taskHandler.runTask();
                    this.taskHandler.taskOngoing = false;
                } else {
                    MessageLog.info((Class)(class$se$ericsson$cello$pms$generic$ScannerTimer$AlarmListener == null ? (class$se$ericsson$cello$pms$generic$ScannerTimer$AlarmListener = ScannerTimer.class$("se.ericsson.cello.pms.generic.ScannerTimer$AlarmListener")) : class$se$ericsson$cello$pms$generic$ScannerTimer$AlarmListener), (String)"Alarm expired, task ongoing already.");
                }
            }
        }
    }
}

