/*
 *  COPYRIGHT
 *  ---------
 *  Ericsson AB 2008-2010 All rights reserved.
 *
 * The information in this document is the property of Ericsson.
 * Except as specifically authorized in writing by Ericsson, the
 * receiver of this document shall keep the information contained
 * herein confidential and shall protect the same in whole or in
 * part from disclosure and dissemination to third parties.
 * Disclosure and dissemination to the receiver's employees shall
 * only be made on a strict need to know basis.
 *
 *
 *  REVISION HISTORY
 *  ----------------
 *
 *  Revised: Johan Flinck 08 Aug 2008
 *  Changes: First revision.
 * 
 * 
 *  2010-09-01 ehsake HM11102 Moved CPPClient handling to CPPClientProducer
 *
 *
 */

package se.ericsson.cello.viewfilecreator.mao;

import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Struct;

import java.util.Hashtable;


public class ProductVersionSearcher {

	private static final String NOREVISION = "NOREVISION";
	private Hashtable revisionTable = new Hashtable(); 
	
	public ProductVersionSearcher() {
		
	}
	
	public String getProductVersion(String productNumber) {
		String productVersion = (String) revisionTable.get(productNumber);
		if(productVersion==null){
			productVersion= NOREVISION;
		}
		return productVersion;
	}
	
	public void createHashtable(ManagedObject[] loadModules) throws Exception {
		
		Struct productData = null;
		for (int i = 0; i < loadModules.length; i++) {
			LoadModuleMo loadModule = (LoadModuleMo)loadModules[i];
			productData = loadModule.getProductData(null);
			revisionTable.put(productData.getValue(LoadModuleMo.PRODUCT_NUMBER),productData.getValue(LoadModuleMo.PRODUCT_REVISION));
		}
	}
	
	
}

