#!/usr/bin/perl
use strict;
use Getopt::Long;
use Data::Dumper;

use lib substr($0, 0, rindex($0,"/")) . '/pmxcel/lib';
use FindBin;
use lib "$FindBin::Bin/pmxcel/lib"; 

use Spreadsheet::ParseExcel;    

my $colmap = { A=>0, B=>1, C=>2, D=>3, E=>4, F=>5, G=>6, H=>7, I=>8, J=>9, K=>10, L=>11, M=>12, N=>13, O=>14, P=>15, Q=>16, R=>17, S=>18, T=>19, U=>20 };


my ($debug,$cfile);
GetOptions
(
	'debug'			=> \$debug,
	'config|c=s'	=> \$cfile
);

sub main
{
	my $cfile = shift;
	read_config($cfile);
}

sub read_config
{
	my $cfile = shift;
	open CONFIG, "<$cfile";
	while ( my $line = <CONFIG> )
	{
		next if $line =~ /^\s*#/;
		my ( $file,$sheet,$cxp,$nodeType,$rel_pos,$up_pos,$cpp_poss,$start ) = split( /;/, $line );
		if ( defined $file && -e $file )
		{
			read_excel( $file,$sheet,$cxp,$nodeType,$rel_pos,$up_pos,$cpp_poss,$start ) ;
		}
		elsif( $file !~/^\s*$/)
		{
			print "couldn't find file: '$file'\n";
		}
	}
	close CONFIG;
	
}

sub read_excel
{
	my ( $file,$sheet,$cxp,$nodeType,$rel_pos,$up_pos,$cpp_poss,$start ) = @_;
	
	my $parser   = Spreadsheet::ParseExcel->new();
	my $workbook = $parser->Parse($file);
	print "$file\n";
	if ( !defined $workbook )
	{
		print "couln't open file: '$file'\n";
		return;
	}
	my $workbook_sheet = $workbook->worksheet($sheet);
	if ( !defined $workbook_sheet )
	{
		print "couln't open sheet: '$file', '$sheet'\nsheets found in document: ";
		for my $worksheet ( $workbook->worksheets() ) 
		{
			my $name = $worksheet->get_name();
			print "'$name', ";
    		}
		print "\b\n";
		return;
	}
	if (defined $workbook_sheet)
	{
		print "file:$file;sheet:$sheet,rel_pos:$rel_pos:$$colmap{$rel_pos},up_pos:$up_pos:$$colmap{$up_pos},cpp_poss:$cpp_poss:$$colmap{$cpp_poss},start pos:$start\n";
		my ( $row_min, $row_max ) = $workbook_sheet->row_range();
		my ( $col_min, $col_max ) = $workbook_sheet->col_range();
		for my $row ( $start .. $row_max )
		{
			my $rel = $workbook_sheet->get_cell( $row, $$colmap{$rel_pos} );
			my $up = $workbook_sheet->get_cell( $row, $$colmap{$up_pos} );
			my $cpp = $workbook_sheet->get_cell( $row, $$colmap{$cpp_poss} );
			next unless $rel && $up && $up->value() && $rel->value() && $rel->value() !~ /internal|Associated|Delivery/i;
			$rel = $rel->value();
			$up = $up->value();
			$cpp = $cpp->value();
			$rel =~ s/\n//g;
			$up =~ s/\n//g;
			$cpp =~ s/\n//g;
			print $rel . ";" . $cpp . "; $cxp; " . $up . "; $nodeType\n" ;
		}
	}
	
}

main($cfile);
exit;
