######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################
function printDN(what,mo)
{
	#where what= fdn,long,short,medium,motype
	#where mo= an entry from the Mo Table
	if (what=="fdn"){}
}
function old_is_process_there(pid,    pscom,line,result,array,s)
{
	#ps -p pid
	#     1352    3000    1352        932   12 24035 08:31:03 /usr/bin/ps
	#ps -fu <user>
	#eanzmagn    1352    3000  12  08:30:59 /usr/bin/ps
	#Martin A    4060       1 con  09:54:52 /usr/bin/rxvt
	result=1
	if (ps_not_support_p_option==1) pscom="/bin/ps -fu "PROCINFO["uid"]
	else pscom="/bin/ps -p "pid" 2>&1"
	if (mosdebug==1) print "DEBUG: pscom="pscom
	while (pscom |& getline line)
	{
		gsub("\r","",line)
		if (mosdebug==1) print "DEBUG: line="line
		split(line,array," ")
		if (ps_not_support_p_option==1)
		{
			if (array[2]~/^[0-9]+$/) s=2 ; else s=3
			if (array[s] == pid) result=0
		}
		else if (ps_not_support_p_option!=1 && array[1] == pid) result=0
		else if (tolower(array[1])=="usage:")
		{
			ps_not_support_p_option=1
			customPrint("Warning: option -p not supported on this version of \"ps\". Using -f instead, may lead to slower execution times.")
			if (os == "cygwin") customPrint("It is recommended to upgrade your cygwin installation!\n")
			else customPrint("It is recommended to install a newer version of \"ps\".")
			break
		}
	}
	close(pscom)
	if (result==1) delete moshell_java_proclist[pid]
	return result
}
function check_missing_backslash( i,fault)
{
	#to put a backslash in front of the following five characters: * ; \n " >
	#\x05c is "\" and \x02a is "*"
	fault=0
	for (i=1; i<=NF ; i++)
	{
		if ($i ~ "\x02a" && $i !~ /\\\*/)
		{
			gsub("*","\x05c\x02a",$i)
			fault=1
		}
		if ($i ~ /\\n/ && $i !~ /\\\\n/)
		{
			gsub(/\\n/,"\x05c\x05cn",$i)
			fault=1
		}
		if ($i ~ ";" && $i !~ /\\;/)
		{
			gsub(/;/,"\x05c;",$i)
			fault=1
		}
		if ($i ~ ">" && $i !~ /\\>/)
		{
			gsub(/>/,"\x05c>",$i)
			fault=1
		}
		if ($i ~ "\x022" && $i !~ /\\"/)
		{
			gsub(/\"/,"\x05c\x022",$i)
			fault=1
		}
	}
	#if (fault==1) print $0
}
function ids_to_ldn(ids,what,attr_name,   cnt,array2,i,class,ldn,res,array3,j,cnt3,nr)
{
	#first processing
	if (ids ~ /^sF[0-9]+#ManagedElement=1,/)
	{
		nr=gensub(/^sF|#.*$/,"","g",ids)
		if (what=="long")
		{
			sub(/^sF[0-9]+#ManagedElement=1,/,"",ids)
			ids=gensub(/#ManagedElement=1,/,"\n     ","g",ids)
		}
		else
		{
			sub(/^sF[0-9]+#ManagedElement=1,[^,]+,/,"",ids)
			ids=gensub(/#ManagedElement=1,[^,]+,/,"\n     ","g",ids)
		}
		if (ids ~ /^([^,]+,)?LoadModule=[^&]+&[0-9]+&([0-9]+)?&([0-9]+)?&/)
		{
			cnt=split(ids,array2,"\n")
			cnt3=split(array2[1],array3,"&")
			ids=sprintf("LoadList #%s\n%-5s%-35s  tag=%-2s%s%s",nr,"",array3[1],array3[2],(array3[3]!=""?sprintf("   heap=%-10s",array3[3]):""),(array3[4]!=""?"   pool="array3[4]:""))
			for (i=2;i<=cnt;i++)
			{
				cnt3=split(array2[i],array3,"&")
				ids=sprintf("%s\n%-40s  tag=%-2s%s%s",ids,array3[1],array3[2],(array3[3]!=""?sprintf("   heap=%-10s",array3[3]):""),(array3[4]!=""?"   pool="array3[4]:""))
			}
		}
		else if (ids ~ /^([^,]+,)?PiuType=/ && attr_name=="piuTypeRefs")
		{
			ids=sprintf("LoadList #%s\n     %s",nr,ids)
		}
		return ids
	}
	else if (ids ~ /(^sF)?ManagedElement=1,/)
	{
		if (what=="long") return gensub(/(^sF)?ManagedElement=1,/,"","g",ids)
		else return gensub(/(^sF)?ManagedElement=1,[^,]+,/,"","g",ids)
	}
	if (ids !~ /^([a-z][A-Z])*1=1(,|$)/)
	{
		if (ids == "sF") return "sFnull"
		#some attributes are sequence of strings and we must keep the sF in front so that they are properly translated as sequence of string and not sequence of MOs: e.g. mgcLabelArray, tdmTermGrpLabelArray, vmgwLabelArray
		#### if (ids ~ /^sF/) sub(/^sF/,"",ids)
		if (ids ~ /^(loadModuleList|piuTypeLmData|[a-z][a-zA-Z0-9]+\[[0-9]+\])$/) ids=""
		return ids
	}
	#now work out the LDN if it was a coded LDN
	#Examples:
	#1=1,5=1,125=adoffbdoff
	#Corrupted examples:
	#1=1,5=1,141=aal2pathvcctp=99
	#1=1,5=1,141=TransportNetwork=1,141=88
	sub(/^([a-z][A-Z])*1=1,/,"",ids);
	cnt=split(ids,array2,",");
	for(i=1;i<=cnt;i++)
	{
		class=rev_motype_r1Table[gensub(/=.*$/,"",1,array2[i])]
		if (class != "") ldn = ldn class gensub(/^[^=]+=/,"=",1,array2[i]) ","
	}
	res=gensub(/,$/,"",1,ldn);
	if (what=="short") sub(/^[^,]+,/,"",res)
	return res
}
function cedf(         motypes,inwhat)
{
	if (multi) return multi_error()
	if (comcli>0) return comcli_error()
	#cell_mofro[UtranCell=30561]=23
	#cell_fromo[23]=UtranCell=30561
	#cell_froro[23]=14
	#cell_
	#IubLink=1002                                            froid             1
	#Board   BoardType   Swallocation/DevType  Module
	#================================================
	#001400  GPB53       GPB_Module            1
	#001500  GPB53       GPB_Module            -
	#001600  GPB53       GPB_Module            8
	#$ lhsh 001600 cell list
	#0014: CapsIndex CellId  CellFroId  LocalCellId IubLinkFroId
	#0014: --------------------------------------------------------------
	#0014:         0   1016*         0        1016           0
	#0014:         1   1017          1        1017           0
	#$ lhsh 001400 hwm list rbs
	#0014: RBS =>
	#0014: Index  IubLinkFroId   CellGroup
	#0014: ------------------------------------------
	#0014: 0    * 1
	#0014: 1      3
	#0014: 2      5
	#0014: 21     -1
	#0014: 22     -1
	buildBoardGroup() 
	motypes["utrancell"]=motypes["iublink"]=1
	ConditionalLoad(motypes)
	mo_log(tempcedflog,"open","mute","overwrite","silent")
	old_fast_lh_threshold=fast_lh_threshold ; fast_lh_threshold=0  #set to 0 to avoid spurious printouts from echo "endofprint"
	$0="eget ^rncmodule= froId" ; get("short","","","","","","","","eget")
	$0="eget ^iublink=   froId" ; get("short","","","","","","","","eget")
	$0="eget ^utrancell= froId" ; get("short","","","","","","","","eget")
	$0="bp mod"                 ; buildBoardGroup("list")
	$0="lh"eval_z(3)" mod hwm list rbs;cell list" ; lh("","",eval_z(3))
	fast_lh_threshold=old_fast_lh_threshold
	mo_log(tempcedflog,"close")
	while (getline < tempcedflog)
	{
		gsub(/\r|\x000/,"")
		if (inwhat!="") gsub(/\*/,"")  #only remove the * if we have finished parsing the MOs
		if ($2=="froId" && $1 ~ /^IubLink=/) { iub_mofro[$1]=$3 ; iub_fromo[$3]=$1 }
		else if ($2=="froId" && $1 ~ /^UtranCell=/) { cell_mofro[$1]=$3 ; cell_fromo[$3]=$1 }
		else if (/00 cell list/) inwhat="cell"
		else if (/00 hwm list rbs/) inwhat="rbs"
		else if (inwhat=="cell" && NF==6 && $2 ~ /^[0-9]+$/ && $NF ~ /^[0-9]+$/) cell_froro[$4]=$2
		else if (inwhat=="rbs" && $2 ~ /^[0-9]+$/ && $3 ~ /^[0-9]+$/) iub_froro[$3]=$2
	}
	close(tempcedflog)
}
function faulty_h2b(hexstr,   result,varName)
{
	if (tolower(hexstr) !~ /^[0-9a-fx]+$/) { Display_help("h2b") ; return}
	if ($3 == ">" && NF == 4 && $4 ~ /^\$/) varName = $4;
	if (tolower(hexstr) !~ /^0x/) hexstr="0x"hexstr
	result=bits2str(hexstr)
	customPrint(sprintf("\n%s: %s",hexstr,result))
	if (varName != "") assignCustomVar(varName,result,"print")
}
function make_userlabel_mapfile(Filter1,Filter2,configfile,   ul)
{
	if (node !~ /^OFFLINE/)
	{
		$0="lt all" ; Load_Proxys("type",0)
	}
	empty_file(tempulmapfile)
	mo_log(tempbolog,"open","mute","overwrite") ; muteFactor=30
	$0="lget "Filter1" userlabel" ; get("long")
	mo_log(tempbolog,"close")
	while (getline < tempbolog)
	{
		gsub("\r","")
		if ($2=="userLabel")
		{
			ul=gensub(/ /,"_","g",gensub(/.*userLabel +/,"",1,$0))
			print $1":"$1"."ul >> tempulmapfile
		}
	}
	close(tempbolog)
	close(tempulmapfile)
}
function bits2str(bits,        data, mask)
{
	if (bits == 0) return "0"
	mask = 1
	for (; bits != 0; bits = rshift(bits, 1)) data = (and(bits, mask) ? "1" : "0") data
	while ((length(data) % 8) != 0)	data = "0" data
	return data
}
####################################################################################################################
# TG FUNCTIONS P2.1
####################################################################################################################
function tg_p21(tgswitch, pipeCommand,Filter1,i,proxy,motypes,nrOfIubs,maxIubPerMod,tg_inputvars,tg_session)
{
	if (tgswitch !~ /^(|r|c)$/)
	{
		if (tgswitch == "d") customPrint("\nCommand only supported on P3 and above.")
		return
	}
	if ($2 !~ /\|/) Filter1=$2
	if (tolower($0) ~ /\|/) pipeCommand=sprintf("| %s",gensub(/^[^\|]*\|/,"",1,$0))
	if (tgswitch ~ "r") tgFetched=0
	if (tgFetched==0 )
	{
		check_node_password()
		if (node_password == "") return
		motypes["utrancell"]=motypes["iublink"]=1
		ConditionalLoad(motypes)
		maxIubPerMod=32  # eventhough there is only 20, there can be gaps in the fro allocation so it is best to get all 32
		mo_log(temptglog,"open","mute","overwrite")
		muteFactor=10000
		printf("\
get ^iublink= rncmoduleref\n\
get ^utrancell= ^(cid|iublinkref)$\n\
get ^utrancell= ^ase..adm$\n\
lh mod cell getesv 1/1/1/1/2/1.-%s cellData\n\
lh mod cell getesv 1/1/1/1/7/1.-%s/4\n\
lh mod cell getesv 1/1/1/1/5/5/1.-%s cellFroId\n\
lh mod cell getesv 1/1/1/1/5/5/1.-%s cellBarred\n",maxIubPerMod*3,maxIubPerMod,maxIubPerMod*3,maxIubPerMod*3) > temptgcmd
		printf("\
lh mod cell resourcedata\n\
lh mod cell ccs\n\
lh mod cell ccs all\n") >> temptgcmd
			printf("\
lh mod cell getesv 1/1/1/1/2/1.-%s ulInterference\n\
lh mod cell getesv 1/1/1/1/2/1.-%s cellLoadMonitor\n",maxIubPerMod*3,maxIubPerMod*3) >> temptgcmd
		close(temptgcmd)
		Read_script(temptgcmd)
		mo_log(temptglog,"close")
		tgFetched=1
	}
	customPrint("\n-------------------------------------------------------------------------------------------------------------------------------")
	customPrint("                                                                                               AseDl    AseUl")
	output=sprintf("%3s %-6s  %-12s  %-12s  %4s  %4s  %-14s  %-14s  %2s  %4s  %3s %3s  %3s %3s",\
"MOD","MP","UtranCellId","IubLinkId","CfRO","IfRO","CellActor","IubActor","CB","UlIf","Tot","Adm","Tot","Adm")
	output=sprintf("%s  %s  %s",output,"ccDevice","ccMod")
	output=sprintf("%s  %s",output,"errorCode")
	customPrint(output)
	customPrint("-------------------------------------------------------------------------------------------------------------------------------")
	#if (logging==1) system(sprintf("%s -f %s -l %s -t %s %s",cellreport,Filter1,logfile,temptglog,pipeCommand))
	#else system(sprintf("%s -f %s -t %s %s",cellreport,Filter1,temptglog,pipeCommand))
	tg_inputvars=make_inputvars(Filter1,temptglog)
	tg_session=sprintf("%s -v variables='%s' -l %s -f %s --source \x027 BEGIN{ tg_function(variables) } \x027 %s",gawk,tg_inputvars,filefunc,funcs,pipeCommand)
	system(tg_session)

}
function defineExtra(cfro)
{
	if (spModule[ccDevice[cfro]] != module[froCid[cfro]] && spModule[ccDevice[cfro]] != "") spComment[cfro]=spModule[ccDevice[cfro]]
	if (ccDevice[cfro] !~ /[0-9]+\/sp[0-9]/ && err[cfro] != 0) ccDevice[cfro]=err[cfro]
	else if (err[cfro] != 0 && spComment[cfro]=="") spComment[cfro]=err[cfro]
	else extra[cfro]=err[cfro]
}


function tg_function(inputvariables)
{
	parse_inputvars(inputvariables)
	tgfilter=inputoptions
	tgfile=commandfile

	#Mod	MP	UtranCell   IubLink    CellFro    IubFro   CellActor        CCDevice        nrOfCellsOnCC   Comment
	#1	001400	30450601    304506     78         46       1/1/1/1/2/1.89   002300/sp1.lnh  19
	#iubLink[cellDN]=iub and cid[cellDN]=cid and cellDN[cid]=cell
	#actor[cid]=actor , cellFro[cid]=cellFro, iubFro[cid]=iubFro, module[cid]=module
	defineErrorCodes()
	while (getline < tgfile)
	{
		gsub("\r","") ; gsub("\x000","")
		#Remove link handler info, eg 0114:
		if ($1 ~ /^0[0-9][0-2][0-9]:$/) sub($1,"")
		#IubLink=10                                                rncModuleRef       RncModule=2
		#UtranCell=cell110993                                      cId                16133
		#UtranCell=cell110993                                      iubLinkRef         IubLink=13
		#UtranCell=90123                                           aseDlAdm           240
		#UtranCell=90123                                           aseUlAdm           160
		if ($1 ~ /^IubLink=/ && $2=="rncModuleRef")
		{
			nrOfIubMOs++
			tempMod=gensub(/^RncModule=/,"",1,$3)+0
			moduleIub[gensub(/^IubLink=/,"",1,$1)]=tempMod
			if (tempMod > maxModule) maxModule=tempMod
		}
		else if ($1 ~ /^UtranCell=/)
		{
			if ($2=="cId")
			{
				cellDN[$3]=gensub(/^UtranCell=/,"",1,$1)
				cellCid[gensub(/^UtranCell=/,"",1,$1)]=$3
				nrOfCellMOs++
			}
			else if ($2=="iubLinkRef")
			{
				iubDN[gensub(/^UtranCell=/,"",1,$1)]=gensub(/^IubLink=/,"",1,$3)
				iubMOList[$3]=$3
			}
			else if ($2=="aseDlAdm")
			{
				aseDlAdm[cellCid[gensub(/^UtranCell=/,"",1,$1)]]=$3
			}
			else if ($2=="aseUlAdm")
			{
				aseUlAdm[cellCid[gensub(/^UtranCell=/,"",1,$1)]]=$3
			}
		}
		#   1.1   iubFroId :  int 0
		else if ($1 ~ /^[0-9]+\.[0-9]+$/ && $2 == "iubFroId" && $3 == ":" && $5 >=0)
		{
			iubActor[$5]=sprintf("1/1/1/1/7/1.%s",gensub(/\..*$/,"",1,$1))
			nrOfIubFros++
		}
		else if (/^\$ lhsh [0-9]+ /)
		{
			currentMp=$3
			#delete thisModuleFroList
			#for (cfro in cellResource) ccDevice[cfro]=spLnh[spId[spData[spP[cellResource[cfro]]]]]
			#delete cellResource
		}
		#   1.   cellData :  RnhCellDataD { areaAttribs RnhCellAreaAttribsD { lac int 111, t3212 int 10, att int 1, rac int 1, nmo int 1, sac int 1 }, cellFroId int 0, cellRoParameters RoamIfFroUtranCellRoExtAttribD { admState int 1, opState int 1, availStatus int 0, localCellId int 10111, cId int 10111, tCell int 1, uarfcnUl int 9714, uarfcnDl int 10664, primaryScramblingCode int 110, schPower1 int -18, schPower2 int -35, primaryCpichPower int 270, maxTxPowerUl int 24, maxTxPowerDl int 370, bchPower int -31, cellReserved int 1, treSelection int 2, qualMeasQuantity int 2, qHyst1 int 4, qHyst2 int 4, qQualMin int -18, qRxLevMin int -115, individualOffset int 0, pwrAdm int 75, pwrAdmOffset int 10, pwrOffset int 5, pwrHyst int 30, congDlInterval int 100, congUlInterval int 100, pwrCongFilter int 1, tmCongAction int 2000, releaseAseDl int 3, congTimeOut int 3000, txInterval int 100, txFilter int 5, fPwrUp int 20, fPwrDown int 10, dlCodeAdm int 70, aseDlAdm int 240, beMarginAseDl int 100, aseUlAdm int 160, beMarginDlPwr int 10, beMarginDlCode int 10, beMarginAseUl int 20, sf8Adm int 8, sf32Adm int 32, aseUlAdmOffset int 40, tfsFlexConstant int 10, minPwrRl int -200, maxRate int 40690, interRate int 7760, minimumRate int 1590, maxPwrMax int 48, interPwrMax int 38, minPwrMax int 0, pwrEstFact int 30, compModeAdm int 15, iFOffset int 0, iFHyst int 6000, iFCong int 620, interFreqFddMeasIndicator int 0, sRatSearch int 4, sIntraSearch int 0, sInterSearch int 0, fachMeasOccaCycLenCoeff int 0, accessClassNBarred int 0, noOfUtranCellPosition int 0, utranCellPosition RoamIfFroUtranCellRoExtCellCoordSeqD { 15 RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 }, RoamIfFroUtranCellRoExtCellCoordD { latitude int -1, latitudeSign int -1, longitude int -1 } }, sf16Adm int 16, intCongFilter int 1, sib1PlmnScopeValueTag int 1, locationAreaFroId int 0, serviceAreaFroId int 0, routingAreaFroId int 0, iubLinkFroId int 0, releaseAseDlNg int 3, tmCongActionNg int 800, tmInitialG int 3000, rncModuleId int 0 }, cellSetupInRbsFlag int 1, cgiPtr RTPointer 4 9 177 126 0, drhCcRefActiveFlag int 1, drhCcRef RTByteBlock 12 8 234 208 120 9 76 216 32 0 0 0 0, errorStatus int 0, SPBlocked int 0, spConfigFlag int 1, tpcPattern01CountDl int 8, rncIdChanged int 0 }
		else if ($1 ~ /^[0-9]+\./ && $2 == "cellData" && $3 == ":")
		{
			if ($NF != "}")
			{
				firstPartOfLine=$0
				getline < tgfile
				gsub("\r","") ; gsub("\x000","")
				secondPartOfLine=$0
				$0=firstPartOfLine secondPartOfLine
			}
			last=split($0,array," ")
			for (i=1;i<=last;i++)
			{
				if (array[i]=="cId") cid=gensub(",","",1,array[i+2])+0
				else if (array[i]=="cellFroId") cfro=gensub(",","",1,array[i+2])+0
				else if (array[i]=="iubLinkFroId") ifro=gensub(",","",1,array[i+2])+0
				else if (array[i]=="rncModuleId") mfro=gensub(",","",1,array[i+2])+0
				else if (array[i]=="errorStatus")  errorStatus=gensub(",","",1,array[i+2])+0
			}
			if (cfro >= 0)
			{
				actor[cid]=sprintf("1/1/1/1/2/1.%s",gensub(/\.$/,"",1,array[1]))
				cellFro[cid]=cfro
				froCid[cfro]=cid
				iubFro[cid]=ifro
				ifroCid[ifro]=sprintf("%s;%s",ifroCid[ifro],cid)
				module[cid]=mfro+1
				mp[mfro+1]=currentMp
				if (mfro+1 > 0) mpToModule[currentMp]=mfro+1
				nrOfCellFros++
				moduleList[mfro+1]=mfro+1
				iubFroList[ifro]=ifro
				#if (mfro+1 > maxModule) maxModule=mfro+1
				if (ifro+1 > maxIfro)   maxIfro  =ifro
				if (cfro   > maxCfro)   maxCfro  =cfro
				#thisModuleFroList[cfro]=cfro
				ActorCid[actor[cid],currentMp]=cid
				if (errorStatus != 0) err[cfro]=sprintf("%s (%s)",errorStatus,cellRoTrans[errorStatus])
			}
		}
		#[0].cellRef=84      #cell resourcedata
		#[0].spP=0x094CAC40  #cell resourcedata
		#spData[1]=0x94CAC40:    #cell ccs all
		#[1].spId=0x120010       #cell ccs all
		#1    120010         20          6  001800/sp0.lnh/CommonChMainPT   #cell ccs
		else if ($1 ~ /^\[[0-9]+\]\.cellRef=[0-9]+$/)
		{
			split($1,array,/\]/)
			cellResource[gensub(/^.*=/,"",1,$1)+0,currentMp]=gensub(/\[/,"",1,array[1])+0
			#cellResource[84]=0
		}
		else if ($1 ~ /^\[[0-9]+\]\.spP=0x0*/)
		{
			split($1,array,/\]/)
			spP[gensub(/\[/,"",1,array[1])+0,currentMp]=gensub(/^.*=0x0*/,"",1,$1)
			#spP[0]=94CAC40
		}
		else if ($1 ~ /^spData\[[0-9]+\]=0x0*/)
		{
			spData[gensub(/^.*=0x0*|:$/,"","g",$1),currentMp]=gensub(/^.*\[|\].*$/,"","g",$1)+0
			#spData[94CAC40]=1
			#print gensub(/^.*=0x0*/,"",1,$1) "    "gensub(/^.*\[|\].*$/,"","g",$1)+0
		}
		else if ($1 ~ /^\[[0-9]+\]\.spId=0x0*/)
		{
			spId[gensub(/^.*\[|\].*$/,"","g",$1)+0,currentMp]=gensub(/^.*=0x0*/,"",1,$1)
			#spId[1]=120010
			#print gensub(/^.*\[|\].*$/,"","g",$1)+0 "    "gensub(/^.*=0x0*/,"",1,$1)
		}
		else if ($5 ~ /^[0-9]+\/sp[0-4]\.lnh\/CommonChMainPT$/)
		{
			#spLnh[120010]=001800/sp0.lnh
			spLnh[$2,currentMp]=gensub(/.lnh/,"",1,gensub(/\/Common.*$/,"",1,$5))
			#spNrOfCells[gensub(/\/Common.*$/,"",1,$5)]=$3
			spModule[gensub(/\/Common.*$/,"",1,$5),currentMp]=mpToModule[currentMp]
		}
		#   1.   ulInterference :  int -106
		else if ($1 ~ /^[0-9]+\./ && $2 == "ulInterference" && $3 == ":")
		{
			printExtra=1
			ulInterf[ActorCid[sprintf("1/1/1/1/2/1.%s",gensub(/\./,"",1,$1)),currentMp]]=$5
			#print ActorCid[sprintf("1/1/1/1/2/1.%s",gensub(/\./,"",1,$1)),currentMp]
		}
		#   1.   cellFroId :  int 0
		else if ($1 ~ /^[0-9]+\./ && $2 == "cellFroId" && $3 == ":")
		{
			cellActorFro[sprintf("1/1/1/1/5/5/1.%s",gensub(/\./,"",1,$1)),currentMp]=$5
		}
		#   1.   cellBarred :  int 0
		else if ($1 ~ /^[0-9]+\./ && $2 == "cellBarred" && $3 == ":")
		{
			cellBar[cellActorFro[sprintf("1/1/1/1/5/5/1.%s",gensub(/\./,"",1,$1)),currentMp]]=$5
		}
		#  2.   cellLoadMonitor :  RnhCellLoadMonitorD { totAseDl int 0, totAseDlRnc RnhCellLoadIntArrayD { 25 int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0 }, totAseDlRncDescending RnhCellLoadIntArrayD { 25 int 0, int 1, int 2, int 3, int 4, int 5, int 6, int 7, int 8, int 9, int 10, int 11, int 12, int 13, int 14, int 15, int 16, int 17, int 18, int 19, int 20, int 21, int 22, int 23, int 24 }, totAseUl int 0, totAseUlRnc RnhCellLoadIntArrayD { 25 int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0 }, sfHistogramDlRnc RnhCellLoadHistArrayD { 25 RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 } }, sfHistogramDl RnhCellSfHistogramD { sf8usage int 0, sf16usage int 0, sf32usage int 0 }, filteredDlPwr float 4, estimatedDlPwrDeltaRnc RnhCellLoadFloatArrayD { 25 float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0, float 0 }, estimatedDlPwrDelta float 0, dlCngstState RnhCellCngstStateD 1, ulCngstState RnhCellCngstStateD 1, compMode int 0, compModeRnc RnhCellLoadIntArrayD { 25 int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0, int 0 }, currDlCode int 390, est2 float 0, est3 float 0, cellFroId int 1 }
		else if ($1 ~ /^[0-9]+\./ && $2 == "cellLoadMonitor" && $3 == ":")
		{
			last=split($0,array," ")
			for (i=1;i<=last;i++)
			{
				if (array[i]=="totAseDl") totasedl=gensub(",","",1,array[i+2])+0
				if (array[i]=="totAseUl") totaseul=gensub(",","",1,array[i+2])+0
			}
			totAseDl[ActorCid[sprintf("1/1/1/1/2/1.%s",gensub(/\./,"",1,$1)),currentMp]]=int(totasedl/100)
			totAseUl[ActorCid[sprintf("1/1/1/1/2/1.%s",gensub(/\./,"",1,$1)),currentMp]]=int(totaseul/100)
		}
	}
	close(tgfile)
	for (comb in cellResource)
	{
		split(comb,array,SUBSEP)
		cfro=array[1] ; currentMp=array[2]
		ccDevice[cfro]=spLnh[spId[spData[spP[cellResource[cfro,currentMp],currentMp],currentMp],currentMp],currentMp]
	}
	#for (iubMo in iubMOList) nrOfIubMOs++
	#print "cellResource["0"]="cellResource[0]
	#print "spP[cellResource["0"]]="spP[cellResource[0]]
	#print "spData[spP[cellResource["0"]]]="spData[spP[cellResource[0]]]
	#print "spId[spData[spP[cellResource["0"]]]]="spId[spData[spP[cellResource[0]]]]
	#print "spLnh[spId[spData[spP[cellResource["0"]]]]]="spLnh[spId[spData[spP[cellResource[0]]]]]
	#Mod	MP	UtranCell   IubLink    CellFro    IubFro   CellActor        CCDevice        nrOfCellsOnCC   Comment
	#1	001400	30450601    304506     78         46       1/1/1/1/2/1.89   002300/sp1.lnh  19
	#actor[cid]=actor ; cellFro[cid]=cfro ; iubFro[cid]=ifro ; module[cid]=mfro ; mp[mfro]=currentMp ; moduleList[mfro]=mfro
	#iubFroList[ifro]=ifro ; cellDN[cid]=cellDN ; iubDN[cellDN]=iubDN ; froCid[cfro]=cid ; ifroCid[ifro]=cid ; iubActor[ifro]=iubActor
	#printf("%3s %-6s  %-12s  %-12s  %-6s  %-6s  %-17s  %s\n","MOD","MP","CELL","IUB","CelFRO","IubFRO","CELL ACTOR","IUB ACTOR","CCDEVICE")
	#for (cfro in froCid) print cellDN[froCid[cfro]],cfro,froCid[cfro],iubFro[froCid[cfro]],module[froCid[cfro]]
	if (tgfilter == "")
	{
		for (modNr=0;modNr<=maxModule;modNr++)
		{
			for (ifro=0;ifro<=maxIfro;ifro++)
			{
				for (cfro=0;cfro<=maxCfro;cfro++)
				{
					if (iubFro[froCid[cfro]]==ifro && moduleIub[iubDN[cellDN[froCid[cfro]]]]==modNr)
					{
						defineExtra(cfro)
						customPrint(sprintf("%2s  %-6s  %-12s  %-12s  %4s  %4s  %-14s  %-14s  %2s  %-4s  %3s %3s  %3s %3s  %s  %s  %s",\
moduleIub[iubDN[cellDN[froCid[cfro]]]],mp[module[froCid[cfro]]],cellDN[froCid[cfro]],iubDN[cellDN[froCid[cfro]]],\
cfro,ifro,actor[froCid[cfro]],iubActor[ifro],cellBar[cfro],ulInterf[froCid[cfro]],\
totAseDl[froCid[cfro]],aseDlAdm[froCid[cfro]],totAseUl[froCid[cfro]],aseUlAdm[froCid[cfro]],ccDevice[cfro],spComment[cfro],extra[cfro]))
					}
				}
			}
		}
		customPrint("-------------------------------------------------------------------------------------------------------------------------------")
		customPrint(sprintf("MO  Total: %s cells, %s iubs",nrOfCellMOs,nrOfIubMOs))
		customPrint(sprintf("FRO Total: %s cells, %s iubs",nrOfCellFros,nrOfIubFros))
	}
	else
	{
		if (froCid[tgfilter] != "")
		{
			cfro=tgfilter
			ifro=iubFro[froCid[cfro]]+0
			defineExtra(cfro)
			output=sprintf("%2s  %-6s  %-12s  %-12s  %4s  %4s  %-14s  %-14s  %2s  %-4s  %3s %3s  %3s %3s  %s  %s  %s",\
moduleIub[iubDN[cellDN[froCid[cfro]]]],mp[module[froCid[cfro]]],cellDN[froCid[cfro]],iubDN[cellDN[froCid[cfro]]],\
cfro,ifro,actor[froCid[cfro]],iubActor[ifro],cellBar[cfro],ulInterf[froCid[cfro]],\
totAseDl[froCid[cfro]],aseDlAdm[froCid[cfro]],totAseUl[froCid[cfro]],aseUlAdm[froCid[cfro]],ccDevice[cfro],spComment[cfro],extra[cfro])
			customPrint(output)
			printed[output]=1
		}
		if (ifroCid[tgfilter] !~ /^;$/)
		{
			last=split(ifroCid[tgfilter],array,";")
			for (i=2;i<=last;i++)
			{
				cfro=cellFro[array[i]]
				ifro=iubFro[froCid[cfro]]+0
				defineExtra(cfro)
				output=sprintf("%2s  %-6s  %-12s  %-12s  %4s  %4s  %-14s  %-14s  %2s  %-4s  %3s %3s  %3s %3s  %s  %s  %s",\
moduleIub[iubDN[cellDN[froCid[cfro]]]],mp[module[froCid[cfro]]],cellDN[froCid[cfro]],iubDN[cellDN[froCid[cfro]]],\
cfro,ifro,actor[froCid[cfro]],iubActor[ifro],cellBar[cfro],ulInterf[froCid[cfro]],\
totAseDl[froCid[cfro]],aseDlAdm[froCid[cfro]],totAseUl[froCid[cfro]],aseUlAdm[froCid[cfro]],ccDevice[cfro],spComment[cfro],extra[cfro])
				if (printed[output] != 1) customPrint(output)
			}
		}
	}
}
######################################################################################
function getTimeDiff()
{
	return getTodayLocal() - getTodayUTC()
}
function parseXpLog(l)
{
	if (fileOps("test -s "xp_logfile[l])!=0) return
	while (getline < xp_logfile[l])
	{
		gsub("\r","") ; gsub("\x000","")
		gsub(/\$ /,"")
		if (tolower($4) ~ /^hz/)  $3=sprintf("%shz",$3)
		if      (tolower($1) ~ /^red:/)     red[l]    =gensub(/\(|\)/,"","g",$3)
		else if (tolower($1) ~ /^green:/)   green[l]  =gensub(/\(|\)/,"","g",$3)
		else if (tolower($1) ~ /^(blue.)?yellow:/)  yellow[l] =gensub(/\(|\)/,"","g",$3)
		else if (tolower($1) ~ /^red$/)     red[l]    =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /^green$/)   green[l]  =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /^(blue.)?yellow$/)  yellow[l] =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /_pid/)      pid[l]    =gensub(/^.*=|[ \t]|\x027/,"","g",$0)
		else if (tolower($1) ~ /_rev/)      rev[l]    =gensub(/^.*=|[ \t]|\x027/,"","g",$0)
		else if (tolower($1) ~ /_name/)     name[l]   =gensub(/^.*=|[ \t]|\x027/,"","g",$0)
		else if (tolower($1) ~ /_date/)     pdate[l]  =gensub(/^.*=|[ \t]|\x027/,"","g",$0)
		else if (tolower($1) ~ /_serial/)   serial[l] =gensub(/^.*=|[ \t]|\x027/,"","g",$0)
		else if (tolower($1) ~ /prod.nr/)   pid[l]    =gensub(/^.*:|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.rev/)  rev[l]    =gensub(/^.*:|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.name/) name[l]   =gensub(/^.*:|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.date/) pdate[l]  =gensub(/^.*:|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /serial.nr/) serial[l] =gensub(/^.*:|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /temperature/) temp[l]=$3
		if (/^Unable to connect to|^!!!!Wrong Password|Connection closed by foreign host.|connect[^ ]*: connection timed out|nc6[^ ]*: remote idle timed out/)
		{
			#split (l,array,SUBSEP)
			#printf("%3s  %3s  %-13s  %-10s  %-6s  %-6s  %-6s  %-15s  %-6s  %-12s %-12s  %-4s\n",array[1],
			#array[2],array[3],name[l],green[l],yellow[l],red[l],pid[l],rev[l],
			#pdate[l],serial[l],temp[l])
			done[l]=1
			nr_xp_remaining--
			break
			#print "nr_xp_remaining="nr_xp_remaining,$0
		}
	}
	close(xp_logfile[l])
	if (done[l]>0) delete xp_logfile[l]
}
function getTodayLocal(  date,result)
{
	"date +\"%Y %m %d %H %M %S\"" | getline date
	close ("date +\"%Y %m %d %H %M %S\"")
	result=mymktime(date)
	#print date,result
	return result
}
