######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

#inputs: thresholdsfile (tfile), use_color
BEGIN{
	startup()
}
function split_special(thestring,thearray,thedelimiter,     t_array,n,p)
{
	delete thearray
	if (thestring !~ /^-/) return split(thestring,thearray,thedelimiter)  	# 10-100    (only positive numbers in the range)
	n=split(thestring,t_array,thedelimiter)
	if (n==4) thearray[2]=sprintf("-%s",t_array[4])+0  # -101.5--99.5  (only negative numbers in the range)
	else thearray[2]=t_array[3]+0       # -900-900   (a negative and a positive number in the range)
	thearray[1]=sprintf("-%s",t_array[2])+0
	#print "split_special: "thearray[1],thearray[2]
	return 2
}
function startup(    kpi,operand,yellow,red,mo)
{
	ok=0
	vertical=0
	start=0
	delete limits
	delete kpis
	while (getline < tfile)
	{
		gsub("\r","")
		#KPI/counter ;  operand  ; yellowLimit (optional) ; redLimit 
		#operand can be one of:  > >= < <= = ~ != !~  [] ][
		#one or two limits can be given. If two limits are given then the first limit will correspond to a minor alert and the second to a major alert
		#the threshold can be a number or a string. With string, only the following operands apply: ~ and !~
		#it is also possible to give a range of valid values. The operand for that is [] (alert if kpi is within the range) or ][ (alert if kpi is outside the range)
		
		if ($1~/^#/) continue
		if (NF < 2) continue
		kpi=$1
		operand=$2
		if ($4 ~ /^-?[-0-9.]+$/) { yellow=$3    ; red=$4 ; mo=$5 }
		else                     { yellow="N/A" ; red=$3 ; mo=$4 }
		kpis[kpi]=kpi
		mos[mo]=mo
		kpimos[kpi,mo]=1
		limits[kpi,"op",mo]=operand
		limits[kpi,"yellow",mo]=yellow
		limits[kpi,"red",mo]=red
	}
	close(tfile)
	z=asort(mos)
}	
function compare(kpi,val,mo,   lim,res,array)
{
	res=""
	lim=""
	if (val !~ /^-?[-0-9.]+$/) 
	{
		#string values
		if (limits[kpi,"op",mo] == "~" && val ~ limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
		else if (limits[kpi,"op",mo] == "!~" && val !~ limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
		#we always flag a red alert if the value is N/A
		else if (val == "N/A") { res="2:" ; lim=limits[kpi,"red",mo] }
	}
	else 
	{
		#number values
		val+=0
		if (limits[kpi,"op",mo] == ">")
		{
			if (val > limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A" && val > limits[kpi,"yellow",mo]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
		}
		else if (limits[kpi,"op",mo] == "<")
		{
			if (val < limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A" && val < limits[kpi,"yellow",mo]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
		}
		else if (limits[kpi,"op",mo] == ">=")
		{
			if (val >= limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A" && val >= limits[kpi,"yellow",mo]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
		}
		else if (limits[kpi,"op",mo] == "<=")
		{
			if (val <= limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A" && val <= limits[kpi,"yellow",mo]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
		}
		else if (limits[kpi,"op",mo] == "[]")
		{
			split_special(limits[kpi,"red",mo],array,"-")
			if (val <= array[2] && val >= array[1]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A")
			{
				split_special(limits[kpi,"yellow",mo],array,"-")
				if (val <= array[2] && val >= array[1]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
			}
		}
		else if (limits[kpi,"op",mo] == "][")
		{
			split_special(limits[kpi,"red",mo],array,"-")
			if (val < array[1] || val > array[2]) { res="2:" ; lim=limits[kpi,"red",mo] }
			else if (limits[kpi,"yellow",mo]!="N/A")
			{
				split_special(limits[kpi,"yellow",mo],array,"-")
				if (val < array[1] || val > array[2]) { res="1:" ; lim=limits[kpi,"yellow",mo] }
			}
		}
		else if (limits[kpi,"op",mo] == "=" && val == limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
		else if (limits[kpi,"op",mo] == "!=" && val != limits[kpi,"red",mo]) { res="2:" ; lim=limits[kpi,"red",mo] }
	}
	#print kpi,val,mo,limits[kpi,"op",mo],limits[kpi,"red",mo],limits[kpi,"yellow",mo],res
	if (res!="")
	{
		if (limits[kpi,"yellow",mo]=="N/A") 
		{
			level=""
			if (use_color==1) { col1="\033[1;31m"; col2="\033[0m" }
		}
		else if (res ~ /^2:/) 
		{
			level="Major"
			if (use_color==1) { col1="\033[1;31m"; col2="\033[0m" }
		}
		else if (res ~ /^1:/) 
		{
			level="Minor"
			if (use_color==1) { col1="\033[1;35m"; col2="\033[0m" }			
		}
		res=sprintf("%s%s %sAlert: %s%s=%s (%s%s)",res,col1,level,col2,kpi,val,limits[kpi,"op",mo],lim)
	}
	return res
}
#Start Time: 2012-10-17 16:45:00 End Time: 2012-10-17 16:45:00 Granularity: rop.


#{print}
{last=split($0,array,"; ")}
(last<3){ print $0 ; next}
(ok==0) { 
	for (i in array)
	{
		if (array[i]~/^(Counter|Object)$/) 
		{
			ok=1 #the header has been parsed
			if (array[i]=="Counter") { vertical=1 ; start=i }
			else if (array[i]=="Object") { posMo=i }
		}
	}
	if (vertical==0) 
	{
		delete header
		for (i in array) 
		{
			if (array[i] in kpis) header[i]=array[i]
		}
	}
	print $0
	next
}
(vertical==1) {
	#There is a separate line per KPI
	#Object; Counter; 2012-10-17 16:45; 
	#UtranCell=Iub-1-1; pmCellDowntimeAuto; 0; 
	#; AvgSpeechErlang; 0; 
	#; AvgSpeechErlang; 0; 0; 
	#; AvgSpeechErlang; N/A; N/A; N/A; 
	#MS,Slot=14; MpLoad; 19.1; 
	#MS,Slot=14; MpLoad; 19.1; 19.1; 
	#CcDevice=1 (MS,Slot=19); CcLoad; 4.1; 4.1; 
	#Object; Counter; 2012-10-17 15:00; 2012-10-17 16:00; 
	#UtranCell=Iub-1-1 (Mod=1); Availability; 100; 100; 
	res=""
	t_res=""
	kpi=array[start]
	mo=array[posMo]
	for (j=z;j>=1;j--) 
	{
		neg=0 ; mofilter=mos[j]
		if (mofilter ~ /^!/) { neg=1 ; sub(/^!/,"",mofilter) }
		else if (mofilter ~ /^[^!]+![^!]+$/) { neg=2 ; split(mofilter,part,"!") }
		if (kpimos[kpi,mos[j]]==1 && ((neg==0 && mo~mofilter) || (neg==1 && mo!~mofilter) || (neg==2 && mo~part[1] && mo!~part[2])))
		{
			for (i=start+1;i<=last;i++) 
			{
				t_res=compare(kpi,array[i],mos[j])
				if (t_res!="" && t_res>res) res=t_res
			}
			sub(/^[12]:/,"",res)
			print $0 res
			next
		}
	}
}
{
	#There is several KPIs per line
	#; Object; NoRrcConnReq; NoRrcConnSuc; RrcFail; RrcFailContrib; RrcSuc; 
	#; UtranCell=Iub-1-1 (Mod=1); 183; 183; 0; N/A; 100; 
	#; Object; CS57Drop; CS64Drop; CS64NoRabRel; PSDrop; PsNoRabRel; SpchDrop; SpchNoRabRel; 
	#; ; 0; 0; 154; 9.8; 7766; 0.3; 1077; 
	res=""
        for (i=1;i<=last;i++) 
        {
                if (!(i in header)) continue
                for (j=z;j>=1;j--) 
                { 
			neg=0 ; mofilter=mos[j]
			if (mofilter ~ /^!/) { neg=1 ; sub(/^!/,"",mofilter) }
			else if (mofilter ~ /^[^!]+![^!]+$/) { neg=2 ; split(mofilter,part,"!") }
			if (kpimos[header[i],mos[j]]==1 && ((neg==0 && array[posMo]~mofilter) || (neg==1 && array[posMo]!~mofilter) || (neg==2 && array[posMo]~part[1] && array[posMo]!~part[2])))
                        {
                                _res=compare(header[i],array[i],mos[j])
                                if (_res != "") res=res gensub(/^[12]:/,"",1,_res)
                        }
                }
        }
        print $0 res
}

