BEGIN{ printf("\n%s%s\n",(lhcom=="lh"?sprintf("%-11s  %-9s  ","Position","Board"):""),"Sensor Temperature (alarm limit)") }
mosdebug==1 { print "DEBUG: "$0 }
/commonjars\/connect[^ ]*: connection timed out|Timeout, server .* not responding|nc6[^ ]*: remote idle timed out/{errors=errors"\n"$0 ; next}
lhcom=="lh" && $1 !~ /^[^:]+:$/ { next }
$1 ~ /^[0-9][0-9][0-9][0-9]:$/ && lhcom=="lh" {
	currboard=gensub(/:$/,"",1,$1)
	if (lastboard=="") lastboard=currboard
	if (currboard != lastboard) 
	{
		dumpboard()
		lastboard=currboard
	}
	sub(/^[^:]+: /,"")
}
/(lhsh|rcmd): failed to connect/ { output="NOCONTACT";next }

#FORMAT of boardtemp all:
#Sensor  Degrees Celsius  Alarm Limit  Alarm Cease Limit
#0       39               70           60               
#1       48               70           60               
#2       33               70           60               
#3       64               95           85               
#4       53               95           85     
#Sensor  Degrees Celsius  Alarm Limit  Alarm Cease Limit
#2       30               127          -65              
#SHOULD GIVE :
#  0  26  EPB1       39 (70) 48 (70) 33 (70) 64 (95) 53 (95)


NF==4 && $1~/^[0-9]$/ && $2~/^[0-9]+$/ && $3~/^[0-9]+$/ && $4 ~ /^[-0-9]+$/{
	output=sprintf("%s %3s %5s",output,$2,"("$3")")
}

#Format of temprt all (MSB3):
#Sensor No:              1(UP)     2 (C)    3 (BOT)
#Status [1=alarm]:         0        0       0
#Temperature [C]:         30       25      29
#Thermal Fault threshold: 80 'C
#Thermal Cease threshold: 70 'C

#Carrier temperature (mother board)
#sensor              temperature(C) 
#0                    32
#1                    35
#2                    31

NF==2 && $1~/^[0-9]$/ && $2~/^[0-9]+$/{
	output=sprintf("%s %3s %5s",output,$2,"")
}	
$1=="Temperature" && $2=="[C]:" {
	output=sprintf(" %3s %5s %3s %5s %3s %5s",$3,"",$4,"",$5,"")
}

END{ dumpboard() ; print gensub(/^\n/,"",1,errors) }
function dumpboard()
{
	bdtype=BoardType[lastboard"00"]
	printf("%s%s\n",(lhcom=="lh"?sprintf("%-11s  %-9s  ",lastboard,bdtype):""),output) 
	output=""
}

