#!/usr/bin/perl
# econkel - May 2015 - first draft
# v1.0 - first 90101
# v1.0.1 - PC version
# v1.2 - Cleanup and add standard deviation
# v1.2.1 - try to add some more complex analysis , calculate Nth percentile
# v1.2.2 - quick version to release just to plot
# v1.3.0 - changes due to good information from Mark Harris
# v1.4.0 - big changes, so revision step
# v1.4.1 - more updates and improvements 
# v1.4.2 - more updates, improvements and bug fixes
# v1.4.3 - algorithms agreed on with Mark Harris M, and Dave Wilko, appling them to this version for testing and verification
# v1.5   - new algorithms and thresholds switches (and ROP) included
# v1.5.1 - chaneded format of branch output to reflect distribution counters instead

# Script to check sinr counters for LTE L14B

use strict;
use Data::Dumper;
use Getopt::Long;                                                                      


my $version = "v1.5.1";
my $debug = "none";
my $lowpercentile = 20;
my $medianoffset = 3;   # generate observation if exceeded
#my $widththreshold = 2;    # for testing width of percentiles within sectors for 2Tx4Rx case
my $Tx4byRx4Ratio = 50;    # percentage ratio for 4Tx by 4 Rx case
my $Tx2byRx4Ratio = 65;    # percentage ratio for 2Tx by 4 Rx case

my $variancefault = "SUS VF "; #"SUSPECTED FAULT ";
my $offsetfault = "SUS OF ";

if ($ARGV[1]) {
	$lowpercentile = $ARGV[1] if ($ARGV[1] ne "false");
}

if ($ARGV[2]) {
	$medianoffset = $ARGV[2] if ($ARGV[2] ne "false");
}
if ($ARGV[3]) {
	$Tx2byRx4Ratio = $ARGV[3] if ($ARGV[3] ne "false");
}
if ($ARGV[4]) {
	$Tx4byRx4Ratio = $ARGV[4] if ($ARGV[4] ne "false");
}
my $highpercentile = 100 - $lowpercentile; 
my $lowoffset = 30 - $medianoffset;    # e.g. 27
my $highoffset = 29 + $medianoffset;   # e.g. 32 
my $secpersample = 60;
my %bucket;
&makeBucket;

my $mode;

my %sectorcarrier;

open FH, "<$ARGV[0]" or die "something did not go well\n\n";

while (<FH>) {
    
      if (/nodename\s+\=\s+(.*)/) {
           $mode = $1;
	  }

      #       SectorCarrier=1                                         pmBranchDeltaSinrDistr0 i[115] = 57 0 5 1 4 2 2 3 2 4 1 5 5 6 4 7 8 8 9 9 13 10 15 11 21 12 22 13 22 14 24 15 25 16 48 17 59 18 80 19 91 20 130 21 186 22 194 23 191 24 235 25 237 26 332 27 332 28 369 29 321 30 294 31 255 32 234 33 173 34 157 35 109 36 85 37 62 38 60 39 31 40 35 41 24 42 16 43 17 44 16 45 10 46 5 47 5 48 5 49 4 51 2 52 2 53 3 55 1 56 1 57 1 58 1 
      # SectorCarrier=1                                         pmBranchDeltaSinrDistr4 i[1] = 0 
      #if (/\s?(SectorCarrier\=\S+)\s+(pmBranch\w+)\s+.*\=\s+(.*)/) {
      if (/(.*SectorCarrier\=\S+)\s+(pmBranch\w+)\s+.*\=\s+(.*)/) {
         if (exists $sectorcarrier{$1}{$2}) {
          #  @{$sectorcarrier{$1}{$2}{case2}} = split(/\s+/,$3);
         } else {
            @{$sectorcarrier{$1}{$2}{case1}} = split(/\s+/,$3);
         }
              
      }
      #SectorCarrier=2                                         noOfUsedTxAntennas 2
      #if (/\s?(SectorCarrier\=\S+)\s+(noOfused.*antennas)\s+(\d+)/i) {
      if (/(.*SectorCarrier\=\S+)\s+(noOfused.*antennas)\s+(\d+)/i) {
           $sectorcarrier{$1}{$2} = $3;
      }
	  #Me=WMED15_WEST_MELBOURNE_530125,SectorCarrier=2 [1] = EUtranCellFDD=WMEDEM1
	  #if (/\s?(SectorCarrier\=\S+)\s+\[(\d+)\]\s+\=\s+(EUtranCell.*D\=.*)/i) {
	  if (/(.*SectorCarrier\=\S+)\s+\[(\d+)\]\s+\=\s+(EUtranCell.*D\=.*)/i) {
	             $sectorcarrier{$1}{cells} = $3;
                 $sectorcarrier{$1}{cells} =~  s/EUtranCell.*D\=//gi;
                 #$sectorcarrier{$1}{cells} =~  s/WM//gi;
	  }


# pmx ROP format
# SectorCarrier=1 pmBranchDeltaSinrDistr0 60,0,4,1,2,2,3,3,3,4,4,5,6,6,9,7,9,8,13,9,20,10,25,11,35,12,44,13,57,14,90,15,107,16,135,17,208,18,316,19,509,20,657,21,993,22,1498,23,1985,24,2671,25,3151,26,3630,27,4090,28,4205,29,3744,30,3007,31,2323,32,1772,33,1357,34,1156,35,872,36,750,37,635,38,572,39,483,40,467,41,397,42,452,43,406,44,288,45,213,46,174,47,124,48,112,49,71,50,45,51,48,52,37,53,41,54,24,55,16,56,17,57,13,58,7,59,20
      if (/\s?(SectorCarrier\=\S+)\s+(pmBranch\w+)\s+(.*)/) {
         if (exists $sectorcarrier{$1}{$2}) {
          #  @{$sectorcarrier{$1}{$2}{case2}} = split(/\s+/,$3);
         } else {
            @{$sectorcarrier{$1}{$2}{case1}} = split(/\,/,$3);
         }
              
      }

}
#print Dumper \%sectorcarrier;
#die;

my $savekeyfilter = "NULL"; 
foreach my $key (keys %sectorcarrier) {
    if ($savekeyfilter eq "NULL") {
       $savekeyfilter = $key;# =~ /(\S+)\_pmBranch.*/;
#print "\n\nkkkkkkkkkkk $key\n";
    }
    for (my $i = 0 ; $i < 7 ; $i++ ) {
    	    &initbuckets($i,$key,1,\%sectorcarrier);
    	    &popbuckets($i,$key,1,\%sectorcarrier);
    	    
        #print "send $i to calcdata for $key\n";
        # do not do this now &calcdelta($i,$key,1,\%sectorcarrier);
        # do not do this now &calcdelta($i,$key,2,\%sectorcarrier);
    }

}

print Dumper \%sectorcarrier if ($debug =~ /^esc/);
#print Dumper \%bucket;

#print ",";
#foreach my $key (sort {$a<=>$b} keys %bucket) {
	#print "$bucket{$key}{val},";
#}
#print "\n";

foreach my $key (sort keys %sectorcarrier) {
    
    if ($key !~ /$savekeyfilter/) {
        $savekeyfilter = $key;
        print "\n";
        print ",";
        foreach my $key (sort {$a<=>$b} keys %bucket) {
	    print "$bucket{$key}{val},";
        }
    }
    print "\n";
    for (my $i = 0 ; $i < 7 ; $i++ ) {
         &printbuckets($i,$key,1,\%sectorcarrier);
    }
}


print "\n\n";




# Calculate average and STDEV and Max hit, median etc...
foreach my $key (keys %sectorcarrier) {
    for (my $i = 0 ; $i < 7 ; $i++ ) {
            my $xi = "pmBranchDeltaSinrDistr".$i; 
   	    my $case = "case1";      #only handle case1 for now 
            my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
            my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};            	    
  	    
            if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {            	    
                my $casecount = "casecount1";  	  
    	        $sectorcarrier{$key}{$xi}{obs} = "";
    	        $sectorcarrier{$key}{$xi}{total} = 0;
    	        $sectorcarrier{$key}{$xi}{average} = 0;
    	        $sectorcarrier{$key}{$xi}{std} = 0;
    	        $sectorcarrier{$key}{$xi}{MaxVal} = 0;
    	        $sectorcarrier{$key}{$xi}{MaxIndex} = 0;
    	        for (my $k = 0 ; $k < 60 ; $k++ ) {
    	        	$sectorcarrier{$key}{$xi}{total} += $sectorcarrier{$key}{$xi}{$casecount}[$k];
    	        	if ($sectorcarrier{$key}{$xi}{MaxVal} < $sectorcarrier{$key}{$xi}{$casecount}[$k]) {
    	        		$sectorcarrier{$key}{$xi}{MaxVal} = $sectorcarrier{$key}{$xi}{$casecount}[$k];
    	        		$sectorcarrier{$key}{$xi}{MaxIndex} = $k;
    	        	}
    	        }
                $sectorcarrier{$key}{$xi}{average} = $sectorcarrier{$key}{$xi}{total}/60;   # must count the zero buckets
                my $xVal = 0;
     	        for (my $k = 0 ; $k < 60 ; $k++ ) {
     	        	$xVal +=   ( $sectorcarrier{$key}{$xi}{$casecount}[$k] - $sectorcarrier{$key}{$xi}{average} )**2;
     	        	
   	        }    
   	        $sectorcarrier{$key}{$xi}{std} = sprintf("%.2f",sqrt($xVal/59));

   	        # now we know the total, we can calculate the medina and percentiles
   	        my $lowtot = 0;
   	        my $hightot = 0;
   	        my $medtot = 0;
   	        my $lowfound;
   	        my $medfound;
   	        my $highfound;
   	  	for (my $k = 0 ; $k <  60 ; $k++) {
   	  		if (!$lowfound) {
  	  	  	    $lowtot += $sectorcarrier{$key}{$xi}{casecount1}[$k];
  	  	  	        if ($lowtot >=    ($lowpercentile)*$sectorcarrier{$key}{$xi}{total}/100  ) {
  	  	  	        	$sectorcarrier{$key}{$xi}{lowpercentile} = $k;
  	  	  	        	$lowfound = "true";
  	  	  	        }	        
  	  	  	}
   	  		if (!$medfound) {
  	  	  	    $medtot += $sectorcarrier{$key}{$xi}{casecount1}[$k];
  	  	  	        if ($medtot >=    50*$sectorcarrier{$key}{$xi}{total}/100  ) {
  	  	  	        	$sectorcarrier{$key}{$xi}{median} = $k;
  	  	  	        	$medfound = "true";
  	  	  	        }	        
  	  	  	}  
   	  		if (!$highfound) {
  	  	  	    $hightot += $sectorcarrier{$key}{$xi}{casecount1}[$k];
  	  	  	        if ($hightot >=    ($highpercentile)*$sectorcarrier{$key}{$xi}{total}/100  ) {
  	  	  	        	$sectorcarrier{$key}{$xi}{highpercentile} = $k;
  	  	  	        	$highfound = "true";
  	  	  	        }	        
  	  	  	}  	  	  	
    	        }

    	            	        
    	    }    # if case1 stuff > 0
    }
}


# apply percentile WIDTH rules for each config

foreach my $key (keys %sectorcarrier) {
    my $dist0gap = $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{highpercentile}}{val} - $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{lowpercentile}}{val};
    my $dist1gap = $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{highpercentile}}{val} - $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{lowpercentile}}{val};
    my $dist2gap = $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{highpercentile}}{val} - $bucket{$sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{lowpercentile}}{val};
    my $abnormal = "";    
    if ( ($sectorcarrier{$key}{noOfUsedRxAntennas} eq 2 ) && (	$sectorcarrier{$key}{noOfUsedTxAntennas}  eq 2) ) {
           # no variance algorithm applied to 2x2 case
    	   #my @sorted = sort {$b <=> $a} ($dist0gap,$dist1gap,$dist2gap);
    	   ##print Dumper \@sorted;
    	   #my $gapA = $sorted[0] - $sorted[1];
    	   #my $gapB = $sorted[1] - $sorted[2];
    	   ##print "gaps $gapA and $gapB\n";
    	   #@sorted = sort {$b <=> $a} ($gapA,$gapB);
    	   ##print Dumper \@sorted;
    	   #if ( ($sorted[0] - $sorted[1]) >   $widththreshold) {
    	   #	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
    	   #	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;
    	   #	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault."gg";
    	   #}
    	    
    }

    if ( ($sectorcarrier{$key}{noOfUsedRxAntennas} eq 4 ) && (	$sectorcarrier{$key}{noOfUsedTxAntennas}  eq 2) ) {
	     print "4by2 found for key $key\n" if ($debug eq "obs");
	
         #if ( ($dist1gap - $dist0gap)   >  $widththreshold ) {
    	 #   	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
     	 #   	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;
        #	 print "1gt0 gaps 012 $dist0gap $dist1gap $dist2gap $widththreshold \n" if ($debug eq "obs");
         #}
         #if ( ($dist1gap - $dist2gap)   >  $widththreshold ) {
    	 #   	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault;
     	 #   	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;
         #	 print "1gt2 gaps 012 $dist0gap $dist1gap $dist2gap $widththreshold \n" if ($debug eq "obs");
       	 #
         #}  
         my @sorted = sort {$b <=> $a} ($dist0gap,$dist1gap,$dist2gap);
		 print Dumper \@sorted if ($debug eq "obs");
         #if ( ( ($sorted[0] - $sorted[1])   >  $widththreshold ) || (($sorted[1] - $sorted[2]) >  $widththreshold  )  ) {
    	    	    #$sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault;
     	    	    #$sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
         	 #print "$key sorted 0-1 gaps 012 $dist0gap $dist1gap $dist2gap $widththreshold \n" if ($debug eq "obs");
        	# 
         #}           

         # apply percentage algorithm to 4by2 TxbyRx case
                 print Dumper \%sectorcarrier if ($debug eq "pmxadded");
                 print "and key found was $key\n\n" if ($debug eq "pmxadded");
		 print Dumper \@sorted if ($debug eq "variance");
         my $sort1over0 =  ($sorted[1] / $sorted[0])*100 if ($sorted[0] ne 0);
         my $sort2over1 =  ($sorted[2] / $sorted[1])*100 if ($sorted[1] ne 0);
         print "sorted ratio $sort1over0  from $sorted[1] and $sorted[0] AND $sort2over1\n" if ($debug eq "variance");
         if ($sorted[0] ne 0) {
           #if ( (   ($sorted[1] / $sorted[0])*100  < (100 - $Tx2byRx4Ratio) )   ||  ( ($sorted[2] / $sorted[1])*100 < ( 100 - $Tx2byRx4Ratio ) ) )  {
           if ( (   ($sorted[1] / $sorted[0])*100  <  $Tx2byRx4Ratio )   ||  ( ($sorted[2] / $sorted[1])*100 <  $Tx2byRx4Ratio  ) )  {
    	    	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
    	    	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;
    	    	    $sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault;
           }
         }


    }
    if ( ($sectorcarrier{$key}{noOfUsedRxAntennas} eq 4 ) && (	$sectorcarrier{$key}{noOfUsedTxAntennas}  eq 4) ) {
	     print "4by4 found for key $key\n" if ($debug eq "obs");
		 
         # let dist1gap be 100%
         my $r0over1 =  ($dist0gap/$dist1gap)*100;
         my $r2over1 =  ($dist2gap/$dist1gap)*100;
         print "ratio printing $r0over1 and $r2over1 gaps 012 $dist0gap $dist1gap $dist2gap\n" if ($debug eq "variance");
         if (  ($dist0gap/$dist1gap)*100  > $Tx4byRx4Ratio ) {
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;		 
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= "0over1" if ($debug eq "variance");		 
         }
         if (  ($dist2gap/$dist1gap)*100  > $Tx4byRx4Ratio ) {
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault;
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;		 
             $sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= "2over1" if ($debug eq "variance");		 
         }
         # old algorithm, too hard and fast, decided to use % ratio above
         #if ( ($dist1gap <  $dist0gap)    ) {
             #$sectorcarrier{$key}{pmBranchDeltaSinrDistr0}{obs} .= $variancefault;
             #$sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;		 
		 #}
         #if ( ($dist1gap <  $dist2gap)    ) {
             #$sectorcarrier{$key}{pmBranchDeltaSinrDistr2}{obs} .= $variancefault;
             #$sectorcarrier{$key}{pmBranchDeltaSinrDistr1}{obs} .= $variancefault;		 
		 #}

           
    }
} 	




# Print out the data
my @row;
format STDOUT =
#seccarbranch noRx/Tx Tot       Med         High      Lowprec  Highprec  Width  OBSERVATION     CELLS
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<@<<<<<<<<<@<<<<<<<@<<<<<<<<@<<<<<<<@<<<<<<@<<<<<@<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<
@row
.

if ($mode !~ /MULTI/) {

    print "$mode\n";
}

@row = ("Branch","Tx\/Rx","Tot","Median","Highest","$lowpercentile"."perc","$highpercentile"."perc","Width","OBSERVATION","Cells");	
$~ = "STDOUT";
write;

foreach my $key (sort keys %sectorcarrier) {
    for (my $i = 0 ; $i < 7 ; $i++ ) {
            my $xi = "pmBranchDeltaSinrDistr".$i; 
   	    my $case = "case1";      #only handle case1 for now 
            my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
            my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};            	    
  	    
            if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {  
            	my ($printSecCar) = $key =~ /\w+\=(\S+)/;
            	my $p1 = $i + 1;
            	my $p2 = $i + 2;
            	my $pBran = $p1."\-".$p2;
                my $pBran = "Dist".$i;   # change to dist format
            	#my $Pwidth = $bucket{$sectorcarrier{$key}{$xi}{R_precentileIndex}}{val} - $bucket{$sectorcarrier{$key}{$xi}{L_precentileIndex}}{val};
            	my $Pwidth = $bucket{$sectorcarrier{$key}{$xi}{highpercentile}}{val} - $bucket{$sectorcarrier{$key}{$xi}{lowpercentile}}{val};
            	my $obs = "";
                #if ( ($sectorcarrier{$key}{$xi}{median} < $lowoffset ) ||   ($sectorcarrier{$key}{$xi}{median} > $highoffset  ) ) {
                if  ($sectorcarrier{$key}{$xi}{median} < $lowoffset ) {
                	$sectorcarrier{$key}{$xi}{obs} .= $offsetfault;
                }
                if ( $sectorcarrier{$key}{$xi}{median} > $highoffset   ) {
                	$sectorcarrier{$key}{$xi}{obs} .= $offsetfault;
                }
          	
   	        #@row = ("SC".$printSecCar."_Br_".$pBran, $sectorcarrier{$key}{noOfUsedTxAntennas}."\/".$sectorcarrier{$key}{noOfUsedRxAntennas},   $sectorcarrier{$key}{$xi}{total}, $bucket{$sectorcarrier{$key}{$xi}{median}}{val}, $sectorcarrier{$key}{$xi}{MaxVal}."\(".$bucket{$sectorcarrier{$key}{$xi}{MaxIndex}}{val}."\)",$bucket{$sectorcarrier{$key}{$xi}{lowpercentile}}{val},$bucket{$sectorcarrier{$key}{$xi}{highpercentile}}{val},$Pwidth,$sectorcarrier{$key}{$xi}{obs} ,$sectorcarrier{$key}{cells} );
   	        @row = ("SC".$printSecCar."_Br".$pBran, $sectorcarrier{$key}{noOfUsedTxAntennas}."\/".$sectorcarrier{$key}{noOfUsedRxAntennas},   $sectorcarrier{$key}{$xi}{total}, $bucket{$sectorcarrier{$key}{$xi}{median}}{val}, $bucket{$sectorcarrier{$key}{$xi}{MaxIndex}}{val},$bucket{$sectorcarrier{$key}{$xi}{lowpercentile}}{val},$bucket{$sectorcarrier{$key}{$xi}{highpercentile}}{val},$Pwidth,$sectorcarrier{$key}{$xi}{obs} ,$sectorcarrier{$key}{cells} );
   	        write;            	    
            }
    }
    @row = ("");
    write;
}
print "\n\nPercentiles $lowpercentile and $highpercentile  - parameter p-N, where N is a number for the lower percentile, upper is auto calculated\n";
#print "2Tx by 4 Rx Percentile width threshold $widththreshold  - parameter o-N, where N is a number\n";
print "Offset from median threshold $medianoffset  - parameter o-N \n";
print "2Tx by 4Rx variance ratio threshold $Tx2byRx4Ratio - parameter 2tx-N\n";
print "4Tx by 4Rx variance ratio threshold $Tx4byRx4Ratio - parameter 4tx-N\n";
print "for example, can issue command \"run asm.mos  0-2 p-10  2tx-45  4tx-55\"\n";
print "to execute the script on the previoud ROP period, add the parameter \"rop\"\n";
print "\nWhile the thresholds are under analysis, it is advised to plot the data per sector\nIn case the algorithm misses a suspected fault\n";


print Dumper \%sectorcarrier if ($debug =~ /^sc/);




sub printbuckets {
  my $xi = "pmBranchDeltaSinrDistr".$_[0];
  my $key = $_[1];
  my $case = "case".$_[2];
  my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
  my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};
  if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {
    my $casecount = "casecount".$_[2]; 
	my $pkey = $key;
    $pkey =~ s/\,/\_/g;	
    $pkey =~ s/Me=//g;	
    print $pkey."_".$xi.",";
    for (my $k = 0 ; $k < 60 ; $k++) {
        print "$sectorcarrier{$key}{$xi}{$casecount}[$k],";
    }
    print "\n";
  }
  
}

sub initbuckets {
	
  my $xi = "pmBranchDeltaSinrDistr".$_[0];
  my $key = $_[1];
  my $case = "case".$_[2];
  my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
  my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};
  if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {
    my $casecount = "casecount".$_[2];
    #print "$key $casecount is here\n";
    for (my $k = 0 ; $k < 60 ; $k++) {
      if (not exists $sectorcarrier{$key}{$xi}{$casecount}[$k]) {
          #print "not exists $key $k $xi $case $casecount\n";
          $sectorcarrier{$key}{$xi}{$casecount}[$k] = 0; 
      }
    }
  }# else {
   # 	    	    # here I've decided to delete unused branches
   # 	    	    print "init deleteing $key for $xi \n\n";
   # 	    	    #delete $sectorcarrier{$key}{$xi};  	  
  #}
}

sub popbuckets {
	
  my $xi = "pmBranchDeltaSinrDistr".$_[0];
  my $key = $_[1];
  my $case = "case".$_[2];
  my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
  my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};
  if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {
    my $casecount = "casecount".$_[2];
    for (my $j = 1 ; $j < @{$sectorcarrier{$key}{$xi}{$case}}  ; $j++) {
         $j++;
         #print "need this printed $key $j $xi  $sectorcarrier{$key}{$xi}{$case}[$j] $sectorcarrier{$key}{$xi}{$case}[$j-1] \n";
         $sectorcarrier{$key}{$xi}{$casecount}[$sectorcarrier{$key}{$xi}{$case}[$j-1]] = $sectorcarrier{$key}{$xi}{$case}[$j];
         #print "then we have for casecount $casecount and counter $xi  $sectorcarrier{$key}{$casecount}[$sectorcarrier{$key}{$xi}{$case}[$j-1]]\n";
         #print Dumper \%sectorcarrier;
         #print "ggggg index $sectorcarrier{$key}{$xi}{$case}[$j-1] stored  $sectorcarrier{$key}{$casecount}[$sectorcarrier{$key}{$xi}{$case}[$j-1]] = $sectorcarrier{$key}{$xi}{$case}[$j]\n";;
    }
    
    
  }
}


sub calcdelta {
  my $xi = "pmBranchDeltaSinrDistr".$_[0];
  my $key = $_[1];
  my $case = "case".$_[2];
  my $temp =  \@{$sectorcarrier{$key}{$xi}{$case}};
  my $arraysize = @{$sectorcarrier{$key}{$xi}{$case}};
  #print Dumper \@{$sectorcarrier{$key}{$xi}{$case}};
  if (@{$sectorcarrier{$key}{$xi}{$case}} > 1) {
    my $casecount = "casecount".$_[2];
    for (my $k = 0 ; $k < 60 ; $k++) {
      if (not exists $sectorcarrier{$key}{$xi}{$casecount}[$k]) {
          #print "not exists $key $k $xi $case $casecount\n";
          $sectorcarrier{$key}{$xi}{$casecount}[$k] = 0; 
      } else {
          #print "actually exists $key $k $xi $case $casecount\n";
      }
    }




    for (my $j = 1 ; $j < @{$sectorcarrier{$key}{$xi}{$case}}  ; $j++) {
         $j++;
         ##print "need this printed $key $j $xi  $sectorcarrier{$key}{$xi}{$case}[$j] $sectorcarrier{$key}{$xi}{$case}[$j-1] \n";
         $sectorcarrier{$key}{$casecount}[$sectorcarrier{$key}{$xi}{$case}[$j-1]] = $sectorcarrier{$key}{$xi}{$case}[$j];
         #print "ggggg index $sectorcarrier{$key}{$xi}{$case}[$j-1] stored  $sectorcarrier{$key}{$casecount}[$sectorcarrier{$key}{$xi}{$case}[$j-1]] = $sectorcarrier{$key}{$xi}{$case}[$j]\n";;
    }
  }

}
#d271549@xxwiy90101 ~/tools/SINR $ cat buckets | perl -ne '{if (/(\w+)\s+(.*)/) {print "\$bucket{$1}{val} = $2\;\n";}}'
sub makeBucket {
$bucket{0}{val} = -29.5;
$bucket{1}{val} = -28.5;
$bucket{2}{val} = -27.5;
$bucket{3}{val} = -26.5;
$bucket{4}{val} = -25.5;
$bucket{5}{val} = -24.5;
$bucket{6}{val} = -23.5;
$bucket{7}{val} = -22.5;
$bucket{8}{val} = -21.5;
$bucket{9}{val} = -20.5;
$bucket{10}{val} = -19.5;
$bucket{11}{val} = -18.5;
$bucket{12}{val} = -17.5;
$bucket{13}{val} = -16.5;
$bucket{14}{val} = -15.5;
$bucket{15}{val} = -14.5;
$bucket{16}{val} = -13.5;
$bucket{17}{val} = -12.5;
$bucket{18}{val} = -11.5;
$bucket{19}{val} = -10.5;
$bucket{20}{val} = -9.5;
$bucket{21}{val} = -8.5;
$bucket{22}{val} = -7.5;
$bucket{23}{val} = -6.5;
$bucket{24}{val} = -5.5;
$bucket{25}{val} = -4.5;
$bucket{26}{val} = -3.5;
$bucket{27}{val} = -2.5;
$bucket{28}{val} = -1.5; #"-2..-1"; # 
$bucket{29}{val} = -0.5; #"-1..0"; # 
$bucket{30}{val} = 0.5; "0..1"; # 
$bucket{31}{val} = 1.5;
$bucket{32}{val} = 2.5;
$bucket{33}{val} = 3.5;
$bucket{34}{val} = 4.5;
$bucket{35}{val} = 5.5;
$bucket{36}{val} = 6.5;
$bucket{37}{val} = 7.5;
$bucket{38}{val} = 8.5;
$bucket{39}{val} = 9.5;
$bucket{40}{val} = 10.5;
$bucket{41}{val} = 11.5;
$bucket{42}{val} = 12.5;
$bucket{43}{val} = 13.5;
$bucket{44}{val} = 14.5;
$bucket{45}{val} = 15.5;
$bucket{46}{val} = 16.5;
$bucket{47}{val} = 17.5;
$bucket{48}{val} = 18.5;
$bucket{49}{val} = 19.5;
$bucket{50}{val} = 20.5;
$bucket{51}{val} = 21.5;
$bucket{52}{val} = 22.5;
$bucket{53}{val} = 23.5;
$bucket{54}{val} = 24.5;
$bucket{55}{val} = 25.5;
$bucket{56}{val} = 26.5;
$bucket{57}{val} = 27.5;
$bucket{58}{val} = 28.5;
$bucket{59}{val} = 29.5;
}


__END__

SectorCarrier             pmBranchDeltaSinrDistr0                                            sequence:long [60]   PDF,ropReset
------------------------------------------------------------------------------------------------------------------------------------
The purpose of the measurement is to monitor the antenna status and detect the faulty antenna in antenna branch pair 0.
The measurement is the SINR difference of PUSCH channel between antenna branch A and antenna branch B in antenna branch pair 0.
PDF ranges:
[0]: =< -29 dB
[1]: ]-29..-28] dB
[2]: ]-28..-27] dB
...
[29]: ]-1..0] dB
[30]: ]0..1] dB
[31]: ]1..2] dB
...
[57]: ]27..28] dB
[58]: ]28..29] dB
[59]: > 29 dB
Compressed: true.
Condition: Each sample steps up one bin counter increment but it depends on  the measurement results to determine which bin counter is incremented. If the bin measurement value falls, the bin counter increments. This counter is used for antenna branch pair 0 with antenna branch A and B.
Counter type: PDF
Sampling rate: Internal attribution: LOCAL_PER_BB_SECTORCARRIER_EVENT; currently, it is 60 seconds per sample
Scanner: Not included in any predefined scanner
Counter is reset after measurement period: Yes
Unit: -
MinLength=0 MaxLength=60
