#!/usr/bin/perl
# econkel for KSD project 2011
# very specific to the counter pmRadioRecInterferencePwr
# added revision 1.1  
#              v1.1 added a percentage column
#              v1.2 included a caluclation of the average UL INT for the duration
#              v2.0 included PRB interferene counters
#              v2.1 included PUCCH counter
#              v3.0 included individual PRB calculations as a unit of power instead of just percentage
#              v3.1 bug fix, PRN listing only three cells
#              V4.0 try to merge faults over many versions,

use strict 'vars';
use Data::Dumper;
use warnings;

my $debug = 0;
my $timedelta = "not known";
#my $unit = 2/(10**48); # Unit: mW * 2^(-48)# older s/w
my $unit = 2/(10**44); # Unit: mW * 2^(-44)
my $maxcells = 6;
my $badflag;
my $i;
my $key;

my $prbmax = 2147483647;
my $prbmaxflag = "false";
my $prbmaxstring;

my $sampleUnit   = 2**(-48);     # as per  pmom for counters pmRadioRecInterferencePwrPrb 


my %inthash;
$inthash{0}{level} = " N+I <= -121";
$inthash{1}{level} = " -121 < N+I <= -120";
$inthash{2}{level} = " -120 < N+I <= -119";
$inthash{3}{level} = " -119 < N+I <= -118";
$inthash{4}{level} = " -118 < N+I <= -117";
$inthash{5}{level} = " -117 < N+I <= -116";
$inthash{6}{level} = " -116 < N+I <= -115";
$inthash{7}{level} = " -115 < N+I <= -114";
$inthash{8}{level} = " -114< N+I <= -113";
$inthash{9}{level} = " -113 < N+I <= -112";
$inthash{10}{level} = " -112 < N+I <= -108";
$inthash{11}{level} = " -108 < N+I <= -104";
$inthash{12}{level} = " -104 < N+I <= -100";
$inthash{13}{level} = " -100 < N+I <= -96";
$inthash{14}{level} = " -96 < N+I <= -92";
$inthash{15}{level} = " -92 < N+I";


# This hash table is vital to the outcome, use the values from the MOM for the counter pmRadioRecInterferencePwr
# to determine the value chose for the bucket
#
my %BucketMap = (
 "0",-121.5,
 "1",-120.5,
 "2",-119.5,
 "3",-118.5,
 "4",-117.5,
 "5",-116.5,
 "6",-115.5,
 "7",-114.5,
 "8",-113.5,
 "9",-112.5,
 "10",-110,
 "11",-106,
 "12",-102,
 "13",-98,
 "14",-94,
 "15",-91,
 );
my %mWattsMap;
foreach my $mkeys (keys %BucketMap) {

     $mWattsMap{$mkeys} =  10**($BucketMap{$mkeys}/10);
}
print Dumper \%mWattsMap if ($debug == 1);
if ($debug == 2) {
   foreach my $dkey (sort keys %mWattsMap) {
       print "$dkey   $mWattsMap{$dkey}\n";
   }
}

my %cellhash;
my %prbcell;



open FH, "<$ARGV[0]" or die "something did not go well\n\n";

while (<FH>) {

      if (/EUtranCell.*\=(.*?)\s+pmRadioRecInterferencePwr\s+.*\=\s+(.*)/i) {
           my @array = split('\s+',$2);
          if (exists $cellhash{$1}) {
              $cellhash{$1}{second} =[  @array ];

          } else {
              $cellhash{$1}{first} = [ @array ];

          }

      }
    # pmRadioRecInterferencePwrPucch
      if (/EUtranCell.*\=(.*?)\s+pmRadioRecInterferencePwrPucch\s+.*\=\s+(.*)/i) {
      
           my @array = split('\s+',$2);
          if (exists $cellhash{$1." pucch"}) {
              $cellhash{$1." pucch"}{second} =[  @array ];

          } else {
              $cellhash{$1." pucch"}{first} = [ @array ];

          }

      }


     # VIC_WMED15_WEST_MELBOURNE_530125> wait 30
      if (/wait\s+(\d+)/) {
         $timedelta = $1;

      }


       # handle PRB counters
       #EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPrb88 0
       #EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPrb89 0
       #EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPrb9 152288480
       #EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPrb90 0

      if (/EUtranCell.*\=(.*?)\s+pmRadioRecInterferencePwrPrb(\d+)\s+(.*)/i) {
          my $v1 = $1;
          my $v2 = $2;
          my $v3 = $3;
          if (exists $prbcell{$v1}{$v2} ) {
              if ($v3 =~ /\-2/) {
                $prbcell{$v1}{$v2}{valid} = "BAD"; 
                $prbcell{$v1}{prbsecond}[$v2] = $v3; 
                $prbcell{$v1}{prbdelta}[$v2] = "SUSPECT";
                $badflag = "TRUE";
              } else {
                $prbcell{$v1}{prbsecond}[$v2] = $v3; 
                $prbcell{$v1}{prbdelta}[$v2]  = $prbcell{$v1}{prbsecond}[$v2] - $prbcell{$v1}{prbfirst}[$v2]; 
                if ($prbcell{$v1}{prbdelta}[$v2] < 0 ) {
                             $prbcell{$v1}{prbdelta}[$v2]  = $prbcell{$v1}{prbsecond}[$v2]; 
                }
                if ($prbcell{$v1}{prbfirst}[$v2] == $prbmax) {
                    $prbmaxflag = "true";
                    $prbmaxstring .= "\ncell $v1 hit max for PRB counter for PRB $v2\n";
                }
 
              }
              
          } else {
              if ($v3 =~ /^\-2/) {
                $prbcell{$v1}{$v2}{valid} = "BAD"; 
                $prbcell{$v1}{prbfirst}[$v2] = $v3; 
                $badflag = "TRUE";
              } else {
                $prbcell{$v1}{$v2}{valid} = "found"; 
                $prbcell{$v1}{prbfirst}[$v2] = $v3; 
              }

          }
      }


}


my $sum = 0;
my $totintcount = 0;
foreach  $key (keys %cellhash) {
$totintcount = 0;
      for (my $i =0 ; $i < 16 ; $i++) {
         $totintcount += ($cellhash{$key}{second}[$i] - $cellhash{$key}{first}[$i]);
      }
      $cellhash{$key}{totintcount} = $totintcount;
      $totintcount = 0;


      my $tot = 0;
      for (my $i = 0 ; $i < 16  ; $i++) {
           my $tmp =  ($cellhash{$key}{second}[$i]   -   $cellhash{$key}{first}[$i])*$mWattsMap{$i};
           $tot += $tmp;
           $sum += ($cellhash{$key}{second}[$i] - $cellhash{$key}{first}[$i]);
      }
      if ($sum ne 0) { 
      print "cell $key sum ne 0  $sum \n" if ($debug == 1);
      my $tavg = $tot/$sum;
      my $avgdBm = 10 * (log($tavg)/log(10));
      $cellhash{$key}{avgdBm} = sprintf ("%.2f",$avgdBm);
      $cellhash{$key}{values} = $_;
      $cellhash{$key}{tot} = $tot;
      $cellhash{$key}{sum} = $sum;
      $cellhash{$key}{tavg} = $tavg;
      $sum = 0; 
     # 
      }


}


print Dumper \%prbcell if ($debug == 3);



# determine if we have had overlap
my $overlapflag = 0;

foreach my  $key (keys %cellhash) {
    if ($cellhash{$key}{totintcount} < 0 ) {
        $overlapflag++;
    }
}

if ($overlapflag > 0 ) {
   $sum = 0;
   $totintcount = 0;
   foreach $key (keys %cellhash) {
   $totintcount = 0;
         for ($i =0 ; $i < 16 ; $i++) {
            $totintcount += $cellhash{$key}{second}[$i];
         }
         $cellhash{$key}{totintcount} = $totintcount;
         $totintcount = 0;
   
   
         my $tot = 0;
         for ($i = 0 ; $i < 16  ; $i++) {
              my $tmp =  ($cellhash{$key}{second}[$i])*$mWattsMap{$i};
              $tot += $tmp;
              my $sum += $cellhash{$key}{second}[$i];
         }
         if ($sum ne 0) { 
         print "cell $key sum ne 0  $sum \n" if ($debug == 1);
         my $tavg = $tot/$sum;
         my $avgdBm = 10 * (log($tavg)/log(10));
         $cellhash{$key}{avgdBm} = sprintf ("%.2f",$avgdBm);
         $cellhash{$key}{values} = $_;
         $cellhash{$key}{tot} = $tot;
         $cellhash{$key}{sum} = $sum;
         $cellhash{$key}{tavg} = $tavg;
         $sum = 0; 
        # 
         }
   
   
   }

}


foreach my $key (keys %prbcell) {
       $prbcell{$key}{totcount} = 0;
       for (my $i = 0 ; $i < 102 ; $i++ ) {
             if (exists $prbcell{$key}{$i}) {


                   if ($prbcell{$key}{prbdelta}[$i] eq "SUSPECT" ) {
                       $badflag = "TRUE";
                   } else {
                       if ($prbcell{$key}{prbdelta}[$i] ne 0) {
                        $prbcell{$key}{totcount} +=  $prbcell{$key}{prbdelta}[$i];
                       }
                   }

             } else {
     
             }
       }

}

my $noOfcells = 0;


my $prbtoprint;
foreach my $key (keys %prbcell) {
	$noOfcells++;
                   $prbcell{$key}{prbCount} = 0;  
       for ($i = 0 ; $i < 102 ; $i++ ) {
             if (exists $prbcell{$key}{$i}) {
                 if ($prbcell{$key}{prbdelta}[$i] ne "SUSPECT" ) {
                   if ($prbcell{$key}{prbdelta}[$i] > 0) {
                        $prbtoprint = "true";
                              $prbcell{$key}{percent}[$i]  =  sprintf ("%.2f",($prbcell{$key}{prbdelta}[$i] / $prbcell{$key}{totcount} ) * 100);
                              $prbcell{$key}{prbCount}++;  
                   } else {
                   }

                 } else {
                              $badflag = "TRUE";

                              $prbcell{$key}{percent}[$i]  = "SUSPECT";
                 }
             }
       }

}





my @outputline;
format OUTTEXT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@outputline
.

my $index = 0;
foreach $key (keys %cellhash) {

    #print "$key   pmRadioRecInterferencePwr    delta     lastvalue\n";
    print "\n\n";
    @outputline = ("$key","pmRadioRecInterferencePwr","\%Contrib","delta","lastvalue");
    $~ = OUTTEXT;
    write;

my $tpercent;
      for ( $i =0 ; $i < 16 ; $i++) {
         #print "    $inthash{$i}{level}     vvvvv   $cellhash{$key}{second}[$i] \n";
         $tpercent = 0;
         my $delta;
         if ($overlapflag > 0 ) {
                $tpercent = sprintf("%.3f",100*($cellhash{$key}{second}[$i])/$cellhash{$key}{totintcount});
                $delta = $cellhash{$key}{second}[$i];
         } else {
            if (($cellhash{$key}{second}[$i] - $cellhash{$key}{first}[$i]) ne "0" ) {
                $tpercent = sprintf("%.3f",100*($cellhash{$key}{second}[$i] - $cellhash{$key}{first}[$i])/$cellhash{$key}{totintcount});
                $delta = $cellhash{$key}{second}[$i] - $cellhash{$key}{first}[$i];
            } else {
                $tpercent = 0;
                $delta = 0;
            }
         }
         @outputline= (" ",$inthash{$i}{level}, $tpercent  ,$delta , $cellhash{$key}{second}[$i]);
         $~ = OUTTEXT;
         write;


      }

}


#my @prbarray = ("","","","","","","");    # only handles 6 cells
my @prbarray = ("","","","","","","","","","","","","");     #handle 12 cells - really need a better solution, but for now....
if ($noOfcells eq 1) {
format PRB1 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.
} 
if ($noOfcells eq 2) {
format PRB2 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
} 
if ($noOfcells eq 3) {
format PRB3 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
} 
if ($noOfcells eq 4) {
format PRB4 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
} 
if ($noOfcells eq 5) {
format PRB5 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
} 
if ($noOfcells eq 6) {
format PRB6 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.			
} 
if ($noOfcells eq 7) {
format PRB7 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}
if ($noOfcells eq 8) {
format PRB8 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}if ($noOfcells eq 9) {
format PRB9 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}if ($noOfcells eq 10) {
format PRB10 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}if ($noOfcells eq 11) {
format PRB11 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}if ($noOfcells eq 12) {
format PRB12 =
@<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<
@prbarray;
.		
}	
#print Dumper \%prbcell;

foreach my $nkey (keys %prbcell) {
  print "\nprocessing here $nkey \n" if ($debug eq "2"); 
                 $prbcell{$nkey}{average} = $prbcell{$nkey}{totcount}/$prbcell{$nkey}{prbCount} if ($prbcell{$nkey}{prbCount} > 0);
                 if (exists $cellhash{$nkey}) {
                   $prbcell{$nkey}{T} = $prbcell{$nkey}{average} * $sampleUnit / 10**($cellhash{$nkey}{avgdBm}/10);
                print "bbbb                   $prbcell{$nkey}{T}  $prbcell{$nkey}{average}  $sampleUnit  $cellhash{$nkey}{avgdBm} \n" if ($debug eq "4");
                       for ($i = 0 ; $i < 102 ; $i++ ) {
                          if (exists $prbcell{$nkey}{$i}) {
                             
                            if ($prbcell{$nkey}{prbdelta}[$i] ne "SUSPECT" ) {
                              if ($prbcell{$nkey}{prbdelta}[$i] > 0) {
                                         $prbcell{$nkey}{PRBdBm}[$i]  =  sprintf ("%.2f",(10*log($prbcell{$nkey}{prbdelta}[$i]*$sampleUnit/$prbcell{$nkey}{T})/log(10)));
                              } 

 
                            }
                          }
                       }
                 }
}



print Dumper \%prbcell if ($debug == 4);
print Dumper \%cellhash if ($debug == 9);



if ($prbtoprint) {
     print "\n\nEstimation of interference per PRB\n";
     $prbarray[0] = "PRB";
     my $ind = 1;
     foreach  $key (keys %prbcell) {
               #print "KEY $key    \n";
                $prbarray[$ind] = $key;
                 $ind++;
     }
     for ($i = $ind ; $i le $noOfcells  ; $i++ ) {
                $prbarray[$i] = "";
     }
      $~ = PRB.$noOfcells;
      write;
      @prbarray = ("","","","","","","");
#      print "\n";
      for (my $i = 0 ; $i < 102 ; $i++ ) {
             my $printi = 0;
             #$ind;
          foreach  $key (keys %prbcell) {
             if (exists $prbcell{$key}{$i}) {
                   if ($prbcell{$key}{prbdelta}[$i] ne 0) {
                     #print "\n$i   "if ($printi eq 0);
                     if ($printi eq 0) {
#                        $~ = PRB;
#                        write;
                        #print "\n";
                        $prbarray[0] = "$i";
                        $printi = 1;
                        $ind = 1;
                     }
                     #print "$prbcell{$key}{percent}[$i]     ";
                     #$prbarray[$ind] =  $prbcell{$key}{percent}[$i];
                     $prbarray[$ind] =  $prbcell{$key}{PRBdBm}[$i];
                     $ind++;
                   }
             }
          }
        # print "\n";
                #if ($prbarray[1] !~   /^\s+$/) {
                if ($prbarray[1] ne "") {
                        $~ = PRB.$noOfcells;
                        
                        write;
                        @prbarray = ("","","","","","","");
                }
      }
}

if ($overlapflag > 0 ) {
    print "\n\nIt looks like the time between pget readings overlapped the end of ROP, so the calculations are based on the last values read \n\n";
} else {
    print "\n\nTime between counter reading was $timedelta seconds \n\n";
}
if ($badflag) {

print STDOUT <<_EOF_;
====================================================================================
warning warning warning warning warning warning warning warning warning warning 

During the fetch (pget) of the counters, some values were not populated. This is not 
an error but the data cannot be considered valid overall.
Please re-run the script

warning warning warning warning warning warning warning warning warning warning 
====================================================================================

_EOF_


}
if ($prbmaxflag eq "true") { 
print STDOUT <<_SEOF_;
====================================================================================
warning warning warning warning warning warning warning warning warning warning 
_SEOF_
    print "$prbmaxstring\n";
print Dumper \%prbcell if ($debug == 1);

print STDOUT <<_SEOF_;

The PRB counters above reached the maximum value of $prbmax and the individual PRB interference values cannot be reliable for this measurement.
Wait for the next ROP period and try again.

warning warning warning warning warning warning warning warning warning warning 
====================================================================================
_SEOF_
}
my @avgline;
format OUTAVGTEXT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<
@avgline
.

print "\n\n";
@avgline = ("Cell","Average UL Int dBm");
$~ = OUTAVGTEXT;
write;

foreach  $key (sort keys %cellhash) {
   @avgline = ("$key","$cellhash{$key}{avgdBm}");
   $~ = OUTAVGTEXT;
   write;
   
}



#print Dumper \%inthash;

__END__
[0]: N+I <= -121
[1]: -121 < N+I <= -120
[2]: -120 < N+I <= -119
[3]: -119 < N+I <= -118
[4]: -118 < N+I <= -117
[5]: -117 < N+I <= -116
[6]: -116 < N+I <= -115
[7]: -115 < N+I <= -114
[8]: -114< N+I <= -113
[9]: -113 < N+I <= -112
[10]: -112 < N+I <= -108
[11]: -108 < N+I <= -104
[12]: -104 < N+I <= -100
[13]: -100 < N+I <= -96
[14]: -96 < N+I <= -92
[15]: -92 < N+I




=================================================================================================================
EUtranCellFDD=WMEDEM1                                   pmRadioRecInterferencePwr i[16] = 0 282219 329376 19086 4643 6445 5442 3085 2298 1873 4332 45706 5202 7 0 0 
EUtranCellFDD=WMEDEM1                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
EUtranCellFDD=WMEDEM2                                   pmRadioRecInterferencePwr i[16] = 78 11339 492182 16755 61467 83637 21524 1534 760 532 1012 23 1 0 0 0 
EUtranCellFDD=WMEDEM2                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwr i[16] = 0 618805 42507 4752 9023 5503 4309 4138 2768 1730 31388 24975 0 0 0 0 
EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
=================================================================================================================
Total: 3 MOs


VIC_WMED15_WEST_MELBOURNE_530125> 

VIC_WMED15_WEST_MELBOURNE_530125> 

VIC_WMED15_WEST_MELBOURNE_530125> wait 2

Waiting from [2011-11-14 09:27:33] to [2011-11-14 09:27:35]...Done.

VIC_WMED15_WEST_MELBOURNE_530125> 

VIC_WMED15_WEST_MELBOURNE_530125> pget cell pmRadioRecInterferencePwr

111114-09:27:36 10.45.18.10 8.0y ERBS_NODE_MODEL_B_1_53_COMPLETE stopfile=/tmp/10705
=================================================================================================================
MO                                                      Attribute         Value
=================================================================================================================
EUtranCellFDD=WMEDEM1                                   pmRadioRecInterferencePwr i[16] = 0 284600 332057 19115 4648 6459 5449 3086 2298 1873 4332 45706 5202 7 0 0 
EUtranCellFDD=WMEDEM1                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
EUtranCellFDD=WMEDEM2                                   pmRadioRecInterferencePwr i[16] = 78 11363 495607 17276 62050 83661 21534 1540 760 532 1013 24 1 0 0 0 
EUtranCellFDD=WMEDEM2                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwr i[16] = 0 623637 42775 4766 9025 5503 4310 4140 2768 1730 31388 24975 0 0 0 0 
EUtranCellFDD=WMEDEM3                                   pmRadioRecInterferencePwrPucch i[16] = 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
=================================================================================================================
Total: 3 MOs



