#!/usr/bin/perl

use strict;
use warnings;
use lib qw(./lib/);

use Parser;

use constant VERSION => "0.3.6";

sub usage {
	print "usage: $0 [-a FILE] [-b WIDTHxHEIGHT][-h] [-v]\n\n";
	print "options:\n";
	print "\t-a, --ascii\t\tProduce ASCII graph from ste output\n";
	print "\t-b, --box\t\tChange default geometry of bridge boxes\n";
	print "\t-h, --help\t\tShow this text\n";
	print "\t-v, --version\t\tShow version\n";
	print "\nvariables:\n";
	print "\tFILE\t\tPath to a log file containing ste output\n";
	print "\tWIDTH\t\tNumber of columns a bridge should span in the graph\n";
	print "\tHEIGHT\t\tNumber of rows a bridge should span in the graph\n";
}

my @output;
my $input;
my $width = 0;
my $height = 0;

if (@ARGV) {
	do {
		my $arg = shift(@ARGV);
		if (grep(/$arg/, ("-a", "--ascii"))) {
			$input = shift(@ARGV);
		} elsif (grep(/$arg/, ("-h", "--help"))) {
			usage();
			exit 0;
		} elsif (grep(/$arg/, ("-v", "--version"))) {
			print "STE version ". VERSION ."\n";
			exit 0;
		} elsif (grep(/$arg/, ("-b", "--box"))) {
			($width, $height) = split("x", shift(@ARGV));
		}
	} while(@ARGV > 0);
}

if (!defined($input)) {
	usage();
	exit 1;
}

open(FILE, $input);
@output = <FILE>;
close(FILE);

print @output;

my $parser = Parser->new(\@output, $width, $height);
$parser->execute();
$parser->correlate();
$parser->ascii();
print "STE version ". VERSION ."\n";
