package Bridge;

use strict;
use warnings;


sub new {
	my ($class, $bridge, $label, $desc, $board, $in_ports, $out_ports, $rf_ports) = @_;
	

#DEBUG
#	print "\n---- New Bridge ----\n";
#	print "-Bridge name: $bridge\n";
#	print "-Bridge desc: $desc\n";
#	print "-Bridge column: $column\n\n";
	
	my $self = {
		_bridge 	=> $bridge,
		_label		=>	$label,
		_desc 		=> $desc,
		_board 		=> $board,
		_in_ports 	=> $in_ports,
		_out_ports 	=> $out_ports,
		_rf_ports	=> $rf_ports,
		_height 	=> 0,
		_width 		=> 0,
		_position 	=> { x => undef, y => undef }
	};

	bless $self;

	return $self;
}

sub setHeight {
	my ($self, $height) = @_;
	$self->{_height} = $height if defined($height);
}

sub setWidth {
	my ($self, $width) = @_;
	$self->{_width} = $width if defined($width);
}

sub getHeight {
	my ($self) = @_;
	return $self->{_height};
}

sub getWidth {
	my ($self) = @_;
	return $self->{_width};
}

sub getLabel {
	my ($self) = @_;
	return $self->{_label};
}

sub getDesc {
	my ($self) = @_;
	return $self->{_desc};
}

sub getBoard {
	my ($self) = @_;
	return $self->{_board};
}

sub getColumn {
	my ($self) = @_;
	return $self->{_column};
}

sub setPosition {
	my ($self, $x, $y) = @_;
	$self->{_position}{x} = $x if defined($x);
	$self->{_position}{y} = $y if defined($y);
}

sub getX {
	my ($self) = @_;

	return $self->{_position}{x};
}

sub getY {
	my ($self) = @_;

	return $self->{_position}{y};
}

sub getBridge {
	my ($self) = @_;
	return $self->{_bridge};
}

sub getOutPrts {
	my ($self) = @_;
	return $self->{_out_ports};
}

sub getInPorts {
	my ($self) = @_;
	return $self->{_in_ports};
}

1;
