<?xml version="1.0" encoding="ISO-8859-1"?>

<!--############################################################################
#  Copyright (C) 2001 by
#  Ericsson Euro Lab Netherlands
#  THE NETHERLANDS
#
#  The program may be used and/or copied only with the written
#  permission from Ericsson Business Mobile Networks BV, or in accordance with
#  the terms and conditions stipulated in the agreement/contract
#  under which the program has been supplied.
#
#  All rights reserved.
#
#  REVISION HISTORY
#  #############################################################################
#  Date    Author   Description
#  #############################################################################
#  010618  elnhssr  stylesheet statement added
#  010618  elnhssr  string lengths constraints added to attributes and struct
#                   template
#  010619  elnhssr  Revision history added
#  010719  elnhssr  formatText template added
#  010821  elnhssr  min / max ranges added in struct template
#  011022  elnhssr  incorporated changes of wessel:
#                    checks for duplicate relation ships added
#                    check for infinite loops added
#  011119  elnhssr  template added for class members attributes and actions
############################################################################-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
    xmlns:lxslt="http://xml.apache.org/xslt"
    xmlns:redirect="org.apache.xalan.xslt.extensions.Redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect">

	<!-- globals -->
	<xsl:param name="old_version"/>
	<xsl:param name="new_version"/>

	<!-- output method -->
	<xsl:output method="html"/>

	<!-- cross reference keys -->
	<xsl:key name="child"  match="//relationship[not(contains(substring-after(@name,'_to_'),'_'))]/containment" use="parent/hasClass/@name"/>
	<xsl:key name="parent" match="//relationship[not(contains(substring-after(@name,'_to_'),'_'))]/containment" use="child/hasClass/@name"/>
	<xsl:key name="use"    match="//structRef|moRef|enumRef"  use="@name"/>
	<xsl:key name="raises" match="//raisesException" use="@name"/>

	<!--	main
			main template
	 -->
	<xsl:template match="/">

		<!-- check relationships -->
		<xsl:apply-templates select="//relationship">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>

		<!-- create index files -->
		<xsl:call-template name="index">
			<xsl:with-param name="nodes" select="//class"/>
		</xsl:call-template>

		<xsl:call-template name="index">
			<xsl:with-param name="nodes" select="//struct"/>
		</xsl:call-template>

		<xsl:call-template name="index">
			<xsl:with-param name="nodes" select="//enum"/>
		</xsl:call-template>

		<xsl:call-template name="index">
			<xsl:with-param name="nodes" select="//exception"/>
		</xsl:call-template>

		<xsl:call-template name="member_index">
			<xsl:with-param name="nodes" select="//class/attribute"/>
		</xsl:call-template>

		<xsl:call-template name="member_index">
			<xsl:with-param name="nodes" select="//class/action"/>
		</xsl:call-template>

		<!-- create doc files -->
		<xsl:apply-templates select="//class">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>

		<xsl:apply-templates select="//struct">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>

		<xsl:apply-templates select="//enum">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>

		<xsl:apply-templates select="//exception">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>

	</xsl:template>


	<!-- 	index
			creates an index of the selected nodes
		param
			nodes:  a list of nodes
	 -->
	<xsl:template name="index">
	<xsl:param name="nodes"/>
	<xsl:message>index=<xsl:value-of select="name($nodes)"/></xsl:message>
	<redirect:write select="concat(concat('index_',name($nodes)),'.html')">
		<xsl:call-template name="stylesheet"/>
		<html><table cellspacing="0" cellpadding="0">
		<xsl:for-each select="$nodes">
			<xsl:sort select="@name"/>
			<tr><td><xsl:call-template name="ref"/></td></tr>
		</xsl:for-each>
		</table></html>
	</redirect:write>
	</xsl:template>

	<!-- 	member_index
			creates an index of the selected class members
		param
			nodes:  a list of class members
	 -->
	<xsl:template name="member_index">
	<xsl:param name="nodes"/>
	<xsl:message>index=<xsl:value-of select="name($nodes)"/></xsl:message>
	<redirect:write select="concat(concat('index_',name($nodes)),'.html')">
		<xsl:call-template name="stylesheet"/>
		<html><table cellspacing="0" cellpadding="0">
		<xsl:for-each select="$nodes">
			<xsl:sort select="@name"/>
			<xsl:sort select="../@name"/>
			   <tr><td><xsl:call-template name="member_ref"/></td></tr>
		</xsl:for-each>
		</table></html>
	</redirect:write>
	</xsl:template>

	<!-- 	class
			creates documentation for a class node
		path
			class node
	-->
	<xsl:template match="class">
		<xsl:call-template name="trace"/>
		<xsl:variable name="file">
			<xsl:value-of select="concat(@name,'.html')"/>
		</xsl:variable>
		<redirect:write select="$file">
			<html>
				<xsl:call-template name="stylesheet"/>
				<xsl:call-template name="head"/>
				<xsl:call-template name="tree"/>
				<dl>
					<xsl:call-template name="systemcreated"/>
					<xsl:call-template name="description"/>
					<xsl:call-template name="possibleParents"/>
					<xsl:call-template name="possibleChildren"/>
					<xsl:call-template name="referencesFrom"/>
					<xsl:call-template name="referencesTo"/>
				</dl>
				<xsl:call-template name="actions"/>
				<xsl:call-template name="attributes"/>
			</html>
		</redirect:write>
	</xsl:template>

	<!-- 	actions
			creates documentation for action nodes
		path
			class node
	 -->
	<xsl:template name="actions">
		<xsl:if test="action">
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<xsl:call-template name="subhead">
			<xsl:with-param name="head">Actions</xsl:with-param>
			</xsl:call-template>
			<xsl:for-each select="action">
				<xsl:sort select="@name"/>
					<tr class="TableRowColor" valign="top">
					<td align="right" width="1%"><font size="-1">
						<code>
						<xsl:call-template name="returnType"/>
						</code></font>
					</td>
					<td>
						<dl>
							<dt>
							<code>
                     <b>
                        <A>
                           <!-- create an anchor -->
                           <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                           <xsl:value-of select="@name"/>
                        </A>
                     </b>
							(
							<xsl:for-each select="parameter[1]">
								<xsl:call-template name="dataType"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="@name"/>
							</xsl:for-each>
							<xsl:for-each select="parameter[position()>1]">
								,
								<xsl:call-template name="dataType"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="@name"/>
							</xsl:for-each>
							);
							<xsl:for-each select="raisesException">
								<xsl:sort select="@name"/>
								<br/>throws <xsl:call-template name="ref"/>
							</xsl:for-each>
							</code>
						</dt>
						<dd>
							<xsl:call-template name="description"/>
						</dd>
					</dl>
					</td>
					</tr>
			</xsl:for-each>
			</table>
			<p/>
		</xsl:if>
	</xsl:template>

	<!--	attributes
			creates documentation for attribute nodes
		path
			class node
	 -->
	<xsl:template name="attributes">
		<xsl:if test="attribute">
			<table border="1" cellpadding="3" cellspacing="0" width="100%">
				<xsl:call-template name="subhead">
					<xsl:with-param name="head">Attributes</xsl:with-param>
				</xsl:call-template>
				<xsl:for-each select="attribute">
					<xsl:sort select="@name"/>
					<tr valign="top">
						<td width="1%">
							<!-- col 1: the type of the attribute -->
							<font size="-1">
								<code>
									<xsl:call-template name="dataType"/>
									<xsl:call-template name="properties"/>
								</code>
							</font>
						</td>
						<td>
							<dl>
								<dt>
									<code>
										<!-- col 1: the name of the attribute -->
										<b>
                                 <A>
      										<!-- create an anchor -->
                                    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                    <xsl:value-of select="@name"/>
                                 </A>
                              </b>
                              <xsl:if test="dataType/*/defaultValue/text()">
                                 =
                                 <xsl:value-of select="dataType/*/defaultValue/text()"/>
                              </xsl:if>
                              <xsl:if test="dataType/*/range">
                                 {
                                 <xsl:value-of select="dataType/*/range/min/text()"/>
                                 ..
                                 <xsl:value-of select="dataType/*/range/max/text()"/>
                                 }
                              </xsl:if>
                              <xsl:if test="dataType/*/lengthRange">
                                 [
                                 <xsl:value-of select="dataType/*/lengthRange/min/text()"/>
                                 ..
                                 <xsl:value-of select="dataType/*/lengthRange/max/text()"/>
                                 ]
                              </xsl:if>
                           </code>
								</dt>
								<dd>
									<xsl:call-template name="description"/>
								</dd>
								</dl>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
	</xsl:template>

	<!-- enum
		create documentation for enum nodes
	 -->
	<xsl:template match="enum">
		<xsl:call-template name="trace"/>
		<redirect:write select="concat(@name,'.html')">
		<html>
		<xsl:call-template name="stylesheet"/>
		<xsl:call-template name="head"/>
		<dl>
			<xsl:call-template name="description"/>
			<xsl:call-template name="referencesFrom"/>
			<xsl:call-template name="referencesTo"/>
		</dl>
		<p/>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<xsl:for-each select="enumMember">
				<tr valign="top">
					<td width="1%">
						<code>
							<xsl:value-of select="value/text()"/>
						</code>
					</td>
					<td>
						<dl>
							<dt>
								<code>
									<b>
                              <A>
                                 <!-- create an anchor -->
                                 <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                 <xsl:value-of select="@name"/>
                              </A>
                           </b>
								</code>
							</dt>
							<dd>
								<xsl:call-template name="description"/>
							</dd>
						</dl>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		</html>
		</redirect:write>
	</xsl:template>

	<!--	struct
			creates documentation for a struct node
	-->
	<xsl:template match="struct">
		<xsl:call-template name="trace"/>

		<redirect:write select="concat(@name,'.html')">
		<html>
		<xsl:call-template name="stylesheet"/>
		<xsl:call-template name="head"/>
		<dl>
			<xsl:call-template name="description"/>
			<xsl:call-template name="referencesFrom"/>
			<xsl:call-template name="referencesTo"/>
		</dl>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<xsl:for-each select="structMember">
				<xsl:sort select="@name"/>
				<tr valign="top">
					<td width="1%">
						<!-- col 1: the type of the attribute -->
						<font size="-1">
							<code>
								<xsl:call-template name="type"/>
								<xsl:call-template name="properties"/>
							</code>
						</font>
					</td>
					<td>
						<dl>
							<dt>
								<code>
									<b>
                              <A>
                                 <!-- create an anchor -->
                                 <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                 <xsl:value-of select="@name"/>
                              </A>
                           </b>
									<xsl:if test="*/defaultValue/text()">
										=
										<xsl:value-of select="*/defaultValue/text()"/>
									</xsl:if>
                           <xsl:if test="string/lengthRange">
                              [
                              <xsl:value-of select="string/lengthRange/min/text()"/>
                              ..
                              <xsl:value-of select="string/lengthRange/max/text()"/>
                              ]
                           </xsl:if>
                           <xsl:if test="*/range">
                              [
                              <xsl:value-of select="*/range/min/text()"/>
                              ..
                              <xsl:value-of select="*/range/max/text()"/>
                              ]
                           </xsl:if>

								</code>
							</dt>
							<dd>
								<xsl:call-template name="description"/>
							</dd>
						</dl>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		</html>
		</redirect:write>
	</xsl:template>

	<!--	exception
			creates documentation for an exception node
	 -->
	<xsl:template match="exception">
		<xsl:call-template name="trace"/>
		<redirect:write select="concat(@name,'.html')">
		<html>
		<xsl:call-template name="stylesheet"/>
		<xsl:call-template name="head"/>
		<dl>
			<xsl:call-template name="description"/>
			<xsl:call-template name="raisedBy"/>
		</dl>
		</html>
		</redirect:write>
	</xsl:template>

	<!--	relationship
			checks for duplicate relationships
	 -->
	 <xsl:template match="relationship">
	 	<xsl:if test="./containment and contains(substring-after(@name,'_to_'),'_')">
			<xsl:message>
WARNING:
	Duplicate containment relationship <xsl:value-of select='@name'/>
			</xsl:message>
		</xsl:if>
	 </xsl:template>

	<!-- raised by -->
	<xsl:template name="raisedBy">
	  <xsl:if test="key('raises',@name)">
			<dt>
				<b>raised by:</b>
			</dt>
			<dd>
				<xsl:for-each select="key('raises',@name)">
					<xsl:for-each select="ancestor::class">
						<xsl:call-template name='ref'/>
					</xsl:for-each>.<xsl:value-of select="ancestor::action/@name"/>
					<xsl:text>();</xsl:text><br/>
				</xsl:for-each>
			</dd>
		</xsl:if>
	</xsl:template>

	<!-- stylesheet -->
	<xsl:template name="stylesheet">
		<head>
			<link rel="stylesheet" type="text/css" href="stylesheet.css" title="Style"/>
		</head>
	</xsl:template>

	<!-- tree -->
	<xsl:template name="tree">
		<table>
			<xsl:call-template name="tree_parent">
				<xsl:with-param name="name" select="@name"/>
				<xsl:with-param name="sub">
						<b><xsl:call-template name="ref"/></b>
						<xsl:call-template name="tree_child"/>
				</xsl:with-param>
			</xsl:call-template>
		</table>
	</xsl:template>

	<!-- childtree -->
	<xsl:template name="tree_child">
		<dl>
		<xsl:for-each select="key('child',@name)/child/hasClass">
			<xsl:sort select="@name"/>
				<dd>
					<tt>+-</tt>
						<xsl:call-template name="ref"/>
			[<xsl:value-of select="../cardinality/min/text()"/>..<xsl:value-of select="../cardinality/max/text()"/>]
				</dd>
		</xsl:for-each>
		</dl>
	</xsl:template>

	<!-- tree_parent -->
	<xsl:template name="tree_parent">
		<xsl:param name="name"/>
		<xsl:param name="sub"/>
		<xsl:param name="children"/>
		<xsl:variable name="childList" select="$children"/>
		<xsl:choose>
			<xsl:when test="contains($childList,concat(':',$name,':'))">
				<xsl:message>
WARNING:
	Infinite loop detected for class = <xsl:value-of select="$name"/>
	childList = <xsl:value-of select="$childList"/>
				</xsl:message>
				<tr><td>
					<dl>
						<dd>
							<xsl:copy-of select="$sub"/>
						</dd>
					</dl>
				</td></tr>
			</xsl:when>
			<xsl:when test="key('parent',@name)/parent/hasClass and $name!='ManagedObject'">
				<xsl:for-each select="key('parent',$name)/parent/hasClass">
					<xsl:variable name="subtree">
						<xsl:call-template name="ref"/>
							<dl>
								<dd>
									<tt>+-</tt> <xsl:copy-of select="$sub"/>
								</dd>
							</dl>
					</xsl:variable>
					<xsl:call-template name="tree_parent">
						<xsl:with-param name="sub"><xsl:copy-of select="$subtree"/></xsl:with-param>
						<xsl:with-param name="name" select="@name"/>
						<xsl:with-param name="children" select="concat(':',$name,':',$childList)"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<tr><td>
					<dl>
						<dd>
							<xsl:copy-of select="$sub"/>
						</dd>
					</dl>
				</td></tr>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- possibleParents -->
	<xsl:template name="possibleParents">
		<xsl:if test="key('parent',@name)">
			<dt><b>Possible parents:</b></dt>
			<dd>
				<xsl:for-each select="key('parent',@name)/parent/hasClass">
					<xsl:sort select="@name"/>
					<xsl:call-template name="ref"/>;
				</xsl:for-each>
				<br/>
			</dd>
		</xsl:if>
	</xsl:template>

	<!-- possibleChildren -->
	<xsl:template name="possibleChildren">
		<xsl:if test="key('child',@name)">
			<dt>
				<b>Possible children:</b>
			</dt>
			<dd>
				<xsl:for-each select="key('child',@name)/child/hasClass">
					<xsl:sort select="@name"/>
					<xsl:call-template name="ref"/>
					[<xsl:value-of select="../cardinality/min/text()"/>..<xsl:value-of select="../cardinality/max/text()"/>];
				</xsl:for-each>
			</dd>
		</xsl:if>
	</xsl:template>

	<!-- referencesFrom -->
	<xsl:template name="referencesFrom">
		<xsl:if test="key('use',@name)">
			<dt>
				<b>References from:</b>
			</dt>
			<dd>
	<xsl:for-each select="key('use',@name)/ancestor::class">
					<xsl:sort select="@name"/>
					<xsl:call-template name='ref'/>;
				</xsl:for-each>
			</dd>
		</xsl:if>
	</xsl:template>

	<!-- referencesTo -->
	<xsl:template name="referencesTo">
		<xsl:if test=".//moRef|structRef|enumRef">
			<dt>
				<b>References to:</b>
			</dt>
			<dd>
				<xsl:for-each select=".//moRef|structRef|enumRef">
					<xsl:sort select="@name"/>
					<xsl:call-template name="ref"/>;
				</xsl:for-each>
			</dd>
		</xsl:if>
	</xsl:template>

	<!-- subhead -->
	<xsl:template name="subhead">
		<xsl:param name="head"/>
		<tr class="TableSubHeadingColor">
			<td colspan="2">
				<font size="+2">
					<b>
						<xsl:copy-of select="$head"/>
					</b>
				</font>
			</td>
		</tr>
	</xsl:template>

	<!-- systemcreated -->
	<xsl:template name="systemcreated">
		<xsl:if test="systemCreated">
		<p>
			<b>This MO is created by the system.</b>
		</p>
		</xsl:if>
	</xsl:template>

	<xsl:template name="formatText">
		<xsl:param name="txt"/>
		<xsl:variable name="text"><xsl:value-of select="$txt"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="contains($text,'&#10;')">
				<xsl:value-of select="substring-before($text,'&#10;')"/>
				<br/>
				<xsl:call-template name="formatText">
					<xsl:with-param name="txt">
						<xsl:value-of select="substring-after($text,'&#10;')"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- description -->
	<xsl:template name="description">
		<xsl:call-template name="formatText">
			<xsl:with-param name="txt">
				<xsl:value-of select="description/text()"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- ref -->
	<xsl:template name="ref">
		<a>
			<xsl:attribute name="href"><xsl:value-of select="concat(@name,'.html')"/></xsl:attribute>
			<xsl:attribute name="target">content</xsl:attribute>
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>


	<!-- member_ref -->
	<xsl:template name="member_ref">
		<a>
			<xsl:attribute name="href"><xsl:value-of select="concat(../@name,'.html','#', @name)"/></xsl:attribute>
			<xsl:attribute name="target">content</xsl:attribute>
			<xsl:value-of select="concat(../@name, '::', @name)"/>
		</a>
	</xsl:template>


	<!-- head -->
	<xsl:template name="head">
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="tableHeadingColor">
				<td>
					<table border="0" width="100%" cellpadding="0" cellspacing="0">
						<tr valign="bottom">
							<td>
								<font size="+3">
									<xsl:value-of select="name()"/>
									<xsl:text> </xsl:text>
									<b>
										<xsl:value-of select="@name"/>
									</b>
								</font>
							</td>
							<td align="right">
								<xsl:value-of select="$new_version"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<!-- properties -->
	<xsl:template name="properties">
		<xsl:for-each select="local|mandatory|noNotification|nonPersistent|readOnly|advisoryReadOnly|restricted|static|undefined">
			<xsl:sort select="name(.)"/>
			<br/><xsl:value-of select="name(.)"/>
		</xsl:for-each>
	</xsl:template>

	<!-- data types -->
	<xsl:template name="type">
		<xsl:for-each select="void|string|float|long|longlong|boolean">
			<xsl:value-of select="name(.)"/>
		</xsl:for-each>
		<xsl:for-each  select="structRef|moRef|enumRef">
			<xsl:call-template name="ref"/>
		</xsl:for-each>
		<xsl:for-each select="sequence">
			<xsl:call-template name="type"/>
			<xsl:text>[</xsl:text>
			<xsl:value-of select="length/text()"/>
			<xsl:text>]</xsl:text>
		</xsl:for-each>
	</xsl:template>

	<!-- dataType -->
	<xsl:template name="dataType">
		<xsl:for-each select="dataType">
			<xsl:call-template name="type"/>
		</xsl:for-each>
	</xsl:template>

	<!-- returnType -->
	<xsl:template name="returnType">
		<xsl:for-each select="returnType">
			<xsl:call-template name="type"/>
		</xsl:for-each>
	</xsl:template>

	<!-- textValue >
	<xsl:template name="textValue">
			<xsl:for-each select="*">
				&lt;<xsl:value-of select="name(current())"/>&gt;
				<xsl:call-template name="textValue"/>
					<xsl:value-of select="current()/text()"/>
				&lt;/<xsl:value-of select="name(current())"/>&gt;
			</xsl:for-each>
	</xsl:template-->


	<!-- compare >
	<xsl:template name="compare">
		<xsl:param name="oldNode"/>
		<xsl:param name="newNode"/>
		<xsl:variable name="txt_old">
			<xsl:for-each select="$oldNode">
				<xsl:call-template name="textValue"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="txt_new">
			<xsl:for-each select="$newNode">
				<xsl:call-template name="textValue"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$txt_old=$txt_new">same</xsl:when>
			<xsl:otherwise>different</xsl:otherwise>
		</xsl:choose>
	</xsl:template-->

	<!-- trace -->
	<xsl:template name="trace">
		<xsl:message><xsl:value-of select="name(.)"/>=<xsl:value-of select="@name"/></xsl:message>
	</xsl:template>

</xsl:stylesheet>
