#!/bin/gawk -f

######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

BEGIN{ 


	#usage: cat <file(s)> | pmExtract.awk [options] <mo_filter> <counter_filter> 
	#
	#        <mo_filter> = Regular expression to select which managed objects will be extracted
	#        <counter_filter> = Regular expression to select which counters will be extracted
	#        <file1>... = rop files to read. If none specified then std input will be read.
	#
	#Options (not yet supported)
	#
	#    -u, --utc
	#           Output time as UTC - otherwise time will be converted to local time
	#           (make sure environment variable TZ is set)
	#           
	#    -tz <timezone>
	#           Specify timezone other than the one in which this machine is located
	#           eg. -tz +10 means 10 hours ahead of GMT
	#           
	#    -s
	#           Include subnetwork in managed object name
	#           
	#    -me   
	#           Include MeContext in managed object name
	#           
	#    -f, --sf      
	#           Highlight the counters marked with the suspected faulty tag.
	#           Without this option, the suspected faulty counters are discarded.
	#
	#    -k      
	#           Keep the counters marked with the suspected faulty tag but do not highlight them.
	#           Without this option, the suspected faulty counters are discarded.
	#
	#    -w <file>      
	#           Print warnings and list of faulty counters to a file, not to screen.
	#    
	#    -l <file>
	#           Print warnings to a file and to screen.
           

	for (i=1;i<ARGC;i++) 
	{
		if (ARGV[i]~/^-(u|tz|s|me|f|k|w|l|-sf)$/) 
		{
			if (ARGV[i]~/^-(tz|w|l)$/) i++
			else if (ARGV[i]=="--sf") sfprint=1
			continue
		}
		if (mof=="") mof=tolower(ARGV[i])
		else pmf=tolower(ARGV[i])
	}
	delete ARGV
	#print "mof="mof " pmf="pmf
}
function removetags(string,what)
{
	gsub(/["]/,"",string)
	gsub(/\/?>/,"",string)
	sub(/^[^=]+=/,"",string)
	if (what=="ldn" && string !~ /^[^=]+=[^=]+/) string="Mo="string
	return string
}
function removespaces(string,   res)
{
	res=string
	gsub(/[ \t]+/,"_",res)
	gsub(/\(|\)/,"",res)
	return res
}
{
	for(i=1;i<=NF;i++)
	{
		if ($i=="<measCollec")
		{
			#<measCollec beginTime="2013-11-22T18:15:00Z"/>
			#<measCollec beginTime="2013-11-23T17:30:00+00:00"/>
		        #<measCollec beginTime="2013-04-30T17:15:00+02:00"/>
			for (j=(i+1);j<=NF;j++)
			{
				if ($j~/^beginTime=/) 
				{
					currtime=removetags($j)
					sub(/T/," ",currtime)
					sub(/Z/,"",currtime)
					sub(/\+.*$/,"",currtime)
					break
				}
			}
		}
		else if ($i=="<managedElement")
		{
			#<managedElement localDn="ManagedElement=PRBS417" swVersion="r0.1"/>
			for (j=(i+1);j<=NF;j++)
			{
				if ($j ~ /^localDn=/) 
				{
					Ldn=removetags($j)
					break
				}
			}
		}
		else if ($i=="<measInfo>" || $i=="<measInfo")
		{
			delete cName
			delete cVal
			delete cInd
			ind=0
		}
		else if ($i=="<measType")
		{
                        #<measType p="1">pmIfHCInOctets</measType>
                        #<measType p="1">ROPType6Sum</measType>
                        #<measType p="1">Processor load (5 min average per core)</measType>

			#match($(i+1),/^p=\"([^"]+)\">([^<]+)</,array)
			match($0,/<measType p=\"([^"]+)\">([^<]+)</,array)
			cName[array[1]]=removespaces(array[2])
			cInd[++ind]=array[1]
		}
		else if ($i=="<measValue")
		{
                        #<measValue measObjLdn="Transport=1,EthernetPort=1">
                        #<measValue measObjLdn="DEFAULT">
                        currMo=Ldn","removetags($(i+1),"ldn")
		}
		else if ($i=="<r")
		{
			match($0,/<r +p=\"([^"]+)\">([^<]*)</,array)
			gsub(/ +,/,",",array[2])
			cVal[array[1]]=array[2]
			#sometimes the counter value contains a space at the end before the xml tag
			#<r p="8">54,54,54,54,54,54,54,54,54,54,54,54,54,54, </r>
			#<r p="9">0,0,0,0,0,0,0,0,0,0,0,0,0,0,0</r>
			#sometimes there is an empty element, causes space in the middle or beginning
			#<r p="5">184,190,186,188,185, ,191,191,191,186,187,192,187,196, </r>
			#<r p="5"> ,164,163,168,166,166,169,170,171,172,172,171, ,174, </r>
		}
		else if ($i=="<suspect>true</suspect>") suspectedFaulty=1
		else if ($i=="</measValue>")
		{
			#put a dummy MO if the MO field is empty, otherwise the line does not show in pmXtab
			#if (currMo=="") currMo="MO=1"
			if (sfprint==1)
			{
				for (z in cVal)
				{
					if (suspectedFaulty==1) cVal[z]=cVal[z]" (SuspectedFaulty)"
					else if (cVal[z] ~ /^,|^ *$/) cVal[z]=cVal[z]" (EmptyCounter)"
					else if (cVal[z] ~ /^-[0-9]+$/) cVal[z]=cVal[z]" (NegativeCounter)"
				}
			}
			for (j=1;j<=ind;j++) 
			{
				if (tolower(currMo)~mof && tolower(cName[cInd[j]])~pmf) print currtime";"currMo";"cName[cInd[j]]";"cVal[cInd[j]]
			}
			delete cVal
			suspectedFaulty=0
		}
	}
}

			