#!/app/python/2.4.1/bin/python
# -*- coding:ISO-8859-1 -*-

#####################################################################################
#                                                                                   #
#  Ericsson AB 2010 - All Rights Reserved                                          #
#                                                                                   #
# The copyright to the computer program(s) herein is the property of Ericsson AB,   #
# Sweden. The programs may be used and/or copied only with the written permission   #
# from Ericsson AB or in accordance with the terms and conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                 #
#                                                                                   #
#####################################################################################
#
#  Source : @@Source
#  
#  Version: @@Version
#  
#  Rule   : @@Rule
#  
#####################################################################################

import sys
sys.path.append('/vobs/iov/rbs/testenv/svo/reporttool')
import directory
import pexpect
import re
import os
import string
import xml.dom.minidom
import xml.dom.ext
from xml import xpath
import traceback

class API_MoShell:
	"This Class controls MoShell"

	## Constants
	MoShellPrompt     = 'SYSTEMVERIFIERING>'
	fp_moshell  = directory.fp_moshell
	SHOWCMD           = None

	def __init__(self, IPADDRESS, USERID='rbs', PASSWORD='rbs', fp_moshell=None):
	
		if fp_moshell != None:
			self.fp_moshell = fp_moshell
	
		moshell_startcmd = '%s -v java=/app/jdk/1.6.0/bin/java,set_window_title=0,prompt_highlight=0,show_colors=0,prompt_colors=0,secure_ftp=1' % self.fp_moshell
		print "\nStarting MoShell"
		print "  ip       = %s" % IPADDRESS
		print "  moshell  = %s" % self.fp_moshell
		
		self.StartString = '%s %s' % (moshell_startcmd, IPADDRESS)

		self.MoShellAp = pexpect.spawn(self.StartString, timeout=180, maxread=50000)

		print "\n  Moshell Starting", 
		self.MoShellAp.expect('QUIT')
		
		print " . setting prompt ", 
		self.MoShellAp.sendline('p SYSTEMVERIFIERING')
		self.MoShellAp.expect(self.MoShellPrompt)
		
		print " . lt all",
		self.MoShellAp.sendline('lt all')
		self.MoShellAp.expect(self.MoShellPrompt)
		
		print " . init password",
		self.MoShellAp.sendline('DummyCmdForSettingPassword')
		
		index = self.MoShellAp.expect([self.MoShellPrompt, 'Please enter Node Password'],  timeout=180)
		if index == 0:
			print " . password retrived from db",
			
		elif index == 1:
			print " . setting password (%s)" % PASSWORD,
			self.MoShellAp.sendline(PASSWORD)
			self.MoShellAp.expect(self.MoShellPrompt)

		print " . MoShell Started"
	
	def __del__(self):
		self.MoShellAp.sendline('quit')
	
	def Quit(self):
		self.MoShellAp.sendline('quit')

	def setMoshell_filepath(self, fp_moshell):
		self.fp_moshell = fp_moshell
	
	def cmd(self, cmd, rtype='string'):
		return self.write(cmd, rtype)

	def Command(self, cmd, rtype='string'):
		return self.cmd(cmd, rtype)

	def write(self, string, rtype='string', response='n', timeout=60):
		_timeouts = 0
		if self.SHOWCMD != None:
			print '  MoShell>%s' % string
		self.MoShellAp.sendline(string)
		while(1):
			index = self.MoShellAp.expect([self.MoShellPrompt, '\[y\/n\]\s*\?', pexpect.EOF, pexpect.TIMEOUT],  timeout=timeout)
			if index == 0:
				_response = self.MoShellAp.before
				if rtype.lower() == 'string':
					return 'MoShell>%s' % _response
				elif rtype.lower() == 'array':
					_array = _response.splitlines()
					del _array[0]
					return _array
				else:
					return 'MoShell>%s' % _response

			elif index == 1:
				self.MoShellAp.sendline(response)

			elif index == 2:
				print "Nothing to read!"
				return None
				
			elif index == 3:
				_timeouts += 1
				print " Timeout #%d reached! %d seconds before returning 'None'!" % (_timeouts, timeout*(10-_timeouts))
				if _timeouts == 10:
					print "Could not get any Data"
					return None

	def acc(self, cmd, parameters):
		print "moshell.acc(%s)" % (cmd)

		self.MoShellAp.sendline("acc %s" % cmd)
		
		while(1):
			index = self.MoShellAp.expect([self.MoShellPrompt, 'Are you Sure \[y\/n\] \?', 'Parameter[^,]+,\s*(\w+)\s[^:]+:'],  timeout=60)

			if index == 0:
				break
			
			elif index == 1:
				self.MoShellAp.sendline('y')
			
			elif index == 2:
				match = self.MoShellAp.match
				if match.group(1) in parameters.keys():
					print ". . %s %s" % (match.group(0), parameters[match.group(1)])
					self.MoShellAp.sendline(parameters[match.group(1)])
				else:
					print ". . ERROR: %s not specified as input (%s)." % (match.group(1), parameters)
					break
			
	def pr(self, LDN, RETURNTYPE='ARRAY'):
		dic = {}
		array = []
		returnArray = []
		sCommand = 'pr ' + LDN
		if self.SHOWCMD != None:
			print '  MoShell>%s' % sCommand
		self.MoShellAp.sendline(sCommand)
		self.MoShellAp.expect(self.MoShellPrompt)
		sResponse = self.MoShellAp.before

		aResponse = sResponse.splitlines()
		for i in range(len(aResponse)-1,-1,-1):
			matchObject = re.match('\s*(\d+)\s+(\S+)\s*$', aResponse[i])
			if matchObject == None:
				del aResponse[i]
			else:
				returnArray.append([matchObject.group(1), matchObject.group(2)])
		return returnArray

	def List(self, LDN, RETURNTYPE='ARRAY'):
		dic = {}
		array = []
		returnArray = []
		sCommand = 'pr ' + LDN
		if self.SHOWCMD != None:
			print '  MoShell>%s' % sCommand
		self.MoShellAp.sendline(sCommand)
		self.MoShellAp.expect(self.MoShellPrompt)
		sResponse = self.MoShellAp.before

		aResponse = sResponse.splitlines()
		for i in range(len(aResponse)-1,-1,-1):
			matchObject = re.match('\s*(\d+)\s+(\S+)\s*$', aResponse[i])
			if matchObject == None:
				del aResponse[i]
			else:
				array.append(matchObject.group(2))
				dic[matchObject.group(2)] = matchObject.group(1)
		
		array.sort()
		for Value in array:
			returnArray.append([dic[Value], Value])
		
		return returnArray


	def Get(self, LDN):
		self.MoShellAp.sendline('get %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		RESPONSE = RESPONSE.splitlines()
		State = 0
		for i in range(len(RESPONSE)-1,-1,-1):

			if re.search('======', RESPONSE[i]) != None:
				State = State + 1
			
			elif State == 0 or State == 3:
				del RESPONSE[i] 

			elif State == 2:
				matchObject = re.match('\s*\d+\s+(\S+)', RESPONSE[i])
				RESPONSE[i] = matchObject.group(1)

		
		return string.join(RESPONSE,'\n')

	def LGET(self, LDN):
		self.MoShellAp.sendline('lget %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		RESPONSE = RESPONSE.splitlines()
		State = 0
		for i in range(len(RESPONSE)-1,-1,-1):

			if re.search('======', RESPONSE[i]) != None:
				State = State + 1
			
			elif State == 0 or State == 3:
				del RESPONSE[i] 

			elif State == 2:
				matchObject = re.match('\s*\d+\s+(\S+)', RESPONSE[i])
				RESPONSE[i] = matchObject.group(1)

		
		return string.join(RESPONSE,'\n')
	

	def getProxy(self, LDN):
		rep = re.compile('\s*(\d+)\s+([\S=]+)\s*$', re.IGNORECASE)
		self.MoShellAp.sendline('lpr %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		response = self.MoShellAp.before
		response = response.splitlines()
		
		del response[0]
		
		for index, line in enumerate(response):
			matchObject = rep.match(line)
			if matchObject != None:
				return matchObject.group(1)
		

	def getAttribute(self, attribute, ldn):
		return self.GetAttribute(ldn, attribute)
		
	def GetAttribute(self, ATTRIBUTE, sLDN):
		rePATTERN = re.compile('%s\s*(\S+)' % ATTRIBUTE, re.IGNORECASE)
		self.MoShellAp.sendline('fget %s %s' % (sLDN, ATTRIBUTE))
		#print "MoShell sent fget %s %s" % (sLDN, sAttribute)
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		
		RESPONSE = RESPONSE.splitlines()
		
		del RESPONSE[0]
		
		for index, LINE in enumerate(RESPONSE):
			#print "Line %d: [%s]" % (index, LINE)
			matchObject = rePATTERN.search(LINE)
			if matchObject != None:
				#print "Returned: ", matchObject.group(1)
				return matchObject.group(1)
		return None

	def LGETAttributes(self, LDN):
		returnDic = {}
		rePATTERN = re.compile('\s*(\S+)\s+([\S=]+)\s*\(?\S*\)?\s*$', re.IGNORECASE)
		self.MoShellAp.sendline('lget %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		RESPONSE = RESPONSE.splitlines()
		
		del RESPONSE[0]
		
		for index, LINE in enumerate(RESPONSE):
			matchObject = rePATTERN.match(LINE)
			if matchObject != None:
				returnDic[matchObject.group(1)] = matchObject.group(2)
		return returnDic

	def GetAttributes2(self, LDN):
		returnDic = {}
		rePATTERN = re.compile('\s*(\S+)\s+([\S=]+)\s*\(?\S*\)?\s*$', re.IGNORECASE)
		self.MoShellAp.sendline('fget %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		RESPONSE = RESPONSE.splitlines()
		
		del RESPONSE[0]
		
		for index, LINE in enumerate(RESPONSE):
			matchObject = rePATTERN.match(LINE)
			if matchObject != None:
				returnDic[matchObject.group(1)] = matchObject.group(2)
		return returnDic

	def GetAttributes(self, LDN):
		returnDic = {}
		rePATTERN = re.compile('\s*(\S+)\s+([\S=]+)\s*\(?\S*\)?\s*$', re.IGNORECASE)
		self.MoShellAp.sendline('fget %s' % (LDN))
		self.MoShellAp.expect(self.MoShellPrompt)
		RESPONSE = self.MoShellAp.before
		RESPONSE = RESPONSE.splitlines()
		
		del RESPONSE[0]
		
		for index, LINE in enumerate(RESPONSE):
			if re.match("\s*>>>\s*\d+\.(\S+)\s*=\s*(\S+)\s*$", LINE) != None:
				matchObject = re.match("\s*>>>\s*\d+\.(\S+)\s*=\s*(\S+)\s*$", LINE)
				#print '#' + LastKey + ':' + matchObject.group(1) + ':' + matchObject.group(2)
				returnDic[LastKey][matchObject.group(1)] = matchObject.group(2)
			elif re.match("\s*>>>[^=]+=\s*(\S+)\s*$", LINE) != None:
				matchObject = re.match("\s*>>>[^=]+=\s*(\S+)\s*$", LINE)
				#print '#' + matchObject.group(1)
				returnDic[LastKey].append(matchObject.group(1))
			elif rePATTERN.match(LINE) != None:
				matchObject = rePATTERN.match(LINE)
				Key = matchObject.group(1)
				Value = matchObject.group(2)
				#print Key + ': ' + Value
				if re.search('Struct',Value):
					returnDic[Key] = {}
					LastKey = Key
				elif re.search('\[\d+\]',Value):
					returnDic[Key] = []
					LastKey = Key
				else:
					returnDic[Key] = Value
		return returnDic
				
	def GetMemoryData(self):
		TMemory=None; UMemory=None; FMemory=None; HMemory=None;

		RESPONSE = self.cmd('mmu')

		if re.search("mmu: command not found", RESPONSE) == None:
			RESPONSE = self.cmd('mmu', 'array')
			for index, LINE in enumerate(RESPONSE):
				if re.search('Total Memory:', LINE) != None:
					matchObject = re.search('=(.*)', RESPONSE[index+1])
					if matchObject != None:
						TMemory = matchObject.group(1)
	
				if re.search('Free Memory:', LINE) != None:
					matchObject = re.search('=(.*)', RESPONSE[index+1])
					if matchObject != None:
						FMemory = matchObject.group(1)
	
				if re.search('Used Memory:', LINE) != None:
					matchObject = re.search('=(.*)', RESPONSE[index+1])
					if matchObject != None:
						UMemory = matchObject.group(1)
						
		else:
			RESPONSE = self.cmd('mm -p')
			if re.search("Unknown command 'mm'", RESPONSE) == None:
				RESPONSE = self.cmd('mm -p', 'array')
				
				#     total       used       inactive   free          #frags largest_frag  watermark
				#RAM: 0x10000000  0xf078000  0          0xf88000      3      0x8b8000      0xf88000
				
				for index, LINE in enumerate(RESPONSE):
					print LINE
					if re.search('RAM:\s*(0x\w+)\s+(0x\w+)\s+\d+\s+(0x\w+)\s+\d+\s+(0x\w+)\s+(0x\w+)', LINE) != None:
						matchObject = re.search('RAM:\s*(0x\w+)\s+(0x\w+)\s+\d+\s+(0x\w+)\s+\d+\s+(0x\w+)\s+(0x\w+)', LINE)
						fTMemory = float(int(matchObject.group(1), 16)/1048576.0)
						fUMemory = float(int(matchObject.group(2), 16)/1048576.0)
						fFMemory = float(int(matchObject.group(3), 16)/1048576.0)
						fHMemory = float(int(matchObject.group(5), 16)/1048576.0)

						TMemory = "%.1f Mbytes" % fTMemory
						UMemory = "%.1f Mbytes (%d%%)" % (fUMemory, int(round(fUMemory/fTMemory*100)))
						FMemory = "%.1f Mbytes (%d%%)" % (fFMemory, int(round(fFMemory/fTMemory*100)))
						HMemory = "%.1f Mbytes (%d%%)" % (fHMemory, int(round(fHMemory/fTMemory*100)))
					
		return (TMemory, UMemory, FMemory, HMemory)

	def GetProductData(self):
		Node_SW=None; Node_Product=None; Node_Revision=None; Node_CV=None

		RESPONSE = self.cmd('cvls', 'array')
		
		for LINE in RESPONSE:
			matchObject = re.search('Current UpgradePkg:\s+UpgradePackage=\S+\s+(\S+)', LINE)
			if matchObject != None:
				Node_SW = matchObject.group(1)
				matchObject = re.search('([^_]+)_(.+)', Node_SW)
				if matchObject != None:
					Node_Product  = matchObject.group(1)
					Node_Revision = matchObject.group(2)

			matchObject = re.search('Startable:\s+(\S+)', LINE)
			if matchObject != None:
				Node_CV = matchObject.group(1)

		return (Node_SW, Node_Product, Node_Revision, Node_CV)

	def GetRevision(self):
		return self.GetAttribute('productRevision', '0')

	def GetRadiolinks(self):
		RadioLinks = {}
		RadioLinks['Total'] = 0
		
		MOS = self.List('RadioLinks', 'ARRAY')
		for MO in MOS:
			matchObject = re.search('Sector=(\d),Carrier=(\d)', MO[1])
			CellId = "S%sC%s" % (matchObject.group(1), matchObject.group(2))
			RadioLinks[CellId] = int(self.GetAttribute('noOfRadioLinks', MO[0]))
			RadioLinks['Total'] += int(RadioLinks[CellId])
	
		return RadioLinks
	
	def listloaded(self, slot):
		lms = []

		print 'lhsh %s listloaded' % slot
		aresponse = self.cmd('lhsh %s listloaded' % slot, 'array')
		
		for line in aresponse:
			print line
			mo = re.match('Load module id: (\S+)\s+\((.+)\)', line)
			if mo != None:
				lms.append([mo.group(1), mo.group(2)])
		
		return lms



	def GetHardwareSlots(self):
		BOARDS = {}
		sRESPONSE = self.cmd('cab')
		aRESPONSE = sRESPONSE.splitlines()
		del aRESPONSE[0:7]

		for sLINE in aRESPONSE:
			matchObject = re.match("\s*(\d)\s*(\d{1,2})", sLINE)
			if matchObject != None:
			#0         1         2         3         4         5         6        7          8         9         10  
			#01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123
			#SMN  APN  BOARD      GREEN   YELLOW  RED     PRODUCT NR       REV     DATE     SERIAL NR   TEMP  COREMGR
				SMN = matchObject.group(1)
				APM = matchObject.group(2)
				SLOTID = '%2.2d%2.2d%2.2d' % (int(SMN), int(APM), 0)
				BOARD = sLINE[10:19].replace(' ', '')
				PRODUCTNR = sLINE[45:60].replace(' ', '')
				PRODUCTREV = sLINE[62:68].replace(' ', '')
				TEXT = "%s (%s %s)" % (BOARD, PRODUCTNR, PRODUCTREV)
				BOARDS[SLOTID] = {'SMN':SMN, 'APM':APM, 'SLOTID':SLOTID, 'BOARD':BOARD, 'PRODUCTNR':PRODUCTNR, 'PRODUCTREV':PRODUCTREV, 'TEXT':TEXT}

		return BOARDS

	def GetProductInventory(self, FILE=None):
		dicBoards = {}
		
		docProductInventory = xml.dom.minidom.Document()

		# Create the Root Element
		xmlProductInventory = docProductInventory.createElement('ProductInventory')
		docProductInventory.appendChild(xmlProductInventory)

		for (proxy, mo) in self.pr(',Slot'):
			dicAttributes = self.GetAttributes(proxy)
			if dicAttributes.get('productData', None) != None and dicAttributes.get('slotState', None) == '1':
				try:
					xmlHW = docProductInventory.createElement('HW')

					xmlNewNode = docProductInventory.createElement('ProdName')
					xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes['productData']['productName']))
					xmlHW.appendChild(xmlNewNode)

					xmlNewNode = docProductInventory.createElement('ProdId')
					xmlNewNode.setAttribute('ProdNo',  dicAttributes['productData']['productNumber'])
					xmlNewNode.setAttribute('ProdRev', dicAttributes['productData']['productRevision'])
					xmlHW.appendChild(xmlNewNode)

					if re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes['productData']['productionDate']) != None:
						mo_date = re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes['productData']['productionDate'])
						year  = mo_date.group(1)
						month = mo_date.group(2)
						day   = mo_date.group(3)
					elif re.match("(\d\d)(W\d\d)", dicAttributes['productData']['productionDate']) != None:
						mo_date = re.match("(\d\d)(W\d\d)", dicAttributes['productData']['productionDate'])
						year  = mo_date.group(1)
						month = mo_date.group(2)
						day   = '??'
					else:
						year  = '????'
						month = '??'
						day   = '??'
					
					xmlNewNode = docProductInventory.createElement('Date')
					xmlNewNode.setAttribute('Year', year)
					xmlNewNode.setAttribute('Day', day)
					xmlNewNode.setAttribute('Month', month)
					xmlHW.appendChild(xmlNewNode)

					xmlNewNode = docProductInventory.createElement('SerialNo')
					xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes['productData']['serialNumber']))
					xmlHW.appendChild(xmlNewNode)

					matchObject = re.search('Subrack=(\d+),Slot=(\d+)', mo)
					xmlNewNode = docProductInventory.createElement('HWPos')
					xmlNewNode.setAttribute('SubrackId', matchObject.group(1))
					xmlNewNode.setAttribute('SlotNo', '%2.2d' % int(matchObject.group(2)))
					xmlHW.appendChild(xmlNewNode)
					
					
					SlotId = "%2.2d%2.2d00" % (int(matchObject.group(1))-1, int(matchObject.group(2)))
					TEXT   = "%s (%s %s)" % (dicAttributes['productData']['productName'], dicAttributes['productData']['productNumber'], dicAttributes['productData']['productRevision'])
					
					dicBoards[SlotId] = {	'SMN'		:int(matchObject.group(1))-1,				\
								'APM'		:int(matchObject.group(2)),  				\
								'SLOTID'	:SlotId,						\
								'BOARD'		:dicAttributes['productData']['productName'],		\
								'PRODUCTNR'	:dicAttributes['productData']['productNumber'],		\
								'PRODUCTREV'	:dicAttributes['productData']['productRevision'],	\
								'TEXT'		:TEXT							\
								}
					
					dicAttributes = self.GetAttributes(self.getProxy(mo+',PlugInUnit=1'))

					xmlHW.setAttribute('LedG', dicAttributes['greenLed'])
					xmlHW.setAttribute('LedY', dicAttributes['yellowLed'])
					xmlHW.setAttribute('LedR', dicAttributes['redLed'])

					xmlProductInventory.appendChild(xmlHW)
				except:
					print dicAttributes
					traceback.print_exc(None, sys.stdout)
			else:
				pass
				
		for (proxy, mo) in self.pr('AuxPlugInUnit'):
			dicAttributes = self.GetAttributes(proxy)
			try:
				xmlHW = docProductInventory.createElement('HW')
				xmlHW.setAttribute('LedG', dicAttributes['greenLed'])
				xmlHW.setAttribute('LedY', dicAttributes['yellowLed'])
				xmlHW.setAttribute('LedR', dicAttributes['redLed'])

				xmlNewNode = docProductInventory.createElement('ProdName')
				xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes.get('productName', 'n/a')))
				xmlHW.appendChild(xmlNewNode)

				xmlNewNode = docProductInventory.createElement('ProdId')
				xmlNewNode.setAttribute('ProdNo',  dicAttributes.get('productNumber', 'n/a'))
				xmlNewNode.setAttribute('ProdRev', dicAttributes.get('productRevision', 'n/a'))
				xmlHW.appendChild(xmlNewNode)

				if re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes.get('productionDate', 'n/a')) != None:
					mo_date = re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes.get('productionDate', 'n/a'))
					year  = mo_date.group(1)
					month = mo_date.group(2)
					day   = mo_date.group(3)
				elif re.match("(\d\d)(w\d\d)", dicAttributes.get('productionDate', 'n/a')) != None:
					mo_date = re.match("(\d\d)(w\d\d)", dicAttributes.get('productionDate', 'n/a'))
					year  = mo_date.group(1)
					month = mo_date.group(2)
					day   = 'n/a'
				else:
					year  = 'n/a'
					month = 'n/a'
					day   = 'n/a'
				
				xmlNewNode = docProductInventory.createElement('Date')
				xmlNewNode.setAttribute('Year', year)
				xmlNewNode.setAttribute('Day', day)
				xmlNewNode.setAttribute('Month', month)
				xmlHW.appendChild(xmlNewNode)

				xmlNewNode = docProductInventory.createElement('SerialNo')
				xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes.get('serialNumber', 'n/a')))
				xmlHW.appendChild(xmlNewNode)

				matchObject = re.search('R?b?s?Subrack=([^,]+),R?b?s?Slot=(\d+)', dicAttributes['plugInUnitRef1'])
				if matchObject != None:
					xmlNewNode = docProductInventory.createElement('HWPos')
					xmlNewNode.setAttribute('SubrackId', '*'+matchObject.group(1)+'*')
					xmlNewNode.setAttribute('SlotNo', '%2.2d' % int(matchObject.group(2)))
					xmlHW.appendChild(xmlNewNode)

	
				xmlProductInventory.appendChild(xmlHW)
			except:
				print dicAttributes
				traceback.print_exc(None, sys.stdout)


		if FILE == 'screen':
			xml.dom.ext.PrettyPrint(docProductInventory, sys.stdout, encoding="ISO-8859-1")
		if FILE != None:
			xml.dom.ext.PrettyPrint(docProductInventory, open(FILE, 'w'), encoding="ISO-8859-1")
			os.chmod(FILE, 0777)
		else:
			pass
		
		return dicBoards

	## This shall be the main function and only return a xml object with the product inventory.
	## If it shall be printed then a function shall call this method.The same for returnning dicBoards.
	def getPI(self):
		dicBoards = {}
		
		docProductInventory = xml.dom.minidom.Document()

		# Create the Root Element
		xmlProductInventory = docProductInventory.createElement('ProductInventory')
		docProductInventory.appendChild(xmlProductInventory)

		for (proxy, mo) in self.pr('Slot'):
			dicAttributes = self.GetAttributes(proxy)
			if dicAttributes.get('productData', None) != None and dicAttributes.get('slotState', None) == '1':
				try:
					xmlHW = docProductInventory.createElement('HW')

					xmlNewNode = docProductInventory.createElement('ProdName')
					xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes['productData']['productName']))
					xmlHW.appendChild(xmlNewNode)

					xmlNewNode = docProductInventory.createElement('ProdId')
					xmlNewNode.setAttribute('ProdNo',  dicAttributes['productData']['productNumber'])
					xmlNewNode.setAttribute('ProdRev', dicAttributes['productData']['productRevision'])
					xmlHW.appendChild(xmlNewNode)

					if re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes['productData']['productionDate']) != None:
						mo_date = re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes['productData']['productionDate'])
						year  = mo_date.group(1)
						month = mo_date.group(2)
						day   = mo_date.group(3)
					elif re.match("(\d\d)(W\d\d)", dicAttributes['productData']['productionDate']) != None:
						mo_date = re.match("(\d\d)(W\d\d)", dicAttributes['productData']['productionDate'])
						year  = mo_date.group(1)
						month = mo_date.group(2)
						day   = '??'
					else:
						year  = '????'
						month = '??'
						day   = '??'
					
					xmlNewNode = docProductInventory.createElement('Date')
					xmlNewNode.setAttribute('Year', year)
					xmlNewNode.setAttribute('Day', day)
					xmlNewNode.setAttribute('Month', month)
					xmlHW.appendChild(xmlNewNode)

					xmlNewNode = docProductInventory.createElement('SerialNo')
					xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes['productData']['serialNumber']))
					xmlHW.appendChild(xmlNewNode)

					matchObject = re.search('Subrack=(\d+),Slot=(\d+)', mo)
					xmlNewNode = docProductInventory.createElement('HWPos')
					xmlNewNode.setAttribute('SubrackId', matchObject.group(1))
					xmlNewNode.setAttribute('SlotNo', '%2.2d' % int(matchObject.group(2)))
					xmlHW.appendChild(xmlNewNode)
					
					
					SlotId = "%2.2d%2.2d00" % (int(matchObject.group(1))-1, int(matchObject.group(2)))
					TEXT   = "%s (%s %s)" % (dicAttributes['productData']['productName'], dicAttributes['productData']['productNumber'], dicAttributes['productData']['productRevision'])
					
					dicBoards[SlotId] = {	'SMN'		:int(matchObject.group(1))-1,				\
								'APM'		:int(matchObject.group(2)),  				\
								'SLOTID'	:SlotId,						\
								'BOARD'		:dicAttributes['productData']['productName'],		\
								'PRODUCTNR'	:dicAttributes['productData']['productNumber'],		\
								'PRODUCTREV'	:dicAttributes['productData']['productRevision'],	\
								'TEXT'		:TEXT							\
								}
					
					dicAttributes = self.GetAttributes(self.getProxy(mo+',PlugInUnit=1'))

					xmlHW.setAttribute('LedG', dicAttributes['greenLed'])
					xmlHW.setAttribute('LedY', dicAttributes['yellowLed'])
					xmlHW.setAttribute('LedR', dicAttributes['redLed'])

					xmlProductInventory.appendChild(xmlHW)
				except:
					print dicAttributes
					traceback.print_exc(None, sys.stdout)
			else:
				pass
				
		for (proxy, mo) in self.pr('AuxPlugInUnit'):
			dicAttributes = self.GetAttributes(proxy)
			try:
				xmlHW = docProductInventory.createElement('HW')
				xmlHW.setAttribute('LedG', dicAttributes['greenLed'])
				xmlHW.setAttribute('LedY', dicAttributes['yellowLed'])
				xmlHW.setAttribute('LedR', dicAttributes['redLed'])

				xmlNewNode = docProductInventory.createElement('ProdName')
				xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes.get('productName', 'n/a')))
				xmlHW.appendChild(xmlNewNode)

				xmlNewNode = docProductInventory.createElement('ProdId')
				xmlNewNode.setAttribute('ProdNo',  dicAttributes.get('productNumber', 'n/a'))
				xmlNewNode.setAttribute('ProdRev', dicAttributes.get('productRevision', 'n/a'))
				xmlHW.appendChild(xmlNewNode)

				if re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes.get('productionDate', 'n/a')) != None:
					mo_date = re.match("(\d\d\d\d)(\d\d)(\d\d)", dicAttributes.get('productionDate', 'n/a'))
					year  = mo_date.group(1)
					month = mo_date.group(2)
					day   = mo_date.group(3)
				elif re.match("(\d\d)(w\d\d)", dicAttributes.get('productionDate', 'n/a')) != None:
					mo_date = re.match("(\d\d)(w\d\d)", dicAttributes.get('productionDate', 'n/a'))
					year  = mo_date.group(1)
					month = mo_date.group(2)
					day   = 'n/a'
				else:
					year  = 'n/a'
					month = 'n/a'
					day   = 'n/a'
				
				xmlNewNode = docProductInventory.createElement('Date')
				xmlNewNode.setAttribute('Year', year)
				xmlNewNode.setAttribute('Day', day)
				xmlNewNode.setAttribute('Month', month)
				xmlHW.appendChild(xmlNewNode)

				xmlNewNode = docProductInventory.createElement('SerialNo')
				xmlNewNode.appendChild(docProductInventory.createTextNode(dicAttributes.get('serialNumber', 'n/a')))
				xmlHW.appendChild(xmlNewNode)

				matchObject = re.search('R?b?s?Subrack=([^,]+),R?b?s?Slot=(\d+)', dicAttributes['plugInUnitRef1'])
				if matchObject != None:
					xmlNewNode = docProductInventory.createElement('HWPos')
					xmlNewNode.setAttribute('SubrackId', '*'+matchObject.group(1)+'*')
					xmlNewNode.setAttribute('SlotNo', '%2.2d' % int(matchObject.group(2)))
					xmlHW.appendChild(xmlNewNode)

	
				xmlProductInventory.appendChild(xmlHW)
			except:
				print dicAttributes
				traceback.print_exc(None, sys.stdout)

		return xmlProductInventory.cloneNode(1)

