#!/bin/bash -p

#========================================
# Paths definitions
#========================================
moshelldir=`dirname "$0"`
if [[ $moshelldir != /* ]] ; then moshelldir=`pwd`/$moshelldir ; fi
vobsinstallation=0
unamea=$(uname -a)
gawkext=""
gawklib=""
if [[ $unamea = [Ll][iI][nN][uU][xX]*x86_64* ]] ; then gawklib="lin64"   ; if [[ $vobsinstallation = 1 ]] ; then gawkext=".lin64" ; fi
elif [[ $unamea = [Ll][iI][nN][uU][xX]* ]]      ; then gawklib="linux"   ; if [[ $vobsinstallation = 1 ]] ; then gawkext=".linux" ; fi
elif [[ $unamea = SunOS*sparc* ]]               ; then gawklib="solaris" ; if [[ $vobsinstallation = 1 ]] ; then gawkext=".solaris" ; fi
elif [[ $unamea = SunOS* ]]                     ; then gawklib="sol86"   ; if [[ $vobsinstallation = 1 ]] ; then gawkext=".sol86" ; fi
else gawklib="cygwin" ; gawkext=".exe"
fi
gawkprog="gawk${gawkext}" 
gawk="$moshelldir/$gawkprog"
#special case where moshell has been installed on a linux 32 bit machine but should be run on linux 64 sharing the same file system
if [[ $unamea = [Ll][iI][nN][uU][xX]*x86_64* && $vobsinstallation != 1 && `file "$moshelldir/gawk"` = *32-bit* ]] ; then gawklib="linux" ; fi
filefunc="$moshelldir/commonjars/lib/${gawklib}/filefuncs"
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+${LD_LIBRARY_PATH}:}$moshelldir/commonjars/lib/${gawklib}
export LANG=C
export LC_ALL=C

moshell="$moshelldir/moshell"
funcs="$moshelldir/funcs.awk"
extern="$moshelldir/extern.awk"
defLogDir="$moshelldir/commonjars/defLogDir.sh"
moshellrc=$($defLogDir)
globmoshellrc=$moshelldir/jarxml/moshellrc
tempior=/tmp/ior$$_$(date +%H%M%S)
logdir="$moshelldir/logfiles/logs_notif"
temp_logdir=$($defLogDir notif)
umask 000
if [[ -w $temp_logdir && -d $temp_logdir ]] ; then logdir=$temp_logdir ; fi
mkdir -p $logdir
umask 022
#========================================

function print_usage()
{
cat <<EOF

Syntax: runClient.sh [options] <iorfile>|<nodeAddress>|<sitefile>
 
Options:
 -v : to specify moshell options from the command line (otherwise they are read from ~/.moshellrc and moshell files)
 -m : start mobrowser
 -p : start pmtester
 -n : start neal-mobrowser (the argument will then be a list of addresses, separated by commas)
 -a[s] : subscribe to alarm and event notifications (same entries that are stored in alarm/event logs)
 -c[s] : subscribe to CS notifications (MO attribute value change, MO created, MO deleted)
The s option (together with -a/-c) is only needed when running towards a secure node with corba_class=1.

Argument:
 - the sitefile can only be used with option "-n". It has the same format as mobatch sitefile, ie, one node address per line.
 - the node address can be either a node name from the ipdatabase, or an ipaddress, or a dns address.
 
Notes:
 - When running the options -a/-c, a logfile is automatically generated with the full output and the parsed output is printed on screen.
To parse this logfile while offline, just run the command "runClient.sh -a <logfile>" or "runClient -c <logfile>" depending on if the logfile contains alarm or CS notifications. 
 - A uservariable called "csnotiflist" allows to filter out certain attributes from the CS notifications when running the "-c" option.

Examples:
 runClient.sh -m rnc10  (run the mobrowser)
 runClient.sh -p mgw3   (run the pmtester)
 runClient.sh -a rxi2   (subscribe to alarms and events)
 runClient.sh -as -v corba_class=1,security_method=2,sa_credential=~/sam.pbe,sa_password=secret rbs3
 runClient.sh -c -v corba_class=3,sa_credential=~/sam.pbe,sa_password=secret rnc2
 runClient.sh -c -v csnotiflist=availabilitystatus,reservedby,operationalstate rnc9 
 runClient.sh -n rnc10,rn11,rbs34,rbs28  (run the neal mobrowser against several nodes)
 runClient.sh -n /home/user/sitefiles/rbs_sitefile   (run the neal mobrowser against several nodes specified in a sitefile)
EOF
}

#The f option (together with -a/-c) is to save the full printouts to a predefined file.
  
iorfile=""
node_address=""
run_secure=""
what="undef"
userVariables=""
full="full"

while getopts "afcmnpsv:" options
do
case $options in
a) what="alarmnotif" ;;
c) what="csnotif" ;;   
m) what="mobrowser" ;;
p) what="pmtester" ;;
n) what="nealmob"  ;;
s) run_secure="_secure" ;;
v) userVariables="$OPTARG";;
f) full="full" ;;
esac
done 
shift $(($OPTIND - 1))
if test $OPTIND -eq 1 ; then print_usage ; exit 1; fi
if [[ $what = undef ]] ; then print_usage ; exit 1 ; fi

case $# in
 1) if test -s $1 ; then iorfile=$1 ; else node_address=$1 ; iorfile=$tempior ; fi ;;
 *) print_usage ; exit 1;;
esac

function cleanup()
{
rm -f $tempior
exit
}

trap 'cleanup' 0 1 2 3 15 

$gawk -v node_address="$node_address" -v iorfile="$iorfile" -v moshelldir="$moshelldir" -v moshell="$moshell" -v moshellrc="$moshellrc" -v globmoshellrc="$globmoshellrc" -v what="$what" -v run_secure="$run_secure" -v vobsinstallation="$vobsinstallation" -v userVariables="$userVariables" -v gawk="$gawk" -v full="$full" -v logdir="$logdir" -v tempior="$tempior" -v extern="$extern" -f "$funcs" -f "$extern" -l "$filefunc" --source '
BEGIN{
	if (what=="nealmob") multi=1
	loadFilefuncs()
	parse_user_variables(moshell)	
	parse_user_variables(globmoshellrc)		
	parse_user_variables(moshellrc)
	parse_commandlineOptions(userVariables)
	parse_common_variables()
	if (multi)
	{
		old_ip_connection_timeout=ip_connection_timeout
		ip_connection_timeout=5	
		node_address_list=""
		if (node_address != "") last=split(node_address,array,",")
		else
		{
			#we have a sitefile
			while (getline < iorfile) if ($1 !~ /^($|#)/) array[++last]=$1
			close(iorfile)
			iorfile=tempior
		}
		for (i=1;i<=last;i++)
		{
			if (array[i]=="") continue
			node_address=find_node_address(array[i],resultTable)
			if (httpget(node_address,"/cello/ior_files/nameroot.ior",iorfile,"ior")==0) nodeList[++nrOfNodes]=node_address
		}
		for (i=1;i<=nrOfNodes;i++) node_address_list=node_address_list" "nodeList[i]
		ip_connection_timeout=old_ip_connection_timeout		
	}
	else
	{
		if (node_address != "") 
		{
			node_address=find_node_address(node_address,resultTable)
			customPrint("Connecting to "node_address"...")
			if (httpget(node_address,"/cello/ior_files/nameroot.ior",iorfile,"ior")!=0) exit
		}
		else
		{
			#check if the iorfile is an alarm/cs log for postprocessing
			getline < iorfile ; close(iorfile) 
			if (! /^IOR/) 
			{
				system(sprintf("cat %s | %s -f %s -f %s --source \x027 BEGIN{ parse_notifications(\"%s\") } \x027",iorfile,gawk,funcs,extern,what))
				exit
			}
		}
	}
	tmp_java_command=make_java_command(sprintf("%s%s",what,(what ~ /^(alarm|cs)notif$/ ? run_secure : "")))
	if (what ~ /^(alarm|csnotif)/)
	{
		notiflogfile=sprintf("%s/%s_%s_%s.log",logdir,what,node_address,strftime("%y%m%d_%H%M%S",systime()))
		customPrint("Full output will be logged to "notiflogfile" !!")
		tmp_pipe_command=" | "sprintf("%s -v csnotiflist=\"%s\" -f %s -f %s --source \x027 BEGIN{ parse_notifications(\"%s\",\"%s\")} \x027",gawk,csnotiflist,funcs,extern,what,notiflogfile)
	}
	system(sprintf("%s%s",tmp_java_command,tmp_pipe_command))
}
'
