package Port;

use strict;
use warnings;

sub new {
	my $class = shift;
	my $input = shift;
	my $is_gen_one = shift;
	
	my @input_array = @$input;
	my $input_length = @input_array;
	
	#For WCDMA RBS Gen1 (do not contain any Ril/length -> add empty values to those pos. in array)
	if($input_length == 15){
		splice @input_array, 2, 0, '';
		splice @input_array, 15, 0, '';
	}
	
	my $id = $input_array[0];
	my $t = $input_array[1];
	my $ril = "";
	$ril = $input_array[2] if($input_array[2] =~ m/^\d+$/);
	


	
	# OUTPUT
	my $out_board = $input_array[3];
	my $out_desc = $input_array[4];
	
	#000100/port_xcu_dev_14/port_5_dev_20 blir 000100/px_d14/p5_d20
	if($out_desc =~ m/^\S+\/port_\S+_\S+_\S+\/port_\S+_\S+_\S+$/){
		$out_desc = join("", ($out_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	elsif($out_desc =~ m/^\S+\/port_\S+_\S+_\S+$/) {
		$out_desc = join("", ($out_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	
	
	# SPEED
	my ($rate) = ($input_array[8] =~ m/(\d.\d)G/);
	$rate = join("",split(/\./, $rate)) if(defined($rate));
	$rate = substr($rate, 0, 2) if(defined($rate));
	
	
	
	# INPUT
	my $in_board = $input_array[9];
	my $in_desc = $input_array[10];
	
	#000100/port_xcu_dev_14/port_5_dev_20 blir 000100/px_d14/p5_d20
	if($in_desc =~ m/^\S+\/port_\S+_\S+_\S+\/port_\S+_\S+_\S+$/){
		$in_desc = join("", ($in_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	elsif($in_desc =~ m/^\S+\/port_\S+_\S+_\S+$/) {
		$in_desc = join("", ($in_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	
	
	# CONNECTION LENGTH
	my $length = $input_array[15];
	if(length($length) == 5){
		my $val = join(".", ($length =~ m/^(\d)(\d)\d\dm$/));
		$length = $val . "k";
	}elsif(length($length) == 6){
		my $val = join("", ($length =~ m/^(\d)(\d)\d\d\dm$/));
		$length = $val . "k";
	}

	
	
	#Separate the MOs
	my @mos = (split(" ", $input_array[16]));
	my $_mo1 = $mos[0];
	my $_mo2 = $mos[1];
	
	my ($out_bridge,$out_port,$in_bridge,$in_port);

	#Matches MO '1,RbsSlot=1,AuxPiu=RU-1-1(D1)'
	if($_mo1 =~ m/^\S+,.+=.+,.+=.+\(.+\)$/) {
		$out_bridge = join("/", ($_mo1 =~ m/^(\S+),.+=(.+),.+=(.+)\(.+\)$/));
		($out_port) = ($_mo1 =~ /.+\((.+)\)$/);
	}
	#Matches MO '1-1,AuxPiu=RRUW-1(D1)'
	elsif($_mo1 =~ m/^\d+-\d+,.+=.+\(.+\)$/) {
		$out_bridge = join("/", ($_mo1 =~ m/^(\d+-\d+),.+=(.+)\(.+\)$/));
		($out_port) = ($_mo1 =~ /.+\((.+)\)$/);
	}
	#Else MO of form AuxPiu=RRU-6(D1)
	else {
		my $mo1 = (split("=", (split(" ", $input_array[16]))[0]))[1];
		($out_bridge, $out_port) = ($mo1 =~ /(.+)\((.+)\)/);
	}
	if($_mo2 =~ m/^\S+,.+=.+,.+=.+\(.+\)$/) {
		$in_bridge = join("/", ($_mo2 =~ m/^(\S+),.+=(.+),.+=(.+)\(.+\)$/));
		($in_port) = ($_mo2 =~ m/^.+\((.*)\)/);
	}
	elsif($_mo2 =~ m/^\d+-\d+,.+=.+\(.+\)$/) {
		$in_bridge = join("/", ($_mo2 =~ m/^(\d+-\d+),.+=(.+)\(.+\)$/));
		($in_port) = ($_mo2 =~ /.+\((.+)\)$/);
	}
	else {
		my $mo2 = (split("=", (split(" ", $input_array[16]))[1]))[1];
		($in_bridge, $in_port) = ($mo2 =~ /(.+)\((.+)\)/);
	}
	
	
	
	my $out_label = $out_bridge;
	my $in_label = $in_bridge;
	
	if($is_gen_one && $out_desc =~ m/^000\d00$/) {
		$out_label = "1/$out_bridge";
	}
	if($is_gen_one && $in_desc =~ m/^000\d00$/) {
		$in_label = "1/$out_bridge";
	}
	
	my $out_key = join("&", $out_bridge, $out_desc);
	my $in_key = join("&", $in_bridge, $in_desc);

	# print "- out_key: $out_key\n";
	# print "- in_key: $in_key\n\n";

	if($out_key eq $in_key){
		return 0;
	}

	my $self = {
		_id			=> 	$id,
		_t			=>	$t,
		_ril		=>	$ril,
		_rate		=>	$rate,
		_length		=>	$length,
		_out_key	=>	$out_key,
		_out_bridge	=>	$out_key,
		_out_label	=>	$out_label,
		_out_port	=>	$out_port,
		_out_desc	=>	$out_desc,
		_out_board	=>	$out_board,
		_in_key		=>	$in_key,
		_in_bridge	=>	$in_key,
		_in_label	=>	$in_label,
		_in_port	=>	$in_port,
		_in_desc	=>	$in_desc,
		_in_board	=>	$in_board,
	};
	
	#DEBUG
#	print "\n---- New Port ----\n";
#	print "Bridge (out): $outBridge\n";
#	print "Port (out): $outPort\n";
#	print "Desc (out): $outDesc\n";
#	print "Bridge (in): $inBridge\n";
#	print "Port (in): $inPort\n";
#	print "Desc (in): $inDesc\n";
#	print "\n";
	

	bless $self, $class;

	return $self;
}

sub getOutBridgeKey {
	my ($self) = @_;
	return $self->{_out_key};
}

sub getOutBridge {
	my ($self) = @_;
	return $self->{_out_key};
}

sub getOutLabel {
	my ($self) = @_;
	return $self->{_out_label};
}

sub getOutBoard {
	my ($self) = @_;
	return $self->{_out_board};
}

sub getOutPort {
	my ($self) = @_;
	return $self->{_out_port};
}

sub getOutDesc {
	my ($self) = @_;
	return $self->{_out_desc};
}

sub getInBridgeKey {
	my ($self) = @_;
	return $self->{_in_key};
}

sub getInBoard {
	my ($self) = @_;
	return $self->{_in_board};
}

sub getInBridge {
	my ($self) = @_;
	return $self->{_in_key};
}

sub getInLabel {
	my ($self) = @_;
	return $self->{_in_label};
}

sub getInPort {
	my ($self) = @_;
	return $self->{_in_port};
}

sub getInDesc {
	my ($self) = @_;
	return $self->{_in_desc};
}

sub getPortIdentifier {
	my ($self) = @_;
	return $self->{_id};
}

sub getRil {
	my ($self) = @_;
	return $self->{_ril};
}

1;
