#!/usr/bin/python
referencesForNcc = ''
import random
def createIpInterfacesMo(rinpm, subrackNos, slotNos):
    ipInterfaces = ""
    for x in range(0, len(slotNos)):
        ipInterfaces += """CREATE
(
   parent "ManagedElement=1,Equipment=1,Subrack={0},Slot={1},PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1"
   identity "{r[defaultRouter]}-IUX"
   moType IpInterface
   exception none
   nrOfAttributes 18
   defaultRouter0 String "{r[defaultRouter]}"
   defaultRouter1 String "0.0.0.0"
   defaultRouter2 String "0.0.0.0"
   defaultRouterPingInterval Integer 4
   maxNoOfFailedPings Integer 2
   maxWaitForPingReply Integer 3
   mtu Integer 1500
   networkPrefixLength Integer {r[subnet_mask]}
   noOfPingsBeforeOk Integer 2
   ownIpAddressActive String "0.0.0.0"
   ownIpAddressPassive String "0.0.0.0"
   rps Boolean false
   switchBackTimer Integer 180
   trafficType Integer 0
   userLabel String "{r[defaultRouter]}-IUX\"
   vLan Boolean false
   vid Integer 1
   vlanRef Ref "ManagedElement=1,EthernetSwitchFabric=1,Vlan={r[vlan_for_iux]}"
)
""".format(subrackNos[x], slotNos[x], r = rinpm)
    return ipInterfaces

def createVlanMo(vlan_for_iux):
    return """CREATE
(
   parent "ManagedElement=1,EthernetSwitchFabric=1"
   identity "{0}"
   moType Vlan
   exception none
   nrOfAttributes 3
   userLabel String "{0}"
   vid Integer {0}
   vlanType Integer 0
)""".format(vlan_for_iux)

def getRncId(path,file):
    return """lt all
l+ {0}{1}
get RncFunction rncId
l-""".format(path,file)

def createNccMo(nccId, clusterMember, rncId, firstMainServerAddresses, numberOfboards, rncType, subrackNo, slotNo): #NodeClusterCommunication
    global referencesForNcc
    s = """CREATE
(
   parent "ManagedElement=1,SystemFunctions=1"
   identity "{0}"
   moType NodeClusterCommunication
   exception none
   nrOfAttributes 6
   administrativeState Integer 0
   clusterIdentity Integer {1}
   dscp Integer 18
   firstMainServerAddresses Array String 2
      "{f[0]}"
      "{f[1]}"
   ipAccessList Array Reference {2}""".format(nccId, rncId, numberOfboards, f = firstMainServerAddresses)
    for x in range (0,len(slotNo)):
        if rncType == 'RNC_8200':
            s += '\n      \"ManagedElement=1,IpSystem=1,IpAccessHostEt='+subrackNo[x]+'-'+slotNo[x]+'-IUX\"'
    if rncType == "RNC_3820":  
        s+= '\n' + referencesForNcc[:-1]
    s += """
   memberIdentity Integer {0}
)
CREATE
(
   parent "ManagedElement=1,SystemFunctions=1,NodeClusterCommunication={0}"
   identity "{1}"
   moType ClusterMember
   exception none
   nrOfAttributes 2
   administrativeState Integer 0
   memberIdentity Integer {1}
)""".format(nccId, clusterMember)
    return s
    
def createIuxUp(nccId, clusterMember, input_iux):
    s = ""
    for x in input_iux[0:len(input_iux)]:
        if 'IUR' in x:
            x=x.replace("IUR","IUX")
        s += x
    return s + """CREATE
(
   parent "ManagedElement=1,SystemFunctions=1,NodeClusterCommunication={0},ClusterMember={1}"
   identity "{1}"
   moType RncClusterMember
   exception none
   nrOfAttributes 2
   ipAccessHostPoolRef Ref "ManagedElement=1,IpSystem=1,IpAccessHostPool=IUX"
   redundancySwitchoverWaitTime Integer -1
)""".format(nccId, clusterMember)
def delete_ss7configuration():
    comlist = """del IuLink=.*,Ranap=
del IurLink=.*,Rnsap=
del SasPositioning=.*,Pcap=
del SccpApLocal=	
del SccpApRemote=
del Mtp3bAp=
del SccpScrc=
del SccpSp=
del Mtp3bSr=
del M3uAssociation=
del Mtp3bSrs=
del Mtp3bSpItu=

"""
    return comlist

#Copy SS7 configuration from CM1    
def get_ss7configuration(path):
    comlist = """lt all
u+s {0}
del IuLink=.*,Ranap=
del IurLink=.*,Rnsap=
del SasPositioning=.*,Pcap=
del SccpApLocal=
del SccpApRemote=
del Mtp3bAp=
del SccpScrc=
del SccpSp=
del Mtp3bSrs=
del Mtp3bSpItu=
u-
u! $undocommandfile
u! $undodelcommandfile

""".format(path)
    return comlist
    
def getIur(path,rncId):
    return """lt all
l+ {0}
get IurLink=Iur rncId {1}
l-""".format(path,rncId)

def deleteIur(iur):
    return """lt all
rdel IurLink={0}
""".format(iur)

def simulatedDeleteIur(path,iur):
    return """lt all
u+s {0}
del RncFunction=1,IurLink={1},ExternalUtranCell=Ext 
u-
u! $undocommandfile
u! $undodelcommandfile""".format(path,iur)

def simulatedDeleteIur2(path,iur):
    return """lt all
u+s {0} 
ma exterCell RncFunction=1,IurLink={1},ExternalUtranCell=Ext reservedBy 
del exterCell 
u-
u! $undocommandfile
u! $undodelcommandfile""".format(path,iur)

def backup_frontends(path):
    comlist = """lt all
u+s {0}
del Mtp3bSr=
del M3uAssociation=
u-
u! $undocommandfile
u! $undodelcommandfile
""".format(path)
    return comlist

#copy M3UAssociations from CM1    
def restore_ss7configuration(path):
    comlist = """lt all
u+s {0}
del Mtp3bSr=
del M3uAssociation=
u-
u! $undocommandfile
u! $undodelcommandfile
""".format(path)
    return comlist
    
def get_local_M3uAssociations(path):
    comlist = """lt all
mr localM3ua
mr localSr
ma localM3ua M3uAssociation sctpId Sctp
ma localSr localM3ua reservedBy
u+s {0}
del localSr
del localM3ua
u-
u! $undocommandfile
u! $undodelcommandfile""".format(path)
    return comlist

def setRncId(rncId):
    return "set RncFunction=1 rncId "+ rncId
    
def featureActivationMos(nccId, clusterMember):
    if nccId == "1":
        return """set SystemFunctions=1,Licensing=1,RncFeature=RncCluster featureState 1
set SystemFunctions=1,NodeClusterCommunication={0} administrativeState 1
set SystemFunctions=1,NodeClusterCommunication={0},ClusterMember={1} administrativeState 1
cvms NodeClusterCommunitaion_Activated
facc 0 manualrestart 2 0 cluster
pol 10 10""".format(nccId, clusterMember)
    else:
        return """set SystemFunctions=1,NodeClusterCommunication={0} administrativeState 1
set SystemFunctions=1,NodeClusterCommunication={0},ClusterMember={1} administrativeState 1
cvms NodeClusterCommunitaion_Activated
""".format(nccId, clusterMember)

def licensing():
    return """set SystemFunctions=1,Licensing=1,RncFeature=RncCluster featureState 1"""
    
def createIpTermServ(noOfGpbs, subrackNoGpb, slotNoGpb, subrackNo, slotNo):
    s = ""
    global referencesForNcc
    
    for x in range (0,noOfGpbs):
       # print("petla "+str(x))
        tab = []    
        for y in range (0,len(subrackNo)):
            if subrackNoGpb[x] == subrackNo[y]:
                
                tab.append(y)
        
        a = random.choice(tab)
        b = a;
        while a == b:
            b = random.choice(tab)

        s += """
CREATE
(
   parent "ManagedElement=1,IpSystem=1"
   identity "{0}-{1}"
   moType IpTermServ
   exception none
   nrOfAttributes 4
   plugInUnitRef Ref "ManagedElement=1,Equipment=1,Subrack={0},Slot={1},PlugInUnit=1"
   primaryIpAccessRef Ref "ManagedElement=1,IpSystem=1,IpAccessHostEt={2}-{3}-IUX"
   secondaryIpAccessRef Ref "ManagedElement=1,IpSystem=1,IpAccessHostEt={4}-{5}-IUX"
   userLabel String "{0}-{1}"
)
""".format(subrackNoGpb[x],slotNoGpb[x],subrackNo[a],slotNo[a],subrackNo[b],slotNo[b])
        referencesForNcc += """   "ManagedElement=1,IpSystem=1,IpTermServ={0}-{1}"
""".format(subrackNoGpb[x],slotNoGpb[x])
    return s

def createIpAccessHostEtFromSingleAddress(first_address, defaultRouter, subrackNo, slotNo):
    ip_last = first_address.split(".")[-1]
    ip_pre_last = first_address.split(".")[-2]
    ip_second_octet = first_address.split(".")[-3]
    ip_first_octet = first_address.split(".")[0]
    ip_last = int(ip_last)
    print ip_last
    s = ""
    for x in range (0,len(slotNo)):
        s += """CREATE
(
   parent "ManagedElement=1,IpSystem=1"
   identity "{0}-{1}-IUX"
   moType IpAccessHostEt
   exception none
   nrOfAttributes 8
   administrativeState Integer 1
   ipAddress String "{6}.{5}.{4}.{2}"
   ipDefaultTtl Integer 64
   ipInterfaceMoRef Ref "ManagedElement=1,Equipment=1,Subrack={0},Slot={1},PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface={3}-IUX"
   networkPrefixLength Integer 0
   ntpDscp Integer 54
   ntpServerMode Integer 0
   userLabel String "{0}-{1}-IUX"
)
""".format(subrackNo[x], slotNo[x], str(ip_last), defaultRouter,str(ip_pre_last),str(ip_second_octet),str(ip_first_octet))
        ip_last += 1
    return s
    
def createIpAccessHostEt(first_address, defaultRouter, subrackNo, slotNo):
   
    if len(first_address) is not len(slotNo):
        print "incorrect number of provided blade adresses"
        sys.exit()
    s = ""
    for x in range (0,len(slotNo)):
        s += """CREATE
(
   parent "ManagedElement=1,IpSystem=1"
   identity "{0}-{1}-IUX"
   moType IpAccessHostEt
   exception none
   nrOfAttributes 8
   administrativeState Integer 1
   ipAddress String "{2}"
   ipDefaultTtl Integer 64
   ipInterfaceMoRef Ref "ManagedElement=1,Equipment=1,Subrack={0},Slot={1},PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface={3}-IUX"
   networkPrefixLength Integer 0
   ntpDscp Integer 54
   ntpServerMode Integer 0
   userLabel String "{0}-{1}-IUX"
)
""".format(subrackNo[x], slotNo[x], first_address[x], defaultRouter)
        
    return s

def vlanCmxbMos(input_cmxb, vlan_for_iux):
    mo_name, vlanref = [], []
    #parsing MOs for cmxb boards
    for x in input_cmxb[0:len(input_cmxb)]:
        if  'EthernetSwitchModulePort' in x: 
            for yy in range(0,len(x)):
                if x[yy]==' ':
                    mo_name.append(x[0:yy])
                    break
    #parsing vlan references for cmxb
    for x2 in input_cmxb[len(input_cmxb):0:-1]:
        if  'EthernetSwitchModulePort' in x2:
            counter =  0
            for yy2 in x2[len(x2):0:-1]:
                counter = counter + 1
                if yy2==']':
                    vlanref.append(x2[len(x2)-counter+4:len(x2)])
                    break
    #creating script rof adding vlan reference for iux
    s = ""
    for x3 in range(0,len(mo_name)):
        s += "set "+mo_name[x3]+' vlanref '+vlanref[x3].strip('\n')+" Vlan=" + vlan_for_iux + "\n"
    return s
    
def saveCvAndRestart():
    comlist = """cvms IuxUpConfigured
facc 0 manualrestart 2 0 cluster
pol 10 10"""
    return comlist
    
def activateSignaling(cvName,program_path):
    comlist = """lt all
confb+
l+ {1}migration.log
hget m3ua autoStartAssociation false
facc hget_group setAutoActivate
cvms {0}
l-
""".format(cvName,program_path)
    return comlist
    
def restoreM3uCM1(program_path):
    return """lt all
confb+
l+ {0}migration.log
trun {0}CM2_M3uAssociations_replaced.mo
l-
""".format(program_path)

def createAndPingIuxEtGroup(rncType,defaultRouter,program_path,CMscripts):
    comlist = """lt all
mr IuxEt
"""
    if rncType == "RNC_3820":
        comlist += """ma IuxEt IpAccessHostEt reservedby iptermserv
"""
    else:
        comlist += """ma IuxEt IpAccessHostEt reservedby cluster
"""
    comlist += """l+ {0}{cm[iuxet_ping]}
facc IuxEt ping {1}
l-""".format(program_path,defaultRouter,cm = CMscripts)
    return comlist

def getUserPlaneRouterIp(program_path,CMscripts):
    return """lt all
l+ {0}{cm[iuxup_ip]}
mr iubref
ma iubref Pool=IUX ipAccessHostRef
get iubref ipInterfaceMoRef 
l-
    """.format(program_path,cm = CMscripts)

def pingUserPlaneRouterIp(defaultRouter,program_path,CMscripts):
    return """lt all
confb+
mr iuxupet
ma iuxupet IpAccessHostPool=IUX ipAccessHostRef
l+ {1}{cm[iuxup_ping]}
facc iuxupet ping {0}
l-   
""".format(defaultRouter, program_path, cm = CMscripts)
    
def migrationMos(program_path, rncType, CMscripts,nccId):
    ipTerm = "" if rncType != 'RNC_3820' else  'trun ' + CMscripts["ipTermServ"] # only for 3820
    if nccId == "1":
        return """lt all
confb+
l+ {0}migration.log
cvms STANDALONE_CV
l cd {0}
trun {cm[vlan]}
run {cm[vlan_cmxb]}
trun {cm[ipinterfaces]}
trun {cm[ipaccesshostEt]}
{1}
trun {cm[ncc]}
run {cm[iuxet_ping]}

l-""".format(program_path, ipTerm, cm = CMscripts)
    elif nccId == "1.1":
        return """lt all
confb+
l+ {0}migration.log
l cd {0}
run {cm[feature_activation]}
truni {cm[iux_up]}
run {cm[iuxup_ip]}
l-""".format(program_path, ipTerm, cm = CMscripts)
    elif nccId == "2":
         return """lt all
confb+
l+ {0}migration.log
cvms STANDALONE_CV
l cd {0}
trun {cm[vlan]}
run {cm[vlan_cmxb]}
trun {cm[ipinterfaces]}
trun {cm[ipaccesshostEt]}
{1}
run {cm[delete_ss7]}
l-""".format(program_path, ipTerm, cm = CMscripts)
    elif nccId == "2.1":
        return """lt all
confb+
l+ {0}migration.log
l cd {0}
run {cm[set_rnc_id]}
trun {cm[ncc]}
run {cm[iuxet_ping]}
l-""".format(program_path, ipTerm, cm = CMscripts)
    elif nccId == "2.2":
        return """lt all
confb+
l+ {0}migration.log
l cd {0}
run {cm[feature_activation]}
trun {cm[ss7]}
trun {cm[m3u_replaced]}
truni {cm[iux_up]}
run {cm[iuxup_ip]}
run {cm[licensing]}
trun {cm[restore_backup_replaced]}
run {cm[save_cv_and_restart]}
l-""".format(program_path, ipTerm, cm = CMscripts)
# cvms USER_PLANE_FOR_IUX

#reconfiguration sctp frontends scripts:

def getSCTP(path,board):

    path += board
    if board == "C1":
        x="3"
        y="25"
    elif board == "C2":
        x="4"
        y="26"
        
    return """u+s {0}
hget M3uAssociation sctpId Sctp=Ms-{1}
rdel hget_group
hget M3uAssociation sctpId Sctp=Ms-{2}
rdel hget_group
u-
u! $undocommandfile
u! $undodelcommandfile""".format(path,x,y)

def getM3uA(path,board):

    if board == "C1":
        x="3"
    elif board == "C2":
        x="4"
    path += board + "_" + x        
    return """u+s {0}
hget M3uAssociation sctpId Sctp=Ms-{1}
rdel hget_group
hget M3uAssociation sctpId Sctp=Ms-{2}
rdel hget_group
u-
u! $undocommandfile
u! $undodelcommandfile""".format(path,x)

def cos(path,board):
    
    if board == "C1":
        x="3"
    elif board == "C2":
        x="4"
    path += board + "_" + x    
    return """u+s {0}

get TransportNetwork=1,Sctp=MS-{1}

get IpSystem=1,IpAccessSctp=MS-{1}

del TransportNetwork=1,Sctp=MS-{1}$
del IpSystem=1,IpAccessSctp=MS-{1}$
del IpSystem=1,IpAccessHostEt=MS-{1}-1$
del IpSystem=1,IpAccessHostEt=MS-{1}-2$
u-

u! $undocommandfile
u! $undodelcommandfile""".format(path,x)
def ipig(path, board,slot):

    path += board + "_" + slot  
    return """u+s {0}
del SwManagement=1,ReliableProgramUniter=sctp_host_MS-{1}-0
u-
u! $undocommandfile
u! $undodelcommandfile
""".format(path,slot)