import os, json, sys, mo, mo_parsing

MOSHELL_PATH = ""

def setupMoshellPath(path):
    global MOSHELL_PATH
    MOSHELL_PATH = path

def deleteFile(fpath):
    try:
        os.remove(fpath)
    except:
        pass
        
def deleteOldFiles(fpath,tempFiles):
    deleteFile(fpath + tempFiles["rncfunc"])
    deleteFile(fpath + tempFiles["vlan"])
    deleteFile(fpath + tempFiles["cab"])
    deleteFile(fpath + tempFiles["iux_up"])
    deleteFile(fpath + tempFiles["iux_up"]+"s")
    deleteFile(fpath + tempFiles["iux_up"][:-3]+".log")
    deleteFile(fpath + tempFiles["iux_up"][:-3]+"_del.mos")
    deleteFile(fpath + "migration.log")

def writeMos(filename, func):
    try:
        with open(filename,'w') as f:
		    f.write(func)
    except:
        print "Exception during writing to", filename
        exit(0)
    print ">>> mos file ready: "+filename

def get_program_path():
    return os.getcwd() + '/'

def readJson(filename):
    try:
        List = json.load(file(filename))
    except:        
        print 'Error in JSON file:',filename
        raw_input()
        List = 0
    print filename, ' was loaded'
    return List

def run_moshell_session(credentials, filename):
    cr = "password=" + credentials["pw"] + " " + credentials["ip"]
    global MOSHELL_PATH
    mos_session = os.popen(MOSHELL_PATH + " " + cr + " " + filename)
    try:
        while 1:
            line = mos_session.readline()
            if not line: break
            print line.rstrip('\n')
        #os.system('mossel session')
    except:
        error = 1
        print "Error during mos_session"
        exit(0)
	print "moshell session finished"
    
def trun_moshell_session(credentials, filename):
    run_moshell_session(credentials,"\"trun " + filename + "\"")
    
def getRncId(working_path,cm,rinpmjson):
    writeMos(working_path + cm +"/" + rinpmjson["iur"]["scripts"]["get_rnc_id"], mo.getRncId(working_path + cm +"/",rinpmjson["iur"]["logs"]["rnc_id"]))
    run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/"  +  rinpmjson["iur"]["scripts"]["get_rnc_id"])
        
    rncId = mo_parsing.getId(working_path + cm +"/" + rinpmjson["iur"]["logs"]["rnc_id"])  
    deleteFile(working_path + cm +"/" + rinpmjson["iur"]["logs"]["rnc_id"])
    return rncId
    
def getInputFromFiles(fpath, tempFiles):
    # take info for CM
    
    d = {}
    for k in tempFiles.keys():
        with open(fpath + tempFiles[k]) as f:
            d[k] = f.readlines()
        
    return d

def get_moshell_output(program_path, credentials, tempFiles):
    deleteOldFiles(program_path,tempFiles)  
    #for k in tempFiles.keys():
        #open(program_path + tempFiles[k],'w').close()  # create empty file if it doesn't exist yet
  
    # comlist is
    # printout for CMXB ports
    # printout for ipinterfaces and rncid
    # u+s for Iux User Plane (used IUR)
    # getting type of rnc 3820 and Evo only supported
    comlist = """lt all
hget EthernetSwitchModulePort administrativeState 1
l+ {0}{t[vlan]}
hget hget_group vlanref
l-
l+ {0}{t[cab]}
cab
get RncFunction rncId
l-
u+s {0}{t[iux_up]}
del pool=iur
u-
u! $undocommandfile
l+ {0}{t[rncfunc]}
get RncFunction rncType
l-
""".format(program_path,t = tempFiles)
    writeMos(program_path + "printout.mos", comlist)
    #Moshell sesion for getting printouts
    run_moshell_session(credentials, program_path+"printout.mos")
    os.unlink(program_path + "printout.mos")
    #os.unlink(tempFiles["iux_up"])
    #os.unlink(tempFiles["iux_up"]+".mos")
    #os.unlink(tempFiles["iux_up"]+"_del.mos")

