#!/usr/bin/python
import mo, mo_parsing
import mo_input as mo_io
import os,sys,shutil
import iur
#todo - find place to hold names of scripts generated on CM1 to be run on CM2
clusterRncId = ''

#delete unneeded files
def clean(path,json):

    for cm in ("CM1","CM2"):
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxet_ping"])
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxup_ping"])
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxup_ip"])
        mo_io.deleteOldFiles(path + cm + '/',json[cm]["tempFiles"])
        
    CMjson = json["CM2"]
    
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"])
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+"_del.mos")
    
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"])
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+"_del.mos")
    
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+"_del.mos")
    
def prepareMigrationMos(nccId, clusterMember, fpath, json,rncId):
    #=======================MOSHELL SESSION=========================================
    
    CMjson = json[str("CM"+nccId)]
   
    tempFiles = CMjson["tempFiles"]
   
    #collect needed data from nodes
    mo_io.get_moshell_output(fpath, CMjson["credentials"], tempFiles)
    rncPrintout = mo_io.getInputFromFiles(fpath, tempFiles)

    #inputCM1
    migrMos = CMjson["migr_mos"]
    rinpmCmInput = CMjson["rinpm_input"]
    rinpmCmInput["nccId"] = nccId # memberId
    rinpmCmInput["clusterMember"] = clusterMember
    mo_io.writeMos(fpath + migrMos["vlan"], mo.createVlanMo(rinpmCmInput["vlan_for_iux"]))
    
    #=====================Checking type of RNC======================================
    rncType, boardType = mo_parsing.checkRncType(rncPrintout["rncfunc"])
    if rncType == 'RNC_3820' and rinpmCmInput["nccId"] == "2":
        print 'CM2 has to be Evo'
        sys.exit()
    mo_io.writeMos(fpath + migrMos["vlan_cmxb"], mo.vlanCmxbMos(rncPrintout["vlan"], rinpmCmInput["vlan_for_iux"]))
    mo_io.writeMos(fpath + migrMos["iuxet_ping"], mo.createAndPingIuxEtGroup(rncType, rinpmCmInput["defaultRouter"], fpath, CMjson))
    mo_io.writeMos(fpath + migrMos["iuxup_ip"], mo.getUserPlaneRouterIp(fpath,CMjson))
    #parsing printout for EPBs(Evo)/ET-IPG(3820)
    
    subrackNo, slotNo, numberOfboards = mo_parsing.parsingBoard(rncPrintout["cab"], boardType)
    print "subrackNo, slotNo, numberOfboards, rncId: ", subrackNo, slotNo, numberOfboards, rncId
	
    global clusterRncId  # rncId is copied from CM1 and set to CM2
    #get id and SS7 stack from CM1
    if nccId == "1":
        ss7configurationFile = fpath + json["CM2"]["migr_mos"]["ss7"]
        
        ss7configurationFile = ss7configurationFile.replace("CM1","CM2")
        m3uaFile = (fpath + json["CM2"]["migr_mos"]["m3u"]).replace("CM1","CM2")
        
        #get rncId from CM1 to be used on CM2
        clusterRncId = rncId
        
        mo_io.writeMos(fpath + migrMos["get_ss7"],mo.get_ss7configuration(ss7configurationFile))
        mo_io.writeMos(fpath + migrMos["get_M3uAssociations"],mo.restore_ss7configuration(m3uaFile))
        
        mo_io.writeMos(fpath + "restoreM3uCM1.mos", mo.restoreM3uCM1(fpath) )
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["get_ss7"]) 
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["get_M3uAssociations"]) 
        
        os.remove(fpath + migrMos["get_ss7"])
        os.remove(fpath + migrMos["get_M3uAssociations"])
              
        mo_parsing.modifySs7Configuration(m3uaFile,"CM1",False,False,True)
     
    elif nccId == "2":
      
        mo_io.writeMos(fpath + migrMos["backup_frontends"],mo.backup_frontends(fpath + migrMos["restore_backup"]))
        
        #backup frontends from CM2
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["backup_frontends"])
        
        #change identity and set autoStartAssociation to false
        mo_parsing.modifySs7Configuration(fpath + migrMos["restore_backup"],"CM2",True,True,False)
        
        mo_io.writeMos(fpath + migrMos["delete_ss7"],mo.delete_ss7configuration())
        mo_io.writeMos(fpath + migrMos["set_rnc_id"],mo.setRncId(clusterRncId))
        mo_io.writeMos(fpath + migrMos["licensing"],mo.licensing())
        mo_io.writeMos(fpath + migrMos["save_cv_and_restart"],mo.saveCvAndRestart())
        mo_io.writeMos(fpath + migrMos["activate_signaling"],mo.activateSignaling("ACTIVATED_SIGNALING",fpath))
        
    else: 
        print "wrong nccId"
    
    #mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["iuxup_ip"])    
    #defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(fpath + CMjson["iuxup_ip"])
   
    #mo_io.writeMos(fpath + migrMos["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,fpath,CMjson))
    mo_io.writeMos(fpath + migrMos["ipinterfaces"], mo.createIpInterfacesMo(rinpmCmInput, subrackNo, slotNo))

    #Parsing GPB for 3820
    if rncType == 'RNC_3820':
        subrackNoGpb, slotNoGpb, noOfGpbs = mo_parsing.parsingGPB(rncPrintout["cab"])
        numberOfboards = noOfGpbs
        #print subrackNoGpb, slotNoGpb, noOfGpbs 
        #sys.exit()
        mo_io.writeMos(fpath + migrMos["ipTermServ"], mo.createIpTermServ(noOfGpbs, subrackNoGpb, slotNoGpb, subrackNo, slotNo))
     
    #Create ip access host et. If there is only one address provided, script will assume that ip addresses change consecutively
    if (type(CMjson["rinpm_input"]["first_address"]) == list):    
        mo_io.writeMos(fpath + migrMos["ipaccesshostEt"], mo.createIpAccessHostEt(rinpmCmInput["first_address"], rinpmCmInput["defaultRouter"], subrackNo, slotNo))
    else:
        mo_io.writeMos(fpath + migrMos["ipaccesshostEt"], mo.createIpAccessHostEtFromSingleAddress(rinpmCmInput["first_address"], rinpmCmInput["defaultRouter"], subrackNo, slotNo))

    mo_io.writeMos(fpath + migrMos["ncc"], mo.createNccMo(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"], clusterRncId, rinpmCmInput["firstMainServerAddresses"], str(numberOfboards),rncType, subrackNo, slotNo))
    mo_io.writeMos(fpath + migrMos["feature_activation"], mo.featureActivationMos(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"]))
    mo_io.writeMos(fpath + migrMos["iux_up"], mo.createIuxUp(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"],rncPrintout["iux_up"]))
    mo_io.writeMos(fpath + migrMos["migrate"],mo.migrationMos(fpath, rncType, migrMos,nccId))
    
    if nccId == "1":
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-2.mos",mo.migrationMos(fpath, rncType, migrMos,"1.1"))
    if nccId == "2":
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-2.mos",mo.migrationMos(fpath, rncType, migrMos,"2.1"))
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-3.mos",mo.migrationMos(fpath, rncType, migrMos,"2.2"))
    print "migration mos for CM"+ str(nccId) +" are prepared"
 

def main():
    #=======================INPUT FROM FILE=========================================
    if len(sys.argv) != 2 or sys.argv[1][-5:] != ".json":
        help()
        sys.exit()
    jsonPath = sys.argv[1]
    rinpmjson = mo_io.readJson(jsonPath)
    #Getting path of json file to store scipts there
    working_path = os.path.abspath(os.path.join(jsonPath,os.pardir)) + "/"

    mo_io.setupMoshellPath(rinpmjson["moshell_path"])
    raw_input("Migration scripts files will be now generated. Press any key to continue.. \n ")
    
    #create directories if they do not exist
    if not os.path.exists(working_path+"CM1/"):
        os.makedirs(working_path+"CM1/")
    if not os.path.exists(working_path+"CM2/"):
        os.makedirs(working_path+"CM2/")  

    #if (type(rinpmjson["CM1"]["rinpm_input"]["first_address"]) == list)
    
    rncId = dict()
    rncId["CM1"] = mo_io.getRncId(working_path,"CM1",rinpmjson)
    rncId["CM2"] = mo_io.getRncId(working_path,"CM2",rinpmjson)
    
    iur.createIurDeletionScripts(working_path,rinpmjson,rncId);
    
   
    clean(working_path,rinpmjson)
    
    prepareMigrationMos(nccId="1", clusterMember="2", fpath = working_path + 'CM1/', json=rinpmjson,rncId = rncId["CM1"])
    prepareMigrationMos(nccId="2", clusterMember="1", fpath = working_path + 'CM2/', json=rinpmjson,rncId = rncId["CM2"])

    ss7configurationFile = working_path + "CM2/" + rinpmjson["CM2"]["migr_mos"]["ss7"]

    #copy backups from CM2 to be used in CM1
    shutil.copy2(working_path+ "CM2/" + rinpmjson["CM2"]["migr_mos"]["restore_backup"], working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["m3u_cm2"])
    #change their identity, set autoStartAssociation to false and set sctpId ref to null
    mo_parsing.modifySs7Configuration(working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["m3u_cm2"],"CM2",True,True,True)

    clean(working_path,rinpmjson)

    migration_choice = raw_input("\nDo you want start migrating RNC to RinP (y/n)?:")

    if migration_choice == 'y':
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["migrate"])
        
        if not mo_parsing.isPingOk(working_path +"CM1/" + rinpmjson["CM1"]["iuxet_ping"]):
            print "no answer from default Router on CM1"
            sys.exit()

        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["migrate"][:-4]+"-2.mos")
        
        defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(working_path+"CM1/" + rinpmjson["CM1"]["iuxup_ip"])
        
        mo_io.writeMos(working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,working_path+"CM1/",rinpmjson["CM1"]))
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["iuxup_ping"])
        
        if not mo_parsing.isPingOk(working_path +"CM1/" + rinpmjson["CM1"]["iuxup_ping"]):
            print "no answer from default Router user plane on CM1"
            sys.exit()
        
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"])
        
        raw_input("Press any key when required changes in Core Network are performed")
        
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"][:-4]+"-2.mos")
        
        if not mo_parsing.isPingOk(working_path +"CM2/" + rinpmjson["CM2"]["iuxet_ping"]):
           print "no answer from default Router on CM2"
           sys.exit()
            
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"][:-4]+"-3.mos")
        defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(working_path+"CM2/" + rinpmjson["CM2"]["iuxup_ip"])
        
        mo_io.writeMos(working_path + "CM2/" + rinpmjson["CM2"]["migr_mos"]["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,working_path+"CM2/",rinpmjson["CM2"]))
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["iuxup_ping"])
        if not mo_parsing.isPingOk(working_path +"CM2/" + rinpmjson["CM2"]["iuxup_ping"]):
           print "no answer from default Router user plane on CM2"
           sys.exit()    
            
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/restoreM3uCM1.mos")
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["activate_signaling"])
        
        iur.deleteIurLink(working_path,rinpmjson)
        print 'RNC has migrated'
def help():
    print """***************************************************************************************
python rinpm.py <configuration.json>
***************************************************************************************
Script for improved Live Node Migration. Generates and launches scripts for CM1 and CM2 
"""
if __name__ == "__main__":
    main()