#!/usr/bin/perl
# econkel - O2 project - Telstra May 2015

# version 1.0 - RI only
# version 2.0 - added CQI
# version 2.1 - added CQI8 breakdown
# version 2.2 - bug fix, for 0 traffic, it happens in the Australian Outback sometimes

use strict;
use Data::Dumper;


my $version = "v2.1";

my @row;
my %hash;

format STOUT = 
@<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<@<<<<<<<<<<<<<<@<<<<<<<<<@<<<<<<<<<<<<<@<<<<<<<<<<<<<@<<<<<<<<<<<<<<<
@row
.
format STOUT2 = 
@<<<<<<<<<<<<<<<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<@<<<<<
@row
.
@row = ("Cell","RI1","RI2","WAVERAGE","R2\%Usage","RI1\%LTCQI8","RI2\%LTCQI8");
$~ = "STOUT";
write;

open FH, "<$ARGV[0]" or die "something did not go well\n\n";
while (<FH>) {
     #                      EUtranCellFDD=ESSDEM1                                   pmRadioUeRepRankDistr i[4] = 9599 38381 0 0 

     if (/EUtranCellFDD\=(\S+)\s+pmRadioUeRepRankDistr.*\]\s+\=\s+(\d+)\s+(\d+)/) {
             $hash{$1}{RI1} = $2;
             $hash{$1}{RI2} = $3;
             if ( ( $2 + $3 ) eq 0 ) {
             } else {
                 $hash{$1}{RIwavg} =  sprintf("%0.2f",($2 + 2*$3)/($2 + $3));
                 $hash{$1}{r2usage} =  sprintf("%0.2f",100*$3/($2 + $3)); 
             }
             #@row = ($1,$2,$3,$average,$r2usage);
             #write;
     }
     if (/EUtranCellFDD\=(\S+)\s+pmRadioUeRepCqiDistr\s+.*16\]\s+\=\s+(.*)/) {
         @{$hash{$1}{CQIRI1}} = split(/\s+/,$2);
     }
     if (/EUtranCellFDD\=(\S+)\s+pmRadioUeRepCqiDistr2\s+.*16\]\s+\=\s+(.*)/) {
         @{$hash{$1}{CQIRI2}} = split(/\s+/,$2);
     }

}

foreach my $key (keys %hash) {
   my $totri1 = 0;
   my $totri2 = 0;
   my $totri1LTCQI8 = 0;
   my $totri2LTCQI8 = 0;
   my $ri1LTCQI8;
   my $ri2LTCQI8;
   foreach (my $i = 0 ; $i < @{$hash{$key}{CQIRI1}} ; $i++) {
      $totri1 += $hash{$key}{CQIRI1}[$i];
      $totri2 += $hash{$key}{CQIRI2}[$i];
      $totri1LTCQI8 += $hash{$key}{CQIRI1}[$i] if ($i < 8) ;
      $totri2LTCQI8 += $hash{$key}{CQIRI2}[$i] if ($i < 8) ;
   }
   foreach (my $i = 0 ; $i < @{$hash{$key}{CQIRI1}} ; $i++) {
      if ($totri1 ne 0 ) {
          $hash{$key}{CQIRI1perc}[$i] = (sprintf("%0.2f",$hash{$key}{CQIRI1}[$i]/$totri1))*100;
          $ri1LTCQI8 = (sprintf("%0.2f",$totri1LTCQI8/$totri1))*100;
      }
      #$hash{$key}{CQIRI1perc}[$i] = sprintf("%.2f",($hash{$key}{CQIRI1}[$i]/$totri1)*100);
      if ($totri2 ne 0 ) {
          $hash{$key}{CQIRI2perc}[$i] = (sprintf("%0.2f",$hash{$key}{CQIRI2}[$i]/$totri2))*100;
          $ri2LTCQI8 = (sprintf("%0.2f",$totri2LTCQI8/$totri2))*100;
      }
   }
   @row = ($key,$hash{$key}{RI1},$hash{$key}{RI2},$hash{$key}{RIwavg},$hash{$key}{r2usage},$ri1LTCQI8,$ri2LTCQI8);
   write;
}
print "\n";
$~ = "STOUT2";
@row = ("cell","RI","CQI0","CQI1","CQI2","CQI3","CQI4","CQI5","CQI6","CQI7","CQI8","CQI9","CQI10","CQI11","CQI12","CQI13","CQI14","CQI15");
write;
foreach my $key (keys %hash) {
      @row = ($key,"RI1");
      my @row2 = ($key,"RI2");
   foreach (my $i = 0 ; $i < @{$hash{$key}{CQIRI1}} ; $i++) {
      push (@row, $hash{$key}{CQIRI1perc}[$i]); 
      push (@row2, $hash{$key}{CQIRI2perc}[$i]); 
   }
   write;
   @row = @row2;
   write;
}

#print Dumper \%hash;
__END__
                     EUtranCellFDD=ENPKEM3                                   pmRadioUeRepCqiDistr i[16] = 1 0 0 1 25 100 156 207 308 429 404 592 559 421 316 315 
                     EUtranCellFDD=ENPKEM3                                   pmRadioUeRepCqiDistr2 i[16] = 1 0 0 0 21 93 137 167 211 362 233 343 454 368 304 300 
                     EUtranCellFDD=ENPKFM3                                   pmRadioUeRepCqiDistr i[16] = 0 0 0 0 1 5 29 33 166 157 110 298 153 147 169 21 
                     EUtranCellFDD=ENPKFM3                                   pmRadioUeRepCqiDistr2 i[16] = 0 0 0 0 1 2 26 20 55 119 38 111 63 1 0 0 

