#!/bin/bash

# Author: Rose Condori (ebbrmc)
# Date: June 15, 2017
# Version: 1.1

# ----------------------------------------------------------------
# COPYRIGHT (c)Telefonaktiebolaget L M Ericsson
#
# The copyright to the computer program(s) herein is the
# property of Telefonaktiebolaget L M Ericsson. The programs
# may be used and/or copied only with the written permission
# from Telefonaktiebolaget L M Ericsson or in accordance with the
# terms and conditions stipulated in the agreement/contract under
# which the program(s) have been supplied.
#
# Disclaimer of Warranty.
#
# THIS PROGRAM IS PROVIDED "AS IS" WITHOUT ANY WARRANTY.
# ERICSSON MAKES NO REPRESENTATIONS OR WARRANTIES WHATSOEVER
# THAT THE PROGRAM IS ERROR-FREE OR THAT THE USE OF THIS PROGRAM
# WILL BE SECURE OR UNINTERRUPTED. FURTHER, ERICSSON MAKES NO
# REPRESENTATIONS OR WARRANTIES WHATSOEVER FOR THE PROGRAM WHETHER
# EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, IMPLIED
# WARRANTIES OF MERCHANTABILITY,NON-INFRINGEMENT AND FITNESS FOR
# A PARTICULAR PURPOSE AND IN NO EVENT SHALL ERICSSON BE LIABLE
# TO LICENSEE FOR ANY LOSS OR DAMAGES ARISING FROM THE USE OF
# THIS PROGRAM.
# ----------------------------------------------------------------

# Overview:
#   This script parses xml counter files from different platforms
#   like TSP nodes, SBG, EPDG, EME
#   The script uses available scripts from moshell tool
#   

#Variables
KPI_dir="/home/ebbrmc/count_tool/"
moshell_dir="/home/EBBRMC/moshell/"
node=""
counter_name=""
counter_type=""
output_fname=""
date_cust=""
hour_cust=""
mo_name=""
type_name=""

### SUB FUNCTIONS ###

#To parse SBG, WCG, EPDG and EME counters, 
check_sbg_counter(){
hour=$hour_cust
curr_date=$date_cust

cat $KPI_dir/*$curr_date.$hour* |  $moshell_dir/./gawk -f $moshell_dir/commonjars/pmExtract.awk  -u "$mo_name" "$counter_name" | $moshell_dir/pmXtab -cols time
}

#To parse TSP counters and EME counters, 
check_tsp_counter(){
hour=$hour_cust
curr_date=$date_cust

cat $KPI_dir/A$curr_date.$hour* |  $moshell_dir/pmExtract  -u "$mo_name" "$counter_name" | $moshell_dir/pmXtab -cols time

}
### MAIN ###

  echo "start"
  if [ "$1" == "" ]; then
         echo "USAGE:"
         echo "    ./counter_check [-n node_name] [-o mo] [-d yyyymmdd] [-h hhmm] [-c counter name] [-t type]"
         echo ""
         echo "OPTIONS:"
         echo " -n"
         echo "     Specify the node name sbg, wcg, eme, epdg, cscf, mtas, hss,  <MyNode>"
         echo " -o"
         echo "     Specify MO, example below:"
         echo "     	SBG use: bsNo=11 for a particular SGC, or netId=1 for a specific interface"
         echo "     	WCG use: traffic_instance9"
		 echo "     	MTAS use: Mo=SIP,503"
         echo "     	or if you are not sure use wildcard . to print all "
         echo " -d"
         echo "     Specify date i.e 20170610"
         echo " -h"
         echo "     Specify hour i.e 0800 for 15 min, 08 for an hour, \"*\" for whole day"
         echo " -c"
         echo "     Specify counter name, example below:"
		 echo " 	SBG: sbgSgcCritResCpLoad, MtasSipOrigUnregRequestIn or partial name such as load, or wildcard . "
		 echo " 	MTAS: MtasSipOrigUnregRequestIn "
		 echo " 	or partial name such as \"load\" "
		 echo " 	or if you are not sure or want to see all available counters use wildcard . "
         echo " -t"
         echo "     Specify the node i.e sbg, wcg, epdg, tsp, emeA, emeB"
		 echo "     Note: emeA use this one if the xml files start with A or emeB if they start with B"
         echo ""
         echo "  	Example: ./counter_check -n sbg -o netId=1 -d 20160219 -h 00 -c sbgSipRegStatRegUserGauge -t sbg"
         echo "  	Example: ./counter_check -n wcg -o instance4_PL-7 -d 20161202 -h 00 -c reg -t wcg "
		 echo "  	Example: ./counter_check -n eme -o . -d 20141210 -h 00 -c sms.numsms_smsx_session_failed -t emeA"
		 echo "  	Example: ./counter_check -n epdg -o . -d 20150306 -h 16 -c cpu -t epdg"
		 echo "  	Example: ./counter_check -n eme -o . -d 20141210 -h 00 -c TotalSipDialogLifetime.actual -t emeB"
         echo "  	Example: ./counter_check -n mtas -o Mo=500 -d 20151223 -h 00 -c reg -t tsp"
		 echo "  	Example: ./counter_check -n hss -o . -d 20130915 -h 00 -c DhRequests -t tsp" 
         echo ""
         exit

  fi
  
  while getopts "n:o:d:h:c:t:" opt
  do
  sc=0
    case $opt in
		
            n)
                    KPI_dir=$KPI_dir/$OPTARG
                    if [ -n "$KPI_dir" ]; then
                       echo " =========== " 
                       echo "   $OPTARG   "
                       echo " =========== "
                    else
                       echo "Wrong KPI dir name!"
                       exit
                    fi
                    ;;
            o)
                    mo_name=$OPTARG
                    ;;

            d)      date_cust=$OPTARG
                    ;;

            h)
                    hour_cust=$OPTARG
                    ;;

            c)
                    counter_name=$OPTARG
                    ;;

			t)		type_name=$OPTARG
					if [  "$type_name" == 'tsp' ] || [ "$type_name" == 'emeA' ]; then
						echo "Parsing " $type_name " counter"
						check_tsp_counter
						exit 1
						
					elif [ "$type_name" == 'sbg' ] || [ "$type_name" == 'wcg' ] || [ "$type_name" == 'epdg' ] || [ "$type_name" == 'emeB' ]; then 
						echo "Parsing " $type_name " counter"
						check_sbg_counter
						exit 2
					else
						echo "Wrong type name!"
						exit 3
					fi	
					;;	
		

    esac
    shift $((OPTIND - 1 + sc))
    OPTIND=1
  done

