/* Copyright (C) 2007 Ericsson AB 
 */

#ifndef WRAPPER_H
#define WRAPPER_H

//#define _GNU_SOURCE
//#define RTLD_NEXT	((void *) -1l)

#include <xlocale.h>
#include <time.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <tcl.h>
#include <assert.h>
#include <pthread.h>

#include "timeclient.h"

#define TRY_CONNECT()                                   \
do {                                                    \
  if (!wrapper_ctx.simics_ctx) {                        \
    simics_connect(wrapper_ctx.host, wrapper_ctx.port); \
  }                                                     \
} while (0)

#define wrapper_log(...)                                                     \
  wrapper_log_(__FILE__, __LINE__, __FUNCTION__ , __VA_ARGS__)

#define GET_REAL_FUNC(name_) \
do {                         \
  *(void**)(&wrapper_ctx.real_funcs.name_) = dlsym(RTLD_NEXT, #name_); \
  if (!wrapper_ctx.real_funcs.name_) {     \
    wrapper_log(1, "Couldn't find real function '%s'", #name_); \
    assert(wrapper_ctx.real_funcs.name_);  \
  }                                        \
} while (0)


#define MSEC_PER_SEC		1000L
#define USEC_PER_SEC		1000000L
#define NSEC_PER_SEC		1000000000L

typedef int (*select_func)(int n, fd_set* readfds, fd_set* writefds, fd_set* exceptfds, struct timeval* timeout);
typedef time_t (*time_func)(time_t *t);
typedef int (*nanosleep_func)(const struct timespec *req, struct timespec *rem);
typedef int (*gettimeofday_func)(struct timeval *tv, struct timezone *tz);
typedef int (*clock_gettime_func)(clockid_t clk_id, struct timespec *tp);
typedef int (*clock_settime_func)(clockid_t clk_id, const struct timespec * tp);
typedef int (*clock_getres_func)(clockid_t clk_id, struct timespec * res);


typedef Tcl_Command (*Tcl_CreateObjCommand_func)(
				Tcl_Interp * interp, const char * cmdName, 
				Tcl_ObjCmdProc * proc, ClientData clientData, 
				Tcl_CmdDeleteProc * deleteProc);
typedef const char * (*Tcl_GetVar_func)(Tcl_Interp * interp, const char * varName, int flags);
typedef const char * (*Tcl_SetVar_func)(Tcl_Interp * interp, const char * varName, const char * newValue, int flags);
typedef int (*Tcl_TraceVar_func)(Tcl_Interp * interp, const char * varName, int flags, Tcl_VarTraceProc * proc, ClientData clientData);

void lib_init(void);

double simics_get_time(void);
void simics_delay(double delay);
void simics_handle_error(simtime_error_t ret);
void simics_connect(const char* host, int port);

void
__attribute__((format(printf,5,6)))
wrapper_log_(
  const char*   file,   /* file where call is made    */
  int           line,   /* line of call               */
  const char*   func,   /* function where called from */
  int           level,  /* log level for printout     */
  const char*   format, /* message to log             */
  ...);

typedef struct real_funcs_t    real_funcs_t;
typedef struct wrapper_ctx_t   wrapper_ctx_t;

struct real_funcs_t {
  select_func         select;
  time_func           time;
  nanosleep_func      nanosleep;
  gettimeofday_func   gettimeofday;
  clock_gettime_func  clock_gettime;
  clock_settime_func  clock_settime;
  clock_getres_func   clock_getres;

  Tcl_CreateObjCommand_func  Tcl_CreateObjCommand;
  Tcl_GetVar_func            Tcl_GetVar;
  Tcl_SetVar_func            Tcl_SetVar;
  Tcl_TraceVar_func          Tcl_TraceVar;
};

struct wrapper_ctx_t {
  simtime_context_t*  simics_ctx;
  real_funcs_t        real_funcs;  
  int                 log_level;
  int                 active;
  pthread_t           thread;

  int                 port;
  const char *        host;
};

extern  wrapper_ctx_t  wrapper_ctx;

int Wrapper_Init(Tcl_Interp *interp);
int tcl_wrapper_cmd(ClientData clientData, Tcl_Interp *interp, int objc, char * CONST objv[]);
char *tcl_trace_active(ClientData clientData, Tcl_Interp *interp, char *part1, char *part2, int flags);

#endif
