#inputs lhcom, command
#$ te status -restart
#$ te status
#     pid name                         enabled groups
#00010069 eth_duplex_sim_irq           check error info interface object
#       - CLS_ATMPDR_IF_1              check error info interface object
#$ lhsh 000100 te status -restart
#$ lhsh 000100 te status
#     pid name                         enabled groups
#0001001e Sys_Osa_clkDistr_proc        check error info interface object
#       - CLS_ATMPDR_IF_1              check error info interface object
#$ lhsh 001100 te s -restart
#=============================================================================================
#$ lhsh 001100 te s
#0011:      pid name                         enabled groups
#0011: 00010069 eth_duplex_sim_irq           check error info interface object
#
BEGIN{ printf("\n%s%-40s  %-9s  %s\n",(lhcom=="lh"?sprintf("%-10s  %-9s  ","Position","Board"):""),"Process","Status","AddedTraceConditions") }
NF==1 && $1=="$" {next}
/Java Trace status:|All Java trace items have default configuration/{next}
/All providers have default configuration/{next}
/Enabled LTTng events:/{inlttng=1;next}
/TRI status:|pid .*name|enabled groups/{inlttng=0;next}
/commonjars\/connect[^ ]*: connection timed out|Timeout, server .* not responding|nc6[^ ]*: remote idle timed out/{errors=errors"\n"$0 ; next}
$1 ~ /^[^:]+:$/ && lhcom=="lh" {
	inbbeqm=0
	prefix=gensub(/:$/,"",1,$1)
	if (prefix ~ /^[0-9][0-9][0-9][0-9]$/) productname=BoardType[prefix"00"]
	else productname=BoardType[prefix]
	sub(/^[^:]+: /,"")
	if (prefix ~ /^[0-9]+bb[0-9]+$/)
	{
		#0001bb3: BbiMcsTraceFilter                     check error info interface
		$0="- "$0
		inbbeqm=1
	}
	#print productname,$0
}
inbbeqm==1 && $2=="check"{next}
/=============================================================================/{next}
tolower($1)=="debug:" || $1=="END_OF_COMMAND" || /TRI status: *$/{next}
/(lhsh|rcmd): failed to connect|unable to hunt / { output=sprintf("%sNOCONTACT",(lhcom=="lh"?sprintf("%-10s  ",prefix):""));next }
$1=="pid" && $2=="name"&&$3=="enabled"{next}
#/coli>/{ print $0}
/\$ lhsh [^ ]+ te status -restart|^coli>\/fruacc\/lhsh [^ ]+ .*te .*status.* -restart/{ print_output()}
#tolower($1) ~ /(^|[^_])product_*name|_board_type/ { productname=gensub(/^.*=/,"","g",$0) ; next }
/te status -restart/ {enabled=0;saved=1;next}
/te status|bbte log status/ { enabled=1;saved=0;next}
saved==1 { savedGroups[$2]=process($0) ; savedList[$2]=$2;next }
#{print prefix,"enabled="enabled,"saved="saved,$0}
(NF > 7 && $3=="check" && /check .*error .*info .*interface .*object/ && (!($2 in printed)))||\
(inbbeqm==1 && NF > 6 && $3=="check" && /check .*error .*info .*interface/ && (!($2 in printed)))||\
(NF > 5 && ($3=="error" || $3=="check") && /error .*info .*trace9/ && (!($2 in printed)) && productname~/^MSB/)||\
(NF > 4 && $3=="error" && /error .*info / && (!($2 in printed)) && productname!~/^MSB/) {
	#       - UehRabHandlingC[177]            check error info interface object
	#00010055 Sys_Spas_link_proc                            check error info interface object
	#        - DSP1/6   error info trace9
	#        - DEC0_Scheduler error info
	#        - WBBL1_DCH_DATA                        check error info interface
	#        - LPP_TRACE_BIN                         check error enter return info trace1 trace2 trace3 trace4 trace5 trace6 trace7 trace8 trace9 state_change bus_send bus_receive send_sig param interface
	if ($2 in savedGroups) 
	{
		status="ena&saved"
		delete savedGroups[$2]
		delete savedList[$2]
	}
	else status="enabled"
	printf("%s%-40s  %-9s  %s\n",(lhcom=="lh"?sprintf("%-10s  %-9s  ",prefix,productname):""),$2,status,process($0))
	printed[$2]=1
	next
}
command=="status all" && $1!~/^(\$|put)$/ && NF>3 && / error / { sub(/\[[0-9]+\]/,"[..]",$2);defGroups[$2]=$2 }
inlttng==1 && $0!~/ com_ericsson_plf_trace_util:\*|\* \(loglevel: TRACE_INFO\)/{
	printf("%s%s\n",(lhcom=="lh"?sprintf("%-10s  %-9s  ",prefix,productname):""),gensub(/^ */,"",1,$0))
}
END{ print_output() ; print gensub(/^\n/,"",1,errors)}
function process(line)
{
	gsub(/^ *[^ ]+ +[^ ]+ +|(check|error|info|interface|object)/,"",line)
	gsub(/^ +| +$/,"",line)
	gsub(/ +/," ",line)
	if (line=="enter return trace1 trace2 trace3 trace4 trace5 trace6 trace7 trace8 trace9 state_change bus_send bus_receive rec_sig send_sig param user1 user2 user3 user4") line="all"
	if (productname~/^MSB/) sub(/trace9/,"",line)
	gsub(/^ +| +$/,"",line)
	gsub(/ +/," ",line)
	return line
}
function print_output()
{
	if (output != "") { print output ; output="" ; return }
	n=asort(savedList)
	for (i=1;i<=n;i++) printf("%s%-40s  %-9s  %s\n",(lhcom=="lh"?sprintf("%-10s  %-9s  ",prefix,productname):""),savedList[i],"saved",savedGroups[savedList[i]])
	n=asort(defGroups)
	for (i=1;i<=n;i++) printf("%s%-40s  %-9s  %s\n",(lhcom=="lh"?sprintf("%-10s  %-9s  ",prefix,productname):""),defGroups[i],"-","default")
	productname=""
	delete printed
	delete savedGroups
	delete savedList
	delete defGroups
}
