######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################
function moshell_start(    i,last,array,tmplocalfile,thenode,a,portlist,k,j,tmpres,arr)
{
	moshellStartTime=systime()
	loadFilefuncs()
	if (fileOps("test -s "iorfile)==0)
	{
		#In case we do bg in offline mode
		if (iorfile ~ /^\//) theMoDump=iorfile
		else theMoDump=sprintf("%s/%s",fileOps("pwd"),iorfile)
		#print "theMoDump="theMoDump
	}
	parse_user_variables(moshell)
	if (noglobrc!=1) parse_user_variables(globmoshellrc)
	if (additionalRcFile!="")
	{
		last=split(additionalRcFile,array,",")
		for (i=1;i<=last;i++) if (fileOps("test -s "array[i])==0) parse_user_variables(array[i])
	}
	if (nouserrc!=1) parse_user_variables(moshellrc)
	parse_securityOptions(securityOptions)
	parse_commandlineOptions(userVariables)
	parse_common_variables()
	moshellUSER=setUSER()
	userglobmoshellrc=globmoshellrc"."moshellUSER
	if (fileOps("test -s "userglobmoshellrc)==0) parse_user_variables(userglobmoshellrc)
	moshell_welcome()
	check_disk()
	check_ram()
	check_sessions()
	check_sessions_all()
	moshell_version_check()
	if (mosdebug==1) print "Start time: "strftime("%Y-%m-%d %H:%M:%S",moshellStartTime)
	if (multi)
	{
		nrOfNodes=0
		old_ip_connection_timeout=ip_connection_timeout
		if (ip_connection_timeout > 3) ip_connection_timeout=3
		node_address_list=node_ipaddress_list=""
		if (fileOps("test -s "node_address)!=0) last=split(node_address,array,",")
		else
		{
			#we have a sitefile
			while (getline < node_address) { gsub("\r","") ; gsub("\x000","") ; if ($1 !~ /^($|#)/) array[++last]=$1 }
			close(node_address)
		}
		if (in_amos_mode()) start_amos()
		for (i=1;i<=last;i++)
		{
			if (array[i]=="") continue
			if (in_amos_mode())
			{
				node_address=array[i]
				if (is_ip_addr(node_address)>0 || node_address ~ /^OFFLINE/) node_address=find_node_address(node_address,resultTable)
				else if (node_in_ipdatabase(node_address)==0) node_address=find_node_address(node_address,resultTable)
				else node_address=amos_translate(node_address,resultTable)
			}
			else
			{
				node_address=find_node_address(array[i],resultTable)
			}
			nodeName[node_address]=resultTable["node_name"]
			if (is_ip_addr(node_address)==2 && ipv6==0 && smart_ipv6==1) declare_user_variable("ipv6=1",2)
			tmplocalfile=tempdir"/"gensub(/:/,".","g",node_address)".ior"
			if (httpget(node_address,"/cello/ior_files/nameroot.ior",tmplocalfile,"ior","","node "i"/"last" ",fast_timeout,"","",0)==0)
			{
				#the file iorfile must be there, though it's not used
				if (iorfileisthere!=1) { fileOps("cp "tmplocalfile" "iorfile) ; iorfileisthere=1 }
				nodeList[++nrOfNodes]=node_address
				nodeAddress[nodeName[node_address]]=node_address
			}
		}
		if (nrOfNodes==0) exit_with_error()
		for (i=1;i<=nrOfNodes;i++)
		{
			if (os != "cygwin") node_address_list=node_address_list" "gensub(/:/,".","g",nodeList[i])".ior:"nodeList[i] # we connect with iorfiles
			else node_address_list=node_address_list" "nodeList[i]   # we connect with ipaddress
			node_ipaddress_list=node_ipaddress_list";"nodeList[i]
		}
		ip_connection_timeout=old_ip_connection_timeout
		sub(/^;/,"",node_ipaddress_list)
		if (in_amos_mode()) stop_amos()
                #if (in_amos_mode()) { start_amos() ; stop_amos() }
	}
	else
	{
		if (in_amos_mode())
		{
			amosopt+=0
			if (amosopt==0)
			{
				start_amos()
				tbac_node_name=node_address
				if (is_ip_addr(node_address)>0 || node_address ~ /^OFFLINE/) node_address=find_node_address(node_address,resultTable)
				else if (node_in_ipdatabase(node_address)==0) node_address=find_node_address(node_address,resultTable)
				else node_address=amos_translate(node_address,resultTable)
				amos_tbac_result=amos_tbac(tbac_node_name,node_address)
				if (amos_tbac_result != 0) exit_amos_error(amos_tbac_result"\n")
				stop_amos()
			}
			else if (amosopt==2)
			{
				amos_rb(amosfile)
				if (is_ip_addr(node_address)>0 || node_address ~ /^OFFLINE/) node_address=find_node_address(node_address,resultTable)
				else if (node_in_ipdatabase(node_address)==0) node_address=find_node_address(node_address,resultTable)
				else node_address=amos_translate(node_address,resultTable,"rb")
			}
			else if (amosopt==1)
			{
				delete amos_ip
				if (fileOps("test -s "amosfile)!=0)
				{
					customPrint("ERROR: cannot read file "amosfile)
					exit_with_error()
				}
				find_listme()
				if (listme=="")
				{
					customPrint("ERROR: cannot find listme utility")
					exit_with_error()
				}
				while (listme |& getline)
				{
					#SubNetwork=ONRM_RootMo_R,SubNetwork=LTE27,MeContext=LTE27ERBS00115@10.18.155.115@@4@ON@1@4@ERBS_NODE_MODEL@-1@-1
					split($0,a,/@/)
					amos_ip[tolower(gensub(/^.*=/,"",1,a[1]))]=a[2]
				}
				close(listme)
				amos_debug=2
				start_amos()
				stop_amos()
				print "---- Node translations ----"
				while (getline < amosfile)
				{
					if (NF==0) continue
					thenode=tolower($1)
					if (thenode~/^#/) continue
					#too slow:
					#if (!(is_ip_addr(thenode)>0 || node_in_ipdatabase(thenode)==0)) amos_translate(thenode,resultTable)
					#amos_tbac_result=amos_tbac(thenode)
					if ((!(is_ip_addr(thenode)>0 || node_in_ipdatabase(thenode)==0))&&(amos_ip[thenode]!=""))
					{
						customPrint("translate "thenode" -> "amos_ip[thenode])
					}
				}
				close(amosfile)
				exit
			}
			if (dbdat)
			{
				if (amos_status["dbc"]!=1)
				{
					customPrint("SQL mode cannot be run on AMOS due to missing license.")
					if (in_amos_sim()!=1) exit_with_error()
				}
			}
		}
		else
		{
			node_address=find_node_address(node_address,resultTable,"listme")
		}
		#if node_address is a dns name we convert it to ip address , otherwise we cannot predict the name of the moscomlog
		#we also need to do this check if ipv6=0 and smart_ipv6 is turned on so we make sure to connect to ipv6 address with ipv6=1
		#we will not do the part below if the node address looks like a ipv4 address
		if (node_address !~ /^OFFLINE/ && is_ip_addr(node_address)!=1)
		{
			if (mosdebug==1) print "Debug: node_address="node_address", isip="is_ip_addr(node_address)", ipv6="ipv6", smart_ipv6="smart_ipv6
			if (is_ip_addr(node_address)==0 || (ipv6==0 && smart_ipv6==1))
			{
				k=0
				portlist[++k]=http_port
				portlist[++k]=443  #when connecting with moshell <dnsname> and the node is a RCS node, then find_ws_ip fails
				for (j=1;j<=k;j++)
				{
					tmp_converted_node_address=find_ws_ip(node_address,portlist[j],"node")
					#TR HV48188/HV53716 : we only replace the original node_address if it was a string, not if it is a ipv6 address
					#Otherwise lookupAccountDetails does not work if it is not the original ipv6 address
					if (is_ip_addr(tmp_converted_node_address) > 0 && is_ip_addr(node_address)==0)
					{
						dns_node_address=node_address
						node_address=tmp_converted_node_address
						break
					}
				}
			}
		}
	}
	parse_commandlineOptions(resultTable["node_options"])
	#reparse the command line options since they ought to override the options of the ipdatabase
	parse_securityOptions(securityOptions)
	parse_commandlineOptions(userVariables)
	parse_common_variables()

	#startnode will be kept the same throughout the whole moshell session
	#whereas node will be set to the value of ManagedElement:userLabel
	if (multi) node=startnode="MULTI_"nrOfNodes
	else node=startnode=resultTable["node_name"]  #old code: node=startnode=toupper(resultTable["node_name"])
	dotnode_address=gensub(":",".","g",node_address)
	fileOps("rm "tempother)
	InitialiseGlobalVariables()
	#If Linux 64bit, check that the 32bit libc is present otherwise nc6 will fail
	if (node_address!~/^OFFLINE/)
	{
		tmpres=validate_nc()
		if (tmpres!=0)
		{
			split(tmpres,arr,SUBSEP)
			if (arr[1]==1 && os=="linux" && linarch=="64") print "ERROR: missing 32-bit libc. Please install 32-bit libc on this workstation."
			else print "ERROR: unable to execute "netcat
			if (mosdebug==1) print arr[2]
			exit_with_error()
		}
	}
	if (multi==1 && smart_corba==1)
	{
	 	if (thereIsASecureNode!=1 && corba_class > 2)
	 	{
	 		customPrint("INFO: None of the nodes are using corba security, switching to corba_class=2")
	 		declare_user_variable("corba_class=2",2)
	 	}
	 	else if (thereIsASecureNode==1 && corba_class == 2)
	 	{
	 		customPrint("INFO: One or more nodes are using corba security, switching to corba_class=4")
	 		declare_user_variable("corba_class=4",2)
	 	}
	}
	if (checkIpContact==1 && multi!=1)
	{
		old_ip_connection_timeout=ip_connection_timeout
		ip_connection_timeout=fast_timeout
	 	printf("Checking ip contact...")
	 	ipContactT=check_ip_contact(node_address,telnet_port,"force","","startup")
	 	if (ipContactT!=0 && smart_secure==1 && telnet_port!=secure_port && secure_shell==0)
	 	{
	 		ipContactT=check_ip_contact(node_address,secure_port,"force","","startup")
	 		if (ipContactT==0)
	 		{
	 			if (mosdebug==1) print "DEBUG: changing to secure_shell=1"
	 			declare_user_variable("secure_shell=1",2)
	 		}
	 	}
	 	if ((comcli>0 || lincli>=2)&&(!(comcli>0 && emcli!~/^(|0)$/ && http_port==80)))
	 	{
	 		#COM/SIU/TCU/AXE
	 		#But: dont go here if it is emcli where http_port is wrongly set to port 80, then we have to set the ports correctly as per below
	 		if (ipContactT==1 && comcli>0 && tls_menu>0 && use_tls==-1)
 			{
 				#we came here if comcli=28 and ssh is locked
 				ipContactT=check_ip_contact(node_address,s_secure_port,"force","","startup")
 			}
	 		if (ipContactT==1)
	 		{
		 		print "Not OK"
		 		print "Unable to connect to "node_address":"telnet_port
		 		exit_with_error()
		 	}
	 		ipContactH=0
			#when connecting to a RCS node and specifying the comcli parameter (eg comcli=27) it does not set the variable checkIpContactPort22Refused so we set it now
			if (is_rcs()==1 && checkIpContactPort22Refused=="unknown")
			{
				check_ip_contact(node_address,22,"force","","port22")
			}
	 	}
	 	else
	 	{
	 		ipContactH=check_ip_contact(node_address,http_port,"force","","startup")
	 		#Check if CPP linux or OSE, currently only done on SSH port
	 		if (secure_port != telnet_port) check_ip_contact(node_address,secure_port,"force","","startup")
	 		#If CPP node with HTTP port unreachable, check if HTTPS ok
	 		if (smart_http==1 && ipContactH==1 && ssh_server_type ~ /dropbear|for OSE|Erlang/)
	 		{
	 			if (check_ip_contact(node_address,s_http_port,"force","","startup")==0)
	 			{
	 				declare_user_variable("secure_http=1",2)
	 				ipContactH=0
	 			}
	 		}
	 		#TR HV48153: If there is contact to http port but no contact to port 22 then double-check if this is really a CPP node by trying to find the IOR file
	 		if (smart_comcli==1 && ipContactH==0 && ssh_server_type!~/dropbear|for OSE|Erlang/ && secure_port==22 && (ipContactT==0 || checkIpContactPort22Refused==1))
	 		{
	 			if (httpget(node_address,"/cello/ior_files/nameroot.ior",iorfile,"ior","silent","",fast_timeout,"","",0)!=0) ipContactH=1
	 		}
	 		#If there is no contact to the http port it could be that this is a COM node
		 	if (smart_comcli==1 && ipContactH!=0 && ssh_server_type!~/dropbear|for OSE/ && secure_port==22 && (ipContactT==0 || checkIpContactPort22Refused==1))
		 	{
		 		#try to determine the type of node since it is not CPP but there is contact on port 22
		 		if (ssh_server_type ~ /Erlang/) comcli=12 #netsim
		 		else if (ssh_server_type ~ /Tectia/) ipContactH=0  #AXE node
		 		#else if (ssh_server_type ~ /OpenSSH_5/) ipContactH=0 #SIU/TCU/ESC ,uses comcli=0 but has no http -> disabled this part as it also matches on regular linux workstations
		 		else if (check_ip_contact(node_address,3443,"force","","startup")==0)  #must be before PGM/BSP/PICO because also responds to port 830
		 		{
		 			#VNFM
		 			comcli=50
		 			if (check_ip_contact(node_address,2023,"force","","startup")!=0) comcli=58   #In case SSH is blocked and only TLS allowed
		 		}
		 		else if (check_ip_contact(node_address,443,"force","","startup")==0)  #must be before PGM/BSP/PICO because also responds to port 830
		 		{
		 			#RCS with HTTPS (> 14B)
		 			comcli=20
		 			if (check_ip_contact(node_address,2023,"force","","startup")!=0) comcli=28   #In case SSH is blocked and only TLS allowed
		 		}
		 		else if (check_ip_contact(node_address,9830,"force","","startup")==0) comcli=10 #PICO
		 		else if (check_ip_contact(node_address,830,"force","","startup")==0)  #Core network nodes
		 		{
			 		if (check_ip_contact(node_address,115,"force","","startup")==0) comcli=37  #MRSv
		 			else if (check_ip_contact(node_address,2024,"force","","startup")==0) comcli=31  #BSP   #NOTE: on commercial BSP the port 22 is not turned on at all, so the smart_comcli may not work
		 			else if (check_ip_contact(node_address,2028,"force","","startup")==0) comcli=39  #SBGv
		 			else comcli=38 #CBA Ref
		 		}
				else if (ssh_server_type ~ /OpenSSH_/) comcli=1 #default, all other COM nodes
		 		if (comcli>0)
		 		{
		 			change_comcli=1
		 			ipContactH=0
		 			ipContactT=0
		 		}
		 	}
	 	}
	 	if (ipContactH==0 && ipContactT==0) print "OK"
	 	else if (ipContactH==0 && ipContactT==1)
	 	{
	 		print "OK"
	 		print "Port "http_port" OK, port "telnet_port" not OK."
	 	}
	 	else if (ipContactH==1 && ipContactT==0)
	 	{
	 		print "OK"
	 		print "Port "telnet_port" OK, port "http_port" not OK."
	 	}
	 	else
	 	{
	 		print "Not OK"
	 		print "Unable to connect to "node_address":"telnet_port
	 		exit_with_error()
	 	}
	 	if (ipContactH==0) make_ws_ip()
		ip_connection_timeout=old_ip_connection_timeout
		#The change of comcli must be done at the end otherwise the ip_connection_timeout setting will be overwritten, crucial for pico
		if (change_comcli==1)
		{
			change_comcli=0
			if (mosdebug==1) print "DEBUG: detected COM node, changing to comcli="comcli
			declare_user_variable("comcli="comcli,2)
		}
	}
	#when connecting to ipv6 com node without specifying the comcli parameter the find_ws_ip function does not find the workstation , so we do it now.
	if (comcli>0 && ipv6==1 && ws_ip=="") make_ws_ip()
	#CPP Linux TR HU87030 - not needed anymore now that secure_shell is 1 by default
	#if (cpplinux==1 && smart_secure==1 && secure_shell==0) secure_shell=1
	#Set the username to $USER on CPP OSE node in AMOS and lab
	if (moshelldir ~ /^(\/vobs\/iov\/rnc\/bin|\/app\/moshell|\/opt\/ericsson\/amos)\// && comcli==0 && cpplinux==0 && username=="moshelluser" && username_modified_from_default!=1) username=ENVIRON["USER"]
	#parse_readme()
	parse_readme_small()   #only make the table SearchString in the beginning. The other help tables will be made the first time the "h" command is run
	make_restrictions()
	if (node_address ~ /^OFFLINE/) keepalive_interval=0   #keepalive_interval only applicable for corba connection
	if ((node_address ~ /^OFFLINE/ && fileOps("test -s "iorfile)==0)||(dbdat==1))
	{
		$0="" ; $2=iorfile ; Load_Proxys(); dbcheck("silent") ; ReadMimName()
	}
	Display_menu(0)
	if (prompt=="") Set_prompt("",evalnodecase(node))
	else Set_prompt("",prompt,"manual")
	#For RCS node, check if uses http or https --> http not used anymore in RCS
	#if (comcli>0 && node_address!~/^OFFLINE/ && secure_http==1 && (secure_port==4192 || comcli_portfile==1))
	#{
	#	if (check_ip_contact(node_address,s_http_port,"force")!=0) secure_http=0
	#}
	#temporary workaround where we change mom fetching from https to export since currently https not supported for ipv6 - NOT NEEDED ANYMORE after fixing openssl for ipv6
	#if (comcli>0 && ipv6==1 && secure_http==1 && comcli_mom==2) comcli_mom=3  #currently https not supported on ipv6
	#Sometimes these uservariables have not been set properly during moshell_install
	if (java=="") java="java"
	if (perl=="" || perl=="/perl") perl="perl"
	if (monode_command != 0)
	{
		monode_commandfile=tempmonodecmd
		fileOps("rm "monode_commandfile)
		last=split(monode_command,array,/(\\n)|;/)
		for (i=1;i<=last;i++)
		{
			if (array[i] !~ /^[ \t]*$/) print gensub(/^ *| *$/,"","g",array[i]) >> monode_commandfile
		}
		close(monode_commandfile)
	}
	if (monode_commandfile != 0)
	{
		if (monode_commandfile ~ tempdir) print "q!!" >> monode_commandfile   #needed. eg: if pmr has not been exited properly, the session will go on and on forever.
		close(monode_commandfile)
		noninteractive=1
		add_to_moscomlog("Start")
		Read_script(monode_commandfile)
		exit
	}
	clean_lmid()
	add_to_moscomlog("Start")
	while (1) Read_usercommand()
}

function moshell_end()
{
	empty_moscomlog_buffer()
	close_comcli()
	if ((mobrowserStarted == 1 && is_process_there(moshell_java_proc["mobrowser"]) == 0) ||\
	    (nealStarted == 1 && is_process_there(moshell_java_proc["nealbrowser"]) == 0))
	{
		print 9 |& TestClient
		while (TestClient |& getline)
		{
			if (corba_debug >= 1) customPrint($0)
		}
		close(TestClient)
	}
	if (pmtesterStarted == 1  && is_process_there(moshell_java_proc["pmtester"]) == 0)
	{
		print 10 |& PmClient
		while (PmClient |& getline)
		{
			if (corba_debug >= 1) customPrint($0)
		}
		close(PmClient)
	}
	log_amos()
	amos_account_delete(temporary_enm_username)
	stop_amos()
	#amos_process_log(moshell_pid) -> already done in trap cleanup in moshell file
	#if (mobrowserStarted==1 || pmtesterStarted==1 || (nocorba==1 && ipContact!=1)) print "Bye..."
	#if (nocorba==0 && mobrowserStarted != 1) print "Cannot connect to MO service, exiting..."
	Window_title("stop")
	stop_rtrdb()
	stop_sshd()
	if (mosdebug==1) { moshellEndTime=systime(); print "End time: "strftime("%Y-%m-%d %H:%M:%S",moshellEndTime)"\nDuration: "convertSeconds(moshellEndTime-moshellStartTime) }
	if (NoBye != 1) print "Bye..."
}
function f_http_port(what)
{
	#returning theCorbaPort does not work if using tunnels to loopback interface 127.0.0.1
	#if (what=="corba" && theCorbaPort ~ /^5683[46]$/) return theCorbaPort
	#if (what=="corba") what="check"
	if (what=="check") http_recheck()
	if (secure_http==1) return s_http_port
	return http_port
}
function make_ws_ip()
{
	#find the IP address of the workstation and store in variable $ws_ip
	ws_ip=find_ws_ip(node_address,f_http_port())
	assignCustomVar("$ws_ip",ws_ip,"","system")
	#now keep only the ipv6 address of ws_ip in case it has both a ipv6 and ipv4, eg: 2001:1b70:828a:158::220 (10.62.158.220)  -> 2001:1b70:828a:158::220
	#but $ws_ip will keep both ipv4 and ipv6 addresses
	sub(/ \(.*$/,"",ws_ip)
}
function stop_rtrdb()
{
	if (dbdat==1 && rtrdbStarted==1 && (is_process_there(rtrdb_pid)==0)) run_sql_command("shutdown;",sqlport,"silent")
	if (dbdat==1 && postgresStarted==1) system(pg_ctl" stop -D "psqldb" -m fast >/dev/null")
}
function moshell_welcome()
{
	if (in_amos_mode())
	{
		printf("\
                        __  __  ____   _____\n\
                  /\\   |  \\/  |/ __ \\ / ____|\n\
                 /  \\  | \\  / | |  | | (___  \n\
                / /\\ \\ | |\\/| | |  | |\\___ \\ \n\
               / ____ \\| |  | | |__| |____) |\n\
              /_/    \\_\\_|  |_|\\____/|_____/\n\
              OSS Framework for MoShell-%s \n\
              \n\
           \n\
",moshell_version)
	}
	else if (emcli != "")
	{
		printf("\
             ______ __  __  _____ _      _____   \n\
            |  ____|  \\/  |/ ____| |    |_   _| \n\
            | |__  | \\  / | |    | |      | |   \n\
            |  __| | |\\/| | |    | |      | |   \n\
            | |____| |  | | |____| |____ _| |_   \n\
            |______|_|  |_|\\_____|______|_____| \n\
              \n\
")
#                            %s     \n\
#",moshell_version)
	}
	else
	{
		printf("\
#####################################################################\n\
#            Welcome to MoShell %-36s#\n\
#                Finn Magnusson, Jan Pettersson                     #\n\
#           http://newtran01.au.ao.ericsson.se/moshell              #\n\
#            Contact: Finn.Magnusson@ericsson.com                   #\n\
#                     Joakim.xo.Ostlund@ericsson.com                #\n\
#####################################################################\n\
\n",\
sprintf("%-5s (LPA108514/1_R%-3s)",moshell_version,toupper(gensub(/\..| .*$/,"","g",moshell_version))))
	}
}
function moshell_age_check(  a,colorstart,colorend,line,reldate,nrwks,where,what)
{
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	moshell_max_age+=0
	if (moshell_max_age == 0) return
	if (emcli!="") return
	if (fileOps("test -f "relhistory)!=0) return
	while (getline line < relhistory)
	{
		gsub("\r","",line)
		if (line ~ /CHANGES IN .*2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]/)
		{
			match(line,/(2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9])/,a)
			reldate=make_timestamp(a[1])
			break
		}
	}
	close(relhistory)
	nrwks=sprintf("%.1f",(systime() - reldate)/(7*24*3600))+0
	nrwksi=sprintf("%.0f",(systime() - reldate)/(7*24*3600))+0
	#print reldate,nrwks,moshell_max_age
	if (nrwks > moshell_max_age)
	{
		if (in_amos_mode()) { what="AMOS" ; where="To obtain the latest released version contact your local Ericsson support."}
		else {what="moshell" ; where="Please download the latest version from http://newtran01.au.ao.ericsson.se/moshell" }
		customPrint(sprintf("%sWARNING: %sthe %s version currently running is more than %s weeks old.\nIt is recommended to always use the latest released moshell version.\n%s\n",colorstart,colorend,what,nrwksi,where))
	}
}

function write_cachedversionfile(latestver,cachedversionfile)
{
	fileOps("rm "cachedversionfile)
	close(cachedversionfile)
	print systime()" "latestver > cachedversionfile
	close(cachedversionfile)
	chmod(00666,cachedversionfile)
}
function moshell_version_check(    tempversionfile,line,array,colorstart,colorend,old_ip_connection_timeout,old_http_port,utran01_contact,latestver,cachedversionfile,refetch)
{
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	if (moshelldir=="/vobs/iov/rnc/bin/moshell")
	{
		customPrint(sprintf("%sWARNING: %sThe moshell installation in clearcase will not be maintained anymore, please run /app/moshell/latest/moshell/moshell instead\n",colorstart,colorend))
	}
	if (moshellversion_check == 0)
	{
		moshell_age_check()
		return
	}
	fileOps("mkdir -p "jarxmldir)
	chmodDir(00777,jarxmldir)
	cachedversionfile=jarxmldir"/latestmoshellversion.txt"
	tempversionfile=tempdir"/latestmoshellversion.txt"
	if (fileOps("test -s "cachedversionfile)!=0) refetch=1
	else
	{
		while (getline line < cachedversionfile)
		{
			#format is: systime() latestversion
			#for instance
			#1383062091 10.0f
			#1383062091 -1 (if unknown)
			gsub("\r","",line)
			split(line,array," ")
			latestver=array[2]
			if (array[1] ~ /^[0-9]+$/ && systime()-array[1] > 90000)
			{
				refetch=1
				#only checks once every 90,000 seconds (~ 24 hrs)
			}
		}
		close(cachedversionfile)
	}
	if (refetch!=1 && latestver=="-1")
	{
		moshell_age_check()
		return
	}
	if (refetch==1)
	{
		latestver="-1"
		old_ip_connection_timeout=ip_connection_timeout
		if (ip_connection_timeout > fast_timeout) ip_connection_timeout=fast_timeout
		utran01_contact=check_ip_contact("newtran01.au.ao.ericsson.se",80)
		ip_connection_timeout=old_ip_connection_timeout
		if (utran01_contact != 0)
		{
			write_cachedversionfile(latestver,cachedversionfile)
			moshell_age_check()
			return
		}
		#old_http_port=http_port ; http_port=80
		httpget("newtran01.au.ao.ericsson.se","/moshell/downloads/latestmoshellversion.txt",tempversionfile,"","silent","","",80,"http",0)
		if (fileOps("test -s "tempversionfile)==0)
		{
			while (getline line < tempversionfile)
			{
				gsub("\r","",line)
				split(line,array," ")
				latestver=array[1]
			}
			close(tempversionfile)
		}
		write_cachedversionfile(latestver,cachedversionfile)
		#http_port=old_http_port
	}
	if (latestver ~ /^1[0-9]\.[0-9][a-z]*$/ && moshell_version < latestver)
	{
		if (moshellversion_check==2)
		{
			customPrint(sprintf("%sERROR: %sthe current moshell version is not up to date. Current version: %s, latest version: %s\n",colorstart,colorend,moshell_version,latestver))
			exit_with_error("","Moshell version too old")
		}
		else customPrint(sprintf("%sWARNING: %sthe current moshell version is not up to date. Current version: %s, latest version: %s\n",colorstart,colorend,moshell_version,latestver))
	}
}
function check_disk(    df_command,freespace,dk_limit,info_text,colorstart,colorend)
{
	if (disk_check==0) return
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }

	#uas1-atvts91 # df -k /var/opt/ericsson/amos
	#Filesystem            kbytes    used   avail capacity  Mounted on
	#mashost:/var/opt/ericsson
	#                     16312320 11954689 4092039    75%    /var/opt/ericsson
	# df -k /var/opt/ericsson/amos
	#Filesystem            kbytes    used   avail capacity  Mounted on
	#mashost:/ossrc/ericsson
	#                     10240000 7412994 2658385    74%    /var/opt/ericsson

	#**:esekilab72ded15@~> df -k /proj/tfwlogs_wmr/users/eanzmagn/moshell_logfiles/logs_moshell/dcg/10.186.144.235
	#Filesystem           1K-blocks      Used Available Use% Mounted on
	#nfslab72-5.rnd.ki.sw.ericsson.se:/export/share2
	#                     128949031200 4274409920 124674621280   4% /proj/tfwlogs_wmr
	#esekits1002 [8:07am] [/home/eanzmagn] -> df -k moshell_logfiles/
	#Filesystem            kbytes    used   avail capacity  Mounted on
	#kihome2.rnd.ki.sw.ericsson.se:/vol/volh13003/x1/0/37/eanzmagn
	#                     2778726400 2119766984 658959416    77%    /home/eanzmagn
	#[~]$ df -k /home/eanzmagn/moshell_logfiles
	#Filesystem     1K-blocks      Used Available Use% Mounted on
	#C:/cygwin      301100024 115644000 185456024  39% /

	#-bash-3.00# df -k /moshellcompile
	#Filesystem           1K-blocks      Used Available Use% Mounted on
	#/dev/dsk/c0t0d0s0    292466166  18120382 271421123   7% /
	#-bash-3.00# /bin/df -k /moshellcompile
	#Filesystem            kbytes    used   avail capacity  Mounted on
	#/dev/dsk/c0t0d0s0    292466166 18120382 271421123     7%    /

	freespace=-1
	df_command="df -k "logdir
	while (df_command |& getline)
	{
		#sometimes the printout takes one line, sometimes two lines, depending on the length of the first field "filesystem"
		if ($1 !~ /^[0-9]+$/) sub($1,"")
		if ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/ && $3 ~ /^[0-9]+$/) freespace=$3+0
	}
	close(df_command)
	dk_limit=parse_size(disk_limit)+0
	freespace*=1024
	if (mosdebug==1) print "DISK freespace="freespace" ("size_to_h(freespace)"), limit="dk_limit" ("disk_limit")"
	if (freespace >= 0)
	{
		if (dk_limit > 0)
		{
			if (freespace < dk_limit)
			{
				#Disk check settings can be modified in the uservariables disk_check and disk_limit.\n\
				#Refer to %s/UserGuide.pdf chapter 2.5 for more information.\n",\
				infotext=sprintf("Not enough free disk space on %s: free=%s, disk_limit=%s\n\
The command \"smd\" can be used for disk cleanup. Type \"h smd\" for info.\n",\
logdir,size_to_h(freespace,"int"),size_to_h(dk_limit,"int"),moshelldir)
				if (disk_check==2)
				{
					customPrint(colorstart"ERROR: "colorend infotext)
					exit_with_error("","Not enough free disk space")
				}
				else customPrint(colorstart"WARNING: "colorend infotext)
			}
		}
		else customPrint(colorstart"WARNING: incorrect value for disk_limit, unable to perform disk space check."colorend)
	}
	else customPrint(colorstart"WARNING: fail to parse \"df -k\", unable to perform disk space check."colorend)
}
function parse_size(size)
{
	size=toupper(size)
	if (size !~ /^[0-9]+[BMGKT]?$/) return -1
	return h_to_size(size)
}
function check_ram(    df_command,freespace,dk_limit,info_text,colorstart,colorend,freePos)
{
	if (ram_check==0) return
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }

	#SOLARIS SPARC
	#esekits1076 [8:23am] [/home/eanzmagn] -> prtconf
	#System Configuration:  Sun Microsystems  sun4u
	#Memory size: 65536 Megabytes
	#esekits1076 [8:29am] [/home/eanzmagn] -> vmstat 1 2
	# kthr      memory            page            disk          faults      cpu
	# r b w   swap  free  re  mf pi po fr de sr m1 m1 m1 m2   in   sy   cs us sy id
	# 1 0 93 94964040 37736696 519 4012 68 6 6 0 24 10 10 10 0 6902 298259 8138 8 11 80
	# 0 0 111 87169520 31538272 28 208 0 0 0 0 0 0  0  0  0 7188 1082961 8793 9 6 85
	#
	#root@atrcus544.athtem.eei.ericsson.se# prtconf
	#System Configuration:  Oracle Corporation  sun4u
	#Memory size: 8192 Megabytes
	#root@atrcus544.athtem.eei.ericsson.se# vmstat 1 2
	# kthr      memory            page            disk          faults      cpu
	# r b w   swap  free  re  mf pi po fr de sr m1 m1 m2 m2   in   sy   cs us sy id
	# 0 0 0 16916640 7456872 9 53 0  0  0  0  0 12  9  0  0  421  272  377  1  0 99
	# 0 0 0 16965496 7571984 0 14 0  0  0  0  0  0  0  0  0  436  210  346  0  0 100

	#SOLARIS X86
	#atrcxb1763{root} # prtconf
	#System Configuration:  Oracle Corporation  i86pc
	#Memory size: 65526 Megabytes
	#atrcxb1763{root} # vmstat 1 2
	# kthr      memory            page            disk          faults      cpu
	# r b w   swap  free  re  mf pi po fr de sr m1 m1 m2 m2   in   sy   cs us sy id
	# 17 0 0 154722988 17272584 864 7975 6 6 6 0 1 1 1 0  0 14713 250385 57927 21 5 74
	# 13 0 0 269367284 16169216 22 438 0 0 0 0 0 0  0  0  0 10536 217519 51323 17 3 80
	#
	#LINUX 32
	#una**:wl7257@~> uname -a
	#Linux wl7257 2.6.27.42-0.1-default #1 SMP 2010-01-06 16:07:25 +0100 i686 i686 i386 GNU/Linux
	#**:wl7257@~> cat /proc/meminfo
	#MemTotal:      3614688 kB
	#MemFree:        197720 kB
	#Buffers:        256060 kB
	#Cached:        1956424 kB
	#SwapCached:          0 kB
	#Active:        1627092 kB
	#Inactive:      1601844 kB
	#HighTotal:     2735876 kB
	#HighFree:       171664 kB
	#LowTotal:       878812 kB
	#LowFree:         26056 kB
	#SwapTotal:     4200956 kB
	#SwapFree:      4200924 kB
	#Dirty:            1492 kB
	#Writeback:           0 kB
	#AnonPages:     1015568 kB
	#Mapped:         147392 kB
	#Slab:           148260 kB
	#SReclaimable:   131208 kB
	#SUnreclaim:      17052 kB
	#PageTables:       5608 kB
	#NFS_Unstable:        0 kB
	#Bounce:              0 kB
	#WritebackTmp:        0 kB
	#CommitLimit:   6008300 kB
	#Committed_AS:  1774568 kB
	#VmallocTotal:   110584 kB
	#VmallocUsed:     54676 kB
	#VmallocChunk:    53748 kB
	#HugePages_Total:     0
	#HugePages_Free:      0
	#HugePages_Rsvd:      0
	#HugePages_Surp:      0
	#Hugepagesize:     4096 kB
	#DirectMap4k:    700416 kB
	#DirectMap4M:    217088 kB
	#**:wl7257@~> vmstat 1 2
	#procs -----------memory---------- ---swap-- -----io---- -system-- -----cpu------
	# r  b   swpd   free   buff  cache   si   so    bi    bo   in   cs us sy id wa st
	# 0  0     32 197860 256060 2087620    0    0     1     4    5    3  1  0 98  1  0
	# 0  0     32 197852 256060 2087620    0    0     0     0  220  314  0  0 100  0  0
	#**:wl7257@~> free
	#             total       used       free     shared    buffers     cached
	#Mem:       3614688    3416828     197860          0     256060    2087620
	#-/+ buffers/cache:    1073148    2541540
	#Swap:      4200956         32    4200924
	#
	#LINUX 64
	#[newtran01:~]$ free
	#             total       used       free     shared    buffers     cached
	#Mem:      32940040   32134092     805948          0     516668   15869488
	#-/+ buffers/cache:   15747936   17192104
	#Swap:     16383992        208   16383784
	#[newtran01:~]$ cat /proc/meminfo
	#MemTotal:     32940040 kB
	#MemFree:        812208 kB
	#Buffers:        514460 kB
	#Cached:       15869416 kB
	#SwapCached:          0 kB
	#Active:       24330480 kB
	#Inactive:      7041784 kB
	#HighTotal:           0 kB
	#HighFree:            0 kB
	#LowTotal:     32940040 kB
	#LowFree:        812208 kB
	#SwapTotal:    16383992 kB
	#SwapFree:     16383784 kB
	#Dirty:             608 kB
	#Writeback:           0 kB
	#AnonPages:    14988388 kB
	#Mapped:         189216 kB
	#Slab:           551184 kB
	#PageTables:     125800 kB
	#NFS_Unstable:        0 kB
	#Bounce:              0 kB
	#CommitLimit:  32854012 kB
	#Committed_AS: 48005976 kB
	#VmallocTotal: 34359738367 kB
	#VmallocUsed:    270912 kB
	#VmallocChunk: 34359467115 kB
	#HugePages_Total:     0
	#HugePages_Free:      0
	#HugePages_Rsvd:      0
	#Hugepagesize:     2048 kB
	#[newtran01:~]$ vmstat 1 2
	#procs -----------memory---------- ---swap-- -----io---- --system-- -----cpu------
	# r  b   swpd   free   buff  cache   si   so    bi    bo   in   cs us sy id wa st
	# 1  0    208 812148 514460 15869420    0    0    42    21    0    0  6  4 89  0  0
	# 1  0    208 812148 514460 15869428    0    0     0     0 1011 1905  4  9 88  0  0

	df_command="vmstat 1 2"
	while (df_command |& getline)
	{
		for (i=1;i<=NF;i++)
		{
			if ($i=="free") { freePos=i ; break }  #free memory is in 4th position on linux and 5th position in solaris
		}
		freespace=$freePos * 1024
		#on linux we must also add buff and cache to the amount of free memory
		if (os=="linux") freespace+=($(freePos+1) + $(freePos+2))*1024
	}
	close(df_command)
	dk_limit=parse_size(ram_limit)+0
	if (mosdebug==1) print "RAM freespace="freespace" ("size_to_h(freespace)"), limit="dk_limit" ("ram_limit")"
	if (freespace > 0)
	{
		if (dk_limit > 0)
		{
			if (freespace < dk_limit)
			{
				#RAM check settings can be modified in the uservariables ram_check and ram_limit.\n\
				#Refer to %s/UserGuide.pdf chapter 2.5 for more information.\n
				infotext=sprintf("Not enough free RAM: free=%s, ram_limit=%s\n",\
size_to_h(freespace,"int"),size_to_h(dk_limit,"int"),moshelldir)
				if (ram_check==2)
				{
					customPrint(colorstart"ERROR: "colorend infotext)
					exit_with_error("","Not enough free RAM")
				}
				else customPrint(colorstart"WARNING: "colorend infotext)
			}
		}
		else customPrint(colorstart"WARNING: incorrect value for ram_limit, unable to perform RAM check."colorend)
	}
	else customPrint(colorstart"WARNING: fail to parse \"vmstat 1 2\", unable to perform RAM check."colorend)
}
function check_sessions(    info_text,colorstart,colorend,ps_command,n)
{
	if ((max_sessions+0)==0) return
	if (os=="cygwin") return
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }

	# ps -u $USER -o args
	#/bin/bash -p /home/eanzmagn/moshell/moshell 10.67.22.9

	ps_command="ps -u "moshellUSER" -o args"
	while (ps_command |& getline)
	{
		if ($0 ~ /\/bin\/bash -p [^ ]*\/moshell /) n++
	}
	close(ps_command)
	if (n>max_sessions)
	{
		infotext="Too many sessions started by this user"
		customPrint(colorstart"ERROR: "colorend infotext" (max: "max_sessions")\n")
		exit_with_error("",infotext)
	}
}
function check_sessions_all(    info_text,colorstart,colorend,ps_command,n)
{
	if ((max_sessions_all+0)==0) return
	if (os=="cygwin") return
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }

	# ps -u $USER -o args
	#/bin/bash -p /home/eanzmagn/moshell/moshell 10.67.22.9

	ps_command="ps -e -o args"
	while (ps_command |& getline)
	{
		if ($0 ~ /\/bin\/bash -p [^ ]*\/moshell /) n++
	}
	close(ps_command)
	if (n>max_sessions_all)
	{
		infotext="Too many sessions started on this workstation"
		customPrint(colorstart"ERROR: "colorend infotext" (max: "max_sessions_all")\n")
		exit_with_error("",infotext)
	}
}
#this function is for converting CXC number <-> lmid
function lmid(pattern,lmidoption,   matches,lm,i)
{
	#if (comcli>0) return comcli_error()
	if (pattern == "")
	{
		Display_help("lmid")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	pattern=tolower(pattern);

	if (lmidoption ~ "c")
	{
		define_codes()
		for (i=1;i<=max_lmid_code;i++) if (tolower(lmid_code_list[i]) ~ pattern) customPrint(lmid_code_list[i])
		return
	}
	if (lmidoption ~ "h")
	{
		buildHwidTable()
		search_lmid(pattern,hwidTable)
		return
	}


	gsub("/","%",pattern); # replace / with % for the LM search
	buildLmidTable("force")
	matches=search_lmid(pattern,lmidTable)

	#If there are no matches we update the lmid table
	if (nocorba==0 && matches == 0)
	{
		#Running makeBoTables() messes up the BoardType table in Gen2
		#if (node_address != "OFFLINE" && multi != 1 && (boTablesMade != 1 || boRefresh==1))
		#{
		#	makeBoTables()
		#	search_lmid(pattern,lmidTable)
		#}
		#else
		{
			customPrint("LM not found in the lmid database.")
			if (node_address=="OFFLINE" || multi==1) customPrint("To update the lmid database, please connect to a node and run the command again.")
			else customPrint("To update the lmid database, please run the \"bor\" command.")
		}
	}
}
function upidfunc(what,    pattern,n,i,line,array)
{
	#if (comcli>0) return comcli_error()
	pattern=tolower($2)
	buildLmidTable()
	customPrint(sprintf("%-5s  %-24s  %11s  %s","Node","UpgradePackage","Release/MOM","CppVersion"))
	if (what ~ "m")
	{
		n=asort(formatted_uptomomTable)
		for (i=1;i<=n;i++)
		{
			split(formatted_uptomomTable[i],array,";")
			line=sprintf("%-5s  %-24s  %11s",array[1],array[2],array[3])
			if (tolower(line) ~ pattern) customPrint(line)
		}
		return
	}
	n=asort(formatted_uptorel)
	for (i=1;i<=n;i++)
	{
		split(formatted_uptorel[i],array,";")
		line=sprintf("%-5s  %-24s  %-11s",array[1],array[3],array[2])
		if (tolower(line) ~ pattern) customPrint(line)
	}
	if (what ~ "o") return
	n=asort(formattedUpid)
	for (i=1;i<=n;i++)
	{
		split(formattedUpid[i],array,";")
		#RNC;501;P5.0.1;CXPxxx_xxx;5.1.2-3
		line=sprintf("%-5s  %-24s  %-11s  %s",array[1],array[4],array[3],array[5])
		if (tolower(line) ~ pattern) customPrint(line)
	}
}
function search_lmid(pattern,table,   lm,matches)
{
	for (lm in table)
	{
		if (tolower(lm) ~ pattern)
		{
			customPrint(lm)
			matches++
		}
	}
	return matches+0
}
function clean_lmid(   i,line,j,found,uniqueline,k,lmid_ok,tmplmiddb)
{
	#new bug correction: the permission of lmiddb had been set to 644, we must put it back to 666
	chmod(00666,lmiddb)  #TR HJ93515
	#there was a bug in previous moshell versions leading to duplicate entries in lmiddb
	#we clean the lmiddb file by only keeping the LAST instance of each duplicate
	#there was also a bug where LM productDate was written instead of LM productName. Remove those entries
	if (fileOps("test -s "lmiddb)!=0) return
	close(lmiddb)
	while (getline < lmiddb)
	{
		if ($1=="Do_not_remove_this_line:lmid_ok2") { lmid_ok=1 ; break }
		if (NF != 2 || $2 ~ /^[0-9]+$/ || $2 ~ /^CXC[0-9]/) continue
		line[++i]=$0
	}
	close(lmiddb)
	if (lmid_ok) return
	for (j=i;j>=1;j--)
	{
		if (line[j] in found) continue
		found[line[j]]=1
		uniqueline[++k]=line[j]
	}
	tmplmiddb=tempdir"/lmids.txt"
	empty_file(tmplmiddb)
	print "Do_not_remove_this_line:lmid_ok2" > tmplmiddb
	for (i=k;i>=1;i--) print uniqueline[i] >> tmplmiddb
	close(tmplmiddb)
	fileOps("mv "lmiddb" "lmiddb".old2")
	fileOps("mv "tmplmiddb" "lmiddb)
	chmod(00666,lmiddb) #TR HJ93515
	system("gzip -f "lmiddb".old2")
}
function ftrun(    ftfile,com,commandList,i)
{
	i=0
	delete commandList
	ftfile=$2
	if (ftfile=="")
	{
		Display_help("ftrun")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	if (fileOps("test -s "ftfile)!=0)
	{
		customPrint("ERROR: file "ftfile" not found.")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	check_node_password()
	if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
	while (getline < ftfile)
	{
		gsub("\r","")
		if (!($1 ~ /^(ft)?(get|put|del)/ && $2!="" && $3!="")) continue
		sub(/[/]+$/,"",$3)
		if ($1~/get/) com="get"
		else if ($1~/put/) com="put"
		else if ($1~/del/) com="dele"
		commandList[++i]=com" "$2" "$3
	}
	close(ftfile)
	return ftpclient(node_address,node_password,"",commandList)
}
function evalnodecase(text)
{
	if (prompt_case>0) return text
	return toupper(text)
}
function edit(file,  tempeditfile,putdir,filename,edit_session,localfilename,datetime)
{
	if (multi) return multi_error()
	customPrint("")
	if (file == "")
	{
		Display_help("edit")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}

	check_node_password()
	if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
	if (checkIfDir("ose",file)==0)
	{
		customPrint("Error: "file" is a directory!!")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	# download the file and edit it using our favourite editor
	datetime=mystrftime("%y%m%d_%H%M%S",systime())
	filename=gensub(/.*\//,"","g",file) # get the file name
	localfilename=filename"."dotnode_address"."datetime
	tempeditfile=sprintf("%s/other/%s",logdir,localfilename)
	#tempeditfile=make_cygpath(tempeditfile)
	if (ftp("get",file,tempeditfile) != 0)
	{
	        customPrint("File not found on node, generating new file...")
	}
	edit_session=sprintf("%s %s",editor,tempeditfile)

	customPrint("Spawning editor. Exit editor to return to moshell.")
	print edit_session
	mysleep(3)
	if (system(edit_session) != 0 )
	{
		customPrint("ERROR: Failed editing the file! File will not be transferred back to the node.")
		customPrint("Edited file saved at: "tempeditfile)
		return
	}

	# now get the directory for ftpput
	putdir=gensub(/(.*\/).*$/,"\\1",1,file)
	#print putdir
	if (putdir !~ /\//)
	{
		putdir=CurrentDir # if there was no directory then set putdir to CurrentDir
	}
	sub(/\/$/,"",putdir)

	if (fileOps("test -f "tempeditfile)==0)
	{
		if (ftp("put",tempeditfile,putdir"/"filename) == 0) fileOps(sprintf("rm %s",tempeditfile)) # remove the downloaded file
		else customPrint(sprintf("Error uploading file. Edited file saved at: %s",tempeditfile))
	}
}
function ftpg(what,    minustime,plustime,startdate,enddate,filter,arg1,arg2,i,array,printdateinfo,maxfiles,ftreeInputFile,old_dollar)
{
	if (multi) return multi_error()
	for (i=2;i<=NF;i++)
	{
		if ($i ~ /^-(m|p|s|e|f|n|i)$/)
		{
			     if ($i=="-m") { minustime=$(i+1) ; printdateinfo=1 }
			else if ($i=="-p") { plustime=$(i+1)  ; printdateinfo=1 }
			else if ($i=="-s") { startdate=$(i+1) ; printdateinfo=1 }
			else if ($i=="-e") { enddate=$(i+1)   ; printdateinfo=1 }
			else if ($i=="-f") filter=$(i+1)
			else if ($i=="-n") maxfiles=$(i+1)+0  #internal use only, not advertised in the help
			else if ($i=="-i") ftreeInputFile=$(i+1)   #internal use only, not advertised in the help
			i++
		}
		else if (arg1=="") arg1=$i
		else if (arg2=="") arg2=$i
	}
	check_node_password()
	if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
	if (comcli>0 && use_tls>0)
	{
		old_dollar=$0 #backup the $0
		if (node_password=="nopassword") node_password=""
		check_node_password("sftp")
		if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
		$0=old_dollar #restore $0
	}
	#GET TODAY FROM NODE IN CASE THE NODE IS NOT RUNNING UTC TIME (used to be: today=getTodayUTC() )
	today=getTodayFromNode()
	split(parse_days(today,startdate,enddate,minustime,plustime),array,";")
	if (array[1]==999) return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
	startdate=array[1] ; enddate=array[2]

	if (printdateinfo) customPrint(sprintf("Startdate=%s, Enddate=%s",mystrftime("%Y%m%d.%H%M%S",startdate),mystrftime("%Y%m%d.%H%M%S",enddate)))
	if (what=="del") what="dele"
	if (mosdebug==1) print "what="what,"arg1="arg1,"arg2="arg2,"filter="filter,"startdate="startdate,"enddate="enddate
	return ftp(what,arg1,arg2,filter,startdate,enddate,"","","",maxfiles,ftreeInputFile)
}

function ftp(what,arg1,arg2,filter,start_date,end_date,nocurrentrop,norecursive,fileprefix,maxfiles,ftreeInputFile,    result,nomakeroot,t_res)
{
	#what: put,get,putc,getc (the "c" is for conditional get/put)
	#arg1,arg2: localfile/localdir or remotefile/remotedir. Recursive get/put occurs if arg1 is a localdir/remotedir
	#filter,start_date,end_date are optional and apply only to "recursive get", not "put"
	#filter: only the files matching the filter will be fetched
	#start_date,end_date: only the files with the timestamp in this timespan will be fetched
	#nocurrentrop=="nocurrentrop" ==> files from the current rop are not fetched from node. Only applicable for recursive get conditional ("getc"). Used by the "pme" command to avoid fetching empty ROP files.
	#norecursive=="norecursive" ==> only files directly under the folder are fetched from node. Used by pme command and also for folders located on local volumes, to avoid fetching matching files in subfolders
	#if there is a * at the end of the source folder, we don't create the root folder, only the subfolders. eg: ftput /home/eanzmagn/files/* /d/loadmodules --> means we don't make the folder "files" in the destination
	#maxfiles only transfers the last xxx files

	if (mosdebug==1) print "ftp: what="what,"arg1="arg1,"arg2="arg2,"filter="filter,"start="start_date,"end="end_date,"nocurr="nocurrentrop,"norec="norecursive,"filepref="fileprefix

	if (arg1 == "")
	{
		if (what ~ /^put/) Display_help("ftput")
		if (what ~ /^get/) Display_help("ftget")
		return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
	}
	check_node_password()
	if (node_password == "") return 1
	#remove any trailing *
	if (arg1 ~ /\*$/)
	{
		nomakeroot=1
		gsub(/[*]+$/,"",arg1)
	}
	#remove any trailing slashes
	gsub(/[/]+$/,"",arg1)
	gsub(/[/]+$/,"",arg2)
	if (what ~ /^put/)
	{
		if (arg2=="") arg2=sprintf("%s/%s",CurrentDir,gensub(/^.*\//,"","g",arg1))
		if (arg2 !~ /^\//) arg2=sprintf("%s/%s",CurrentDir,arg2)
		if (checkIfDir("",arg1) == 0) return recursive_ftp(what,arg1,arg2,filter,"","","","","",nomakeroot,maxfiles)
		t_res=checkIfDir("ose",arg2)
		if (t_res==999) return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
		if (t_res==0) arg2=sprintf("%s/%s",arg2,gensub(/^.*\//,"","g",arg1)) #check if arg2 is a directory; if yes, convert it to a file name
	}
	else if (what ~ /^get/)
	{
		if (arg1 ~ /^[0-9][0-9][0-9][0-9]00!\/[cpr]/) sub(/^[0-9][0-9][0-9][0-9]00!\//,"/",arg1) #the user tried to fetch from a global volume by giving the local link handler
		if (arg1 ~ /^[0-9][0-9][0-9][0-9]00!\//) norecursive="norecursive"
		if (arg1 !~ /^(\/|[0-9][0-9][0-9][0-9]00!\/)/) arg1=sprintf("%s/%s",CurrentDir,arg1)
		t_res=checkIfDir("ose",arg1)
		if (t_res==999) return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
		if (t_res==0) return recursive_ftp(what,arg1,arg2,filter,start_date,end_date,nocurrentrop,norecursive,fileprefix,nomakeroot,maxfiles,ftreeInputFile)
		if (arg2=="") arg2=gensub(/^.*\//,"","g",arg1)
		if (checkIfDir("",arg2)==0) arg2=sprintf("%s/%s",arg2,gensub(/^.*\//,"","g",arg1)) #check if arg2 is a directory; if yes, convert it to a file name
	}
	else if (what ~ /^del/)
	{
		if (arg1 !~ /^\//) arg1=sprintf("%s/%s",CurrentDir,arg1)
		t_res=checkIfDir("ose",arg1)
		if (t_res==999) return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
		if (t_res==0) return recursive_ftp(what,arg1,"",filter,start_date,end_date,nocurrentrop,norecursive,fileprefix,nomakeroot,maxfiles)
		else
		{
			customPrint("Error: no such directory "arg1".")
			return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
		}
	}

	result=ftpclient(node_address,node_password,sprintf("%s %s %s",gensub(/c*$/,"","g",what),arg1,arg2))
	assignCustomVar("$ftp_result",result)
	return result
}
function recursive_ftp(what,arg1,arg2,filter,start_date,end_date,nocurrentrop,norecursive,fileprefix,nomakeroot,maxfiles,ftreeInputFile,   \
i,commandList,j,fileListSrc,fileListDest,localfilename,existingDirList,existingFileList,destdir,destfile,localdir,\
localfile,tmp_timestamp,a,line,filePrintout,today,answer,tmp_filename,ls_session,negfilter,fcount,lfArray,lfDir,dirListSrc,y,theDirSrc,k,sfile_list,\
arr,thedest,tempdest,z,expok,exportParams,n,tlgdir,thepassword,theusername,theserver,loclgdir,thepwfile,sep,ciphers,theserverport,theexportcommand)
{
	gsub(/[/]+$/,"",arg1)
	gsub(/[/]+$/,"",arg2)
	negfilter=0
	if (filter ~ /^!/)
	{
		sub(/^!/,"",filter)
		negfilter=1
	}

	if (what ~ /^(get|del)/)
	{
		if (what ~ /^get/)
		{
			if (arg2 == "") arg2=sprintf("./%s",gensub(/^.*\//,"","g",arg1))
			else if (arg2 !~ sprintf("%s/*$",gensub(/^.*\//,"","g",arg1)))
			{
				if (!(arg2==ctlogdir || arg2==gplogdir || arg2==uelogdir || arg2==rnlogdir)) arg2=sprintf("%s/%s",arg2,gensub(/^.*\//,"","g",arg1))
			}
			if (nomakeroot==1) sub(/\/[^/]+$/,"",arg2)
			if (checkIfDir("",arg2) != 0)
			{
				if (fileOps("mkdir -p "arg2) != 0)
				{
					customPrint(sprintf("Error: %s is not a valid directory",arg2))
					return 1
				}
			}
		}
		#print "arg1: "arg1" arg2: "arg2
		fcount=0
		if (nocurrentrop=="nocurrentrop") today=getTodayFromNode()
		if (ftreeInputFile!="" && fileOps("test -s "ftreeInputFile)==0) fileOps("cp "ftreeInputFile" "tempgalog)
		else
		{
			mo_log(tempgalog,"open","mute","overwrite","silent")
			muteFactor=800
			#print "maxfiles="maxfiles
			ftree(gensub(/\/+$/,"",1,arg1),"","",(fileprefix=="%pmd%"?"f":""),norecursive,(maxfiles>0?"reverse":""))
			mo_log(tempgalog,"close")
		}
		print ""
		while (getline line < tempgalog)
		{
			#we do a getline to "line" because otherwise, this part was crashing sometimes
			$0=line
			gsub("\r","") ; gsub("\x000","")
			if ($NF ~ /^\([^)]+\)$/) sub(/ +\([^)]+\)$/,"")   #removal of LM CXC translation , will not be there unless we ran with option "-i <ftreefile>" (internal option)
			#ftget /d/configuration/cv:
			#drwxrwxrwx  512        7 Feb 2005 05:48:09  /d/configuration/cv/M_MGw_Inc7CM50_030205A_EPAMILL_RTDMA/
			#-rw-rw-rw-  26893      7 Feb 2005 05:48:06  /d/configuration/cv/M_MGw_Inc7CM50_030205A_EPAMILL_RTDMA/ARMAMENT
			#-rw-rw-rw-  142        7 Feb 2005 05:48:07  /d/configuration/cv/M_MGw_Inc7CM50_030205A_EPAMILL_RTDMA/attribute

			#-rw-r-----      root  prbs_basic_group 4283 Sep 27  /opt/com/comea/internalFiles/PerformanceManagementReportFiles/A20130927.0714+0000-0729+0000_1.xml

			#PICO W15
			#drwxrwx---      1440  11 Dec 2015 09:23:00  /oss/persistent/diag2/csync_log/
			#-rw-rw----      8667  11 Dec 2015 09:23:00  /oss/persistent/diag2/csync_log/ntp_statslog_3.log
			#-rw-rw----     24380  11 Dec 2015 09:23:00  /oss/persistent/diag2/csync_log/ntp_statslog_3.log.1


			if (what ~ /^get/ && $1~/^d/)
			{
				localdir=sprintf("%s%s",arg2,gensub(arg1,"",1,$NF))
				if (fileOps(sprintf("mkdir -p %s",localdir))!=0)
				{
					customPrint(sprintf("Unable to create the directory: %s",localdir))
					close(tempgalog)
					return 1
				}
			}
			else if (what ~ /^del/ && $1~/^d/ && filter=="")
			{
				dirListSrc[$NF]=$NF
			}
			else if (what ~ /^del/ && NF==1 && $1==sprintf("%s/",arg1))
			{
				theDirSrc=arg1
			}
			else if ($1~/^-r/)
			{
				if (fileprefix == "%pmd%")
				{
					#-rw-rw-rw-  120208     5 Dec 2006 18:15:00  /c/pm_data/A20061205.1800-1815_CTR_20001.bin.gz
					if ($NF ~ /^\/c\/pmd\//) tmp_filename=gensub(/\//,"_","g",$NF)
					#/c/logfiles/dspdumps/00_01/ECDAdump17408-01.gz
					#/d/logfiles/dspdumps/00_02/ECDAdump17408-02.gz
					else if ($NF ~ /\/dspdumps\/00/) tmp_filename=gensub(/\//,"_","g",gensub(/^.*\/dspdumps/,"",1,$NF))
					#/p000200/logfiles/dspdumps/GCPUdump1024-03.gz
					else if ($NF ~ /^\/p00/) tmp_filename="_"gensub(/^\/p|00\/.*$/,"","g",$NF)"_"gensub(/^.*\/dspdumps\//,"",1,$NF)
					#/d/logfiles/dspdumps/EMdump768-08.gz
					else if ($NF ~ /^\/d\/logfiles\/dspdumps\/[^0]/) tmp_filename="_0001_"gensub(/^.*\/dspdumps\//,"",1,$NF)
					else tmp_filename=gensub(/^.*\//,"_",1,$NF)
					localfilename=sprintf("%s/%s%02d%02d_%s%s",arg2,$5,mm[$4],$3,gensub(/:/,"","g",$6),tmp_filename)
				}
				else if (fileprefix != "") localfilename=sprintf("%s/%s%s",arg2,fileprefix,gensub(/^.*\//,"",1,gensub(arg1,"",1,$NF)))
				else if (is_rcs()==1 && $NF ~ "/rcs/dumps/pmd/") localfilename=sprintf("%s/%s",arg2,gensub(/^\/rcs\/dumps\/pmd\/[0-9]+_/,"",1,$NF))
				else localfilename=sprintf("%s%s",arg2,gensub(arg1,"",1,$NF))
				#rename files in /c/3gsim/stats from 2013-06-01_16:15:00_statistics.xml.gz to A20130601.1615-1615.xml.gz
				if (filter==pmfilter && pmdatapath ~ /^\/[cdrp]/ && localfilename ~ /^\/.+\/[12][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]_[0-9][0-9]:[0-9][0-9]:[0-9][0-9]_statistics.xml.gz$/)
				{
					lfDir=gensub(/\/[^/]+$/,"",1,localfilename)
					split(gensub(/^.*\//,"",1,localfilename),lfArray,/[-_:]/)
					localfilename=lfDir"/A"lfArray[1] lfArray[2] lfArray[3] "." lfArray[4] lfArray[5] "-" lfArray[4] lfArray[5] ".xml.gz"
					#print filter,pmfilter,pmdatapath,localfilename
				}
				#replace colon ":" with dot "." as colon cannot be used on windows
				if (localfilename ~ /:/ && localfilename !~ /^.:/) localfilename=gensub(/:/,".","g",localfilename)
				#the sole purpose of localfilename is to check whether the file already exists locally (conditional download)
				if (what ~ /^getc/)
				{
					#conditional download, file already exists on workstation and is not empty
					#VERY important to have the fileops before the pattern matching on "what":
					#this way the the fileOps operation is always done and it avoids possible hangings
					#when recursive download of a directory in secure_ftp=0
					#this hanging was due to choosing a data port already in use, but does not happen with this fix
					if (fileOps("test -s "localfilename)==0)
					{
						#if it is a corrupted gz file then we will download it again
						if (localfilename ~ /\.gz$/ && fileOps("gzip -t "localfilename)!=0) {}
						else continue
					}
					else if (is_rcs()==1 && localfilename~"/pmd-")
					{
						if (fileOps("test -s "gensub(/\.tgz$/,".zip",1,localfilename))==0) continue
						else if (fileOps("test -s "localfilename".gpg")==0) continue
						else if (fileOps("test -s "localfilename"_with_llog.tgz")==0) continue
						else if (fileOps("test -s "localfilename".gpg_with_llog.tgz")==0) continue
					}
				}
				#if (filter==pmfilter && comcli>0 && localfilename ~ /^\/.+\/A[12][0-9][0-9][0-9].*\.xml$/ && fileOps("test -s "localfilename".gz")==0 && what ~ /^getc/)
				#{
				#	#the rop files are gzipped locally
				#	#NOT YET IMPLEMENTED
				#	continue
				#}
				if ((negfilter==0 && $NF ~ filter)||(negfilter==1 && $NF !~ filter))
				{
					#for XML ROP files we use the end time in the file name because the time stamp is a few minutes later than the rop end date
					#PICO: /opt/com/comea/internalFiles/PerformanceManagementReportFiles/A20131129.1315+0000-1330+0000_PRBS389.xml
					#G2: /rop/A20140102.1400+0000-1415+0000.gz
					#G2: /c/logfiles/troubleshooting/exception/logs/201603240115-0130_exception_1.bin.gz
					#example: -rw-rw-rw-   0      9527   1 Sep 2010 19:04:00 A20100901.1845-1900:1.xml.gz
					if (comcli>0 && $NF ~ /\/(A[0-9]+\.[0-9]+[^/]+\.(xml|gz)$|[0-9]+-[0-9]+_exception_[0-9]+.bin.gz$)/) tmp_timestamp=make_file_timestamp($NF,".(xml|gz)$")
					else if (comcli==0 && $NF ~ /A[^/]+[.:][1-2]\.xml.gz$/) tmp_timestamp=make_file_timestamp($NF,".xml.gz$")
					#for other files we use the file timestamp
					#-rw-rw----      8667  11 Dec 2015 09:23:00  /oss/persistent/diag2/csync_log/ntp_statslog_3.log
					else tmp_timestamp=make_timestamp(sprintf("%s-%s-%s",$5,mm[$4],$3),$6)
					if (nocurrentrop=="nocurrentrop" && today < make_file_timestamp($NF,"(lnk|bin)(.gz)*$"))
					{
						#means that the ROP period is not yet finished for this file
						#we do not download files for the current rop if the parameter nocurrentrop is set
						continue
					}
					#print tmp_timestamp,start_date,end_date,$0
					if (tmp_timestamp >= start_date || start_date=="")
					{
						if (tmp_timestamp <= end_date || end_date=="")
						{
							fcount++
							if (maxfiles>0 && fcount>maxfiles) continue
							fileListSrc[++i]=$NF
							if (fileprefix == "%pmd%")
							{
								#-rw-rw-rw-  120208     5 Dec 2006 18:15:00  /c/pm_data/A20061205.1800-1815_CTR_20001.bin.gz
								if ($NF ~ /^\/c\/pmd\//) tmp_filename=gensub(/\//,"_","g",$NF)
								#/c/logfiles/dspdumps/00_01/ECDAdump17408-01.gz
								#/d/logfiles/dspdumps/00_02/ECDAdump17408-02.gz
								else if ($NF ~ /\/dspdumps\/00/) tmp_filename=gensub(/\//,"_","g",gensub(/^.*\/dspdumps/,"",1,$NF))
								#/p000200/logfiles/dspdumps/GCPUdump1024-03.gz
								else if ($NF ~ /^\/p00/) tmp_filename="_"gensub(/^\/p|00\/.*$/,"","g",$NF)"_"gensub(/^.*\/dspdumps\//,"",1,$NF)
								#/d/logfiles/dspdumps/EMdump768-08.gz
								else if ($NF ~ /^\/d\/logfiles\/dspdumps\/[^0]/) tmp_filename="_0001_"gensub(/^.*\/dspdumps\//,"",1,$NF)
								else tmp_filename=gensub(/^.*\//,"_",1,$NF)
								fileListDest[i]=sprintf("%s/%s%02d%02d_%s%s",arg2,$5,mm[$4],$3,gensub(/:/,"","g",$6),tmp_filename)
							}
							else if (fileprefix != "") fileListDest[i]=sprintf("%s/%s%s",arg2,fileprefix,gensub(/^.*\//,"",1,gensub(arg1,"",1,$NF)))
							else fileListDest[i]=sprintf("%s%s",arg2,gensub(arg1,"",1,$NF))
							#rename files in /c/3gsim/stats from 2013-06-01_16:15:00_statistics.xml.gz to A20130601.1615-1615.xml.gz
							if (filter==pmfilter && pmdatapath ~ /^\/[cdrp]/ && fileListDest[i] ~ /^\/.+\/[12][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]_[0-9][0-9]:[0-9][0-9]:[0-9][0-9]_statistics.xml.gz$/)
							{
								lfDir=gensub(/\/[^/]+$/,"",1,fileListDest[i])
								split(gensub(/^.*\//,"",1,fileListDest[i]),lfArray,/[-_:]/)
								fileListDest[i]=lfDir"/A"lfArray[1] lfArray[2] lfArray[3] "." lfArray[4] lfArray[5] "-" lfArray[4] lfArray[5] ".xml.gz"
								#print filter,pmfilter,pmdatapath,fileListDest[i]
							}

							filePrintout[i]=$0
						}
					}
				}
			}
		}
		close(tempgalog)
		if (what ~ /^get/)
		{
			if (comcli>0 && i>0 && (fileListSrc[1]~"/c/logfiles/troubleshooting/exception/logs/.*_exception_.*.bin.gz" || fileListSrc[1]~"/rcs/dumps/pmd/[0-9]+_pmd-"))
			{
				thedest=gensub(/[^/]+$/,"",1,fileListDest[1])
				theusername=moshellUSER
				thepassword="secret"
				theserver=ws_ip
				tlgdir=thedest
				if (export_method>=1)
				{
					find_amos_export_login()
					theserverport=convert_export_method()
					theusername=export_username
					theserver=ws_ip
					if (export_password=="") export_password=get_sls_password(export_username)
					if (export_password!="") thepassword=export_password
					else return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
					if (export_method==2)
					{
						if ((export_server=="") || (export_server==ws_ip && smart_export>0)) export_method=1
						else
						{
							theserver=export_server
							loclgdir=tlgdir
							gsub(/[/]+$/,"",export_dir)
							tlgdir="lg_" strftime("%Y%m%d_%H%M%S",systime())"_"gawk_pid
							if (export_dir!="") tlgdir=export_dir "/" tlgdir
							thepwfile=tempdir"/export_pw"
							make_sshzfile(thepwfile,export_password)
							customPrint("")
							if (use_keyboard_interactive!=1) auth_method=auth_method",keyboard-interactive"
							if (ftpclient(export_server,export_password,"mkdir "tlgdir,"","",export_username,theserverport,thepwfile)!=0)
							{
								#if the first attempt fails we try with a weaker cipher to see if the export server can handle it
								ciphers="-o Ciphers=aes128-ctr"
								#if (use_keyboard_interactive!=1) auth_method=auth_method",keyboard-interactive"
								if (ftpclient(export_server,export_password,"mkdir "tlgdir,"","",export_username,theserverport,thepwfile,"",ciphers)!=0)
								{
									customPrint("ERROR: unable to create temp directory on export server.")
									if (use_keyboard_interactive!=1) sub(",keyboard-interactive","",auth_method)
									return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
								}
							}
							else if (export_dir=="")
							{
								tlgdir=sftpCurrentWorkingDirectory"/"tlgdir
							}
						}
					}
				}
				if (tlgdir !~ /^\//) sep="/"
				if (start_sshd("",theserverport)==1)
				{
					customPrint("ERROR: unable to start sshd")
					return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
				}

				if (is_ip_addr(theserver)==2 && theserver!~/^\[.*\]$/) theserver="["theserver"]"

				#exportParams=sprintf("%s%s%s%s%s",theserver,SUBSEP,theusername,SUBSEP,thepassword)
				#split(exportParams,arr,SUBSEP)
				sfile_list=""
				if (tlgdir !~ /[/]$/) tlgdir=tlgdir"/"   #the exportexcep command does not work if there is not a slash at the end of the path
				#thedest=gensub(/[^/]+$/,"",1,fileListDest[1])
				#tempdest=tempdir"/pmefrgen2/"
				for (j=1;j<=i;j++)
				{
					if (fileListSrc[j] ~ "/rcs/dumps/pmd/[0-9]+_pmd-") sfile_list=sfile_list" "gensub(/^\/rcs\/dumps\/pmd\/|_pmd-.*$/,"","g",fileListSrc[j])
					else sfile_list=sfile_list" "gensub(/^.*\//,"",1,fileListSrc[j])
					if (j%20!=0) continue
					#system("rm -rf "tempdest)
					#fileOps("mkdir -p "tempdest)
					#chmodDir(00777,tempdest)
					#$0="lh mp exportexcep sftp://"arr[2]"@"arr[1] tempdest " "arr[3] sfile_list
					if (fileListSrc[1] ~ "/rcs/dumps/pmd/[0-9]+_pmd-") theexportcommand="exportdump export" ; else theexportcommand="exportexcep"
					$0=sprintf("lh mp %s sftp://%s@%s:%d%s%s %s %s",theexportcommand,theusername,theserver,sshdport,sep,tlgdir,thepassword,sfile_list)
					lh()
					#run_system("cp "tempdest"* "thedest)
					sfile_list=""
				}
				if (sfile_list!="")
				{
					#system("rm -rf "tempdest)
					#fileOps("mkdir -p "tempdest)
					#chmodDir(00777,tempdest)
					#$0="lh mp exportexcep sftp://"arr[2]"@"arr[1] tempdest " "arr[3] sfile_list
					if (fileListSrc[1] ~ "/rcs/dumps/pmd/[0-9]+_pmd-") theexportcommand="exportdump export" ; else theexportcommand="exportexcep"
					$0=sprintf("lh mp %s sftp://%s@%s:%d%s%s %s %s",theexportcommand,theusername,theserver,sshdport,sep,tlgdir,thepassword,sfile_list)
					lh()
					#run_system("cp "tempdest"* "thedest)
				}

				stop_sshd("print")
				if (export_method==2)
				{
					delete commandList
					commandList[1]="get "tlgdir"/* "loclgdir
					commandList[2]="rm "tlgdir"/*"
					commandList[3]="rmdir "tlgdir
					customPrint("")
					ftpclient(export_server,export_password,"",commandList,"",export_username,theserverport,thepwfile,"nostop",ciphers)
					tlgdir=loclgdir
					if (use_keyboard_interactive!=1) sub(",keyboard-interactive","",auth_method)
				}
				customPrint("")
				decrypt_pmd(tlgdir)
				return 0
			}
			for (j=1;j<=i;j++)
			{
				commandList[j]=sprintf("get %s %s",fileListSrc[j],fileListDest[j])
				if (filter == pmfilter && pmlsfile != "") print filePrintout[j] >> pmlsfile
				else if (filter == uefilter && uelsfile != "") print filePrintout[j] >> uelsfile
				else if (filter == ctfilter && ctlsfile != "") print filePrintout[j] >> ctlsfile
				else if (filter == gpfilter && gplsfile != "") print filePrintout[j] >> gplsfile
				#if (mosdebug==1) print j,commandList[j]
			}
			close(pmlsfile) ; close(uelsfile) ; close(ctlsfile) ; close(gplsfile)
			return ftpclient(node_address,node_password,"",commandList)
		}
		else if (what ~ /^del/)
		{
			y=asort(dirListSrc)
			for (j=1;j<=i;j++) commandList[j]=sprintf("dele %s",fileListSrc[j])
			for (j=i+1;j<=(i+y);j++) commandList[j]=sprintf("rmdir %s",dirListSrc[i+1+y-j])
			#after the last loop j got incremented by 1 so we put it at the final value of i (number of files) + y (number of directories)
			j=i+y
			if (what ~ /^dela/ && theDirSrc!="") { commandList[++j]=sprintf("rmdir %s",theDirSrc) ; y++ }
			if (what == "delf") answer="y"
			else
			{
				customPrint(sprintf("\n\
==================================================================================="))
				for (k=1;k<=j;k++) customPrint(commandList[k])
				customPrint(sprintf("\
==================================================================================="))
				#customPrint(sprintf("Remove "i+0" files and "y+0" directories. Are you Sure [y/n] ? "),"","","noLF")
				answer=Read_Answer(reading_script,"","","","","yesno",sprintf("Remove "i+0" files and "y+0" directories. Are you Sure [y/n] ? "))
			}
			if (tolower(answer) ~ /^y+(es)?$/) return ftpclient(node_address,node_password,"",commandList)
			else add_to_moscomlog("","%@> Fail (Command aborted)")
		}
	}
	else if (what ~ /^put/)
	{
		if (arg2 == "") arg2=sprintf("%s/%s",CurrentDir,gensub(/^.*\//,"","g",arg1))
		else if (arg2 !~ sprintf("%s/*$",gensub(/^.*\//,"","g",arg1))) arg2=sprintf("%s/%s",arg2,gensub(/^.*\//,"","g",arg1))
		if (nomakeroot==1) sub(/\/[^/]+$/,"",arg2)
		if (checkIfDir("ose",arg2) != 0)
		{
			if (checkIfDir("ose",arg2,"file")==0)
			{
				customPrint(sprintf("Error: %s is not a valid directory, a file already exists with the same name"))
				return 1
			}
			if (ftpclient(node_address,node_password,"mkdir "arg2) != 0)
			{
				customPrint(sprintf("Error: %s is not a valid directory",arg2))
				return 1
			}
		}

		#print "arg1: " arg1 ", arg2: " arg2

		#Check the list of existing subdirectories under arg2
		mo_log(tempgalog,"open","mute","overwrite","silent")
		muteFactor=800
		ftree(arg2)
		mo_log(tempgalog,"close")
		while (getline < tempgalog)
		{
			gsub("\r","") ; gsub("\x000","")
			if (/^d/)
			{
				gsub(/\/$/,"",$NF); #remove final slash from ftree output
				existingDirList[$NF]=1
			}
			else if (/^-r/) existingFileList[$NF]=1
		}
		close(tempgalog);

                #handle the case in Solaris where it does not display the directory when you do a ls -lR
                localdir=arg1
                destdir=arg2

                ls_session=sprintf("ls -lRa %s",arg1)

		while (ls_session |& getline)
	        {
			#/home/eanzmagn/license/:
			#total 176
			#drwxrwxrwx   2 eanzmagn rnd         4096 Mar 29 11:50 .
			#drwxr-xr-x 165 eanzmagn user       49152 May  7 09:11 ..
			#-rw-rw-rw-   1 eanzmagn rnd         4342 Apr 26 21:45 .licensekeys.xml
			#-rw-rw-rw-   1 eanzmagn rnd           36 Apr 26 21:45 .parameters_01.lic
			#-rw-rw-rw-   1 eanzmagn rnd        15458 Mar 15 08:48 T821137428_071113_142023.xml
			#-rw-rw-rw-   1 eanzmagn rnd         4342 Apr 26 21:45 licensekeys.xml
			gsub("\r",""); gsub("\x000","")
			if ($1 ~ /^d/ || $NF == "." || $NF == "..") continue
			if (/:$/) #it's a directory
			{
				gsub(/:$/,"")
				localdir=$1
				destdir=gensub(arg1,arg2,1,$1)
				if (existingDirList[destdir] != 1 && destdir != arg2) commandList[++i]=sprintf("mkdir %s",destdir)
			}
			else if (/^-r/)
			{
				#if ($NF !~ filter) continue
				if ((negfilter==0 && $NF ~ filter)||(negfilter==1 && $NF !~ filter))
				{
					localfile=sprintf("%s/%s",localdir,$NF)
					destfile=sprintf("%s/%s",destdir,$NF)
					if (!(what ~ /^putc/ && existingFileList[destfile]==1)) #conditional download
					{
						commandList[++i]=sprintf("put %s %s",localfile,destfile)
					}
				}
			}
		}
		close(ls_session)
		#for (j=1;j<=i;j++) print j,commandList[j]

		return ftpclient(node_address,node_password,"",commandList)
	}
}
function decrypt_pmd(thedir,    nr_of_files,i,fileList,llogTable,tpmd,tlf)
{
	delete llogTable
	sub(/[/]$/,"",thedir)
	llogTableOk=0 #global var
	tlf=tempdir"/llog"
	nr_of_files=fileOps("ls "thedir,fileList)
	for (i=1;i<=nr_of_files;i++)
	{
		if (fileList[i] ~ /\.tgz\.gpg$/)
		{
			if (llogTableOk==0) make_llog_table(llogTable)
			tpmd=gensub(/\.tgz\.gpg$/,"",1,fileList[i])
			#print i,thedir,fileList[i],tpmd
			if (llogTable[tpmd]!="")
			{
				close(tlf)
				print llogTable[tpmd] > tlf
				close(tlf)
				run_system(sprintf("zip -mjT %s/%s.zip %s %s/%s",thedir,tpmd,tlf,thedir,fileList[i]))
			}
		}
	}

}
function make_llog_table(llogTable, currpmd,currline)
{
	delete llogTable
	mo_log(temppmdgpglog,"open","mute","overwrite","silent")
	run_rcscoli_cmd("/diagm/llog -l")
	mo_log(temppmdgpglog,"close")
	while (getline < temppmdgpglog)
	{
		#No:       146
		#Reason:   Program Crash
		#Time:     2016-10-16 11:12:58
		#Program:  /home/sirpa/software/LRAT-RACOAM-ARM_CXP9029582_26_R11CN/lratMonitorArmLm/bin/lratMonitorArmLm
		#Pid:      10213
		#Rank:     -
		#Signal:   SIGSEGV
		#PMD:      pmd-LmMonitorPT-10213-20161016-111258
		#Extra:    -
		gsub("\r","");gsub("\x000","")
		if ($1=="PMD:") currpmd=$2
		if ($1=="No:")
		{
			llogTableOk=1
			if (currpmd ~ "pmd") llogTable[currpmd]=currline
			currline=" Start "
		}
		else if ($1~/^[A-Z][^:]+:$/) currline=currline" $ "gensub(/^[ \t]*[^ \t:]+:[ \t]+|[ \t]+/,"",1,$0)
	}
	close(temppmdgpglog)
	if (currpmd~"pmd") llogTable[currpmd]=currline
	#for (i in llogTable) print i,llogTable[i]
}

function checkIfDir(platform,string,file,   telnet_session,result,f,checkDone,a)
{
	#to check if a directory is on the file system or not
	#if the "file" parameter is set, it will check if a file is on the file system (instead of a directory)
	if (platform=="ose")
	{
		result=1
		if (string in knownDirectoryList && knownDirectoryList[string]==1) return 0
		if (comcli==0 && string~/^\/(c|d|[rp][0-9][^/]+)[/]?$/) return 0
		if (comcli>0 && string~/^\/(rop|pm_data)$/) return 0  #on RBS G2 the /rop folder does not contain "." and ".."
		if (comcli>0 && (string=="/rcs/dumps/pmd" || string=="/c/logfiles/troubleshooting/exception/logs")) return 0  #special handling for this folder on Gen2
		if (comcli>0 && mom_version~/^(IPWORKS|COM_NODE_MODEL)/ && string~/[/]PerformanceManagementReportFiles[/]?$/) return 0 #same as above, on IPWORKS and HSS
		#if (mosdebug==1) print "DEBUG: checkIfDir "string
		if ((comcli>0 && linux_shell==0 && comcli_port==secure_port)||(comcli>0 && mom_version ~ /PRBS_NODE_MODEL/))
		{
			#there is no linux shell and no coli shell, so we run the ls -l command in sftp
			#we use this methode always on PICO because even when there is linux shell in pico, the other method via shell does not work with soft links
			mo_log(tempdirlog,"open","mute","overwrite","silent")
			#comcli_cmd("bash -c \"ls -ld "string"\"")
			muteFactor=10000
			ftpclient(node_address,node_password,"ls -an "string,"","silent")
			mo_log(tempdirlog,"close","","silent")
			customPrint("")
			while (getline < tempdirlog)
			{
				gsub("\r","") ; gsub("\x000","")
				remove_colors()
				if (mosdebug==1) print "DEBUG: "$0
				#only look at the first line
				#if directory:
				#drwxrwx---    2 0     0      160 Jun 28 17:16 /var/persistent/.
				#if file:
				#-rw-rw----    0 0        20030         768 Jun 28 19:16 /var/persistent/log/oss/diag2/log/wtmp
				#Note : on netsim pico, the directory lines with "." and ".." are not there, therefore we are counting the number of files and return a directory if there is more than one file found
				sub(/^\/.*\//,"",$NF)
				if ($1!~/^.r......./) continue  #continue until we find a line that starts with file permissions
				if ($1~/^dr......./ && $NF == "." && file=="")
				{
					result=0
					checkDone=1
					if (mom_version ~ /PRBS_NODE_MODEL/) knownDirectoryList[string]=1  #on pico avoid to keep checking if something is a directory because it can result in SFTP login failed when doing many consecutive SFTP sessions
				}
				else if ($1 ~ /^-r/) f++   #the number of files found
			}
			close(tempdirlog)
			if (checkDone!=1)
			{
				if ((f>1 && file=="")||(f==1 && file!="")) result=0
			}
		}
		else
		{
			telnet_session=enter_telnet_login(node_address,node_password)
			if (telnet_session ~ /Unable to connect|Wrong Password/)
			{
				customPrint(telnet_session)
				return 999
			}
			#on some COM nodes there is a line like "total 12" when doing ls -l on a directory but on other COM nodes like pico this line is not there
			if (cpplinux==1 && string ~ /^[0-9]+00!/)
			{
				split(string,a,"!")
				print "lhsh "a[1]" ls -ld "a[2]"\nexit" |& telnet_session
			}
			else if (comcli>0 || cpplinux==1) print "ls -ld "string"\nexit" |& telnet_session
			else print "ls -l "string"\nexit" |& telnet_session
			while (telnet_session |& getline)
			{
				gsub("\r","") ; gsub("\x000","")
				if (comcli>0) remove_colors()
				#comcli
				#total 12
				#drwxr-xr-x    2 root     root          2080 May 12 01:04 /var/volatile/log/PerformanceManagementReportFiles
				#-rw-r--r--    1 root     root           886 May 12 01:04 /var/volatile/log/PerformanceManagementReportFiles/A20360512.0045+0000-0100+0000_1.xml
				if (/Directory \x027/ || ((comcli>0 || cpplinux==1) && /^(total [0-9]+$|dr........[ \t])/))
				{
					#if looking for a directory return 0 else if looking for file return 1
					if (file=="")
					{
						result=0
						if (string in unknownDirectoryList) knownDirectoryList[string]=1
					}
					break
				}
				else if (/-r/ && file!= "")
				{
					result=0
					break
				}
			}
			close(telnet_session)
		}
	}
	else
	{
		if (file=="") result=fileOps("test -d "string)
		else result=fileOps("test -f "string)
	}
	if (mosdebug==1) print "DEBUG: checkIfDir "string" -> "result
	return result
}
function define_temp_files(   long_pid)
{
	long_pid=gawk_pid strftime("%Y%m%d%H%M%S",systime())
	fcleandir          = sprintf("%s/fclean",               logdir)
	tempenbxmldir      = sprintf("%s/enbxml",               tempdir)
	tempfcleanlog	   = sprintf("%s/fcleanLog%s",		tempdir,gawk_pid)
	temp_cvrm_file	   = sprintf("%s/cvrm%s",		tempdir,gawk_pid)
	tempa_tlog	   = sprintf("%s/audit_trailLog%s.xml",	tempdir,gawk_pid)
	tempanrlog	   = sprintf("%s/anrLog%s.xml",	        tempdir,gawk_pid)
	tempalliplog       = sprintf("%s/al.tmp",               tempdir)
	tempscannerlog     = sprintf("%s/pmScannerLog%s",       tempdir,gawk_pid)
	temppmxilog        = sprintf("%s/pmxiLog%s",            tempdir,gawk_pid)
	temppmxglog        = sprintf("%s/pmxgLog%s",            tempdir,gawk_pid)
	tempjvmgclog       = sprintf("%s/jvmgcLog%s",           tempdir,gawk_pid)
	tempmoalarmlog	   = sprintf("%s/moalarmLog%s",	        tempdir,gawk_pid)
	tempallog	   = sprintf("%s/alarmLog%s.xml",	tempdir,gawk_pid)
	tempatrlog	   = sprintf("%s/audittrailLog%s.xml",	tempdir,gawk_pid)
	tempavlog	   = sprintf("%s/availabilityLog%s.xml",tempdir,gawk_pid)
	temptelog	   = sprintf("%s/teread%s.log",         tempdir,gawk_pid)
	templloglog	   = sprintf("%s/llog%s.log",           tempdir,gawk_pid)
	temppmdzpmlog	   = sprintf("%s/pmdzpm%s.log",         tempdir,gawk_pid)
	temprupmdlog	   = sprintf("%s/rupmd%s.log",          tempdir,gawk_pid)
	temprucmdfile      = sprintf("%s/rucmd%s.cmd",          tempdir,gawk_pid)
	tempbplog          = sprintf("%s/bp%s.log",             tempdir,gawk_pid)
	templslog          = sprintf("%s/ls%s.log",             tempdir,gawk_pid)
	tempbolog	   = sprintf("%s/boLog%s",		tempdir,gawk_pid)
	temproamlog        = sprintf("%s/roamLog%s",            tempdir,gawk_pid)
	tempsqlattrlog	   = sprintf("%s/sqlattrLog%s",		tempdir,gawk_pid)
	tempsqlmaolog	   = sprintf("%s/sqlmaoLog%s",		tempdir,gawk_pid)
	tempsqlfrolog	   = sprintf("%s/sqlfroLog%s",		tempdir,gawk_pid)
	tempsqlcsvlog      = sprintf("%s/sqlcsvLog%s.dat",      tempdir,gawk_pid)
	tempsqlargfile     = sprintf("%s/sqlargFile%s",         tempdir,gawk_pid)
	tempresublog	   = sprintf("%s/resubLog%s",		tempdir,gawk_pid)
	tempresub2log	   = sprintf("%s/resub2Log%s",		tempdir,gawk_pid)
	tempcomlog	   = sprintf("%s/commandLog%s.cmd",	tempdir,gawk_pid)
	tempevlog	   = sprintf("%s/eventLog%s.xml",	tempdir,gawk_pid)
	tempipclog	   = sprintf("%s/iptranLog%s.xml",	tempdir,gawk_pid)
	tempipdlog	   = sprintf("%s/iptranDebugLog%s.xml",	tempdir,gawk_pid)
	tempmoslog	   = sprintf("%s/mosLog%s.log",	        tempdir,gawk_pid)
	temprliblog        = sprintf("%s/rlibLog%s.xml",	tempdir,gawk_pid)
	tempfcleancmd	   = sprintf("%s/fcleanCmd%s",		tempdir,long_pid)
	tempdbd1log	   = sprintf("%s/dbd1Log%s",		tempdir,gawk_pid)
	tempdbd2log	   = sprintf("%s/dbd2Log%s",		tempdir,gawk_pid)
	tempmomlog	   = sprintf("%s/momLog%s",		tempdir,gawk_pid)
	tempshowmiblog     = sprintf("%s/showmibLog%s",		tempdir,gawk_pid)
	tempgalog	   = sprintf("%s/gaLog%s",		tempdir,gawk_pid)
	temppcrxml         = sprintf("%s/pcrNetconf%s",         tempdir,gawk_pid)
	tempexexlog	   = sprintf("%s/exexLog%s",		tempdir,gawk_pid)
	tempmxlpmomlog	   = sprintf("%s/pmxlpmomLog%s",	tempdir,gawk_pid)
	tempfalog          = sprintf("%s/faLog%s",		tempdir,gawk_pid)
	tempdalog          = sprintf("%s/daLog%s",		tempdir,gawk_pid)
	temprbscmdslog	   = sprintf("%s/rbsCmdsLog%s",		tempdir,gawk_pid)
	tempcomclicmdslog  = sprintf("%s/comcliCmdsLog%s",      tempdir,gawk_pid)
	tempirtlog	   = sprintf("%s/irtLog%s",		tempdir,gawk_pid)
	tempirtcmd	   = sprintf("%s/irtCmd%s",		tempdir,gawk_pid)
	tempintmomlog	   = sprintf("%s/intmomLog%s",		tempdir,gawk_pid)
	tempintmomlog2	   = sprintf("%s/intmomLog2%s",		tempdir,gawk_pid)
	tempintmomlog3	   = sprintf("%s/intmomLog3%s",		tempdir,gawk_pid)
	temptnlog	   = sprintf("%s/tnpLog%s",		tempdir,gawk_pid)
	temprftlog	   = sprintf("%s/rftLog%s",		tempdir,gawk_pid)
	tempcrtlog	   = sprintf("%s/crtLog%s",		tempdir,gawk_pid)
	tempvswrlog	   = sprintf("%s/vswrLog%s",		tempdir,gawk_pid)
	tempdrhlog	   = sprintf("%s/drhLog%s",		tempdir,gawk_pid)
	tempcpplog	   = sprintf("%s/cppLog%s",		tempdir,gawk_pid)
	temprbslog	   = sprintf("%s/rbsLog%s",		tempdir,gawk_pid)
	templhlistlog	   = sprintf("%s/lhlistLog%s",		tempdir,gawk_pid)
	temppmdgpglog	   = sprintf("%s/pmdgpgLog%s",		tempdir,gawk_pid)
	tempxmulog	   = sprintf("%s/xmuLog%s",		tempdir,gawk_pid)
	temprnclog	   = sprintf("%s/rncLog%s",		tempdir,gawk_pid)
	tempstslog	   = sprintf("%s/stsLog%s",		tempdir,gawk_pid)
	tempstsrlog	   = sprintf("%s/stsrLog%s",		tempdir,gawk_pid)
	tempstclog	   = sprintf("%s/stcLog%s",		tempdir,gawk_pid)
	templkvlog	   = sprintf("%s/lkvLog%s",		tempdir,gawk_pid)
	tempupdlog	   = sprintf("%s/updLog%s",		tempdir,gawk_pid)
	tempstvlog	   = sprintf("%s/stvLog%s",		tempdir,gawk_pid)
	tempstvblog	   = sprintf("%s/stvbLog%s",		tempdir,gawk_pid)
	tempinvglog	   = sprintf("%s/invgLog%s",		tempdir,gawk_pid)
	tempstelog	   = sprintf("%s/steLog%s",		tempdir,gawk_pid)
	tempsteglog	   = sprintf("%s/stegLog%s",		tempdir,gawk_pid)
	tempsterlog	   = sprintf("%s/sterLog%s",		tempdir,gawk_pid)
	templkrlog	   = sprintf("%s/lkrLog%s",		tempdir,gawk_pid)
	templkralog	   = sprintf("%s/lkraLog%s",		tempdir,gawk_pid)
	tempsttlog	   = sprintf("%s/sttLog%s",		tempdir,gawk_pid)
	tempstilog	   = sprintf("%s/stiLog%s",		tempdir,gawk_pid)
	tempstiflog	   = sprintf("%s/stifLog%s",		tempdir,gawk_pid)
	tempstioflog	   = sprintf("%s/stiofLog%s",		tempdir,gawk_pid)
	tempstifplog	   = sprintf("%s/stifpLog%s",		tempdir,gawk_pid)
	tempstimlog	   = sprintf("%s/stimLog%s",		tempdir,gawk_pid)
	tempstiulog	   = sprintf("%s/stiuLog%s",		tempdir,gawk_pid)
	tempetelog	   = sprintf("%s/eteLog%s",		tempdir,gawk_pid)
	temphwlog	   = sprintf("%s/hiliLog%s.xml",	tempdir,gawk_pid)
	tempifcmd	   = sprintf("%s/ifCmd%s",		tempdir,gawk_pid)
	tempinvlog	   = sprintf("%s/invLog%s",		tempdir,gawk_pid)
	tempinvllog	   = sprintf("%s/invlLog%s",		tempdir,gawk_pid)
	tempinvswlog	   = sprintf("%s/invswLog%s",		tempdir,gawk_pid)
	tempinvtemplog	   = sprintf("%s/invTempLog%s",		tempdir,gawk_pid)
	tempinvrflog	   = sprintf("%s/invRfLog%s",		tempdir,gawk_pid)
	tempinvpglog	   = sprintf("%s/invpgLog%s",		tempdir,gawk_pid)
	tempstdlog	   = sprintf("%s/stdLog%s",		tempdir,gawk_pid)
	temphgetlog        = sprintf("%s/hgetLog%s",            tempdir,gawk_pid)
	temphgetmlog       = sprintf("%s/hgetmLog%s",           tempdir,gawk_pid)
	tempsshzfile       = sprintf("%s/sshz%s",		tempdir,gawk_pid)
	tempmibcmd	   = sprintf("%s/mibCmd%s",		tempdir,long_pid)
	templhcmd	   = sprintf("%s/lhCmd%s",		tempdir,long_pid)
	templhlog	   = sprintf("%s/lhLog%s_0.gz",		tempdir,long_pid)
	templhshcmd	   = sprintf("%s/lhshCmd%s",		tempdir,long_pid)
	tempcabhw	   = sprintf("%s/cabHwInfoFile",	tempdir)
	temppgcmd          = sprintf("%s/pgCmd%s",		tempdir,long_pid)
	tempcedhcmd        = sprintf("%s/cedhCmd%s",		tempdir,long_pid)
	tempcedhgz         = sprintf("%s/cedhLog%s_0.gz",       tempdir,long_pid)
	tempftecmd         = sprintf("%s/fteCmd%s",		tempdir,long_pid)
	temploopcmd	   = sprintf("%s/loopCmd%s",		tempdir,gawk_pid)
	tempmergelog	   = sprintf("%s/mergeLog%s",		tempdir,gawk_pid)
	tempmonodecmd	   = sprintf("%s/monodeCmd%s",		tempdir,gawk_pid)
	temppmrbuffer	   = sprintf("%s/pmrbuffer%s",		tempdir,gawk_pid)
	temppmrpipe	   = sprintf("%s/pmrpipe%s",		tempdir,gawk_pid)
	tempseclog	   = sprintf("%s/securityLog%s.xml",	tempdir,gawk_pid)
	tempstrlog	   = sprintf("%s/strLog%s",		tempdir,gawk_pid)
	tempcedlog	   = sprintf("%s/cedLog%s",		tempdir,gawk_pid)
	tempcedflog	   = sprintf("%s/cedfLog%s",		tempdir,gawk_pid)
	tempcedhlog	   = sprintf("%s/cedhLog%s",		tempdir,gawk_pid)
	tempcedmlog	   = sprintf("%s/cedmLog%s",		tempdir,gawk_pid)
	tempsyslog	   = sprintf("%s/sysLog%s",		tempdir,gawk_pid)
	temptedlog         = sprintf("%s/tedLog%s",		tempdir,gawk_pid)
	tempipcslog        = sprintf("%s/ipcsLog%s",		tempdir,gawk_pid)
	tempbgflog         = sprintf("%s/bgfLog%s",		tempdir,gawk_pid)
	temptgcmd1	   = sprintf("%s/tgCmd1%s",		tempdir,gawk_pid)
	temptgcmd	   = sprintf("%s/tgCmd%s",		tempdir,gawk_pid)
	temptglog	   = sprintf("%s/tgLog%s",		tempdir,gawk_pid)
	tempuerlog	   = sprintf("%s/uerLog%s",		tempdir,long_pid)
	tempupglog	   = sprintf("%s/upgLog%s.log",		tempdir,gawk_pid)
	tempbgpidlog       = sprintf("%s/bgpid%s.log",		tempdir,gawk_pid)
	tempnohuplog       = sprintf("%s/nohup%s.log",		tempdir,gawk_pid)
	temppcrlog         = sprintf("%s/pcrLog%s.log",         tempdir,gawk_pid)
	temppgetsnlog      = sprintf("%s/pgetsnLog%s.log",      tempdir,gawk_pid)
	tempbdtypes        = sprintf("%s/bdTypes%s.awk",        tempdir,gawk_pid)
	tempcptlog         = sprintf("%s/cptlog%s.log",         tempdir,gawk_pid)
	readline	   = sprintf("%s/readline%s",		tempdir,gawk_pid)
	command_buffer	   = sprintf("%s/cmdbuffer%s",		tempdir,gawk_pid)
	readanswer	   = sprintf("%s/readanswer%s",		tempdir,gawk_pid)
	readsilent	   = sprintf("%s/readsilent%s",		tempdir,gawk_pid)
	readprompt         = sprintf("%s/readprompt%s",         tempdir,gawk_pid)
	readpromptsilent   = sprintf("%s/readpromptsilent%s",   tempdir,gawk_pid)
	inputrc		   = sprintf("%s/inputrc%s",		tempdir,gawk_pid)
	tempiubcellmodfile = sprintf("%s/iubcellmodfile%s",	tempdir,gawk_pid)
	tempulmapfile      = sprintf("%s/ulmapfile%s",	        tempdir,gawk_pid)
	tempsqlcmd         = sprintf("%s/sqlcmd%s.sql",         tempdir,long_pid)
	tempsqltablenames  = sprintf("%s/sqltablenames%s",      tempdir,gawk_pid)
	tempsqlmotypetable = sprintf("%s/sqlmotypetable%s",     tempdir,gawk_pid)
	tempsqlmodatarev   = sprintf("%s/sqlmodatarev%s",       tempdir,gawk_pid)
	tempsqliubdatastr  = sprintf("%s/sqliubdatastr%s",      tempdir,gawk_pid)
	tempxblogdir       = sprintf("%s/xblogs%s",             tempdir,gawk_pid)
	tempknownhostfile  = sprintf("%s/knownhost%s",		tempdir,gawk_pid)
	tempdirlog	   = sprintf("%s/dirLog%s",		tempdir,gawk_pid)
	tempftreelog	   = sprintf("%s/ftreeLog%s",		tempdir,gawk_pid)
	tempdatelog	   = sprintf("%s/dateLog%s",		tempdir,gawk_pid)
	tempcoliawk        = sprintf("%s/colidb%s.awk",         tempdir,gawk_pid)
	tempmoscolibuffer  = sprintf("%s/moscolibuffer%s",      tempdir,gawk_pid)
	tempvardumpfile    = sprintf("%s/vardumpfile%s",        tempdir,gawk_pid)
	templklog          = sprintf("%s/lkLog%s",              tempdir,gawk_pid)
	tempcomclicmdlog   = sprintf("%s/comcliLog%s",          tempdir,gawk_pid)
	tempmglog          = sprintf("%s/mgLog%s",              tempdir,gawk_pid)
	tempmglog2         = sprintf("%s/mgLog2%s",             tempdir,gawk_pid)
	tempirplog	   = sprintf("%s/irpLog%s",		tempdir,gawk_pid)
	tempirslog	   = sprintf("%s/irsLog%s",		tempdir,gawk_pid)
	tempirslog1	   = sprintf("%s/irs1Log%s",		tempdir,gawk_pid)
	tempirslog2	   = sprintf("%s/irs2Log%s",		tempdir,gawk_pid)
	tempirslist1	   = sprintf("%s/irs1List%s",		tempdir,gawk_pid)
	tempirslist2	   = sprintf("%s/irs2List%s",		tempdir,gawk_pid)
	tempmtlog	   = sprintf("%s/mtlog%s",		tempdir,gawk_pid)
	tempetlog	   = sprintf("%s/etlog%s",		tempdir,gawk_pid)
	tempcvcllog	   = sprintf("%s/cvcllog%s",		tempdir,gawk_pid)
	tempcvcl2log	   = sprintf("%s/cvcl2log%s",		tempdir,gawk_pid)
	templtclog	   = sprintf("%s/ltclog%s",		tempdir,gawk_pid)
	templtmoclog	   = sprintf("%s/ltmoclog%s",		tempdir,gawk_pid)
	tempfrulog	   = sprintf("%s/frulog%s",		tempdir,gawk_pid)
	tempmd5file        = sprintf("%s/md5file%s",		tempdir,gawk_pid)
	tempshowallfile    = sprintf("%s/showall%s",		tempdir,gawk_pid)
	templttnglog       = sprintf("%s/lttngLog%s",		tempdir,gawk_pid)
	templgfacclog      = sprintf("%s/lgfaccLog%s",		tempdir,gawk_pid)
	tempshowmocvarlog  = sprintf("%s/showmocvarLog%s",      tempdir,gawk_pid)
	tempnetconfcmd     = sprintf("%s/netconfCmd%s",		tempdir,gawk_pid)
	tempnetconflog     = sprintf("%s/netconfLog%s",		tempdir,gawk_pid)
	templastmoshellcmd = sprintf("%s/lgnlastcmd",           tempdir)
	templgnvarfile     = sprintf("%s/lgnvarfile",           tempdir)
	tempuerfile        = sprintf("/d/usr/uer%s",            long_pid)
	#this will produce the line: Failed to add the host to the list of known hosts, which is used to know that the login was successful
	#if (comcli>0 && (node_login==0 || linux_shell==2)) tempknownhostfile="/xYz/Xyz/xyZ"   #known host is not used anymore
        empty_file(command_buffer)
}
function multi_error()
{
	customPrint("\nThis command is currently not supported in multi mode. Type \"h\" to print all available commands.")
	return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
}
function comcli_error(what,what2)
{
	if (what=="pmev" && what2!~/^(emom|set)$/) return
	if (what=="pm") customPrint("\nNo PmGroup or MeasurementType MOs found. PM commands are not supported on this COM node.")
	else if (what=="pmev") customPrint("\nNo EventGroup or EventType MOs found. Emom/pset commands are not supported on this COM node.")
	else if (what=="msrbs") customPrint("\nThis command is currently not supported on COM nodes, except MSRBSv2.")
	else if (what=="rcs") customPrint("\nThis command is currently not supported on COM nodes, except MSRBSv2 and TCU.")
	else if (what=="os")  customPrint("\nThis command is currently not supported on Solaris/sparc for this type of nodes. Please run on Linux, Cygwin, or Solaris/x86.")
	else if (what=="monoption")  customPrint("\nThis option is currently only supported for CPP nodes.")
	else if (what=="cyg") customPrint("\nThis command is only supported on Cygwin version 2.7 or higher. Please upgrade the cygwin version, make sure to include the optional package libglib2.0")
	else if (what=="esci")customPrint("\nThis command is only applicable for RCS nodes (MSRBSv2/TCU).")
	else if (what=="cppcommand") customPrint("\nThis command is only applicable for CPP nodes.")
	else if (what=="rbs") customPrint("\nThis command is only applicable for RBS/ERBS/MSRBS.")
	else customPrint("\nThis command is currently not supported on COM nodes. Type \"h\" to print all available commands.")
	return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
}
function dbdat_error()
{
	customPrint("\nThis command is currently not supported in SQL mode. Type \"h\" to print all available commands.")
	return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
}
function initialiseGlobalTables()
{
	delete dest

	delete extraMuteList
	delete oldMuteList
	delete oldExtraMuteList
	delete oldLogList
	#delete oldlogList
	delete old_get_printoutformatList
	delete oldMuteFactorList

	delete moGroup
	delete moGroupList

	delete unzipList
	delete mom_DirectMeChildren
	delete mib_eline
	delete mib_sline_proxy
	delete first_attribute_table

	delete bdGroupList
	delete bdGroup
	delete hubMpList
	delete ignorePortDev
	delete ignorePortDev2
	delete grpBoardList
	delete availableBoardList
	delete virtualBoardMap

	#sti
	delete IpInterfaceTable

	#dbdat mode
	delete MoType

	#help
	delete CommandName
	delete chap_desc
	delete chap_title
	delete command_desc
	delete menu_command_list
	delete short_command_desc

	#lm/up translation
	delete cppidTable
	delete formattedUpid
	delete formatted_uptorel
	delete lmidLookupTable
	delete lmidRevLookupTable
	delete lmidTable
	delete upidTable
	delete uptorelTable

	#kmom
	delete kmomKpiList
	delete kmomKpiArea
	delete kmomKpiAreaList
	delete kmomKpiDesc
	delete kmomLength
	delete kmomKpiUnit
	delete kmomKpiMos

	#other
	delete asyncTable
	delete SfpEricssonTable
	delete causeTable
	delete cellReselectionCntrMismatchTable
	delete cntrMismatchTable
	delete dbcLdnFieldAttrTable
	delete dbcLdnFieldMoTable
	delete deviceLnhTable
	delete froAttrTable
	delete froIdTable
	delete gsmRelHoAndCellReselCntrMismatchTable
	delete handoverOnlyCntrMismatchTable
	delete hwidLookupTable
	delete hwidTable
	delete mclTable
	delete moAttrTable
	delete mos2emTable
	delete motype_r1Table
	delete relMismatchTable
	delete resTable
	delete rev_motype_r1Table
	delete rncSBPiuModTable
	delete rset_customtable
	delete shellTable
	delete sqlCorruptedMAOTable
	delete sqlDuplicateFroTable
	delete sqlMapRealTable
	delete sqlMoRefTable
	delete sqlUnusedFroTable
	delete suspectedFroIdTable
	delete uer_uectxTable

	#pgets
	delete ScannerAttributes
	delete ScannerAttributesAlreadyTaken
	delete ScannerAttributesNumber
	delete ScannerEmpty
	delete ScannerFilterMax
	delete ScannerFilterName
	delete ScannerFilterValue
	delete ScannerMos
	delete ScannerName
	delete ScannerNrOfAttributes
	delete ScannerNrOfCounterInstances
	delete ScannerObsMax
	delete ScannerObsName
	delete ScannerObsNumber
	delete ScannerObsValue
	delete ScannerOutputMode
	delete ScannerPeriod
	delete ScannerProxy
	delete ScannerProxyList
	delete ScannerState
	delete ScannerTrigger

	#help
	delete SearchStringMenuList

	#multimode
	delete xmlmomlistTable
	delete MibPrefixTable

	#lg
	delete xmlLog

	#lki
	delete aal2IubList
	delete aal5IubList
	delete vpIubTable
	delete vp1IubTable
	delete vp2IubTable
	delete vc1IubTable
	delete vc2IubTable
	delete aal2RpuTable
	delete aal5ProcessorTable
	delete subrackAtmPortTable

	#customVar
	#delete customVarTableList
	#delete customVar
	#delete globalVar
	#delete systemVar
	#delete sortedVar

	clear_uer_tables()
	clear_license()
	clear_inv_tables()
	clear_rbs()
	clear_bo_tables()
	clear_internal_proxy_table()
	clear_eget_tables()
	clear_mom_tables()
	clear_sqlmap_tables()
	clear_offline_coli_tables()
	clear_rbs_comcli()
}
function reset_lg_files(val,negfilter,     a,i)
{
	split("al ev av sys upg llog ipc com a_t atr sec hw te pmd mos xb rlib ls bp anr ted ipcs bgf ipd",a," ")
	if (val==1)
	{
		for (i in a)
		{
			if (negfilter!="" && a[i]~negfilter) continue
			comLogFetched[a[i]]=1
		}
	}
	else if (val=="")
	{
		for (i in a) { logFetched[a[i]]=foundXmlLog[a[i]]=comLogFetched[a[i]]=0 }
	}
	#logFetched["al"]=logFetched["ev"]=logFetched["av"]=logFetched["sys"]=logFetched["upg"]=logFetched["llog"]=logFetched["ipc"]=0
	#logFetched["com"]=logFetched["a_t"]=logFetched["atr"]=logFetched["sec"]=logFetched["hw"]=logFetched["te"]=logFetched["pmd"]=0
	#logFetched["mos"]=logFetched["xb"]=logFetched["rlib"]=logFetched["ls"]=logFetched["bp"]=logFetched["anr"]=logFetched["ted"]=0
	#logFetched["ipcs"]=logFetched["bgf"]=0
	#foundXmlLog["av"]=foundXmlLog["ev"]=foundXmlLog["al"]=foundXmlLog["sys"]=foundXmlLog["upg"]=foundXmlLog["llog"]=foundXmlLog["ipc"]=0
	#foundXmlLog["com"]=foundXmlLog["a_t"]=foundXmlLog["atr"]=foundXmlLog["sec"]=foundXmlLog["hw"]=foundXmlLog["te"]=foundXmlLog["pmd"]=0
	#foundXmlLog["mos"]=foundXmlLog["xb"]=foundXmlLog["rlib"]=foundXmlLog["ls"]=foundXmlLog["bp"]=foundXmlLog["anr"]=foundXmlLog["ted"]=0
	#foundXmlLog["ipcs"]=foundXmlLog["bgf"]=0
}
function moscomlog_rotate(file,size,    oldfile)
{
	if (moscommandsize==0) return
	if ((fileOps("stat size "file)+0) > (size+0))
	{
		oldfile=file".old"
		customPrint("Moving and compressing "file" to "oldfile".gz")
		fileOps("mv "file" "oldfile)
		system("gzip -f "oldfile)
		chmod(00666,oldfile".gz")
	}
}
function InitialiseGlobalVariables(   array,i,tmpdir,fileList,n,tdirname,tfilename,tdate,oldmoscomlog,tf)
{
	#sql_client="/cygdrive/c/temp/sqlite/sqlite-3.5.1/sqlite3.exe test.db 2>&1"
	#print ".help" |& sql_client
	#while (sql_client |& getline) { if (/^.width NUM NUM/) break}
	initialiseGlobalTables()
	checkIpContactPort22Refused="unknown"
	sl3Status=0
	disabled_confirmation=0
	iRu=0
	reading_script+=0
	noninteractive+=0
	gawk_pid=PROCINFO["pid"]
	stopfile="/tmp/"gawk_pid
        if (http_port=="8080") CurrentDir="/host"  #running against SimCello
        else CurrentDir="/d"
        noPrintLogHeader=1
        max_dcgm_file_size=30000000   #if the dgm.log.gz is bigger than 30 MB then we cut out the rof_info_esig all printouts
        #is_netsim=0
        include_ber=0
        cpplinux=0

        if (auth_method=="") auth_method="password,keyboard-interactive"
        #used in the function mos2em
        mos2emInfo["cygwin_minversion"]="2.7.0"   #1.7.18 for everything except lttng/babeltrace that need 2.7.0
        mos2emInfo["ssh_version"]="OpenSSH_7.4p1, OpenSSL 1.0.2k  26 Jan 2017"
        mos2emInfo["gawk_version"]="GNU Awk 4.1.4, API: 1.1"
        #linux:
        mos2emInfo["lttng_version"]="2.9.3 (urcu 0.8.6, popt 1.16, libxml2 2.9.2, xz 5.2.1, libuuid 1.0.2)"
        mos2emInfo["babel_version"]="1.5.1 (glib2 2.25.13)"
        #cygwin
        mos2emInfo["lttng_version_cyg"]="2.9.4 (urcu 0.9.3, popt 1.16, libxml2 2.9.4, xz 5.2.2, libuuid 2.25.2)"
        mos2emInfo["babel_version_cyg"]="1.5.2 (glib2 2.46.2)"
        #solaris/x86:
        mos2emInfo["lttng_version_sol86"]="2.9.3 (urcu 0.9.3, popt 1.16, libxml2 2.9.3, xz 5.0.5, libuuid 1.0.2, libgcc 5.2.0, libglib2 2.41.1, libiconv2 1.14, liblzma5 5.0.5, libpcre 8.38, libz1 1.2.8)"
        mos2emInfo["babel_version_sol86"]="1.5.1 (glib2 2.41.1)"

	makeColiMap()
        supported_cache_version=146   #the version of the cached mom currently supported
        supported_pmcache_version=1   #the version of the cached PM mom (COM nodes) currently supported
        supported_eventcache_version=1   #the version of the cached EVENT mom (COM nodes) currently supported
        supported_momversioncache_version=9   #the version of the cached momversion used when comcli_momversion_cache=1
        dbCompare=0
        dbCompareProgsOnly=0
        closeMultiFiles=0
        comcli_use_showmoc=0
        getSpeed=100
        undoMode=0
       	makeScriptSummary=0
	summaryIndex=0
	oldLogIndex=0
	noPermissionToMe=0
	#is_3820=0
	maxCoreModule=0  #the maximum number of core processors in module MP
	axenode=""
	space_sign="@"
	indent="   "   #used by mos2mo function
	sqlOfflineError="In offline mode, the CV must be stored in the same folder or zipfile as the MO dump."
	term=ENVIRON["TERM"]
	moshellUSER=setUSER()
	trun1_transaction_timeout=3600
	if (get_printoutformat=="") get_printoutformat="noproxy"
	target_monitor_cpp51=sprintf("%s/CXC1326054_R51CG06",commonjardir)
	osacoli_cpp6=sprintf("%s/CXC1325608_R61BJ02",commonjardir)
	osacoli_cpp7=sprintf("%s/CXC1325608_R71Z35",commonjardir)
	helloCap="<capability>urn:ietf:params:netconf:base:1.0</capability><capability>urn:com:ericsson:ebase:0.1.0</capability><capability>urn:com:ericsson:ebase:1.1.0</capability>"
	helloCapOneTransaction="<capability>urn:ietf:params:netconf:base:1.0</capability><capability>urn:com:ericsson:ebase:0.1.0</capability>"
	helloCommand="<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><capabilities>"helloCap"</capabilities></hello>]]>]]>"
	helloCommandOneTransaction="<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><capabilities>"helloCapOneTransaction"</capabilities></hello>]]>]]>"
	closeCommand="<rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><close-session/></rpc>]]>]]>"
	netconfStartString="<rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><edit-config xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><target><running/></target><config xmlns:xc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
	netconfEndString="</config></edit-config></rpc>]]>]]>"
	lockBeforeDeleteMOs="^(PlugInUnit|EUtranCell[FT]DD|TermPointToENB|GpsReceiver|IpAccessHostEt|IpAccessHostGpb|IpAccessHostSpb|IpSyncRef|PacketFrequencySyncRef|PacketTimeSyncRef|NbIotCell)$"
	lockBeforeDeleteMOsCOM="[.](SectorEquipmentFunction|FieldReplaceableUnit|NodeBLocalCell|EUtranCell[FT]DD|TermPointToENB|NbIotCell)$"
	mosConnFailError="Checking ip contact...Not OK|Fetching IOR file...Failed!|Cannot connect to MO service, exiting...|AMOS error, exiting...|Not enough free disk space, exiting...|Not enough free RAM, exiting..."
	fileOps("mkdir -p "jarxmldir)
	chmodDir(00777,jarxmldir)
	Define_pm_menus()
	Define_months()
	Define_cppmos()
	define_temp_files()
	definetruntypes()
	xmlNodePath["tedr1"]="/r000100/telogs"
	xmlNodePath["tedr2"]="/r000200/telogs"
	xmlNodePath["tedr3"]="/r000300/telogs"
	xmlNodePath["ted"]="/d/usr/cello/telogs"    ; xmlNodeFilter["ted"]="telog.*gz$"
	xmlNodePath["sys"]="/c/logfiles/systemlog"  ; xmlNodeFilter["sys"]="sys"
	xmlNodePath["ipcs"]="/c/logfiles/ipcs_logs" ; xmlNodeFilter["ipcs"]="ip.*txt$"
	xmlNodePath["bgf"]="/c/logfiles/BGF"        ; xmlNodeFilter["bgf"]="BGF.*txt$"
	xmlTempLog["al"]=tempallog
	xmlTempLog["ev"]=tempevlog
	xmlTempLog["av"]=tempavlog
	xmlTempLog["hw"]=temphwlog
	xmlTempLog["sys"]=tempsyslog
	xmlTempLog["upg"]=tempupglog
	xmlTempLog["com"]=tempcomlog
	xmlTempLog["a_t"]=tempa_tlog
	xmlTempLog["atr"]=tempatrlog
	xmlTempLog["sec"]=tempseclog
	xmlTempLog["te"]=temptelog
	xmlTempLog["llog"]=templloglog
	xmlTempLog["pmd"]=temppmdzpmlog
	xmlTempLog["ipc"]=tempipclog
	xmlTempLog["ipd"]=tempipdlog
	xmlTempLog["mos"]=tempmoslog
	xmlTempLog["xb"]=tempxblogdir
	xmlTempLog["rlib"]=temprliblog
	xmlTempLog["ls"]=templslog
	xmlTempLog["bp"]=tempbplog
	xmlTempLog["anr"]=tempanrlog
	xmlTempLog["ted"]=temptedlog
	xmlTempLog["ipcs"]=tempipcslog
	xmlTempLog["bgf"]=tempbgflog
	reset_lg_files()
        updata_LastNrOfUp=0
	tgFetched=0
	LoopyMOs=".(SchedulerSp|QueueRed|QueueTailDrop|SchedulerDwrr|Shaper)$"  #MO classes in ECIM MOM that can cause endless loops in the "momt" and "momc" command
	if (unr==3)
	{
		usergawk=sprintf("%s/gawk"          ,commonjardir)
		pmExtract=sprintf("%s/pmExtract"    ,commonjardir)
		pmXtab=   sprintf("%s/pmXtab"       ,commonjardir)
		pmDiff=   sprintf("%s/pmDiff -force",commonjardir)
	}
	else
	{
		usergawk=gawk
		pmExtract=sprintf("%s %s/pmExtract"    ,perl,moshelldir)
		pmXtab=   sprintf("%s %s/pmXtab"       ,perl,moshelldir)
		pmDiff=   sprintf("%s %s/pmDiff -force",perl,moshelldir)
	}
	if (pmSummary=="") pmSummary=sprintf("%s -w %s/pmSummary/bin/pmSummary.pl",perl,commonjardir)  #pmSummary could be specified in the uservariable pmSummary
	else if (pmSummary !~ " -w ") pmSummary=sprintf("%s -w %s",perl,pmSummary)  #pmSummary has been specified in the uv pmSummary but without the path to perl in front
	pmxcel=sprintf("%s -I %s/pmxcel/lib -w %s/pmxcel/pmxcel.pl",perl,commonjardir,commonjardir)

	n=fileOps("ls "commonjardir"/scripts",fileList)
	for (i=1;i<=n;i++)
	{
		noLogScriptList[fileList[i]]=1
	}

	#The order is very important:
	javaErrorList[1]="PKCS 12 storing not implemented"
	javaErrorMessage[1]="!! Java version 1.4.2_05 or higher is required when corba_class>=3 !!"
	javaErrorList[2]="java.lang.ClassNotFoundException: com.prismtech.corba.jacorb.PortRangeSSLSocketFactory"
	javaErrorMessage[2]="!! The files jacorb.jar and jacsec.jar stored in "jarxmldir" are too old. R1C01 or higher is required. \nTry to download the jar files from a node running a later SW release."
	javaErrorList[3]="ClassNotFoundException:|NoClassDefFoundError:|java.lang.NoSuchMethodError|org.omg.CORBA.INITIALIZE: can.t instantiate default ORB implementation " #com.inprise.vbroker.orb.ORB or org.jacorb.orb.ORB
	javaErrorMessage[3]="!! One of the jar files in "jarxmldir" may be corrupted.\nDelete the suspected jar file(s) and try to connect again."
	javaErrorList[4]="java.lang.SecurityException: (Cannot locate policy or framework files|Cannot set up certs for trusted CAs)"
	javaErrorMessage[4]="!! Try to use a higher java version."
	javaErrorList[5]="CORBA.INITIALIZE:|CORBA.NO_PERMISSION|Could not create the Java virtual machine.|CORBA.COMM_FAILURE"
	javaErrorString=javaErrorNumber=""
	for (i in javaErrorList)
	{
		javaErrorNumber++
		javaErrorString=javaErrorString"|"javaErrorList[i]
	}
	sub(/^\|/,"",javaErrorString)
	assignCustomVar("$gawk",usergawk,                  "","system")
	assignCustomVar("$gawk_pid",gawk_pid,              "","system")
	assignCustomVar("$moshelldir",moshelldir,          "","system")
	assignCustomVar("$scripts",commonjardir"/scripts", "","system")
	assignCustomVar("$logdir",logdir,                  "","system")
	assignCustomVar("$ipaddress",node_address,         "","system")
	assignCustomVar("$nodename",node,                  "","system")
	assignCustomVar("$moshell_version",moshell_version,"","system")
	assignCustomVar("$tempdir",tempdir,                "","system")
	assignCustomVar("$uname",check_full_os(),          "","system")
	assignCustomVar("$os",check_os(),                  "","system")
	CcAccess=check_cc_access()
	AfsAccess=check_afs_access()
	yesNo[0]="No"
	yesNo[1]="Yes"
	#(obsolete) rdel_supported_mos="IubLink,NbapCommon,NbapDedicated,UtranCell,Ranap,Rnsap,Vmgw,Mtp3bSls,Mtp3bSrs,M3uAssociation,UniSaalTp,NniSaalTp,Aal5TpVccTp,Aal0TpVcctp,Aal1TpVcctp,Aal2PathVcctp,VclTp,VplTp,VpcTp,Aal2RoutingCase,Aal2Ap,AtmPort,AtmCrossConnection,ImaGroup,PacketDataRouter,Ds0Bundle"
	#split(rdel_supported_mos,array,",") ; for (i in array) rdel_supportedtable[tolower(array[i])]=1
	if (bocachedir=="") bocachedir=logdir"/cache"
	if (bocachename=="") bocachename=dotnode_address
	fileOps("mkdir -p "bocachedir)
	botablescache=sprintf("%s/%s.bo",bocachedir,bocachename)
	rnctablescache=sprintf("%s/%s.rnc",bocachedir,bocachename)
	cpptablescache=sprintf("%s/%s.cpp",bocachedir,bocachename)
	drhtablescache=sprintf("%s/%s.drh",bocachedir,bocachename)
	defaultLgfDir=sprintf("%s/lg/%s",logdir,dotnode_address)
	botablesfile=sprintf("%s/%s.bo",tempdir,dotnode_address)
	rnctablesfile=sprintf("%s/%s.rnc",tempdir,dotnode_address)
	tgtablesfile=sprintf("%s/cache/%s.tg",logdir,dotnode_address)
	moscomlog=sprintf("%s/moscomlogs/%s.log",logdir,dotnode_address) #command log
	moshistlog=sprintf("%s/moscomlogs/%s.history",logdir,dotnode_address) #history log, shown by the command "hi"
	default_moscomlog=moscomlog
	if (fileOps("test -d "moscommanddir)==0)
	{
		gsub(/(\/moscomlogs(\/*))*/,"",moscommanddir)
		moscommanddir=moscommanddir"/moscomlogs"
		tmpdir=sprintf("%s/%s",moscommanddir,moshellUSER)
		if (fileOps("mkdir -p "tmpdir)==0 && chmodDir(00777,tmpdir)==0) moscomlog=sprintf("%s/%s.log",tmpdir,dotnode_address)
	}
	if (moscomlog == default_moscomlog) moscommanddir=sprintf("%s/moscomlogs",logdir)
	if (fileOps("test -s "moscomlog)!=0 && fileOps("test -s "moscomlog".gz")==0) system("gzip -d "moscomlog".gz")
	printf("BEGIN{ moscomlog=\"%s\"; templastmoshellcmd=\"%s\"}\n",moscomlog,templastmoshellcmd) > templgnvarfile
	close(templgnvarfile)
	#if the moscomlog is bigger than xx MB then move it to a file called <node>.old.gz    #<node>.@date_time.log.gz
	#if (mosdebug==1) print "DEBUG: "moscomlog" "fileOps("stat size "moscomlog)" "moscommandsize
	#if ((moscommandsize>0) && ((fileOps("stat size "moscomlog)+0) > (moscommandsize*1048576 + 0)))
	#{
	#	tdirname=gensub(/\/[^/]+$/,"",1,moscomlog)
	#	tfilename=gensub(/^.*\/|\.log$/,"","g",moscomlog)
	#	#tdate=strftime("%Y%m%d_%H%M%S",systime())
	#	#oldmoscomlog=sprintf("%s/%s.@%s.log",tdirname,tfilename,tdate)
	#	oldmoscomlog=sprintf("%s/%s.log.old",tdirname,tfilename)
	#	customPrint("Moving and compressing "moscomlog" to "oldmoscomlog".gz")
	#	fileOps("mv "moscomlog" "oldmoscomlog)
	#	system("gzip -f "oldmoscomlog)
	#	chmod(00666,oldmoscomlog".gz")
	#}
	moscomlog_rotate(moscomlog,moscommandsize*1048576)
        add_file_to_history()
	moscomlog_rotate(moshistlog,500000)
	empty_file(temppmrpipe) ; chmod(00755,temppmrpipe)
	if (unr==3)
	{
		#make some temporary logfile and make them writeable to all, this is important for the limited version
		empty_file(tempalliplog) ; chmod(00666,tempalliplog)
		empty_file(tempbolog) ; chmod(00666,tempbolog)
	}

	#this table is to save the checkIfDir() function for checking if an argument is a directory on the node harddisk
	if (comcli==0)
	{
		pmStandby["/p001200/pm_data"]=pmStandby["/p001200/pm_data/"]="/p001300/pm_data"
		pmStandby["/p001300/pm_data"]=pmStandby["/p001300/pm_data/"]="/p001200/pm_data"
		pmStandby["/p000400/pm_data"]=pmStandby["/p000400/pm_data/"]="/p002600/pm_data"
		pmStandby["/p002600/pm_data"]=pmStandby["/p002600/pm_data/"]="/p000400/pm_data"
		pmStandby["/p000700/pm_data"]=pmStandby["/p000700/pm_data/"]="/p002200/pm_data"
		pmStandby["/p002200/pm_data"]=pmStandby["/p002200/pm_data/"]="/p000700/pm_data"
		unknownDirectoryList["/d/loadmodules"]=1
		unknownDirectoryList["/d/configuration"]=1
		unknownDirectoryList["/d/configuration/cv"]=1
		unknownDirectoryList["/d/systemfiles"]=1
		unknownDirectoryList["/d/usr"]=1
		unknownDirectoryList["/d/logfiles"]=1
		unknownDirectoryList["/c/cmxb"]=1
		unknownDirectoryList["/c/configuration"]=1
		unknownDirectoryList["/c/java"]=1
		unknownDirectoryList["/c/license"]=1
		unknownDirectoryList["/c/loadmodules"]=1
		unknownDirectoryList["/c/loadmodules_norepl"]=1
		unknownDirectoryList["/c/logfiles"]=1
		unknownDirectoryList["/c/node_id"]=1
		unknownDirectoryList["/c/pi_data"]=1
		unknownDirectoryList["/c/pm_data"]=1
		unknownDirectoryList["/c/pmd"]=1
		unknownDirectoryList["/c/public_html"]=1
		unknownDirectoryList["/c/rnc"]=1
		unknownDirectoryList["/c/security"]=1
		unknownDirectoryList["/c/systemfiles"]=1
		unknownDirectoryList["/c/tmp"]=1
		unknownDirectoryList["/c/up"]=1
		unknownDirectoryList["/c/usr"]=1
		unknownDirectoryList["/p001200/pm_data"]=1
		unknownDirectoryList["/p001300/pm_data"]=1
		unknownDirectoryList["/p0000700/pm_data"]=1
		unknownDirectoryList["/p002200/pm_data"]=1
		unknownDirectoryList["/p000400/pm_data"]=1
		unknownDirectoryList["/p002600/pm_data"]=1
		unknownDirectoryList["/c/logfiles/dspdumps"]=1
		unknownDirectoryList["/c/usr/dsp_dump"]=1
		unknownDirectoryList["/c/usr/vpp_dump"]=1
		unknownDirectoryList["/c/logfiles/dspdumps/00_01"]=1
		unknownDirectoryList["/d/logfiles/dspdumps"]=1
		unknownDirectoryList["/p000200/logfiles/dspdumps"]=1
		unknownDirectoryList["/p000300/logfiles/dspdumps"]=1
	}


	#Make Op/Adm state table
	ropTr["1 (TEN_SECONDS)"]    = "10"
	ropTr["2 (THIRTY_SECONDS)"] = "30"
	ropTr["3 (ONE_MIN)"]        = "60"
	ropTr["4 (FIVE_MIN)"]       = "300"
	ropTr["5 (FIFTEEN_MIN)"]    = "900"
	ropTr["6 (THIRTY_MIN)"]     = "1800"
	ropTr["7 (ONE_HOUR)"]       = "3600"
	ropTr["8 (TWELVE_HOUR)"]    = "12h"
	ropTr["9 (ONE_DAY)"]        = "24h"
	operationalStateText[0]="DISABLED"
	operationalStateText[1]="ENABLED"
	administrativeStateText[0]="LOCKED"
	administrativeStateText[1]="UNLOCKED"
	administrativeStateText[2]="SHUTTINGDOWN"
	short_operationalStateText[0]="D"
	short_operationalStateText[1]="E"
	short_administrativeStateText[0]="L"
	short_administrativeStateText[1]="U"
	short_administrativeStateText[2]="S"
	linkStateText[0]="AVAILABLE"
	linkStateText[1]="FAILED"
	linkStateText[2]="REMOTELY_BLOCKED"
	linkStateText[4]="LOCALLY_BLOCKED"
	linkStateText[8]="REMOTELY_INHIBITED"
	linkStateText[16]="LOCALLY_INHIBITED"
	linkStateText[32]="DEACTIVATED"
	linkStateText[33]="DEACTIVATED&FAILED"
	assocStateText[1]="INACTIVE" ; assocShortText[1]="I"
	assocStateText[2]="ACTIVE"   ; assocShortText[2]="A"
	assocStateText[4]="ESTABLISHED" ; assocShortText[4]="E"
	assocStateText[8]="DOWN"        ; assocShortText[8]="D"
	iuantdevtypeText[1]="S-RET"
	iuantdevtypeText[2]="TMA"
	iuantdevtypeText[17]="M-RET"
	pmfilter="xml.gz$"
	uefilter="_(UETR_[0-9]+|[Uu]e[Tt]race_[-_a-zA-Z0-9]+).bin(.gz)*$"
	ctfilter="(_CTR_[0-9]+|_[Cc]ell[Tt]race_[-_a-zA-Z0-9]+|.Lrat_[0-9]+_[0-9]+).bin(.gz)*$"   #Pico: A20160809.2215-2230_ENB413.Lrat_1_1.bin.gz
	gpfilter=".lnk(.gz)*$"
	rnfilter="RNC_Exception_[0-9]+_[0-9]+.gz$"
	exfilter="_exception_"
	lefilter="_LocalEvent_"
	event_version=""

	#060305-18:18:09 172.31.98.137 6.1ze RNC_NODE_MODEL_G_5_0 stopfile=/tmp/2638 (if show_timestamp==1)
	#*** 172.31.98.137 6.1ze RNC_NODE_MODEL_G_5_0 stopfile=/tmp/2638             (if show_timestamp==0)
	#071107-17:36:33 137.58.194.147 7.0r LIMITED RNC_NODE_MODEL_G_5_28 stopfile=/tmp/12588  (if limited/restricted version)
	#060328-05:54:42 10.172.96.5 6.1zg MOM-CELLO_4.3.2-3_5_1
	#081028-19:17:46 150.236.57.73 7.0y Rbs_NODE_MODEL_T_3_0 stopfile=/tmp/8126  #there is a lower case on TD-SCDMA RBS MOM
	#090717-11:31:14 134.138.69.238 7.1t CelloMOM_MOM-CPP7-LSV34.6BC1_1 stopfile=/tmp/5368

	dump_header_line=sprintf("^(\\*\\*\\*|[0-9][0-9][01][0-9][0-3][0-9]-[0-2][0-9]:[0-5][0-9]:[0-5][0-9]) +[^ ]+ +([4-9]|1[0-9])\\.[0-9][a-z]* (LIMITED|READONLY|RESTRICTED.?)* *[A-Z][a-zA-Z-]+_[^ ]+")

	#UsageState translations
	usageStateText[0]="I"
	usageStateText[1]="A"
	usageStateText[2]="B"

	#LED translations for inv printout
	#0:NOT_APPLICABLE, 1:NOT_AVAILABLE, 2:OUT, 3:STEADY_LIGHT, 4:SLOW_BLINK, 5:FAST_BLINK, 6:FLICKERING
	#0:N/A 1:? 2:OFF 3:ON 4:05HZ 5:2HZ 6:16HZ
	#INDICATOR translations:
	#0:NOT_APPLICABLE, 1:NOT_AVAILABLE, 2:OFF, 3:STEADY_ON, 4:SLOW_BLINK, 6:FAST_BLINK, 7:DOUBLE_FLASH_AND_STEADY_ON, 8:DOUBLE_FLASH_AND_OFF
	PIULED[0]="N/A"
	PIULED[1]="?"
	PIULED[2]="OFF"
	PIULED[3]="ON"
	PIULED[4]="05HZ"
	PIULED[5]="2HZ"
	PIULED[6]="16HZ"  #actually corresponds to 2HZ when read from Indicator attribute and 16HZ does not exist on the Indicator
	PIULED[7]="xx1" #DOUBLE_FLASH_AND_STEADY_ON
	PIULED[8]="xx0" #DOUBLE_FLASH_AND_OFF

	#RBS CE FOR DUW BOARDS. Based on CPI DUW description and FDI - OAM, TRAFFIC AND CHARACTERISTICS FOR DUW V2 (1/190 24-FCP 121 9071)
	RBS_CE["KDU127161/1"]  ="128/128 CE"   #DUW1001 128 DL 128 UL, 192 EUL
	RBS_CE["KDU127161/2"]  ="384/384 CE"   #DUW2001 384 DL 384 UL, 576 EUL
	RBS_CE["KDU127161/3"]  ="768/512 CE"   #DUW3001 768 DL 512 UL, 768 EUL
	RBS_CE["KDU127174/1"]  ="192/128 CE"  #	DUW1101 128 DL 128 UL, 192 EUL (CPI) -> 192 DL 128 UL, 128 RLs
	RBS_CE["KDU127174/2"]  =""  #	DUW2101
	RBS_CE["KDU127174/3"]  ="768/512 CE"  #	DUW3101 768 DL 512 UL, 768 EUL
	RBS_CE["KDU127174/4"]  ="1152/768 CE"  #	DUW4101 768 DL 768 UL, 1152 EUL (CPI) -> 1152 DL 768 UL (FDI) , 768 RLs
	#RBS CE FOR RAX BOARDS. Based on 27/1551-HRB 105 102/1 and 41/1551-HRB 105 102/1, or 1/221 01-FGC 101 811
	RBS_CE["ROJ1192071/2"] ="RaxR1 16CE"
	RBS_CE["ROJ1192071/3"] ="RaxR1 16CE"
	RBS_CE["ROJ1192187/1"] ="RaxR2 128CE"
	RBS_CE["ROJ1192187/2"] ="RaxR2 64CE"
	RBS_CE["ROJ1192187/3"] ="RaxR2 32CE"
	RBS_CE["ROJ1192187/4"] ="RaxR2 128CE"
	RBS_CE["ROJ1192187/5"] ="RaxR2 64CE"
	RBS_CE["ROJ1192187/6"] ="RaxR2 32CE"
	RBS_CE["ROJ1192187/7"] ="RaxR2 64CE"
	RBS_CE["ROJ1192187/8"] ="RaxR2 32CE"
	RBS_CE["ROJ1192187/10"]="RaxR2 128CE"
	RBS_CE["ROJ1192187/11"]="RaxR2 128CE"
	RBS_CE["ROJ1192187/12"]="RaxR2 64CE"
	RBS_CE["ROJ1192187/13"]="RaxR2 32CE"
	RBS_CE["ROJ1192187/14"]="RaxR2e 128CE"
	RBS_CE["ROJ1192187/15"]="RaxR2e 64CE"
	#RBS CE FOR TX BOARDS. Based on 1/221 01-FGC 101 811 rev PH3
	RBS_CE["ROJ1192124/3"]= "TxR1 228CE"   #TX R1
	RBS_CE["ROJ1192240/1"]= "TxR2 228CE"   #TX R2
	RBS_CE["ROJ1192254/11"]="TxR3 64CE"    #TX R3
	RBS_CE["ROJ1192254/12"]="TxR3 128CE"   #TX R3
	RBS_CE["ROJ1192254/13"]="TxR3 256CE"   #TX R3
	RBS_CE["ROJ1192254/3"]= "HsTx15 128CE"   #HS-TX15
	RBS_CE["ROJ1192254/5"]= "HsTx15 128CE"   #HS-TX15
	RBS_CE["ROJ1192254/7"]= "HsTx15 128CE"   #HS-TX15
	RBS_CE["ROJ1192254/4"]= "HsTx45 384CE"   #HS-TX45
	RBS_CE["ROJ1192254/8"]= "HsTx45 384CE"   #HS-TX45
	RBS_CE["ROJ1192254/6"]= "HsTx60 384CE"   #HS-TX60
	#RBS CAPABILITY FOR RRU BOARDS. Based on 41/1551-HRB 105 102/1
	RBS_CE["KRC161007/1"] ="2.1GHz 10W 1/1 15MHz"
	RBS_CE["KRC161007/2"] ="2.1GHz 20W 2/2 15MHz"
	RBS_CE["KRC161154/1"] ="2.1GHz 10W 2/2 15MHz" #RRU22 2110
	RBS_CE["KRC161109/1"] ="2.1GHz 20W 2/2 15MHz"
	RBS_CE["KRC161134/1"] ="2.1GHz 40W 2/2 15MHz"
	RBS_CE["KRC161134/11"]="2.1GHz 40W 2/2 15MHz"
	RBS_CE["KRC161134/11"]="2.1GHz 40W 2/2 15MHz"
	RBS_CE["KRC11842/2"]  ="2.1GHz 20/40/60W 4/4 20MHz"
	RBS_CE["KRC161134/2"] ="1.9GHz 40W 2/2 15MHz"
	RBS_CE["KRC11847/2"]  ="1.9GHz 20/40/60W 4/4 20MHz"
	RBS_CE["KRC161109/4"] ="1.7/2.1GHz 40W 2/2 15MHz"
	RBS_CE["KRC161109/3"] ="1.7/1.8GHz 20W 2/2 15MHz"
	RBS_CE["KRC161134/6"] ="900MHz 40W 2/2 15MHz"
	RBS_CE["KRC161134/61"]="900MHz 40W 2/2 15MHz"
	RBS_CE["KRC161134/5"] ="850MHz 40W 2/2 15MHz"
	RBS_CE["KRC161134/51"]="850MHz 40W 2/2 15MHz"
	RBS_CE["KRC11846/2"]  ="850MHz 20/40/60W 4/4 20MHz"

	#RBS CAPABILITY FOR RRU BOARDS. Based on 95/1551-HRB 105 102/1
	RBS_CE["KRC161154/2"] ="2.1GHz 20W 2/2 15MHz" #RRU22 2120

	#RBS CAPABILITY FOR RU BOARDS. Based on 41/1551-HRB 105 102/1
	RBS_CE["KRC11816/2"]="2.1GHz 20W 15MHz"
	RBS_CE["KRC11816/3"]="2.1GHz 20W 15MHz"
	RBS_CE["KRC11816/1"]="2.1GHz 30W 15MHz"
	RBS_CE["KRC11816/4"]="2.1GHz 30W 15MHz"
	RBS_CE["KRC11818/3"]="2.1GHz 20W 15MHz"
	RBS_CE["KRC11818/4"]="2.1GHz 20W 15MHz"
	RBS_CE["KRC11818/1"]="2.1GHz 40W 15MHz"
	RBS_CE["KRC11818/5"]="2.1GHz 40W 15MHz"
	RBS_CE["KRC11818/6"]="2.1GHz 60W 10MHz"
	RBS_CE["KRC11829/4"]="1.7/2.1GHz 20W 15MHz"
	RBS_CE["KRC11829/2"]="1.7/2.1GHz 40W 15MHz"
	RBS_CE["KRC11819/2"]="1.9GHz 20W 15MHz"
	RBS_CE["KRC11819/1"]="1.9GHz 40W 15MHz"
	RBS_CE["KRC11819/3"]="1.9GHz 40W 15MHz"
	RBS_CE["KRC11835/2"]="900MHz 40W 15MHz"
	RBS_CE["KRC11835/4"]="900MHz 40W 15MHz"
	RBS_CE["KRC11822/3"]="850MHz 20W 15MHz"
	RBS_CE["KRC11822/1"]="850MHz 40W 15MHz"
	RBS_CE["KRC11822/4"]="850MHz 40W 15MHz"
	RBS_CE["KRC11822/6"]="850MHz 40W 15MHz"
	RBS_CE["KRC11822/2"]="850MHz 60W 15MHz"
	RBS_CE["KRC11822/5"]="850MHz 60W 15MHz"
	RBS_CE["KRC11840/2"]="2.1GHz 60W"
	#RBS CAPABILITY FOR RU BOARDS. Based on 95/1551-HRB 105 102/1
	RBS_CE["KRC121154/1"]="2.1GHz 20W 15MHz" #RU21 2120
	RBS_CE["KRC121154/2"]="2.1GHz 30W 15MHz" #RU21 2130
	RBS_CE["KRC121155/2"]="2.1GHz 40W 15MHz" #RU22 2140

	#RBS CAPABILITY FOR FU BOARDS. Based on 41/1551-HRB 105 102/1
	RBS_CE["KRC11817/1"]="2.1GHz"
	RBS_CE["KRC11820/1"]="1.9GHz"
	RBS_CE["KRC11821/1"]="850MHz"
	RBS_CE["KRC11828/1"]="1.7/2.1GHz"
	RBS_CE["KRC11836/1"]="900MHz"

	#RBS CAPABILITY FOR AIU/TRX/PAU BOARDS. Based on 27/1551-HRB 105 102/1
	RBS_CE["KRY1011854/3"]="2.1GHz"        #AIU
	RBS_CE["KRY1011854/5"]="2.1GHz"        #AIU
	RBS_CE["KRY1011854/6"]="2.1GHz"        #AIU
	RBS_CE["KRY1011451/3"]="1.9GHz"        #AIU
	RBS_CE["KRY112119/3"]="2.1GHz 20MHz"   #sAIU
	RBS_CE["KRY112120/1"]="2.1GHz 60MHz"   #sAIU
	RBS_CE["KRY112123/1"]="1.9GHz"         #sAIU
	RBS_CE["KRY112124/1"]="850MHz"         #sAIU
	RBS_CE["ROJ1192125/3"]="2.1GHz"        #TRX
	RBS_CE["ROJ1192164/1"]="2.1GHz"        #TRX
	RBS_CE["ROJ1192233/1"]="1.9GHz"        #TRX
	RBS_CE["ROJ1192237/1"]="2.1GHz 20MHz"  #sTRX
	RBS_CE["ROJ1192237/1"]="2.1GHz 60MHz"  #sTRX
	RBS_CE["ROJ1192237/2"]="2.1GHz 20MHz"  #sTRX
	RBS_CE["ROJ1192289/1"]="1.9GHz"        #sTRX
	RBS_CE["ROJ1192289/1"]="850MHz"        #sTRX
	RBS_CE["KRB90103/3"]="2.1GHz 5W"  #PAU
	RBS_CE["KRB90112/1"]="2.1GHz 20W"  #PAU
	RBS_CE["KRB90117/1"]="1.9GHz"  #PAU
	RBS_CE["KRB90118/1"]="850MHz"  #PAU

	#RBS CAPABILITY FOR PSU BOARDS. Based on 11/1551-LZA 701 6003 (CPI)
	RBS_CE["BML161174/1"]="PSU AC"
	RBS_CE["BMR910427/1"]="PSU DC"

	#RBS8418 TDSCDMA 6/1551-HRB10651/1 and 3/1551-HRB 106 51/1
	RBS_CE["BML901210/1"]="PSU AC"
	RBS_CE["BML901181/1"]="PSU AC"
	RBS_CE["KRC161174/1"]="RRU46 2GHz 3W/path 15MHz"
	RBS_CE["KRC161174/4"]="RRU46i 2GHz 8W 15MHz"
	RBS_CE["KRC161174/3"]="RRU86 2GHz 3W/path 15MHz"
	RBS_CE["KRC161174/5"]="RRU86A 1.9GHz 4W/path 15MHz"
	RBS_CE["KRC161217/1"]="RRU112A 1.9GHz 20W 20MHz"

	#The mapping between CXC and attribute name can be found by doing "mom . . . . cxc"
	#or from the document 1/0062-HSD10102 https://erilink.ericsson.se/eridoc/erl/objectId/09004cff874b95ef?docno=1/0062-HSD10102Uen&action=current&format=excel12book

	rbsFeatureName["CXC4010071/4005"]="StandardizedTma"
	rbsFeatureName["CXC4010071/4006"]="StandardizedRet"
	rbsFeatureName["CXC4020001"]     ="HsdpaDynamicCodeAllocation"
	rbsFeatureName["CXC4020002"]     ="16Qam"
	rbsFeatureName["CXC4020003"]     ="HsdpaFlexibleScheduler"
	rbsFeatureName["CXC4020005"]     ="EnhancedUplinkIntroduction"
	rbsFeatureName["CXC4020008"]     ="HsdpaIncrementalRedundancy"
	rbsFeatureName["CXC4020010"]     ="RttPositioning"
	rbsFeatureName["CXC4020011"]     ="Eul2msTti"
	rbsFeatureName["CXC4020012"]     ="Mimo"
	rbsFeatureName["CXC4020013"]     ="EnhancedLayer2"
	rbsFeatureName["CXC4020014"]     ="64Qam"
	rbsFeatureName["CXC4020015"]     ="MbmsIubEfficiency"
	rbsFeatureName["CXC4020016"]     ="Grake"
	rbsFeatureName["CXC4020018"]     ="4wayRxDiversity"
	rbsFeatureName["CXC4020020"]     ="DlPowerControlEul"
	rbsFeatureName["CXC4020021"]     ="SpecialHwSupport"
	rbsFeatureName["CXC4020022"]     ="ConfigurableCarrierBandwidth"
	rbsFeatureName["CXC4020023"]     ="HsdpaImprovedLinkAdaptation"
	rbsFeatureName["CXC4020025"]     ="FDpchSrbOnHsdpa"
	rbsFeatureName["CXC4020026"]     ="Cpc"
	rbsFeatureName["CXC4020028"]     ="HsdpaMinBitRate"
	rbsFeatureName["CXC4020029"]     ="HsdpaMc"
	rbsFeatureName["CXC4020030"]     ="PerHarqProcessGrant"
	rbsFeatureName["CXC4020031"]     ="RetCascading"
	rbsFeatureName["CXC4020032"]     ="HsdpaMcInactCtrl"
	rbsFeatureName["CXC4020035"]     ="DualTmaSupport"
	rbsFeatureName["CXC4020040"]     ="IncrNumHsCodes"
	rbsFeatureName["CXC4020042"]     ="EulForLargeRbsConfig"
	rbsFeatureName["CXC4030037"]     ="DualStackIub"
	rbsFeatureName["CXC4020034"]     ="64QamMimo"
	rbsFeatureName["CXC4020054"]     ="DchEulBalancing"
	rbsFeatureName["CXC4020055"]     ="EnhUeDrx"
	rbsFeatureName["CXC4020043"]     ="HsFach"
	rbsFeatureName["CXC4020036"]     ="HsdpaDbMc"
	rbsFeatureName["CXC4020038"]     ="HsdpaMcMimo"
	rbsFeatureName["CXC4020051"]     ="MixedMode"
	rbsFeatureName["CXC4020053"]     ="HsdpaRbrQosProfiling"
	rbsFeatureName["CXC4020057"]     ="EulDynRot"
	rbsFeatureName["CXC4020063"]     ="RbsMpLoadSharing"
	rbsFeatureName["CXC4020064"]     ="EulFach"
	rbsFeatureName["CXC4021014"]     ="CeCapEul"
	rbsFeatureName["CXC4020039"]     ="EulTdScheduling"
	rbsFeatureName["CXC4020058"]     ="HsAqmCongCtrl"
	rbsFeatureName["CXC4020041"]     ="ImprovedLayer2"
	rbsFeatureName["CXC4020061"]     ="InterferenceSuppression"
	rbsFeatureName["CXC4020060"]     ="PsiCoverage"
	rbsFeatureName["CXC4020069"]     ="CeExtForEul"
	rbsFeatureName["CXC4020068"]     ="Csasr"
	rbsFeatureName["CXC4020066"]     ="UlFcc"
	rbsFeatureName["CXC4020070"]     ="IntSuppEul10ms"
	rbsFeatureName["CXC4020037"]     ="EulMc"
	rbsFeatureName["CXC4020072"]     ="HsdpaMcInterDuSched"
	rbsFeatureName["CXC4020076"]     ="CombinedCell"
	rbsFeatureName["CXC4020065"]     ="IntSuppAllBearers"
	rbsFeatureName["CXC4020075"]     ="CeEfficiencyEul"

	rbsFeatureName["CXC4020082"]     ="Hsdpa3Mc"
	rbsFeatureName["CXC4020083"]     ="HsdpaDb3Mc"
	rbsFeatureName["CXC4020079"]     ="HsdpaPowerSharing"
	rbsFeatureName["CXC4020084"]     ="IncreasedCellCarrierSupport"
	rbsFeatureName["CXC4020081"]     ="Nbir"
	rbsFeatureName["CXC4020091"]     ="UlCoMpReception"
	rbsFeatureName["CXC4020073"]     ="IncreasedHsCodeCap"
	rbsFeatureName["CXC4020074"]     ="HsOlpc"
	rbsFeatureName["CXC4020090"]     ="MultiSectorPerRadio"
	rbsFeatureName["CXC4020086"]     ="EulLowLatencyPresched"
	rbsFeatureName["CXC4011929"]     ="UlSpectrumAnalyzer"

	rbsFeatureName["CXC4020098"]     ="HsAdaptiveBler"
	rbsFeatureName["CXC4020102"]     ="HsdpaMixedModePowerSharing"

	rbsFeatureName["CXC4020103"]     ="AdditionalCeExtForEul"
	rbsFeatureName["CXC4020104"]     ="EulAdaptiveBler"
	rbsFeatureName["CXC4020022"]     ="ConfigurableCarrierBandwidth"
	rbsFeatureName["CXC4020105"]     ="CsVoiceBatterySavings"

	#Does not need any license:
	rbsFeatureName["CXCyyyyyyy"]     ="AbsoluteTimeSynch"
	rbsFeatureName["CXCzzzzzzz"]     ="ImprovedDAgc"



	rbsCapacityName["CXC4010071/4002"]="RbsChannelElementsUplink"
	rbsCapacityName["CXC4010071/4003"]="RbsChannelElementsDownlink"
	rbsCapacityName["CXC4021001"]     ="NumHsPdschCodes"
	rbsCapacityName["CXC4021002"]     ="NumHsdpaUsers"
	rbsCapacityName["CXC4021003"]     ="DelayedActivationOfCapacity"
	rbsCapacityName["CXC4021007"]     ="NumEulUsers"
	rbsCapacityName["CXC4021008"]     ="Num40WPowerAmplifiers"
	rbsCapacityName["CXC4021009"]     ="Num60WPowerAmplifiers"
	rbsCapacityName["CXC4021010"]     ="NumCarriers"
	rbsCapacityName["CXC4021011"]     ="Num80WPowerAmplifiers"
	rbsCapacityName["CXC4021012"]     ="Num100WPowerAmplifiers"
	rbsCapacityName["CXC4021013"]     ="Num120WPowerAmplifiers"
	rbsCapacityName["CXC4020009"]     ="ChannelElementUl"
	rbsCapacityName["CXC4020046"]     ="ChannelElementDl"
	rbsCapacityName["CXC4020106"]     ="NumRbsCarriers"

	rbsCapacityName["CXC4020094"]     ="Num140WPowerAmplifiers"
	rbsCapacityName["CXC4020095"]     ="Num160WPowerAmplifiers"
	rbsCapacityName["CXC4012134"]     ="Num180WPowerAmplifiers"
	rbsCapacityName["CXC4012135"]     ="Num200WPowerAmplifiers"
	rbsCapacityName["CXC4012136"]     ="Num220WPowerAmplifiers"
	rbsCapacityName["CXC4012137"]     ="Num240WPowerAmplifiers"



	#Other capacities, not found in MO?
	#CXC4020017                            False    0        False     0         Licensed     Improved CE ladder for Enhanced Uplink
	#CXC4021004                            False    0        False     0         Licensed     Channel Element Ladder for E-DCH.


	LICENSE_INFO["CXC4040002"]="Ethernet Link Aggregation"
	LICENSE_INFO["CXC4040003"]="Layer 2 Gateway port"
	LICENSE_INFO["CXC4040004"]="IP Security"
	LICENSE_INFO["CXC4040005"]="Egress IP Traffic Shaping"
	LICENSE_INFO["CXC4040006"]="IPv6"
	LICENSE_INFO["CXC4040007"]="Frequency Syncronization"
	LICENSE_INFO["CXC4040008"]="Time and Phase Synchronization"
	LICENSE_INFO["CXC4040009"]="Two-Way Active Measurement Protocol Responder"
	LICENSE_INFO["CXC4040010"]="Real time security Event Logging"
	LICENSE_INFO["CXC4040011"]="Synchronous Ethernet"
	LICENSE_INFO["CXC4040013"]="IP Flow Monitoring"
	LICENSE_INFO["CXC4040014"]="Ethernet OAM Service"

	LICENSE_MOINFO["CXC4040002"]="EthernetSwitchingAdm:LinkAgg"
	LICENSE_MOINFO["CXC4040003"]="EthernetSwitchingAdm:L2gp"
	LICENSE_MOINFO["CXC4040004"]="IpSec"
	LICENSE_MOINFO["CXC4040005"]="TrafficManagement"
	LICENSE_MOINFO["CXC4040006"]="Ipv6"
	LICENSE_MOINFO["CXC4040007"]="Synchronization:ptpFreq"
	LICENSE_MOINFO["CXC4040008"]="Synchronization:ptpTime"
	LICENSE_MOINFO["CXC4040009"]="Ippm"
	LICENSE_MOINFO["CXC4040010"]="RealTimeSecLog"
	LICENSE_MOINFO["CXC4040011"]="Synchronization:SyncEth"
	LICENSE_MOINFO["CXC4040013"]="IpLicensing:IpFlowMonitoring"
	LICENSE_MOINFO["CXC4040014"]="IpLicensing:EthernetOamService"

	maxCxcCpp=14   #increase this number when adding more CPP features

	#The table cppFeatureMOs is needed by the feature mosalarm=1 !!
	for (i in LICENSE_MOINFO) cppFeatureMOs[gensub(/:.*$/,"",1,LICENSE_MOINFO[i])]=gensub(/:.*$/,"",1,LICENSE_MOINFO[i])


	#Ip static Route types according to "mom iproutingtable listroutes"
	ipStaticRouteType[1] = "OTHER"
	ipStaticRouteType[2] = "LOCAL"
	ipStaticRouteType[3] = "NETMGMT"
	ipStaticRouteType[4] = "ICMP"
	ipStaticRouteType[13]= "OSPF"

	cg_klm_v12[1] ="1/1.1.1"
	cg_klm_v12[2] ="1/1.1.2"
	cg_klm_v12[3] ="1/1.1.3"
	cg_klm_v12[4] ="1/1.2.1"
	cg_klm_v12[5] ="1/1.2.2"
	cg_klm_v12[6] ="1/1.2.3"
	cg_klm_v12[7] ="1/1.3.1"
	cg_klm_v12[8] ="1/1.3.2"
	cg_klm_v12[9] ="2/1.3.3"
	cg_klm_v12[10]="2/1.4.1"
	cg_klm_v12[11]="2/1.4.2"
	cg_klm_v12[12]="2/1.4.3"
	cg_klm_v12[13]="2/1.5.1"
	cg_klm_v12[14]="2/1.5.2"
	cg_klm_v12[15]="2/1.5.3"
	cg_klm_v12[16]="2/1.6.1"
	cg_klm_v12[17]="3/1.6.2"
	cg_klm_v12[18]="3/1.6.3"
	cg_klm_v12[19]="3/1.7.1"
	cg_klm_v12[20]="3/1.7.2"
	cg_klm_v12[21]="3/1.7.3"
	cg_klm_v12[22]="4/2.1.1"
	cg_klm_v12[23]="4/2.1.2"
	cg_klm_v12[24]="4/2.1.3"
	cg_klm_v12[25]="4/2.2.1"
	cg_klm_v12[26]="4/2.2.2"
	cg_klm_v12[27]="4/2.2.3"
	cg_klm_v12[28]="4/2.3.1"
	cg_klm_v12[29]="4/2.3.2"
	cg_klm_v12[30]="5/2.3.3"
	cg_klm_v12[31]="5/2.4.1"
	cg_klm_v12[32]="5/2.4.2"
	cg_klm_v12[33]="5/2.4.3"
	cg_klm_v12[34]="5/2.5.1"
	cg_klm_v12[35]="5/2.5.2"
	cg_klm_v12[36]="5/2.5.3"
	cg_klm_v12[37]="5/2.6.1"
	cg_klm_v12[38]="6/2.6.2"
	cg_klm_v12[39]="6/2.6.3"
	cg_klm_v12[40]="6/2.7.1"
	cg_klm_v12[41]="6/2.7.2"
	cg_klm_v12[42]="6/2.7.3"
	cg_klm_v12[43]="7/3.1.1"
	cg_klm_v12[44]="7/3.1.2"
	cg_klm_v12[45]="7/3.1.3"
	cg_klm_v12[46]="7/3.2.1"
	cg_klm_v12[47]="7/3.2.2"
	cg_klm_v12[48]="7/3.2.3"
	cg_klm_v12[49]="7/3.3.1"
	cg_klm_v12[50]="7/3.3.2"
	cg_klm_v12[51]="8/3.3.3"
	cg_klm_v12[52]="8/3.4.1"
	cg_klm_v12[53]="8/3.4.2"
	cg_klm_v12[54]="8/3.4.3"
	cg_klm_v12[55]="8/3.5.1"
	cg_klm_v12[56]="8/3.5.2"
	cg_klm_v12[57]="8/3.5.3"
	cg_klm_v12[58]="8/3.6.1"
	cg_klm_v12[59]="9/3.6.2"
	cg_klm_v12[60]="9/3.6.3"
	cg_klm_v12[61]="9/3.7.1"
	cg_klm_v12[62]="9/3.7.2"
	cg_klm_v12[63]="9/3.7.3"

	cg_klm_v15[1,1] = "1/1.1.1"
	cg_klm_v15[1,2] = "1/1.1.2"
	cg_klm_v15[1,3] = "1/1.1.3"
	cg_klm_v15[1,4] = "1/1.1.4"
	cg_klm_v15[1,5] = "1/1.2.1"
	cg_klm_v15[1,6] = "1/1.2.2"
	cg_klm_v15[1,7] = "1/1.2.3"
	cg_klm_v15[1,8] = "1/1.2.4"
	cg_klm_v15[1,9] = "2/1.3.1"
	cg_klm_v15[1,10]= "2/1.3.2"
	cg_klm_v15[1,11]= "2/1.3.3"
	cg_klm_v15[1,12]= "2/1.3.4"
	cg_klm_v15[1,13]= "2/1.4.1"
	cg_klm_v15[1,14]= "2/1.4.2"
	cg_klm_v15[1,15]= "2/1.4.3"
	cg_klm_v15[1,16]= "2/1.4.4"
	cg_klm_v15[1,17]= "3/1.5.1"
	cg_klm_v15[1,18]= "3/1.5.2"
	cg_klm_v15[1,19]= "3/1.5.3"
	cg_klm_v15[1,20]= "3/1.5.4"
	cg_klm_v15[1,21]= "3/1.6.1"
	cg_klm_v15[1,22]= "3/1.6.2"
	cg_klm_v15[1,23]= "3/1.6.3"
	cg_klm_v15[1,24]= "3/1.6.4"
	cg_klm_v15[1,25]= "4/1.7.1"
	cg_klm_v15[1,26]= "4/1.7.2"
	cg_klm_v15[1,27]= "4/1.7.3"
	cg_klm_v15[1,28]= "4/1.7.4"
	cg_klm_v15[2,1] = "5/2.1.1"
	cg_klm_v15[2,2] = "5/2.1.2"
	cg_klm_v15[2,3] = "5/2.1.3"
	cg_klm_v15[2,4] = "5/2.1.4"
	cg_klm_v15[2,5] = "5/2.2.1"
	cg_klm_v15[2,6] = "5/2.2.2"
	cg_klm_v15[2,7] = "5/2.2.3"
	cg_klm_v15[2,8] = "5/2.2.4"
	cg_klm_v15[2,9] = "6/2.3.1"
	cg_klm_v15[2,10]= "6/2.3.2"
	cg_klm_v15[2,11]= "6/2.3.3"
	cg_klm_v15[2,12]= "6/2.3.4"
	cg_klm_v15[2,13]= "6/2.4.1"
	cg_klm_v15[2,14]= "6/2.4.2"
	cg_klm_v15[2,15]= "6/2.4.3"
	cg_klm_v15[2,16]= "6/2.4.4"
	cg_klm_v15[2,17]= "7/2.5.1"
	cg_klm_v15[2,18]= "7/2.5.2"
	cg_klm_v15[2,19]= "7/2.5.3"
	cg_klm_v15[2,20]= "7/2.5.4"
	cg_klm_v15[2,21]= "7/2.6.1"
	cg_klm_v15[2,22]= "7/2.6.2"
	cg_klm_v15[2,23]= "7/2.6.3"
	cg_klm_v15[2,24]= "7/2.6.4"
	cg_klm_v15[2,25]= "8/2.7.1"
	cg_klm_v15[2,26]= "8/2.7.2"
	cg_klm_v15[2,27]= "8/2.7.3"
	cg_klm_v15[2,28]= "8/2.7.4"
	cg_klm_v15[3,1] = "9/3.1.1"
	cg_klm_v15[3,2] = "9/3.1.2"
	cg_klm_v15[3,3] = "9/3.1.3"
	cg_klm_v15[3,4] = "9/3.1.4"
	cg_klm_v15[3,5] = "9/3.2.1"
	cg_klm_v15[3,6] = "9/3.2.2"
	cg_klm_v15[3,7] = "9/3.2.3"
	cg_klm_v15[3,8] = "9/3.2.4"
	cg_klm_v15[3,9] ="10/3.3.1"
	cg_klm_v15[3,10]="10/3.3.2"
	cg_klm_v15[3,11]="10/3.3.3"
	cg_klm_v15[3,12]="10/3.3.4"
	cg_klm_v15[3,13]="10/3.4.1"
	cg_klm_v15[3,14]="10/3.4.2"
	cg_klm_v15[3,15]="10/3.4.3"
	cg_klm_v15[3,16]="10/3.4.4"
	cg_klm_v15[3,17]="11/3.5.1"
	cg_klm_v15[3,18]="11/3.5.2"
	cg_klm_v15[3,19]="11/3.5.3"
	cg_klm_v15[3,20]="11/3.5.4"
	cg_klm_v15[3,21]="11/3.6.1"
	cg_klm_v15[3,22]="11/3.6.2"
	cg_klm_v15[3,23]="11/3.6.3"
	cg_klm_v15[3,24]="11/3.6.4"
	cg_klm_v15[3,25]="12/3.7.1"
	cg_klm_v15[3,26]="12/3.7.2"
	cg_klm_v15[3,27]="12/3.7.3"
	cg_klm_v15[3,28]="12/3.7.4"

	b2h_table["0000"]="0"
	b2h_table["0001"]="1"
	b2h_table["0010"]="2"
	b2h_table["0011"]="3"
	b2h_table["0100"]="4"
	b2h_table["0101"]="5"
	b2h_table["0110"]="6"
	b2h_table["0111"]="7"
	b2h_table["1000"]="8"
	b2h_table["1001"]="9"
	b2h_table["1010"]="A"
	b2h_table["1011"]="B"
	b2h_table["1100"]="C"
	b2h_table["1101"]="D"
	b2h_table["1110"]="E"
	b2h_table["1111"]="F"
	h2b_table["0"]="0000"
	h2b_table["1"]="0001"
	h2b_table["2"]="0010"
	h2b_table["3"]="0011"
	h2b_table["4"]="0100"
	h2b_table["5"]="0101"
	h2b_table["6"]="0110"
	h2b_table["7"]="0111"
	h2b_table["8"]="1000"
	h2b_table["9"]="1001"
	h2b_table["A"]="1010"
	h2b_table["B"]="1011"
	h2b_table["C"]="1100"
	h2b_table["D"]="1101"
	h2b_table["E"]="1110"
	h2b_table["F"]="1111"

	uerEstabCause[0]="origConversational"
	uerEstabCause[1]="origStreaming"
	uerEstabCause[2]="origInteractive"
	uerEstabCause[3]="origBackground"
	uerEstabCause[4]="origSubscribedTraffic"
	uerEstabCause[5]="termConversational"
	uerEstabCause[6]="termStreaming"
	uerEstabCause[7]="termInteractive"
	uerEstabCause[8]="termBackground"
	uerEstabCause[9]="emergencyCall"
	uerEstabCause[10]="IRAT_cellReselection"
	uerEstabCause[11]="IRAT_cellChangeOrder"
	uerEstabCause[12]="registration"
	uerEstabCause[13]="rrc_detach"
	uerEstabCause[14]="origHighPrioSignaling"
	uerEstabCause[15]="origLowPrioSignaling"
	uerEstabCause[16]="callReEstablishment"
	uerEstabCause[17]="termHighPrioSignaling"
	uerEstabCause[18]="termLowPrioSignaling"
	uerEstabCause[19]="termCauseUnknown"
	uerEstabCause[20]="mbms_reception"
	uerEstabCause[21]="mbms_PTP_RB_request"
	#uerEstabCause[20]="SecSigConnReq"   ??? according to class specification of RnhIfCommonEstablishmentCauseD

	#MGW device types
	msDevType[2^0]  = "DTMF Sender"
	msDevType[2^1]  = "Tone Sender"
	msDevType[2^2]  = "Continuity Check"
	msDevType[2^3]  = "DTMF Receiver"
	msDevType[2^4]  = "MCC"
	msDevType[2^5]  = "EC"
	msDevType[2^6]  = "NR"
	msDevType[2^7]  = "GTT"
	msDevType[2^8]  = "AMR"
	msDevType[2^9]  = "Inmarsat"
	msDevType[2^10] = "UP FH"
	msDevType[2^11] = "CSD GSM FH"
	msDevType[2^12] = "CSD Digital"
	msDevType[2^13] = "CSD Modem"
	msDevType[2^14] = "IM"
	msDevType[2^15] = "MPC"
	msDevType[2^16] = "IPB"
	msDevType[2^17] = "CDMA SC"
	msDevType[2^18] = "Jitter Handling"
	msDevType[2^19] = "EFR"
	msDevType[2^20] = "TFO"
	msDevType[2^21] = "CSD Gsm Fax"
	msDevType[2^22] = "PCM"
	msDevType[2^23] = "IPET"
	msDevType[2^24] = "AMR-WB"
	msDevType[2^25] = "Reserved"
	msDevType[2^26] = "G.729"

	#New MOM tags
	tagTranslation["statusInformation"]             = "Status Information: "
	tagTranslation["applicationTag"]                = "Application Tag: "
	tagTranslation["condition"]                     = "Condition: "
	tagTranslation["counterContext"]                = "Context: "
	tagTranslation["counterReset"]                  = "Counter is reset after measurement period: "
	tagTranslation["counterReset","true"]           = "Yes"
	tagTranslation["counterReset","false"]          = "No"
	tagTranslation["counterType"]                   = "Counter type: "
	tagTranslation["dependencies"]                  = "Dependencies: "               #in old MOM we have: Dependencies:\n
	#tagTranslation["dependenciesScript"]            = "Dependencies Script: "
	tagTranslation["deprecated"]                    = "Deprecated: "                 #in old MOM we have: Deprecated:\n
	tagTranslation["disturbances"]                  = "Disturbances: "               #in old MOM we have: Disturbances:\n
	tagTranslation["feature"]                       = "Feature: "
	tagTranslation["filter"]                        = "Filter: "
	tagTranslation["getValue"]                      = "Get value: "
	tagTranslation["lockBeforeDelete"]              = "Lock before delete: "
	tagTranslation["lockBeforeModify"]              = "Lock before modify: "
	tagTranslation["notificationTypes"]             = "Notification types: "
	tagTranslation["obsolete"]                      = "Obsolete: "
	tagTranslation["precondition"]                  = "Precondition: "
	tagTranslation["resolution"]                    = "Resolution: "
	tagTranslation["samplingRate"]                  = "Sampling rate: "
	tagTranslation["scanner"]                       = "Scanner: "
	tagTranslation["sideEffects"]                   = "Side effects: "
	tagTranslation["specification"]                 = "Specification: "
	tagTranslation["takesEffect"]                   = "Change takes effect: "
	tagTranslation["transactionConstraints"]        = "Transaction constraints: "
	tagTranslation["transactionRequired"]           = "Transaction required: "
	tagTranslation["transactionRequired","true"]    = "Yes"
	tagTranslation["transactionRequired","false"]   = "No"
	tagTranslation["undefinedValue"]                = "Undefined value: "
	tagTranslation["visibility"]                    = "Visibility: "
	tagTranslation["validValues"]                   = "Valid values: "
	tagTranslation["preliminary"]                   = "Preliminary: "
	#These two tags are handled separately as they are tied together:
	#tagTranslation["unit"]                          = "Unit: "
	#tagTranslation["multiplicationFactor"]          = "Multiplication factor: "

	#Undo actions
	revAction["addPath"]="removePath"                           ; revAction["removePath"]="addPath"
	revAction["addDhcpServerAddress"]="removeDhcpServerAddress" ; revAction["removeDhcpServerAddress"]="addDhcpServerAddress"
	revAction["setAutoActivate"]="setAutoDown"                  ; revAction["setAutoDown"]="setAutoActivate"
	revAction["activateRemoteSp"]="inactivateRemoteSp"          ; revAction["inactivateRemoteSp"]="activateRemoteSp"
	revAction["addRemoteSp"]="removeRemoteSp"                   ; revAction["removeRemoteSp"]="addRemoteSp"
	revAction["activate"]="deactivate"                          ; revAction["deactivate"]="activate"
	revAction["localInhibit"]="localUninhibit"                  ; revAction["localUninhibit"]="localInhibit"
	revAction["activateLinkSet"]="deactivateLinkSet"            ; revAction["deactivateLinkSet"]="activateLinkSet"
	revAction["blockSignalingRoute"]="deBlockSignalingRoute"    ; revAction["deBlockSignalingRoute"]="blockSignalingRoute"
	revAction["addRepertoire"]="deleteRepertoire"               ; revAction["deleteRepertoire"]="addRepertoire"
	revAction["addSlot"]="deleteSlot"                           ; revAction["deleteSlot"]="addSlot"
	revAction["addCicRange"]="removeCicRange"                   ; revAction["removeCicRange"]="addCicRange"
	revAction["addNri"]="removeNri"                             ; revAction["removeNri"]="addNri"
	revAction["addTdmTermGrpMos"]="removeTdmTermGrpMos"         ; revAction["removeTdmTermGrpMos"]="addTdmTermGrpMos"
	revAction["addSyncRefResource"]="removeSyncRefResource"     ; revAction["removeSyncRefResource"]="addSyncRefResource"
	revAction["addAal2ApToRc"]="removeAal2ApFromRc"             ; revAction["removeAal2ApFromRc"]="addAal2ApToRc"
	revAction["writeSystConst"]="resetSystConst"                ; revAction["resetSystConst"]="writeSystConst"
	revAction["writeConst"]="deleteConst"                       ; revAction["deleteConst"]="writeConst"
	revAction["addIpAccessHostMos"]="removeIpAccessHostMos"     ; revAction["removeIpAccessHostMos"]="addIpAccessHostMos"
	revAction["switch"]="switch"
	revAction["manualMspSwitch"]="manualMspSwitch"
	revAction["manualSwitch"]="manualSwitch"
	revAction["changeFrequency"]="changeFrequency"
	revAction["pnpChangeFrequency"]="pnpChangeFrequency"
	revAction["setFrequencyBand"]="setFrequencyBand"
	#Aal2PathDistributionUnit  addPath                            1:aal2PathVccTpId:sequence-moRef-Aal2PathVccTp
	#Aal2PathDistributionUnit  removePath                         1:aal2PathList:sequence-moRef-Aal2PathVccTp
	#Dhcp                      addDhcpServerAddress               1:ipAddressArray:sequence-string
	#Dhcp                      removeDhcpServerAddress            1:ipAddressArray:sequence-string
	#M3uAssociation            setAutoActivate                    0
	#M3uAssociation            setAutoDown                        0
	#M3uaLocalAs               activateRemoteSp                   1:remoteSp:moRef-M3uaRemoteSp
	#M3uaLocalAs               addRemoteSp                        1:remoteSp:moRef-M3uaRemoteSp
	#M3uaLocalAs               inactivateRemoteSp                 1:remoteSp:moRef-M3uaRemoteSp
	#M3uaLocalAs               removeRemoteSp                     1:remoteSp:moRef-M3uaRemoteSp
	#M3uaRemoteAs              addRemoteSp                        1:remoteSp:moRef-M3uaRemoteSp
	#M3uaRemoteAs              removeRemoteSp                     1:remoteSp:moRef-M3uaRemoteSp
	#Mtp3bSlAnsi               activate                           0
	#Mtp3bSlAnsi               deactivate                         0
	#Mtp3bSlAnsi               localInhibit                       0
	#Mtp3bSlAnsi               localUninhibit                     0
	#Mtp3bSlChina              activate                           0
	#Mtp3bSlChina              deactivate                         0
	#Mtp3bSlChina              localInhibit                       0
	#Mtp3bSlChina              localUninhibit                     0
	#Mtp3bSlItu                activate                           0
	#Mtp3bSlItu                deactivate                         0
	#Mtp3bSlItu                localInhibit                       0
	#Mtp3bSlItu                localUninhibit                     0
	#Mtp3bSlTtc                activate                           0
	#Mtp3bSlTtc                deactivate                         0
	#Mtp3bSls                  activateLinkSet                    0
	#Mtp3bSls                  deactivateLinkSet                  0
	#Mtp3bSr                   blockSignalingRoute                0
	#Mtp3bSr                   deBlockSignalingRoute              0
	#ReliableProgramUniter     switch                             0
	#SwAllocation              addRepertoire                      1:aRepertoire:moRef-Repertoire
	#SwAllocation              addSlot                            1:aSlot:moRef-ManagedObject
	#SwAllocation              deleteRepertoire                   1:aRepertoire:moRef-Repertoire
	#SwAllocation              deleteSlot                         1:aSlot:moRef-ManagedObject

	#for the stx table:
	#actualSpeedDuplex
	#0:NO_LINK, 1:ETH_1_GB_FULL, 2:ETH_10_GB_FULL, 3:ETH_40_GB_FULL
	#-> NOLINK, 1G_F , 10G_F , 40G_F
	#0:NO_LINK, 1:ETH_10_MB_HALF, 2:ETH_10_MB_FULL, 3:ETH_100_MB_HALF, 4:ETH_100_MB_FULL, 5:ETH_1000_MB_HALF, 6:ETH_1000_MB_FULL
	#-> NOLINK, 10M_H, 10M_F, 100M_H, 100M_F, 1G_H, 1G_F
	#EdgePortMode
	#0:ADMIN_EDGE_OFF, 1:AUTO_EDGE, 2:ADMIN_EDGE_ON, 3:ADMIN_EDGE_BPDU_GUARD, 4:ADMIN_EDGE_BPDU_FILTER
	#-> ADM_OFF, AUTO, ADM_ON, ADM_GUARD, ADM_FILTER
	#trafficType
	#0:NOT_USED, 1:SIGNALING, 2:PAYLOAD, 3:SIGNALING_AND_PAYLOAD, 4:SYNCHRONIZATION, 5:SIGNALING_AND_SYNCHRONIZATION, 6:PAYLOAD_AND_SYNCHRONIZATION, 7:SIGNALING_AND_PAYLOAD_AND_SYNCHRONIZATION, 8:OPERATION_AND_MAINTENENCE
	#-> NOTUSED, CP, UP, CP_UP, SYNC, CP_SYNC, UP_SYNC, CP_UP_SYNC, O&M
	#EthModSpeedDuplex                    1:ETH_1_GB_FULL, 2:ETH_10_GB_FULL, 3:ETH_40_GB_FULL
	#EthModSpeedDuplex2                   1:ETH_10_MB_HALF, 2:ETH_10_MB_FULL, 3:ETH_100_MB_HALF, 4:ETH_100_MB_FULL, 5:ETH_1_GB_HALF, 6:ETH_1_GB_FULL, 7:ETH_10_GB_FULL, 8:ETH_40_GB_FULL

	stxTable["1 (ETH_10_MB_HALF)"]="10M_H"
	stxTable["2 (ETH_10_MB_FULL)"]="10M_F"
	stxTable["3 (ETH_100_MB_HALF)"]="100M_H"
	stxTable["4 (ETH_100_MB_FULL)"]="100M_F"
	stxTable["5 (ETH_1_GB_HALF)"]="1G_H"
	stxTable["6 (ETH_1_GB_FULL)"]="1G_F"
	stxTable["7 (ETH_10_GB_FULL)"]="10G_F"
	stxTable["8 (ETH_40_GB_FULL)"]="40G_F"
	stxTable["0 (NO_LINK)"]="NOLINK"
	stxTable["1 (ETH_1_GB_FULL)"]="1G_F"
	stxTable["2 (ETH_10_GB_FULL)"]="10G_F"
	stxTable["3 (ETH_40_GB_FULL)"]="40G_F"
	stxTable["1 (ETH_10_MB_HALF)"]="10M_H"
	stxTable["2 (ETH_10_MB_FULL)"]="10M_F"
	stxTable["3 (ETH_100_MB_HALF)"]="100M_H"
	stxTable["4 (ETH_100_MB_FULL)"]="100M_F"
	stxTable["5 (ETH_1000_MB_HALF)"]="1G_H"
	stxTable["6 (ETH_1000_MB_FULL)"]="1G_F"
	stxTable["0 (ADMIN_EDGE_OFF)"]="EDGE_OFF"
	stxTable["1 (AUTO_EDGE)"]="AUTO_EDGE"
	stxTable["2 (ADMIN_EDGE_ON)"]="EDGE_ON"
	stxTable["3 (ADMIN_EDGE_BPDU_GUARD)"]="BPDU_GUARD"
	stxTable["4 (ADMIN_EDGE_BPDU_FILTER)"]="BPDU_FILTER"
	stxTable["ROJ1192315"]="MFX11"
	stxTable["ROJ1192316"]="MFX12"
	stxTable["ROJ1192317"]="MFX13"
	stxTable["ROJ1192399"]="MFX14"
	stxTable["0 (NOT_USED)"]="UNKNOWN"
	stxTable["1 (SIGNALING)"]="CP"
	stxTable["2 (PAYLOAD)"]="UP"
	stxTable["3 (SIGNALING_AND_PAYLOAD)"]="CP&UP"
	stxTable["4 (SYNCHRONIZATION)"]="SYNC"
	stxTable["5 (SIGNALING_AND_SYNCHRONIZATION)"]="CP&UP"
	stxTable["6 (PAYLOAD_AND_SYNCHRONIZATION)"]="UP&SYNC"
	stxTable["7 (SIGNALING_AND_PAYLOAD_AND_SYNCHRONIZATION)"]="CP&UP&SYNC"
	stxTable["8 (OPERATION_AND_MAINTENENCE)"]="O&M"
	stxTable["0 (ETHERNET_2_DIX)"]="2DIX"
	stxTable["1 (IEEE_802_3_LLC_SNAP)"]="SNAP"

	#for the dbc command WRNae89948
	#CPP
	sqlOldTable["ipcpetipfrotable_01"]        = "ipcpetmfgfrotable_01"
	sqlOldTable["ipadmhostfrobase_05"]        = "ipadmhostfroipv4_04"
	#WRBS
	sqlOldTable["ncclcontrolportresmgrc"]     = "lrsclcontrolportresmgrc"
	sqlOldTable["chcrrhhsdpaiubdata_1"]       = "eqcrrhhsdpaiubdata_2"
	sqlOldTable["ecsetdevsetmgtdata_1"]       = "eqcnehdevsetmgtdata_2"
	sqlOldTable["ecclimcabinetparams_3"]      = "eqcclimcabinetparams_2"
	sqlOldTable["ecnprsectordata_1"]          = "eqcnprsectordata_2"
	sqlOldTable["ecnehauxpiudata_8"]          = "eqcnehauxpiudata_7"
	sqlOldTable["ecnehpiumgtdata_2"]          = "eqcnehpiumgtdata_1"
	sqlOldTable["sccrcresmgrc_1"]             = "lrsrcrfaccessresmgrc_9"
	sqlOldTable["sccrcantennabranch_1"]       = "lrsrcrfapantennabranch_3"
	sqlOldTable["chcrrhomnodebdata_1"]        = "eqcrrhomnodebdata_1"
	sqlOldTable["chcrrhhscellparamdata_1"]    = "eqcrrhhsdpacellparamdata_1"
	sqlOldTable["sccrcretprofilehandlerc_1"]  = "lrsrcrfaprethandlerc_3_1"
	sqlOldTable["ecpcpossresourcemgrc_1"]     = "lrspcpossresourcemgrc_6"
	sqlOldTable["scccemdbid_1"]               = "bccemdbid_5"
	sqlOldTable["sccrccarrier_1"]             = "lrsrccellcarriermgrc_4"
	sqlOldTable["chchschmgrc_1"]              = "bclrshschmgrc_8"
	sqlOldTable["ecnprbatterydata_1"]         = "eqcnprbatterydata_1"
	sqlOldTable["ectstimingmanagerc_1"]       = "lrststimingmanagerc_2"
	sqlOldTable["ecnprexternaltmadata_1"]     = "eqcnprexternaltmadata_2"
	sqlOldTable["chchschrbsmgrc_1"]           = "bclrshschrbsmgrc_3"
	sqlOldTable["chcrrhhscellparamdata_2"]    = "chcrrhhscellparamdata_2_tmp"
	sqlOldTable["chcrrhhscellparamdata_3"]    = "chcrrhhscellparamdata_2"
	sqlOldTable["chcrrhbbpdata_1"]            = "eqcrrhbbpdata_3"
	sqlOldTable["ecnprantennabranchdata_3"]   = "eqcnprantennabranchdata_2"
	sqlOldTable["ecdevdevicedata_1"]          = "eqcnehdevicedata_2"
	sqlOldTable["ecxpuauxpiudata_1"]          = "ecnehauxpiudata_8"
	sqlOldTable["ecpcbatteryresourcemgrc_1"]  = "lrspcbatteryresourcemgrc_5"
	sqlOldTable["ecnproilcabledata_1"]        = "eqcnproilcabledata_2"
	sqlOldTable["ecnprrfcabledata_1"]         = "eqcnprrfcabledata_2"
	sqlOldTable["eqcnprslotdata_1"]           = "eqcbdhslotdata"
	sqlOldTable["ecxpupiumgtdata_1"]          = "ecnehpiumgtdata_3"
	sqlOldTable["ecgrpresmgrdata_1"]          = "eqcgrpresmgrdata_5"
	sqlOldTable["ecsetdevsetdata_1"]          = "eqcnehdevsetdata_2"
	sqlOldTable["ecdevmgtdata_1"]             = "eqcnehdevmgtdata_1"
	sqlOldTable["ecerhallocationtable_1"]     = "eqcrrhallocationtable_2"
	sqlOldTable["ecnehclimcabinetparams_1"]   = "eqcclimcabinetparams_4"
	sqlOldTable["ecnehrefmodeldata_1"]        = "eqcnehrefmodeldata_4"
	sqlOldTable["chchschiubmgrc_1"]           = "chcrrhhsdpaiubdata_1"

	#make tables lmid,upid,uptomom  --> made only when needed, to save memory. Only make the uptomom table
	#buildLmidTable()
       	parse_uptomom_file(uptomomdb)


	#Obsolete uservariables, now hardcoded
	#Path to the local folder on node where to put temporary COLI command files used by cab/lh/uer
	nodetempdir="/d/usr"        #used for lh and cab commands
	# List of MO's that shouldn't be followed in the lko/llko function. Not case sensitive. Must have a comma before and after !!
	dontfollowlist=",rncmodule,unisaalprofile,nnisaalprofile,atmtrafficdescriptor,pluginunit,reliableprogramuniter,Ranap,LocationArea,RoutingArea,ServiceArea,UtranCell,TimDevice,Etm4,Etm1,Aal2ap,NbapCommon,NbapDedicated,NodeSynch,Mtp2ProfileItu,Mtp2ProfileAnsi,Aal2QosProfile,Aal2QosCodePointProfile,Mtp2ProfileChina,AiDevice,Subrack,NodeSynchTp,TdmTermGrp,Slot,PiuType,Repertoire,"
	# List of MO's that should be followed in the lk/llk function via parent/child relationship.
	followlist="iublink,mtp3bsls,iub"
	# Display progress during lt/lc command
	# 0 = progress is printed, each LDN being loaded is printed on the line
	# 1 = no progress is printed until the command is completed where a summary line will be printed
	PrintProxySilent=1
	# Output of lt/lc commands. Only applies when the variable PrintProxySilent is set to 0
	# 0 = print only proxy number
	# 1 = print LDN and proxy number)
	PrintProxyLDN=1
	# Path to target monitor loadmodule and targetmonitor type. Only applicable to CPP <= 5.0
	target_monitor_6054=commonjardir"/CXC1326054_R1D01"
	target_monitor_33077=commonjardir"/CXC33077_R5A08"
	target_monitor_type=1
	# Ask for attribute type.
	# If 0, attribute type will be automatically entered in the cr and actc commands.
	# If 1, attribute type must be entered manually
	ask_for_attribute_type=0
	# Path to the command log for "lgo" command in CPP4
	commandlog_path="/c/commandlog"
	# define some default aliases
	$0="alias ombat run "commonjardir"/scripts/ombat/ombat.mos" ; alias("add","silent")
	$0="alias teall te e check error enter return info trace1 trace2 trace3 trace4 trace5 trace6 trace7 trace8 trace9 state_change bus_send bus_receive rec_sig send_sig param interface object user1 user2 user3 user4" ; alias("add","silent")
}
function Define_com_mos(  i,tmp)
{
	if (comcli==0) return
	delete cppMoList
	delete com_moclass_list
	delete dupMocList
	hasDupMocs=0
	for (i in mom_moclass_list)
	{
		if (tolower(i) ~ /^(com|ecim)/) { cppMoList[i]=1 ; cppMoList[tolower(i)]=1 }
		if (length(i) > maxLength["mo"]) maxLength["mo"]=length(i)
		tmp=gensub(/^.*\./,"",1,i)
		if (length(tmp) > maxLength["smallmo"]) maxLength["smallmo"]=length(tmp)
		if (tmp in com_moclass_list && com_moclass_list[tmp]==tmp)
		{
			#dont count as duplicate if one of the duplicate class is deprecated
			if (!(exclude_deprecated>=2 && class_description[i] ~ /Deprecated: /)) { hasDupMocs=1 ; dupMocList[tmp]=tmp }
		}
		#if (class_description[i] ~ /Deprecated: /) print i
		if (!(exclude_deprecated>=2 && class_description[i] ~ /Deprecated: /))
		{
			com_moclass_list[tolower(tmp)]=tmp
			com_moclass_list[tmp]=tmp
		}
	}
	for (i in derived_type)
	{
		if (length(i) > maxLength["derived"]) maxLength["derived"]=length(i)
	}
	for (i in MoAttributesType)
	{
		if (length(MoAttributesType[i]) > maxLength["type"]) maxLength["type"]=length(MoAttributesType[i])
	}
	for (i in enum_description)
	{
		if (length(i) > maxLength["enum"]) maxLength["enum"]=length(i)
	}
	for (i in struct_contents)
	{
		if (length(i) > maxLength["struct"]) maxLength["struct"]=length(i)
	}
	for (i in MoAttributesType)
	{
		if (MoAttributesTypeJava[i]=="") MoAttributesTypeJava[i]=convert_attribute_types(MoAttributesType[i])
	}
}
function Define_cppmos(  cppmolist)
{
	if (comcli>0) return
	delete cppMoList
	cppmolist=sprintf("%s/cppmolist.txt",commonjardir)
	close(cppmolist)
	if (fileOps("test -f "cppmolist)!=0) { customPrint("Error: file "cppmolist" not found!") ; return }
	while (getline < cppmolist)
	{
		gsub("\r","")
		cppMoList[$1]=1
		cppMoList[tolower($1)]=1
	}
	close(cppmolist)
}
function Define_pm_menus()
{
	if (multi)
	{
		pmMenu[1]=101
		pmMenu[2]=102
		pmMenu[3]=103
		pmMenu[31]=131
		pmMenu[32]=132  #not yet supported in multimode
		pmMenu[4]=104
		pmMenu[5]=105
		pmMenu[6]=106
		pmMenu[7]=107
		pmMenu[8]=108
		pmMenu[10]=9
		pmStop="Enter_choice_or_type_8_for_help"
	}
	else
	{
		pmMenu[1]=1
		pmMenu[2]=2
		pmMenu[3]=3
		pmMenu[31]=31
		pmMenu[32]=32
		pmMenu[33]=33
		pmMenu[4]=4
		pmMenu[5]=5
		pmMenu[6]=6
		pmMenu[7]=7
		pmMenu[8]=8
		pmMenu[10]=10
		pmStop="Enter_choice_or_type_9_for_help"
	}
}
function define_rcs_logs()
{
	delete rcsLogName
	rcsLogName["al"]="(AlarmLog)$"
	rcsLogName["upg"]="(SwmLog)$"
	rcsLogName["a_t"]=rcsLogName["atr"]="(AuditTrailLog)$"
	rcsLogName["hw"]="(AiLog)$"
	rcsLogName["sec"]="(SecurityLog)$"
	rcsLogName["ipc"]="(TnNetworkLog)$"
	rcsLogName["rlib"]="(TnApplicationLog)$"
	rcsLogName["bgf"]="(BatteryLog)$"
	rcsLogName["ipcs"]="(OotLog)$"
}
function setreservedby(proxy,attribute,value,   moclass,i,last,array,element)
{
	if (!(p2s("MoType",proxy)":"attribute in MoAttributesTypeJava)) return
	if (MoAttributesTypeJava[p2s("MoType",proxy)":"attribute] !~/^a?r$/) return
	if (value !~ /^[0-9,]+$/) return
	last=split(value,array,",")
	for (i=1;i<=last;i++)
	{
		if (array[i] !~ /^[0-9]+$/) continue
		moclass=p2s("MoType",array[i])
		if (!(moclass":reservedBy" in MoAttributesTypeJava)) continue
		if (MoAttributesTypeJava[moclass":reservedBy"]=="r") mib_table[array[i],"reservedBy"]=Ldn[proxy]
		else if (MoAttributesTypeJava[moclass":reservedBy"]=="ar" && mib_table[array[i],"reservedBy"]!~sprintf("%s($|\n)",p2s("Mo",proxy)))
		{
			mib_table[array[i],"reservedBy"]=mib_table[array[i],"reservedBy"]"\n >>> reservedBy = "Ldn[proxy]
			match(mib_table[array[i],"reservedBy"],/^\[([0-9]+)\] =/,element)
			sub(/^\[[0-9]+\]/,"["++element[1]"]",mib_table[array[i],"reservedBy"])
		}
	}
}

function make_mib_value(proxy,attribute,value,   type,moclass,array,j,element,z,word,i,structreference)
{
	setreservedby(proxy,attribute,value)
	#convert from a value format to be sent to the node to a value format for the offline mib_table
	moclass=p2s("MoType",proxy)
	type=MoAttributesType[moclass":"attribute]
	if (type ~ /^enumRef:/)
	{
		if (value ~ /^-?[0-9]+$/) value=parse_attribute(moclass,attribute,value)
		else if (value ~ /^[A-Z]/)
		{
			match(enum_contents[gensub(/^.*:/,"",1,type)],sprintf("([0-9]+):%s(,|$)",value),array)
			value=array[1]" ("value")"
		}
	}
	else if (type ~ /^moRef/) value=(comcli==0 || value~/^[-0-9]+$/?p2s("LdnMo",value):giveLdn(value))
	else if (type ~ /^sequence:moRef/)
	{
		last=split(value,array,(comcli==0 || value~/^[-,0-9]+$/?",":" "))
		value="["last"] = "
		for (j=1;j<=last;j++) value=value"\n >>> "attribute" = "(comcli==0 || array[j]~/^[-0-9]+$/?p2s("LdnMo",array[j]):giveLdn(array[j]))
	}
	else if (type ~ /^structRef/)
	{
		#note: special handling for struct with moref:
		#comcli:
		#groupRef="ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=SynchronizationCounterGroup"
		#measurementTypeRef="ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=SynchronizationCounterGroup,MeasurementType=pmMaxDelayVariation"
		#cpp:
		#eutranFrequencyRef:r=1289,reportConfigEUtraIntraFreqPmRef:r=1368
		structreference=gensub(/^structRef:/,"",1,type)
		if (comcli>0 && structreference in struct_with_moref && struct_with_moref[structreference]!="")
		{
			last=split(value,array,"\n")
			value="Struct{"last"}"
			for (j=1;j<=last;j++)
			{
				value=value"\n >>> "j"."gensub(/=.*$/,"",1,array[j])" = "gensub(/^[^=]+=["]?|["]*$/,"","g",array[j])
			}
		}
		else
		{
			last=split(value,array,(comcli>0?"\n":","))
			value="Struct{"last"}"
			for (j=1;j<=last;j++)
			{
				split(array[j],element,"=")
				if (structreference in struct_with_moref && struct_with_moref[structreference]!="")
				{
					value=value"\n >>> "j"."gensub(/:.*$/,"",1,element[1])" = "p2s("FdnMo",gensub(/^[^=]+=/,"",1,array[j]))
				}
				else
				{
					value=value"\n"translate_enum_in_struct(moclass,attribute," >>> "j"."gensub(/:.*$/,"",1,element[1])" = "gensub(/^[^=]+=/,"",1,array[j]),gensub(/^[^=]+=/,"",1,array[j]))
				}
			}
		}
	}
	else if (type ~ /^sequence:struct/)
	{
		last=split(value,array,";")
		value="t["last"] = "
		for (j=1;j<=last;j++)
		{
			z=split(array[j],element,",")
			value=value"\n >>> Struct["(j-1)"]  has "z" members:"
			for (i=1;i<=z;i++)
			{
				split(element[i],word,"=")
				value=value"\n >>> "i"."gensub(/:.*$/,"",1,word[1])" = "gensub(/^[^=]+=/,"",1,element[i])
			}
		}
	}
	else if (type ~ /^sequence:/)
	{
		last=split(value,array,/[, ]/)
		value=gensub(/^a/,"",1,MoAttributesTypeJava[moclass":"attribute])"["last"] = "
		for (j=1;j<=last;j++) value=value array[j]" "
	}
	if (translate_sequence_enum==1 && type ~ /^sequence:enumRef/) value=parse_attribute(moclass,attribute,value)
	return value
}
function unmake_mib_value(proxy,attribute,value,comnode,   last,i,array,tprox,array2,oldval)
{
	#if (mosdebug==1) print "unmake_mib_value: "proxy,attribute,value
	#convert from a value format for the offline mib_table to a value format to be sent to the node
	oldval=value
	moclass=p2s("MoType",proxy)
	type=MoAttributesType[moclass":"attribute]
	if (type ~ /^enumRef:/) value=gensub(/ \(.*$/,"",1,value)
	else if (type ~ /^moRef/)
	{
		if (!(comcli>0 && value==""))
		{
			value=giveMoProxy(value,"","ignorecase")
			if (comnode==1) value=p2s("Mo",value)
		}
	}
	else if (type ~ /^sequence:moRef/)
	{
		# >>> packetDataRouterRef = SubNetwork=ONRM_ROOT_MO_R,SubNetwork=RNC309,MeContext=RNC309,ManagedElement=1,Equipment=1,SpDevicePool=PdrDevice,PdrDevice=1,PacketDataRouter=1
		last=split(value,array,"\n")
		if (last <= 1)
		{
			if (comnode==1) value=""
			else value=-1
		}
		else
		{
			value=""
			for (i=2;i<=last;i++)
			{
				if (array[i]~"=")
				{
					split(array[i],array2," ")
					if (array2[4] !~ "=") continue
					tprox=giveMoProxy(array2[4],"","ignorecase")
					if (comnode==1) value=value" "p2s("Mo",tprox)
					else value=value","tprox
				}
			}
			sub(/^,/,"",value)
		}
	}
	else if (type ~ /^structRef/)
	{
		last=split(value,array,"\n")
		value=""
		for (j=2;j<=last;j++)
		{
			value=value","gensub(/^ >>> [0-9]+\.| =.*$/,"","g",array[j])"="gensub(/^[^=]+= /,"",1,array[j])
			if (comnode==1) sub(/ \([^)]+\)$/,"",value)
		}
		sub(/^,/,"",value)
	}
	else if (type ~ /^sequence:/)
	{
		last=split(value,array," ")
		value=""
		for (j=3;j<=last;j++) value=value","array[j]
		sub(/^,/,"",value)
	}
	if (mosdebug==1) print "unmake_mib_value: "proxy,attribute,type,oldval" -> "value
	return value
}
function inputAttribute(value,type,attrTable,restricted,Me,attribute,motype,option,inputPrefix,    \
abort,last,array,j,k,comb,subcomb,substruct,l,what,extra,val,theprompt,theprefix,z,a,m,fulltype,tenum)
{
	fulltype=type
	#attrTable["value"] and attrTable["type"] is the output from the function
	delete attrTable
	if (option=="e")
	{
		if (multi) motype=sprintf("%s%s%s",momVersion[Me],SUBSEP,motype)
		if (sprintf("%s%s%s",motype,SUBSEP,attribute) in attr_range && attr_range[motype,attribute]!="") extra=" ["gensub(" to ","..",1,gensub(/^ *| *$/,"","g",attr_range[motype,attribute]))"]"
		if (restricted=="restricted" && sprintf("%s%s%s",motype,SUBSEP,attribute) in attr_default && attr_default[motype,attribute]!="") extra=extra" (default="gensub(/ \(/,":",1,gensub(/\)/,"",1,attr_default[motype,attribute]))")"
		#if (extra!="") customPrint(extra,"","","noLF")
		#print motype,attribute,attr_range[motype,attribute],attr_default[motype,attribute]
		if (multi) sub(sprintf("^.*%s",SUBSEP),"",motype)
	}
	#customPrint(sprintf(" (%s): ",type),"","","noLF")
	theprefix=sprintf("%s%s (%s): ",inputPrefix,extra,type)
	if (tolower(type) ~ /^moref[:\-]/)
	{
		#customPrint(sprintf("\n   Enter mo LDN: "),"","","noLF")
		value=Read_Answer("","","","","","",sprintf(theprefix"\n   Enter mo LDN: "))
		if (!(restricted =="restricted" && tolower(value) == "d"))
		{
			if (tolower(value) ~ /^(null|)$/) value = -1
			else value=giveMoProxy(value,"","ignorecase",Me)
		}
		type=convert_attribute_types(type)
	}
	else if (tolower(type) ~ /sequence.moref/)
	{
		#customPrint(sprintf("\n   Enter LDN, or sequence of LDNs (separated by spaces): "),"","","noLF")
		value=Read_Answer("","","","","","",sprintf(theprefix"\n   Enter LDN, or sequence of LDNs (separated by spaces): "))
		if (!(restricted =="restricted" && tolower(value) == "d"))
		{
			if (tolower(value) != "null")
			{
				last=split(value,array," ")
				value=""
				for (j=1;j<=last;j++)
				{
					value=value","giveMoProxy(array[j],"","ignorecase",Me)
				}
				value=gensub(/^,/,"","g",value)
			}
		}
		type=convert_attribute_types(type)
	}
	else if (tolower(type) ~ /^structref[:\-]/)
	{
		structreference=gensub(/^.*[:\-]/,"","g",type)
		type=convert_attribute_types(type)
		if (option=="e")
		{
			#customPrint("")
			customPrint(theprefix)
			theprefix=""
			value=""
			if (multi) structreference=sprintf("%s%s%s",momVersion[Me],SUBSEP,structreference)
			last=split(struct_contents[structreference],array,",")
			for (j=1;j<=last;j++)
			{
				extra=sprintf("       Element %s of %s, %s",j,last,array[j])
				if (sprintf("%s%s%s",structreference,SUBSEP,array[j]) in attr_range && attr_range[structreference,array[j]]!="") extra=extra" ["gensub(" to ","..",1,gensub(/^ *| *$/,"","g",attr_range[structreference,array[j]]))"]"
				if (sprintf("%s%s%s",structreference,SUBSEP,array[j]) in attr_default && attr_default[structreference,array[j]]!="") extra=extra" (default: "attr_default[structreference,array[j]]")"
				extra=extra" ("struct_type[structreference,array[j]]
				if (struct_type[structreference,array[j]] ~ /enumRef/)
				{
					what=gensub(/^.*[:\-]/,"",1,struct_type[structreference,array[j]])
					if (multi) what=sprintf("%s%s%s",momVersion[Me],SUBSEP,what)
					extra=extra" "enum_contents[what]
				}
				#customPrint(extra"): ","","","noLF")
				if (array[j]~/^(challengePassword|password)$/) val=Read_Answer("","","","","hide","",extra"): ")
				else val=Read_Answer("","","","","","",extra"): ")
				if (val=="" || (restricted=="restricted" && tolower(val)=="d")) { value=val ; break}
				if (struct_type[structreference,array[j]] ~ /^(sequence:)?moRef/)
				{
					if (!(restricted =="restricted" && tolower(value) == "d"))
					{
						if (tolower(val) ~ /^(null|)$/) val = -1
						else if (tolower(struct_type[structreference,array[j]]) ~ /^moref[:\-]/) val=giveMoProxy(val,"","ignorecase",Me)
						else
						{
							z=split(val,a,/[ ;]/)
							val=""
							for (m=1;m<=z;m++)
							{
								if (a[m]!~/.+=.+/) continue
								val=val" "giveMoProxy(a[m],"","ignorecase",Me)
								sub(/^ /,"",val)
							}
						}
					}
				}
				else if (val ~ /^.+=.+,/) gsub(/,/,"",val)  #in case the struct members is a string containing commas but is not an LDN
				value=value","array[j]"="val
			}
			sub(/^,/,"",value)
			if (multi) sub(sprintf("^.*%s",SUBSEP),"",structreference)
		}
		else
		{
			#format should be: sib11repperiod:i=2,sib11startpos:i=4
			#                  sib11repperiod=2,sib11startpos=4
			#struct_type[sib11,sib11repperiod]=long
			#struct_type[sib11,sib11repmax]=long
			value=Read_Answer("","","","","","",theprefix)
		}
		if (!(restricted =="restricted" && tolower(value) == "d"))
		{
			value=parse_struct(value,structreference,Me)
			#print "attvalue: "value
		}
	}
	else if (tolower(type) ~ /^sequence[:\-]structref[:\-]/)
	{
		value=Read_Answer("","","","","","",theprefix)
		structreference=gensub(/^.*[:\-]/,"","g",type)
		type=convert_attribute_types(type)
		if (!(restricted =="restricted" && tolower(value) == "d"))
		{
			last=split(value,array,";")
			value=""
			for (j=1;j<=last;j++)
			{
				value=value";"parse_struct(array[j],structreference,Me)
			}
			value=gensub(/^;/,"",1,value)
		}
	}
	else
	{
		theprompt=""
		if (tolower(type) ~ /sequence[:\-]/ && tolower(type) !~ /struct/)
		{
			#customPrint(sprintf("\n   Enter value or sequence of values, separated by \",\": "),"","","noLF")
			theprompt=sprintf("\n   Enter value or sequence of values, separated by \",\": ")
		}
		else if (tolower(type) ~ /enumref/)
		{
			what=gensub(/^.*[:\-]/,"",1,type)
			if (multi) what=sprintf("%s%s%s",momVersion[Me],SUBSEP,what)
			#customPrint(sprintf("\n   Enter one of the following integers: %s: ",enum_contents[what]),"","","noLF")
			theprompt=sprintf("\n   Enter one of the following integers: %s: ",enum_contents[what])
		}
		if (attribute ~ /^(password|ftpServerPassword|uriPassword|challengePassword)$/) value=Read_Answer("","","","","hide","",theprefix theprompt)
		else value=Read_Answer("","","","","","",theprefix theprompt)
		if (comcli>0 && type ~ /^enumRef/ && value!~/^(-?[0-9]+|d)$/)
		{
			#in COM, the enum can be entered in text format instead of integer, we convert it to integer
			tenum=gensub(/^enumRef./,"",1,type)
			if ((tenum,value) in enum && enum[tenum,value]!="") value=enum[tenum,value]
		}
		if (ask_for_attribute_type==1)
		{
			#customPrint(sprintf("   Enter Type (Integer|Long|Float|String|Boolean|Ref|sTruct): "),"","","noLF")
			theprompt=sprintf("   Enter Type (Integer|Long|Float|String|Boolean|Ref|sTruct): ")
			type=Read_Answer("","","","","","",theprefix theprompt)
		}
		else type=convert_attribute_types(type)
		if (tolower(type) == "ai" && value ~ /[0-9]+-[0-9]+/) value=expand_integer(value)
	}
	if (tolower(value)=="null" && tolower(type) ~ /^(a*s|ar)$/ && attribute!="challengePassword")
	{
		#to be able to enter empty strings or empty array of mo
		#but action NodeCredential.startOnlineEnrollment() must support giving the challengePassword as a literal "null"
		attrTable["value"]=""
		attrTable["type"]=type
	}
	else if (comcli>0 && value=="" && tolower(type) ~ /^a*s$/) #to be able to enter empty strings in com nodes on mandatory attributes
	{
		attrTable["value"]=""
		attrTable["type"]=type
	}
	else if (value=="" || tolower(type) !~ /^a*[ilfsbrt]$/)
	{
		abort=1
		if (value=="")
		{
			customPrint("Empty value! Aborting...")
			add_to_moscomlog("","%@> Fail (Command aborted)")
		}
		if (tolower(type) !~ /^a*[ilfsbrt]$/) customPrint("Incorrect type! Aborting...")
	}
	else if ((tolower(type) ~ /^[il]$/ && value !~ /^(-?[0-9]+|d)$/)||\
	         (tolower(type) == "b" && tolower(value) !~ /^(d|true|false)$/))
	{
		abort=1
		customPrint("Incorrect value! Aborting...")
	}
	else
	{
		attrTable["value"]=value
		attrTable["type"]=type
	}
	if (mosdebug==1) print "value="attrTable["value"],"type="attrTable["type"]
	return abort
}
function processAttribute(value,type,attrTable,restricted,Me,attribute,motype,    \
abort,last,array,j,k,comb,subcomb,substruct,l,what,extra,val,theprompt,theprefix,fulltype)
{
	fulltype=type
	#attrTable["value"] and attrTable["type"] is the output from the function
	delete attrTable

	#It is supported to set non-mandatory attributes to "d", means default. Then they will not be included in the create command
	if (value=="d")
	{
		attrTable["value"]="d"
		attrTable["type"]=type
		return ""
	}

	if (tolower(type) ~ /^moref[:\-]/)
	{
		if (tolower(value) ~ /^(null|)$/) value = -1
		else value=giveMoProxy(value,"","ignorecase",Me)
	}
	else if (tolower(type) ~ /sequence.moref/)
	{
		if (tolower(value) != "null")
		{
			last=split(value,array," ")
			value=""
			for (j=1;j<=last;j++)
			{
				value=value","giveMoProxy(array[j],"","ignorecase",Me)
			}
			value=gensub(/^,/,"","g",value)
		}
	}
	else if (tolower(type) ~ /^structref[:\-]/)
	{
		structreference=gensub(/^.*[:\-]/,"","g",type)
		value=parse_struct(value,structreference,Me)
	}
	else if (tolower(type) ~ /^sequence[:\-]structref[:\-]/)
	{
		structreference=gensub(/^.*[:\-]/,"","g",type)
		last=split(value,array,";")
		value=""
		for (j=1;j<=last;j++)
		{
			value=value";"parse_struct(array[j],structreference,Me)
		}
		value=gensub(/^;/,"",1,value)
	}
	type=convert_attribute_types(type)
	if (tolower(type) == "ai" && value ~ /[0-9]+-[0-9]+/) value=expand_integer(value)
	#In CPP an attribute of type string or type sequence can have empty value
	#In COM almost any attribute type can have an empty value
	if (value~/^(|null)$/ && (tolower(type) ~ /^[as]/ || comcli>0))
	{
		attrTable["value"]=""
		attrTable["type"]=type
	}
	else if (value=="" || tolower(type) !~ /^a*[ilfsbrt]$/)
	{
		abort=1
		if (value=="") customPrint("Empty value! Aborting...")
		else if (tolower(type) !~ /^a*[ilfsbrt]$/) customPrint("Incorrect type! Aborting...")
	}
	else if ((tolower(type) ~ /^[il]$/ && value !~ /^(-?[0-9]+)$/)||\
	         (tolower(type) == "b" && tolower(value) !~ /^(true|false)$/))
	{
		if (!(comcli>0 && fulltype ~ /^enumRef/)) #in COM it is ok to enter the enum name
		{
			abort=1
			customPrint("Incorrect value! Aborting...")
		}
		#print attribute,type,value
	}
	else
	{
		attrTable["value"]=value
		attrTable["type"]=type
	}
	if (mosdebug==1) print "value="attrTable["value"],"type="attrTable["type"]
	return abort
}
function expand_integer(Value,    array,b,j,k,last,start,stop)
{
	#to convert from 1,2,3,9-12,16
	#to : 1,2,3,9,10,11,12,16
	if (Value ~ /[0-9]+-[0-9]+/)
	{
		last=split(Value,array,/[, ]/)
		Value=""
		for (j=1;j<=last;j++)
		{
			if (array[j] ~ /^[0-9]+$/) Value=Value","array[j]
			else if (array[j] ~ /^[0-9]+-[0-9]+$/)
			{
				split(array[j],b,"-")
				if (b[2]>=b[1]) { start=b[1] ; stop=b[2] }
				else { start=b[2] ; stop=b[1] }
				for (k=start;k<=stop;k++) Value=Value","k
			}
		}
		sub(/^,/,"",Value)
	}
	return Value
}
function parse_struct(Value,structreference,Me,    k,comb,last,array,l,substruct,subcomb,tmp_class,tmp_val,t_type,sep,brray,j,last2,quotesign,invalidMember,invalidMemberList,origValue,colorstart,colorend,z,arr)
{
	if (comcli>0 && Value ~ /^.+=.+\n.+/) return Value  #means that this struct has already been processed by parse_struct before, eg in the case of "cr" command which parses the struct at inputAttribute, then again before sending the values
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	if (mosdebug==1) print "parse_struct: structreference="structreference" Value="Value
	if (multi)
	{
		if ((momVersion[Me],structreference) in struct_with_moref && struct_with_moref[momVersion[Me],structreference]!="") return parse_struct_moref(Value,structreference,Me)
		structreference=sprintf("%s%s%s",momVersion[Me],SUBSEP,structreference)
	}
	else if (structreference in struct_with_moref && struct_with_moref[structreference]!="") return parse_struct_moref(Value,structreference,Me)
	split(struct_contents[structreference],substruct,",")
	if (comcli>0)
	{
		#special case in case the format of a struct member of type sequence would be like [false,false,false] instead of false false false
		for (z in substruct)
		{
			if (struct_type[structreference,substruct[z]]~/^sequence:/ && Value~sprintf("%s=\\[",substruct[z]))
			{
				match(Value,sprintf("%s=\\[([^]]+)\\]",substruct[z]),arr)
				sub(sprintf("%s=\\[([^]]+)\\]",substruct[z]),sprintf("%s=%s",substruct[z],gensub(/["]?,["]?/," ","g",arr[1])),Value)
			}
		}
	}
	last=split(Value,array,",")
	origValue=Value
	Value=""
	for (l=1;l<=last;l++)
	{
		tmp_class=gensub(/=.*$|:.*$/,"","g",array[l])  #eg: if we wrote: productnumber=xxx or productnumber:s=xxx
		sub(/^[ \t]*/,"",tmp_class)   #eg: if there were some spaces in front of the struct member name
		tmp_val=gensub(/^[^=]+=/,"","g",array[l])
		if (comcli==0)
		{
			if (tmp_val ~ "=") gsub("=","`",tmp_val)
			if (tmp_val ~ ":") gsub(":","^",tmp_val)
		}
		invalidMember[tmp_class]=1
		for (k in substruct)
		{
			if (tolower(substruct[k])==tolower(tmp_class))
			{
				delete invalidMember[tmp_class]
				t_type=struct_type[structreference,substruct[k]]
				if (comcli>0)
				{
					#a enum inside a struct member must be given as its translation not the integer, and also must not have quotes
					if (t_type ~ /^enumRef/)
					{
						 if (tmp_val ~ /^-?[0-9]+$/ && (gensub(/^enumRef./,"",1,t_type),tmp_val) in enum) tmp_val=enum[gensub(/^enumRef./,"",1,t_type),tmp_val]
					}
					#boolean and integers must not have quotes
					else if (t_type ~ /^(bool|u?int)/) {}
					else if (t_type ~ /^derivedRef:/ && gensub(/^[^:]+:/,"",1,t_type) in derived_type && derived_type[gensub(/^[^:]+:/,"",1,t_type)] ~ /^u?int/) {}
					else if (t_type ~ /^sequence:/)
					{
						#elements in sequence:moRef can be separated by spaces or semicolons
						if (t_type ~ /^sequence:moRef/)
						{
							if (tmp_val !~ /[^ ]+ +[^ ]+/ && tmp_val ~ /;/) sep=";"
							else sep=" "
						}
						#elements in other types of sequences are separated by spaces or commas
						else sep="[ ,]"
						last2=split(tmp_val,brray,sep)
						tmp_val="["
						for (j=1;j<=last2;j++)
						{
							if (brray[j]=="") continue
							quotesign="\""
							if ((t_type ~ /^sequence:(bool|enumRef|u?int)/)||(t_type ~ /^sequence:derivedRef:/ && gensub(/^[^:]+:/,"",1,t_type) in derived_type && derived_type[gensub(/^[^:]+:/,"",1,t_type)] ~ /^u?int/)) quotesign=""
							tmp_val=sprintf("%s%s%s%s,",tmp_val,quotesign,com_process_value(gensub(/[ \"]/,"","g",brray[j]),gensub(/^sequence:/,"",1,t_type),"noquotes"),quotesign)
						}
						tmp_val=gensub(/,$/,"",1,tmp_val)"]"
					}
					#all other types will have quotes around the value
					else tmp_val=sprintf("\"%s\"",tmp_val)
					if (t_type ~ /\.EcimEmpty$/)
					{
						if (tolower(tmp_val)~"true") Value=sprintf("%s\n%s",Value,substruct[k])
					}
					else Value=sprintf("%s\n%s=%s",Value,substruct[k],tmp_val)
				}
				else Value=sprintf("%s,%s:%s=%s",Value,substruct[k],convert_attribute_types(t_type),tmp_val)
			}
		}
	}
	if (comcli>0)
	{
		sub(/^\n/,"",Value)
		if (structreference ~ /\.EcimPassword$/)
		{
			#We put ECIMPW=<val>\nECIMPW so that when the parse_struct function is run several times in a row, it can see that it already parsed this
			if (Value ~ /cleartext/) Value="ECIMPW="gensub(/^.*password=|\n|cleartext/,"","g",Value)" cleartext\nECIMPW"
			else Value="ECIMPW="gensub(/^.*password=|\n|cleartext/,"","g",Value)"\nECIMPW"
		}
	}
	else sub(/^,/,"",Value)
	if (mosdebug==1) print "parse_struct result: Value="Value
	for (k in invalidMember) invalidMemberList=invalidMemberList","k
	sub(/^,/,"",invalidMemberList)
	if (invalidMemberList!="") customPrint(sprintf("%sWarning:%s the struct value %s contains some invalid members: %s",colorstart,colorend,origValue,invalidMemberList))
	return Value
}
function parse_struct_moref(Value,structreference,Me,    k,comb,last,array,l,substruct,subcomb,tmp_class,tmp_val,structMembers,tmp_type,theval,sep,tmp_fulltype,j,last2,brray,quotesign)
{
	#special case of struct with moref where there will be only one member, eg DMXC_T_L3_InterfaceIPv4.Encapsulation
	#we dont re-parse it if it looks like it already has the correct format
	if (comcli>0 && structreference~/^DMXC_T_L3_InterfaceIPv[46]\.Encapsulation$/ && Value~/^ref=\"ManagedElement/ && Value!~/loopback/) return Value
	if (comcli>0 && structreference~/\.MeasurementSpecification$/ && Value~/Ref=\"ManagedElement/) return Value

	if (mosdebug==1) print "parse_struct_with_moref: structreference="structreference" Value="Value
	#used for struct that have members of type moRef
	#this function should work for all types of struct but has not been tested so we use it only on the structs that contain moref for the time being (e.g. PmUeMeasIntraFreq and UtranFreqToQciProfileRelation)
	if (multi) structreference=sprintf("%s%s%s",momVersion[Me],SUBSEP,structreference)
	split(struct_contents[structreference],substruct,",")
	for (l in substruct) structMembers[tolower(substruct[l])]=substruct[l]
	last=split(Value,array,",")
	Value=""
	for (l=1;l<=last;l++)
	{
		#print array[l]
		tmp_class=gensub(/=.*$|:.*$/,"","g",array[l])  #eg: if we wrote: productnumber=xxx or productnumber:s=xxx
		tmp_loclass=tolower(tmp_class)
		if (tmp_loclass in structMembers && structMembers[tmp_loclass]!="")
		{
			tmp_fulltype=struct_type[structreference,structMembers[tmp_loclass]]
			tmp_type=convert_attribute_types(tmp_fulltype)
		}
		tmp_val=gensub(/^[^=]+=/,"","g",array[l])
		#print "structreference="structreference",tmp_loclass="tmp_loclass",structMembers[tmp_loclass]="structMembers[tmp_loclass]",tmp_type="tmp_type",tmp_val="tmp_val,"tmp_fulltype="tmp_fulltype
		if (tmp_type !~ "r" && tmp_val ~ "=") gsub("=","`",tmp_val)
		if (tmp_val ~ ":") gsub(":","^",tmp_val)
		if (tmp_loclass in structMembers && structMembers[tmp_loclass]!="")
		{
			if (comcli>0)
			{
				#if (mosdebug==1) print "tmp_val="tmp_val"x"p2s("LdnMo",tmp_val)"$"
				theval=tmp_val
				if (tmp_type ~ /^a/)
				{
					#elements in sequence:moRef can be separated by spaces or semicolons
					if (tmp_type ~ /^ar/)
					{
						if (theval !~ /[^ ]+ +[^ ]+/ && theval ~ /;/) sep=";"
						else sep=" "
					}
					#elements in other types of sequences are separated by spaces or commas
					else sep="[ ,]"
					last2=split(theval,brray,sep)
					theval="["
					for (j=1;j<=last2;j++)
					{
						if (brray[j]=="") continue
						quotesign="\""
						if ((tmp_fulltype ~ /^sequence:(bool|enumRef|u?int)/)||(tmp_fulltype ~ /^sequence:derivedRef:/ && gensub(/^sequence:derivedRef:/,"",1,tmp_fulltype) in derived_type && derived_type[gensub(/^sequence:derivedRef:/,"",1,tmp_fulltype)] ~ /^u?int/)) quotesign=""
						theval=sprintf("%s%s%s%s,",theval,quotesign,com_process_value(gensub(/[ \"]/,"","g",brray[j]),gensub(/^sequence:/,"",1,tmp_fulltype),"noquotes"),quotesign)
					}
					theval=gensub(/,$/,"",1,theval)"]"
				}
				else if (tmp_type ~ "r" && tmp_val ~ /^[0-9]+$/) theval=sprintf("\"%s\"",p2s("LdnMo",tmp_val))
				#a enum inside a struct member must be given as its translation not the integer, and also must not have quotes
				else if (tmp_fulltype ~ /^enumRef/ && tmp_val ~ /^-?[0-9]+$/ && (gensub(/^enumRef./,"",1,tmp_fulltype),tmp_val) in enum) theval=enum[gensub(/^enumRef./,"",1,tmp_fulltype),tmp_val]
				else if (tmp_type !~ /r|i|l|b/) theval=sprintf("\"%s\"",tmp_val)
				if (tmp_type ~ "r" && tmp_val == "-1") Value=sprintf("%s\nno %s",Value,structMembers[tmp_loclass])
				else if (tmp_fulltype ~ /\.EcimEmpty$/)
				{
					if (tolower(tmp_val)~"true") Value=sprintf("%s\n%s",Value,structMembers[tmp_loclass])
				}
				else Value=sprintf("%s\n%s=%s",Value,structMembers[tmp_loclass],theval)
				#if (tmp_type ~ "r")
				#{
				#	if (tmp_val ~ /^[0-9]+$/) Value=sprintf("%s\n%s=\"%s\"",Value,structMembers[tmp_loclass],p2s("LdnMo",tmp_val))
				#	else Value=sprintf("%s\n%s=%s",Value,structMembers[tmp_loclass],tmp_val)
				#}
				#else Value=sprintf("%s\n%s=\"%s\"",Value,structMembers[tmp_loclass],tmp_val)
			}
			else
			{
				if (tmp_type~"r" && tmp_val=="") tmp_val="-1"
				Value=sprintf("%s,%s:%s=%s",Value,structMembers[tmp_loclass],tmp_type,tmp_val)
			}
		}
		else Value=Value SUBSEP array[l]
	}
	if (comcli>0) { sub(/^\n/,"",Value) ; sep="\n" }
	else { sub(/^,/,"",Value) ; sep="," }
	#print "Value1="gensub(SUBSEP,"SUBSEP","g",Value)"x"
	#print "Value="Value
	if (Value ~ SUBSEP)
	{
		#some struct members are moRef, eg, PmUeMeasControl MO in LTE
		last=split(Value,array,sep)
		Value=""
		for (l=1;l<=last;l++)
		{
			if (array[l] ~ SUBSEP)
			{
				if (array[l] ~ "=")
				{
					theval=giveMoProxy(gensub(/^[^=]+=/,"",1,gensub(SUBSEP,",","g",array[l])),"","ignorecase",Me)+0
					if (comcli>0 && theval>0) theval=sprintf("\"%s\"",p2s("LdnMo",theval))   #if a non-existent LDN was given , giveMoProxy returns 0 and this would give ManagedElement=1 , which can cause corruption in COM
					Value=Value sep gensub(/=.*$/,"",1,array[l])"="theval
				}
			}
			else Value=Value sep array[l]
		}
		if (comcli>0) sub(/^\n/,"",Value)
		else sub(/^,/,"",Value)
	}
	#print "Value2="gensub(SUBSEP,"SUBSEP","g",Value)"x"
	return Value
}
function gzcatsort(flist,dfile,   n,array,i,res)
{
	gsub(/^ *| *$/,"",flist)
	n=split(flist,array," ")
	if (n==0) return ""
	n=asort(array)
	for(i=1;i<=n;i++) res=res array[i]" "
	sub(/ *$/,"",res)
	if (res ~ /\.gz$/) res="gzip -dc "res" > "dfile
	else res="cat "res" > "dfile
	return res
}
function fetchXmlLog(what,where,startdate,enddate,maxfiles,   telnet_session,i,timestamp,timearray,dest,n,filename,j,array,formattedTimestamp,    \
gzipcommand,tmp_secdir,fileList,cp_command,last,nr_files,tfile,nr_subfiles,subfileList,gzcommand,dogz,flist,catcommand,z,y,resarray,what2,cp2_command)
{
	if (logFetched[what] > 0) return logFetched[what]
	if (what=="mos")
	{
		fileOps("rm "xmlTempLog[what])
		gzcommand="gzip -dc"
		if (in_amos_mode() != 1)
		{
			#possible file structure:
			# default moscommanddir: /home/user/moshell_logfiles/logs_moshell/moscomlogs/ipaddress.log --> can only see your user's commands
			# own moscommanddir    : /path/to/moscommanddir/moscomlogs/userid/ipaddress.log --> can see all users' commands
			# files belonging to other users can be gzipped
			nr_files=fileOps(sprintf("ls %s",moscommanddir),fileList)
			if (nr_files > 0) cp_command="cat"
			for (i=1;i<=nr_files;i++)
			{
				if (moscomlog == default_moscomlog)
				{
					nr_subfiles=1
					subfileList[1]=fileList[i]
				}
				else nr_subfiles=fileOps(sprintf("ls %s/%s",moscommanddir,fileList[i]),subfileList)
				for (j=1;j<=nr_subfiles;j++)
				{
					if (subfileList[j] !~ lgnodefilter) continue
					if (moscomlog == default_moscomlog) tfile=sprintf("%s/%s",moscommanddir,subfileList[j])
					else tfile=sprintf("%s/%s/%s",moscommanddir,fileList[i],subfileList[j])
					if (fileOps("test -s "tfile)==0)
					{
						if (tfile ~ /\.gz$/) { gzcommand=gzcommand" "tfile ; dogz=1 }
						else cp_command=cp_command" "tfile
					}
				}
			}
			if (cp_command!="cat") cp_command=cp_command" > "xmlTempLog[what]
			if (dogz==1) gzcommand=gzcommand" >> "xmlTempLog[what]
		}
		else
		{
			nr_files=fileOps("ls "amos_rootlogdir,fileList)
			if (nr_files > 0) cp_command="cat"
			for (i=1;i<=nr_files;i++)
			{
				nr_subfiles=fileOps(sprintf("ls %s/%s/logs_moshell/moscomlogs",amos_rootlogdir,fileList[i]),subfileList)
				for (j=1;j<=nr_subfiles;j++)
				{
					if (subfileList[j] !~ lgnodefilter) continue
					tfile=sprintf("%s/%s/logs_moshell/moscomlogs/%s",amos_rootlogdir,fileList[i],subfileList[j])
					if (fileOps("test -s "tfile)==0)
					{
						if (tfile ~ /\.gz$/) { gzcommand=gzcommand" "tfile ; dogz=1 }
						else cp_command=cp_command" "tfile
					}
				}
			}
			if (cp_command!="cat") cp_command=cp_command" > "xmlTempLog[what]
			if (dogz==1) gzcommand=gzcommand" >> "xmlTempLog[what]
		}
		if (cp_command!="cat")
		{
			customPrint(cp_command)
			system(cp_command)
			chmod(00666,xmlTempLog[what])
			if (fileOps("test -s "xmlTempLog[what])==0) logFetched[what]=1
		}
		if (dogz==1)
		{
			customPrint(gzcommand)
			system(gzcommand)
			chmod(00666,xmlTempLog[what])
			if (fileOps("test -s "xmlTempLog[what])==0) logFetched[what]=1
		}
		return logFetched[what]
	}
	if (comcli>0 && where=="")
	{
		split(fetch_comlogs("get",lgfdir,startdate,enddate,"",what,maxfiles),resarray,SUBSEP)
		if (resarray[1]==0) where=resarray[2]
		if (where==999) return
	}

	if (where != "")
	{
		if (foundXmlLog[what] != 1) find_xmlLogs_pathes(where)
		if (foundXmlLog[what]==1)
		{
			if ((what ~ /^(sys|upg|a_t|atr|sec|ipc|rlib|ipd|anr)$/)||(what ~ /^(al|bgf)$/ && comcli>0))
			{
				#the RCS SAF logfile (alarm, TN app, TN network, Battery) can be in various order
				#the Pico runtime log (audit trail) can be in various order
				if (comcli>0)
				{
					if ((mom_version ~ /^(MSRBS|RCS)_/ && what ~ /^(al|ipc|rlib|bgf)$/)||(mom_version ~ /PRBS_/ && what ~ /^(a_t|atr|al)$/))
					{
						if (mom_version ~ /PRBS_/ && what=="al") xmlLog[what]=mysortlist(xmlLog[what],"reverse")
						else xmlLog[what]=mysortlist(xmlLog[what])
					}
				}
				cp_command="cat "xmlLog[what]" > "xmlTempLog[what]
				#on RCS node the "a_t" and "atr" log are the same log: the AuditTrailLog
				if (xmlLog[what] ~ /rcslogs\/AuditTrailLog_/)
				{
					if (what=="a_t") what2="atr" ; else if (what=="atr") what2="a_t"
					cp2_command="cat "xmlLog[what2]" > "xmlTempLog[what2]
				}
			}
			else if (comcli>0 && what ~ /^(ipcs)$/) cp_command="cp "xmlLog[what]" "xmlTempLog[what]
			else if (what == "xb")
			{
				if (comcli>0)
				{
					system("rm -rf "xmlTempLog["xb"])
					system("mkdir "xmlTempLog["xb"])
					cp_command="cp -R "xmlLog[what]" "xmlLog[what]"/../var "xmlLog[what]"/../tmp "xmlLog[what]"/../vnf "xmlTempLog[what]
				}
				else
				{
					cp_command="cp -R "xmlLog[what]" "xmlTempLog[what]
				}
			}
			else if (what ~ /^(ted|ipcs|bgf)$/) cp_command=gzcatsort(xmlLog[what],xmlTempLog[what])
			else cp_command="cp "xmlLog[what]" "xmlTempLog[what]
			if (cp_command!="")
			{
				customPrint(cp_command)
				system(cp_command)
			}
			if (cp2_command!="")
			{
				customPrint(cp2_command)
				system(cp2_command)
			}
			if (what=="xb")
			{
				system("chmod -R 777 "xmlTempLog[what])
				if (fileOps("test -d "xmlTempLog[what])==0) logFetched[what]=1
			}
			else
			{
				chmod(00666,xmlTempLog[what])
				if (fileOps("test -s "xmlTempLog[what])==0)
				{
					logFetched[what]=1
					if (what2!="") logFetched[what2]=1
				}
			}
		}
		return logFetched[what]
	}
	check_node_password()
	if (node_password == "") return ""
	if (what=="sys" || what=="ted" || what=="bgf" || what=="ipcs")
	{
		fileOps("rm "xmlTempLog[what])
		fileOps("mkdir "tempdir"/"what)
		if (what=="ted") fetch_ted(startdate,tempdir)
		else ftp("get",xmlNodePath[what],tempdir"/"what,xmlNodeFilter[what],startdate,"","",(what=="bgf"?"":"norecursive"),"")
		mo_log(tempgalog,"open","mute","overwrite","silent")
		lftree("f",tempdir"/"what)
		mo_log(tempgalog,"close")
		flist=""
		while (getline < tempgalog) { gsub("\r","") ; gsub("\x000","") ; if ($1~/^-r/) flist=flist " "$NF }
		close(tempgalog)
		catcommand=gzcatsort(flist,xmlTempLog[what])
		if (catcommand!="")
		{
			customPrint(catcommand)
			system(catcommand)
		}
		close(xmlTempLog[what])
		if (fileOps("test -s "xmlTempLog[what])==0) logFetched[what]=1
		return logFetched[what]
	}
	else if (what=="a_t" || what=="atr" || what=="sec" || what=="ipc" || what=="rlib" || what=="upg" || what=="anr" || what=="ipd")
	{
		#print what,foundXmlLog[what],xmlLog[what],xmlTempLog[what]
		if (foundXmlLog[what] != 1 || xmlLog[what] !~ /^ *\/[cd]\//) find_xmlLogs_pathes()
		if (foundXmlLog[what] != 1) return
		if (what=="ipd") refresh_etipglog()
		fileOps("rm "xmlTempLog[what])
		last=split(xmlLog[what],array," ")
		for (i=1;i<=last;i++)
		{
			if (array[i] == "") continue
			if (ftpclient(node_address,node_password,sprintf("Get %s %s.tmp",array[i],xmlTempLog[what]))!=0) continue
			while (getline < sprintf("%s.tmp",xmlTempLog[what])) print $0 >> xmlTempLog[what]
			close(sprintf("%s.tmp",xmlTempLog[what]))
		}
		close(xmlTempLog[what])
		fileOps(sprintf("rm %s.tmp",xmlTempLog[what]))
		if (fileOps("test -s "xmlTempLog[what])==0) { logFetched[what]=1 ; chmod(00666,xmlTempLog[what]) }
		return logFetched[what]
	}
	else if (what=="te")
	{
		fetch_te()
		logFetched["te"]=1
		return logFetched["te"]
	}
	else if (what=="llog")
	{
		fetch_llog()
		logFetched["llog"]=1
		return logFetched["llog"]
	}
	else if (what=="pmd")
	{
		fetch_pmd(startdate,enddate,"",maxfiles)
		logFetched["pmd"]=1
		return logFetched["pmd"]
	}
	else if (what=="xb")
	{
	     logFetched["xb"]=fetch_xblog(startdate,enddate)
	     return logFetched["xb"]
	}
	else if (what=="ls")
	{
		fetch_ls()
		logFetched["ls"]=1
		return logFetched["ls"]
	}
	else if (what=="bp")
	{
		fetch_bp()
		logFetched["bp"]=1
		return logFetched["bp"]
	}
	else
	{
		#what= av,ev,al, anr
		if (foundXmlLog[what] != 1 || xmlLog[what] !~ /^ *\/[cd]\//) find_xmlLogs_pathes()
		if (foundXmlLog[what]==1)
		{
			#to avoid fetching files that are not there, especially in the case of the cpp5 logs
			ftpclient(node_address,node_password,sprintf("Get %s %s",xmlLog[what],xmlTempLog[what]))
			chmod(00666,xmlTempLog[what])
			if (fileOps("test -s "xmlTempLog[what])==0) logFetched[what]=1
		}
		return logFetched[what]
	}
}
function mysortlist(thelist,what,   n,i,a)
{
	n=split(thelist,a," ")
	n=asort(a)
	thelist=""
	if (what=="reverse")
	{
		for (i=n;i>=1;i--) thelist=thelist" "a[i]
	}
	else
	{
		for (i=1;i<=n;i++) thelist=thelist" "a[i]
	}
	return thelist
}
function fetch_ted(startdate,destdir,    z,array,y,i)
{
	buildBoardGroup()
	if (("tmmp" in bdGroup && bdGroup["tmmp"]~/[0-9]+00;[0-9]+00/) || (isEvo==1))
	{
		#if Evo or if there are several TM boards then we must collect from xxyy00!/d/usr/cello/telogs instead of /d/usr/cello/telogs
		z=split(bdGroup["tmmp"],array,";")
		z=asort(array)
		for (y=1;y<=z;y++)
		{
			if (checkIfDir("ose",array[y]"!"xmlNodePath["ted"])!=0) continue
			ftp("get",array[y]"!"xmlNodePath["ted"],destdir"/ted",xmlNodeFilter["ted"],startdate,"","","norecursive","")
		}
	}
	else
	{
		if (checkIfDir("ose",xmlNodePath["ted"])==0)
		{
			ftp("get",xmlNodePath["ted"],destdir"/ted",xmlNodeFilter["ted"],startdate,"","","norecursive","")
		}
		for (i=1;i<=3;i++)
		{
			if (checkIfDir("ose",xmlNodePath["tedr"i])==0)
			{
				ftp("get",xmlNodePath["tedr"i],destdir"/ted/tedr",xmlNodeFilter["ted"],startdate,"","","norecursive","")
			}
		}
	}
}
function fetch_bp()
{
	mo_log(tempbplog,"open","mute","overwrite","silent")
	muteFactor=100
	TI()
	$0="bp all" ; buildBoardGroup("list")
	mo_log(tempbplog,"close")
	chmod(00666,tempbplog)
}
function fetch_ls(    array,last,i)
{
	mo_log(templslog,"open","mute","overwrite","silent")
	muteFactor=100
	TI()
	$0="bp all" ; buildBoardGroup("list")
	TI()
	muteFactor=10
	$0="";ftree_function("f","/c/pmd")
	$0="";ftree("/c/logfiles"SUBSEP"/c/systemfiles"SUBSEP"/c/usr","","","f")
	#$0="";ftree_function("f","/c/logfiles")
	#$0="";ftree_function("f","/c/systemfiles")
	#$0="";ftree_function("f","/c/usr")
	if (mom_version ~ /RBS/)
	{
		$0="lh mp ftreef /d/logfiles" ; lh()
		$0="lh mp ftreef /d/systemfiles" ; lh()
	}
	if (mom_version ~ /^ERBS/)
	{
		last=split(bdGroup["mp"],array,";")
		for (i=1;i<=last;i++)
		{
			$0=""; ftree_function("f","/p"array[i]"/logfiles")
		}
	}
	mo_log(templslog,"close")
	chmod(00666,templslog)
}
function eval_z(val)
{
	if (use_lhz>=val) return "z"
	else return ""
}
function fetch_te()
{
	customPrint("lh "lgtgroup" te log read |tee "temptelog,"","","")
	mo_log(temptelog,"open","mute","overwrite","silent")
	if (lgtgroup in NrOfBoards) muteFactor=250*NrOfBoards[lgtgroup]
	TI()
	$0="bp all" ; buildBoardGroup("list")
	TI()
	$0="lh "lgtgroup" te log read" ; lh("","user")
	mo_log(temptelog,"close")
	chmod(00666,temptelog)
	if (comcli>0) fileOps("cp "temptelog" "tempdir"/rcslogs/teread.log")
}
function fetch_llog()
{
	customPrint("lh "lgggroup" llog -l |tee "templloglog,"","","")
	mo_log(templloglog,"open","mute","overwrite","silent")
	if (lgggroup in NrOfBoards) muteFactor=250*NrOfBoards[lgggroup]
	TI()
	$0="bp all" ; buildBoardGroup("list")
	TI()
	if (comcli>0) $0="lh mp llog -l" ; else $0="lh "lgggroup" llog -l"
	lh()
	if (lgggroup=="allpd")
	{
		#$0="lh piudev llog -l"  ; lh()  #piudev already included in allpd
		$0="lh xmu02 llog -l -n 5"; lh()
		$0="lh xmu03 llog -l"; lh()    #on XMU03 the -n option has a different meaning, instead of listing the last 5 restarts, it lists restart number 5
		$0="lh pimcu llog -l"; lh()
		$0="lh ru llog -l" ; lh()      #previously we were running llog -l -n 5 but that does not work on NGR G2 (Linux based) radio such as RRU2212 which then just collects restart number 5
	}
	mo_log(templloglog,"close")
	chmod(00666,templloglog)
	if (comcli>0) fileOps("cp "templloglog" "tempdir"/rcslogs/llog.log")
}
function fetch_pmd(startdate,enddate,destdir,maxfiles,     \
fileList,a,i,nr_of_files,zpm_command,cp_command,curr_file,date,time,tmp_timestamp,cat_command,file,count,gzip_command,tmpinfo,fcount,fcountDu,rcount,readfile_session,cat_command2,tt,arr,wt,z,k,arry,thefile)
{
	if (cpplinux==1) ftp("getc","/c/pmd",pmdlogdir,".(tgz|tar)$",startdate,enddate,"","","%pmd%")
	else if (comcli>0)
	{
		ftp("getc","/rcs/dumps/pmd",pmdlogdir,"",startdate,enddate,"","","")
		if (exportdump_not_supported==1) return
	}
	else ftp("getc","/c/pmd",pmdlogdir,".pmd$",startdate,enddate,"","","%pmd%")
	mo_log(temppmdzpmlog,"open","mute","overwrite","silent")
	TI()
	$0="bp all" ; buildBoardGroup("list")
	TI()
	mo_log(temppmdzpmlog,"close")
	fetch_rupmd(startdate,enddate)
	nr_of_files=fileOps("ls "pmdlogdir"/pmd",fileList)
	for (i=1;i<=nr_of_files;i++)
	{
		if (i==1) customPrint("")
		if (fileList[i] ~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_.*\.(pmd|txt.gz|tar.gz|tgz|tar)$/)
		{
			split(fileList[i],a,"")
		}
		else if (fileList[i] ~ /-[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9][0-9][0-9]\.(tgz|zip|tgz.gpg|tgz_with_llog.tgz|tgz.gpg_with_llog.tgz)$/)
		{
			match(fileList[i],/-([1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9][0-9][0-9])\./,arr)
			split(arr[1],a,"")
		}
		else continue
		tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
		if (tmp_timestamp >= startdate || startdate=="")
		{
			if (tmp_timestamp <= enddate || enddate=="")
			{
				if (fileList[i] ~ /\.pmd$/)
				{
					print "Parsing PMD file: "pmdlogdir"/pmd/"fileList[i] >> temppmdzpmlog
					close(temppmdzpmlog)
					zpm_command=sprintf("%s -s \"USER REPORTED ERROR DATA\" %s >> %s",zpm,pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
					system(zpm_command)
					zpm_command=sprintf("%s -s \"TSL INFORMATION\" %s >> %s",zpm,pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
					system(zpm_command)
					zpm_command=sprintf("%s -s \"ERROR CODE\" %s >> %s",zpm,pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
					system(zpm_command)
					zpm_command=sprintf("%s -s \"ERROR LOG\" %s >> %s",zpm,pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
					system(zpm_command)
					zpm_command=sprintf("%s -s \"REGISTERS\" %s >> %s",zpm,pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
					system(zpm_command)
					customPrint(gensub(/ -s .REGISTERS.| >>.*$/,"","g",zpm_command))
					#if (destdir != "" && fileOps("mkdir -p "destdir"/pmd")==0)
					#{
					#	cp_command=sprintf("cp "pmdlogdir"/pmd/"fileList[i]" "destdir"/pmd")
					#	customPrint(cp_command)
					#	system(cp_command)
					#}
				}
				else if (fileList[i] ~ /\.(txt.gz)$/) #|tar.gz
				{
					print "Parsing RUPMD file: "pmdlogdir"/pmd/"fileList[i] >> temppmdzpmlog
					close(temppmdzpmlog)
					if (fileList[i] ~ /\.txt.gz$/)
					{
						zpm_command=sprintf("gzip -dc %s >> %s",pmdlogdir"/pmd/"fileList[i],temppmdzpmlog)
						customPrint("gzip -dc "pmdlogdir"/pmd/"fileList[i])
						system(zpm_command)
					}
				}
				else if (fileList[i] ~ /\.(tgz|zip|gpg|tar.gz|tar)$/)
				{
					printf "Parsing LinuxPMD file: "fileList[i]" " >> temppmdzpmlog
					close(temppmdzpmlog)

					#tt=gensub(/^[0-9]+_[0-9]+_c_pmd_[0-9]+_[0-9]+_/,"",1,fileList[i])
					tt=gensub(/^.*_pmd-/,"pmd-",1,fileList[i])
					if (fileList[i]~/\.tar.gz$/)
					{
						#NGR G2/XMU

						#20170119_190127_pmd-cmd_proc-916-20170119-190127_0001BXP_0.tar.gz
						z=split(tt,arry,"_")
						tt=""
						for (k=1;k<=z;k++)
						{
							if (arry[k]~"BXP") break
							tt=tt"_"arry[k]
						}
						sub(/^_/,"",tt)
					}
					sub(/\.(tgz|zip|tar.gz|tar)$/,"",tt)
					if (tt ~ /^pmd-kernel-0-/)
					{
						print " $ Kernel crash $" >> temppmdzpmlog
						close(temppmdzpmlog)
						continue
					}
					wt=tt"/"
					if (fileList[i] ~ /\.(tgz_with_llog.tgz|tgz.gpg_with_llog.tgz)$/) wt=""
					if (fileList[i] ~ /\.gpg$/) {}
					else if (fileList[i]~/\.zip$/)
					{
						zpm_command=sprintf("unzip -p %s llog | tail -1",pmdlogdir"/pmd/"fileList[i])
						customPrint(zpm_command)
						system(zpm_command" >> "temppmdzpmlog)
					}
					else if (cpplinux==1 && fileList[i]~/\.tar$/)
					{
						fileOps(sprintf("mkdir %s/lzpm",tempdir))
						zpm_command=sprintf("cd %s/lzpm && tar xf %s %sappdump.tgz",tempdir,pmdlogdir"/pmd/"fileList[i],wt)
						if (run_system(zpm_command)==0)
						{
							thefile=sprintf("%s/lzpm/%sappdump.tgz",tempdir,wt)
							if (os ~ /^sun/) zpm_command=sprintf("cd %s/lzpm && gzip -dc %s | tar xf - ./llog && tail -1 %s/lzpm/llog",tempdir,thefile,tempdir)
							else zpm_command=sprintf("tar -xOzf %s ./llog | tail -1",thefile)
							customPrint(zpm_command)
							system(zpm_command" >> "temppmdzpmlog)
						}
					}
					else if (os ~ /^sun/)
					{
						fileOps(sprintf("mkdir %s/lzpm",tempdir))
						zpm_command=sprintf("cd %s/lzpm && gzip -dc %s | tar xf - %sllog && tail -1 %s/lzpm/%sllog",tempdir,pmdlogdir"/pmd/"fileList[i],wt,tempdir,wt)
						customPrint(zpm_command)
						system(zpm_command" >> "temppmdzpmlog)
					}
					else
					{
						zpm_command=sprintf("tar -xOzf %s %sllog | tail -1",pmdlogdir"/pmd/"fileList[i],wt)
						customPrint(zpm_command)
						system(zpm_command" >> "temppmdzpmlog)
					}
					print "" >> temppmdzpmlog
					close(temppmdzpmlog)
				}
			}
		}
	}
	close(temppmdzpmlog)
	#here we do the copy of files with lgf, maximum 90 files otherwise gets too big. this is because eventhough the node may have only 10MB of pmd files, we may have saved a whole bunch of them in the folder moshell_logfiles/logs_moshell/pmdfiles
	if (destdir != "" && fileOps("mkdir -p "destdir"/pmd")==0)
	{
		customPrint("\n\nSaving up to 90 pmd files for this period")
		fcount=0
		delete fileList
		nr_of_files=fileOps("ls "pmdlogdir"/pmd",fileList)
		nr_of_files=asort(fileList)
		for (i=nr_of_files;i>=1;i--)
		{
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_.*\.(pmd|txt.gz|tar.gz|tgz|tar)$|-[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9][0-9][0-9]\.(tgz|zip|tgz.gpg|tgz_with_llog.tgz|tgz.gpg_with_llog.tgz)$/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					if (destdir != "" && fileOps("mkdir -p "destdir"/pmd")==0)
					{
						if (fileList[i] ~ /\.pmd$/)
						{
							fcount++
							if (fcount>90) continue
						}
						else if (fileList[i] ~ /\.(txt.gz|tar.gz|tgz|tar)$/)
						{
							rcount++
							if (rcount>90) continue
						}
						cp_command=sprintf("cp "pmdlogdir"/pmd/"fileList[i]" "destdir"/pmd")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
	}
	if (comcli>0)
	{
		fileOps("cp "temppmdzpmlog" "tempdir"/rcslogs/pmdzpm.log")
		return
	}
	if (mom_version != "" && mom_version ~ /^RBS/)
	{
		#RBS classic
		if (checkIfDir("ose","/c/logfiles/dspdumps")==0) ftp("getc","/c/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%")
		#DUW
		if (checkIfDir("ose","/d/logfiles/dspdumps/00_01")==0)
		{
			#we are in board 000100
			ftp("getc","/d/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%")
			if (checkIfDir("ose","000200!/d/logfiles/dspdumps/00_02")==0)
			{
				#the notation 00xx00!/d does not allow recursive transfer so we must specify the exact directory path with 00_0x at the end
				#the asterisk at the end is to not make the directory 00_02 under destination folder dspdumps
				ftp("getc","000200!/d/logfiles/dspdumps/00_02/*",pmdlogdir"/dspdumps","",startdate,enddate,"","","%pmd%")
			}
		}
		else if (checkIfDir("ose","/d/logfiles/dspdumps/00_02")==0)
		{
			#we are in board 000200
			ftp("getc","/d/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%")
			if (checkIfDir("ose","000100!/d/logfiles/dspdumps/00_01")==0)
			{
				#the notation 00xx00!/d does not allow recursive transfer so we must specify the exact directory path with 00_0x at the end
				#the asterisk at the end is to not make the directory 00_01 under destination folder dspdumps
				ftp("getc","000100!/d/logfiles/dspdumps/00_01/*",pmdlogdir"/dspdumps","",startdate,enddate,"","","%pmd%")
			}
		}

		customPrint("\n\nProcessing DSP dumps")
		nr_of_files=fileOps("ls "pmdlogdir"/dspdumps",fileList)
		for (i=1;i<=nr_of_files;i++)
		{
			count=0
			#if (fileList[i] !~ "ECDAdump") continue
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					curr_file=sprintf("%s/dspdumps/%s",pmdlogdir,fileList[i])
					if (fileList[i] ~ "ECDAdump")
					{
						customPrint(""curr_file)
						print "Parsing ECDA file: "curr_file >> temppmdzpmlog
						if (curr_file ~ /\.gz$/) gzip_command="gzip -dc "curr_file
						else gzip_command="cat "curr_file
						while (gzip_command |& getline)
						{
							count++
							if (count < 100 && NF > 0) print $0 >> temppmdzpmlog
						}
						close(gzip_command)
					}
					if (destdir != "" && fileOps("mkdir -p "destdir"/dspdumps")==0)
					{
						cp_command=sprintf("cp "curr_file" "destdir"/dspdumps")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
		close(temppmdzpmlog)
	}


	#Collecting WinDrv dumps (dumps on ET-ATM boards), only done with lgf, not lgp since lgp cannot parse them
	if (mom_version != "" && mom_version !~ /^ERBS/ && destdir != "" && checkIfDir("ose","/c/usr")==0 && fileOps("mkdir -p "destdir"/usr")==0)
	{
		customPrint("\n\nCollecting WinDrv dumps")
		ftp("getc","/c/usr",pmdlogdir,"winDrv",startdate,enddate,"","","%pmd%")
		nr_of_files=fileOps("ls "pmdlogdir"/usr",fileList)
		for (i=1;i<=nr_of_files;i++)
		{
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					curr_file=sprintf("%s/usr/%s",pmdlogdir,fileList[i])
					if (destdir != "" && fileOps("mkdir -p "destdir"/usr")==0)
					{
						cp_command=sprintf("cp "curr_file" "destdir"/usr")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
	}

	#Collecting MGW DSP dumps
	if (mom_version ~ "MGW") # && destdir != "" && fileOps("mkdir -p "destdir"/dsp_dump")==0)
	{
		customPrint("\n\nCollecting MGW DSP dumps")
		if (checkIfDir("ose","/c/usr/dsp_dump")==0) ftp("getc","/c/usr/dsp_dump",pmdlogdir,"",startdate,enddate,"","","%pmd%")
		nr_of_files=fileOps("ls "pmdlogdir"/dsp_dump",fileList)
		for (i=1;i<=nr_of_files;i++)
		{
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					curr_file=sprintf("%s/dsp_dump/%s",pmdlogdir,fileList[i])
					print sprintf("Parsing MGWDSP file: %s",fileList[i]) >> temppmdzpmlog
					if (destdir != "" && fileOps("mkdir -p "destdir"/dsp_dump")==0)
					{
						cp_command=sprintf("cp "curr_file" "destdir"/dsp_dump")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
		customPrint("\n\nCollecting MGW VPP dumps")
		if (checkIfDir("ose","/c/usr/vpp_dump")==0) ftp("getc","/c/usr/vpp_dump",pmdlogdir,"",startdate,enddate,"","","%pmd%")
		nr_of_files=fileOps("ls "pmdlogdir"/vpp_dump",fileList)
		for (i=1;i<=nr_of_files;i++)
		{
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					curr_file=sprintf("%s/vpp_dump/%s",pmdlogdir,fileList[i])
					print sprintf("Parsing MGWVPP file: %s",fileList[i]) >> temppmdzpmlog
					if (destdir != "" && fileOps("mkdir -p "destdir"/vpp_dump")==0)
					{
						cp_command=sprintf("cp "curr_file" "destdir"/vpp_dump")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
	}

	#From here only ERBS

	if (mom_version != "" && mom_version !~ /^ERBS/) return
	customPrint("\n\nProcessing logfiles in /c/logfiles/troubleshooting/error")
	ftp("getc","/c/logfiles/troubleshooting/error",pmdlogdir,"",startdate,enddate,"","","%pmd%")
	nr_of_files=fileOps("ls "pmdlogdir"/error",fileList)
	for (i=1;i<=nr_of_files;i++)
	{
		#if (i==1) customPrint("")
		if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
		split(fileList[i],a,"")
		tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
		if (tmp_timestamp >= startdate || startdate=="")
		{
			if (tmp_timestamp <= enddate || enddate=="")
			{
				curr_file=sprintf("%s/error/%s",pmdlogdir,fileList[i])
				customPrint(""curr_file)
				print "Parsing ERROR file: "gensub(/\.gz$/,"",1,curr_file) >> temppmdzpmlog
				if (curr_file ~ /\.gz$/) readfile_session="gzip -dc "curr_file
				else readfile_session="cat "curr_file
				close(readfile_session)
				while (readfile_session |& getline)
				{
					if ($1=="***" && $2=="Trace") break
					if (NF > 0) print $0 >> temppmdzpmlog
				}
				close(readfile_session)
				if (destdir != "" && fileOps("mkdir -p "destdir"/error")==0)
				{
					cp_command=sprintf("cp "curr_file" "destdir"/error")
					customPrint(cp_command)
					system(cp_command)
				}
			}
		}
	}
	close(temppmdzpmlog)
	customPrint("\n\nProcessing FAULTLOG files")
	mo_log(tempgalog,"open","mute","overwrite","silent")
	$0="ls -l /c/logfiles/dspdumps/00_01"; cmd()   #L12A and before
	$0="lh mp ls -l /d/systemfiles"; lh()          #L12B and after
	$0="ls -l /c/pmd" ; cmd()                      #DataDump files
	mo_log(tempgalog,"close")
	cat_command=""
	cat_command2=""
	while (getline < tempgalog)
	{
		#$ lhsh 000300 ls -l /d/systemfiles
		if ($NF=="/d/systemfiles" && NF>3) board=$(NF-3)
		else if ($2 ~ /^-r/ && $NF ~ /^FAULTLOG[0-9]/)
		{
			#0003: -rw-rw-rw-   0       131   5 Jul 2012 14:43:01 FAULTLOG01_120705_144301.log
			date=sprintf("%s-%02d-%02d",$7,mm[$6],$5)
			time=$8
			tmp_timestamp=make_timestamp(date,time)
			if (tmp_timestamp >= startdate && tmp_timestamp <= enddate)
			{
				file=sprintf("%s!/d/systemfiles/%s",board,$NF)
				cat_command=sprintf("%scat %s;",cat_command,file)
			}
		}
		#$ ls -l /c/logfiles/dspdumps/00_01
		else if ($1 ~ /^-r/ && $NF ~ /^FAULTLOG[0-9]/)
		{
			#-rw-rw-rw-   0  10167574  26 Feb 2012 08:11:48 GCPUdump1024-01.gz
			date=sprintf("%s-%02d-%02d",$6,mm[$5],$4)
			time=$7
			tmp_timestamp=make_timestamp(date,time)
			if (tmp_timestamp >= startdate && tmp_timestamp <= enddate)
			{
				file=sprintf("/c/logfiles/dspdumps/00_01/%s",$NF)
				cat_command=sprintf("%scat %s;",cat_command,file)
			}
		}
		#-rw-rw-rw-   0     41916  16 May 2016 23:02:39 DataDump24Du02_160516_230238.bin
		else if ($1 ~ /^-r/ && $NF ~ /^DataDump.*\.bin$/)
		{
			date=sprintf("%s-%02d-%02d",$6,mm[$5],$4)
			time=$7
			tmp_timestamp=make_timestamp(date,time)
			if (tmp_timestamp >= startdate && tmp_timestamp <= enddate)
			{
				file=sprintf("/c/pmd/%s",$NF)
				cat_command2=sprintf("%scat %s;",cat_command2,file)
			}
		}
	}
	close(tempgalog)
	mo_log(tempfalog,"open","mute","overwrite","silent")
	$0=cat_command ; cmd()  #cannot run it with fast_coli because fast_coli does not work well when carriage return is missing at the end of the file and the FAULTLOG files sometimes are missing the last carriage return
	mo_log(tempfalog,"close")
	customPrint("")
	while (getline < tempfalog)
	{
		#$ cat /c/logfiles/dspdumps/00_01/FAULTLOG01_120510_064112.log
		#$ cat 000100!/d/systemfiles/FAULTLOG01_120613_182911.log
		#[2012-06-13 18:29:11] ULMA[01024]:LPP fatal error with faultId = 0x74 arg1 = 0x354 arg2 = 0x800 arg3 = 0x0
		#$ cat 000100!/d/systemfiles/FAULTLOG02_120801_145258.log
		#[2012-08-01 14:52:58] ULMA[00768]:pap_xio_dliqb_cproc.c:426: DBC Assert failure: xioPortMapping.valid == 1
		if (NF >=3 && $1 ~ /^\[/)
		{
			sub(/^\[/,"",$1); sub(/\]$/,"",$2)
			print sprintf("Parsing FAULTLOG file: %s %s",file,$0) >> temppmdzpmlog
			customPrint(file)
		}
		else if ($NF ~ /FAULTLOG.*\.log$/) file=$NF
	}
	close(tempfalog)
	close(temppmdzpmlog)
	if (destdir != "") run_system("cp "tempfalog" "destdir"/faultlogs.log")

	mo_log(tempdalog,"open","mute","overwrite","silent")
	$0=cat_command2 ; cmd()  #cannot run it with fast_coli because fast_coli does not work well when carriage return is missing at the end of the file and the FAULTLOG files sometimes are missing the last carriage return
	mo_log(tempdalog,"close")
	customPrint("")
	if (destdir != "") run_system("cp "tempdalog" "destdir"/datadumps.log")


	#The ENB DSP dumps are really big so if startdate is empty, we take the last 45 days only
	if (startdate<1)
	{
		startdate=systime()-45*24*3600
		tmpinfo=" for the last 45 days"
	}

	if (maxfiles > 0)
	{
		if (maxfiles<1) tmpinfo="no DSP dumps"
		else if (maxfiles==8) tmpinfo="the last DSP dump"tmpinfo
		else if (maxfiles>8) tmpinfo="the last "((maxfiles-8)+4)/4" DSP dumps" tmpinfo
	}
	else tmpinfo="all DSP dumps"tmpinfo
	customPrint(sprintf("\n\nCollecting %s of each DU for this period (use option \"-d <n>\" to specify a different number of DSP dumps to collect)",tmpinfo))

	if (maxfiles > 0 && maxfiles < 1) return  #maxfiles=0.5 -> no DSP dumps to collect

	#L12A and before
	if (checkIfDir("ose","/c/logfiles/dspdumps/00_01")==0) ftp("getc","/c/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%",maxfiles)
	#L12B and after
	if (checkIfDir("ose","/d/logfiles/dspdumps")==0)
	{
		ftp("getc","/d/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%",maxfiles)
	}
	last=split(bdGroup["mp"],array,";")
	for (i=1;i<=last;i++)
	{
		if (checkIfDir("ose","/p"array[i]"/logfiles/dspdumps")==0) ftp("getc","/p"array[i]"/logfiles/dspdumps",pmdlogdir,"",startdate,enddate,"","","%pmd%",maxfiles)
	}
	if (destdir != "" && fileOps("mkdir -p "destdir"/dspdumps")==0)
	{
		delete fcountDu
		delete fileList
		nr_of_files=fileOps("ls "pmdlogdir"/dspdumps",fileList)
		nr_of_files=asort(fileList)
		for (i=nr_of_files;i>=1;i--)
		{
			if (fileList[i] !~ /^[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9][0-9][0-9]_/) continue
			split(fileList[i],a,"")
			tmp_timestamp=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[10],a[11],a[12],a[13],a[14],a[15]))
			if (tmp_timestamp >= startdate || startdate=="")
			{
				if (tmp_timestamp <= enddate || enddate=="")
				{
					curr_file=sprintf("%s/dspdumps/%s",pmdlogdir,fileList[i])
					if (destdir != "" && fileOps("mkdir -p "destdir"/dspdumps")==0)
					{
						#L12A 20120323_100817_00_01_EMdump256-47.gz
						#L12B 20121222_112109_0001_GCPUdump512-32.gz

						match(fileList[i],/^[0-9]+_[0-9]+_([0-9][0-9]_?[0-9][0-9])_/,array)
						fcountDu[array[1]]++
						if (maxfiles>0&&fcountDu[array[1]]>maxfiles) continue
						cp_command=sprintf("cp "curr_file" "destdir"/dspdumps")
						customPrint(cp_command)
						system(cp_command)
					}
				}
			}
		}
	}
}
function fetch_rupmd(startdate,enddate,   \
rupmdlist,n,currpmd,currdate,currfile,currboard,currfilename,rucmdlist,currftp,ruftplist,p,temprucmdnode,currtimestamp,i,a,isxmu03,xmu03flist,b64command)
{
	if (!(mom_version != "" && mom_version ~ /RBS/ && fileOps("mkdir -p "rupmdlogdir)==0)) return
	if (comcli>0) return
	nr_rupmd=0
	mo_log(temprupmdlog,"open","mute","overwrite","silent")
	TI()
	$0="lh xmu pmd -l"  ; lh("")
	$0="lh pimcu pmd -l"; lh("")
	$0="lh ru pmd -l"   ; lh("")
	TI()
	mo_log(temprupmdlog,"close")
	while (getline < temprupmdlog)
	{
		#RU / XMU02
		#$ lhsh 000900/port_0_dev_5 pmd -l
		#0009p0d5:     ******** DUMP DATA LOST ********
		#0009p0d5: ----------------------------------------
		#0009p0d5: [POST MORTEM DUMP INFORMATION]
		#0009p0d5:   PMD identity : 0x8
		#0009p0d5:   Date         : 2013-12-24
		#0009p0d5:   Time         : 13:53:44
		#0009p0d5: ----------------------------------------

		#XMU03:
		#0001BXP_2:   PMD identity : 2 (rhd-cprid got signal SIGILL)
		#0001BXP_2:   Date         : 2015-08-28
		#0001BXP_2:   Time         : 14:57:21
		#0001BXP_2:   md5sum       : ee31653d7685eaf96cc33baa5a07b820

		#RRU2212/4415
		#0001BXP_0: PMD identity : pmd-cmd_proc-916-20170119-190127 (cmd_proc got signal BUS (7))
		#0001BXP_0: Date         : 2017-01-19
		#0001BXP_0: Time         : 19:01:27


		if ($2=="lhsh" && $4=="pmd" && $5=="-l")
		{
			currboard=$3
			isxmu03=0
			if (currboard in BoardType && BoardType[currboard]~/^XMU03|^RRU(2012|2212|2242|2468|4415|4426|4428|4442|4449|4478|8843)/) isxmu03=1
		}
		else if ($2=="PMD" && $3=="identity" && $4==":" && $5~/^(0x|[0-9]+$|pmd-.*$)/) currpmd=$5
		else if ($2=="Date" && $3==":") currdate=$4
		else if ($2=="Time" && $3==":")
		{
			currtimestamp=make_timestamp(currdate,$4)
			if (currtimestamp >= startdate || startdate=="")
			{
				if (currtimestamp <= enddate || enddate=="")
				{
					currfilename=gensub(/-/,"","g",currdate)"_"gensub(/:/,"","g",$4)"_"currpmd"_"gensub(/:$/,"",1,$1) (isxmu03==1?".tar.gz.b64":".txt")
					currfile=rupmdlogdir"/"currfilename
					if ((fileOps("test -s "currfile".gz")==0) || (fileOps("test -s "currfile)==0 && fileOps("gzip -f "currfile)==0) || (fileOps("test -s "gensub(".b64$","",1,currfile))==0)) continue
					currcmd="lhsh "currboard" pmd "currpmd" > /gzip/d/usr/"currfilename".gz"
					currftp="get /d/usr/"currfilename".gz "rupmdlogdir"/"currfilename".gz"
					rucmdlist[currcmd]=currcmd
					ruftplist[currftp]=currftp
					if (isxmu03==1) xmu03flist[currfile".gz"]=currfile".gz"
				}
			}
		}
	}
	close(temprupmdlog)
	n=asort(rucmdlist)
	customPrint("\n\nCollecting "n" RU/XMU dumps")
	if (n>0)
	{
		temprucmdnode="/d/usr/"gensub(/^.*\//,"",1,temprucmdfile)
		p=asort(ruftplist)
		for (i=1;i<=p;i++)
		{
			split(ruftplist[i],a," ")
			ruftplist[p+i]="dele "a[2]
		}
		ruftplist[p+p+1]="dele "temprucmdnode
		fileOps("rm "temprucmdfile)
		for (i=1;i<=n;i++) print "echo "gensub(">","to",1,gensub("lhsh","Saving",1,rucmdlist[i]))"\n"rucmdlist[i] >> temprucmdfile
		print "echo \"EndOfPrint\"" >> temprucmdfile
		close(temprucmdfile)
		if (ftpclient(node_address,node_password,"put "temprucmdfile" "temprucmdnode)==0)
		{
			$0="shell -f "temprucmdnode ; cmd()
			ftpclient(node_address,node_password,"",ruftplist)
		}
	}
	n=asort(xmu03flist)
	for (i=1;i<=n;i++)
	{
		#The command below works only for XMU03 dumps but not NGR G2 dumps
		#if (system("gzip -dc "xmu03flist[i]" | uudecode -o "gensub(/.b64.gz$/,"",1,xmu03flist[i]))==0) system("rm "xmu03flist[i])
		b64command="gzip -dc "xmu03flist[i]" | egrep -v '^begin-base64 |^====$' | "openssl" enc -base64 -d > "gensub(/.b64.gz$/,"",1,xmu03flist[i])
		if (run_system(b64command)==0) run_system("rm "xmu03flist[i])

	}
}
function fetch_xblog_all(startdate,enddate,what,where,theboard,    n,array,i,xbcom,fromdir)
{
	buildBoardGroup()
	if (("cmxb" in bdGroup && bdGroup["cmxb"] != "")||("xb" in bdGroup && bdGroup["xb"] != "")) {}
	else return
	remove_xblog_all()
	#print "theboard="theboard
	if (NrOfBoards["scb"] > 0)
	{
		fromdir="/c/cmxb/logfiles"
		if (theboard!="" && bdGroup["scb"]~sprintf("(^|;)%s($|;)",theboard))
		{
			$0="lhsh "theboard" cmxblog cp -all"
			cmd()
		}
		else
		{
			$0="lh scb cmxblog cp -all"
			lh()
		}
	}
	else
	{
		fromdir="/c/xb/logfiles"
		if (theboard!="" && bdGroup["xb"]~sprintf("(^|;)%s($|;)",theboard)) $0="xblog cp "theboard" -all"
		else
		{
			split(bdGroup["xb"],array,";")
			n=asort(array)
			for (i=1;i<=n;i++) xbcom=xbcom";xblog cp "array[i]" -all"
			sub(/^;/,"",xbcom)
			$0=xbcom
		}
		cmd()
	}
	ftp(what,fromdir,where,".(log|tar).gz$",startdate,enddate)
	system("mv "where"/logfiles/* "where)
	system("rmdir "where"/logfiles")
	system("echo xblogs_fetched > "where"/fetch.log")
	remove_xblog_all()
}
function remove_xblog_all(    thedir)
{
	if (NrOfBoards["scb"] > 0) thedir="/c/cmxb/logfiles"
	else thedir="/c/xb/logfiles"
	old_ip_inactivity_timeout=ip_inactivity_timeout
	ip_inactivity_timeout=300
	$0="rm -Rf "thedir
	cmd()
	ip_inactivity_timeout=old_ip_inactivity_timeout
}
function fetch_xblog(startdate,enddate,    fileFilter,array,optionTranslation,i,j,last,apnList,nodetype,max_apn,cax_smn)
{
	# Fetch all log files from all ethernet backplane switch boards

	# Build board groups so we can find out where subracks and boards are
	buildBoardGroup()

	if (("cmxb" in bdGroup && bdGroup["cmxb"] != "")||("xb" in bdGroup && bdGroup["xb"] != "")) {}
	else return

	customPrint("\n\nCollecting XB logs")

	optionTranslation["o"]="os"
	optionTranslation["s"]="snmp"
	optionTranslation["c"]="cli"
	optionTranslation["b"]="bm"
	optionTranslation["w"]="switching"
	optionTranslation["m"]="swm"
	optionTranslation["e"]="security"
	optionTranslation["f"]="firewall"
	optionTranslation["h"]="shm"
	optionTranslation["a"]="app"
	optionTranslation["t"]="tuman"
	optionTranslation["p"]="pfm"

	if (xbLogFilter == "x") xbLogFilter="oscbwmefhatp"    #option x shows all logs
	if (xbLogFilter == "") fileFilter = "os"
	else
	{
		last=split(xbLogFilter,array,"")
		for (i=1;i<=last;i++) fileFilter=fileFilter"|"optionTranslation[array[i]]
		sub(/^\|/,"",fileFilter)
		if (mosdebug==1) print "DEBUG: xbLogFilter="xbLogFilter" fileFilter=" fileFilter
	}

	if (NrOfBoards["scb"] > 0)
	{
		# This is an AMAX based node, check for CMXB connected to SCB
		nodetype="HCS"
		apnList[1]=0
		apnList[2]=1
		max_apn=2
	}
	else
	{
		# This is an evo node
		nodetype="EVO"
		apnList[1]=1
		apnList[2]=2
		apnList[3]=27
		apnList[4]=28
		max_apn=4
	}

	# Remove old log directory structure
	system("rm -rf "xmlTempLog["xb"])
	system("mkdir "xmlTempLog["xb"])

	if (mosdebug==1) print "DEBUG: xbFetchFilter="xbFetchFilter" fileFilter="fileFilter" nodetype="nodetype
	if (xbFetchFilter ~ /^[0-9]+$/)
	{
		# Fetch logs from a single board
		fetch_xblog_board(xbFetchFilter,startdate,enddate,fileFilter,nodetype)
	}
	else
	{
		# Attempt to fetch logs from the switch boards in each subrack
		for (i=1;i<=NrOfSubracks;i++)
		{
		        # Skip CAX subrack for now, handled below
		        if(BoardType[sprintf("%02d0100", SortedSmnTable[i])] ~ /CCIB/)
			{
			     cax_smn = SortedSmnTable[i]
			     continue
			}

			for (j=1;j<=max_apn;j++) fetch_xblog_board(sprintf("%02d%02d00", SortedSmnTable[i],apnList[j]),startdate,enddate,fileFilter,nodetype)
		}

		# Fetch logs from CAX, if present
		if(NrOfBoards["ccib"] > 0)
		{
		     apnList[1]=1
		     apnList[2]=3
		     apnList[3]=4
		     apnList[4]=6

		     for (j=1;j<=max_apn;j++) fetch_xblog_board(sprintf("%02d%02d00", cax_smn,apnList[j]),startdate,enddate,fileFilter,nodetype)
		}
	}
	return 1
}

function fetch_xblog_board(lnh,startdate,enddate,fileFilter,nodetype,    available_logs,num_avail_logs,currlog,logTimeStamp,ftpCommandList,i,fullLogPath,line,logroot,lnhParts,got_timeout,command)
{
	# Fetches all available log files matching criteria from a single board and stores them on the WS

	#only fetch the logs if the board type is known, otherwise means the board is unreachable
	if (lnh in BoardType && BoardType[lnh] !~ /^(SCXB|CMXB|CCIB|SCB|SMXB)/) return

	if (mosdebug==1) print "DEBUG: fetch_xb_log_board lnh="lnh" fileFilter="fileFilter" nodetype="nodetype

	if( nodetype ~ "EVO" ) fileOps("mkdir "xmlTempLog["xb"]"/"lnh)

	mo_log(xmlTempLog["xb"]"/fetch.log","open","mute","overwrite","silent")
	muteFactor=5

	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}
	# Available log files to copy
	num_avail_logs=0
	got_timeout=0

	if (nodetype ~ "EVO") command="xblog ls "lnh
	else command="lhsh "lnh" cmxblog ls"
	if (mosdebug==1) print "DEBUG: command="command
	print command |& telnet_session
	while (telnet_session |& getline line)
	{
		gsub("\r","",line)
		gsub(/^[ $]*/,"",line)
		if (mosdebug==1) print "DEBUG: "line
		customPrint(line)
		# $ xblog ls 000100
		# Status Filename
		# ---------------
		# open   shm.log
		# safe   shm_-J208395-0100000_20110802T080906+0000.log.gz
		# ready  snmp_-J208395-0100000_20110803T114602+0000.log.gz
		# ...
		# -- End of file list --

		#rcmd: unknown command 'cmxblog'
		if (line ~ /: unknown command '/) break
		else if (line ~ /Timeout.*not responding|: connection timed out/)
		{
			#Timeout, server 10.67.30.10 not responding.
			#/home/eanzmagn/moshell/commonjars/connect: connection timed out
			print "Timeout while checking logs for "lnh
			got_timeout=2
			break
		}
		else if (line ~ /^Timeout / )
		{
			#$ xblog ls 000100
			#Timeout while waiting for SNMP Get response

			# Error case where board is not present or not operational

			print "Timeout while checking logs for "lnh
			got_timeout=1
			break
			#close(telnet_session)
			#mo_log(xmlTempLog["xb"]"/fetch.log","close")
			#return
		}
		else if (line ~ /(open|safe|ready)/ && line ~ fileFilter)
		{
			if (line !~ /gz$/)
			{
				# This is an open log file, we must copy it since we don't have any timestamp
				available_logs[num_avail_logs++] = gensub(/^(open|safe|ready)[\t ]*/,"",1,line)
			}
			else
			{
				# Since the timpstamp on the log only tells us when the log was closed,
				# we check that this time does not occur before startdate.
				# Enddate filtering will be done after log file is parsed

				# shm_-J208395-0100000_20110803T143546+0000.log.gz
				# Find _(YYYY)(MM)(DD)T(hh)(mm)(ss)+
				match(line, /_([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])T([0-9][0-9])([0-9][0-9])([0-9][0-9])\+/, logTime)
				# This format is needed for mymktime() that gives us the UNIX time corresponding to the date/time of the log file
				#                                            Year       Month       Day       Hour      Minute     Second
				logTimeStamp = sprintf("%s %s %s %s %s %s",logTime[1],logTime[2],logTime[3],logTime[4],logTime[5],logTime[6])
				if (startdate <= mymktime(logTimeStamp)) available_logs[num_avail_logs++] = gensub(/^(open|safe|ready)[\t ]*/,"",1,line)
			}
		}
		else if (line ~ /End of file list/) break
	}

	# Nothing to copy
	if (num_avail_logs == 0 || got_timeout>0)
	{
		if (got_timeout!=2)
		{
			print "exit" |& telnet_session
			while (telnet_session |& getline line){}
		}
		close(telnet_session)
		mo_log(xmlTempLog["xb"]"/fetch.log","close")
		return
	}

	currlog = 0
	if (nodetype ~ "EVO") command="xblog cp "lnh" "available_logs[currlog++]
	else command="lhsh "lnh" cmxblog cp "available_logs[currlog++]
	if (mosdebug==1) print "DEBUG: command="command
	print command |& telnet_session
	while (telnet_session |& getline line)
	{
		gsub("\r","",line)
		gsub(/^[ $]*/,"",line)
		if (mosdebug==1) print "DEBUG: "line
		customPrint(line)

		#$ xblog cp 000100 os.log
		#Copying 'os.log', renamed to: os_-J208395-0100000_20110805T082204+0000.log.gz OK
		#Done! 1 file(s) copied.

		#$ xblog cp 000100 shm_-J208395-0100000_20110803T143546+0000.log.gz
		#Copying 'shm_-J208395-0100000_20110803T143546+0000.log.gz' OK
		#Done! 1 file(s) copied.

		#Copying 'snmp_-J208395-0100025_20110803T102102+0000.log.gz' Error in SNMP Set response (10)
		#Copying 'switching_-J208395-0100025_20110802T064101+0000.log.gz' XB reports error in transfer.

		if (line ~ /Timeout.*not responding|: connection timed out/)
		{
			#Timeout, server 10.67.30.10 not responding.
			#/home/eanzmagn/moshell/commonjars/connect: connection timed out
			print "Timeout while copying logs for "lnh
			got_timeout=2
			break
		}
		if (line ~ /renamed to/)
		{
			match(line, /renamed to: ([0-9A-Za-z\-_\+\.]+) /, newLogName)
			available_logs[currlog-1] = newLogName[1]
		}

		if (line ~ /^Copying/ && line !~ /OK$/)
		{
			print "ERROR while copying log file from "lnh"\n"line
		}
		else if (line ~ /^Done!/)
		{
			# $ xblog cp 002800 os_-J208392-0100028_20110812T074501+0000.log.gz
			# Done! No files copied.
			#
			# Special case that happens when copying one of the open logs causes
			# a previously saved log to be removed from the XB. Set filename to
			# empty string to prevent ftpClient from exiting when it fails to
			# download the file from the node.
			if (line ~ /No files copied/)
			available_logs[currlog-1] = ""

			# Are we done?
			if (currlog == num_avail_logs) break

			if (nodetype ~ "EVO") command="xblog cp "lnh" "available_logs[currlog++]
			else command="lhsh "lnh" cmxblog cp "available_logs[currlog++]
			if (mosdebug==1) print "DEBUG: command="command
			print command |& telnet_session
		}
	}
	if (got_timeout!=2)
	{
		print "exit" |& telnet_session
		while (telnet_session |& getline){}
	}
	close(telnet_session)
	if (got_timeout==2)
	{
		mo_log(xmlTempLog["xb"]"/fetch.log","close")
		return
	}


	i=0

	if( nodetype ~ "EVO" ) logroot = "/c/xb/logfiles"
	else
	{
		# Convert SCB lnh to CMXB lnh
		logroot = "/c/cmxb/logfiles"
		match(lnh, /([0-9][0-9])([0-9][0-9])([0-9][0-9])/, lnhParts)
		if (lnhParts[2] == "01") lnhParts[2] = "03"
		else if (lnhParts[2] == "00") lnhParts[2] = "26"
		lnh=sprintf("%s%s%s",lnhParts[1],lnhParts[2],lnhParts[3])
		fileOps("mkdir "xmlTempLog["xb"]"/"lnh)
	}

	# Download log files
	for (xbLogFile in available_logs)
	{
		if (available_logs[xbLogFile] == "") continue
		ftpCommandList[++i] = "get "logroot"/"lnh"/"available_logs[xbLogFile]" "xmlTempLog["xb"]"/"lnh"/"available_logs[xbLogFile]
		if (mosdebug==1) print "DEBUG: ftpCommandList["i"]="ftpCommandList[i]
	}

	mo_log(xmlTempLog["xb"]"/fetch.log","close")

	#the printout of the ftp transfers will not go into fetch.log but into the regular logfile (e.g. dcgm logfile)
	ftpclient(node_address,node_password,"",ftpCommandList)

	#mo_log(xmlTempLog["xb"]"/fetch.log","open","mute","overwrite","silent")

	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}

	# Remove log files from node to void filling /c with persistent logs
	for (xbLogFile in available_logs)
	{
		fullLogPath=logroot"/"lnh"/"available_logs[xbLogFile]
		command="chmod 777 "fullLogPath"\nrm "fullLogPath"\necho rm ok\n"
		if (mosdebug==1) print "DEBUG: command="command
		print command |& telnet_session

		# Make sure each remove command is processed before sending a new one
		while (telnet_session |& getline line)
		{
			gsub("\r","",line)
			if (mosdebug==1) print "DEBUG: "line
			if (line !~ /echo/ && line ~ /rm ok$/) break
		}
	}

	print "exit" |& telnet_session
	while (telnet_session |& getline) {}
	close(telnet_session)
	#mo_log(xmlTempLog["xb"]"/fetch.log","close")
}
function get_trace_log(dir,file)
{
	if (ftpclient(node_address,node_password,sprintf("Get %s/%s %s.tmp",dir,file,xmlTempLog["upg"]))==0)
	{
		while (getline < sprintf("%s.tmp",xmlTempLog["upg"])) print $0 >> xmlTempLog["upg"]
		close(sprintf("%s.tmp",xmlTempLog["upg"]))
	}
}
function refresh_etipglog(       etipcom)
{
	if (mom_version ~ "RBS_NODE_MODEL") return
	if (mosdebug==1) print "REFRESH ETIPG LOG"
	buildBoardGroup()
	etipcom="lh etipg bh IpTranProf_Configure forceprop"
	#customPrint(etipcom,"","force")
	$0=etipcom;lh()
}
function find_xmlLogs_pathes(where,    tmp_aevlist,n,scount,ucount,ocount,lcount,ycount,zcount,qcount,dcount)
{
	xmlLog["a_t"]=xmlLog["atr"]=xmlLog["ipc"]=xmlLog["sec"]=xmlLog["rlib"]=xmlLog["upg"]=xmlLog["anr"]=xmlLog["ipd"]=xmlLog["al"]=""
	mo_log(tempgalog,"open","mute","overwrite","silent")
	muteFactor=800
	if (where != "")
	{
		lftree("f",where)
		xmlLog["sys"]=xmlLog["ted"]=xmlLog["bgf"]=xmlLog["ipcs"]=""
	}
	else
	{
		#refresh_etipglog()
		#ftree("/c/logfiles")
		#read the individual folders as there could be some very large folders in /c/logfiles, eg /c/logfiles/spaslog
		$0=""; ftree("/c/logfiles/pnp_log"SUBSEP"/c/logfiles/audit_trail"SUBSEP"/c/logfiles/availability"SUBSEP"/c/logfiles/systemlog"SUBSEP\
"/c/logfiles/hw_inventory"SUBSEP"/c/logfiles/security"SUBSEP"/c/logfiles/Rlib"SUBSEP\
"/c/logfiles/alarm_event"SUBSEP"/c/logfiles/iptran"SUBSEP"/c/logfiles/cello"SUBSEP"/c/logfiles/SON"SUBSEP"/c/systemfiles/cello/cma/su"SUBSEP"/c/logfiles/su")
		#ftree("/c/logfiles/audit_trail")
		#ftree("/c/logfiles/availability")
		#ftree("/c/logfiles/systemlog")
		#ftree("/c/logfiles/hw_inventory")
		#ftree("/c/logfiles/security")
		#ftree("/c/logfiles/Rlib")
		#ftree("/c/logfiles/alarm_event")
		#ftree("/c/logfiles/iptran")
		#ftree("/c/logfiles/cello")
	}

	mo_log(tempgalog,"close")
	while (getline < tempgalog)
	{
		gsub("\r","") ; gsub("\x000","")
		#/c/logfiles/Rlib/RLIB_PM_LOG.xml
		#/c/logfiles/SON/ANR_EVENTLOG.xml
		#cello 5.1.2.1-3 and above:
		#-rw-rw-rw-  3145728    6 Sep 2006 14:58:46  /c/logfiles/audit_trail/SHELL_AUDITTRAIL_LOG.xml
		#-rw-rw-rw-  2999995    6 Sep 2006 08:13:21  /c/logfiles/audit_trail/CORBA_AUDITTRAIL_LOG.xml
			#cello 5.1 and above:
		#-rw-rw-rw-  26565     18 Aug 2005 16:15:26  /c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml
		#-rw-rw-rw-  32679     18 Aug 2005 16:00:26  /c/logfiles/alarm_event/ALARM_LOG.xml
		#-rw-rw-rw-  307       18 Aug 2005 15:41:40  /c/logfiles/alarm_event/EVENT_LOG.xml
		#-rw-rw-rw-  44453     19 Aug 2005 00:32:27  /c/logfiles/security/CELLO_SECURITYEVENT_LOG.xml
		#-rw-rw-rw-  20686     19 Aug 2005 00:32:31  /c/logfiles/audit_trail/CELLO_AUDITTRAIL_LOG.xml
		#-rw-rw-rw-  103713    18 Aug 2005 15:57:57  /c/logfiles/audit_trail/AUDIT_TRAIL_LOG.xml
		#-rw-rw-rw-  7092      18 Aug 2005 16:15:26  /c/logfiles/systemlog/00000syslog
		#-rw-rw-rw-  26268     28 Oct 2005 09:27:13  /c/systemfiles/cello/cma/su/Trace.log
		#-rw-rw-rw-  8262      30 Dec 2005 10:20:01  /c/logfiles/hw_inventory/CELLO_HWINVENTORY_LOG.xml
			#cello 5:
		#-rw-rw-rw-  121798    18 Aug 2005 12:48:52  /c/logfiles/cello/CELLO_AVAILABILITY2_LOG.xml
		#-rw-rw-rw-  61637     17 Aug 2005 13:31:08  /c/logfiles/cello/CELLO_ALARM_LOG.xml
		#-rw-rw-rw-  47002     17 Aug 2005 13:32:07  /c/logfiles/cello/CELLO_EVENT_LOG.xml
		#-rw-rw-rw-  335       26 Jul 2005 11:33:51  /c/logfiles/cello/security/CELLO_SECURITYEVENT_LOG.xml
		#-rw-rw-rw-  27167     13 Aug 2005 19:24:35  /c/logfiles/systemlog/00000syslog
		#-rw-rw-rw-  568       10 Dec 2005 10:32:35  /c/tmp/Trace.log
		#-rw-rw-rw-  8262      30 Dec 2005 10:20:01  /c/logfiles/hw_inventory/CELLO_HWINVENTORY_LOG.xml
			#cello 4 and below:
		#-rw-rw-rw-  72        19 May 2005 02:59:23  /c/logfiles/logattributes/CELLO_ALARM_LOG.def
		#-rw-rw-rw-  79        19 May 2005 02:59:23  /c/logfiles/logattributes/CELLO_AVAILABILITY_LOG.def
		#-rw-rw-rw-  71        19 May 2005 02:59:23  /c/logfiles/logattributes/CELLO_EVENT_LOG.def
		#-rw-rw-rw-  2999998   18 Aug 2005 08:36:37  /c/logfiles/cello/CELLO_ALARM_LOG.xml
		#-rw-rw-rw-  999996    18 Aug 2005 08:34:18  /c/logfiles/cello/CELLO_AVAILABILITY_LOG.xml
		#-rw-rw-rw-  499994    17 Aug 2005 08:35:03  /c/logfiles/cello/CELLO_EVENT_LOG.xml
		#-rw-rw-rw-  1047671   27 Jul 2005 02:01:35  /c/logfiles/systemlog/00010syslog
		#-rw-rw-rw-  568       10 Dec 2005 10:32:35  /c/tmp/Trace.log
		if ($1 ~ /^-[-r]/ && $NF !~ "logattributes")
		{
			#for cases when there is both the cpp5 and cpp5.1 avlog/alarmlog/evlog on the same node. We want to take the first one which will be the cpp5.1
			if (comcli> 0)
			{
				#RCS
				#-rw-r--r-- eanzmagn             2605 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/AiLog_20140515123749
				#-rw-r--r-- eanzmagn          1597174 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/AuditTrailLog_20140515123751
				#-rw-r--r-- eanzmagn          7740686 Jun 5  19:06 /home/eanzmagn/.../cpplogs/rcslogs/esi.20140606T000556+0000.tar.gz
				#-rw-r--r-- eanzmagn           243687 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/NotificationLog_20140515135324
				#-rw-r--r-- eanzmagn             7215 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/RBS_CS_AVAILABILITY_LOG_20140606000556.xml.gz
				#-rw-r--r-- eanzmagn            22320 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/SecurityLog_20140515130626
				#-rw-r--r-- eanzmagn             3000 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/SwmLog_20140515123615
				#-rw-r--r-- eanzmagn            53728 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/SystemLog_20140515123721
				#-rw-r--r-- eanzmagn            53728 Jun 5  19:05 /home/eanzmagn/.../cpplogs/rcslogs/AlarmLog_20140515123721
				#RCS new
				#-rw-r--r-- 1 eanzmagn rnd 9591 Jul 17 13:16 rcslogs/rcs/saf_log/saLogAlarm/saLogAlarm_20140612__141322.log
				#-rw-r--r-- 1 eanzmagn rnd 9591 Jul 17 13:16 rcslogs/SystemLog_20140612141720
				#-rw-r--r-- 1 eanzmagn rnd    0 Jun 12 16:13 rcslogs/rcs/saf_log/saLogSystem/saLogSystem_20140612__141322.log


				#PICO
				#-rw-r----- eanzmagn              865 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/permanent/oss/alarmlog.log
				#-rw-r----- eanzmagn              865 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/permanent/oss/alarmlog.log.1
				#-rw-r----- eanzmagn              865 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/permanent/oss/alarmlog.log.2
				#-rw-r----- eanzmagn             4975 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/permanent/oss/AutointegrationLog.txt
				#-rw-r----- eanzmagn             2352 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/permanent/oss/sysevent
				#-rw-r----- eanzmagn             1092 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/volatile/log/fmevents.log
				#-rw-r----- eanzmagn            53886 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/volatile/log/security
				#-rw-r----- eanzmagn            53886 Jun 5  19:29 /home/eanzmagn/.../cpplogs/picologs/volatile/log/runtime

				if ($NF~/(\/rcslogs\/AiLog_|\/permanent\/(log\/)?oss\/AutointegrationLog.txt)/) { xmlLog["hw"]=$NF ; foundXmlLog["hw"]=1 }
				else if ($NF~/\/rcslogs\/AuditTrailLog_/) { xmlLog["a_t"]=$NF ; xmlLog["atr"]=$NF ; foundXmlLog["a_t"]=1 ; foundXmlLog["atr"]=1}
				else if ($NF~/\/rcslogs\/OotLog_/) { xmlLog["ipcs"]=$NF ; foundXmlLog["ipcs"]=1 }
				else if ($NF~/\/rcslogs\/RBS_CS_AVAILABILITY_LOG_/) { xmlLog["av"]=$NF ; foundXmlLog["av"]=1 }
				else if ($NF~/(\/rcslogs\/SecurityLog_|\/volatile\/log\/security)/) { xmlLog["sec"]=$NF ; foundXmlLog["sec"]=1 }
				else if ($NF~/(\/rcslogs\/SwmLog_|\/permanent\/(log\/)?oss\/SWUpgradeLog)/) { xmlLog["upg"]=$NF ; foundXmlLog["upg"]=1 }
				else if ($NF~/(\/rcslogs\/(SystemLog_|saLogSystem_.*\.log$)|\/permanent\/(log\/)?oss\/sysevent)/) { xmlLog["sys"]=$NF ; foundXmlLog["sys"]=1 }
				else if ($NF~/(\/rcslogs\/(AlarmLog_|saLogAlarm_.*\.log$)|\/permanent\/(log\/)?oss\/alarmlog.log)/)
				{
					#if (/\/rcslogs\/saLogAlarm_.*\.log$/) xmlLog["al"]=xmlLog["al"]" "$NF  ; else xmlLog["al"]=$NF
					xmlLog["al"]=xmlLog["al"]" "$NF
					foundXmlLog["al"]=1
				}
				else if ($NF~/(\/rcslogs\/(NotificationLog_|saLogNotification_.*\.log$)|\/volatile\/log\/fmevents.log)/) { xmlLog["ev"]=$NF ; foundXmlLog["ev"]=1 }
				else if ($NF~/\/rcslogs\/rcs\//) { xmlLog["xb"]=gensub(/\/rcs\/.*$/,"/rcs",1,$NF) ; foundXmlLog["xb"]=1 }
				else if ($NF~/\/volatile\/log\/(permanent\/oss\/)?runtime[^/]*$/)
				{
					if ($NF ~ /\/runtime$/) { xmlLog["llog"]=$NF ; foundXmlLog["llog"]=1 }
					xmlLog["a_t"]=xmlLog["a_t"]" "$NF
					foundXmlLog["a_t"]=1
				}
				else if ($NF~/(\/rcslogs\/TnNetworkLog_.*\.log$)/) { xmlLog["ipc"]=xmlLog["ipc"]" "$NF ; foundXmlLog["ipc"]=1 }
				else if ($NF~/(\/rcslogs\/TnApplicationLog_.*\.log$)/) { xmlLog["rlib"]=xmlLog["rlib"]" "$NF ; foundXmlLog["rlib"]=1 }
				else if ($NF~/(\/rcslogs\/BatteryLog.*\.log$)/) { xmlLog["bgf"]=xmlLog["bgf"]" "$NF ; foundXmlLog["bgf"]=1 }
				else if ($NF~/(\/(rcslogs\/)?llog\.log$)/) { xmlLog["llog"]=$NF ; foundXmlLog["llog"]=1 }   #in online mode llog.log/teread.log are under $tempdir/rcslogs
				else if ($NF~/(\/(rcslogs\/)?teread\.log$)/) { xmlLog["te"]=$NF ; foundXmlLog["te"]=1 }     #in offline mode llog.log/teread.log are under $tempdir/cpplogs
				else if ($NF~/(\/(rcslogs\/)?pmdzpm\.log$)/) { xmlLog["pmd"]=$NF ; foundXmlLog["pmd"]=1 }     #in offline mode llog.log/teread.log are under $tempdir/cpplogs
				continue
			}

			if ($NF ~ /AVAILABILITY.*xml$|\/(CELLO_)*(ALARM|EVENT).*xml$/) tmp_aevlist[$NF]=1
			else if ($NF ~ /CELLO_HWINVENTORY.*xml$/)                 { xmlLog["hw"]=$NF    ; foundXmlLog["hw"]=1  }
			else if ($NF ~ /(ANR|TPS)_EVENTLOG.xml$/)
			{
				xmlLog["anr"]=xmlLog["anr"]" "$NF
				foundXmlLog["anr"]=1
			}
			#else if ($NF ~ /(CORBA_AUDITTRAIL|AUDIT_TRAIL).*xml$/)    { xmlLog["a_t"]=$NF  ; foundXmlLog["a_t"]=1 }
			#else if ($NF ~ /(CELLO|SHELL)_AUDITTRAIL.*xml$/)          { xmlLog["atr"]=$NF  ; foundXmlLog["atr"]=1 }
			else if ($NF ~ /(CORBA_AUDITTRAIL|PNP_LOG).*(xml|push)$/ && ocount < 30)
			{
				xmlLog["a_t"]=xmlLog["a_t"]" "$NF
				foundXmlLog["a_t"]=1
				ocount++
			}
			else if ($NF ~ /SHELL_AUDITTRAIL.*(xml|push)$/ && lcount < 30)
			{
				xmlLog["atr"]=xmlLog["atr"]" "$NF
				foundXmlLog["atr"]=1
				lcount++
			}
			else if ($NF ~ /CELLO_SECURITYEVENT_LOG.*(xml|push)$/ && ycount < 30)
			{
				xmlLog["sec"]=xmlLog["sec"]" "$NF
				foundXmlLog["sec"]=1
				ycount++
			}
			else if ($NF ~ /CELLO_IPTRAN_LOG.*(xml|push)$/ && zcount < 30)
			{
				xmlLog["ipc"]=xmlLog["ipc"]" "$NF
				foundXmlLog["ipc"]=1
				zcount++
			}
			else if ($NF ~ /CELLO_IPTRAN_DEBUG_LOG.*(xml|push)$/ && dcount < 30)
			{
				xmlLog["ipd"]=xmlLog["ipd"]" "$NF
				foundXmlLog["ipd"]=1
				dcount++
			}
			else if ($NF ~ /RLIB_PM_LOG.*(xml|push)$/ && qcount < 30)
			{
				xmlLog["rlib"]=xmlLog["rlib"]" "$NF
				foundXmlLog["rlib"]=1
				qcount++
			}
			else if ($NF ~ /Trace.log(_old)?$|Trace.txt$|_Trace_.*\.(txt|push)$/ && ucount < 10)
			{
				#Trace.log
				#Trace.log_old
				#T821156109_Trace_20131128T091955.push
				#T821156109_Trace_20131222T141006.txt
				#Trace.txt
				xmlLog["upg"]=xmlLog["upg"]" "$NF
				foundXmlLog["upg"]=1
				ucount++
			}
			else if (where != "")
			{
				#scount and ucount are protections for offline mode in case the directory contains a large number of syslog/Trace.log
				#it prevents to concatenate a too large number of them, only the first 10 or 15 are concatenated.
				if ($NF ~ /syslog$/ && scount < 15)
				{
					xmlLog["sys"]=xmlLog["sys"]" "$NF
					foundXmlLog["sys"]=1
					scount++
				}
				else if ($NF ~ /teread.log$/)
				{
					xmlLog["te"]=$NF
					foundXmlLog["te"]=1
				}
				else if ($NF ~ /llog.log$/)
				{
					xmlLog["llog"]=$NF
					foundXmlLog["llog"]=1
				}
				else if ($NF ~ /pmdzpm.log$/)
				{
					xmlLog["pmd"]=$NF
					foundXmlLog["pmd"]=1
				}
				else if ($NF ~ /ls.log$/)
				{
					xmlLog["ls"]=$NF
					foundXmlLog["ls"]=1
				}
				else if ($NF ~ /bp.log$/)
				{
					xmlLog["bp"]=$NF
					foundXmlLog["bp"]=1
				}
				else if ($NF ~ /xblogs\/fetch.log$/)
				{
					xmlLog["xb"]=gensub(/\/fetch.log$/,"",1,$NF)
					foundXmlLog["xb"]=1
				}
				else if ($NF ~ /telog.*gz$/)
				{
					xmlLog["ted"]=xmlLog["ted"]" "$NF
					foundXmlLog["ted"]=1
				}
				else if ($NF ~ /BGF\/.*txt$/)
				{
					xmlLog["bgf"]=xmlLog["bgf"]" "$NF
					foundXmlLog["bgf"]=1
				}
				else if ($NF ~ /ipcs_logs\/.*txt$/)
				{
					xmlLog["ipcs"]=xmlLog["ipcs"]" "$NF
					foundXmlLog["ipcs"]=1
				}
			}
		}
	}
	close(tempgalog)
	xmlLog["upg"]=sort_upgtrace(xmlLog["upg"])
	#This part is for finding the alarm/event/availability logs on CPP5.0 and below
	n=asorti(tmp_aevlist)
	#1 /c/logfiles/alarm_event/ALARM_LOG.xml                     cpp5.1
	#2 /c/logfiles/alarm_event/EVENT_LOG.xml                     cpp5.1
	#3 /c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml      cpp5.1
	#4 /c/logfiles/cello/CELLO_ALARM_LOG.xml                     cpp5 and below
	#5 /c/logfiles/cello/CELLO_AVAILABILITY2_LOG.xml             cpp5
	#6 /c/logfiles/cello/CELLO_AVAILABILITY_LOG.xml              cpp4 and below
	#7 /c/logfiles/cello/CELLO_EVENT_LOG.xml                     cpp5 and below
	if (CelloVersion=="" || where!="")
	{
		#if we don't know the cello version, we take the log from the latest cello version
		#for al/ev/av, it the one with the lowest index
		for (i=n;i>=1;i--)
		{
			if      (tmp_aevlist[i] ~ /([^Y]|^)EVENT/)   { xmlLog["ev"]=tmp_aevlist[i]          ; foundXmlLog["ev"]=1 }
			else if (tmp_aevlist[i] ~ /ALARM/)        { xmlLog["al"]=tmp_aevlist[i]          ; foundXmlLog["al"]=1 }
			else if (tmp_aevlist[i] ~ /AVAILABILITY/) { xmlLog["av"]=tmp_aevlist[i]   ; foundXmlLog["av"]=1 }
		}
	}
	else if (CelloVersion < "5")
	{
		#cpp4 and below
		xmlLog["ev"]="/c/logfiles/cello/CELLO_EVENT_LOG.xml"          ; foundXmlLog["ev"]=1
		xmlLog["al"]="/c/logfiles/cello/CELLO_ALARM_LOG.xml"          ; foundXmlLog["al"]=1
		xmlLog["av"]="/c/logfiles/cello/CELLO_AVAILABILITY_LOG.xml"   ; foundXmlLog["av"]=1
	}
	else if (CelloVersion >= "5.1")
	{
		#cpp5.1 and above
		xmlLog["ev"]="/c/logfiles/alarm_event/EVENT_LOG.xml"                  ; foundXmlLog["ev"]=1
		xmlLog["al"]="/c/logfiles/alarm_event/ALARM_LOG.xml"                  ; foundXmlLog["al"]=1
		xmlLog["av"]="/c/logfiles/availability/CELLO_AVAILABILITY2_LOG.xml"   ; foundXmlLog["av"]=1
	}
	else
	{
		#cpp5
		xmlLog["ev"]="/c/logfiles/cello/CELLO_EVENT_LOG.xml"                        ; foundXmlLog["ev"]=1
		xmlLog["al"]="/c/logfiles/cello/CELLO_ALARM_LOG.xml"                        ; foundXmlLog["al"]=1
		xmlLog["av"]="/c/logfiles/cello/CELLO_AVAILABILITY2_LOG.xml"                ; foundXmlLog["av"]=1
	}
	#xmlLog["a_t"]="/c/logfiles/audit_trail/AUDIT_TRAIL_LOG.xml"
	#xmlLog["atr"]="/c/logfiles/audit_trail/CELLO_AUDITTRAIL_LOG.xml"
}
function sort_upgtrace(list,  a,i,j,ret,l)
{
	if (comcli>0) return list
	#put the files in the following order:
	l[1]="systemfiles/cello/cma/su/Trace.log_old$"        #>= CPP5.1
	l[2]="systemfiles/cello/cma/su/Trace.log$"            #>= CPP5.1
	l[3]="systemfiles/cello/cma/su/trace/Trace.log_old$"  #>= CPP6.1
	l[4]="systemfiles/cello/cma/su/trace/Trace.log$"      #>= CPP6.1
	l[5]="logfiles/su/.*_Trace_.*.(txt|push)$"            #>= C14B
	l[6]="logfiles/su/Trace.txt$"                         #>= C14B
	split(list,a," ")
	for (i=1;i<=6;i++)
	{
		for (j in a)
		{
			if (a[j] ~ l[i]) { ret=ret" "a[j] ; break }
		}
	}
	sub(/^ */,"",ret)
	if (mosdebug==1) print "sorted_upgtrace="ret
	return ret
}
function parse_days(today,startdate,enddate,minustime,plustime,  array,a,number)
{
	if (today==999)
	{
		customPrint("Unable to find out the current date!")
		return 999
	}
	number["m"]=60 ; number["h"]=3600 ; number["d"]=number[""]=86400
	if (startdate ~ /^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9]/) startdate=make_timestamp(startdate)
	else if (startdate != "") { customPrint("Wrong format in the -s option!") ; return 999 }
	else if (minustime ~ /^[0-9]+[dhm]?$/) startdate= today - maxTime(minustime * number[gensub(/^[0-9]+/,"",1,minustime)])
	else if (minustime != "") { customPrint("Wrong format in the -m option!") ; return 999 }
	else startdate= -1E8
	if (enddate ~ /^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9]/) enddate=make_timestamp(enddate)
	else if (enddate != "") { customPrint("Wrong format in the -e option!") ; return 999 }
	else if (plustime ~ /^[0-9]+[dhm]?$/) enddate=startdate + plustime * number[gensub(/^[0-9]+/,"",1,plustime)]
	else if (plustime != "") { customPrint("Wrong format in the -p option!") ; return 999 }
	else enddate=getTodayUTC()+86400
	return startdate";"enddate
}
function maxTime(timesecs)
{
	if (timesecs>2000000000) return 2000000000
	return timesecs
}
function settz(what,s,e,m,    tz)
{
	#a workaround for solaris/sparc where the third argument in mystrftime (to print time in utc) does not work when the date is within the daylight saving time range
	#example: gawk 'BEGIN{print mystrftime("%Y-%m-%d %H:%M:%S",1241572680,1)}' --> gives 2009-05-06 03:18:00 on solaris/sparc but 01:18:00 on all other platforms
	#update: the fault happens also on some solaris/x86 so let's do the correction on both sunsparc and sun86
	tz=""
	if (os ~ /^sunsparc/ || os=="sun86")
	{
		if (comcli==0 && what ~ /^(al|ev)$/) #|| (what == "mos" && m == 1)
		{
			tz="TZ=UTC StartDate="mystrftime("%Y%m%d.%H%M%S",s)" EndDate="mystrftime("%Y%m%d.%H%M%S",e)" "
		}
	}
	return tz
}
function make_absolute_path(string)
{
	if (string !~ /^\//) string=fileOps("pwd")"/"string
	return string
}
function getTodayFromLogfiles(file,    unzip_session,line,res,a,b,thedate)
{
	res=""
	unzip_session="unzip -p "file" bp.log ls.log llog.log pmdzpm.log rcslogs/date.log 2>/dev/null"
	while (unzip_session |& getline line)
	{
		#Log close: 130816-080445 - /proj/tfwlogs_wmr/users/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20130816-074854_20793/bp20828.log
		#Log close: 160623-234821 - /home/rns1/moshell_logfiles/logs_moshell/tempfiles/20160623-174849_9324/rcslogs/date.log
		split(line,b," ")
		if (b[1]=="Log" && b[2]=="close:" && b[4]=="-")
		{
			split(b[3],a,"")
			thedate=sprintf("20%d%d %d%d %d%d %d%d %d%d %d%d",a[1],a[2],a[3],a[4],a[5],a[6],a[8],a[9],a[10],a[11],a[12],a[13])
			res=mymktime(thedate)+100000  #the date in bp.log or ls.log plus one day
		}
	}
	close(unzip_session)
	if (res=="") res=getTodayUTC()
	else customPrint("Date of log collection: "strftime("%Y-%m-%d",res))
	return res
}
function LogService(logswitch,   pipeCommand,n,i,whatlist,allip_session,allip_inputvars,merge,zip_session,unzip_session,today,array,fetchResultList,\
line,telnet_session,minustime,plustime,startdate,enddate,lglogdir,lgfdir,tmpswitch,lgzipfile,pwd,what,tmptime,indate,old_startdate,dspdumpzipfile,\
cp_session,mv_session,maxfiles,resarray)
{
	if (multi) return multi_error()
	if (comcli>0)
	{
		if (logswitch !~ /^[abdeghvsuolykztfcinmr01jx45p]+$/)
		{
			gsub(/[^abdeghvsuolykztfcinmr01jx45p]/,"",logswitch)
			customPrint("Info: some options are not supported on COM nodes and will be ignored.\n\
Only the following options are currently supported: abdeghjvsuoplykzt45fcinmr")
		}
		#return comcli_error()
	}
	lgnodefilter=dotnode_address".log"
	#options: aevsmircduoOUylh: alarm,event,avail,sys,merge,inverse,refresh,csv,downtime,upgrade,commandlog,audittrail,???,security,audit_trail,hili
	#lgd <logfile> startdate;enddate
	if (logswitch == "" && $2=="")
	{
		Display_help("lg")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	lgtgroup="all" #global variable
	lgggroup="allpd" #global variable
	startdate=enddate=minustime=plustime=lglogdir=""
	pmdlogdir=sprintf("%s/pmdfiles/%s",(pm_logdir == "" ? logdir : pm_logdir),dotnode_address)
	rupmdlogdir=sprintf("%s/pmd",pmdlogdir)  #we put the RU PMDs in the same folder as MP/BP/SP PMDs

	if (logswitch ~ "f")
	{
		if (node ~ /^OFFLINE/)
		{
			customPrint("Option \"f\" is not applicable in offline mode. Please run without the \"f\" option.")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		lgfdir=defaultLgfDir"/"mystrftime("%Y%m%d_%H%M%S",systime())
	}

	if (tolower($0) ~ /\|/) pipeCommand=sprintf("| %s",gensub(/^[^\|]*\|/,"",1,$0))
	sub(/\|.*$/,"")
	#xb filters are global variables, need to be initialised
	xbLogFilter=""
	xbFetchFilter=""
	#initialisation of maxfiles, the number of ENB DSP dumps to collect: 0 for lgp, 0 for lgf
	if (logswitch ~ "f")
	{
		maxfiles=0.5 #with lgf , the default is no ENB DSP dump fetched
		if (logswitch ~ "1") maxfiles=8  #with "lgf1" one DSP dump will be fetched by default, more can be specified by -d option
		if (comcli>0 && logswitch ~ "0") maxfiles=12345678901234567890   #with lgf0 on RCS node, ESI will not be collected
	}
	else maxfiles=0.5
	for (i=2;i<=NF;i++)
	{
		if ($i ~ /^-(m|p|s|e|l|g|n|x|b|d)$/)
		{
			     if ($i=="-m") minustime=$(i+1)
			else if ($i=="-p") plustime=$(i+1)
			else if ($i=="-s") startdate=$(i+1)
			else if ($i=="-e") enddate=$(i+1)
			else if ($i=="-l")
			{
				lglogdir=gensub(/^~\//,ENVIRON["HOME"]"/",1,gensub(/\/$/,"",1,$(i+1)))
				if (lglogdir=="")
				{
					customPrint("Error: an argument must be specified to the option \"-l\", e.g. \"-l <file>\" or \"-l <directory>\".")
					return add_to_moscomlog("","%@> Fail (Syntax error)")
				}
				if (fileOps("test -s "lglogdir)!=0 && fileOps("test -d "lglogdir)!=0)
				{
					customPrint("Error: file or directory not found: "lglogdir)
					return add_to_moscomlog("","%@> Fail (Syntax error)")
				}
				if (fileOps("test -d "lglogdir)==0 && logswitch !~ "r")
				{
					#always refresh when -l <directory>
					logswitch=logswitch"r"
				}
				old_lglogdir=lglogdir  #keep this in memory so the user does not have to type -l each time
			}
			else if ($i=="-g") lgtgroup=lgggroup=$(i+1)
			else if ($i=="-n") lgnodefilter=$(i+1)
			else if ($i=="-x") xbLogFilter=$(i+1)
			else if ($i=="-b") xbFetchFilter=$(i+1)
			else if ($i=="-d")
			{
				#number of GCPU dumps to collect
				maxfiles=$(i+1)+0
				if (maxfiles==0) maxfiles=0.5
				else if (maxfiles==1) maxfiles=8
				else if (maxfiles>=2) maxfiles=8+(maxfiles-1)*4
			}
			i++
		}
		#in case the startdate or minustime was given as argument instead of with the -s/-m option (backward compatibility)
		else if (startdate=="" && $i ~ /^[1-2][0-9][0-9][0-9][0-1][0-9][0-3][0-9](\.[0-9]+)?$/ && checkIfDir("",$i)!=0) startdate=$i
		else if (minustime=="" && $i ~ /^[0-9]+[mhd]?$/ && checkIfDir("",$i)!=0) minustime=$i
		else if (logswitch ~ "f")
		{
			if (checkIfDir("",$i)==0) lgfdir=make_absolute_path($i)
			else
			{
				customPrint("Invalid directory! Syntax: lgf [<local directory>]. Type \"h lg\" for more info.")
				return add_to_moscomlog("","%@> Fail (Syntax error)")
			}
		}
	}
	#if offline, check that the option -l was used
	if (node ~ /^OFFLINE/ && lglogdir == "")
	{
		if (old_lglogdir != "") lglogdir=old_lglogdir
		else if (logfiles_zip != "")
		{
			#try to use the <node>_logfiles.zip stored in the same folder as the MO dump
			lglogdir=logfiles_zip
		}
		else
		{
			customPrint("\nIn offline mode, the directory or zipfile containing the log files must be specified with option \"-l\".\nType \"h lg\" for more info about this option.")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
	}

	if (logswitch ~ /^[inmr]+$/) today=getTodayUTC()  #moshell commandlog
	else if (lglogdir=="" || logswitch ~ "f")
	{
		check_node_password()
		if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
		#GET TODAY FROM NODE IN CASE THE NODE IS NOT RUNNING UTC TIME (used to be: today=getTodayUTC() )
		today=getTodayFromNode()
	}
	else if (lglogdir ~ /_logfiles\.zip$/ && fileOps("test -s "lglogdir) == 0) today=getTodayFromLogfiles(lglogdir)
	else today=getTodayUTC()
	split(parse_days(today,startdate,enddate,minustime,plustime),array,";")
	if (array[1]==999) return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
	startdate=array[1] ; enddate=array[2]

	if (logswitch ~ /^[inmr]+$/ && startdate == -1E8) startdate=systime()-30*86400  #for lgn we take by default the last 30 days only
	if (logswitch ~ /[xw]/ && startdate > -1E8) { enddate=startdate ; startdate= -1E8 }
	if (logswitch ~ /[j]/ && startdate > -1E8) { old_startdate=startdate ; startdate=-1E8 }

	customPrint(sprintf("Startdate=%s, Enddate=%s",mystrftime("%Y%m%d.%H%M%S",startdate),mystrftime("%Y%m%d.%H%M%S",enddate)))

	if (logswitch ~ "f")
	{
		if (lgfdir=="") lgfdir=defaultLgfDir"/"mystrftime("%Y%m%d_%H%M%S",systime())
		if (checkIfDir("",lgfdir)!=0) fileOps("mkdir -p "lgfdir)
		#ftget -f (\.xml|syslog)$ /c/logfiles $lgfdir
		#ftget -f Trace.log /c/systemfiles $lgfdir
		if (logswitch ~ "r") what="get" ; else what="getc"
		if (comcli>0)
		{
			fetch_comlogs(what,lgfdir,startdate,enddate,"dozip","",maxfiles)
			return
		}
		#Options 0/1/2/3 are mutually exclusive and cannot be combined
		#lgf on CPP -> everything except xblog and LTE DSP dump
		#lgf on RCS -> all logs plus small ESI
		#lgf0 on RCS -> only customer logs, not ESI
		#lgf1 on RCS -> all logs plus large ESI
		#lgf1 -> everything (same as old lgf up to 10.0m)
		#lgf2 -> only xblog  -> put in logfiles2.zip
		#lgf3 -> only LTE DSP dump  -> not implemented yet, use "lgp -d <nr of dumps>"
		if (logswitch ~ /[0-9].*[0-9]/)
		{
			customPrint("\nThe numeric options in lgf cannot be combined, only one at a time. Eg: lgf1 / lgf2 / lgf3. Type \"h lg\" for more info.")
			return
		}

		if (logswitch !~ /[2-9]/)
		{
			#/c/logfiles is fetched first so that the SHELL_AUDITTRAIL will be fetched as early as possible so as for it to not contain too many commands of the dcg
			refresh_etipglog()
			ftp(what,"/c/logfiles",lgfdir,"(syslog|.xml|.push)$|/(BGF|ipcs_logs)/.*txt$|/Trace.txt$",startdate,enddate)
			ftp(what,"/c/systemfiles",lgfdir,"Trace.log",startdate,enddate) #very important to do on /c/systemfiles and not /c/systemfiles/cello/cma, to keep the folder structure
			#if there exists a previously fetched shell_audittrail_log copy it to the folder -> does not work, makes duplicates entries
			#if (fileOps("test -s "tempatrlog)==0) fileOps("cp "tempatrlog" "lgfdir"/logfiles/audit_trail/000000_000000_SHELL_AUDITTRAIL_LOG_20120000T000000.push")

			$0="fcleand "lgfdir"/logfiles" ; fcleand()
			$0="fcleand "lgfdir"/systemfiles" ; fcleand()
			if (what=="get" || (what=="getc" && fileOps("test -s "lgfdir"/teread.log")!=0)) fetch_te()
			if (what=="get" || (what=="getc" && fileOps("test -s "lgfdir"/llog.log")!=0)) fetch_llog()
			fetch_ted(startdate,lgfdir)
			if (what=="get" || (what=="getc" && fileOps("test -s "lgfdir"/ls.log")!=0)) fetch_ls()
			if (what=="get" || (what=="getc" && fileOps("test -s "lgfdir"/bp.log")!=0)) fetch_bp()
			if (what=="get" || (what=="getc" && fileOps("test -s "lgfdir"/pmdzpm.log")!=0)) fetch_pmd(startdate,enddate,lgfdir,maxfiles)
			if (fileOps("test -s "temptelog)==0)   fileOps("cp "temptelog" "lgfdir"/teread.log")
			if (fileOps("test -s "templloglog)==0) fileOps("cp "templloglog" "lgfdir"/llog.log")
			if (fileOps("test -s "temppmdzpmlog)==0) fileOps("cp "temppmdzpmlog" "lgfdir"/pmdzpm.log")
			if (fileOps("test -s "templslog)==0) fileOps("cp "templslog" "lgfdir"/ls.log")
			if (fileOps("test -s "tempbplog)==0) fileOps("cp "tempbplog" "lgfdir"/bp.log")
		}
		if (logswitch ~ /[12]/) fetch_xblog_all(startdate,enddate,what,lgfdir"/xblogs",xbFetchFilter)

		pwd=fileOps("pwd")
		Local_command("cd "lgfdir)
		lgzipfile=sprintf("%s/%s_logfiles%s.zip",lgfdir,process_nodename(node),(logswitch~"2"?"2":""))
		if (logswitch~"2")
		{
			run_system(sprintf("zip -rmD %s xblogs",lgzipfile))
		}
		else
		{
			run_system(sprintf("zip -rmD %s logfiles systemfiles pmd error %steread.log llog.log pmdzpm.log bp.log ted",lgzipfile,(logswitch~"1"?"xblogs ":"")))
			run_system(sprintf("zip %s ls.log",lgzipfile))
			dspdumpzipfile=sprintf("%s/%s_dspdump.zip",lgfdir,process_nodename(node))
			run_system(sprintf("zip -rmD %s dspdumps usr dsp_dump vpp_dump ls.log faultlogs.log datadumps.log",dspdumpzipfile))
		}
		Local_command("cd "pwd)
		if (fileOps(sprintf("test -s %s",lgzipfile))==0)
		{
			customPrint("Successful storage of the CPP logs to "lgzipfile)
			customPrint("For offline processing, run: lg[<options>] -l <zipfile>.")
			system("rm -rf "lgfdir"/logfiles "lgfdir"/systemfiles")
		}
		if (fileOps(sprintf("test -s %s",dspdumpzipfile))==0)
		{
			customPrint("Successful storage of the DSP dumps to "dspdumpzipfile)
		}
		return
	}

	if (logswitch ~ "c" && logswitch !~ /[xd]/) customPrint("Date;Time;Log;Severity;Object;Event;Cause;AdditionalText;AckState;Id;NotificationId;CorrelatedAlarms")

	if (fileOps("test -s "lglogdir) == 0)
	{
		#if the argument to -l is a zipfile or an individual logfile
		if (lglogdir ~ /\.zip$/)
		{
			lgzipfile=lglogdir
			lglogdir=tempdir"/cpplogs"
			#if it's a zip file generated by dcgf
			if (fileOps("test -d "lglogdir)!=0 || logswitch ~ "r" || lgzipfile != unzipList["lg"])
			{
				if (lgzipfile != unzipList["lg"] && unzipList["lg"] != "") system("rm -rf "lglogdir)
				system("mkdir -p "lglogdir)
				chmod(00777,lglogdir)
				unzip_session="unzip -oq "lgzipfile" -d "lglogdir
				customPrint(unzip_session)
				system(unzip_session)
				unzipList["lg"]=lgzipfile
				if (fileOps("test -d "lglogdir"/rcslogs")==0)
				{
					#the ESI and AVLOG may be gzipped, ungzip the AVLOG and untar the ESI
					pwd=fileOps("pwd")
					Local_command("cd "lglogdir"/rcslogs","silent")
					if (system("gzip -df *.gz 2>/dev/null")==0)
					{
						if (system("tar xf *.tar 2>/dev/null")==0) system("rm *.tar")  #the ESI is tared
					}
					Local_command("cd "pwd,"silent")
				}
			}
			#always do refresh when reading from offline zipfile  !
			if (logswitch !~ "r") logswitch=logswitch"r"
		}
		else
		{
			allip_inputvars=make_inputvars(logswitch,lglogdir,startdate";"enddate,"","","","",today)
			allip_session=sprintf("%s -v variables='%s' -l %s -f %s -f %s --source \x027 BEGIN{ parse_xmlsys_log(variables) } \x027 %s",gawk,allip_inputvars,filefunc,funcs,extern,pipeCommand)
			if (mosdebug==1) print allip_session
			system(allip_session)
			customPrint("")
			return
		}
	}

	if (logswitch ~ "r")
	{
		upgradeLogDir=oldUpgradeLogDir=""
		reset_lg_files()
	}
	#Note: the order of attribution of the whatlist table is very important. Do not change the order, especially regarding the "o" option.
	if (logswitch ~ "d")
	{
		#node downtime
		if (logswitch~"c") tmpswitch="dc" ; else tmpswitch="d"
		if (is_rcs()==1) logswitch="vm"
		else if (mom_version ~ /PRBS_NODE_MODEL/) logswitch="v"   #the "d" option is actually not supported on PICO
		else logswitch="%vsum"
	}
	#else if (logswitch ~ "b")
	#{
	#	#node downtime and board downtime, not implemented yet
	#	if (logswitch~"c") tmpswitch="bc" ; else tmpswitch="b"
	#	logswitch="kvsum"
	#}
	#else if (logswitch ~ "j")
	#{
	#	#the old lgd format
	#	if (logswitch~"c") tmpswitch="jc" ; else tmpswitch="j"
	#	logswitch="vsum"
	#}
	else if (logswitch ~ "x")
	{
		if (logswitch~"c") tmpswitch="xc" ; else tmpswitch="x"
		if (comcli>0) logswitch="avmc"
		else logswitch="asumc"
	}
	else if (logswitch ~ "j")
	{
		#alarm durations
		if (logswitch~"c") tmpswitch="jc" ; else tmpswitch="j"
		if (comcli>0) logswitch="avmc"
		else logswitch="asumc"
	}
	else if (logswitch ~ "w")
	{
		if (logswitch~"c") tmpswitch="wc" ; else tmpswitch="w"
		logswitch="ysumc"
	}

	if (logswitch ~ "%")    { whatlist[++n]="bp"}  #this is a internal option, not for user purpose -> important must be first so that lgvsum% will parse this first
	if (logswitch ~ "a")    { whatlist[++n]="al" }  #/c/logfiles/cello/CELLO_ALARM_LOG
	if (logswitch ~ "e")    { whatlist[++n]="ev" }  #/c/logfiles/cello/CELLO_EVENT_LOG
	if (logswitch ~ "v")    { whatlist[++n]="av" }  #/c/logfiles/cello/CELLO_AVAILABILITY_LOG
	if (logswitch ~ "s")    { whatlist[++n]="sys"}  #/c/logfiles/systemlog
	if (logswitch ~ "u")    { whatlist[++n]="upg"}  #/c/systemfiles/cello/cma/su/ (CPP5.1) or /c/systemfiles/cello/cma/su/trace (CPP6) or /c/logfiles/su (C14B)
	if (logswitch ~ /[oq]/) { whatlist[++n]="a_t"}   #/c/logfiles/audit_trail/AUDIT_TRAIL_LOG.xml, similar to commandlog (set,cr,del,acc)
	if (logswitch ~ "l")    { whatlist[++n]="atr"}  #/c/logfiles/audit_trail/CELLO_AUDITTRAIL_LOG.xml, to log the COLI commands
	if (logswitch ~ "y")    { whatlist[++n]="sec"}  #/c/logfiles/security/CELLO_SECURITYEVENT_LOG.xml, to log accesses to COLI
	if (logswitch ~ "h")    { whatlist[++n]="hw" }  #/c/logfiles/hw_inventory/CELLO_HWINVENTORY_LOG.xml, generated by hili mk
	if (logswitch ~ "z")    { whatlist[++n]="ipc"}  #/c/logfiles/iptran/CELLO_IPTRAN_LOG.xml
	if (logswitch ~ "@")    { whatlist[++n]="ipd"}  #/c/logfiles/iptran/CELLO_IPTRAN_DEBUG_LOG.xml (internal option used by pmxi, not for user purpose)
	if (logswitch ~ "n")    { whatlist[++n]="mos"}  #moshell_logfiles/logs_moshell/moscomlogs/node_address.log
	if (logswitch ~ "t")    { whatlist[++n]="te" }  #lh lgtgroup te log read
	if (logswitch ~ "g")    { whatlist[++n]="llog"} #lh lgggroup llog -l (except ru where we do llog -l -n 10)
	if (logswitch ~ "p")    { whatlist[++n]="pmd"}  #fetch and parse pmd files
	if (logswitch ~ "k")    { whatlist[++n]="xb"}   #Fetch and parse ethernet backplane switch board logs
	if (logswitch ~ "b")    { whatlist[++n]="rlib"} #fetch and parse RLIB_PM_LOG.xml
	if (logswitch ~ "1")    { whatlist[++n]="ls"}
	if (logswitch ~ "2")    { whatlist[++n]="ted"}  #/d/usr/cello/telogs
	if (logswitch ~ "3")    { whatlist[++n]="anr"}  #/c/logfiles/SON/ANR_EVENTLOG.xml
	if (logswitch ~ "4")    { whatlist[++n]="bgf"}  #/c/logfiles/BGF
	if (logswitch ~ "5")    { whatlist[++n]="ipcs"}  #/c/logfiles/ipcs_logs
	if (logswitch ~ "m")    { merge=1 ; fileOps("rm "tempmergelog) }
	#if (tolower($0) ~ /^[ \t]*lg[aevrsim]*[ \t]*[0-9]*[ \t]*\|/) pipeCommand=sprintf("| %s",gensub(/^[^\|]*\|/,"",1,$0))
	for (i=1;i<=n;i++)
	{
		fetchResultList[whatlist[i]]=fetchXmlLog(whatlist[i],lglogdir,startdate,enddate,maxfiles) #we do the fetching first otherwise the logfile collide if we are doing a merge
		#special case for RCS nodes, the "a_t" and "atr" logs are the same, namely the AuditTrailLog
		if (mom_version ~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/ && whatlist[i]~/^(a_t|atr)$/) fetchResultList["atr"]=fetchResultList["a_t"]=fetchResultList[whatlist[i]]
	}
	if (logswitch ~ "m")
	{
		mo_log(tempmergelog,"open","mute","overwrite","silent")
		muteFactor=100000
	}
	for (i=1;i<=n;i++)
	{
		if (fetchResultList[whatlist[i]] != 1) continue
		allip_inputvars=make_inputvars(logswitch,xmlTempLog[whatlist[i]],startdate";"enddate,"","","",whatlist[i],today)
		#in lgd, we must collect the whole availability log in order to get the correct uptime for the node
		if (tmpswitch ~ "d" && whatlist[i]=="av") allip_inputvars=make_inputvars(logswitch,xmlTempLog[whatlist[i]],-1E8";"enddate,"","","",whatlist[i],today)
		if (merge != 1)
		{
			allip_session=sprintf("%s%s -v variables='%s' -l %s -f %s -f %s --source \x027 BEGIN{ parse_xmlsys_log(variables) } \x027 %s",settz(whatlist[i],startdate,enddate,merge),gawk,allip_inputvars,filefunc,funcs,extern,pipeCommand)
			if (mosdebug==1) print allip_session
			system(allip_session)
			customPrint("")
		}
		else
		{
			printf("Parsing %s...",gensub(/^\/.*\/|[0-9].*$/,"","g",xmlTempLog[whatlist[i]]))
			allip_session=sprintf("%s%s -v variables='%s' -l %s -f %s -f %s --source \x027 BEGIN{ parse_xmlsys_log(variables) } \x027",settz(whatlist[i],startdate,enddate,merge),gawk,allip_inputvars,filefunc,funcs,extern)
			if (mosdebug==1) print allip_session
			system(allip_session)
			print "Done."
			print "" >> tempmergelog   #very important to have an empty line between each log otherwise timestamp order can be wrong
		}
	}
	if (merge==1)
	{
		if (logswitch ~ /^[uvsmyc]+$/ && lglogdir=="")
		{
			#1) workaround for the RNC node restart completed does not always appear in avlog so we fetch it from te log
			#2) print the number of active telnet/ssh/ftp connections in lgw

			telnet_session=enter_telnet_login(node_address,node_password)
			if (telnet_session !~ /Unable to connect|Wrong Password/)
			{
				if (tmpswitch ~ "w") print "readclock\ndsock client list port\nrsock -fln\nexit" |& telnet_session
				else if (logswitch ~ /^[uvsm]+$/) print "te log read\nexit" |& telnet_session
				while (telnet_session |& getline line)
				{
					gsub("\r","",line)
					#[2006-04-03 09:53:11.412] rlibRestartAvliControllerC ../src/RlibRestartAvliControllerC.cpp:186 INFO:RNC Node Restart Completed
					#Date: 2005-08-11 UTC Time: 07:33:16. Thursday
					#Date: 2005-08-11 Time: 07:31:36. Thursday
					#rsock -fln :
					#9    91     TCP   0x8f31   ose_telnet_1                   setsockopt(65535,8,0x1) 9=accept(6,147.214.195.156:40461) eof_event(0) read_event(1) fcntl(0x4,6)
					#6    96     TCP   0x8f31   sshd_handler                   setsockopt(65535,8,0x1) setsockopt(65535,4098,0xffff) setsockopt(65535,4097,0xffff) 6=accept(1,137.58.211.24:43483) eof_event(0) error_event(0) read_event(1) fcntl(0x4,0) fcntl(0x4,4)
					#9    91     TCP   0x8f31   ose_ftpd_spa                   setsockopt(65535,8,0x1) 9=accept(8,147.214.195.156:42840)
					#dsock client list port:
					#ose_telnet_147.214.195.156:57853-175441539
				   	#sshd_handler_147.214.195.156:60705-147326733
					#ose_ftpd_spawn-230885056
					if (line ~ / INFO:RNC Node Restart Completed/)
					{
						split(line,array," ")
						print gensub(/\[/,"",1,array[1]),gensub(/\..*$/,"",1,array[2]),"T&E  ","RNC Node Restart Completed" >> tempmergelog
					}
					else if (line ~ /^Date: /)
					{
						last=split(line,array," ")
						for (i=3;i<=last;i++) if (array[i] == "Time:") tmptime=gensub(/\.$/,"",1,array[i+1])
						print array[2]";"tmptime".000;READCLOCK" >> tempmergelog
						tmptime=tmptime".001"
						indate=1
					}
					else if (indate) print array[2]";"tmptime";"line >> tempmergelog
				}
				close(telnet_session)
			}
		}
		mo_log(tempmergelog,"close")
		if (tmpswitch!="")
		{
			mo_log(tempgalog,"open","mute","overwrite","silent")
			muteFactor=100000
		}
		allip_inputvars=make_inputvars(logswitch,tempmergelog,"","","","","",today)
		allip_session=sprintf("%s -v variables='%s' -l %s -f %s -f %s --source \x027 BEGIN{ sortMerge(variables) } \x027 %s",gawk,allip_inputvars,filefunc,funcs,extern,pipeCommand)
		if (mosdebug==1) print allip_session
		system(allip_session)
		if (tmpswitch!="")
		{
			mo_log(tempgalog,"close")
			allip_inputvars=make_inputvars(tmpswitch,tempgalog,sprintf("%s;%s",(tmpswitch~"j"?old_startdate:startdate),enddate),"","","","",today)
			allip_session=sprintf("%s -v variables='%s' -l %s -f %s -f %s --source \x027 BEGIN{ parse_xmlsys_log(variables) } \x027 %s",gawk,allip_inputvars,filefunc,funcs,extern,pipeCommand)
			if (mosdebug==1) print allip_session
			system(allip_session)
		}
	}
}
function process_nodename(thetext)
{
	#remove spaces, tabs from the node name
	#replace colons (:) with dots in the node ip (if ipv6)
	gsub(/[ \t]/,"",thetext)
	gsub(/:/,".",thetext)
	return thetext
}
function run_system(thesession)
{
	customPrint(thesession)
	return system(thesession)
}
function fetch_comlogs(what,lgfdir,startdate,enddate,dozip,logtype,maxfiles,   res,resdir)
{
	if (Start_moMode()==1) return 1
	if (mom_version ~ /PRBS_NODE_MODEL/)
	{
		resdir=fetch_picologs(what,lgfdir,startdate,enddate,logtype,dozip)
		if (dozip=="dozip") ziplogs(lgfdir,"picologs",maxfiles)
		else reset_lg_files(1)
		return 0 SUBSEP resdir
	}
	else if (mom_version ~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/)
	{
		resdir=fetch_rcslogs(what,lgfdir,startdate,enddate,logtype,dozip,maxfiles)
		if (dozip=="dozip") ziplogs(lgfdir,"rcslogs",maxfiles)
		#else reset_lg_files(1)
		return 0 SUBSEP resdir
	}
	else
	{
		customPrint("\nlg is currently not supported on this type of COM node.")
		return 1
	}
}
function fetch_picologs(what,lgfdir,startdate,enddate,logtype,dozip,    tlgdir,pT)
{
	if (dozip=="" && logtype !~ /^(al|ev|sys|upg|sec|hw|llog|a_t)$/)
	{
		customPrint("\nThis lg option is unsupported for this type of node.")
		return add_to_moscomlog("","%@> Fail (Syntax error)","",999)
	}
	tlgdir=tempdir"/picologs"
	if (dozip=="dozip")
	{
		if (mom_version ~ /^[WM]PRBS_NODE_MODEL/)
		{
			ftp("delf","/var/volatile/log","","[/](Pma|Iub|Boam|Core.)_traceLog.dmp$")
			comcli_cmd("femtolog -snapshot")
		}
		system("rm -rf "tlgdir)
		fileOps("mkdir -p "tlgdir)
		fileOps("mkdir -p "tlgdir"/permanent/log")
		fileOps("mkdir -p "tlgdir"/persistent/log")
		fileOps("mkdir -p "tlgdir"/volatile")
		ftp(what,"/var/permanent/log/oss",tlgdir"/permanent/log","!/PerformanceManagementReportFiles/",startdate,enddate)
		ftp(what,"/var/persistent/log/oss",tlgdir"/persistent/log","!/PerformanceManagementReportFiles/",startdate,enddate)
		ftp(what,"/var/volatile/log",tlgdir"/volatile","!/PerformanceManagementReportFiles/",startdate,enddate)
		ftp(what,"/var/persistent/tmp",tlgdir"/persistent","!/PerformanceManagementReportFiles/",startdate,enddate)
		if (mom_version ~ /^[WM]PRBS_NODE_MODEL/)
		{
			ftp("delf","/var/volatile/log","","[/](Pma|Iub|Boam|Core.)_traceLog.dmp$")
		}
		#reset_lg_files(1)
		return tlgdir
	}
	pT["al"]="alarmlog.log$"
	pT["ev"]="fmevents.log$"
	pT["sys"]="sysevent$"
	pT["upg"]="SWUpgradeLog.txt$"
	pT["sec"]="security$"
	pT["hw"]="AutointegrationLog.txt$"
	pT["llog"]="runtime$" #"runtime([.][1-9])?$"
	pT["a_t"]="runtime[^/]*$"
	#if (comLogFetched[logtype]==1) return tlgdir
	fileOps("mkdir -p "tlgdir)
	ftp(what,"/var/volatile/log",tlgdir"/volatile",pT[logtype],"","")
	#comLogFetched[logtype]=1
	return tlgdir
}
function convert_export_method(    old_dollar)
{
	if (export_method==3)
	{
		if (use_tls>0)
		{
			old_dollar=$0 #backup the $0
			if (node_password=="nopassword") node_password=""
			check_node_password("sftp")
			#if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
			$0=old_dollar #restore $0
		}
		export_method=2
		export_server=node_address
		export_username=username
		export_password=node_password
		if (export_username=="root" && export_dir=="") export_dir="/home" #On nodes like vSAPC where there are two cores SC-1/SC-2 the /root folder is different on each core so we should use a NFS mounted folder like /home
		return ftp_port
	}
	else return export_port
}
function fetch_rcslogs(what,lgfdir,startdate,enddate,logtype,dozip,maxfiles,    commandList,z,tlgdir,i,logList,motypes,sleeptime,startime,pwd,thepassword,theusername,theserver,loclgdir,thepwfile,sep,thelogid,to,granularity,logmoc,currLog,actionId,tgranu,ciphers,theserverport)
{
	if (mosdebug==1) print "what="what", logtype="logtype,comLogFetched[logtype]", dozip="dozip", maxfiles="maxfiles
	tlgdir=tempdir"/rcslogs"
	if (comLogFetched[logtype]==1) return tlgdir
	#motypes["log"]=motypes["logm"]=1
	#ConditionalLoad(motypes)
	load_subtree("SystemFunctions=1,LogM=1","conditional")
	if ((nrOfMoType(fullmoc("logm"))+nrOfMoType(fullmoc("log")))==0)
	{
		customPrint("\nNo logs found!")
		return add_to_moscomlog("","%@> Fail (Syntax error)","",999)
	}
	define_rcs_logs()
	if ((logtype in rcsLogName && rcsLogName[logtype]!="")||(logtype~/^(xb|av|llog|te|pmd)$/)||(dozip=="dozip")) {}
	else
	{
		customPrint("\nThis lg option is unsupported for this type of node.")
		return add_to_moscomlog("","%@> Fail (Syntax error)","",999)
	}
	system("rm -rf "tlgdir)
	fileOps("mkdir -p "tlgdir)

	if (logtype~/^(llog|te|pmd)$/ && dozip!="dozip")
	{
		customPrint("")
		if (logtype=="llog")    { fetch_llog() ; comLogFetched["llog"]=1 }
		else if (logtype=="te") { fetch_te()   ; comLogFetched["te"]=1   }
		else if (logtype=="pmd"){ fetch_pmd(startdate,enddate,"",maxfiles) ; comLogFetched["pmd"]=1 }
		return tlgdir
	}

	theusername=moshellUSER
	thepassword="secret"
	theserver=ws_ip
	if (export_method>=1)
	{
		find_amos_export_login()
		theserverport=convert_export_method()
		theusername=export_username
		theserver=ws_ip
		if (export_password=="") export_password=get_sls_password(export_username)
		if (export_password!="") thepassword=export_password
		else return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
		if (export_method==2)
		{
			if ((export_server=="") || (export_server==ws_ip && smart_export>0)) export_method=1
			else
			{
				theserver=export_server
				loclgdir=tlgdir
				gsub(/[/]+$/,"",export_dir)
				tlgdir="lg_" strftime("%Y%m%d_%H%M%S",systime())"_"gawk_pid
				if (export_dir!="") tlgdir=export_dir "/" tlgdir
				thepwfile=tempdir"/export_pw"
				make_sshzfile(thepwfile,export_password)
				customPrint("")
				if (use_keyboard_interactive!=1) auth_method=auth_method",keyboard-interactive"
				if (ftpclient(export_server,export_password,"mkdir "tlgdir,"","",export_username,theserverport,thepwfile)!=0)
				{
					#if the first attempt fails we try with a weaker cipher to see if the export server can handle it and also we append "keyboard-interactive" to auth_method
					ciphers="-o Ciphers=aes128-ctr"
					#if (use_keyboard_interactive!=1) auth_method=auth_method",keyboard-interactive"
					if (ftpclient(export_server,export_password,"mkdir "tlgdir,"","",export_username,theserverport,thepwfile,"",ciphers)!=0)
					{
						customPrint("ERROR: unable to create temp directory on export server.")
						if (use_keyboard_interactive!=1) sub(",keyboard-interactive","",auth_method)
						return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
					}
				}
				else if (export_dir=="")
				{
					tlgdir=sftpCurrentWorkingDirectory"/"tlgdir
				}
			}
		}
	}
	if (tlgdir !~ /^\//) sep="/"
	if (start_sshd("",theserverport)==1)
	{
		customPrint("ERROR: unable to start sshd")
		return add_to_moscomlog("","%@> Fail (Connection failure)","",999)
	}
	disabled_confirmation=1
	old_muteFactor=muteFactor
	muteFactor=2

	if (is_ip_addr(theserver)==2 && theserver!~/^\[.*\]$/) theserver="["theserver"]"

	if ((logtype!~/^(xb|av)$/ && rcsLogName[logtype]!="")|| (dozip=="dozip"))
	{
		if (dozip=="dozip") thelogid=""
		else thelogid=rcsLogName[logtype]
		customPrint("Executing action Log.export()","","force")
		mo_log(templgfacclog,"open","mute","overwrite","silent")
		$0=sprintf("accn ^log=%s export sftp://%s@%s:%d%s%s %s",thelogid,theusername,theserver,sshdport,sep,tlgdir,thepassword) ; act("call","short","","n")
		mo_log(templgfacclog,"close")
		customPrint("","","force")
		while (getline < templgfacclog)
		{
			#  828  LogM=1,Log=AiLog                                               export                         2
			# >>> Return value = 256
			if ($3=="export") currLog=gensub(/^.*,/,"",1,$2)
			else if ($1==">>>" && $2=="Return")
			{
				actionId[currLog]=$5
				customPrint(sprintf("%-30s  actionId=%s",currLog,actionId[currLog]),"","force")
			}
			#!!!! ERROR: Call command failed, error code: ComFailure Messages from transaction participants: Previous action is already ongoing. Wait until the previous action is ready.
			else if (/!!!!|ERROR:/) customPrint(sprintf("%-30s  %s",currLog,$0),"","force")
		}
		close(templgfacclog)
		if (actionId[currLog]!="")
		{
			starttime=systime()
			mysleep(2) #takes time for the action to get started
			to=0
			mo_log(tempgalog,"open","mute","overwrite","silent")
			while (1)
			{
				$0="get log="thelogid" progressreport state.=....running" ; get("short")
				if (customVar["$nr_of_mos"]==0) break
				mysleep(1)
				sleeptime=systime()-starttime
				if (sleeptime>export_timeout)
				{
					to=1
					break
				}
			}
			mo_log(tempgalog,"close")
			if (to==1) customPrint("\nTimeout while waiting for log export to complete")
			mysleep(2)
			$0="hget log="thelogid" report@result|actionid" ; hget("short","","","","","notail")
			if (dozip!="dozip")
			{
				comLogFetched[logtype]=1
				if (logtype ~ /^(a_t|atr)$/) comLogFetched["a_t"]=comLogFetched["atr"]=1
			}
		}
	}

	if (logtype=="av" || dozip=="dozip")
	{
		customPrint("\nExecuting action LogM.exportAvailabilityLog()","","force")
		mo_log(templgfacclog,"open","mute","overwrite","silent")
		$0=sprintf("accn ^logm= exportAvailabilityLog sftp://%s@%s:%d%s%s %s",theusername,theserver,sshdport,sep,tlgdir,thepassword) ; act("call","short","","n")
		mo_log(templgfacclog,"close")
		while (getline < templgfacclog)
		{
			if ($3=="exportAvailabilityLog") currLog=$2","$3
			else if ($1==">>>" && $2=="Return")
			{
				actionId[currLog]=$5
				customPrint(sprintf("%-30s  actionId=%s",currLog,actionId[currLog]),"","force")
			}
			#!!!! ERROR: Call command failed, error code: ComFailure Messages from transaction participants: Previous action is already ongoing. Wait until the previous action is ready.
			else if (/!!!!|ERROR:/) customPrint(sprintf("%-30s  %s",currLog,$0),"","force")
		}
		close(templgfacclog)
		if (actionId[currLog]!="")
		{
			starttime=systime()
			mysleep(2) #takes time for the action to get started
			to=0
			mo_log(tempgalog,"open","mute","","silent")
			while (1)
			{
				$0="get logm= progressreport state.=....running" ; get("short")
				if (customVar["$nr_of_mos"]==0) break
				mysleep(1)
				sleeptime=systime()-starttime
				if (sleeptime>export_timeout)
				{
					to=1
					break
				}
			}
			mo_log(tempgalog,"close")
			if (to==1) customPrint("\nTimeout while waiting for log export to complete")
			#wait before checking the result, as sometimes the attribute progressReport does not update itself in time
			mysleep(2)
			$0="hget logm= report@result|actionid" ; hget("short","","","","","notail")
			if (dozip!="dozip") comLogFetched["av"]=1
		}
	}

	if ((maxfiles!=12345678901234567890) &&(logtype=="xb" || dozip=="dozip"))
	{
		#customPrint("\nExecuting action LogM.exportEsi()","","force")
		mo_log(templgfacclog,"open","mute","overwrite","silent")
		logmoc=fullmoc("LogM")
		granularity=""
		if ((logmoc,"exportEsi") in action && action[logmoc,"exportEsi"]~"granularity")
		{
			if ((maxfiles+0)<0) granularity=" static"
			else if ((maxfiles+0)<1) granularity=" small"   #default value: maxfiles=0.5 => no DSP dumps
		}
		tgranu=granularity
		if (tgranu=="") tgranu=" large"
		customPrint("\nExecuting action LogM.exportEsi()"tgranu,"","force")
		$0=sprintf("accn ^logm= exportEsi sftp://%s@%s:%d%s%s %s%s",theusername,theserver,sshdport,sep,tlgdir,thepassword,granularity) ; act("call","short","","n")
		mo_log(templgfacclog,"close")
		while (getline < templgfacclog)
		{
			if ($3=="exportEsi") currLog=$2","$3
			else if ($1==">>>" && $2=="Return")
			{
				actionId[currLog]=$5
				customPrint(sprintf("%-30s  actionId=%s",currLog,actionId[currLog]),"","force")
			}
			#!!!! ERROR: Call command failed, error code: ComFailure Messages from transaction participants: Previous action is already ongoing. Wait until the previous action is ready.
			else if (/!!!!|ERROR:/) customPrint(sprintf("%-30s  %s",currLog,$0),"","force")
		}
		close(templgfacclog)
		if (actionId[currLog]!="")
		{
			starttime=systime()
			mysleep(2) #takes time for the action to get started
			to=0
			mo_log(tempgalog,"open","mute","","silent")
			while (1)
			{
				$0="get logm= progressreport state.=....running" ; get("short")
				if (customVar["$nr_of_mos"]==0) break
				mysleep(1)
				sleeptime=systime()-starttime
				if (sleeptime>(export_timeout*20))
				{
					to=1
					break
				}
			}
			mo_log(tempgalog,"close")
			if (to==1) customPrint("\nTimeout while waiting for log export to complete")
			mysleep(2)
			$0="hget logm= report@result|actionid" ; hget("short","","","","","notail")
			if (dozip!="dozip") comLogFetched["xb"]=1
		}
	}

	muteFactor=old_muteFactor
	disabled_confirmation=0
	stop_sshd("print")
	if (export_method==2)
	{
		delete commandList
		commandList[1]="get "tlgdir"/* "loclgdir
		commandList[2]="rm "tlgdir"/*"
		commandList[3]="rmdir "tlgdir
		customPrint("")
		ftpclient(export_server,export_password,"",commandList,"",export_username,theserverport,thepwfile,"nostop",ciphers)
		tlgdir=loclgdir
		if (use_keyboard_interactive!=1) sub(",keyboard-interactive","",auth_method)
	}
	if (dozip!="dozip")
	{
		pwd=fileOps("pwd")
		Local_command("cd "tlgdir,"silent")
		if (system("gzip -df *.gz 2>/dev/null")==0)   #the ESI and AVLOG are gzipped
		{
			if (system("tar xf *.tar 2>/dev/null")==0) system("rm *.tar")  #the ESI is tared
		}
		Local_command("cd "pwd,"silent")
	}
	if (dozip=="dozip")
	{
		customPrint("")
		fetch_llog()
		fetch_te()
		fetch_pmd("","",tlgdir,maxfiles)
	}
	return tlgdir
}
function ziplogs(lgfdir,folder,maxfiles,    pwd,lgzipfile,zip_session,datefile,res)
{
	res=check_rcslogs_validity(folder,maxfiles)
	#if (res==1) return
	fileOps("mkdir -p "tempdir"/"folder)
	pwd=fileOps("pwd")
	datefile=tempdir"/"folder"/date.log"
	fileOps("rm "datefile)
	printf("Log close: %s - %s\n",strftime("%y%m%d-%H%M%S",systime()),datefile) > datefile
	close(datefile)
	Local_command("cd "tempdir)
	lgzipfile=sprintf("%s/%s_logfiles.zip",lgfdir,process_nodename(node))
	zip_session=sprintf("zip -rmD %s %s%s",lgzipfile,folder,(is_rcs()==1?" llog.log teread.log pmdzpm.log":""))
	customPrint(zip_session,"","force")
	system(zip_session)
	Local_command("cd "pwd)
	if (fileOps(sprintf("test -s %s",lgzipfile))==0)
	{
		if (res==1) customPrint("Storage of node logs to "lgzipfile)
		else customPrint("Successful storage of the node logs to "lgzipfile)
		#customPrint("For offline processing, run: lg[<options>] -l <zipfile>.")  -> this method does not work yet
	}
}
function check_rcslogs_validity(folder,maxfiles,   res,n,fileList,i,f,colorstart,colorend,thecom,theerr)
{
	#res=0 => ok
	#res=1 => no files are there
	#res=2 => some files are there but not ESI
	if (is_rcs()==0) return 0
	fileOps("mv "tempdir"/rcslogs/teread.log "tempdir)
	fileOps("mv "tempdir"/rcslogs/llog.log "tempdir)
	fileOps("mv "tempdir"/rcslogs/pmdzpm.log "tempdir)
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	unassignCustomVar("$rcs_lgf_error")
	res=0
	n=fileOps("ls "tempdir"/rcslogs",fileList)
	if (n==0) res=1
	else
	{
		res=2
		for (i=1;i<=n;i++) if (fileList[i]~/^esi.*\.tar(.gz(.gpg)?)?$/) res=0
	}
	if (indcg==1) thecom="dcg" ; else thecom="lgf"
	if (res==1) theerr=sprintf(colorstart"\nERROR: Operator logs and ESI export failed.\n"colorend\
"Try setting the following uservariables in the file ~/.moshellrc, then re-run "thecom":\n\
 - export_method: use value 1 (SFTP export to the current workstation) or value 2 (SFTP export to a different workstation).\n\
 - export_username: the username for the SFTP server to which the logs will be exported\n\
 - export_password: the password for the SFTP server. Can be encrypted with the command \"encpw\". If the password is not set, then it will be prompted at the command line.\n\
 - export_server: the IP address of the SFTP server. Only applicable if export_method=2.\n\
More information about export uservariables can be found in the file "moshelldir"/moshell.")
	else if (res==2 && maxfiles!=12345678901234567890) theerr=sprintf("%s\nERROR: ESI export failed, the logfiles.zip is incomplete. Please re-run %s%s%s",colorstart,thecom,(thecom=="dcg"?" or collect ESI separately with lgf command.":"."),colorend)
	if (theerr!="")
	{
		customPrint(theerr,"","force")
		if (indcg==1) assignCustomVar("$rcs_lgf_error",theerr,"","system")
	}
	return res
}
function fix_mibprefix(mibprefix)
{
	if (mospace_convert==1 && mibprefix ~ / /)
	{
		#we change the mibprefix to replace the white space with space_sign
		origMibPrefix=mibprefix
		gsub(/ /,space_sign,mibprefix)
	}
	assignCustomVar("$mibprefix",mibprefix,"","system")
	return mibprefix
}
function ReadNodeName(  me_attributes,array,theRats,tRat)
{
	#ComMe :  ManagedElement="Node Name"
	#Ldn[0]:  ManagedElement=Node@Name
	if (nodenameread == 1) return
	if (comcli>0)
	{
		cliMode="unknown"
		print "show "ComMe",userLabel" |& SshClient
		while (SshClient |& getline)
		{
			gsub("\r","") ; gsub("\x000","")
			if (mosdebug==1) print $0
			if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
			if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
			if ($1 ~ /^userLabel=\"/)
			{
				split($0,array,/\"/)
				if (array[2] !~ /^[-_+= ]*$/) node=gensub(/^ *| *$/,"","g",array[2])
			}
		}
		print "show "ComMe",dnPrefix" |& SshClient
		while (SshClient |& getline)
		{
			gsub("\r","") ; gsub("\x000","")
			if (mosdebug==1) print $0
			if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
			if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
			if ($1 ~ /^dnPrefix=\"/)
			{
				split($0,array,/\"/)
				MibPrefix=fix_mibprefix(gensub(/^ *| *$/,"","g",array[2]))
			}
		}
		print "show "ComMe",release" |& SshClient
		while (SshClient |& getline)
		{
			gsub("\r","") ; gsub("\x000","")
			if (mosdebug==1) print $0
			if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
			if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
			if ($1 ~ /^release=\"/)
			{
				split($0,array,/\"/)
				MeRelease=gensub(/[^0-9A-Za-z.]/,"","g",array[2])
			}
		}
		#If the ManagedElement is not equal to 1 then that will be the node Id
		if (Ldn[0] ~ /^ManagedElement=/ && Ldn[0] != "ManagedElement=1")
		{
			node=gensub(/^.*=/,"",1,Ldn[0])
			gsub(/[ \t@]/,"_",node)
		}
		if (checkedRats!=1)
		{
			checkedRats=1
			tRat["BtsFunction=1"]="G"
			tRat["ENodeBFunction=1"]="L"
			tRat["NodeBFunction=1"]="W"
			print "show "ComMe |& SshClient
			while (SshClient |& getline)
			{
				gsub("\r","") ; gsub("\x000","")
				if (mosdebug==1) print $0
				if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($1 ~ /^(E?NodeB|Bts)Function=1$/) theRats=theRats tRat[$1]
			}
			if (theRats!="") assignCustomVar("$rats",theRats,"","system")
		}
		if (mosdebug==1) print "ReadNodeName: Ldn[0]="Ldn[0]", ComMe="ComMe", MibPrefix="MibPrefix
	}
	else
	{
		me_attributes=getMoAttribute(0,prompt_attribute)
		if (me_attributes !~ /^(!!!|[-_+= ]*$)/) node=gensub(/^ *| *$|\"/,"","g",me_attributes)
		else
		{
			me_attributes=getMoAttribute(0,"site")
			if (me_attributes !~ /^(!!!|[-_+= ]*$)/) node=gensub(/^ *| *$|\"/,"","g",me_attributes)
		}
		check_sl3()
	}
	gsub(/[()]/,"",node)
	gsub(/[ \t]+/,"_",node)
	if (prompt_has_been_manually_set != 1) Set_prompt("",evalnodecase(node))
	nodenameread=1
	ReadMimName()
}
function check_sl3(   infoline)
{
	if (CorbaSecurity=="ON" && sl3==0 && smart_sl3==1 && sl3Status==0 && corba_class>=4)
	{
		sl3Status=getMoAttribute("ManagedElement=1,SystemFunctions=1,Security=1","operationalSecurityLevel")+0
		if (sl3Status >= 3)
		{
			infoline="INFO: Node in security level 3"(sl3Status>3?" unconfirmed":"")
			if (MibPrefix!="")
			{
				#if the MibPrefix is empty , meaning the node is not connected to OSS, then the username and sls_username shall not necessarily be the same, so the smart_sl3 setting will not be changing to sl3=1
				infoline=infoline", switching to sl3=1"
				declare_user_variable("sl3=1",2)
			}
			customPrint(infoline)
		}
	}
}
function ReadMimName(    me_attributes,tmpUp,tmpline,tmpVer)
{
	if (dbdat) return
	if (comcli>0)
	{
		if (mom_version ~ "RBS_NODE_MODEL")
		{
			ExpectedNodeType="RBS"
			assignCustomVar("$nodetype",ExpectedNodeType,"","system")
		}
		return
	}
	#workaround for RNCs where the MOM version is not called RNC_NODE_MODEL_... (eg. P6_UPLIFT)
	me_attributes=getMoAttribute(0,"mimName")
	if (me_attributes ~ /^RNC_NODE_MODEL/ && mom_version !~ "RNC")
	{
		if (parsemom_has_been_run_by_user!=1)
		{
			#check the MOM again, sometimes the MOM check failed due to http server was not ready
			#only do this if the user had not run parsemom <mom> previously since we don't want to override the MOM that they have chosen
			CheckMom("force")
		}
		if (mom_version !~ "RNC") mom_version="RNC_"gensub(/^RNC_/,"",1,mom_version)
		assignCustomVar("$momversion",mom_version,   "","system")
	}
	#Make a new global variable NodeType and ExpectedNodeType
	NodeType=mom_version
	#workaround to know if the node is an RXI since this cannot be seen based on the MOM name
	if (me_attributes ~ /RANAG/) NodeType=me_attributes
	if (NodeType ~ "RNC") ExpectedNodeType="RNC"
	else if (NodeType ~ "MGW") ExpectedNodeType="MGW"
	else if (NodeType ~ "RANAG") ExpectedNodeType="RXI"
	else if (NodeType ~ "RBS") ExpectedNodeType="RBS"
	if (me_attributes ~ /^MRS_NODE_MODEL/) isMRS=1
	tmpUp=getMoAttribute("ManagedElement=1,SwManagement=1,ConfigurationVersion=1","currentUpgradePackage")
	if (tmpUp ~ /UpgradePackage=/)
	{
		cppUpVersion=getMoAttribute("ManagedElement=1,SwManagement=1,UpgradePackage="gensub(/^.*=/,"",1,tmpUp),"cppUpVersion")
		cppUpVersion=translate_cppUpVersion(gensub(/^.*productNumber = |\n.*productRevision.*$/,"","g",cppUpVersion))
		assignCustomVar("$cppversion",cppUpVersion,         "","system")
		tmpUp=getMoAttribute("ManagedElement=1,SwManagement=1,UpgradePackage="gensub(/^.*=/,"",1,tmpUp),"administrativeData")
		tmpUp=gensub(/^.*productNumber = |\n.*productRevision.*$/,"","g",tmpUp)
		if (tmpUp !~ /^ *$/)
		{
			if (me_attributes ~ "_NODE_MODEL_") tmpVer=gensub("_NODE_MODEL","",1,me_attributes)
			else if (mom_version ~ "RBS|RNC|MGW") tmpVer=gensub(/_NODE_MODEL_.*$/,"",1,mom_version)"_"gensub(/_.*$/,"",1,gensub(/^.*_NODE_MODEL_/,"",1,mom_version))
			if (tmpVer != "")
			{
				tmpline=sprintf("%s;%s",tmpUp,tmpVer)
				if (!(tmpline in uptomomTable))
				{
					print tmpline >> uptomomdb ; close(uptomomdb)
					chmod(00666,uptomomdb)
					parse_uptomom_file(uptomomdb)
				}
			}
			if (tmpUp ~ "CXP9012374") ExpectedNodeType="3GSIM"
		}
	}
	assignCustomVar("$nodetype",(ExpectedNodeType!=""?ExpectedNodeType:gensub(/_.*$/,"",1,mom_version)),         "","system")
	if (ExpectedNodeType ~ /^(RBS|RXI)$/ && max_poll_time>300) max_poll_time=300
}
function lsv2cpp(lsv,   cppLSV,maxlsv,i)
{
	#convert a LSV number to a CPP version
	#reference: https://platform-mia.rnd.ki.sw.ericsson.se/summary/ and https://cpp-shipment.rnd.ki.sw.ericsson.se/cpp/deliveries
	lsv+=0
	lsv=int(lsv)
	maxlsv=250
	for (i=1;i<=34;i++) cppLSV[i]="C07.0"
	for (i=35;i<=59;i++) cppLSV[i]="C08.0"
	for (i=60;i<=74;i++) cppLSV[i]="C12.0"
	for (i=75;i<=79;i++) cppLSV[i]="C12.1"
	for (i=80;i<=89;i++) cppLSV[i]="C12.2"
	for (i=90;i<=98;i++) cppLSV[i]="C13.0"
	for (i=99;i<=107;i++) cppLSV[i]="C13.1"
	for (i=108;i<=112;i++) cppLSV[i]="C13.2"
	for (i=113;i<=120;i++) cppLSV[i]="C14.0"
	for (i=121;i<=126;i++) cppLSV[i]="C14.1"
	for (i=127;i<=133;i++) cppLSV[i]="C14.2"
	for (i=134;i<=144;i++) cppLSV[i]="C14.3"
	for (i=145;i<=147;i++) cppLSV[i]="C15.0"
	for (i=148;i<=159;i++) cppLSV[i]="C15.1"
	for (i=160;i<=172;i++) cppLSV[i]="C16.0"
	for (i=173;i<=175;i++) cppLSV[i]="C16.1"
	for (i=173;i<=175;i++) cppLSV[i]="C16.1"
	for (i=173;i<=175;i++) cppLSV[i]="C16.1"
	for (i=175;i<=185;i++) cppLSV[i]="C16.2"
	for (i=186;i<=191;i++) cppLSV[i]="C16.3"
	for (i=192;i<=198;i++) cppLSV[i]="C17.0"
	for (i=199;i<=204;i++) cppLSV[i]="C17.Q1"
	for (i=205;i<=212;i++) cppLSV[i]="C17.Q2"
	for (i=213;i<=219;i++) cppLSV[i]="C17.Q3"
	for (i=220;i<=maxlsv;i++) cppLSV[i]="C17.Q4"
	if (lsv~/^[1-9][0-9]+$/ && lsv<=maxlsv && cppLSV[lsv]!="") return cppLSV[lsv]
	else return "C30"
}
function translate_cppUpVersion(text,what,    array,lsv)
{
	#test by putting this function and the above in a file /tmp/awk.awk, then do:
	#gawk -f /tmp/awk.awk -v mom_version="_NODE_" --source '{printf("%-20s %s\n", $1,translate_cppUpVersion($1))}'
	#and copy paste these lines to see the output:
	#MOM-CPP-LSV122
	#MOM-CPP8-LSV59.2.1-2
	#MOM-EP10-CPP8.0.1.1
	#EP38-CPP_8.0.1.1
	#EP49-CPP_7.0.3.10.1
	#CPP_107_XXX
	#CPP_EP13-89.7.1_XXX
	#CPP_GCC_XXX
	#CPP_INT_XXX
	#CPP_LSV89.2_XXX
	#C14.1_121_XXXX
	#C14A_113_XXX
	#C14A_INT_XXX

	#Translate the MOM label from MOM-CPP-LSVxxx to CXX_LSVxxx
	if (what=="mom")
	{
		if (text ~ "LSV")
		{
			lsv=gensub(/^.*LSV/,"",1,text)
			return lsv2cpp(lsv)"_"text
		}
		else return "C08_"text
	}

	#Translate the CPP UP version of a application node
	if (mom_version ~ "_NODE_MODEL_")
	{
		if (text ~ /^C[12][0-9]/) return text
		else if (text ~ /LSV[0-9]+/)
		{
			match(text,/LSV([0-9]+)/,array)
			return lsv2cpp(array[1])"_"text
		}
		else return "C08_"text
		#EP38-CPP_8.0.1.1
		#EP49-CPP_7.0.3.10.1
		#LSV135
	}

	#Translate the CPP UP version of a CPP node
	#the format can be like:
	#LSV135
	#CPP_107_XXX
	#CPP_EP13-89.7.1_XXX
	#CPP_GCC_XXX
	#CPP_INT_XXX
	#CPP_LSV89.2_XXX
	#C14.1_121_XXXX
	#C14A_113_XXX
	#C14A_INT_XXX
	if (text ~ /^C[12][0-9]A/) { sub("A",".0",text) ; return text }
	else if (text ~ /^C[12][0-9]B/) { sub("B",".1",text) ; return text }
	else if (text ~ /^C[12][0-9]C/) { sub("C","Z",text) ; sub("C",".2",text) ; sub("Z","C",text) ; return text }
	else if (text ~ /^C[12][0-9]D/) { sub("D",".3",text) ; return text }
	else if (text ~ /^C[12][0-9]\.[0-9]/) return text
	else if (text ~ /^CPP_/)
	{
		sub(/^CPP_/,"",text)
		split(text,array,"_")
		sub(/^EP[-0-9]+-/,"",array[1])
		sub(/^LSV/,"",array[1])
		sub(/\.[.0-9]+$/,"",array[1])
		array[1]+=0
		return lsv2cpp(array[1])"_"text
	}
	return "C30_"text
}

function Create_commandline(prompt,    thetimeout,amos_li)
{
	#note: the option "-e" in the bash "read" command is not used when mosdebug=99.
	#This is a special workaround that can be used by expect script to avoid the wraparound of moshell commands. See TR WRNae06245

	#Keep alive. If keepalive_interval > 0 then the inactivity timeout will be replaced by this value in the readline file

	thetimeout=inactivity_timeout
	if (keepalive_interval>0) thetimeout=keepalive_interval
	#if (keepalive_interval>0 || amos_log_interval>0)
	#{
	#	amos_li=amos_log_interval*60
	#	if (keepalive_interval==0) thetimeout=amos_li
	#	else if (amos_li==0) thetimeout=keepalive_interval
	#	else thetimeout=findmin(keepalive_interval,amos_li)
	#}
	if (prompt ~ /\\n/) prompt=sprintf("`echo -e '%s'`",prompt)
	printf("#!%s -fp\nINPUTRC=%s\nHISTSIZE=%s\nHISTFILESIZE=%s\nHISTFILE=%s\nHISTIGNORE=if*REPLY+x*\nset -o histexpand\nset -o history ; read %s -r -t %s -p \"%s> \"\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,inputrc,keep_history_lines,keep_history_lines,command_buffer,(mosdebug~/^999?$/?"-n 4096":"-e"),thetimeout,prompt) > readline
	if (fileOps("test -s "inputrc)!=0) printf("set completion-ignore-case on\nset show-all-if-ambiguous on\nset mark-directories on\nset visible-stats on\n\"\\e[D\": backward-char\n\"\\e[C\": forward-char\n\"\\e[A\": history-search-backward\n\"\\e[B\": history-search-forward\n\"\\e[1~\": beginning-of-line\n\"\\e[4~\": end-of-line\n\"\\e[7~\": beginning-of-line\n\"\\e[8~\": end-of-line\n\"\\e[3~\": delete-char\n\"\\M-[2~\": paste-from-clipboard\nset expand-tilde on\n") > inputrc
	if (fileOps("test -s "readanswer)!=0) printf("#!%s -fp\nread %s -t %s\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,(mosdebug~/^999?$/?"-n 2048":"-e"),inactivity_timeout) > readanswer
	if (fileOps("test -s "readsilent)!=0) printf("#!%s -fp\nread %s -s -t %s\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,(mosdebug~/^999?$/?"-n 2048":"-e"),inactivity_timeout) > readsilent
	close(inputrc) ; close(readline) ; close(readanswer) ; close(readsilent)
	chmod(00755,readline) ; chmod(00755,readanswer) ; chmod(00755,readsilent)
}

function Set_prompt(what,Filter1,manual)
{
	if (manual=="manual") prompt_has_been_manually_set=1  #global variable
	#prompt is a global variable
	if (what=="bold")
	{
		if (prompt_highlight == 1) prompt_highlight=0
		else prompt_highlight=1
		Set_prompt("",prompt)
	}
	else if (Filter1 !="")
	{
		#\[\033[1;33m\]>\[\033[0m\] ; \[\033[1m\][\w]\$\[\033[0m\] #\[\033[1m\]%s\[\033[0m\] #\033[1m%s\033[0m
		prompt=Filter1
		# when bold prompt, a command longer than the window would wrap around itself
		# in a bash shell, the PS1 variable can have \[ and \] around the escape characters to prevent the problem
		# but in read -e -p, it does not work. One must use \001 instead of \[ and \002 instead of \]
		# refer to http://stackoverflow.com/questions/8806643/colorized-output-breaks-linewrapping-with-readline/8916332#8916332
		if (prompt_highlight==1 && prompt_color==0) Create_commandline(sprintf("\001\033[1m\002%s\001\033[0m\002",prompt))
		else if (prompt_highlight==1 && prompt_color==1)
		{
			#Test colors:
			#print 30,sprintf("\033[1;30m%s\033[0m",prompt) #grey
			#print 31,sprintf("\033[1;31m%s\033[0m",prompt) #red
			#print 32,sprintf("\033[1;32m%s\033[0m",prompt) #green
			#print 33,sprintf("\033[1;33m%s\033[0m",prompt) #yellow
			#print 34,sprintf("\033[1;34m%s\033[0m",prompt) #dark blue
			#print 35,sprintf("\033[1;35m%s\033[0m",prompt) #purple
			#print 36,sprintf("\033[1;36m%s\033[0m",prompt) #light blue
			#print 37,sprintf("\033[1;37m%s\033[0m",prompt) #white

			if (tolower(mom_version) ~ "rnc") Create_commandline(sprintf("\001\033[1;%dm\002%s\001\033[0m\002",prompt_rnc,prompt))
			else if (tolower(mom_version) ~ "rbs") Create_commandline(sprintf("\001\033[1;%dm\002%s\001\033[0m\002",prompt_rbs,prompt))
			else if (tolower(mom_version) ~ "mgw") Create_commandline(sprintf("\001\033[1;%dm\002%s\001\033[0m\002",prompt_mgw,prompt))
			else Create_commandline(sprintf("\001\033[1m\002%s\001\033[0m\002",prompt))
		}
		else Create_commandline(prompt)
	}
	Window_title("start")
	assignCustomVar("$nodename",node,                  "","system")
	assignCustomVar("$ipaddress",node_address,         "","system")
}
function Display_menus(what)
{
	if (what=="p" && NF>1) { Set_prompt("",$2,"manual") ; return }
	Display_menu(what)
	customPrint("\n        Type: - h <command> to view command description, e.g: h pget")
	customPrint("              - h <pattern> to view commands whose description match a string, e.g: h change.*prompt")
}
function Display_menu(what,header,   i,colorstart,colorend)
{
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	if (what==0)
	{
		if (multi || node ~ /^OFFLINE/) printf("\n\
HELP MENU            : h\n\
QUIT                 : q\n")
		else
		{
			if (emcli!="") printf("\n\
-------------------------------------------------------------------------------\n\
WARNING: This system is restricted solely to authorized users for legitimate\n\
business purposes only. The actual or attempted unauthorized access,\n\
use, or modification of this system is strictly prohibited.\n\
\n\
Unauthorized users are subject to appropriate disciplinary proceedings\n\
and/or criminal and civil penalties under state, federal, or other\n\
applicable domestic and foreign laws.\n\
\n\
The use of this system may be monitored and recorded for\n\
administrative and security reasons. Anyone accessing this system\n\
expressly consents to such monitoring and is advised that if\n\
monitoring reveals possible evidence of criminal activity, the owner\n\
of this equipment may provide the evidence of such activity to law\n\
enforcement officials.\n\
\n\
All authorized users shall comply with the security policies,\n\
instructions and requirements related to the business purpose and in\n\
case of doubt shall seek advice from his/her manager.\n\
-------------------------------------------------------------------------------\n")

			printf("\n\
HELP MENU            : h\n\
BASIC MO COMMANDS    : m\n\
OTHER MO COMMANDS    : n\n\
OTHER COMMANDS       : o\n\
PM COMMANDS          : p\n\
QUIT                 : q\n")
		}
		if (node ~ /^OFFLINE$/ && dbdat!=1) printf("\n\
For offline browsing of the MIB, load an MO dump with command \"lt <modump>\".\n\
The MO dump can be fetched when online, using command \"dcgk\"\n")
		if (node ~ /^OFFLINE/ && dbdat!=1) printf("\n\
For offline browsing of PM ropfiles, run \"pmr/pmx"(ropfiles_zip!=""?"":" -l <pmropfiles>")"\".\n\
For offline browsing of CPP logfiles, run \"lg[options]"(logfiles_zip!=""?"":" -l <cpplogfiles>")"\".\n%s%s%s",\
(logfiles_zip!=""?"":"The PM ropfiles and CPP logs can be fetched when online, using command \"dcgf\"\n"),\
"To list all available facc/mcc commands, type \"?\"\n",\
"To list all available COLI commands, type \"lh all ?\"\n")
		if (EMCLI["ua"]==1) printf("\n\
%sThere is a newer EMCLI package available on the node, version %s\n\
To upgrade, run the command \"emcli upgrade\"%s\n",\
colorstart,EMCLI["nv"],colorend)
	}
	else
	{
		if (header=="line")
		{
			if (what=="u") customPrint("----------------------------------- COMMANDS SUPPORTED IN MULTI MODE ----------------------------------")
			if (what=="f") customPrint("----------------------------------- COMMANDS SUPPORTED IN OFFLINE MODE ----------------------------------")
			if (what=="d") customPrint("----------------------------------- COMMANDS SUPPORTED IN SQL MODE ----------------------------------")
			if (what=="m") customPrint("----------------------------------- BASIC MO COMMANDS  ----------------------------------")
			if (what=="n") customPrint("----------------------------------- OTHER MO COMMANDS    ----------------------------------")
			if (what=="o") customPrint("----------------------------------- OTHER COMMANDS     ----------------------------------")
			if (what=="p") customPrint("----------------------------------- PM COMMANDS        ----------------------------------")
			if (what=="h") customPrint("----------------------------------- HELP CHAPTERS      ----------------------------------")
			if (what=="c") customPrint("----------------------------------- COMMANDS SUPPORTED ON COM NODES ----------------------------------")
			if (what=="e") customPrint("----------------------------------- COMMANDS SUPPORTED IN EMCLI ----------------------------------")
		}
		else
		{
			customPrint(sprintf("\n****************************************************************************************************\n\
%-20s  %s\n****************************************************************************************************","Command Name","Purpose (type \"h <command>\" for detailed help on a command)"))
		}
		parse_readme()
		if (what=="h")
		{
			for (i=0;i<=9;i++) customPrint(sprintf("%-23s  %s",i,chap_title[i]))
		}
		for (i=1;i<=Number_of_commands;i++)
		{
			if (sprintf("%s%s%s",what,SUBSEP,CommandName[i]) in menu_command_list)
			{
				if (in_amos_mode() && CommandName[i] ~ /^(fset)/) continue
				customPrint(short_command_desc[i])
			}
		}
	}
}


function Display_help(Filter1,   i,j,array,answer,last,dest,n,half,command_found,tmphelpfile,what)
{
	if (Filter1 ~ /^(pset|pcr|cr|trun)$/) assignCustomVar("$command_result",1)  #this means the command failed so we set $command_result=1
	if (multi) what="u"
	else if (dbdat) what="d"
	else if (emcli!="") what="e"
	else if (comcli>0) what="c"
	else if (node~/^OFFLINE_/) what="f"
	if (Filter1 == "")
	{
		customPrint("")
		if (multi) Display_menu("u","line")
		else if (dbdat) Display_menu("d","line")
		else if (emcli!="") Display_menu("e","line")
		else if (comcli>0) Display_menu("c","line")
		else if (node ~ /^OFFLINE_/) Display_menu("f","line")
		else
		{
			Display_menu("m","line")
			Display_menu("n","line")
			Display_menu("o","line")
			Display_menu("p","line")
		}
		Display_menu("h","line")
		customPrint("\n        Type: - h <command> to view command description, e.g: h pget")
		customPrint("              - h <pattern> to view commands whose description match a string, e.g: h change.*prompt")
		customPrint("              - h <chapter> to view a chapter, e.g: h 3")
	}
	else
	{
		parse_readme()
		Filter1=tolower(Filter1)
		if      (Filter1 == "syntax"   ) Filter1=3
		else if (Filter1 == "lazy"     ) Filter1=5
		else if (Filter1 == "contact"  ) Filter1=10
		else if (Filter1 == "tut"      ) Filter1=2
		else if (Filter1 == "scripting") Filter1=6
		else if (Filter1 == "utils"    ) Filter1=7

		if (Filter1 ~ /^([0-9]|10)$/)
		{
			tmphelpfile=sprintf("%s/help%s_%s",tempdir,gawk_pid,Filter1)
			if (fileOps("test -s "tmphelpfile)!=0)
			{
				print("\n############################################################################################") > tmphelpfile
				print(chap_title[Filter1])                                                                             >> tmphelpfile
				print("############################################################################################")  >> tmphelpfile
				print(chap_desc[Filter1])                                                                              >> tmphelpfile
			}
			system("less --quit-at-eof "tmphelpfile)
		}
		else
		{
			for (i in SearchString)
			{
				if (Filter1 !~ SearchString[i]) continue
				if (in_amos_mode() && CommandName[i] ~ /^(fset)/)
				{
					command_found=1
					continue
				}
				if (what!="" && SearchStringMenuList[i,what]!=1)
				{
					command_found=1
					continue
				}
				customPrint("\n***************************************************************************************")
				customPrint(CommandName[i])
				customPrint("***************************************************************************************")
				customPrint(command_desc[i])
				command_found=1
			}
			if (command_found != 1)
			{
				#try to match against the command descriptions
				for (i=1;i<=Number_of_commands;i++)
				{
					if (tolower(command_desc[i]) ~ Filter1) { command_found=1 ; break }
				}
				if (command_found==1)
				{
					customPrint("\nFollowing commands match that word in the command description (type \"h <command>\" for more info on each command):\n")
					for (i=1;i<=Number_of_commands;i++)
					{
						if (in_amos_mode() && CommandName[i] ~ /^(fset)/) continue
						if (tolower(command_desc[i]) ~ Filter1) customPrint(short_command_desc[i])
					}
				}
			}
		}
	}
}
function parse_readme(     dummy,i,j,reading_commands,array,z,base,options)
{
	#this function is run only once in the session
	if (readme_parsed==1) return
	readme_parsed=1
	delete SearchString
	if (fileOps("test -f "relhistory)==0)
	{
		chap_title[0]="Revision History"
		while (getline < relhistory)
		{
			gsub("\r","")
			chap_desc[0]=chap_desc[0] "\n" $0
		}
		close(relhistory)
	}
	if (fileOps("test -f "readme)!=0)
	{
		customPrint("ERROR: file "readme" not found.")
		return
	}
	while (getline < readme)
	{
		gsub("\r","")
		if (/^([0-9]|10)- /)
		{
			split($0,array,/- */)
			chap_title[array[1]]=array[2]
			getline dummy < readme
			while ((getline <readme) && ($0 != "############################################################################################"))
			{
				gsub("\r","")
				chap_desc[array[1]]=chap_desc[array[1]] "\n" $0

			}
		}
	}
	close(readme)
	while (getline < readme)
	{
		gsub("\r","")
		if (/^4- Command descriptions/) reading_commands=1
		if ($0 ~ /^- [a-z\<!]/ && reading_commands==1)
		{
			i++
			CommandName[i]=gensub(/^- /,"",1,$0)
			base=options=""
			base=gensub(/\[[^\[\]]+\]/,"","g",$2)
			gsub(/\//,"|",base) ; gsub(/\+/,"\\+",base) ; gsub(/\?/,"\\?",base)
			if ($2 ~ /\[/) { options=gensub(/[^\[\]]*\[|\][^\[\]]*/,"","g",$2);gsub(/\|/,"",options) }
			SearchString[i]=sprintf("^(%s)%s$",base,(options!="" ? sprintf("[%s]*",options) : ""))
			#printf("DEBUG: %-40s %s\n",$2,SearchString[i])
			getline dummy < readme ; $0=""
			while ((getline <readme) && ($0 !~ /^\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*/))
			{
				gsub("\r","")
				if ($0 == "############################################################################################") break
				if ($1 == "Menu:")
				{
					#Menu: m. Read MO attribute(s).
					#Menu: m,u. Set attribute(s)
					split(gensub(/\.$/,"",1,$2),array,",")
					for (z in array)
					{
						menu_command_list[array[z],CommandName[i]]=1
						SearchStringMenuList[i,array[z]]=1
					}
					short_command_desc[i]=sprintf("%-23s  %s",gensub(/ +[^ ].*$/,"",1,CommandName[i]),gensub(/^Menu: *[^ ]+\. *| *$/,"","g",$0))
					if (short_command_desc[i] ~ /^ose.coli /) sub(sprintf("%-23s","ose/coli"),sprintf("%-23s","ose/coli command"),short_command_desc[i])
					else if (short_command_desc[i] ~ /^linux.rcs-coli.comcli /) sub(sprintf("%-23s","linux/comcli"),sprintf("%-23s","linux/comcli command"),short_command_desc[i])
					sub(/^Menu: *[^ ]+\. */,"",$0)
				}
				command_desc[i]=command_desc[i] "\n" $0
			}
		       #(($0 != "*********************************************************************************")||\
		       #($0 != "*******************************************************")||\
		       #($0 != "***************************************")))
		}
	}
	close(readme)
	Number_of_commands = i
	for (j=0;j<=9;j++) sub("\n","",chap_desc[j])
	for (j=0;j<=Number_of_commands; j++) sub("\n","",command_desc[j])
}
function parse_readme_small(     dummy,i,j,reading_commands,array,z,base,options)
{
	if (fileOps("test -f "readme)!=0)
	{
		customPrint("ERROR: file "readme" not found.")
		return
	}
	delete SearchString
	while (getline < readme)
	{
		gsub("\r","")
		if (/^4- Command descriptions/) reading_commands=1
		if ($0 ~ /^- [a-z\<!]/ && reading_commands==1)
		{
			i++
			base=options=""
			base=gensub(/\[[^\[\]]+\]/,"","g",$2)
			gsub(/\//,"|",base) ; gsub(/\+/,"\\+",base) ; gsub(/\?/,"\\?",base)
			if ($2 ~ /\[/) { options=gensub(/[^\[\]]*\[|\][^\[\]]*/,"","g",$2);gsub(/\|/,"",options) }
			SearchString[i]=sprintf("^(%s)%s$",base,(options!="" ? sprintf("[%s]*",options) : ""))
			getline dummy < readme ; $0=""
			while ((getline <readme) && ($0 !~ /^\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*\*/))
			{
				gsub("\r","")
				if ($0 == "############################################################################################") break
			}
		}
	}
	close(readme)
}
function make_restrictions()
{
	if (command_restriction==0) return
	make_restricted_table(blocked_commands,blockedMosCommands,blockedColiCommands)
}
function make_restricted_table(files,moshellTable,coliTable,     last,array,i,tfile,ok)
{
	last=split(files,array,",")
	for (i=1;i<=last;i++)
	{
		tfile=array[i]
		if (tfile=="") continue
		if (fileOps("test -s "tfile)!=0) continue
		while (getline < tfile)
		{
			gsub("\r","")
			if ($1 ~ /^#/) continue
			if (NF==0) continue
			ok=0
			for (j in SearchString)
			{
				if ($1 ~ SearchString[j] || $1 ~ /^~/) { moshellTable["^"gensub(/^[~]/,"",1,$1)]=1 ; ok=1 ; break }
			}
			if (ok==0)
			{
				gsub(/^[ \t]+|[ \t]+$/,"")
				coliTable["^"gensub(/[ \t]/," +","g",$0)]=1
			}
		}
		close(tfile)
	}
}
function Window_title(when,   what,wnode)
{
	if (set_window_title == 1 && monode_commandfile==0 && monode_command==0)
	{
		if (when == "start")
		{
			#split(node,array,".")
			wnode=toupper(node)
			if (in_amos_mode()) what="AMOS"
			else if (emcli != "") what="EMCLI "EMCLI["pn"]" "EMCLI["pr"]" ("moshell_version")"
			else what="MOSHELL "moshell_version
			if ( term == "sun-cmd") printf("\x16\x1B]l%s - %s - Stopfile=%s\x16\x1B\\\n",wnode,what,stopfile)
			else printf("\x1B]0;%s - %s - Stopfile=%s\a",wnode,what,stopfile)
		}
		if (when == "stop")
		{
			if ( term == "sun-cmd") printf("\x16\x1B]l\x16\x1B\\\n")
			else printf("\x1B]0; \a") #need a space other some terminals like dtterm do not clear the terminal
		}
		if (when == "command")
		{
		        if ( term == "sun-cmd") printf("\x16\x1B]l%s\x16\x1B\\\n",$2)
			else printf("\x1B]0;%s\a",$2)
		}
	}
}

function parsemom(userMomFile)
{
	if (userMomFile=="")
	{
		if (mom_file == "")
		{
			if (multi)
			{
				customPrint("In multimode, a MOM file must be specified, i.e: parsemom <momfile>")
				return
			}
			CheckMom()
		}
		else readmom(mom_file)
		return
	}
	if (fileOps("test -s "userMomFile)==0) mom_file=userMomFile
	else if (userMomFile ~ /.gz$/ && fileOps("test -s "gensub(/.gz$/,"",1,userMomFile))==0) mom_file=gensub(/.gz$/,"",1,userMomFile)
	else if (userMomFile !~ /.gz$/ && fileOps("test -s "userMomFile".gz")==0) mom_file=userMomFile".gz"
	else if (userMomFile !~ /.jar$/ && fileOps("test -s "userMomFile".jar")==0) mom_file=userMomFile".jar"
	else
	{
		customPrint("\nMOM file not found: "userMomFile)
		return
	}
	readmom(mom_file)
	if (multi)
	{
		parsemomhasbeenrun=1
		if (nealStarted == 1 && is_process_there(moshell_java_proc["nealbrowser"]) == 0)
		{
			#after running parsemom, there will only be one MOM in the session so all other MOMs are cleared from memory
			for (i in momVersionList) if (i != mom_version) delete momVersionList[i]
			CheckMom_MULTI()
		}
	}
	if (userMomFile!="") parsemom_has_been_run_by_user=1
}
function clear_mom_tables(what)
{
	if (what=="pm")
	{
		#Clearing the PM MOM tables is only applicable on COM nodes !
		#Because in comcli the PM MOM tables are made by reading some MO instances
		#The PM MOM tables are cleared when doing "lt root"

		#Difference between sorted_Pm_attribute_list and sorted_Pm_counter_list
		# - sorted_Pm_attribute_list has the MO class in index while sorted_Pm_counter_list has the PmGroup
		# - sorted_Pm_attribute_list does not contain deprecated counters if exclude_deprecated>0) while sorted_Pm_counter_list has them always
		if (comcli>0)
		{
			delete PmAttributes
			delete PmAttributesType
			delete Pm_attr_comments
			delete Pm_attr_description
			delete pdf_counter_table
			delete pm_deprecated
			delete Pm_attribute_list
			delete sorted_Pm_attribute_list
			delete Pm_counter_list
			delete sorted_Pm_counter_list
			delete MeasTypeMo
			delete eventfileList
			delete eventList
			delete EvTypeMo
			delete EvGroupMo
		}
		return
	}

	cdmaMOM=i=0
	mimCounter=0
	delete LogAttributes
	delete Log_attr_description
	delete Log_attribute_list
	delete MoAttributesType
	delete MoAttributesTypeJava
	delete PmAttributes
	delete PmAttributesType
	delete Pm_attr_comments
	delete Pm_attr_description
	delete Pm_attribute_list
	delete action
	delete action_list
	delete actn_description
	delete actn_result
	delete actn_deprecated
	delete attr_comments
	delete attr_default
	delete attr_description
	delete attr_length
	delete attr_range
	delete attr_refs
	delete attr_unit
	delete attribute_list
	delete cardinality
	delete childList
	delete class_description
	delete class_syscreated
	delete com_moclass_list
	delete deprecatedRelationship
	delete derived_description
	delete derived_type
	delete ecimMomName
	delete ecimMomVer
	delete eget_attribute_list
	delete enum
	delete enum_contents
	delete enum_description
	delete has_syscreated_children
	delete hidden_attributes #global table with all pm attributes that were filtered out
	delete mandatory_attributes
	delete maxLength
	delete MeasTypeMo
	delete eventfileList
	delete eventList
	delete EvTypeMo
	delete EvGroupMo
	delete momVersionComponents
	delete ecimVersionComponents
	delete mimComponents
	delete mimNames
	delete momParts
	delete mom_moclass_list
	delete param_table
	delete parentList
	delete pdf_counter_table
	delete pm_deprecated
	delete pull_attrlist
	delete pull_molist
	delete restricted_attributes
	delete sorted_Log_attribute_list
	delete sorted_Pm_attribute_list
	delete sorted_action_list
	delete sorted_attr_refs
	delete sorted_attribute_list
	delete sorted_childList
	delete sorted_eget_attribute_list
	delete sorted_mom_list
	delete sorted_parentList
	delete sorted_pull_attrlist
	delete struct_contents
	delete struct_key
	delete struct_default_value
	delete struct_description
	delete struct_type
	delete struct_with_moref
	delete tolower_mom_moclass_list
	delete takes_effect
	delete progressAttribute
	delete sorted_struct_contents
	delete moc_key_attributes
	delete Pm_counter_list
	delete sorted_Pm_counter_list
	#global variable

	#table descriptions, can be seen with mosdebug==2, eg:
	#enum[SupportedAdminStates,UNLOCKED]=1$
	#enum[SupportedAdminStates,1]=UNLOCKED$
	#enum_description[SupportedAdminStates]=The following administrative states are supported when this enumeration is used:...
	#enum_contents[SupportedAdminStates]=0:LOCKED, 1:UNLOCKED$
	#MoAttributesType[Rach:administrativeState]=enumRef:SupportedAdminStates$
	#sorted_mom_list[structure]=AccountInfo,ActionResultData,AdminProductData,AirFlowData,ArpQosStruct,AseLoadThresholdUlSpeech,CVActionAdditionalResultData,CVActionResultData,CapacityData,CellCapability,CertInfo,CertSpec,ConfigurationVersionAttributes,DhcpResultData,DscpPbit,EmergencyInfo,EnrollmentData,EtDescription,GeographicalPosition,GlobalTitleData,HcsSib11Config,HcsSib3Config,HcsUsage,HealthCheckResult,HsToDchTrigger,IcmOverallResult,IcmSubrackResult,M3uaTimerData,MeApplicationConfigurationData,MimInfo,Mtp2HslCongestChina,Mtp2HslCongestItu,Mtp2ProfileDataAnsi,Mtp2ProfileDataChina,Mtp2ProfileDataItu,Mtp2ProfileDataTtc,Mtp3bSpAnsiPriorityData,Mtp3bSpAnsiTimerData,Mtp3bSpChinaPriorityData,Mtp3bSpChinaTimerData,Mtp3bSpItuPriorityData,Mtp3bSpItuTimerData,Mtp3bSpTtcPriorityData,Mtp3bSpTtcTimerData,NniSaalProfileData,NodeCertInfo,OperProductData,OperatingMode,OspfAreaRange,PbitQueue,PeriodicalReportingCriteria,PiuTypeMOConfiguration,PiuTypeProgramConfiguration,PlmnIdentity,PositioningClientMappings,PositioningQualities,PwrLoadThresholdDlSpeech,QoSProfileClassA,QoSProfileClassB,QoSProfileClassC,QoSProfileClassD,RateSelectionPsInteractive,ResMeasDef,RoutingTableEntry,Sb1Data,ScheduleEntry,Scmg,SfpInformation,Sib11Data,Sib12Data,Sib18Data,Sib1Data,Sib2Data,Sib3Data,Sib5Data,Sib7Data,StaticRoute,SupportedUpgradeTypesStatusData,TraceData,TransferData,TransportOptionDef,UniSaalProfileData,ValueOfUnex,VidInformation$
	#sorted_mom_list[moclass]=Aal0TpVccTp,Aal1TpVccTp,Aal2Ap,Aal2PathDistributionUnit,Aal2PathVccTp,Aal2QosCodePointProfile,Aal2QosProfile,Aal2RoutingCase,Aal2Sp,Aal5TpVccTp,AgpsPositioning,ArpMap,ArpQosClassProfile,AtmConfService,AtmCrossConnection,AtmPort,AtmTrafficDescriptor,Cbu,CcDevice,CchFrameSynch,CellUpdate,ChannelSwitching,CnOperator,ConfigurationVersion,CoverageRelation,CpmTransGapPattSeq,DcDevice,DchFrameSynch,DchMap,Dhcp,Ds0Bundle,E1PhysPathTerm,E1Ttp,E3PhysPathTerm,Equipment,EtMfg,EthernetLink,EthernetSwitch,EthernetSwitchPort,Eul,ExchangeTerminal,ExchangeTerminalIp,ExternalGsmCell,ExternalGsmNetwork,ExternalUtranCell,Fach,Fan,FastEthernet,GeneralProcessorUnit,GigaBitEthernet,GpsReceiver,GsmRelation,Handover,HgTtp,Hsdsch,ImaGroup,ImaLink,InternalEthernetPort,InternalLinkGroup,Ip,IpAccessAutoConfig,IpAccessHostEt,IpAccessHostGpb,IpAccessHostPool,IpAccessHostSpb,IpAtmLink,IpEthPacketDataRouter,IpInterface,IpOam,IpRoutingTable,IpSyncRef,IpSystem,IuBcLink,IuLink,IubEdch,IubLink,IurLink,J1PhysPathTerm,Jvm,Licensing,LoadControl,LoadModule,LocationArea,Log,LogService,M3uAssociation,ManagedElement,ManagedElementData,ManagedObject,Mbms,MbmsCch,MbmsServiceArea,MediumAccessUnit,MocnCellProfile,Mspg,MspgExtended,MtchFrameSynch,Mtp2Hsl,Mtp2HslProfileChina,Mtp2HslProfileItu,Mtp2HslTpChina,Mtp2HslTpItu,Mtp2ProfileAnsi,Mtp2ProfileChina,Mtp2ProfileItu,Mtp2ProfileTtc,Mtp2TpAnsi,Mtp2TpChina,Mtp2TpItu,Mtp2TpTtc,Mtp3bAp,Mtp3bSlAnsi,Mtp3bSlChina,Mtp3bSlItu,Mtp3bSlTtc,Mtp3bSls,Mtp3bSpAnsi,Mtp3bSpChina,Mtp3bSpItu,Mtp3bSpTtc,Mtp3bSr,Mtp3bSrs,NbapCommon,NbapDedicated,Ncli,NniSaalProfile,NniSaalTp,NodeSynch,Os155SpiTtp,Ospf,OspfArea,OspfInterface,PacketDataRouter,Paging,Pcap,Pch,PdrDevice,PiuType,PlmnIdentityGroup,PlugInUnit,PmService,PositioningServiceClass,PowerControl,Program,RabHandling,Rach,Ranap,Rcs,ReliableProgramUniter,Repertoire,ResMeasControl,RncCapacity,RncDeployment,RncFeature,RncFunction,RncModule,RncSystemParameters,RnlQosClassProfile,Rnsap,RoutingArea,Rrc,RttPositioning,SasPositioning,SccpAccountingCriteria,SccpApLocal,SccpApRemote,SccpEntitySet,SccpGlobalTitle,SccpPolicing,SccpScrc,SccpSp,Sctp,SduFormat,Security,SecurityHandling,ServiceArea,SgwMgmtMapping,Sid,Slot,SpDevicePool,SpiQosClass,Spm,Spu,Sts1SpeTtp,Sts3CspeTtp,Subflow,Subrack,SwAllocation,SwManagement,SwitchCoreUnit,SwitchExtensionUnit,SwitchFabric,SwitchInternalLink,SwitchModule,SwitchPortStp,SwitchStp,Synchronization,SystemFunctions,T1PhysPathTerm,T1Ttp,T3PhysPathTerm,TcMap,TdmCrossConnection,TimDevice,TimingUnit,TnlCchQosClassProfile,TnlDchQosClassProfile,TnlHspaQosClassProfile,TnlIuQosClassProfile,TnlQosClass,TrafficClass,TrafficClassPsInt,TransportNetwork,TuSyncRef,UeMeasControl,UePositioning,UeRabType,UeRc,UeRcEdchFlow,UeRcEdchGainFactors,UeRcHsdsch,UeRcPhyChDl,UeRcPhyChEdch,UeRcPhyChTfc,UeRcPhyChUl,UeRcRab,UeRcRb,UeRcRrc,UeRcTrCh,UeRrcType,UniSaalProfile,UniSaalTp,UpgradePackage,UpgradeTrace,Ura,UtranCell,UtranNetwork,UtranRelation,Vc11Ttp,Vc12Ttp,Vc3Ttp,Vc4Ttp,VclTp,VpcTp,VplTp,Vt15Ttp,WcdmaCarrier,WebServer$
	#sorted_mom_list[enumerate]=Aal2AllocationMode,AalCounterMode,ActivationVals,ActiveSwitchPlane,ActualEthernetSpeedDuplex,AdmState,AdmStateRn,AlarmReport,AtmCounterMode,AtmNomPmBlkSize,AtmQos,AutoConfigurationMode,AvailabilityStatus,BooleanVals,BridgePriority,BundlingActivated,CVActionMainResult,CVActionResultInformation,CVAutoConfigurationInformation,CVCurrentDetailedActivity,CVCurrentMainActivity,CVInvokedAction,CertCategory,CertEnrollState,ChangeoverType,ClassIdDef,ClockState,ConfigurationVersionType,CongestLevel,Crc4Mode,DefaultTraffic,DiscardReturnServiceMsg,DupuBehaviour,EdgePortMode,EmergencyStatus,EncodingScheme,ErrorCorrectionType,EthFrameFormat,EthernetSpeedDuplex,FaultCriteria,FileState,FileXferClient,FunctionName,GlobalTitleIndicator,HealthCheckActionResult,HealthCheckResultCode,HgTsAllocation,HomingState,IcmReturnCode,IdlePattern,Information,InvokedAction,IpTrafficType,J1Type,LedStatus,LinkActive,LinkPrimary,LmFilesInstallState,LoadClass,LoadModuleLoaderType,LoadModulePreLoadType,LoopbackDetection,LoopbackState,M3uAssociationRole,MauDuplexMode,ModifiedSlsRotation,MspActionResult,Mtp3bCongestLevel,Mtp3bNetworkInd,Mtp3bNetworkIndTtc,Mtp3bProceduralState,Mtp3bSioSpareBitsUse,Mtp3bSpPriorityLevel,Mtp3bTfrHandling,Mtp3bUsageState,Mtp3bVersion,MuxMode,NatureOfAddress,NodeBehaviourType,NodeRestartType,NtpServerMode,NumberingPlan,OnOffVals,OperState,OperVals,OperationalMode,Os155LoopBack,OspfMetricType,OutputMode,PathTraceFormat,PiuRole,Priority,ProtectionStatus,ProtocolVersion,RPUNormalisationMode,RPUOperationalMode,RPUReplicationMode,RPUSwitchOverMode,RefActivity,RefState,RemoteBlockingStates,RestartCause,RestartRank,RestartReason,RestartType,RouteState,RouteType,SccpCountType,SecurityLevel,SendLogs,SeqRestarts,SequnceNumberingType,ServiceCategory,SfpState,SharingMode,SignalNumber,SilPortState,SlotState,StandardMode,StartState,StateVals,StpActivation,StpMode,StpRole,StpState,SubrackType,SupportedAdminStates,SupportedAltitudeDirections,SupportedAmrNbModes,SupportedBands,SupportedChannelTypes,SupportedCnIndications,SupportedCompressedModeMethods,SupportedCoreNetDomains,SupportedCoverage,SupportedDeviceTypes,SupportedDirections,SupportedFreqRelations,SupportedGainFactorReferences,SupportedGpehRecordingLevels,SupportedHandoverTypes,SupportedHarqRedundTypes,SupportedIpAddresses,SupportedLatitudeSigns,SupportedMeasQuantities,SupportedMeasQuantitiesForConnQuality,SupportedMobilityRelationType,SupportedNetOpModes,SupportedNodeRelations,SupportedOperStates,SupportedPositioningFeatures,SupportedPositioningMethods,SupportedPositioningModes,SupportedPowerControlMethods,SupportedQoSClasses,SupportedRbTypes,SupportedRbUsers,SupportedRegulationTypes,SupportedReportFormats,SupportedResMeasQuantities,SupportedResServices,SupportedReservedStates,SupportedSasFeatures,SupportedSduFormatContexts,SupportedServiceClasses,SupportedServiceIndications,SupportedSsd,SupportedStandaloneSrbRates,SupportedStandbyStatuses,SupportedTrBearerQosClasses,SupportedTrafficClasses,SupportedTransmissionGrantTypes,SupportedTransportChannelTypes,SupportedUeAutoUpdateModes,SupportedUsageStates,SwitchModes,SwitchReliableGroup,SyncMode,SyncStatus,TestStatus,TraceType,TransmissionMode,TypeOfStorage,UpgradePackageState,UpgradePackageType,UpgradeProgressInformation,Weekday,WorkingMode$
	#sorted_mom_list[pull_mo]=Aal0TpVccTp,Aal1TpVccTp,Aal2Ap,Aal2PathDistributionUnit,Aal2PathVccTp,Aal2QosCodePointProfile,Aal2QosProfile,Aal2RoutingCase,Aal2Sp,Aal5TpVccTp,AgpsPositioning,ArpMap,ArpQosClassProfile,AtmConfService,AtmCrossConnection,AtmPort,AtmTrafficDescriptor,Cbu,CellUpdate,ChannelSwitching,CnOperator,ConfigurationVersion,CoverageRelation,CpmTransGapPattSeq,DchMap,Dhcp,Ds0Bundle,E1PhysPathTerm,E1Ttp,E3PhysPathTerm,Equipment,EtMfg,EthernetLink,EthernetSwitch,ExchangeTerminal,ExchangeTerminalIp,ExternalGsmCell,ExternalGsmNetwork,ExternalUtranCell,Fach,Fan,FastEthernet,GeneralProcessorUnit,GpsReceiver,HgTtp,ImaGroup,ImaLink,InternalLinkGroup,Ip,IpAccessAutoConfig,IpAccessHostGpb,IpAccessHostPool,IpAccessHostSpb,IpAtmLink,IpOam,IpRoutingTable,IpSyncRef,IpSystem,J1PhysPathTerm,Jvm,Licensing,LoadModule,Log,LogService,M3uAssociation,ManagedElement,ManagedElementData,MbmsServiceArea,MediumAccessUnit,MocnCellProfile,Mspg,MspgExtended,MtchFrameSynch,Mtp2Hsl,Mtp2HslProfileChina,Mtp2HslProfileItu,Mtp2HslTpItu,Mtp2ProfileAnsi,Mtp2ProfileChina,Mtp2ProfileItu,Mtp2ProfileTtc,Mtp2TpAnsi,Mtp2TpChina,Mtp2TpItu,Mtp2TpTtc,Mtp3bAp,Mtp3bSlAnsi,Mtp3bSlChina,Mtp3bSlItu,Mtp3bSlTtc,Mtp3bSls,Mtp3bSpAnsi,Mtp3bSpChina,Mtp3bSpItu,Mtp3bSpTtc,Mtp3bSr,Mtp3bSrs,NbapDedicated,Ncli,NniSaalProfile,NniSaalTp,Os155SpiTtp,Ospf,OspfArea,OspfInterface,Pch,PiuType,PlmnIdentityGroup,PlugInUnit,PmService,PowerControl,Program,RabHandling,ReliableProgramUniter,Repertoire,ResMeasControl,RncDeployment,RncFeature,RncModule,RncSystemParameters,RnlQosClassProfile,Rnsap,Rrc,RttPositioning,SccpAccountingCriteria,SccpApLocal,SccpApRemote,SccpEntitySet,SccpGlobalTitle,SccpPolicing,SccpScrc,SccpSp,Sctp,SduFormat,Security,ServiceArea,SgwMgmtMapping,Sid,Slot,SpDevicePool,SpiQosClass,Spm,Spu,Sts1SpeTtp,Sts3CspeTtp,Subflow,Subrack,SwAllocation,SwManagement,SwitchCoreUnit,SwitchExtensionUnit,SwitchFabric,SwitchInternalLink,SwitchModule,SystemFunctions,T1PhysPathTerm,T1Ttp,T3PhysPathTerm,TcMap,TdmCrossConnection,TimDevice,TimingUnit,TnlCchQosClassProfile,TnlDchQosClassProfile,TnlHspaQosClassProfile,TnlIuQosClassProfile,TnlQosClass,TrafficClass,TrafficClassPsInt,TransportNetwork,TuSyncRef,UeMeasControl,UePositioning,UeRabType,UeRcEdchFlow,UeRcEdchGainFactors,UeRcHsdsch,UeRcPhyChDl,UeRcPhyChEdch,UeRcPhyChTfc,UeRcPhyChUl,UeRcRab,UeRcRb,UeRcRrc,UeRcTrCh,UeRrcType,UniSaalProfile,UniSaalTp,UpgradePackage,UpgradeTrace,UtranNetwork,Vc12Ttp,Vc4Ttp,VpcTp,Vt15Ttp,WcdmaCarrier,WebServer$

	#action_list[moclass]=action1,action2,action3
	#sorted_action_list[moclass]=action1,action2,action3
	#attribute_list[moclass]=attribute,attribute,attribute
	#sorted_attribute_list[moclass]=attr,attr,attr
	#class_description[moclass]=description
	#mandatory_attributes[moclass]=attr1,attr2
	#restricted_attributes[moclass]=attr1,attr2
	#action[moclass,action]=numberofparams:param1:param2:type1:type2
	#actn_description[moclass,action]=description
	#actn_result[moclass,action]=returntype
	#attr_comments[moclass,attribute]=flags
	#attr_description[moclass,attribute]=description
	#MoAttributesType[moclass":"attribute]=type
	#MoAttributesTypeJava[moclass":"attribute]=javatype
	#mom_moclass_list[moclass]=moclass
	#tolower_mom_moclass_list[tolower(moclass)]=tolower(moclass)
	#Pm_attr_comments[moclass,pmattribute]=flags
	#Pm_attr_description[moclass,pmattribute]=description
	#Pm_attribute_list[moclass]=pmattribute,pmattribute
	#sorted_Pm_attribute_list[moclass]=pmattribute,pmattribute
	#PmAttributes[moclass":"pmattribute]=moclass":"pmattribute
	#PmAttributesType[moclass":"pmattribute]=type
	#attr_default
	#attr_length
	#attr_range

	#enum[enum,translation]=value
	#enum[enum,value]=translation
	#enum_contents[enum]=value:translation, value:translation
	#enum_description[enum]=description

	#struct_contents[struct]=member,member,member
	#struct_description[struct]=description
	#struct_type[struct,member]=type

	#pdf_counter_table[counter]=nrOfelements

	#pull_molist[moclass]=moclass
	#childList
	#sorted_childList

	#sorted_pull_attrlist[moclass]=attr1,attr2
	#eget_attribute_list
	#sorted_eget_attribute_list
	#sorted_mom_list
	#sorted_parentList
	#sorted_pull_attrlist

	#cardinality
	#pdf_counter_table
	#pull_attrlist
	#pull_molist

}

function make_fake_celloversion(    res,tver)
{
	#derived from mom_version
	res="7-FAKE"
	tver=gensub(/^.*NODE_MODEL_/,"",1,mom_version)
	if (mosdebug==1) print "MOMVERSION="mom_version", tver="tver
	if (mom_version ~ /^RNC/)
	{
		if (tver >= "L") res="8-FAKE"
		else if (tver >= "K") res="7-FAKE"
		else if (tver >= "H") res="6-FAKE"
		else if (tver >= "G") res="5-FAKE"
		else if (tver >= "E") res="4-FAKE"
		else if (tver >= "D") res="3-FAKE"
	}
	else if (mom_version ~ /^ERBS/)
	{
		if (tver >= "B") res="8-FAKE"
		else if (tver >= "A") res="7-FAKE"
	}
	else if (mom_version ~ /^WRBS/)
	{
		if (tver >= "A") res="8-FAKE"
	}
	else if (mom_version ~ /^RBS/)
	{
		if (tver >= "M") res="8-FAKE"
		else if (tver >= "L") res="7-FAKE"
		else if (tver >= "K") res="6-FAKE"
		else if (tver >= "J") res="5-FAKE"
		else if (tver >= "H") res="4-FAKE"
	}
	else if (mom_version ~ /^RANAG/)
	{
		if (tver >= "H") res="7-FAKE"
		else if (tver >= "G") res="6-FAKE"
		else if (tver >= "E") res="5-FAKE"
	}
	else if (mom_version ~ "CPP")
	{
		res=gensub(/^.*CPP/,"",1,mom_version)+0"-FAKE"
	}
	else if (mom_version ~ "MGW")
	{
		if (tver >= "R6") res="7-FAKE"
		else if (tver >= "R5") res="6-FAKE"
		else if (tver >= "R4") res="5-FAKE"
		else if (tver >= "R3") res="4-FAKE"
		else if (tver >= "B" && convert_momrevision(tver) >= "B_000015_000052") res="8-FAKE"
		else if (tver >= "A") res="7-FAKE"
	}
	else if (mom_version ~ /^TDRNC/)
	{
		if (tver >= "B") res="8-FAKE"
		else if (tver >= "A") res="6-FAKE"
	}
	if (mosdebug==1) print "DEBUG: fakecppmomversion="res
	return res
}
function process_tag(   currtag,currtagtext)
{
	currtag=gensub(/^<|>.*$/,"","g",$1)
	currtagtext=gensub(/^[ \t]*<[^>]+>[ \t]*/,"",1,$0)
	currtagtext=gensub(/[ \t]*<[^>]+>[^>]*$/,"",1,currtagtext)
	if ((currtag,currtagtext) in tagTranslation) currtagtext=tagTranslation[currtag,currtagtext]
	if (currtag=="visibility" && tolower(currtagtext) ~ "hidden") currtagtext=currtagtext"\nThis attribute may only be changed by Ericsson personnel."
	return sprintf("%s%s",tagTranslation[currtag],currtagtext)
}
function make_mom_version_com(string,   array,mimT,i,last,word,res,res2)
{
	#<mim name="ECIM_CommonLibrary" organization="LMI/LXR" release="0" version="1">
	#<mim author="ERAASC" contact="EAB/FLE/CD Anders Carlsson" date="2011-09-12" docNo="" name="ComTop" namespace="urn:com:ericsson:ecim:ComTop" namespacePrefix="comtop" organization="EAB/FLE/CD" release="0" revision="" version="3">
	#<mim author="Vahagn Avedian" contact="ETXAVED" date="04/11/2011" docNo="" name="ComSysM" namespace="urn:com:ericsson:ecim:ComSysM" namespacePrefix="comsysm" organization="EAB/FLE/TA" release="0" revision="A" version="2">
	#<mim author="EHSWOLM" contact="Thomas Wolmer" date="2011-04-14" docNo="" name="ComFm" namespace="urn:com:ericsson:ecim:ComFm" namespacePrefix="comfm" organization="EAB/FLE/CC" release="0" revision="" version="2_3">
	#<mim author="QPEREBJ" contact="" date="2011-04-18" docNo="" name="ComSecM" namespace="urn:com:ericsson:ecim:ComSecM" namespacePrefix="comsecm" organization="EAB/FLE/CB" release="0" revision="" version="1_0">
	#<mim author="QPEREBJ" contact="" date="2011-04-18" docNo="" name="ComLocalAuthorization" namespace="urn:com:ericsson:ecim:ComLocalAuthorization" namespacePrefix="comlocalauthorization" organization="EAB/FLE/CB" release="0" revision="" version="1_0">
	#<mim author="QPEREBJ" contact="" date="2011-04-18" docNo="" name="ComLdapAuthentication" namespace="urn:com:ericsson:ecim:ComLdapAuthentication" namespacePrefix="comldapauthentication" organization="EAB/FLE/CB" release="0" revision="" version="1_0">
	#<mim author="" contact="" date="" docNo="" name="Context" namespace="urn:com:ericsson:ecim:Context" namespacePrefix="context" organization="" release="not released" revision="" version="R1.0">
	#<mim author="" contact="" date="" docNo="" name="SSRAdmintratorMom" namespace="urn:com:ericsson:ecim:SSRAdmintratorMom" namespacePrefix="ssradmintratormom" organization="" release="1" revision="" version="1">
	#<mim author="Patrik Buhr" contact="QPATBUH" date="" docNo="" name="ComSnmp" namespace="urn:com:ericsson:ecim:ComSnmp" namespacePrefix="comsnmp" organization="EAB/FLE/CC" release="0" revision="A" version="10">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Node" namespace="urn:com:ericsson:ecim:Epg_Node" namespacePrefix="epg_node" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_Dhcp" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_Dhcp" namespacePrefix="epg_pgw_apn_dhcp" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_PCscf" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_PCscf" namespacePrefix="epg_pgw_apn_pcscf" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_Pdp_SC_Idle_Def" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_Pdp_SC_Idle_Def" namespacePrefix="epg_pgw_apn_pdp_sc_idle_def" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_Pdp_SC_Idle_Plmn" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_Pdp_SC_Idle_Plmn" namespacePrefix="epg_pgw_apn_pdp_sc_idle_plmn" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="3">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_Pdp_SC_Idle_Prof" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_Pdp_SC_Idle_Prof" namespacePrefix="epg_pgw_apn_pdp_sc_idle_prof" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_Pdp_SC_Idle_Roam" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_Pdp_SC_Idle_Roam" namespacePrefix="epg_pgw_apn_pdp_sc_idle_roam" organization="" release="0" revision="" version="2">
	#<mim author="ervxipe2" contact="ervxipe2" date="" docNo="" name="Epg_Pgw_Apn_QosControl" namespace="urn:com:ericsson:ecim:Epg_Pgw_Apn_QosControl" namespacePrefix="epg_pgw_apn_qoscontrol" organization="Ericsson EAB, NDO EPG" release="0" revision="" version="3">
	last=split(string,array," ")
	for (i=1;i<=last;i++)
	{
		split(array[i],word,"=")
		mimT[word[1]]=gensub(/\"|>/,"","g",word[2])
	}
	res=mimT["name"]
	#if (mimT["version"] != "") res=res"_"mimT["version"]
	#if (mimT["release"] != "") res=res"_"mimT["release"]
	#if (mimT["correction"] != "") res=res"_"mimT["correction"]
	res=res2=res"_"mimT["version"]"."mimT["release"]"."mimT["correction"]
	if (mimT["revision"] != "") res=res"_"mimT["revision"]
	return mimT["name"] SUBSEP res SUBSEP res2
	#res2 is same as res but without the revision field -> res2 is used for calculating the crc part for the MOM version
}

function make_mom_version(string,suffix,   array,res,i)
{
	#        <mim name="MRS_NODE_MODEL_B" version="15" release="214">
	#   <mim name="RNC_NODE_MODEL_G" version="1" release="5">
	#   <mim name="RNC_NODE_MODEL_G_COMPLETE" version="1" release="5">
	#   <mim name="RNC_NODE_MODEL_CPP9UPLIFT" version="71" release="5" author="David Sundqvist / Jacqueline Beaulac" date="Wed Feb 02 10:23:17 CET 2011" revision="">
	#  <mim name="CPP MOM" version="MOM-CPP6-LSV25" release="2">   (it can contain spaces, remove them
	#CelloMOM_hidden                MOM-CPP-C12-LSV73.1-gen3-complete gen3-complete

	split(string,array,"=")
	if (string !~ /[<>"]/)
	{
		if (string !~ "NODE_MODEL") return ""
		#In multimode we have this type of string:
		#172.31.88.70 name=Cello type=ERBS_NODE_MODEL_A version=3.10 release=
		#172.31.68.99 name=Cello type=MGW_NODE_MODEL_R5_1 version=R30 release=F01
		#172.31.68.105 name=Cello type=RANAG_NODE_MODEL_J version=1.18 release=
		#137.58.194.78 name=Cello type=RBS_NODE_MODEL_N version=1.44 release=
		#131.160.80.127 name=Cello type=MRS_NODE_MODEL_B version=15 release=213
		for (i=3;i<=5;i++) array[i-1]=gensub(/ .*$/,"",1,array[i])
		if (array[3] ~ /^[0-9]+\.[0-9]+$/ && array[4] ~ /^[ \t]*$/)
		{
			#172.31.88.70 name=Cello type=ERBS_NODE_MODEL_A version=3.10 release=
			array[4]=gensub(/^.*\./,"",1,array[3])
			array[3]=gensub(/\..*$/,"",1,array[3])
		}
	}
	else
	{
		for (i=2;i<=4;i++)
		{
			gsub(/^[^"]*["]|["][^"]*$|[ \t)(]|[-_l]*(hidden|limited|complete)/,"",array[i])
		}
	}
	gsub(/-/,"_",array[2])
	sub(/CPP8UPLIFT/,"L_1",array[2])
	sub(/CPP9UPLIFT/,"M_1",array[2])
	#Possible fix to support the fact that MIM name sometimes differs on CPP complete MOM and limited MOM
	#always put CPP as MIM name on CPP MOM because sometimes it differs between complete MOM and limited MOM, eg:
        #<mim name="CPP" version="MOM-CPP-C12-LSV74-gen1-limited" release="gen1-limited" author="" date="Tue Feb 22 16:35:15 CET 2011" revision="MOM-CPP-C12-LSV74-gen1-limited">
        #<mim name=""    version="MOM-CPP-C12-LSV74-gen1-complete" release="gen1-complete" author="" date="Tue Feb 22 10:48:58 CET 2011" revision="MOM-CPP-C12-LSV74-gen1-complete">
	#if (array[3] ~ "CPP") array[2]="CPP"
	res=array[2]"_"array[3]"_"array[4] suffix
	if (res ~ /^_/ && res ~ "CPP") res="CelloMOM" res
	if (res ~ /^MRS/) sub(/^MRS/,"MRSMGW",res)
	return res
}
function make_cello_version(tmpCelloVersion)
{
	tmpCelloVersion="9"tmpCelloVersion
	#if (tmpCelloVersion ~ "C13") tmpCelloVersion="91"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C14") tmpCelloVersion="92"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C15") tmpCelloVersion="93"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C16") tmpCelloVersion="94"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C17") tmpCelloVersion="95"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C18") tmpCelloVersion="96"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C19") tmpCelloVersion="97"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C20") tmpCelloVersion="98"tmpCelloVersion
	#else if (tmpCelloVersion ~ "C21") tmpCelloVersion="99"tmpCelloVersion
	return tmpCelloVersion
}
function readmom(mom_file,check,   array,last,i,tempRange,type,param_range,param_desc,paramlist,param,returnType,mom_file_cache,\
moclass,readmom_command,tempDefaultValue,momHide,tempUnit,tmpCelloVersion,inmimpart,inmetadata,currMim,tval,theMim,inmim,mimLine,actnExceptions,inrelationship,t_text,t_name,\
inbidir,incardinality,min,max,incontainment,relmocount,relattrcount,relattr,relmo,relcard,relcardcount,processedMomFile,new_readmom_command,line,isexcl,deprecated_relationship,\
tname,bufferedEcimMomVer,a,inenum,enumname,instruct,structname,inclass,classname,inattribute,attributename,inaction,actionname,inenummember,enummembername,instructmember,\
structmembername,inactiondescription,inactiontag,inattributedescription,inattributetag,inchild,inclassdescription,inclasstag,inderived,inderiveddescription,inderivedtag,\
inenumdescription,inenummemberdescription,inenummembertag,inenumtag,inparameter,inparameterdescription,inparametertag,inparent,inreturntype,instructdescription,\
instructmemberdescription,instructmembertag,instructtag)
{
	inmim=0
	#comcli=0   #initialise comcli to 0 in case by mistake a user has connected to a CPP node with the uv comcli>0  ?
	mimLine=""
	delete bufferedEcimMomVer
	#fist we check if there is already a cached MOM and if yes, parse it
	if (mom_file ~ /.cache(.gz)?$/)
	{
		mom_file_cache = gensub(/.gz$/,"",1,mom_file)
		sub(/.cache(.gz)?$/,"",mom_file)
	}
	else mom_file_cache = gensub(/\.(gz|jar)$/,"",1,mom_file)".cache"
	if (read_mom_cache(mom_file_cache) == 0) return

	#if no cached mom, we parse the regular MOM and produce a cached MOM

	mom_file=correct_mom_path(mom_file)
	if (fileOps("test -s "mom_file) != 0) { customPrint("MOM file not found: "mom_file) ; return }
	else if (fileOps("grep </models> "mom_file)!=0 || fileOps("grep \x000\x000\x000\x000\x000\x000 "mom_file)==0)
	{
		customPrint("ERROR: MOM file is corrupted: "mom_file)
		customPrint("       Please delete this file and try again !!")
		return
	}

	if (check=="check") customPrint("Checking MOM version...","","","noLF")
	else customPrint(sprintf("Parsing MOM: "mom_file" "),"","","noLF")

	clear_mom_tables()
	tagFilterStart=tagFilterEnd=""
	for (i in tagTranslation) tagFilterStart=tagFilterStart"|"i
	sub(/^./,"",tagFilterStart)
	tagFilterEnd="</("tagFilterStart")>"
	tagFilterStart="^<("tagFilterStart")>"
	i=0 #initialise this, very important or can be hanging

	if (mom_file ~ /.xml$/) readmom_command="cat "mom_file
	else if (mom_file ~ /.xml.jar$/) readmom_command="unzip -p "mom_file" \\*.xml"
	else if (mom_file ~ /.xml.gz$/)  readmom_command="gzip -dc "mom_file
	else readmom_command="cat "mom_file   #in case someone tries to parse a MOM that does not have an xml extension
	CelloVersion=mom_version=momdocnumber=momdocrevision=""


	#some MOMs have several tags on the same line which cannot be parsed properly by moshell.
	#eg RNC MOM :
	#</description><dataType><sequence><moRef name="ExternalUtranCell"/><minLength>0</minLength><maxLength>1</maxLength></sequence></dataType><obsolete>This attribute is currently not used by the RNC.  Changing it has no effect.</obsolete><takesEffect>New connections</takesEffect></attribute>

	processedMomFile=tempdir"/processedMomFile.xml"
	fileOps("rm "processedMomFile)
	while (readmom_command |& getline)
	{
		gsub("\r","") ; gsub("\x000","") ; gsub(/[‘]/,"") ; gsub(/^[\t][\t]+/,"")
        	if (mosdebug==0 && check!="check") show_progress(5000)
		#check if a end tag is followed by another tag, eg </description><dataType>
		if (NF==0) continue
		if (/<[^<>/]*\/[^<>/]*>.*</)
		{
			new_readmom_command="cat "processedMomFile
			#print $0
			#gsub(/>/,">\n")
			line=""
			last=split($0,array,">")
			for (i=1;i<=last;i++) line=line array[i] (array[i]~/</?">":"") (array[i]~/<.*\//?"\n":"")
			$0=line
		}
		print $0 >> processedMomFile
	}
	close(readmom_command)
	close(processedMomFile)
	if (new_readmom_command != "")
	{
		readmom_command=new_readmom_command
		close(readmom_command)
	}
	else fileOps("rm "processedMomFile)
	while (readmom_command |& getline)
	{
		#This is to cope for MOMs where we have the end tag on the same line as a start tag. eg: </struct></struct name=....
        	gsub("\r","") ; gsub("\x000","") ; gsub(/[‘]/,"") ; gsub(/^[\t][\t]+/,"")
        	if (mosdebug==0 && check!="check") show_progress(2000)
        	if (comcli==0 && /<!-- ECIM MOM -->/) comcli=1
        	else if (comcli>0 && $1 == "<mim" && $NF !~ />$/) { inmim=1 ; mimLine=$0 }
        	else if (comcli>0 && inmim==1)
        	{
        		mimLine=mimLine" "$0
        		if ($NF ~ />$/)
        		{
        			inmim=0
        			$0=mimLine
        		}
        	}
        	else if (comcli==0 && NF==2 && $2~/^MOM-CPP/ && $1~/^[A-Z]/)
        	{
			#Atm		MOM-CPP8-LSV59.2.1-2
			#CommonDefinitions		MOM-CPP8-LSV59.2.1-2
			#Support_System		SupportSystem_A.7.3
			#Equipment		MOM-CPP8-LSV59.2.1-2
			#ExtEthSwitching		MOM-EP1-CPP8.0.1.1
        		momParts[$1]=translate_cppUpVersion($2,"mom")
        	}

        	#The above is to handle case where the <mim is split into several lines like above
		#<mim author="EEIDBUI"
		#     contact="LMI/LXR/SD Dominic Buffini"
		#     date="2010-12-14"
		#     docNo=""
		#     name="ECIM_Equipment"
		#     namespace="urn:com:ericsson:ecim:ECIM_Equipment:ECIM_Equipment:1.0"
		#     namespacePrefix="ecim_equipment"
		#     organization="LMI"
		#     release="0"
		#     revision="B"
		#     version="1">

        	if (comcli>0 && $0 ~ /<mim / && inmim==0)
        	{
        		split(make_mom_version_com($0),array,SUBSEP)
        		currMim=array[1]
        		mimComponents[++mimCounter]=array[2]
        		mimComponents[array[2]]=mimCounter
        		mimNames[mimCounter]=currMim
        		mimNames[currMim]=mimCounter
        		momVersionComponents[array[3]]=array[3]
        	}
		else if (comcli>0 && $1=="<extension" && /name=\"ecimMomName\"/)
		{
			#            <extension name="ecimMomName" value="ECIM_Top"/>
			tval=""
			for (i=1;i<=NF;i++)
			{
				if ($i ~ /^value=\"/)
				{
					tval=gensub(/^.*=\"|\"[^"]+$/,"","g",$i)
					ecimMomName[currMim]=tval
					ecimMomName[tval]=currMim
					break
				}
			}
		}
		else if (comcli>0 && $1=="<extension" && /name=\"ecimMom(Version|Release|Correction)\"/)
		{
		        #	<extension name="ecimMomVersion" value="1"/>
		        #       <extension name="ecimMomRelease" value="2"/>
		        #       <extension name="ecimMomCorrection" value="1"/>
			tname=tval=""
			for (i=1;i<=NF;i++)
			{
				#assuming name comes before value
				if ($i ~ /^name=\"/) tname=gensub(/^.*=\"|\"[^"]*$/,"","g",$i)
				else if ($i ~ /^value=\"/)
				{
					tval=gensub(/^.*=\"|\"[^"]+$/,"","g",$i)
					#If assuming that the order will be Version, Release, Correction:
					#ecimMomVer[ecimMomName[currMim]]=ecimMomVer[ecimMomName[currMim]]"_"tval
					#Better method:
					bufferedEcimMomVer[tname]=(tname~/Release|Correction/?".":"") tval
					break
				}
			}
		}
		else if (comcli>0 && $1=="</domainExtension>" && length(bufferedEcimMomVer)>0 && currMim in ecimMomName && ecimMomName[currMim]!="")
		{
			ecimMomVer[ecimMomName[currMim]]="_"bufferedEcimMomVer["ecimMomVersion"] bufferedEcimMomVer["ecimMomRelease"] bufferedEcimMomVer["ecimMomCorrection"]
			tval=ecimMomName[currMim]"_"bufferedEcimMomVer["ecimMomVersion"] bufferedEcimMomVer["ecimMomRelease"]
			ecimVersionComponents[tval]=tval
			delete bufferedEcimMomVer
		}
		else if ($0 ~ "<mim name=")
		{
			#   <mim name="RNC_NODE_MODEL_G" version="1" release="5">
			#  <mim name="CPP MOM" version="MOM-CPP6-LSV25" release="2">   (it can contain spaces, remove them
			split($0,array,"\"")
			#cope for BSC MOMs where the cello part comes after the application part
			if (!(cdmaMOM==1 && mom_version !~ "CELLO"))
			{
				if (array[2] ~ "_COMPLETE" || mom_file ~ "_COMPLETE.xml") mom_version=make_mom_version($0,"_COMPLETE")
				else mom_version=mom_version=make_mom_version($0)
			}
			if (CelloVersion == "")
			{
				#initialise CelloVersion in case it is missing from the MOM file, will avoid empty value
				CelloVersion=make_fake_celloversion()
			}
		}
		else if ($1=="<mimParts>") inmimpart=1
		else if ($1=="</mimParts>") inmimpart=0
		else if ($1=="<momMetaData>") inmetadata=1
		else if ($1=="</momMetaData>") inmetadata=0
		else if ((comcli==0)&&(($1 ~ /^(Revision|Label):$/ && $2 ~ /CELLO|CPP/) || ($0 ~ /^<!--@master: CPP_MOM MOM-CPP[^ ]+ [^ ]+-->/)))
		{
			# Revision:        MOM-CELLO_4.3.1
			# Revision:        MOM_CPP5_LSV35-2   ---> replace with: 5.0_LSV35-2
			# Revision:        MOM_CPP5.1_LSV33_WP1-8
			# Revision:        MOM-CPP_4.3.3-1
			# Revision:        MOM-C12.0-LSV69-gen5-limited   ---> replace with 912.0-LSV69
			# Label:          MOM-CPP8-LSV59.2.1-2
			#<!--@master: CPP_MOM MOM-CPP7.0-LSV10 3-->
			#<!--@master: CPP_MOM MOM-CPP-C12.0-LSV67 gen5-->
			if ($1=="Revision:")
			{
				momdocrevision=$2
				CelloVersion=gensub(/^.*(CELLO|CPP)_*/,"",1,$2)
				# WE REPLACE 5_ WITH 5.0_ FOR PROPER COMPARISONS BETWEEN CPP VERSIONS, eg in function find_xmlLogs_pathes()
				sub(/^5_/,"5.0_",CelloVersion)
			}
			else if ($1 == "Label:")
			{
				CelloVersion=gensub(/^.*(CELLO|CPP)_*/,"",1,$2)
				if (CelloVersion !~ /^[3-9]/) CelloVersion=make_cello_version(CelloVersion)
			}
			else
			{
				CelloVersion=sprintf("%s-%s",gensub(/^.*CPP/,"",1,$3),gensub(/--.*$/,"",1,$4))
				if (CelloVersion !~ /^[3-9]/) CelloVersion=make_cello_version(CelloVersion)
			}
		}
		else if (inmimpart==1 && $1 ~ /^<(name|label)>/)
		{
			# <label>MOM-CPP8-LSV59.2.1-2</label>
                        #<mimPart>
                        #        <name>Synchronization</name>
                        #        <label>EMX_BUILD_LABEL_NOT_DEFINED</label>
                        #        <label>MOM-CPP-LSV130</label>
                        #</mimPart>
                        t_text=gensub(/^[^>]+> *| *<[^<]+$/,"","g",$0)
                        #print $1,t_text
                        if ($1~/^<name>/) t_name=t_text
			else if ($1 ~ /^<label>/)
			{
				if (t_text~"CPP")
	                        {
	                        	momParts[t_name]=translate_cppUpVersion(t_text,"mom")
					CelloVersion=gensub(/^.*(CELLO|CPP)_*/,"",1,t_text)
					if (CelloVersion !~ /^[3-9]/) CelloVersion=make_cello_version(CelloVersion)
	                        	#if (CelloVersion > momParts[t_name]) CelloVersion=momParts[t_name]  --> for future implementation
	                        }
	                        else
	                        {
	                        	momParts[t_name]=t_text
	                        }
			}
                }
		else if (comcli==0 && CelloVersion ~ /^$|FAKE/ && NF==2 && $2 ~ /^MOM-CPP/)
		{
			#Atm             MOM-CPP8-LSV48
			#Atm             MOM-CPP9-LSV68
			#Atm             MOM-CPP-C12-LSV69
			tmpCelloVersion=gensub(/^MOM-CPP/,"",1,$2)
			if (tmpCelloVersion !~ /^[3-9]/) tmpCelloVersion=make_cello_version(tmpCelloVersion)
			if (tmpCelloVersion >= CelloVersion) CelloVersion=tmpCelloVersion
		}
		else if (comcli==0 && $1 == "Document" && $2 == "no:")
		{
			momdocnumber=gensub(/^.*Document +no:[ \t]*|[ \t]*$/,"","g",$0)
			#CPP MOM:
			#        Document no:    190 89-1/CSX 101 09
			#        Revision:       MOM-CPP5.1.2.1-3
			#RNC MOM:
			#     Document no:     15554-AXD10503/1
			#     Revision:        Z1
			#RBS MOM:
			#     Document no:     1/15554-CXA104389 Uen
			#     Revision:        F
			#MGW MOM:
			#     Document no:     CXC 132 9486/2
			#     Revision:        R12A01
		}
		else if (comcli==0 && $1 == "Revision:") momdocrevision=$2
		#<label>RncMOM.BU.3</label>
		#Label: RncMOM.BU.3
		else if (comcli==0 && /[Ll]abel.*RncMOM/) momdocrevision=gensub(/^.*RncMOM.|<\/.*$/,"","g",$0)
		else if (inmetadata==1 && $1 ~ /^<docNum>/) momdocnumber=gensub(/^.*<docNum> *| *<\/docNum>.*$/,"","g",$0)
		else if (inmetadata==1 && $1 ~ /^<docRev>/) momdocrevision=gensub(/^.*<docRev> *| *<\/docRev>.*$/,"","g",$0)
		else if (comcli==0 && mom_version ~ /RNC_NODE_MODEL/ && /<applicationTag.*Filter=.DD|<filter/)
		{
			#These are valid filter tags:
		        #<applicationTag>Filter=FDD</applicationTag>
		        #<applicationTag>Filter=TDD</applicationTag>
			#<filter>FDD</filter>
			#<filter>TDD</filter>
			#These are not valid filter tags:
		        #<applicationTag>ReviewComment='TDD: in a timeslot in current cell'</applicationTag>
		        #<filter>ApplicationXml,FDD,TDD</filter>
		        if (/TDD.*FDD|FDD.*TDD/) continue
			if ((mom_version ~ /TDRNC/ && /FDD/) || (mom_version ~ /^RNC/ && /TDD/))
			{
				if (inenum==1) momHide["enum",enumname]=1
				else if (instruct==1) momHide["struct",structname]=1
				else if (inclass==1) momHide["class",classname]=1
				else if (inattribute==1) momHide["attribute",classname,attributename]=1
				else if (inaction==1) momHide["action",classname,actionname]=1
				else if (inenummember==1) momHide["enummember",enumname,enummembername]=1
				else if (instructmember==1) momHide["structmember",structname,structmembername]=1
			}
		}

		if (check=="check") continue

		#</enum><enum name="AdministrativeStateT">
		if (/<enum name=/)
		{
			inenum=1
			inenummember=0
		}
		# <enumMember name="OUT ">  (if extra space remove it)
		else if (/<enumMember name=/)
		{
			inenum=0
			inenummember=1
		}
        	else if (/<struct name=/)
        	{
        		instruct=1
        		instructmember=0
        	}
        	else if (/<structMember name=/)
        	{
        		instruct=0
        		instructmember=1
        	}
        	else if (/<class name=/)
        	{
        		inclass=1
        		inattribute=0
        		inaction=0
        		inparameter=0
        	}
        	else if (/<attribute name=/)
        	{
        		inclass=0
        		inattribute=1
        		inaction=0
        		inparameter=0
        	}
        	else if  (/<action name=/)
        	{
        		inclass=0
        		inattribute=0
        		inaction=1
        		inparameter=0
        	}
        	else if (/<parameter name=/)
        	{
        		inclass=0
        		inattribute=0
        		inaction=1
        		inparameter=1
        	}
		else if (/<containment>/)
		{
			incontainment=1
			incardinality=0
			min=max=parentmo=childmo=""
		}
		else if (/<derivedDataType name=/)
		{
			inderived=1
		}
		else if (/<(uni|bi)DirectionalAssociation>/)
		{
			inbidir=1
			incardinality=0
			min=max=""
			relmocount=relattrcount=relcardcount=0
			delete relmo
			delete relattr
			delete relcard
		}
		#handling of deprecated relationships:
		#<relationship name="GeranFreqGroup_to_GeranFrequency">
		#	<deprecated>Since L14B. Replaced by GeranFrequency below MOC GeraNetwork.</deprecated>
		else if (/<relationship name=/) inrelationship=1
		else if (inrelationship==1 && /<deprecated/) deprecated_relationship=1
		else if (inrelationship==1 && /<\/relationship>/) deprecated_relationship=inrelationship=0

		if (inenum==1)
		{
			if (/<enum name=/)
			{
				split($0,array,/\"/)
				enumname=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				if (comcli>0) enumname=currMim "." enumname #&& enumname in enum_description
			}
			if (/<description>/)
			{
				inenumdescription=1
				split($0,array,/description>|<\/description/)
				enum_description[enumname]=gensub(/^ */,"",1,array[2])
			}
			if (inenumdescription==1)
			{
				if (!/<description/) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inenumdescription=0
			}
			if ($1 ~ tagFilterStart)
			{
				inenumtag=1
				enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],process_tag())
			}
			if (inenumtag==1)
			{
				if ($1 !~ tagFilterStart) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inenumtag=0
			}
			#if ($1 ~ tagFilterStart) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],process_tag())
		}
		else if (inenummember==1)
		{
			if (/<enumMember name=/)
			{
				split($0,array,/\"/)
				enummembername=gensub(/^ *| *$/,"","g",array[2])
				enum_description[enumname]=sprintf("%s\n - %s: ",enum_description[enumname],enummembername)
			}
			if (/<description>/)
			{
				inenummemberdescription=1
				split($0,array,/description>|<\/description/)
				enum_description[enumname]=sprintf("%s%s",enum_description[enumname],gensub(/^ */,"",1,array[2]))
			}
			if (inenummemberdescription==1)
			{
				if (!/<description/) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inenummemberdescription=0
			}
			if (/<value\>/)
			{
				split($0,array,/>|</)
				if (!((enumname,array[3]) in enum)) enum_contents[enumname]=sprintf("%s, %s:%s",enum_contents[enumname],array[3],enummembername)
				enum[enumname,array[3]]=enummembername
				enum[enumname,enummembername]=array[3]
			}
			if (/<\/enumMember>/) inenummember=0
			if ($1 ~ tagFilterStart)
			{
				inenummembertag=1
				enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],process_tag())
			}
			if (inenummembertag==1)
			{
				if ($1 !~ tagFilterStart) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inenummembertag=0
			}
			#if ($1 ~ tagFilterStart) enum_description[enumname]=sprintf("%s\n%s",enum_description[enumname],process_tag())
		}
		else if (inderived==1)
		{
			#  <derivedDataType name="EcimEmpty">
			#      <description>The empty built-in type represents a leaf that does not have any value, it conveys information by its presence or absence.</description>
			#      <baseType>
			#          <boolean/>
			#      </baseType>
			#  </derivedDataType>
			if (/<derivedDataType name=/)
			{
				split($0,array,/\"/)
				derivedname=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				if (comcli>0)
				{
					derivedname=currMim "." derivedname #&& derivedname in derived_description
					derived_type[derivedname]=""  #must initialise in case the same derived appears several times, happens in BSP MOM
				}
			}
			if (/<description>/)
			{
				inderiveddescription=1
				split($0,array,/description>|<\/description/)
				derived_description[derivedname]=gensub(/^ */,"",1,array[2])
			}
			if (inderiveddescription==1)
			{
				if (!/<description/) derived_description[derivedname]=sprintf("%s\n%s",derived_description[derivedname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inderiveddescription=0
			}
			if ($1 ~ tagFilterStart)
			{
				inderivedtag=1
				derived_description[derivedname]=sprintf("%s\n%s",derived_description[derivedname],process_tag())
			}
			if (inderivedtag==1)
			{
				if ($1 !~ tagFilterStart) derived_description[derivedname]=sprintf("%s\n%s",derived_description[derivedname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inderivedtag=0
			}
			if (/<isPassphrase/) derived_description[derivedname]=sprintf("%s\n%s",derived_description[derivedname],"IsPassPhrase: Yes")
			if (/<sequence/) derived_type[derivedname]="sequence:"
			#ignore the tag <stringLength>
			if (/<boolean|<long|<integer|<string[^L]|<float|<moRef|<enumRef|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/)
			{
				split($0,array,"<")
				split(array[2],array,">")
				sub(/ *\//,"",array[1])
				sub("derivedDataTypeRef","derivedRef",array[1])
				if (/name=/)
				{
					sub(/ name=\"/,":",array[1])
					sub(/\"/,"",array[1])
				}
				derived_type[derivedname]=derived_type[derivedname] array[1]
			}
			if (/<min>.*<\/min>/) tempRange=sprintf("%sMin=%s ",tempRange,gensub(/^.*<min>|<\/min>.*$/,"","g",$0))
			if (/<max>.*<\/max>/) tempRange=sprintf("%sMax=%s ",tempRange,gensub(/^.*<max>|<\/max>.*$/,"","g",$0))
			if (/<defaultValue>.*<\/defaultValue>/)
			{
				tempDefaultValue=replace_signs(gensub(/^.*<defaultValue>|<\/defaultValue>.*$/,"","g",$0))
				gsub(/ *, */,",",tempDefaultValue) #a default value of type sequence should not have spaces between the commas, confuses momr and diffr
				tempRange=sprintf("%sDefault=%s ",tempRange,tempDefaultValue)
				attr_default[derivedname]=attr_default[derivedname]","gensub(/\"/,"","g",tempDefaultValue)
				sub(/^,/,"",attr_default[derivedname])
			}
			if (/<unit>.*<\/unit>/)
			{
				#print derivedname,"x",derivedmembername,"y",$0
				attr_unit[derivedname]=sprintf("%s%s",(derivedname in attr_unit?attr_unit[derivedname]" ":""),gensub(/^.*<unit> *| *<\/unit.*$/,"","g",$0))
			}
			if (/<multiplicationFactor>.*<\/multiplicationFactor>/) attr_unit[derivedname]=sprintf("%s%s",gensub(/^.*<multiplicationFactor> *| *<\/multiplicationFactor.*$/,"","g",$0),(derivedname in attr_unit?" "attr_unit[derivedname]:""))
			if (/<\/derivedDataType>/)
			{
				inderived=0
				if (derivedname in attr_unit) derived_description[derivedname]=sprintf("%s\nUnit: %s",derived_description[derivedname],attr_unit[derivedname])
				if (tempRange != "")
				{
					#print derivedname,tempRange,parseMomRange(tempRange)
					derived_description[derivedname]=sprintf("%s\n%s",derived_description[derivedname],parseMomRange(tempRange))
					attr_range[derivedname]=gensub(/,* *(Range:|(Default|MaxLength|MinLength)=[^ ]*) */,"","g",parseMomRange(tempRange))
					gsub(/ *, */,",",attr_range[derivedname])
					tempRange=""
				}
			}
		}
		else if (instruct==1)
		{
			if (/<struct name=/)
			{
				isexcl=0
				split($0,array,/\"/)
				structname=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				if (comcli>0)
				{
					structname=currMim "." structname # && structname in struct_description
					struct_contents[structname]=""  #must initialise in case the same struct is repeated in several MOM fragments, happens in BSP MOM
				}
			}
			if (/<isExclusive/) isexcl=1
			if (/<description>/)
			{
				instructdescription=1
				split($0,array,/description>|<\/description/)
				struct_description[structname]=gensub(/^ */,"",1,array[2])
			}
			if (instructdescription==1)
			{
				if (!/<description/) struct_description[structname]=sprintf("%s\n%s",struct_description[structname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) instructdescription=0
			}
			if ($1 ~ tagFilterStart)
			{
				instructtag=1
				struct_description[structname]=sprintf("%s\n%s",struct_description[structname],process_tag())
			}
			if (instructtag==1)
			{
				if ($1 !~ tagFilterStart) struct_description[structname]=sprintf("%s\n%s",struct_description[structname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   instructtag=0
			}
			#if ($1 ~ tagFilterStart) struct_description[structname]=sprintf("%s\n%s",struct_description[structname],process_tag())
			if (/<deprecated *\/>/) struct_description[structname]=sprintf("%s\nDeprecated: This struct is deprecated.",struct_description[structname])
			if (/<obsolete *\/>/)   struct_description[structname]=sprintf("%s\nObsolete: This struct is obsolete.",struct_description[structname])
		}
		else if (instructmember==1)
		{
			if (isexcl==1) #ECIM MOM
			{
				isexcl=0
				struct_description[structname]=sprintf("%s\n%s",struct_description[structname],"IsExclusive: True. Only one struct member can have a value assigned at a given time.")
			}
			if (/<structMember name=/)
			{
				split($0,array,/\"/)
				structmembername=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				struct_contents[structname]=sprintf("%s,%s",struct_contents[structname],structmembername)
				if (comcli>0) struct_type[structname,structmembername]="" #must initialise because in ECIM MOM sometimes the same struct comes several times
			}
			if (/<description>/)
			{
				instructmemberdescription=1
				split($0,array,/description>|<\/description/)
				struct_description[structname,structmembername]=gensub(/^ */,"",1,array[2])
			}
			if (instructmemberdescription==1)
			{
				if (!/<description/) struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) instructmemberdescription=0
			}
			if (/<sequence/) struct_type[structname,structmembername]="sequence:"
			if (/<boolean|<long|<integer|<string|<float|<moRef|<enumRef|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/)
			{
				split($0,array,"<")
				split(array[2],array,">")
				sub(/ *\//,"",array[1])
				sub("derivedDataTypeRef","derivedRef",array[1])
				if (/name=/)
				{
					sub(/ name=\"/,":",array[1])
					sub(/\"/,"",array[1])
				}
				struct_type[structname,structmembername]=struct_type[structname,structmembername] array[1]
			}
			if (comcli>0 && /<extension +name=\"isKey\" +value=\"true\"/) struct_key[structname]=structmembername
			if (comcli>0 && /<mimName>/)
			{
				tmpMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
				last=split(struct_type[structname,structmembername],array,/[-:]/)
				sub(sprintf("%s$",array[last]),tmpMim"."array[last],struct_type[structname,structmembername])
			}
			if (/<min>.*<\/min>/) tempRange=sprintf("%sMin=%s ",tempRange,gensub(/^.*<min>|<\/min>.*$/,"","g",$0))
			if (/<max>.*<\/max>/) tempRange=sprintf("%sMax=%s ",tempRange,gensub(/^.*<max>|<\/max>.*$/,"","g",$0))
			if (/<defaultValue>.*<\/defaultValue>/)
			{
				tempDefaultValue=replace_signs(gensub(/^.*<defaultValue>|<\/defaultValue>.*$/,"","g",$0))
				gsub(/ *, */,",",tempDefaultValue) #a default value of type sequence should not have spaces between the commas, confuses momr and diffr
				tempRange=sprintf("%sDefault=%s ",tempRange,tempDefaultValue)
				attr_default[structname,structmembername]=attr_default[structname,structmembername]","gensub(/\"/,"","g",tempDefaultValue)
				sub(/^,/,"",attr_default[structname,structmembername])
			}
			if (/<extension name=\"/)
			{
				#<extension name="isNillable" value="true"/>
				#<extension name="isKey" value="true"/>
				match($0,/<extension name=\"([^"]+)\" value=\"([^"]+)\"/,array)
				struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],array[1]": "array[2])
			}
			if (/<unit>.*<\/unit>/) attr_unit[structname,structmembername]=sprintf("%s%s",((structname,structmembername) in attr_unit?attr_unit[structname,structmembername]" ":""),gensub(/^.*<unit> *| *<\/unit.*$/,"","g",$0))
			if (/<multiplicationFactor>.*<\/multiplicationFactor>/) attr_unit[structname,structmembername]=sprintf("%s%s",gensub(/^.*<multiplicationFactor> *| *<\/multiplicationFactor.*$/,"","g",$0),((structname,structmembername) in attr_unit?" "attr_unit[structname,structmembername]:""))
			if (/<\/structMember>/)
			{
				instructmember=0
				if ((structname,structmembername) in attr_unit) struct_description[structname,structmembername]=sprintf("%s\nUnit: %s",struct_description[structname,structmembername],attr_unit[structname,structmembername])
				if (tempRange != "")
				{
					struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],parseMomRange(tempRange))
					attr_range[structname,structmembername]=gensub(/,* *(Range:|(Default|MaxLength|MinLength)=[^ ]*) */,"","g",parseMomRange(tempRange))
					gsub(/ *, */,",",attr_range[structname,structmembername])
					tempRange=""
				}
			}
			if ($1 ~ tagFilterStart)
			{
				instructmembertag=1
				struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],process_tag())
			}
			if (instructmembertag==1)
			{
				if ($1 !~ tagFilterStart) struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   instructmembertag=0
			}
			if (/<deprecated *\/>/) struct_description[structname,structmembername]=sprintf("%s\nDeprecated: This struct member is deprecated.",struct_description[structname,structmembername])
			if (/<obsolete *\/>/)   struct_description[structname,structmembername]=sprintf("%s\nObsolete: This struct member is obsolete.",struct_description[structname,structmembername])
			#if ($1 ~ tagFilterStart) struct_description[structname,structmembername]=sprintf("%s\n%s",struct_description[structname,structmembername],process_tag())
		}
		else if (inclass==1)
		{
			if (/<class name=/)
			{
				split($0,array,/\"/)
				classname=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				if (comcli>0) classname=currMim "." classname # && classname in mom_moclass_list
				mom_moclass_list[classname]=classname
				tolower_mom_moclass_list[tolower(classname)]=tolower(classname)
				if (classname ~ /IS2000BSS/) cdmaMOM=1
			}
			if (/<description>/)
			{
				inclassdescription=1
				split($0,array,/description>|<\/description/)
				class_description[classname]=gensub(/^ */,"",1,array[2])
			}
			if (inclassdescription==1)
			{
				if (!/<description/) class_description[classname]=sprintf("%s\n%s",class_description[classname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inclassdescription=0
			}
			if (/<systemCreated/)
			{
				class_description[classname]=sprintf("%s\n%s",class_description[classname],"Note: Instances of this MO class are SystemCreated.")
			}
			if (/<deprecated *\/>/)
			{
				class_description[classname]=sprintf("%s\n%s",class_description[classname],"Deprecated: Instances of this MO class are deprecated.")
			}
			if ($1 ~ tagFilterStart)
			{
				inclasstag=1
				class_description[classname]=sprintf("%s\n%s",class_description[classname],process_tag())
			}
			if (inclasstag==1)
			{
				if ($1 !~ tagFilterStart) class_description[classname]=sprintf("%s\n%s",class_description[classname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inclasstag=0
			}
			#if ($1 ~ tagFilterStart) class_description[classname]=sprintf("%s\n%s",class_description[classname],process_tag())
		}
		else if (inattribute==1)
		{
			if (/<attribute name=/)
			{
				split($0,array,/\"/)
				attributename=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				if (classname":"attributename ~ /\
(MsProfile:(deviceType|numDevicesInSet|dspLoadModuleTag|numDsp))|\
((ImBasicMessage|ImVariableMessage):flexibleManagementInd)/)
				{
					inattribute=0
					continue
				}
				else if ((comcli==0)&&(attributename ~ /^Log/ && classname !~ /^Log/))
				{
					LogAttributes[classname":"attributename]=classname":"attributename
					Log_attribute_list[classname]=Log_attribute_list[classname]","attributename
				}
				else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && attributename !~ /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/))
				{
					#PmAttributes[classname":"attributename]=classname":"attributename
					Pm_attribute_list[classname]=Pm_attribute_list[classname]","attributename
				}
				else
				{
					attribute_list[classname]=attribute_list[classname]","attributename
				}
				if (comcli>0)
				{
					#must initialise because in BSP ECIM MOM the same attribute is sometimes repeated leading to the data type keep getting appended to itself
					MoAttributesType[classname":"attributename]=""
					attr_comments[classname,attributename]=""
				}
			}
			if (/<description>/)
			{
				inattributedescription=1
				split($0,array,/description>|<\/description/)
				if ((comcli==0)&&(attributename ~ /^Log/ && classname !~ /^Log/)) Log_attr_description[classname,attributename]=gensub(/^ */,"",1,array[2])
				else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && attributename !~ /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/)) Pm_attr_description[classname,attributename]=gensub(/^ */,"",1,array[2])
				else attr_description[classname,attributename]=gensub(/^ */,"",1,array[2])
			}
			if (inattributedescription==1)
			{
				if (!/<description/)
				{
					if ((comcli==0)&&(attributename ~ /^Log/ && classname !~ /^Log/)) Log_attr_description[classname,attributename]=Log_attr_description[classname,attributename]"\n"gensub(/<.*$/,"",1,$0)
					else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && attributename !~ /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/)) Pm_attr_description[classname,attributename]=Pm_attr_description[classname,attributename]"\n"gensub(/<.*$/,"",1,$0)
					else attr_description[classname,attributename]=attr_description[classname,attributename]"\n"gensub(/<.*$/,"",1,$0)
					#if (/^Counter is reset after measurement (period|interval): No/) pull_molist[classname]=classname
				}
				if (/<\/description/) inattributedescription=0
			}
			if ((comcli>0)||\
				((comcli==0)&&(attributename !~ /^(pm|Pm|Log|currentPmRegister)/ || attributename ~  /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/ || (attributename ~ /^Log/ && classname ~ /^Log/))))
			{
				if (/<noNotification/) attr_comments[classname,attributename]="noNotification,"attr_comments[classname,attributename]
				if (/<mandatory/)
				{
					attr_comments[classname,attributename]="mandatory,"attr_comments[classname,attributename]
					if (comcli==0 && attributename != sprintf("%sId",classname)) mandatory_attributes[classname]=mandatory_attributes[classname]","attributename
				}
				if (/<restricted/)
				{
					#this must be after <mandatory in case the two tags are on the same line like this:
					# </description><mandatory/><restricted/><dataType>
					attr_comments[classname,attributename]="restricted,"attr_comments[classname,attributename]
					if (attr_comments[classname,attributename] !~ "mandatory") restricted_attributes[classname]=restricted_attributes[classname]","attributename
				}
				if (/<systemCreated/) attr_comments[classname,attributename]="systemCreated,"attr_comments[classname,attributename]
				if (/<nonPersistent/) attr_comments[classname,attributename]="nonPersistent,"attr_comments[classname,attributename]
				if (/<readOnly/) attr_comments[classname,attributename]="readOnly,"attr_comments[classname,attributename]
				if (/<nonUnique/) attr_comments[classname,attributename]="nonUnique,"attr_comments[classname,attributename]
				if (/<ordered/) attr_comments[classname,attributename]="ordered,"attr_comments[classname,attributename]
				if (/<deprecated *\/>/) attr_comments[classname,attributename]="deprecated,"attr_comments[classname,attributename]  #ECIM MOM : can be <deprecated/> or <deprecated></deprecated>
				if (/<obsolete *\/>/)   attr_comments[classname,attributename]="obsolete,"attr_comments[classname,attributename]    #ECIM MOM : can be <obsolete/> or <obsolete></obsolete>
				if (/<isNillable/) attr_comments[classname,attributename]="isNillable,"attr_comments[classname,attributename]  #ECIM MOM : can be <isNillable/> or <isNillable></isNillable>
				if (/<key/) attr_comments[classname,attributename]="key,"attr_comments[classname,attributename]
				if (/<sequence/) MoAttributesType[classname":"attributename]="sequence:"
				if (/<boolean|<long|<integer|<string|<float|<moRef|<enumRef|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/)
				{
					#<dataType><sequence><moRef name="ExternalUtranCell"/>
					#in case the tag <dataType> is on the same line

					#<string />
					#<string>
					#<string></string>
					MoAttributesType[classname":"attributename]=MoAttributesType[classname":"attributename] gensub(/^<| *\/*>.*$|DataType/,"","g",gensub(/<dataType>|<sequence>/,"","g",$1))
					if (/name=/)
					{
						if (MoAttributesType[classname":"attributename] ~ /^sequence:/) MoAttributesType[classname":"attributename]=MoAttributesType[classname":"attributename] "-" gensub(/name=|\"|>|\/|<.*/,"","g",$2)
						else MoAttributesType[classname":"attributename]=MoAttributesType[classname":"attributename] ":" gensub(/name=|\"|>|\/|<.*/,"","g",$2)
					}
					MoAttributesTypeJava[classname":"attributename]=convert_attribute_types(MoAttributesType[classname":"attributename])
				}
				if (comcli>0 && /<mimName>/)
				{
					tmpMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
					last=split(MoAttributesType[classname":"attributename],array,/[-:]/)
					sub(sprintf("%s$",array[last]),tmpMim"."array[last],MoAttributesType[classname":"attributename])
				}
				if (comcli>0 && /<\/attribute>/)
				{
					if (attr_comments[classname,attributename] ~ "mandatory" && attr_comments[classname,attributename] !~ "key,") mandatory_attributes[classname]=mandatory_attributes[classname]","attributename
					if (attr_comments[classname,attributename] ~ "key,")
					{
						if (attr_comments[classname,attributename] ~ "mandatory") { sub(/mandatory/,"",attr_comments[classname,attributename]) ; sub(/,,/,",",attr_comments[classname,attributename]) }
						if (attr_comments[classname,attributename] ~ "restricted") { sub(/restricted/,"",attr_comments[classname,attributename]) ; sub(/,,/,",",attr_comments[classname,attributename]) }
					}
				}
			}
			else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && $1 ~ /<sequence|<boolean|<long|<integer|<string|<float|<moRef|<enumRef|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/))
			{
				if (/<sequence/) PmAttributesType[classname":"attributename]="sequence:"
				else PmAttributesType[classname":"attributename]=PmAttributesType[classname":"attributename] gensub(/<| *\/*>.*$|DataType/,"","g",$1)
			}
			if (/<extension name=\"/)
			{
				#<extension name="isNillable" value="true"/>
				#<extension name="isKey" value="true"/>
				match($0,/<extension name=\"([^"]+)\" value=\"([^"]+)\"/,array)
				attr_description[classname,attributename]=sprintf("%s\n%s",attr_description[classname,attributename],array[1]": "array[2])
			}
			if (/<min>.*<\/min>/) tempRange=sprintf("%sMin=%s ",tempRange,gensub(/^.*<min>|<\/min>.*$/,"","g",$0))
			if (/<max>.*<\/max>/) tempRange=sprintf("%sMax=%s ",tempRange,gensub(/^.*<max>|<\/max>.*$/,"","g",$0))
			if (/<defaultValue>.*<\/defaultValue>/)
			{
				tempDefaultValue=replace_signs(gensub(/^.*<defaultValue>|<\/defaultValue>.*$/,"","g",$0))
				gsub(/ *, */,",",tempDefaultValue) #a default value of type sequence should not have spaces between the commas, confuses momr and diffr
				tempRange=sprintf("%sDefault=%s ",tempRange,tempDefaultValue)
				attr_default[classname,attributename]=attr_default[classname,attributename]","gensub(/\"/,"","g",tempDefaultValue)
				sub(/^,/,"",attr_default[classname,attributename])
			}
			if (/<minLength>.*<\/minLength>/)
			{
				tempRange=sprintf("%sMinLength=%s ",tempRange,gensub(/^.*<minLength>|<\/minLength>.*$/,"","g",$0))
			}
			if (/<maxLength>.*<\/maxLength>/)
			{
				tempRange=sprintf("%sMaxLength=%s ",tempRange,gensub(/^.*<maxLength>|<\/maxLength>.*$/,"","g",$0))
				if (attributename ~ /^pm/) pdf_counter_table[attributename]=gensub(/^.*<maxLength>|<\/maxLength>.*$/,"","g",$0)+0
				attr_length[classname,attributename]=gensub(/^.*<maxLength>|<\/maxLength>.*$/,"","g",$0)
			}
			if (/<unit>.*<\/unit>/) attr_unit[classname,attributename]=sprintf("%s%s",((classname,attributename) in attr_unit?attr_unit[classname,attributename]" ":""),gensub(/^.*<unit> *| *<\/unit.*$/,"","g",$0))
			if (/<multiplicationFactor>.*<\/multiplicationFactor>/) attr_unit[classname,attributename]=sprintf("%s%s",gensub(/^.*<multiplicationFactor> *| *<\/multiplicationFactor.*$/,"","g",$0),((classname,attributename) in attr_unit?" "attr_unit[classname,attributename]:""))
			if (/<\/attribute>/)
			{
				inattribute=0
				if ((classname,attributename) in attr_unit) tempUnit="\nUnit: "attr_unit[classname,attributename] ; else tempUnit=""
				if (classname":"attributename in MoAttributesType && MoAttributesType[classname":"attributename]!="") attr_description[classname,attributename]=sprintf("%s%s\n%s",attr_description[classname,attributename],tempUnit,parseMomRange(tempRange))
				else if (comcli==0) Pm_attr_description[classname,attributename]=sprintf("%s%s\n%s",Pm_attr_description[classname,attributename],tempUnit,parseMomRange(tempRange))
				attr_range[classname,attributename]=gensub(/,* *(Range:|(Default|MaxLength|MinLength)=[^ ]*) */,"","g",parseMomRange(tempRange))
				gsub(/ *, */,",",attr_range[classname,attributename])
				tempRange=""
			}
			if ($1 ~ tagFilterStart)
			{
				inattributetag=1
				if ((comcli==0)&&(attributename ~ /^Log/ && classname !~ /^Log/)) Log_attr_description[classname,attributename]=sprintf("%s\n%s",Log_attr_description[classname,attributename],process_tag())
				else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && attributename !~ /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/)) Pm_attr_description[classname,attributename]=sprintf("%s\n%s",Pm_attr_description[classname,attributename],process_tag())
				else attr_description[classname,attributename]=sprintf("%s\n%s",attr_description[classname,attributename],process_tag())
			}
			if (inattributetag==1)
			{
				if ($1 !~ tagFilterStart)
				{
					if ((comcli==0)&&(attributename ~ /^Log/ && classname !~ /^Log/)) Log_attr_description[classname,attributename]=sprintf("%s\n%s",Log_attr_description[classname,attributename],gensub(/<.*$/,"",1,$0))
					else if ((comcli==0)&&(attributename ~ /^(pm|Pm|currentPmRegister)/ && attributename !~ /^(pmMode|pmMonitoring|PmServiceId|PmEventServiceId|PmUeMeasControlId|PmInitiatedUeMeasurementsId|[Pp][Mm]Id|PmchMchId|PmUlInterferenceReportId|PmFlexCounterFilterId|PmCapacityId|PmIndicationId|PmKpiId)$/)) Pm_attr_description[classname,attributename]=sprintf("%s\n%s",Pm_attr_description[classname,attributename],gensub(/<.*$/,"",1,$0))
					else attr_description[classname,attributename]=sprintf("%s\n%s",attr_description[classname,attributename],gensub(/<.*$/,"",1,$0))
				}
				if ($0 ~  tagFilterEnd)   inattributetag=0
			}
			#if ($1 ~ tagFilterStart) attr_description[classname,attributename]=sprintf("%s\n%s",attr_description[classname,attributename],process_tag())
		}
		else if (inaction==1 && inparameter==0)
		{
			if (/<action name=/)
			{
				i=0
				split($0,array,/\"/)
				actionname=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				action_list[classname]=action_list[classname]","actionname
			}
			if (/<deprecated *\/>/) actn_deprecated[classname,actionname]=1  #ECIM MOM
			if (/<description>/)
			{
				inactiondescription=1
				split($0,array,/description>|<\/description/)
				actn_description[classname,actionname]=gensub(/^ */,"",1,array[2])
			}
			if (inactiondescription==1)
			{
				if (!/<description/) actn_description[classname,actionname]=sprintf("%s\n%s",actn_description[classname,actionname],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inactiondescription=0
			}
			if (/<returnType/) inreturntype=1
			if (inreturntype==1)
			{
				if (/<sequence/) returnType="sequence:"
				if (/<boolean|<long|<integer|<string|<float|<moRef|<enumRef|<void|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/)
				{
					returnType=returnType gensub(/<| *\/*>.*$|DataType/,"","g",$1)
					if (/name=/)
					{
						if (returnType ~ /^sequence:/) returnType=returnType "-" gensub(/name=|\"|>|\/|<.*/,"","g",$2)
						else returnType=returnType ":" gensub(/name=|\"|>|\/|<.*/,"","g",$2)
					}
				}
				if (comcli>0 && /<mimName>/)
				{
					tmpMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
					last=split(returnType,array,/[-:]/)
					sub(sprintf("%s$",array[last]),tmpMim"."array[last],returnType)
				}
			}
			if (/<\/returnType/) inreturntype=0
			if (/<raisesException name=/) actnExceptions=sprintf("%s%s, ",actnExceptions,gensub(/^.*raisesException name=.|\"[^\"]*$/,"","g",$0))
			if (/<\/action>/)
			{
				for (j=0;j<=i;j++)
					if (j in param && param[j] != "") paramlist=paramlist":"param[j]
				for (j=0;j<=i;j++)
					if (j in type && type[j] != "") paramlist=paramlist":"type[j]
				action[classname,actionname]= i paramlist
				if (returnType != "")
				{
					actn_description[classname,actionname]=sprintf("%s\nReturnType: %s",actn_description[classname,actionname],returnType)
					actn_result[classname,actionname]=returnType
				}
				for (j=1;j<=i;j++)
				{
					if (j in param_range && param_range[j] != "") param_range[j]=sprintf("[%s]. ",gensub(/ +$/,"","g",param_range[j]))
					actn_description[classname,actionname]=sprintf("%s\nParameter %s: %s (%s). %s%s",actn_description[classname,actionname],j,param[j],type[j],param_range[j],param_desc[j])
				}
				i=0
				if (actnExceptions != "")
				{
					actn_description[classname,actionname]=sprintf("%s\nRaises exceptions: %s",actn_description[classname,actionname],gensub(/, $/,"",1,actnExceptions))
				}
				delete param_desc ; delete param ; delete type ; delete param_range
				paramlist=returnType=tempRange=actnExceptions=""
				inaction=0
			}
			if ($1 ~ tagFilterStart)
			{
				inactiontag=1
				actn_description[classname,actionname]=sprintf("%s\n%s",actn_description[classname,actionname],process_tag())
			}
			if (inactiontag==1)
			{
				if ($1 !~ tagFilterStart) actn_description[classname,actionname]=sprintf("%s\n%s",actn_description[classname,actionname],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inactiontag=0
			}
			#if ($1 ~ tagFilterStart) actn_description[classname,actionname]=sprintf("%s\n%s",actn_description[classname,actionname],process_tag())
		}
		else if (inparameter==1)
		{
			if (/<parameter name=/)
			{
				split($0,array,/\"/)
				parametername=gensub(/^ *| *$/,"","g",array[2])  #in case there are some extra spaces in the name
				param[++i]=parametername
			}
			if (/<description>/)
			{
				inparameterdescription=1
				split($0,array,/description>|<\/description/)
				param_desc[i]=gensub(/^ */,"",1,array[2])
			}
			if (inparameterdescription==1)
			{
				if (!/<description/) param_desc[i]=sprintf("%s\n%s",param_desc[i],gensub(/<.*$/,"",1,$0))
				if (/<\/description/) inparameterdescription=0
			}
			if (/<sequence/) type[i]="sequence-"
			if (/<boolean|<long|<integer|<string|<float|<moRef|<enumRef|<structRef|<u?int(8|16|32|64)|<derivedDataTypeRef|<decimal64/)
			{
				type[i]=type[i] gensub(/<| *\/*>.*$|DataType/,"","g",$1)
				if (/name=/)
				{
					type[i]=type[i] "-" gensub(/name=|\"|>|\/|<.*/,"","g",$2)
				}
			}
			if (comcli>0 && /<mimName>/)
			{
				tmpMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
				last=split(type[i],array,/[-:]/)
				sub(sprintf("%s$",array[last]),tmpMim"."array[last],type[i])
			}
			if (/<min>.*<\/min>/) param_range[i]=sprintf("%sMin=%s ",param_range[i],gensub(/^.*<min>|<\/min>.*$/,"","g",$0))
			if (/<max>.*<\/max>/) param_range[i]=sprintf("%sMax=%s ",param_range[i],gensub(/^.*<max>|<\/max>.*$/,"","g",$0))
			if (/<\/parameter>/) inparameter=0
			if ($1 ~ tagFilterStart)
			{
				inparametertag=1
				param_desc[i]=sprintf("%s\n%s",param_desc[i],process_tag())
			}
			if (inparametertag==1)
			{
				if ($1 !~ tagFilterStart) param_desc[i]=sprintf("%s\n%s",param_desc[i],gensub(/<.*$/,"",1,$0))
				if ($0 ~  tagFilterEnd)   inparametertag=0
			}
			#if ($1 ~ tagFilterStart) param_desc[i]=sprintf("%s\n%s",param_desc[i],process_tag())
		}

		else if (incontainment==1)
		{
			#<containment>
			#<parent>
			#    <hasClass name="SysM">
			#        <mimName>ComSysM</mimName>
			#    </hasClass>
			#</parent>
			#<child>
			#    <hasClass name="Schema">
			#        <mimName>ComSysM</mimName>
			#    </hasClass>
			#    <cardinality>
			#        <min>2</min>
			#    </cardinality>
			#</child>
			#</containment>
			if (/<parent>/) inparent=1
			if (/<\/parent>/) inparent=0
			if (/<child>/) inchild=1
			if (/<\/child>/) inchild=0
			if (/<cardinality>/) incardinality=1
			if (/<\/cardinality>/) incardinality=0
			if (/<hasClass name=\"/)
			{
				split($0,array,/\"/)
				#if (comcli>0) array[2]=currentMim SUBSEP array[2]
				if (inparent==1) parentmo=array[2]
				else if (inchild==1) childmo=array[2]
			}
			if (/<min>/ && incardinality==1) min=gensub(/^.*<min>|<\/min>.*$/,"","g",$0)
			if (/<max>/ && incardinality==1) max=gensub(/^.*<max>|<\/max>.*$/,"","g",$0)
			if (comcli>0 && /<mimName>/)
			{
				theMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
				if (inparent==1) parentmo=theMim"."parentmo
				else if (inchild==1) childmo=theMim"."childmo
			}
			if (/<\/containment>/)
			{
				#workaround for RBS MOM M and N which has three faulty relations:
				#relationship Jvm_to_LoadModule
				#relationship Jvm_to_ReliableProgramUniter
				#relationship SwAllocation_to_Jvm

				if (!((parentmo=="ManagedObject") || (childmo=="ManagedObject") || (parentmo==childmo) ||\
				      (parentmo=="Jvm" && childmo~/^(LoadModule|ReliableProgramUniter)$/) || \
				      (parentmo=="SwAllocation" && childmo=="Jvm")))
				{
					childList[parentmo]=childList[parentmo]";"childmo
					parentList[childmo]=parentList[childmo]";"parentmo
					if (min==max) cardinality[parentmo,childmo]=min
					else cardinality[parentmo,childmo]=min"-"max
				}
				if (deprecated_relationship==1) deprecatedRelationship[parentmo,childmo]=1
				incontainment=0
				incardinality=0
				min=max=parentmo=childmo=""
			}
		}
		else if (inbidir==1)
		{
			#<relationship name="Ranap_masterSccpApLocalRef">
			#  <uniDirectionalAssociation>
			#    <hasClass name="Ranap"/>
			#    <associationEnd name="masterSccpApLocalRef">
			#      <hasClass name="SccpApLocal"/>
			#      <cardinality>
			#        <min>0</min>
			#        <max>1</max>
			#      </cardinality>
			#    </associationEnd>
			#  </uniDirectionalAssociation>
			#</relationship>

			#<relationship name="UtranCell_to_IubLink">
			#        <biDirectionalAssociation>
			#                <associationEnd name="iubLinkRef">
			#                        <hasClass name="IubLink"/>
			#                        <cardinality>
			#                                <min>1</min>
			#                                <max>1</max>
			#                        </cardinality>
			#                </associationEnd>
			#                <associationEnd name="reservedBy">
			#                        <hasClass name="UtranCell"/>
			#                        <cardinality>
			#                                <min>0</min>
			#                                <max>12</max>
			#                        </cardinality>
			#                </associationEnd>
			#        </biDirectionalAssociation>
			#</relationship>
			if (/<cardinality>/) { incardinality=1 ; min=0 ; max="" }
			if (/<\/cardinality>/)
			{
				incardinality=0
				relcard[++relcardcount]=parseminmax(min,max)
				min=0 ; max=""
			}
			if (/<min>/ && incardinality==1) min=gensub(/^.*<min>|<\/min>.*$/,"","g",$0)
			if (/<max>/ && incardinality==1) max=gensub(/^.*<max>|<\/max>.*$/,"","g",$0)
			if (comcli>0 && /<mimName>/)
			{
				theMim=gensub(/^.*<mimName> *| *<\/mimName>.*$/,"","g",$0)
				#if (inparent==1) parentmo=theMim"."parentmo
				#else if (inchild==1) childmo=theMim"."childmo
			}
			if (/<associationEnd name=\"/)
			{
				split($0,array,/\"/)
				relattr[++relattrcount]=array[2]
			}
			if (/<hasClass name=\"/)
			{
				split($0,array,/\"/)
				if (comcli>0) array[2]=theMim "." array[2]
				relmo[++relmocount]=array[2]
			}
			if (/<\/biDirectionalAssociation>/)
			{
				attr_refs[relmo[2],relattr[1]]=attr_refs[relmo[2],relattr[1]]","relmo[1] relcard[1]
				attr_refs[relmo[1],relattr[2]]=attr_refs[relmo[1],relattr[2]]","relmo[2] relcard[2]
				sub(/^,/,"",attr_refs[relmo[2],relattr[1]])
				sub(/^,/,"",attr_refs[relmo[1],relattr[2]])
			}
			if (/<\/uniDirectionalAssociation>/)
			{
				attr_refs[relmo[1],relattr[1]]=attr_refs[relmo[1],relattr[1]]","relmo[2] relcard[1]
				sub(/^,/,"",attr_refs[relmo[1],relattr[1]])
			}
			if (/<\/(uni|bi)DirectionalAssociation>/)
			{
				inbidir=0
				incardinality=0
				min=max=""
				relmocount=relattrcount=relcardcount=0
				delete relmo
				delete relattr
				delete relcard
			}
		}
	}
	close(readmom_command)
	if (check=="check") return
	customPrint("Done.")

	###############
	#Postprocessing
	###############
	#make_restricted_attributes()
	apply_mom_filter(momHide)

	remake_com_refs()

	sort_out_double_parents()
	remake_com_childparent()
	sort_out_double_parents()
	sort_childparentLists()

	postprocessing(class_description)
	postprocessing(attr_description)
	postprocessing(actn_description)
	postprocessing(enum_description)
	postprocessing(derived_description)
	postprocessing(struct_description)
	postprocessing(Pm_attr_description)
	postprocessing(Log_attr_description)
	for (attr in attr_comments)  sub(/,$/,"",attr_comments[attr])
	for (attr in Pm_attr_comments)  sub(/,$/,"",Pm_attr_comments[attr])
	for (struct in struct_contents) sub(/^,/,"",struct_contents[struct])
	for (enm in enum_contents) sub(/^ *, */,"",enum_contents[enm])
	for (moclass in attribute_list) sub(/^,/,"",attribute_list[moclass])
	for (moclass in Pm_attribute_list) sub(/^,/,"",Pm_attribute_list[moclass])
	for (moclass in Log_attribute_list) sub(/^,/,"",Log_attribute_list[moclass])
	for (moclass in action_list) sub(/^,/,"",action_list[moclass])
	for (moclass in mandatory_attributes) sub(/^,/,"",mandatory_attributes[moclass])
	for (moclass in restricted_attributes) sub(/^,/,"",restricted_attributes[moclass])

	###############
	#Sort attribute list and pm attribute list
	###############
	sortTable(attribute_list,sorted_attribute_list)
	sortTable(action_list,sorted_action_list)
	sortTable(Pm_attribute_list,sorted_Pm_attribute_list)
	sortTable(Log_attribute_list,sorted_Log_attribute_list)
	sortTable(struct_contents,sorted_struct_contents)

	###############
	#On Cello 2 and 3, Get Attribute does not work on spu when using null session
	###############
	if (CelloVersion ~ /^(2|3)/) sorted_attribute_list["Spu"]="SpuId,userLabel"

	remove_invalid_moclasses(Pm_attribute_list)
	remove_invalid_moclasses(sorted_Pm_attribute_list)
	add_attr_tags()
	make_pullcounter_table()
	make_com_momversion()
	make_struct_with_moref()

	build_mom_cache_file(mom_file_cache)
	momfinish()

}
function make_restricted_attributes(   i,a,classname,attributename)
{
	#This function is not used yet as it causes the restricted attributes to be in alphabetical order, would be a non-backward compatible change of the cr command
	for (i in attr_comments)
	{
		if (attr_comments[i] ~ "restricted" && attr_comments[i] !~ "mandatory")
		{
			split(i,a,SUBSEP)
			classname=a[1]
			attributename=a[2]
			restricted_attributes[classname]=restricted_attributes[classname]","attributename
		}
	}
}
function make_struct_with_moref(    i,array)
{
	#make a list of all structs that contain a moRef. Example: PmUeMeasIntraFreq and UtranFreqToQciProfileRelation
	#also include structs that contain a sequence of moRef. Example: DistributionInfo
	for (i in struct_type)
	{
		if (struct_type[i] ~ /^(sequence:)?moRef/)
		{
			split(i,array,SUBSEP)
			struct_with_moref[array[1]]=struct_with_moref[array[1]]","array[2]
			sub(/^,/,"",struct_with_moref[array[1]])
		}
	}
	#struct_with_moref[DistributionInfo] = eUtranFreqRefList
	#struct_with_moref[UtranFreqToQciProfileRelation] = qciProfileRef
	#struct_with_moref[ReportConfigParamsQciOffset] = qciProfileRef
	#struct_with_moref[Cdma2000FreqRelQciB2ThrOffsets] = qciProfileRef
	#struct_with_moref[GeranFreqRelQciB2ThrOffsets] = qciProfileRef
	#struct_with_moref[PmUeMeasIntraFreq] = reportConfigEUtraIntraFreqPmRef,eutranFrequencyRef
	#struct_with_moref[EUtranFreqToQciProfileRelation] = qciProfileRef
}
function parseminmax(min,max)
{
	if (min=="") return ""
	if (min==max) return "["min"]"
	return "["min"-"max"]"
}
function convert_ecim_to_com(moclass,   part,theMim)
{
	if (comcli==0) return moclass
	if (moclass in mom_moclass_list && mom_moclass_list[moclass]!="") return moclass
	split(moclass,part,/\./)
	theMim=part[1]
	if (theMim in mimNames && mimNames[theMim]!=""){}
	else if (theMim in ecimMomName && ecimMomName[theMim]!="") theMim=ecimMomName[theMim]
	moclass=theMim"."part[2]
	return moclass
}
function fix_containment_table(table, i,j,array,last,part,theMim,newIndex)
{
	if (comcli==0) return
	#first fix the values of the table, replacing all the references to ECIM MOM with references to COM MOM
	for (i in table)
	{
		last=split(table[i],array,";")
		table[i]=""
		for (j=1;j<=last;j++)
		{
			if (array[j]=="") continue
			table[i]=table[i]";"convert_ecim_to_com(array[j])
		}
		gsub(/;;+/,";",table[i])
	}
	#then copy all entries referring to ECIM MOM to corresponding entries referring to COM MOM
	for (i in table)
	{
		newIndex=convert_ecim_to_com(i)
		if (newIndex!=i) table[newIndex]=table[newIndex]";"table[i]
		gsub(/;;+/,";",table[i])
	}
}
function find_mim_prefix(what,typeref,theMim,    i)
{
	if (what=="derived") return search_com_table(derived_type,typeref,theMim)
	else if (what=="enum") return search_com_table(enum_contents,typeref,theMim)
	else if (what=="struct") return search_com_table(struct_contents,typeref,theMim)
	else if (what=="mo") return search_com_table(mom_moclass_list,typeref,theMim)
	return typeref
}
function search_com_table(table,typeref,theMim)
{
	if (theMim!="" && (theMim"."typeref) in table && table[theMim"."typeref]!="")
	{
		typeref=theMim"."typeref
		return typeref
	}
	for (i in table)
	{
		if (i ~ sprintf(".%s$",typeref) && table[i] != "")
		{
			typeref=i
			break
		}
	}
	return typeref
}
function convert_datatype_ecim_to_com(what,typeref,currMim,   part,theMim,last)
{
	#converts for instance ECIM_Top.DateTime to ComTop.DateTime
	if (comcli==0) return typeref
	if (what=="derived" && typeref in derived_type && derived_type[typeref]!="") return typeref
	if (what=="enum" && typeref in enum_contents && enum_contents[typeref]!="") return typeref
	if (what=="struct" && typeref in struct_contents && struct_contents[typeref]!="") return typeref
	if (what=="mo" && typeref in mom_moclass_list && mom_moclass_list[typeref]!="") return typeref
	last=split(typeref,part,/\./)
	if (last==1)
	{
		#the mim prefix is missing, try to find it
		typeref=find_mim_prefix(what,typeref,currMim)
		return typeref
	}
	theMim=part[1]
	if (theMim in mimNames && mimNames[theMim]!=""){}
	else if (theMim in ecimMomName && ecimMomName[theMim]!="") theMim=ecimMomName[theMim]
	typeref=theMim"."part[2]
	return typeref
}
function remake_com_refs(  i,j,array,last,part,theMim)
{
	if (comcli==0) return
	#all the data types enumRef, moRef, derivedDataRef, structRef should point to the COM MOM name instead of ECIM MOM name

	#three tables to fix:
	#struct_type[ECIM_PM.MeasurementReaderNameValue,lastUpdated]=derivedRef:ECIM_Top.DateTime$   -> replace ECIM_Top with ComTop
	#struct_type[Licensing.GracePeriod,gracePeriodState]=enumRef:LmGracePeriodState$   -> replace LmGracePeriodState with Licensing.LmGracePeriodState

	#MoAttributesType[ECIM_PM.PmThresholdMonitoring:thresholdSeverity]=enumRef:ECIM_FM.SeverityLevel$   -> replace ECIM_FM with ComFm
	#MoAttributesType[Licensing.CapacityFeature:licensedCapacity]=structRef:CapacityData$   -> replace CapacityData with Licensing.CapacityData
	#MoAttributesType[LogM.Log:severityFilter]=sequence:enumRef-LogM.LogSeverity$

	#action[ComSysM.Schema,export]=2:uri:password:string:derivedRef-ECIM_SysM.EcimPasswordString$   -> replace ECIM_SysM with ComSysM

	#Note: moRef:ManagedObject is ok:
	#struct_type[ECIM_PM.MeasurementReaderNameValue,moClassInstance]=moRef:ManagedObject$

	for (i in MoAttributesType)
	{
		if (MoAttributesType[i] !~ /Ref[-:]/) continue
		match(MoAttributesType[i],/^(.*)(Ref[-:])(.*)$/,array)
		#print array[1]" "array[2]" "array[3]
		#if (MoAttributesType[i] ~ "Ref" && MoAttributesType[i] !~ /\./ && MoAttributesType[i] !~ /ManagedObject/) print i,MoAttributesType[i]
		theMim=gensub(/\..*$/,"",1,i)
		MoAttributesType[i]=array[1] array[2] convert_datatype_ecim_to_com(gensub(/^sequence:/,"",1,array[1]),array[3],theMim)
	}
	for (i in struct_type)
	{
		if (struct_type[i] !~ /Ref[-:]/) continue
		match(struct_type[i],/^(.*)(Ref[-:])(.*)$/,array)
		#print array[1]" "array[2]" "array[3]
		#if (struct_type[i] ~ "Ref" && MoAttributesType[i] !~ /\./ && MoAttributesType[i] !~ /ManagedObject/) print i,MoAttributesType[i]
		theMim=gensub(/\..*$/,"",1,i)
		struct_type[i]=array[1] array[2] convert_datatype_ecim_to_com(gensub(/^sequence:/,"",1,array[1]),array[3],theMim)
	}
	for (i in actn_result)
	{
		if (actn_result[i] !~ /Ref[-:]/) continue
		theMim=gensub(/\..*$/,"",1,i)
		match(actn_result[i],/^(.*)(Ref[-:])(.*)$/,array)
		#print array[1]" "array[2]" "array[3]
		actn_result[i]=array[1] array[2] convert_datatype_ecim_to_com(gensub(/^sequence:/,"",1,array[1]),array[3],theMim)
	}

	for (i in action)
	{
		if (action[i] !~ /Ref[-:]/) continue
		theMim=gensub(/\..*$/,"",1,i)
		last=split(action[i],part,":")
		action[i]=part[1]
		for (j=2;j<=last;j++)
		{
			if (part[j] !~ /Ref[-:]/) action[i]=action[i]":"part[j]
			else
			{
				match(part[j],/^(.*)(Ref[-:])(.*)$/,array)
				action[i]=action[i]":"array[1] array[2] convert_datatype_ecim_to_com(gensub(/^sequence./,"",1,array[1]),array[3],theMim)
			}
		}
	}
}


function remake_com_childparent(   i,j,array,last,part,theMim)
{
	if (comcli==0) return
	#In the containment relations sometimes the ECIM MOM name has been used instead of COM MOM name

	#Example:
	#this line:
	#childList[ECIM_Top.SystemFunctions]=CmwPm.Pm;SwIM.SwInventory;ECIM_SwM.SwM$
	#must be added to this entry:
	#childList[ComTop.SystemFunctions]=ComSysM.SysM;ComFm.Fm;ComSecM.SecM;ComFileM.FileM$

	#This line:
	#parentList[CmwPm.Pm]=;ECIM_Top.SystemFunctions$
	#To be replaced by:
	#parentList[CmwPm.Pm]=;ComTop.SystemFunctions$

	#This line:
	#cardinality[ECIM_Top.SystemFunctions,SwIM.SwInventory]=1$
	#To be replaced by:
	#cardinality[ComTop.SystemFunctions,CmwPm.Pm]=1$

	if (mosdebug==2)
	{
		print "Before processing"
		tablePrint(childList,"childList")
		tablePrint(parentList,"parentList")
		tablePrint(cardinality,"cardinality")
	}

	fix_containment_table(childList)
	fix_containment_table(parentList)
	for (i in cardinality)
	{
		split(i,array,SUBSEP)
		cardinality[convert_ecim_to_com(array[1]),convert_ecim_to_com(array[2])]=cardinality[array[1],array[2]]
	}
	if (mosdebug==2)
	{
		print "\n\nAfter processing"
		tablePrint(childList,"childList")
		tablePrint(parentList,"parentList")
		tablePrint(cardinality,"cardinality")
	}

}

function remove_element(table,moclass,element,separator,    j,arrayz,last)
{
	last=split(table[moclass],arrayz,separator)
	delete table[moclass]
	for (j=1;j<=last;j++) { if (arrayz[j] != element) table[moclass]=table[moclass] separator arrayz[j] }
	if (moclass in table) sub(/^./,"",table[moclass])
}
function apply_mom_filter(momHide,   i,j,k,z,array,word,keepenum,keepstruct)
{
	j=0
	for (i in momHide) { j++ ; if (j > 0) break }
	if (j == 0) return

	#momHide["enum",enumname]=1
	#momHide["struct",structname]=1
	#momHide["class",classname]=1
	#momHide["attribute",classname,attributename]=1
	#momHide["action",classname,actionname]=1
	#momHide["enummember",enumname,enummembername]
	#momHide["structmember",structname,structmembername]

	for (i in enum_contents)
	{
		#enum_contents[SupportedAdminStates]=0:LOCKED, 1:UNLOCKED
		split(enum_contents[i],array,",")
		for (j in array)
		{
			if (array[j]=="") continue
			split(array[j],word,":")
			if (!(("enummember",i,word[2]) in momHide)) keepenum[i]=1
		}
	}
	for (i in struct_contents)
	{
		#struct_contents[AdminProductData]=productNumber,productRevision,productName,productInfo,productionDate
		split(struct_contents[i],array,",")
		for (j in array)
		{
			if (array[j]=="") continue
			if (!(("structmember",i,array[j]) in momHide)) keepstruct[i]=1
		}
	}
	for (i in enum_contents)   { if (!(i in keepenum))   momHide["enum",i]  =1 }
	for (i in struct_contents) { if (!(i in keepstruct)) momHide["struct",i]=1 }

	for (i in momHide)
	{
		split(i,array,SUBSEP)
		if (array[1]=="enum")
		{
			#enum_contents[enum]=value:translation,value:translation
			#enum_description[enum]=description
			delete enum_contents[array[2]]
			delete enum_description[array[2]]
		}
		else if (array[1]=="struct")
		{
			#struct_contents[struct]=member,member,member
			#struct_description[struct]=description
			delete struct_contents[array[2]]
			delete struct_description[array[2]]
		}
		else if (array[1]=="class")
		{
			#action_list[moclass]=action1,action2,action3
			#attribute_list[moclass]=attribute,attribute,attribute
			#class_description[moclass]=description
			#mandatory_attributes[moclass]=attr1,attr2
			#restricted_attributes[moclass]=attr1,attr2
			#mom_moclass_list[moclass]=moclass
			#tolower_mom_moclass_list[tolower(moclass)]=tolower(moclass)
			#Pm_attribute_list[moclass]=pmattribute,pmattribute
			#sorted_action_list[moclass]=action1,action2,action3
			#sorted_attribute_list[moclass]=attr,attr,attr
			#sorted_Pm_attribute_list[moclass]=pmattribute,pmattribute
			delete action_list[array[2]]
			delete attribute_list[array[2]]
			delete class_description[array[2]]
			delete mandatory_attributes[array[2]]
			delete restricted_attributes[array[2]]
			delete mom_moclass_list[array[2]]
			delete tolower_mom_moclass_list[tolower(array[2])]
			delete Pm_attribute_list[array[2]]
			delete childList[array[2]]
			delete parentList[array[2]]
			for (j in childList)  { if (childList[j] ~ array[2])  remove_element(childList,j,array[2],";")  }
			for (j in parentList) { if (parentList[j] ~ array[2]) remove_element(parentList,j,array[2],";") }
		}
	}
	for (i in enum)
	{
		#enum[enum,translation]=value
		#enum[enum,value]=translation
		split(i,array,SUBSEP)
		if (("enum",array[1]) in momHide) delete enum[i]
	}
	for (i in struct_type)
	{
		#struct_type[struct,member]=type
		split(i,array,SUBSEP)
		if (("struct",array[1]) in momHide) delete struct_type[i]
	}
	for (i in action)
	{
		#action[moclass,action]=numberofparams:param1:param2:type1:type2
		#actn_description[moclass,action]=description
		#actn_result[moclass,action]=returntype
		split(i,array,SUBSEP)
		if (("action",i) in momHide || ("class",array[1]) in momHide)
		{
			delete action[i]
			delete actn_description[i]
			delete actn_result[i]
			delete actn_deprecated[i]
			remove_element(action_list,array[1],array[2],",")
		}
	}
	for (i in attr_description)
	{
		#attr_description[moclass,attribute]=description
		#attr_comments[moclass,attribute]=flags
		#MoAttributesType[moclass":"attribute]=type
		#MoAttributesTypeJava[moclass":"attribute]=javatype
		split(i,array,SUBSEP)
		if (("attribute",i) in momHide || ("class",array[1]) in momHide)
		{
			delete attr_description[i]
			delete attr_comments[i]
			delete MoAttributesType[array[1]":"array[2]]
			delete MoAttributesTypeJava[array[1]":"array[2]]
			remove_element(attribute_list,array[1],array[2],",")
			remove_element(mandatory_attributes,array[1],array[2],",")
			remove_element(restricted_attributes,array[1],array[2],",")
		}
	}
	for (i in Pm_attr_description)
	{
		#Pm_attr_description[moclass,pmattribute]=description
		#Pm_attr_comments[moclass,pmattribute]=flags
		#PmAttributes[moclass":"pmattribute]=moclass":"pmattribute
		#PmAttributesType[moclass":"pmattribute]=type
		split(i,array,SUBSEP)
		if (("attribute",i) in momHide || ("class",array[1]) in momHide)
		{
			delete Pm_attr_description[i]
			delete Pm_attr_comments[i]
			#delete PmAttributes[array[1]":"array[2]]
			delete PmAttributesType[array[1]":"array[2]]
			hidden_attributes[array[1],array[2]]=1
			remove_element(Pm_attribute_list,array[1],array[2],",")
		}
	}
	#attr_default
	#attr_length
	#attr_range
	#pdf_counter_table[counter]=nrOfelements
	#pull_molist[moclass]=moclass
	#childList
	#sorted_childList
	#sorted_pull_attrlist[moclass]=attr1,attr2
	#eget_attribute_list
	#sorted_eget_attribute_list
	#sorted_mom_list
	#sorted_parentList
	#sorted_pull_attrlist
	#cardinality
	#pull_attrlist
	#pull_molist
}

function build_mom_cache_file(mom_file_cache)
{
	customPrint("Caching MOM to: "mom_file_cache" ","","","noLF")
	#first check if a mom cache file "appeared" whilst we parsed the MOM, could be due to mobatch
	#second check if we can write to the mom cache file
	#third write the mom cache to tempbolog and the move it to mom_file_cache - to prevent corruption
	# if multiple sessions of moshell (e.g. through mobatch) try to write a cache file at the same time.

	if (fileOps(sprintf("test -s %s",mom_file_cache)) == 0) { customPrint(" "mom_file_cache" already exists.") ; return }
	if (!(fileOps("touch "mom_file_cache)==0 && fileOps("test -f "mom_file_cache)==0)) { customPrint("!!! Unable to write to "mom_file_cache" !!!") ; return }

	empty_file(tempbolog);
	print "MOSHELL_MOM_CACHE_VERSION " supported_cache_version      >> tempbolog;
	print "CelloVersion: "             CelloVersion                 >> tempbolog;
	print "mom_version: "              mom_version                  >> tempbolog;
	print "cdmaMOM: "                  cdmaMOM                      >> tempbolog;
	print "momdocnumber: "             momdocnumber                 >> tempbolog;
	print "momdocrevision: "           momdocrevision               >> tempbolog;
	print "mimCounter: "               mimCounter                   >> tempbolog;
	print "ComVersion: "               ComVersion                   >> tempbolog;
	print "MeRelease: "                MeRelease                    >> tempbolog;
	dump_array(attr_refs                ,"attr_refs"                 ,tempbolog);
	dump_array(class_description        ,"class_description"         ,tempbolog);
	dump_array(attr_description         ,"attr_description"          ,tempbolog);
	dump_array(attr_default             ,"attr_default"              ,tempbolog);
	dump_array(attr_range               ,"attr_range"                ,tempbolog);
	dump_array(attr_unit                ,"attr_unit"                 ,tempbolog);
	dump_array(attr_length              ,"attr_length"               ,tempbolog);
	dump_array(actn_description         ,"actn_description"          ,tempbolog);
	dump_array(actn_deprecated          ,"actn_deprecated"           ,tempbolog);
	dump_array(struct_with_moref        ,"struct_with_moref"         ,tempbolog);
	dump_array(actn_result              ,"actn_result"               ,tempbolog);
	dump_array(enum_description         ,"enum_description"          ,tempbolog);
	dump_array(struct_description       ,"struct_description"        ,tempbolog);
	dump_array(Pm_attr_description      ,"Pm_attr_description"       ,tempbolog);
	printf ".";
	dump_array(Log_attr_description     ,"Log_attr_description"      ,tempbolog);
	dump_array(attr_comments            ,"attr_comments"             ,tempbolog);
	dump_array(Pm_attr_comments         ,"Pm_attr_comments"          ,tempbolog);
	dump_array(struct_contents          ,"struct_contents"           ,tempbolog);
	dump_array(struct_key               ,"struct_key"                ,tempbolog);
	dump_array(enum                     ,"enum"                      ,tempbolog);
	dump_array(enum_contents            ,"enum_contents"             ,tempbolog);
	dump_array(attribute_list           ,"attribute_list"            ,tempbolog);
	dump_array(action                   ,"action"                    ,tempbolog);
	dump_array(action_list              ,"action_list"               ,tempbolog);
	dump_array(takes_effect             ,"takes_effect"              ,tempbolog);
	printf ".";
	dump_array(Pm_attribute_list        ,"Pm_attribute_list"         ,tempbolog);
	dump_array(Log_attribute_list       ,"Log_attribute_list"        ,tempbolog);
	dump_array(mandatory_attributes     ,"mandatory_attributes"      ,tempbolog);
	dump_array(restricted_attributes    ,"restricted_attributes"     ,tempbolog);
	dump_array(sorted_attribute_list    ,"sorted_attribute_list"     ,tempbolog);
	dump_array(sorted_action_list       ,"sorted_action_list"        ,tempbolog);
	printf ".";
	dump_array(sorted_Pm_attribute_list ,"sorted_Pm_attribute_list"  ,tempbolog);
	dump_array(sorted_Log_attribute_list,"sorted_Log_attribute_list" ,tempbolog);
	dump_array(struct_type              ,"struct_type"               ,tempbolog);
	dump_array(MoAttributesType         ,"MoAttributesType"          ,tempbolog);
	dump_array(PmAttributesType         ,"PmAttributesType"          ,tempbolog);
	dump_array(MoAttributesTypeJava     ,"MoAttributesTypeJava"      ,tempbolog);
	printf ".";
	#dump_array(PmAttributes             ,"PmAttributes"              ,tempbolog);
	dump_array(LogAttributes            ,"LogAttributes"             ,tempbolog);
	dump_array(childList                ,"childList"                 ,tempbolog);
	dump_array(parentList               ,"parentList"                ,tempbolog);
	dump_array(sorted_childList         ,"sorted_childList"          ,tempbolog);
	dump_array(sorted_parentList        ,"sorted_parentList"         ,tempbolog);
	printf ".";
	dump_array(deprecatedRelationship   ,"deprecatedRelationship"    ,tempbolog);
	dump_array(cardinality              ,"cardinality"               ,tempbolog);
	dump_array(pull_molist              ,"pull_molist"               ,tempbolog);
	dump_array(sorted_pull_attrlist     ,"sorted_pull_attrlist"      ,tempbolog);
	dump_array(mom_moclass_list         ,"mom_moclass_list"          ,tempbolog);
	dump_array(tolower_mom_moclass_list ,"tolower_mom_moclass_list"  ,tempbolog);
	dump_array(pdf_counter_table        ,"pdf_counter_table"         ,tempbolog);
	dump_array(hidden_attributes        ,"hidden_attributes"         ,tempbolog);
	dump_array(derived_description      ,"derived_description"       ,tempbolog);
	dump_array(derived_type             ,"derived_type"              ,tempbolog);
	dump_array(momVersionComponents     ,"momVersionComponents"      ,tempbolog);
	dump_array(ecimVersionComponents    ,"ecimVersionComponents"     ,tempbolog);
	dump_array(mimComponents            ,"mimComponents"             ,tempbolog);
	dump_array(momParts                 ,"momParts"                  ,tempbolog);
	dump_array(ecimMomName              ,"ecimMomName"               ,tempbolog);
	dump_array(mimNames                 ,"mimNames"                  ,tempbolog);
	dump_array(ecimMomVer               ,"ecimMomVer"                ,tempbolog);
	dump_array(sorted_struct_contents   ,"sorted_struct_contents"    ,tempbolog);
	print "END_MOSHELL_MOM_CACHE"                                   >> tempbolog;
	close(tempbolog);
	#check again if someone didn't already write to cache
	if (fileOps(sprintf("test -s "mom_file_cache)) != 0)
	{
		fileOps("mv "tempbolog" "mom_file_cache)
		empty_file(tempbolog)
		chmod(00666,mom_file_cache)
	}
	customPrint("Done.")
	if (system("gzip -f "mom_file_cache)==0)
	{
		customPrint("Compressing to: "mom_file_cache".gz ...Done.")
		chmod(00666,mom_file_cache".gz")
	}
}
function definetruntypes()
{
	truntype["i"]="Integer"
	truntype["l"]="Long"
	truntype["b"]="Boolean"
	truntype["f"]="Float"
	truntype["s"]="String"
	truntype["r"]="Ref"
	truntype["t"]="Struct"
	truntype["ai"]="Array Integer"
	truntype["al"]="Array Long"
	truntype["ab"]="Array Boolean"
	truntype["af"]="Array Float"
	truntype["as"]="Array String"
	truntype["ar"]="Array Reference"
	truntype["at"]="Array Struct"
}
function correct_mom_path(mom_file)
{
	if (fileOps("test -s "mom_file".gz")==0) mom_file=mom_file".gz"
	else if (fileOps("test -s "mom_file".jar")==0) mom_file=mom_file".jar"
	else if (fileOps("test -s "gensub(/.gz$/,"",1,mom_file))==0) mom_file=gensub(/.gz$/,"",1,mom_file)
	return mom_file
}
function make_momver(prefix,mv,suffix,    n,i,thestring,theval,p,a,x,y,z,g,h,ck,rat,v1,v2,v,ratlist,tmpmomf)
{
	n=asort(momVersionComponents)
	for (i=1;i<=n;i++)
	{
		#ComSecM_11.1.0
		thestring=thestring";"momVersionComponents[i]
		split(gensub(/^.*_/,"",1,momVersionComponents[i]),a,".")
		if (prefix ~ /^(CRBS|MSRBS)_NODE_MODEL/)
		{
			if (momVersionComponents[i]~/^[LGW]rat/) ratlist[substr(momVersionComponents[i],1,1)]=substr(momVersionComponents[i],1,1)
		}
		else if (prefix ~ /PRBS_NODE_MODEL/)
		{
			if (tolower(momVersionComponents[i]) ~ /_nodebfunction/) ratlist["W"]="W"
			else if (tolower(momVersionComponents[i]) ~ /_enodebfunction/) ratlist["L"]="L"
		}
		x+=a[1]
		y+=a[2]
		z+=a[3]
	}
	p=asort(ratlist)
	for (i=1;i<=p;i++) rat=rat ratlist[i]
	p=asort(ecimVersionComponents)
	for (i=1;i<=p;i++)
	{
		#ECIM_T_OSPFv2_1.0
		thestring=thestring";"ecimVersionComponents[i]
		split(gensub(/^.*_/,"",1,ecimVersionComponents[i]),a,".")
		#g+=a[1]
		#h+=a[2]
		x+=a[1]
		y+=a[2]
	}
	sub(/^;/,"",thestring)
	fileOps("rm "tempmd5file)
	print thestring > tempmd5file
	close(tempmd5file)
	#print x"."y"."z"_"g"."h
	#v1=sprintf("%.4f",(x*10^12+y*10^6+z)/n/10^12)
	#v2=sprintf("%.2f",(g*10^6+h)/p/10^6)
	#ck=crc_function(thestring)
	ck=make_md5(tempmd5file)
	v1=x"."y"."z
	v2=g"."h
	#OLD naming convention:
	#res=prefix"_"mv"_"ck
	#NEW naming convention
	if (prefix ~ /^PRBS_NODE_MODEL/)
	{
		if (rat ~ /LW/) prefix="M"prefix
		else if (rat ~ /^.$/) prefix= rat prefix
	}
	if (node ~ /^OFFLINE_/ && MeRelease=="")
	{
		tmpmomf=gensub(/^.*\//,"",1,mom_file)
		#MSRBS_NODE_MODEL_17B_308.32727.62_fd32
		#MSRBS_NODE_MODEL_17Q2_308.32727.62_fd32
		if (tmpmomf ~ /_NODE_MODEL_[0-9A-Za-z.]+_[1-9][0-9]*\.[1-9][0-9]*\.[1-9][0-9]*_[0-9a-f][0-9a-f][0-9a-f][0-9a-f]/) MeRelease=gensub(/_.*$/,"",1,gensub(/^.*_NODE_MODEL_/,"",1,tmpmomf))
	}
	res= prefix (MeRelease!=""?"_"MeRelease:"") "_"v1"_" substr(ck,1,4) (prefix~/^(CRBS|MSRBS)_NODE_MODEL/&&rat!="GLW"&&rat!=""?"_"rat:"") suffix
	return res
}
function make_md5(file,   md5_command,result,ok)
{
	ok=0
	result="md5_error"

	if (fileOps("test -s "file)!=0)
	{
		customPrint("MD5 Error: file "file" not found!")
		return result
	}
	#we do the md5 on ungzipped file otherwise it will give different checksums
	if (file ~ /\.gz$/)
	{
		if (system("gzip -df "file)==0){sub(/.gz$/,"",file) ; ok=1 }
		else return result
	}
	md5_command=md5sum" "file
	while (md5_command |& getline)
	{
		gsub("\r","") ; gsub("\x000","")
		if (mosdebug==1) print "md5: "$0
		if ($NF ~ file) result=$1
	}
	close(md5_command)
	if (ok==1) system("gzip -f "file)
	return result
}
function make_com_momversion(what,   i,prefix,newmomfile,tpref,suffix)
{
	if (comcli==0) return
	if (node ~ /^OFFLINE_/ && mom_file ~ /_TESTMOM\.xml/) testMOM=1
	if (testMOM==1) suffix="_TESTMOM"
	mom_version=""
        for(i=1;i<=mimCounter;i++)
        {
                if (tolower(mimComponents[i]) ~ /comtop|ecim_*top/) ComVersion=mimComponents[i]
                else if (tolower(mimComponents[i]) ~ /_node|_wcdma|_lte|^wrat|^lrat|^grat/) mom_version=mom_version"_"gensub(/_NODE_MODEL_/,"_",1,mimComponents[i])  #in LTE G2 there is a MOM fragment called ERBS_NODE_MODEL, that could be confusing in scripts that look at the MOM version
                if (tolower(mimComponents[i]) ~ "(epic|msrbs).*(wcdma|_nodebfunction)") prefix="PRBS_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ "(epic|msrbs).*enodebfunction") prefix="PRBS_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ "axefunction") prefix="AXE_NODE_MODEL"
                else if (mimComponents[i] ~ /^EMe_|^VEme/) prefix="EME_NODE_MODEL"
                else if (mimComponents[i] ~ /^Pgm/) prefix="PGM_NODE_MODEL"
                else if (mimComponents[i] ~ /^Sapc/) prefix="SAPC_NODE_MODEL"
                else if (mimComponents[i] ~ /^SecurityGateway/) prefix="SEG_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /^cscf/) prefix="CSCF_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /hss.?function/) prefix="HSS_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /^dmxc/) prefix="DMXC_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /^ipworks/) prefix="IPWORKS_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /^bgf/) prefix="BGF_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ /^sbg/) prefix="SBG_NODE_MODEL" #SbgCm_9.2.0
                else if (tolower(mimComponents[i]) ~ /^dscoam/) prefix="DSC_NODE_MODEL" #DscOamMom_4.39.0_A
                else if (tolower(mimComponents[i]) ~ "_node" && prefix!~"PRBS_NODE_MODEL") prefix=toupper(gensub(/_node.*$/,"",1,tolower(mimComponents[i])))"_NODE_MODEL"
                else if (tolower(mimComponents[i]) ~ "sectorequipment|^lrat" && prefix!~"PRBS_NODE_MODEL") prefix="MSRBS_NODE_MODEL"  #RBS G2
                else if (mimComponents[i] ~ /^Rcs[A-Z]/) tpref="RCS_NODE_MODEL" #RCS node like G2 or TCU03
        }
        sub(/^_/,"",mom_version)
        if (prefix=="")
        {
        	if (tpref!="") prefix=tpref
        	else prefix="COM_NODE_MODEL"
        }
        if (mom_version=="") mom_version=ComVersion
        mom_file=correct_mom_path(mom_file)
        #mom_version=prefix"_"mom_version"_"make_md5(mom_file)
        mom_version=make_momver(prefix,mom_version,suffix)
        newmomfile=jarxmldir"/"mom_version".xml"
	if (what=="print") customPrint(mom_version)
        if (fileOps("test -s "newmomfile)!=0 && fileOps("test -s "newmomfile".gz")!=0)
        {
                customPrint("Copying "mom_file" to "newmomfile".gz")
                fileOps("cp "mom_file" "newmomfile".gz")
        }
        if (what=="print" && fileOps("test -s "newmomfile".gz")==0) mom_file=newmomfile".gz"
        ReadMimName()
}
function momfinish(    i,extra,tcppver)
{
	#Set celloversion variable so it is accessible to users
	if ((multi && nrOfNodes==1)||(multi!=1))
	{
		unassignCustomVar("$momparts")
		unassignCustomVar("$cellomomversion")
		unassignCustomVar("$celloversion")
		unassignCustomVar("$momdocnumber")
		unassignCustomVar("$momdocrevision")
		unassignCustomVar("$comtopmomversion")
		if (comcli>0)
		{
			assignCustomVar("$comtopmomversion",ComVersion,"","system")
			for(i=1;i<=mimCounter;i++)
			{
				extra=""
				if (mimNames[i] in ecimMomName && ecimMomName[mimNames[i]]!=mimNames[i]) extra=" ("ecimMomName[mimNames[i]] ecimMomVer[ecimMomName[mimNames[i]]]")"
				#print mimComponents[i],extra
				assignCustomVar(sprintf("$momparts[%02d]",i),sprintf("%s%s",mimComponents[i],extra),"","system")
			}
			Define_com_mos()
		}
		else
		{
			assignCustomVar("$momdocnumber",momdocnumber,"","system")
			assignCustomVar("$momdocrevision",momdocrevision,"","system")
			tcppver=""
			for (i in momParts)
			{
				if (momParts[i] ~ /CPP|LSV/ && momParts[i] > tcppver) tcppver=momParts[i]
				assignCustomVar(sprintf("$momparts[%s]",i),momParts[i],"","system")
			}
			if (tcppver!="") CelloVersion="9-"tcppver
			assignCustomVar("$cellomomversion",CelloVersion,"","system")
			assignCustomVar("$celloversion",CelloVersion,"","system")

		}
		assignCustomVar("$momversion",mom_version,   "","system")
	}

	hackMom()
	make_sorted_lists()
	make_param_table()
	for (i in Pm_attr_comments) { if (Pm_attr_comments[i] ~ /deprecated|obsolete/) pm_deprecated[i]=1 }

	makeMimMapping()
	makeSimpleMimMapping()
	make_imom_table()
	makeNetconfcliFiles()

	#tablePrint(mimMap,"mimMap")
	if (CelloVersion ~ /^[4-6]/) use_lhz=0  #use_lhz is only supported from CPP7 and higher

	#In online mode, when comcli_mom is > 0 , the mom version is not yet known by the time we set the prompt, so the prompt color is empty.
	#Therefore we set the prompt again after reading the MOM
	if (prompt_has_been_manually_set != 1 && comcli>0 && comcli_mom>0 && node !~ /^OFFLINE_/) Set_prompt("",evalnodecase(node))

	MomHasBeenRead=1

}
function makeNetconfcliFiles(   i,a,b,n,j,y,z,s,t,combined_attr_list,tmp,e,f,l)
{
	if (comcli==0 || use_netconf==0) return
	#if (comcli==0) return
	tempnetconfmomdir  = sprintf("%s/netconfmomdir",        tempdir)
	tempactionfile     = sprintf("%s/actionFile",           tempnetconfmomdir)
	tempstructfile     = sprintf("%s/structFile",           tempnetconfmomdir)
	tempseqfile        = sprintf("%s/seqFile",              tempnetconfmomdir)
	tempmoattributefile= sprintf("%s/moattrFile",           tempnetconfmomdir)
	tempkeyattrfile    = sprintf("%s/keyattrFile",          tempnetconfmomdir)
	tempunknownattrfile= sprintf("%s/hideUnknownAttrFile",  tempnetconfmomdir)
	fileOps("mkdir -p "tempnetconfmomdir)
	fileOps("rm "tempactionfile)
	fileOps("rm "tempstructfile)
	fileOps("rm "tempseqfile)
	fileOps("rm "tempmoattributefile)
	fileOps("rm "tempkeyattrfile)
	fileOps("rm "tempunknownattrfile)
	for (i in action)
	{
		split(i,a,SUBSEP)
		split(action[i],b,":")
		n=b[1]+0
		#if (n==0) continue
		for (j=2;j<=(n+1);j++)
		{
			y[j-1]=b[j]
			z[j-1]=b[j+n]
		}
		s=gensub(/^.*\./,"",1,a[1])" "a[2]" "n
		for (j=1;j<=n;j++) s=s" "y[j]
		for (j=1;j<=n;j++) s=s" "z[j]
		print s >> tempactionfile
	}
	close(tempactionfile)
	for (i in ExtendedMoAttributesType)
	{
		split(i,a,":")
		#if (exclude_deprecated>0 && attr_comments[a[1],a[2]] ~ /deprecated|obsolete/) continue
		#if (ExtendedMoAttributesType[i]~/^struct/)
		if (ExtendedMoAttributesType[i]~/structRef/)
		{
			print gensub(/^.*\./,"",1,a[1])" "a[2]" "struct_contents[gensub(/^.*structRef[-:]/,"",1,ExtendedMoAttributesType[i])] >> tempstructfile
		}
		#if (ExtendedMoAttributesType[i]~/^sequence:/ && ExtendedMoAttributesType[i]!~/^sequence:struct/)
		if (ExtendedMoAttributesType[i]~/^sequence:/)
		{
			print gensub(/^.*\./,"",1,a[1])" "a[2] >> tempseqfile
		}
	}
	close(tempseqfile)
	close(tempstructfile)
	for (i in sorted_attribute_list)
	{
		if (sorted_attribute_list[i]=="") continue
		tmp=gensub(/^.*\./,"",1,i)
		if (tmp in dupMocList && dupMocList[tmp]!="")
		{
			split(sorted_attribute_list[i],e,",")
			for (f in e) combined_attr_list[tmp,e[f]]=1
			continue
		}
		print tmp" "sorted_attribute_list[i] >> tempmoattributefile
	}
	for (i in dupMocList)
	{
		l=""
		for (j in combined_attr_list)
		{
			split(j,a,SUBSEP)
			if (a[1]==i && a[2]!="") l=l","a[2]
			sub(/^,/,"",l)
		}
		if (l!="") print i" "l >> tempmoattributefile
	}
	close(tempmoattributefile)
	for (i in attr_comments)
	{
		if (attr_comments[i] ~ /key/)
		{
			split(i,a,SUBSEP)
			sub(/^[^.]+\./,"",a[1])
			split(a[1],b,"")
			a[3]=gensub(b[1],tolower(b[1]),1,a[1])
			if (a[2] != sprintf("%sId",a[3])) print a[1]" "a[2] >> tempkeyattrfile
		}
	}
	close(tempkeyattrfile)
	for (i in dupMocList) print i >> tempunknownattrfile
	close(tempunknownattrfile)
	mustSendFiles=1
	old_netconf_counter=netconf_counter+0
	netconf_counter++
}
function sendNetconfCliFiles()
{
	if (use_netconf>0 && netconf_counter>old_netconf_counter)
	{
		comcli_cmd_mini("parseactionfile "tempactionfile)
		comcli_cmd_mini("parsestructattributefile "tempstructfile)
		comcli_cmd_mini("parsesequenceattributefile "tempseqfile)
		comcli_cmd_mini("parseattributefile "tempmoattributefile)
		comcli_cmd_mini("parsekeyattrfile "tempkeyattrfile)
		comcli_cmd_mini("parseunknownattrfile "tempunknownattrfile)
		mustSendFiles=0
	}
}

function make_param_table(   ref_file,i,array)
{
	if (multi) return
	#if (noninteractive) return
	if (set_check == 0) return
	ref_file=find_pmrfile("PARAM")
	parse_mofile(ref_file,param_table,"baseline","","noDN")
	if (fileOps("test -s "custom_param_file)==0)
	{
		parse_mofile(custom_param_file,param_table,"baseline","","noDN")
	}
	if (mosdebug==2) tablePrint(param_table,"param_table")
}
function make_imom_table(   ref_file,i,a,moc,att,flag,type,desc,n,b,c,p,q,j,k,vals,td_table,fmoc)
{
	if (is_rcs()!=1) return
	if (simulate_no_testmom==1) sub(/_TESTMOM$/,"",mom_version)
	if (mom_version ~ /_TESTMOM/)
	{
		ref_file=find_pmrfile("IMOMF")
		if (ref_file=="") return
		while (getline < ref_file)
		{
			gsub("\r","")
			#AnrFunction   noOfTimesToCheckRel     long   noNotification,EricssonOnly
			if ($1 ~ /^[A-Z]/ && $NF~/EricssonOnly/)
			{
				moc=simpleMimMap[$1]"."$1
				if (moc":"$2 in MoAttributesType && attr_comments[moc,$2]!~"EricssonOnly")
				{
					attr_comments[moc,$2]=attr_comments[moc,$2]",EricssonOnly"
					sub(/^,/,"",attr_comments[moc,$2])
				}
			}
		}
		close(ref_file)
		return
	}
	ref_file=find_pmrfile("IMOMD")
	if (ref_file!="")
	{
		delete td_table
		while (getline < ref_file)
		{
			gsub("\r","")
			#attr_description[Lrat.ReportConfigEUtraBestCell,reportQuantityA3] = The quantities to include in the measurement report.<CR>Dependencies: The value sameAsTriggerQuantity means that the same quantity as triggerQuantity is to be included in the measurement report.<CR>The value both means that both RSRP and RSRQ quantities is to be included in the measurement report.<CR>Change takes effect: New connection<CR>Default=BOTH<CR>Range: 0,1
			gsub(/^.*\[|\]$/,"",$1)
			sub(/,/,SUBSEP,$1)
			td_table[$1]=gensub(/<CR>/,"\n","g",gensub(/^[^=]+= /,"",1,$0))
		}
		close(ref_file)
	}
	ref_file=find_pmrfile("IMOM")
	if (ref_file=="") return
	delete imom_table
	delete imom_list
	delete imom_list_full
	delete sorted_imom_list
	delete sorted_imom_list_full
	while (getline < ref_file)
	{
		#ManagedElement,ENodeBFunction,AnrFunction|managedelement,enodebfunction,anrfunction|noOfTimesToCheckRel|nooftimestocheckrel|RW|int32||||This parameter defines the number of times that a suspected neighbour relation (if there are more then one cell with the same PCI), shall be checked using CGI reports. |
		#ManagedElement,ENodeBFunction,EUtranCellFDD,UeMeasControl,ReportConfigEUtraBadCovPrim|managedelement,enodebfunction,eutrancellfdd,uemeascontrol,reportconfigeutrabadcovprim|reportQuantityA2Prim|reportquantitya2prim|RW|enumRef||SAME_AS_TRIGGER_QUANTITY,BOTH|0,1|The quantities to include in the measurement report for the primary eventA2 measurement. The value 0 - sameAsTriggerQuantity means that the same quantity as triggerQuantity is included in the measurement report. The value 1 - both means that both Reference Symbol Received Power (RSRP) and Reference Symbol Received Quality (RSRQ) quantities are included in the measurement report. Primary and secondary measurement parameters refer to the option to use different settings for two simultaneous measurements for eventA2.|
		split($0,a,/\|/)
		fmoc=gensub(/,/,".","g",a[1])
		moc=gensub(/^.*,/,"",1,a[1])
		moc=simpleMimMap[moc]"."moc
		att=a[3]
		if (simulate_no_testmom!=1 && moc":"att in MoAttributesType && MoAttributesType[moc":"att]!="") continue
		if (att=="reservedBy") continue
		if (sprintf("%sid",tolower(cutmoc(moc)))==tolower(att)) continue
		if (MeRelease >= "17")
		{
			if (cutmoc(moc)~/^(ReportConfigB2CdmaRttUlTrig|ReportConfigB2CdmaUlTrig)$/) continue   #These MO classes are deprecated from 17.Q4
			else if (att~/^(mbsfnSubframeAlloc|pftTatAndIatPairSelection)$/) continue #These attributes are deprecated from 17.Q2 / 16B respectively
		}
		if (a[5]=="RO") flag="readOnly,EricssonOnly"
		else flag="EricssonOnly"
		type=a[6]":"a[7]
		sub(/:$/,"",type)
		p=split(a[9],b,",")
		split(a[8],c,",")
		vals=""
		for (j=1;j<=p;j++) vals=vals b[j]":"c[j]" "
		if ((moc,att) in td_table && td_table[moc,att]!="") a[10]=td_table[moc,att]
		desc=a[10]"\nValues: "vals
		sub(/\nValues: +$/,"",desc)
		imom_list_full[fmoc,att]=fmoc","att
		imom_list[moc,att]=moc","att
		imom_table[moc,att]=type SUBSEP flag SUBSEP desc
		if (check_append_testmom()==0)
		{
			attr_comments[moc,att]=extended_attr_comments[moc,att]=merge_momlist(attr_comments[moc,att],flag)
			if (attr_description[moc,att]=="") attr_description[moc,att]=desc
			if (MoAttributesType[moc":"att]=="")
			{
				MoAttributesType[moc":"att]=ExtendedMoAttributesType[moc":"att]=type
				MoAttributesTypeJava[moc":"att]=convert_attribute_types(type)
				tolower_MoAttributesType[tolower(moc":"att)]=1
			}
		}
		#if (mom_version ~ /_TESTMOM/ && attr_comments[moc,att]!~/EricssonOnly/)
		#{
		#	attr_comments[moc,att]=attr_comments[moc,att]",EricssonOnly"
		#	sub(/^,/,"",attr_comments[moc,att])
		#}
	}
	close(ref_file)
	n=asort(imom_list)
	for (i=1;i<=n;i++)
	{
		split(imom_list[i],a,",")
		sorted_imom_list[a[1]]=sorted_imom_list[a[1]]","a[2]
		sub(/^,/,"",sorted_imom_list[a[1]])
	}
	n=asort(imom_list_full)
	for (i=1;i<=n;i++)
	{
		split(imom_list_full[i],a,",")
		sorted_imom_list_full[a[1]]=sorted_imom_list_full[a[1]]","a[2]
		sub(/^,/,"",sorted_imom_list_full[a[1]])
	}
	delete imom_list
	delete imom_list_full
	if (check_append_testmom()==0)
	{
		for (i in sorted_imom_list)
		{
			attribute_list[i]=extended_attribute_list[i]=sorted_attribute_list[i]=sorted_extended_attribute_list[i]=merge_momlist(sorted_attribute_list[i],sorted_imom_list[i])
		}
	}
}
function merge_momlist(list1,list2,   list,a,b,c,i,n)
{
	split(list1,a,",")
	split(list2,b,",")
	for (i in a) c[a[i]]=a[i]
	for (i in b) c[b[i]]=b[i]
	n=asort(c)
	for (i=1;i<=n;i++) list=list","c[i]
	sub(/^,/,"",list)
	return list
}
function check_append_testmom()
{
	if (use_testmomdump==1 && node ~ /^OFFLINE_/ && mom_version !~ /_TESTMOM/ && fileOps("test -s "tempintmomlog3)==0) return 0
	return 1
}
function print_mom_tables()
{
	#tablePrint(class_description        ,"class_description")
	#tablePrint(attr_description         ,"attr_description")
	tablePrint(attr_default             ,"attr_default")
	tablePrint(attr_range               ,"attr_range")
	tablePrint(attr_length              ,"attr_length")
	#tablePrint(actn_description         ,"actn_description")
	#tablePrint(enum_description         ,"enum_description")
	#tablePrint(struct_description       ,"struct_description")
	#tablePrint(Pm_attr_description      ,"Pm_attr_description")
	#tablePrint(Log_attr_description     ,"Log_attr_description")
	tablePrint(attr_comments            ,"attr_comments")
	tablePrint(Pm_attr_comments         ,"Pm_attr_comments")
	tablePrint(struct_contents          ,"struct_contents")
	tablePrint(enum                     ,"enum")
	tablePrint(enum_contents            ,"enum_contents")
	tablePrint(attribute_list           ,"attribute_list")
	tablePrint(action                   ,"action")
	tablePrint(action_list              ,"action_list")
	tablePrint(actn_result              ,"actn_result")
	tablePrint(Pm_attribute_list        ,"Pm_attribute_list")
	tablePrint(Log_attribute_list       ,"Log_attribute_list")
	tablePrint(mandatory_attributes     ,"mandatory_attributes")
	tablePrint(restricted_attributes    ,"restricted_attributes")
	tablePrint(sorted_attribute_list    ,"sorted_attribute_list")
	tablePrint(sorted_action_list       ,"sorted_action_list")
	tablePrint(sorted_Pm_attribute_list ,"sorted_Pm_attribute_list")
	tablePrint(sorted_Log_attribute_list,"sorted_Log_attribute_list")
	tablePrint(struct_type              ,"struct_type")
	tablePrint(MoAttributesType         ,"MoAttributesType")
	tablePrint(PmAttributesType         ,"PmAttributesType")
	tablePrint(MoAttributesTypeJava     ,"MoAttributesTypeJava")
	#tablePrint(PmAttributes             ,"PmAttributes")
	tablePrint(LogAttributes            ,"LogAttributes")
	tablePrint(childList                ,"childList")
	tablePrint(parentList               ,"parentList")
	tablePrint(sorted_childList         ,"sorted_childList")
	tablePrint(sorted_parentList        ,"sorted_parentList")
	tablePrint(cardinality              ,"cardinality")
	tablePrint(attr_refs                ,"attr_refs")
	tablePrint(pdf_counter_table        ,"pdf_counter_table")
	tablePrint(pull_molist              ,"pull_molist")
	tablePrint(sorted_pull_attrlist     ,"sorted_pull_attrlist")
	tablePrint(mom_moclass_list         ,"mom_moclass_list")
	tablePrint(tolower_mom_moclass_list ,"tolower_mom_moclass_list")
	tablePrint(sorted_mom_list          ,"sorted_mom_list")
	tablePrint(eget_attribute_list      ,"eget_attribute_list")
	tablePrint(sorted_eget_attribute_list ,"sorted_eget_attribute_list")
	tablePrint(hidden_attributes        ,"hidden_attributes")
	tablePrint(com_moclass_list         ,"com_moclass_list")
	#tablePrint(derived_description      ,"derived_description")
	tablePrint(derived_type             ,"derived_type")
	tablePrint(mimComponents            ,"mimComponents")
	tablePrint(mimNames                 ,"mimNames")
	tablePrint(ecimMomVer               ,"ecimMomVer")
	tablePrint(cppMoList                ,"cppMoList")
	tablePrint(mimMap                   ,"mimMap")
	tablePrint(ecimMomName              ,"ecimMomName")
	tablePrint(struct_with_moref        ,"struct_with_moref")


	#table formats:
	#class_description[moclass]=description
	#attr_description[moclass,attribute]=description
	#actn_description[moclass,action]=description
	#enum_description[enum]=description
	#struct_description[struct]=description
	#attr_comments[moclass,attribute]=flags
	#struct_contents[struct]=member,member,member
	#enum[enum,value]=translation
	#enum[enum,translation]=value
	#enum_contents[enum]=value:translation, value:translation
	#attribute_list[moclass]=attribute,attribute,attribute
	#action[moclass,action]=numberofparams:param1:param2:type1:type2
	#action_list[moclass]=action1,action2,action3  (same for sorted_action_list)
	#mandatory_attributes[moclass]=attr1,attr2
	#restricted_attributes[moclass]=attr1,attr2  (same for sorted_attribute_list)
	#struct_type[struct,member]=type
	#MoAttributesType[moclass":"attribute]=type
	#pdf_counter_table[counter]=nrOfelements
	#pull_molist[moclass]=moclass
	#sorted_pull_attrlist[moclass]=attr1,attr2
	#mom_moclass_list[moclass]=moclass
	#tolower_mom_moclass_list[tolower(moclass)]=tolower(moclass)
	#mimComponents[44]=Epg_Pgw_RuleSpace_4_0$
	#ecimMomName[ComTop]=ECIM_Top
	#derived_type[Epg_Pgw_ServiceIdentification.Port]=uint32$
	#derived_description[Epg_Pgw_SI_HeaderRule.RangedU16]=1 ... 6553
	#cppMoList[ComFm.FmAlarmType]=ComFm.FmAlarmType$
}
function make_pullcounter_table(   i,last,array,j,tmp_list,tlist)
{
	#if the pull_molist is empty, make a default one.
	#This has to be done on CPP5.0 and below where the info about pull counters is not present in MOM
	if (!(CelloVersion >= "5.1"))
	{
		#add all MGW MOs
		#MOs under MgwApplication, InteractiveMessaging, MsProcessing, MsPlatform
		tmp_list["MgwApplication"]=tmp_list["InteractiveMessaging"]=tmp_list["MsProcessing"]=tmp_list["MsPlatform"]=1
		for (i in tmp_list)
		{
			if (!(i in attribute_list)) continue
			pull_molist[i]=i
			split(show_all_childrenclasses(i),array,";")
			for (j in array) pull_molist[array[j]]=array[j]
		}
		#add all Cello MOs that use the pull method and that have pm counters
		delete tmp_list
		tmp_list["Aal0TpVccTp"]=1
		tmp_list["Aal1TpVccTp"]=1
		tmp_list["Aal2Ap"]=1
		tmp_list["Aal2PathVccTp"]=1
		tmp_list["Aal2Sp"]=1
		tmp_list["Aal5TpVccTp"]=1
		tmp_list["AtmPort"]=1
		tmp_list["E1PhysPathTerm"]=1
		tmp_list["E1Ttp"]=1
		tmp_list["E3PhysPathTerm"]=1
		tmp_list["EthernetLink"]=1
		tmp_list["ImaGroup"]=1
		tmp_list["ImaLink"]=1
		tmp_list["Ip"]=1
		tmp_list["IpAccessHostGpb"]=1
		tmp_list["IpAccessHostMsb"]=1
		tmp_list["IpAtmLink"]=1
		tmp_list["J1PhysPathTerm"]=1
		tmp_list["M3uAssociation"]=1
		tmp_list["MediumAccessUnit"]=1
		tmp_list["Mtp2TpAnsi"]=1
		tmp_list["Mtp2TpChina"]=1
		tmp_list["Mtp2TpItu"]=1
		tmp_list["Mtp3bAp"]=1
		tmp_list["Mtp3bSlAnsi"]=1
		tmp_list["Mtp3bSlChina"]=1
		tmp_list["Mtp3bSlItu"]=1
		tmp_list["Mtp3bSlTtc"]=1
		tmp_list["Mtp3bSpAnsi"]=1
		tmp_list["Mtp3bSpChina"]=1
		tmp_list["Mtp3bSpItu"]=1
		tmp_list["Mtp3bSpTtc"]=1
		tmp_list["Mtp3bSr"]=1
		tmp_list["Mtp3bSrs"]=1
		tmp_list["NniSaalTp"]=1
		tmp_list["Os155SpiTtp"]=1
		tmp_list["Ospf"]=1
		tmp_list["OspfArea"]=1
		tmp_list["OspfInterface"]=1
		tmp_list["PlugInUnit"]=1
		tmp_list["SccpAccountingCriteria"]=1
		tmp_list["SccpPolicing"]=1
		tmp_list["SccpScrc"]=1
		tmp_list["SccpSp"]=1
		tmp_list["Sctp"]=1
		tmp_list["Sts1SpeTtp"]=1
		tmp_list["Sts3CspeTtp"]=1
		tmp_list["T1PhysPathTerm"]=1
		tmp_list["T1Ttp"]=1
		tmp_list["T3PhysPathTerm"]=1
		tmp_list["UniSaalTp"]=1
		tmp_list["Vc12Ttp"]=1
		tmp_list["Vc4Ttp"]=1
		tmp_list["VclTp"]=1
		tmp_list["VpcTp"]=1
		tmp_list["VplTp"]=1
		tmp_list["Vt15Ttp"]=1
		for (i in tmp_list) pull_molist[i]=i
	}

	#add MOs that do not have PM counters to the pull_molist
	for (i in attribute_list)
	{
		if (!(i in Pm_attribute_list)) pull_molist[i]=i
	}
	#add MOs that have attributes of type "noReset"
	for (i in Pm_attr_comments)
	{
		if (Pm_attr_comments[i]~"noReset")
		{
			split(i,array,SUBSEP)
			pull_molist[array[1]]=array[1]
		}
	}
	#remove MOs that have attributes of type "ropReset"
	for (i in Pm_attr_comments)
	{
		if (Pm_attr_comments[i]~"ropReset")
		{
			split(i,array,SUBSEP)
			delete pull_molist[array[1]]
		}
	}
	#remove SS7 MOs in C14.1 and after, TR HS47259
	if ("Ss7" in momParts && momParts["Ss7"]>="C14.1")
	{
		tlist["M3ua"]=tlist["Mtp3bSpAnsi"]=tlist["Mtp3bSpChina"]=tlist["Mtp3bSpItu"]=tlist["Mtp3bSpTtc"]=tlist["SccpSp"]=1
		for (i in tlist)
		{
			delete pull_molist[i]
			split(show_all_childrenclasses(i),array,";")
			for (j in array) delete pull_molist[array[j]]
		}
	}


	#Remove MOs that don't work from the pull_molist table
	remove_invalid_moclasses(pull_molist)

	#Here we can add any MO classes to the pull list:
	#pull_molist["IpInterface"]="IpInterface"

	#Make the pull counter list, only attributes of type integer, sequence:integer, boolean, string, moref are included
	for (i in pull_molist)
	{
		last=split(sorted_attribute_list[i],array,",")
		for (j in array)
		{
			if (MoAttributesTypeJava[i":"array[j]] ~ /^(i|ai|b|s|r)$/ && array[j] !~ sprintf("^%sId$",i)) pull_attrlist[i]=pull_attrlist[i]","array[j]
		}
	}

	#Add the userLabel for all MO classes that are not a pull MO
	for (i in attribute_list)
	{
		if ((!(i in pull_molist)) && (i":userLabel" in MoAttributesType))
		{
			pull_attrlist[i]="userLabel"
			pull_molist[i]=i
		}
	}
	#Add the IpInterface::trafficType attribute
	if ("IpInterface:trafficType" in MoAttributesType)
	{
		pull_attrlist["IpInterface"]="trafficType,userLabel"
	}
	#cleanup the tables
	for (i in pull_attrlist) sub(/^,/,"",pull_attrlist[i])
	sortTable(pull_attrlist,sorted_pull_attrlist)
}
function remove_invalid_moclasses(table,  tmp_list,i)
{
	#the following MO classes cause problems when creating scanners
	delete tmp_list
	tmp_list["DeviceSet"]=1
	tmp_list["IPBDeviceSet"]=1
	tmp_list["TdmStructData"]=1
	tmp_list["DevicePool"]=1
	tmp_list["VmgwStructData"]=1
	tmp_list["MescStructData"]=1
	tmp_list["GcpStructData"]=1
	tmp_list["ChStructData"]=1
	tmp_list["TimingUnit2"]=1
	for (i in tmp_list) delete table[i]
}
function make_sorted_lists(   i,n,dest)
{
	delete sorted_mom_list
	n=asorti(pull_molist,dest)
	for (i=1;i<=n;i++) sorted_mom_list["pull_mo"]=sorted_mom_list["pull_mo"]","dest[i]
	n=asorti(mom_moclass_list,dest)
	for (i=1;i<=n;i++) sorted_mom_list["moclass"]=sorted_mom_list["moclass"]","dest[i]
	n=asorti(struct_contents,dest)
	for (i=1;i<=n;i++) sorted_mom_list["structure"]=sorted_mom_list["structure"]","dest[i]
	n=asorti(enum_contents,dest)
	for (i=1;i<=n;i++) sorted_mom_list["enumerate"]=sorted_mom_list["enumerate"]","dest[i]
	n=asorti(derived_type,dest)
	for (i=1;i<=n;i++) sorted_mom_list["derived"]=sorted_mom_list["derived"]";"dest[i]    #a derivedType can contain a comma , eg ERBS_NODE_MODEL_D.DerivedInteger_MbsfnArea_commonSFAllocPeriod_4..4,8..8,16..16,32..32,64..64,128..128,256..256_Type
	for (i in sorted_mom_list) sub(/^,/,"",sorted_mom_list[i])
}
function remove_deprecated_relationships(     i,array,last,t_parent,t_child,res)
{
	res=0
	for (i in deprecatedRelationship)
	{
		split(i,array,SUBSEP)
		t_parent=array[1]
		t_child=array[2]
		#TR HU87067 , the relationship between QoSClassifier to DscpToPCPMap and DscpToPCPMap to DscpSetToPCP were marked deprecated by mistake
		if ((t_parent=="RtnQoSSystem.QoSClassifier" && t_child=="RtnQoSSystem.DscpToPCPMap")||(t_parent=="RtnQoSSystem.DscpToPCPMap" && t_child=="RtnQoSSystem.DscpSetToPCP")) continue
		remove_element(childList,t_parent,t_child,";")
		remove_element(parentList,t_child,t_parent,";")
		res++
	}
	return res
}
function hackMom(    moc,attr,i,array,last,tmp_attributes)
{
	#here you can do some changes to the MOM

	#Do not include deprecated attributes in cr command
	if (exclude_deprecated > 0)
	{
		for (i in attr_comments)
		{
			if (attr_comments[i] ~ /deprecated|obsolete/)
			{
				split(i,array,SUBSEP)
				if (multi) { moc=sprintf("%s%s%s",array[1],SUBSEP,array[2]) ; attr=array[3] }
				else { moc=array[1] ; attr=array[2] }
				if (attr_comments[i] ~ "mandatory")
				{
					#Only remove mandatory-obsolete attributes, mandatory-deprecated attributes must be kept, otherwise creation may fail
					 if (attr_comments[i] ~ "obsolete") remove_element(mandatory_attributes,moc,attr,",")
				}
				else if (attr_comments[i] ~ "restricted")
				{
					remove_element(restricted_attributes,moc,attr,",")
				}
				if (exclude_deprecated>=2)
				{
					remove_element(attribute_list,moc,attr,",")
					remove_element(sorted_attribute_list,moc,attr,",")
					#must keep these entries otherwise it causes problems when parsing a MO dump. Must not delete the the MoAttributesType entries for deprecated attributes.
					#delete MoAttributesType[moc":"attr]
					#delete MoAttributesTypeJava[moc":"attr]
				}
			}
		}
		if (remove_deprecated_relationships() > 0)
		{
			sort_childparentLists()
		}
	}
	if (exclude_deprecated>=2)
	{
		for (i in Pm_attr_comments)
		{
			if (Pm_attr_comments[i] ~ /deprecated|obsolete/)
			{
				split(i,array,SUBSEP)
				if (multi) { moc=sprintf("%s%s%s",array[1],SUBSEP,array[2]) ; attr=array[3] }
				else { moc=array[1] ; attr=array[2] }
				remove_element(sorted_Pm_attribute_list,moc,attr,",")
			}
		}
	}
	if (exclude_deprecated>=3)
	{
		for (i in actn_description)
		{
			if (actn_description[i] ~ /Obsolete:|Deprecated:/ || (i in actn_deprecated && actn_deprecated[i]==1))
			{
				split(i,array,SUBSEP)
				if (multi) { moc=sprintf("%s%s%s",array[1],SUBSEP,array[2]) ; attr=array[3] }
				else { moc=array[1] ; attr=array[2] }
				remove_element(sorted_action_list,moc,attr,",")
			}
		}
	}
	delete struct_deprecated
	if (exclude_deprecated>=4)
	{
		#Example
		#struct_deprecated[Lrat.AcBarringPresence,acBarringForEmergPresence] = 1
		#struct_deprecated[AcBarringPresence,acBarringForEmergPresence] = 1
		for (i in struct_description)
		{
			#special case for the struct member subFrameOffset in FrameStartOffset/FrameStartOffsetTDD (ERBS_NODE_MODEL)
			#it looks deprecated but in fact it is only some enum values that are deprecated
			if (i~sprintf("^FrameStartOffset(TDD)?%ssubFrameOffset$",SUBSEP)) continue
			if (struct_description[i] ~ /Obsolete:|Deprecated:/) struct_deprecated[i]=1
		}
	}

	sortTable(attr_refs,sorted_attr_refs,"depr")

	#we make the attribute sccpEntitySetId in SccpGlobalTitle MO as restricted because otherwise the MO creation does not work
	addRestrictedAttribute("SccpGlobalTitle","sccpEntitySetId")
	#the following attributes have to be entered if the attribute autoConfig is set to OFF
	addRestrictedAttribute("IpAccessHostGpb","ipAddress1")
	addRestrictedAttribute("IpAccessHostGpb","ipAddress2")
	addRestrictedAttribute("IpAccessHostSpb","ipAddress")
	addRestrictedAttribute("IpAccessHostSpb","ipAddress2")
	addRestrictedAttribute("IpInterface","defaultRouter0")
	addRestrictedAttribute("IpAccessHostEt","ipAddress")
	addRestrictedAttribute("DnsResolver","dnsServerAutoConfig")
	addRestrictedAttribute("DnsResolver","dnsServerAddress")
	if (mom_version ~ /^(TD)?RBS/) addRestrictedAttribute("AuxPlugInUnit","piuType")
	#In CPP>=5.1, it is not possible to set the attribute Aal2PathDistributionUnit:aal2PathVccTpList anymore, only action addpath works now
	#This is breaking the undo mode. The workaround is to add that attribute in the restricted list
	if (CelloVersion >= "5.1") addRestrictedAttribute("Aal2PathDistributionUnit","aal2PathVccTpList")
	#In CPP >=6, the attribute Aal2Ap::allocationMode requires the following extra attributes,
	#which are described as optional in MOM because they are not needed when allocationMode = AUTOMATIC
	#in fact the Aal2Ap:rpuId is required because the default value of allocationMode is MANUAL, it gets set to AUTOMATIC after creation.
	#so Aal2Ap::rpuId is always needed at create, regardless of the setting allocationMode
	#Aal2PathDistributionUnit::rpuId should have the value "d" (in "cr" command) when the Aal2Ap::allocationMode is AUTOMATIC
        if (CelloVersion >= "6")   addRestrictedAttribute("Aal2Ap","rpuId")
        if (CelloVersion >= "6")   addRestrictedAttribute("Aal2PathDistributionUnit","rpuId")
        addRestrictedAttribute("Vmgw","activeGcpTransportLayer")
        addRestrictedAttribute("IuLink","userPlaneIpResourceRef")
        addRestrictedAttribute("IubLink","userPlaneIpResourceRef")
        addRestrictedAttribute("IurLink","userPlaneIpResourceRef")
        addRestrictedAttribute("IuLink","atmUserPlaneTermSubrackRef")
        addRestrictedAttribute("IubLink","atmUserPlaneTermSubrackRef")
        addRestrictedAttribute("IurLink","atmUserPlaneTermSubrackRef")
        addRestrictedAttribute("Iub","userPlaneIpResourceRef")
        addRestrictedAttribute("NbapCommon","uniSaalTpRef1")
        addRestrictedAttribute("NbapDedicated","uniSaalTpRef1")
        addRestrictedAttribute("IpInterface","rps")
        addRestrictedAttribute("IpInterface","vlanRef")
        addRestrictedAttribute("IpInterface","mtu")
	addRestrictedAttribute("MbmsCch","plMbmsSaRef")
	addRestrictedAttribute("MbmsCch","nonPlMbmsSaRef")
	addRestrictedAttribute("IpSyncRef","ntpServerIpAddress")
	addRestrictedAttribute("DchMap","internalArp")
	#removeMandatoryAttribute("M3uAssociation","dscp")  #Not needed anymore, handled by the function process_restricted_attributes()
        addRestrictedAttribute("UtranCell","mocnCellProfileRef")
        addRestrictedAttribute("M3uaRemoteSp","exchangeMode")
	addRestrictedAttribute("Aal2Sp","afi") #WRNae93820
	addRestrictedAttribute("Ipv6Interface","vLan")
	addRestrictedAttribute("Ipv6Interface","vid")
	addRestrictedAttribute("Ipv6Interface","vlanRef")
	addRestrictedAttribute("Cdma2000FreqBandRelation","cellReselectionPriority")
	addRestrictedAttribute("Cdma20001xRttBandRelation","cellReselectionPriority")
	addRestrictedAttribute("EUtranFreqRelation","cellReselectionPriority")
	addRestrictedAttribute("GeranFreqGroupRelation","cellReselectionPriority")
	addRestrictedAttribute("UtranFreqRelation","cellReselectionPriority")
	addRestrictedAttribute("UtranTDDFreqRelation","cellReselectionPriority")
	addRestrictedAttribute("EUtranCellFDD","sectorCarrierRef")
	addRestrictedAttribute("EUtranCellTDD","sectorCarrierRef")
	addRestrictedAttribute("EUtranCellFDD","dlChannelBandwidth")
	addRestrictedAttribute("EUtranCellFDD","ulChannelBandwidth")
	#http://newtran01.au.ao.ericsson.se/moshell/forum_viewtopic.php?4.8238
	addRestrictedAttribute("EUtranCellFDD","additionalPlmnList")
	addRestrictedAttribute("EUtranCellTDD","additionalPlmnList")
	addRestrictedAttribute("EUtranCellFDD","additionalPlmnReservedList")
	addRestrictedAttribute("EUtranCellTDD","additionalPlmnReservedList")
	#DNS ipv6
	addRestrictedAttribute("DnsClient","dnsServerAddress")
	if (comcli>0)
	{
		addRestrictedAttribute("RtnPBRIPv4.NextHop","adminDistance")
		#The attribute address must be prompted since it is mandatory when configurationMode=MANUAL which is the default value
		addRestrictedAttribute("RtnL3InterfaceIPv4.AddressIPv4","address")
		addRestrictedAttribute("RtnL3InterfaceIPv4.AddressIPv4","configurationMode")  #TR HV24489
		addRestrictedAttribute("RtnL3InterfaceIPv6.AddressIPv6","address")
		addRestrictedAttribute("RtnL3InterfaceIPv6.AddressIPv6","configurationMode")
		#Applicable for InterfaceIPv4: One of the attributes address, discard and reference must be set, but only one of them at the same time.
		addRestrictedAttribute("RtnRoutesStaticRouteIPv4.NextHop","address")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv4.NextHop","discard")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv4.NextHop","reference")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv4.NextHop","adminDistance")
		#Applicable for InterfaceIPv6: One of the attributes address and discard must be set, but only one of them at the same time.
		addRestrictedAttribute("RtnRoutesStaticRouteIPv6.NextHop","address")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv6.NextHop","discard")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv6.NextHop","reference")
		addRestrictedAttribute("RtnRoutesStaticRouteIPv6.NextHop","adminDistance")
		#Dependencies: one of encapsulation or loopback must be set
		addRestrictedAttribute("RtnL3InterfaceIPv4.InterfaceIPv4","encapsulation")
		addRestrictedAttribute("RtnL3InterfaceIPv4.InterfaceIPv4","loopback")
		#Applicable for InterfaceIPv6: This attribute must be set.
		addRestrictedAttribute("RtnL3InterfaceIPv6.InterfaceIPv6","encapsulation")
		addRestrictedAttribute("RtnL3InterfaceIPv6.InterfaceIPv6","loopback") #TR HU66352
		#These attributes are structs where all members have a default value, thus don't need to be mandatory
		removeMandatoryAttribute("RtnTransformProfile.IpsecTransformProfile","childSaLifetime")
		removeMandatoryAttribute("RsyncRadioEquipmentClock.RadioEquipmentClock","minQualityLevel")
		removeMandatoryAttribute("RsyncRadioEquipmentClock.RadioEquipmentClockReference","adminQualityLevel")
		#TR HU86714
		addRestrictedAttribute("RtnEthernetOam.EthernetOamLocalMep","encapsulation")
		addRestrictedAttribute("RtnEthernetOam.EthernetOamLocalMep","maintenanceAssociationType")
		addRestrictedAttribute("RtnEthernetOam.EthernetOamLocalMep","maintenanceAssociationName")
		#TR HV18690
		addRestrictedAttribute("RtnTdmE1T1Port.E1T1Port","portInterfaceNumber")

		#LTE ENB attributes, same ones as in G1
		addRestrictedAttribute("Lrat.Cdma2000FreqBandRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.Cdma20001xRttBandRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.EUtranFreqRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.GeranFreqGroupRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.UtranFreqRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.UtranTDDFreqRelation","cellReselectionPriority")
		addRestrictedAttribute("Lrat.EUtranCellFDD","sectorCarrierRef")
		addRestrictedAttribute("Lrat.EUtranCellTDD","sectorCarrierRef")
		addRestrictedAttribute("Lrat.EUtranCellFDD","dlChannelBandwidth")
		addRestrictedAttribute("Lrat.EUtranCellFDD","ulChannelBandwidth")
		#http://newtran01.au.ao.ericsson.se/moshell/forum_viewtopic.php?4.8238
		addRestrictedAttribute("Lrat.EUtranCellFDD","additionalPlmnList")
		addRestrictedAttribute("Lrat.EUtranCellTDD","additionalPlmnList")
		addRestrictedAttribute("Lrat.EUtranCellFDD","additionalPlmnReservedList")
		addRestrictedAttribute("Lrat.EUtranCellTDD","additionalPlmnReservedList")

		#EventJob on Gen2
		addRestrictedAttribute("RcsPMEventM.EventJob","streamDestinationIpAddress")
		addRestrictedAttribute("RcsPMEventM.EventJob","streamDestinationPort")

	}



	addRestrictedAttribute("UtranRelation","mobilityRelationType")
	if ("Vmgw:activeGcpTransportLayer" in MoAttributesType)
	{
		addRestrictedAttribute("Vmgw","mtp3bApMoRef")
		addRestrictedAttribute("Vmgw","gcpAssociationMoRef")
	}
	if (CelloVersion < "7") { MoAttributesTypeJava["Spm:reservedBy"]="ar" } #in old CPP versions the type of Spm:reservedBy is "r" instead of "ar"
	if (CelloVersion >= "5.1")
	{
		#Add some more attributes for some MOs that are not pull MOs but those attributes happen to work
		addPushAttribute("Aal2Ap","nrOfConfiguredAal2Paths,nrOfRemotelyBlockedAal2Paths,nrOfUnavailableAal2Paths,userLabel")
		#addPushAttribute("Synchronization","syncReference,userLabel")
	}
	process_default_values()
	make_eget_list()
	make_sqlmap()
	make_attr_range_for_enums_and_structs()
	make_syscreated_table()
	add_mgw_callpathtrace()
	make_progress_attribute_table()

	#modify the attribute descriptions to show the attr_refs info
	for (i in sorted_attr_refs)
	{
		if (sorted_attr_refs[i]=="") continue
		last=split(i,array,SUBSEP)
		if (last>1)
		{
			#last can be 2 (online mode) or 3 (multimode)
			if (length(array[last-1])>maxLength["refmo"]) maxLength["refmo"]=length(array[last-1])
			if (length(array[last])>maxLength["refattr"]) maxLength["refattr"]=length(array[last])
		}
		if (i in attr_description) attr_description[i]=attr_description[i]"\nReferences: "sorted_attr_refs[i]
	}
	if (mom_version ~ /^RNC_NODE_MODEL_[H-Z]_/ && mom_version !~ /_COMPLETE$/ && use_complete_mom==0)
	{
		attribute_list["IubLink"]=attribute_list["IubLink"]",remoteSctpPortNbapC,remoteSctpPortNbapD"
		extended_attribute_list["IubLink"]=extended_attribute_list["IubLink"]",remoteSctpPortNbapC,remoteSctpPortNbapD"
		MoAttributesType["IubLink:remoteSctpPortNbapC"]=ExtendedMoAttributesType["IubLink:remoteSctpPortNbapC"]="long"
		MoAttributesType["IubLink:remoteSctpPortNbapD"]=ExtendedMoAttributesType["IubLink:remoteSctpPortNbapD"]="long"
		MoAttributesTypeJava["IubLink:remoteSctpPortNbapC"]="i"
		MoAttributesTypeJava["IubLink:remoteSctpPortNbapD"]="i"
		attr_default["IubLink","remoteSctpPortNbapC"]="5113"
		attr_default["IubLink","remoteSctpPortNbapD"]="5114"
		attr_range["IubLink","remoteSctpPortNbapC"]="1 to 65535"
		attr_range["IubLink","remoteSctpPortNbapD"]="1 to 65535"
		sorted_attribute_list["IubLink"]=sort_tableentry(attribute_list["IubLink"])
		sorted_extended_attribute_list["IubLink"]=sort_tableentry(extended_attribute_list["IubLink"])
	}
	if (mom_version ~ /^RNC_NODE_MODEL_[H-Z]_/)
	{
		for (i in Pm_attr_description)
		{
			split(i,array,SUBSEP)
			if (array[1]=="UtranRelation")
			{
				if (tolower(array[2]) ~ "cnhho") Pm_attr_description[i]=Pm_attr_description[i]"\nRelation type: Core-Network Hard HandOver"
				else if (tolower(array[2]) ~ "inter|ifho") Pm_attr_description[i]=Pm_attr_description[i]"\nRelation type: Inter-Frequency HandOver"
				else Pm_attr_description[i]=Pm_attr_description[i]"\nRelation type: Intra-Frequency HandOver"
			}
		}
	}
	if (mom_version ~ /^(MSRBS|RCS)_NODE_MODEL_/)
	{
		delete attr_range["RcsSecM.UserManagement","legalNotice"]
		sub(/,/,", ",attr_default["RcsSecM.UserManagement","legalNotice"])
		sub(/\*/,"99999999",attr_range["RcsSecM.UserManagement","loginFailureDelay"])
		#TR HV11787
		action["RcsBrM.BrmBackup","restore"]=0
		sub(/\nParameter 1: name \(string\). Name of the backup to restore./,"",actn_description["RcsBrM.BrmBackup","restore"])
	}
	process_restricted_attributes()
	#the below is not used yet as it is a non-backward compatible change, would cause the attributes to be prompted in alphabetical order in the cr command
	#sort_mom_table(mandatory_attributes)
	#sort_mom_table(restricted_attributes)
}

function sort_mom_table(thetable,   tmp_table,i)
{
	delete tmp_table
	sortTable(thetable,tmp_table)
	delete thetable
	for (i in tmp_table) thetable[i]=tmp_table[i]
}
function sort_tableentry(table_entry,      sorted_entry,array,i,last)
{
	sorted_entry=""
	split(table_entry,array,",")
	last=asort(array)
	for (i=1;i<=last;i++)
	{
		if (array[i]!=array[i-1]) sorted_entry=sprintf("%s,%s",sorted_entry,array[i])
	}
	sub(/^,/,"",sorted_entry)
	return sorted_entry
}
function make_progress_attribute_table(  i,a)
{
	if (comcli==0) return
	delete progressAttribute
	for (i in MoAttributesType)
	{
		if (MoAttributesType[i] ~ /\.AsyncActionProgress$/)
		{
			split(i,a,":")
			progressAttribute[a[1]]=a[2]
		}
	}
}
function add_mgw_callpathtrace()
{
	if (mom_version !~ "MGW_NODE_MODEL") return
	if (actn_result["Vmgw","callPathTrace"]=="") actn_result["Vmgw","callPathTrace"]="structRef:CallPathTraceStructData"
	if (actn_result["Vmgw","getTraceResult"]=="") actn_result["Vmgw","getTraceResult"]="structRef:GetTraceResultStructData"
	actn_result["Vmgw","callpathtrace"]=actn_result["Vmgw","callPathTrace"]
	actn_result["Vmgw","gettraceresult"]=actn_result["Vmgw","getTraceResult"]
	if (struct_type["CallPathTraceStructData","resultCode"] !~ /enumRef/)
	{
		struct_type["CallPathTraceStructData","resultCode"]="enumRef:CallPathTraceResultCode"
		enum["CallPathTraceResultCode",0]="SUCCESSFUL"
		enum["CallPathTraceResultCode",1]="TIMEOUT"
		enum["CallPathTraceResultCode",2]="INVALID_CONTEXT"
		enum["CallPathTraceResultCode",3]="MAX_LIMIT_REACHED"
		enum["CallPathTraceResultCode",4]="EMPTY"
	}
	if (struct_type["GetTraceResultStructData","resultCode"] !~ /enumRef/)
	{
		struct_type["GetTraceResultStructData","resultCode"]="enumRef:GetTraceResultResultCode"
		enum["GetTraceResultResultCode",0]="SUCCESSFUL"
		enum["GetTraceResultResultCode",1]="UNSUCCESSFUL"
		enum["GetTraceResultResultCode",2]="NOT_READY_YET"
	}
	if (struct_type["GetTraceResultStructData","mode"] !~ /enumRef/)
	{
		struct_type["GetTraceResultStructData","mode"]="enumRef:GetTraceResultMode"
		enum["GetTraceResultMode",0]="SEND_ONLY"
		enum["GetTraceResultMode",1]="RECEIVE_ONLY"
		enum["GetTraceResultMode",2]="SEND_RECEIVE"
		enum["GetTraceResultMode",3]="INACTIVE"
	}
	if (struct_type["GetTraceResultStructData","serviceState"] !~ /enumRef/)
	{
		struct_type["GetTraceResultStructData","serviceState"]="enumRef:GetTraceResultServiceState"
		enum["GetTraceResultServiceState",0]="ACTIVE"
		enum["GetTraceResultServiceState",1]="PASSIVE"
		enum["GetTraceResultServiceState",2]="TRANSPARENT"
	}
	if (struct_type["GetTraceResultStructData","type"] !~ /enumRef/)
	{
		struct_type["GetTraceResultStructData","type"]="enumRef:GetTraceResultType"
		enum["GetTraceResultType",1]  = "TDM"
		enum["GetTraceResultType",2]  = "AAL2-INT"
		enum["GetTraceResultType",3]  = "AAL2-EXT"
		enum["GetTraceResultType",2^3]  = msDevType[2^3]
		enum["GetTraceResultType",2^4]  = msDevType[2^4]
		enum["GetTraceResultType",2^5]  = msDevType[2^5]
		enum["GetTraceResultType",2^6]  = msDevType[2^6]
		enum["GetTraceResultType",2^7]  = msDevType[2^7]
		enum["GetTraceResultType",2^8]  = msDevType[2^8]
		enum["GetTraceResultType",2^9]  = msDevType[2^9]
		enum["GetTraceResultType",2^10] = msDevType[2^10]
		enum["GetTraceResultType",2^11] = msDevType[2^11]
		enum["GetTraceResultType",2^12] = msDevType[2^12]
		enum["GetTraceResultType",2^13] = msDevType[2^13]
		enum["GetTraceResultType",2^14] = msDevType[2^14]
		enum["GetTraceResultType",2^15] = msDevType[2^15]
		enum["GetTraceResultType",2^16] = msDevType[2^16]
		enum["GetTraceResultType",2^17] = msDevType[2^17]
		enum["GetTraceResultType",2^18] = msDevType[2^18]
		enum["GetTraceResultType",2^19] = msDevType[2^19]
		enum["GetTraceResultType",2^20] = msDevType[2^20]
		enum["GetTraceResultType",2^21] = msDevType[2^21]
		enum["GetTraceResultType",2^22] = msDevType[2^22]
		enum["GetTraceResultType",2^23] = msDevType[2^23]
		enum["GetTraceResultType",2^24] = msDevType[2^24]
		enum["GetTraceResultType",2^25] = msDevType[2^25]
		enum["GetTraceResultType",2^26] = msDevType[2^26]
	}
}
function make_syscreated_table(   i,j,k,m,array,array1,array2)
{
	delete class_syscreated
	delete has_syscreated_children
	for (i in class_description) if (class_description[i] ~ "Note: Instances of this MO class are SystemCreated.") class_syscreated[i]=1
	for (i in class_description)
	{
		if (i in class_syscreated) continue
		split(sorted_childList[i],array,";")
		for (j in array)
		{
			if (array[j] in class_syscreated)
			{
				has_syscreated_children[i]=has_syscreated_children[i]","array[j]
				split(sorted_childList[array[j]],array1,";")
				for (k in array1)
				{
					if (array1[k] in class_syscreated)
					{
						has_syscreated_children[i]=has_syscreated_children[i]","array1[k]
						split(sorted_childList[array1[k]],array2,";")
						for (m in array2)
						{
							if (array2[m] in class_syscreated)
							{
								has_syscreated_children[i]=has_syscreated_children[i]","array2[m]
							}
						}
					}
				}
			}
		}
	}
	for (i in has_syscreated_children)
	{
		sub(/^,/,"",has_syscreated_children[i])
		#print i,has_syscreated_children[i]
	}
}
function make_attr_range_for_enums_and_structs(   i,array,tmpstruct,j,array2)
{
	#the attributes of type enum do not have the range tag though they do have a valid range of values.
	#we populate the attr_range table for these attributes so that they will be caught by the diff function in case a value is not in the enum range
	for (i in enum_contents)
	{
		#enum_contents[SupportedAdminStates]=0:LOCKED, 1:UNLOCKED$
		attr_range[i]=gensub(/:[^,]+/,"","g",enum_contents[i])
		gsub(" ","",attr_range[i])
	}
	for (i in MoAttributesType)
	{
		if (MoAttributesType[i] ~ /enumRef|derivedRef/)
		{
			split(i,array,":")
			if (attr_range[array[1],array[2]] != "") continue
			attr_range[array[1],array[2]]=attr_range[gensub(/^.*(enumRef|derivedRef)./,"",1,MoAttributesType[i])]
			if (attr_range[array[1],array[2]] == "") continue
			attr_description[array[1],array[2]]=attr_description[array[1],array[2]]"\nRange: "attr_range[array[1],array[2]]
		}
	}
	for (i in struct_type)
	{
		#struct_type[RateSelectionPsInteractive,channelType]=enumRef:SupportedChannelTypes$
		if (struct_type[i] ~ /enumRef|derivedRef/)
		{
			if (attr_range[i] != "") continue
			attr_range[i]=attr_range[gensub(/^.*(enumRef|derivedRef)./,"",1,struct_type[i])]
		}
	}
	#here we also add the following entries in attr_range, eg: attr_range[moclass,attr.structmember]=range
	#probably this part is not adapted for multimode
	for (i in MoAttributesType)
	{
		#struct_type[CapacityData,value]=long$
		#struct_contents[ResMeasDef]=service,rmq$
		if (MoAttributesType[i] ~ /^structRef:/)
		{
			tmpstruct=gensub(/^structRef:/,"",1,MoAttributesType[i])
			if (tmpstruct in struct_contents && struct_contents[tmpstruct]!="")
			{
				split(struct_contents[tmpstruct],array,",")
				for (j in array)
				{
					if (sprintf("%s%s%s",tmpstruct,SUBSEP,array[j]) in attr_range && attr_range[tmpstruct,array[j]] != "")
					{
						split(i,array2,":")
						attr_range[array2[1],array2[2]"."array[j]]=attr_range[tmpstruct,array[j]]
					}
				}
			}
		}
	}
	#Include the unit specified in derivedRef in the attribute description
	if (comcli>0)
	{
		for (i in MoAttributesType)
		{
			if (MoAttributesType[i] ~ /derivedRef/)
			{
				split(i,array,":")
				if (attr_unit[array[1],array[2]] != "") continue
				#print array[1],array[2],gensub(/^.*derivedRef./,"",1,MoAttributesType[i]),attr_unit[gensub(/^.*derivedRef./,"",1,MoAttributesType[i])]
				attr_unit[array[1],array[2]]=attr_unit[gensub(/^.*derivedRef./,"",1,MoAttributesType[i])]
				if (attr_unit[array[1],array[2]] == "") continue
				attr_description[array[1],array[2]]=attr_description[array[1],array[2]]"\nUnit: "attr_unit[array[1],array[2]]
			}
		}
	}
}
function add_attr_tags(   i,last,j,array,word)
{
	for (i in Pm_attr_description)
	{
		if (Pm_attr_description[i] ~ /reset after measurement (period|interval): +([Yy]es|[Nn]o)/)
		{
			Pm_attr_comments[i]=(Pm_attr_description[i]~/measurement (period|interval): +[Yy]/?"ropReset":"noReset")","Pm_attr_comments[i]
		}
		if (Pm_attr_description[i] ~ /[cC]ounter +[Tt]ype:/)
		{
			match(Pm_attr_description[i],/[cC]ounter +[Tt]ype: +([^ \n]+)/,array)
			Pm_attr_comments[i]=array[1]","Pm_attr_comments[i]
		}
		split(i,word,SUBSEP)
		if (class_description[word[1]] ~ /Deprecated:|Obsolete:/ && Pm_attr_description[i] !~ /Deprecated:|Obsolete:/)
		{
			if (class_description[word[1]] ~ /Deprecated:/) Pm_attr_description[i]=Pm_attr_description[i]"\nDeprecated: the MO class "word[1]" is deprecated."
			else if (class_description[word[1]] ~ /Obsolete:/) Pm_attr_description[i]=Pm_attr_description[i]"\nObsolete: the MO class "word[1]" is obsolete."
		}
		if (Pm_attr_description[i] ~ /Deprecated:/) Pm_attr_comments[i]="deprecated,"Pm_attr_comments[i]
		if (Pm_attr_description[i] ~ /Obsolete:/) Pm_attr_comments[i]="obsolete,"Pm_attr_comments[i]
		if (Pm_attr_description[i] ~ /Not Implemented./) Pm_attr_comments[i]="notImplemented,"Pm_attr_comments[i]
		if (Pm_attr_description[i] ~ /Preliminary:/) Pm_attr_comments[i]="preliminary,"Pm_attr_comments[i]
		gsub(/^,|,$/,"",Pm_attr_comments[i])
	}

	for (i in attr_description)
	{
		if (tolower(attr_description[i]) ~ /ericsson *(personn*el|staff)/ && i != sprintf("RncFunction%sspare",SUBSEP))
		{
			attr_comments[i]=attr_comments[i]",EricssonOnly"
			sub(/^,/,"",attr_comments[i])
		}
		split(i,word,SUBSEP)
		if (word[1] !~ /^(Spu|Spm|AntennaUnit)$/ && class_description[word[1]] ~ /Deprecated:|Obsolete:/ && attr_description[i] !~ /Deprecated:|Obsolete:/)
		{
			#TR HV17421 (Spu/Spm) and TR HV18615 (AntennaUnit)
			if (class_description[word[1]] ~ /Deprecated:/) attr_description[i]=attr_description[i]"\nDeprecated: the MO class "word[1]" is deprecated."
			else if (class_description[word[1]] ~ /Obsolete:/) attr_description[i]=attr_description[i]"\nObsolete: the MO class "word[1]" is obsolete."
		}
		if (attr_description[i] ~ /Deprecated:/ && attr_comments[i]!~ "deprecated" && i != sprintf("%s%s%s","EUtranCellTDD",SUBSEP,"channelBandwidth"))
		{
			#TR HQ53506. the attribute EUtranCellTDD::channelBandwidth is not really deprecated, only the values 1400 and 3000 are
			attr_comments[i]="deprecated,"attr_comments[i]
			sub(/,$/,"",attr_comments[i])
		}
		if (attr_description[i] ~ /Obsolete:/ && attr_comments[i]!~ "obsolete")
		{
			attr_comments[i]="obsolete,"attr_comments[i]
			sub(/,$/,"",attr_comments[i])
		}
		if (attr_description[i] ~ /Preliminary:/ && attr_comments[i]!~ "preliminary")
		{
			attr_comments[i]="preliminary,"attr_comments[i]
			sub(/,$/,"",attr_comments[i])
		}
		if (attr_description[i] ~ /[Tt]akes +effect:/)
		{
			takes_effect[i]=gensub(/^.*[Tt]akes +effect: +/,"Takes effect: ",1,attr_description[i])
			sub(/\n.*$/,"",takes_effect[i])
		}
	}
	for (i in actn_description)
	{
		split(i,word,SUBSEP)
		if (class_description[word[1]] ~ /Deprecated:|Obsolete:/ && actn_description[i] !~ /Deprecated:|Obsolete:/)
		{
			if (class_description[word[1]] ~ /Deprecated:/) actn_description[i]=actn_description[i]"\nDeprecated: the MO class "word[1]" is deprecated."
			else if (class_description[word[1]] ~ /Obsolete:/) actn_description[i]=actn_description[i]"\nObsolete: the MO class "word[1]" is obsolete."
		}
	}

}
function clear_eget_tables()
{
	delete eget_attribute_list
	delete extended_attribute_list
	delete ExtendedMoAttributesType
	delete extended_attr_comments
	delete sorted_extended_attribute_list
	delete tolower_MoAttributesType
}
function make_eget_list(   i)
{
	#must do this even when comcli>0 because use_extended_mom is set to 1 in kget and also we might use extendedMOM on COMCLI in the future
	#if (comcli>0) return
	clear_eget_tables()
	for (i in sorted_attribute_list) extended_attribute_list[i]=sorted_attribute_list[i]
	for (i in MoAttributesType)
	{
		ExtendedMoAttributesType[i]=MoAttributesType[i]
		if (MoAttributesType[i] != "") tolower_MoAttributesType[tolower(i)]=1
	}
	for (i in attr_comments) extended_attr_comments[i]=attr_comments[i]


	egetmom=sprintf("%s/commonjars/extendedMOM.txt",moshelldir)
	if (fileOps("test -s "egetmom)!=0)
	{
		customPrint("\nExtended MOM file not found: "egetmom)
		return
	}
	close(egetmom)
	while (getline < egetmom)
	{
		gsub("\r","")
		if (NF != 6 || $1 !~ /^[A-Z]/) continue
		if (CelloVersion < $3) continue
		if ($5 != "-" && CelloVersion >= $5) continue
		if ($4 ~ /^[A-Z]/ && mom_version !~ sprintf("^(TD|MRS)?%s",$4)) continue
		if (tolower($1":"$2) in tolower_MoAttributesType) continue
		if ($6 ~ /^[A-Z]/ && gensub(/^[^_]+_NODE_MODEL_/,"",1,mom_version) < $6) continue
		eget_attribute_list[$1]=eget_attribute_list[$1]","$2
		extended_attribute_list[$1]=extended_attribute_list[$1]","$2
		#if (use_extended_mom==1) ExtendedMoAttributesType[$1":"$2]="long"
		ExtendedMoAttributesType[$1":"$2]="long"
		extended_attr_comments[$1,$2]="readOnly"
	}
	close(egetmom)
	if ((mom_version ~ "RNC_NODE_MODEL") && (mom_version >= "RNC_NODE_MODEL_V_2_" || mom_version ~ "RNC_NODE_MODEL_V_[0-9][0-9]+_"))
	{
		#Attributes cellReselectionCntr/handoverOnlyCntr available from CXP9021775-R2BA32
		eget_attribute_list["UtranCell"]=eget_attribute_list["UtranCell"]",cellReselectionCntr,handoverOnlyCntr"
		extended_attribute_list["UtranCell"]=extended_attribute_list["UtranCell"]",cellReselectionCntr,handoverOnlyCntr"
		#if (use_extended_mom==1) ExtendedMoAttributesType[$1":"$2]="long"
		ExtendedMoAttributesType["UtranCell:cellReselectionCntr"]="long"
		ExtendedMoAttributesType["UtranCell:handoverOnlyCntr"]="long"
		extended_attr_comments["UtranCell","cellReselectionCntr"]="readOnly"
		extended_attr_comments["UtranCell","handoverOnlyCntr"]="readOnly"
	}
	for (i in eget_attribute_list) sub(/^,/,"",eget_attribute_list[i])
	sortTable(eget_attribute_list,sorted_eget_attribute_list)
	sortTable(extended_attribute_list,sorted_extended_attribute_list)
}
function clear_sqlmap_tables()
{
	delete sqlMapFro
	delete sqlMapTable
	delete sqlMapTableList
	delete sqlMapIndex
	delete rlibMapTable
	delete rlibFuncTable
	delete sqlMapIndex2
	delete sqlMapPrio
	delete sqlPrioList
	delete sqlMapToMos
	delete sqlMapBack
	delete sqlMapMoArray
	delete sqlMapTo
	delete sqlMapResattr
	delete sqlMapParentIndex
	delete sqlMapFroMo
	delete sqlMapFroFro
	delete sqlParentTable
	delete sqlFroType
	delete sqlNoFro
	delete sqlRealTableList
}
function make_sqlmap(     array,i,resattr,tattr,start,tstop,d)
{
	if (comcli>0) return
	clear_sqlmap_tables()
	rlibmapfile=sprintf("%s/commonjars/rlibRncLicensingConstData.h",moshelldir)
	rlibfuncmap=sprintf("%s/commonjars/rlibRncUeFunctionalitiesConstData.h",moshelldir)
	if (fileOps("test -s "rlibmapfile)!=0)
	{
		customPrint("\nRLIB Map file not found: "rlibmapfile)
		return
	}
	while (getline < rlibmapfile)
	{
		#const int rlibIdHsdpaMobilityPhase1                = 1; // HSDPA Mobility Phase 1
		gsub("\r","") ; gsub(/#.*$/,"") ; gsub(/\/.*$/,"")
		if ($1=="const" && $2=="int" && $4=="=") rlibMapTable[gensub(/;/,"",1,$5)+0]="Licensing=1,RncFeature="gensub(/^rlibId/,"",1,$3)
	}
	close(rlibmapfile)
	if (fileOps("test -s "rlibfuncmap)!=0)
	{
		customPrint("\nRLIB Functionalities Map file not found: "rlibfuncmap)
		return
	}
	while (getline < rlibfuncmap)
	{
		#const int rlibIdFDpch                              = 1; // SRB on HSDPA and F-DPCH
		gsub("\r","") ; gsub(/#.*$/,"") ; gsub(/\/.*$/,"")
		if ($1=="const" && $2=="int" && $4=="=") rlibFuncTable[gensub(/;/,"",1,$5)+0]="Licensing=1,RncFeature=AdvancedDiffUeHandling,UeFunctionality="gensub(/^rlibId/,"",1,$3)
	}
	close(rlibfuncmap)
	sqlmapfile=sprintf("%s/commonjars/sqlMap.txt",moshelldir)
	if (fileOps("test -s "sqlmapfile)!=0)
	{
		customPrint("\nSQL Map file not found: "sqlmapfile)
		return
	}
	close(sqlmapfile)
	#print "CELLOVERSION:"CelloVersion
	while (getline < sqlmapfile)
	{
		gsub("\r","") ; gsub(/#.*$/,"")
		if (!($1=="-" || mom_version ~ sprintf("^(TD|MRS)?%s",$1))) continue
		if (CelloVersion < $2) continue
		if ($1=="RBS" && $3=="SystemConstants" && mom_version !~ /^RBS_NODE_MODEL_U_[4-9]_/) continue
		sqlMapFro[$3]=$4
		if (dbdat) MoAttributesType[$3":"$4]="froId"
		if (NF < 5) continue
		sqlMapTable[$3]=$5
		sqlMapTableList[$5]=1
		if (NF < 6) continue
		#the 6th word has the name of the index field of the fro table.
		#when AIR as one unit is used, there can be another field of the fro table that will be used as index, eg the table ecxpuauxpiudata (AuxPlugInUnit) can have the field airpiufroid as fro index
		split($6,d,",")
		$6=d[1]
		sqlMapIndex[$3]=$6
		sqlMapIndex[$5]=$6
		if (dbdat) MoAttributesType[$3":"$6]="froid"
		#Special fields intended for AIR as one unit where some MOs have several FROs (AuxPlugInUnit, DeviceGroup, DeviceSet)
		#the word in position 6 (froIndex) can have additional fields for alternative froIndex and sql table priority
		#the alternative froIndex indicates that the froId is not stored in theclientsuniqueid but in some other field
		#the priority field (sqlMapPrio) indicates the fro tables that have to be parsed first because we need to read the parent MOs before the children in order to get the froIds correctly
		#AuxPlugInUnit: ecxpuauxpiudata (alternative froIndex: airpiufroid  , priority 1)
		#DeviceGroup:  ecgrpresmgrdata (alternative froIndex: containerfroid,  priority 2)
		#DeviceSet: ecsetdevsetdata (alternative froIndex: airsetfroid,  priority unspecified)
		if (d[2]!="")
		{
			sqlMapIndex2[$3]=d[2]
			sqlMapIndex2[$5]=d[2]
		}
		if (d[3]!="") { sqlMapPrio[$5]=d[3] ; sqlPrioList[d[3]]=d[3] }
		if (NF < 7) continue
		sqlMapParentIndex[$3]=$7
		if (dbdat) MoAttributesType[$3":"$7]="parentid"
		sqlParentTable[$3,$7]=1
	}
	close(sqlmapfile)
	#Node Ver MoClass      froId        sqlTable        sqlIndex
	#-     0  Aal0TpVccTp  aal0CepFroId aal0cepfrotable froid
	#sqlMapFro[Aal0TpVccTp]=aal0CepFroId
	#sqlMapTable[Aal0TpVccTp]=aal0cepfrotable
	#sqlMapTableList[aal0cepfrotable]=1
	#sqlMapIndex[Aal0TpVccTp]=froid
	#sqlParentTable[VclTp,vpcepfroid]=1  (pointer to the parent froid)
	sqlrefmapfile=sprintf("%s/commonjars/sqlRefMap.txt",moshelldir)
	while (getline < sqlrefmapfile)
	{
		gsub("\r","") ; gsub(/#.*$/,"")
		if (!($1=="-" || mom_version ~ $1)) continue
		if (CelloVersion < $2) continue
		if (NF < 6) continue
		if ($5 ~ /\[[0-9]/)
		{
			#RNC 0 CnOperator          equivalentPlmnIdentityGroupRef               equivalentplmnidentitygroupfroid_[0-31]         PlmnIdentityGroup
			tattr=gensub(/\[.*$/,"",1,$5)
			tstart=gensub(/^.*\[|-.*$/,"","g",$5)+0
			tstop=gensub(/^.*-|\]$/,"","g",$5)+0
			for (i=tstart;i<=tstop;i++)
			{
				if (i==tstart)
				{
					sqlMapMoArray[$3]=1
					sqlMapMoArray[$3,$4]=tstart"-"tstop
				}
				sqlMapMoArray[$3,sprintf("%s%s",tattr,i)]=$4
				#print "sqlMapMoArray["$3","sprintf("%s%s",tattr,i)"]="$4
			}
			continue
		}
		if ($4 != "-" && $5 != "-")
		{
			if (dbdat) MoAttributesType[$3":"$5]="froRef:"$4
			sqlMoRefTable[$3,$5]=$4
		}
		if ($6 == "-") continue
		#the table sqlMapFroMo is used for translation of FroId to LDN
		if ($6 ~ ",") { if ($4 != "-") sqlMapFroMo[$3,$5]=$4 }
		else sqlMapFroMo[$3,$5]=$6
		sqlMapFroMo[$6]=1
		#table used to list the moref attributes that are stored in FRO only, used for the check "FRO pointing to non-existing FRO"
		if ($4=="-") sqlMapFroFro[$3,$5]=$6

		if ($7=="nocheck") continue
		if ($4 != "-") sqlMapTo[$3,$4]=1   #we use the mao attr for the "to" relation
		else sqlMapTo[$3,$5]=$6  #we use the fro attr, eg for usaalid_2. Here there cannot be commas in $6
		sqlMapToMos[$3]=1
		split($6,array,",")
		for (i in array)
		{
			resattr="reservedBy"
			if ($7 ~ /^reservedBy/) resattr=$7
			if (array[i]=="PlugInUnit") resattr="reservedByList"
			else if (array[i]=="EthernetLink") resattr="reservedBy"  #must be specified because on same line as IpAtmLink which uses reservedByOspf
			sqlMapBack[array[i],resattr]=1
			sqlMapResattr[array[i]]=resattr
		}
	}
	close(sqlrefmapfile)
	#special case, hardcoded: when the attribute IpAccessHostSpb::spmid points to a PiuDevice:
	sqlMapTo["IpAccessHostSpb","spmid"]="PiuDevice"
	sqlMapToMos["IpAccessHostSpb"]=1
	sqlMapBack["PiuDevice","reservedBy"]=1
	sqlMapResattr["PiuDevice"]="reservedBy"

	#sqlMoRefTable[Aal2Ap,mtp3id]=sigLinkId
	#sqlMoRefTable[Aal2Ap,usaalid_1]=sigLinkId
	#sqlMapFroMo[Aal2Ap,usaalid_1]=UniSaalTp   #if there is only one possible MoType
	#sqlMapFroMo[UtranCell,nutrancellfroid]=utranCellRef  #if there are several MoTypes in the 6th column, eg UtranCell,ExternalUtranCell, we use the mao attribute to find the MO type

	#sqlMapFroFro[Aal5TpVccTp,resourceid]=PlugInUnit,Spm   #table used to list the moref attributes that are stored in FRO only, used for the check "FRO pointing to non-existing FRO"

	#sqlMapTo[Aal2Ap,sigLinkId]=1          #"to", using mao
	#sqlMapTo[Aal2Ap,usaalid_1]=UniSaalTp  #"to", using fro (when no mao attr for the to relation)
	#sqlMapBack[UniSaalTp,reservedBy]=1    #"back", always using mao
}
function process_default_values(   j,array,last,i,array2,tmpstruct)
{
	for (j in attr_default)
	{
		if (attr_default[j] ~ /^-?[0-9]+/) continue
		split(j,array,SUBSEP)
		if (array[1]":"array[2] in MoAttributesType)
		{
			if (MoAttributesType[array[1]":"array[2]]~/^enumRef:/)
			{
				match(enum_contents[gensub(/^enumRef:/,"",1,MoAttributesType[array[1]":"array[2]])],sprintf("(-?[0-9]+):%s(,|$)",attr_default[j]),array)
				if (1 in array) attr_default[j]=array[1]" ("attr_default[j]")"
			}
			else if (MoAttributesType[array[1]":"array[2]]~/^sequence:enumRef-/)
			{
				last=split(attr_default[j],array2,",")
				attr_default[j]=""
				for (i=1;i<=last;i++) attr_default[j]=attr_default[j]" "enum[gensub(/^sequence:enumRef-/,"",1,MoAttributesType[array[1]":"array[2]]),array2[i]]
				sub(/^ /,"",attr_default[j])
			}
		}
		else if (j in struct_type && struct_type[j] ~ /^enumRef:/)
		{
			if (attr_default[j]~/^[A-Z]/) attr_default[j]=enum[gensub(/^enumRef:/,"",1,struct_type[j]),attr_default[j]]" ("attr_default[j]")"
		}
	}
	for (j in MoAttributesType)
	{
		if (MoAttributesType[j] !~ /^structRef:/) continue
		tmpstruct=(multi==1?gensub(sprintf("%s.*$",SUBSEP),SUBSEP,1,j):"") gensub(/^structRef:/,"",1,MoAttributesType[j])
		last=split(struct_contents[tmpstruct],array,",")
		struct_default_value[j]="Struct{"last"}"
		for (i=1;i<=last;i++)
		{
			struct_default_value[j]=struct_default_value[j]"\n >>> "i"."array[i]" = "attr_default[tmpstruct,array[i]]
		}
		#print j,struct_default_value[j]
	}
}
function addPushAttribute(moClass,attributeName,   array,i,tmplist,last)
{
	#attributeName can be:
	#  -  one attribute, eg: addPushAttribute("Aal2Ap","userLabel")
	#  -  several attributes, separated by spaces, eg: addPushAttribute("Aal2Ap","nrOfConfiguredAal2Paths,userLabel")
	#  -  "all", eg: addPushAttribute("Aal2Ap","all")
	if (multi) moClass=sprintf("%s%s%s",mom_version,SUBSEP,moClass)
	pull_molist[moClass]=moClass
	#split(sorted_pull_attrlist[moClass],array,",")
	#for (i in array) tmplist[tolower(array[i])]=1

	#we just overwrite the existing entry instead of appending
	delete sorted_pull_attrlist[moClass]
	if (attributeName=="all")
	{
		last=split(sorted_attribute_list[moClass],array,",")
	}
	else
	{
		last=split(attributeName,array,",")
	}
	last=asort(array)
	for (i=1;i<=last;i++)
	{
		attributeName=array[i]
		if (!(tolower(attributeName) in tmplist)) sorted_pull_attrlist[moClass]=sorted_pull_attrlist[moClass]","attributeName
	}
	sub(/^,/,"",sorted_pull_attrlist[moClass])

	#split(sorted_mom_list["pull_mo"],array,",")
	#for (i in array) tmplist[tolower(array[i])]=1
	#if (!(tolower(moClass) in tmplist)) sorted_mom_list["pull_mo"]=sorted_mom_list["pull_mo"]","moClass
	#sub(/^,/,"",sorted_mom_list["pull_mo"])

	#print "MOSHELLDEBUG: "moClass" "sorted_pull_attrlist[moClass]
	#print "MOSHELLDEBUG: "sorted_mom_list["pull_mo"]
}
function addRestrictedAttribute(moClass,attributeName,  array,i,tmplist,a)
{
	if (comcli>0)
	{
		#on 5G, the MIM name can have a suffix like _PA1 or SPA1 or PA1
		#mimNames[RtnSctpProfile_PA1] = 33
		#mimNames[LratSPA1] = 3
		#mimNames[LratSectorPA1] = 7
		#mimNames[LratScPA1] = 6
		#mimNames[LratBpPA1] = 5
		split(moClass,a,".")
		if (!(a[1] in mimNames && mimNames[a[1]]!=""))
		{
			for (i in mimNames)
			{
				if (i ~ sprintf("^%s(_[^_]+|S?PA[1-9])$",a[1]))
				{
					moClass=i"."a[2]
					break
				}
			}
		}
	}
	if (multi) moClass=sprintf("%s%s%s",mom_version,SUBSEP,moClass)
	if (!(sprintf("%s:%s",moClass,attributeName) in MoAttributesType)) return
	if (exclude_deprecated>0 && attr_comments[moClass,attributeName] ~ /deprecated|obsolete/) return
	#add the attribute only if it is not already restricted or mandatory
	delete tmplist ; delete array ; i=0
	if (moClass in restricted_attributes)
	{
		split(restricted_attributes[moClass],array,",")
		for (i in array) tmplist[tolower(array[i])]=1
	}
	if (moClass in mandatory_attributes)
	{
		split(mandatory_attributes[moClass],array,",")
		for (i in array) tmplist[tolower(array[i])]=1
	}
	if (!(tolower(attributeName) in tmplist)) restricted_attributes[moClass]=restricted_attributes[moClass]","attributeName
	if (moClass in restricted_attributes)
	{
		sub(/^,/,"",restricted_attributes[moClass])
		#print "MOSHELLDEBUG: "moClass" "restricted_attributes[moClass]
	}
}
function removeMandatoryAttribute(moClass,attributeName,   array,i,last)
{
	if (multi) moClass=sprintf("%s%s%s",mom_version,SUBSEP,moClass)
	if (!(sprintf("%s:%s",moClass,attributeName) in MoAttributesType)) return
	if (attr_comments[moClass,attributeName] !~ "mandatory") return
	#print "\nDEBUG_BEFORE: "moClass,attributeName,mandatory_attributes[moClass],attr_comments[moClass,attributeName]
	last=split(mandatory_attributes[moClass],array,",")
	delete mandatory_attributes[moClass]
	for (i=1;i<=last;i++) if (array[i]!=attributeName) mandatory_attributes[moClass]=mandatory_attributes[moClass]","array[i]
	sub(/^,/,"",mandatory_attributes[moClass])
	last=split(attr_comments[moClass,attributeName],array,",")
	delete attr_comments[moClass,attributeName]
	for (i=1;i<=last;i++) if (array[i]!="mandatory") attr_comments[moClass,attributeName]=attr_comments[moClass,attributeName]","array[i]
	sub(/^,/,"",attr_comments[moClass,attributeName])
	#print "\nDEBUG_AFTER: "moClass,attributeName,mandatory_attributes[moClass],attr_comments[moClass,attributeName]
}
function process_restricted_attributes(      i,n,a,tmp_restricted_attributes,j)
{
	#in the MGW incomplete MOM the M3uAssociaton::dscp has an additional mandatory tag that can sometimes be after the restricted tag
	#which can lead to this attribute getting included in both tables mandatory_attributes and restricted_attributes
	#this getting prompted twice in cr command
	#so here we check the restricted_attributes_table and take away attributes that are already in the mandatory_attributes table
	for (i in restricted_attributes)
	{
		n=split(restricted_attributes[i],a,",")
		for (j=1;j<=n;j++)
		{
			if (i in mandatory_attributes && mandatory_attributes[i] ~ sprintf("(^|,)%s($|,)",a[j]))
			{
				#print i,a[j]
				continue
			}
			tmp_restricted_attributes[i]=tmp_restricted_attributes[i]","a[j]
		}
	}
	delete restricted_attributes
	for (i in tmp_restricted_attributes) restricted_attributes[i]=gensub(/^,/,"",1,tmp_restricted_attributes[i])
}

#dump out arrays and surround with psuedo xml tags <..> and </..>
#works fine for multidimentional arrays because gawk thinks of these as single
#dimentional arrays anyhow...
function dump_array(array,arrayname,file,  var)
{
	print "<MomTable= "arrayname">" >> file;
	for (var in array)
	{
		print "<"var">\n" array[var] "\n</"var">" >> file;
	}
	print "</" arrayname ">" >> file;
}

#this guy reads in the file mom_file_cache and fills all the internal variables
#and arrays which are extracted from the MOM file.
function read_mom_cache(mom_file_cache   ,var,value,arrayname,readmom_command,cache_req,tmp_mom_file_cache,cp_com)
{

	#we must clear the mom tables in normal mode otherwise when switching between MOMs with "parsemom" we keep old entries
	#but we cannot have in multi mode when several MOM versions are used otherwise only one MOM version is loaded
	if (nrOfMomVersions < 2) clear_mom_tables()

	delete cache_req
	if (mom_file_cache !~ /.gz$/ && fileOps("test -s "mom_file_cache".gz")==0) mom_file_cache=mom_file_cache".gz"

	#check cache version and file completeness
	#the first line of the file is the MOM CACHE version, eg:
	#MOSHELL_MOM_CACHE_VERSION 1    (the version number has to be an integer: 1, 2, 3, ...)
	if (fileOps("test -s "mom_file_cache)!=0) return 1

	tmp_mom_file_cache=tempdir"/"gensub(/^.*\//,"",1,mom_file_cache)
	cp_com="cp "mom_file_cache" "tmp_mom_file_cache
	#customPrint(cp_com)
	fileOps(cp_com)
	if (fileOps("test -s "tmp_mom_file_cache)!=0) return 1
	if (tmp_mom_file_cache ~ /.cache.gz$/)  readmom_command="gzip -dc "tmp_mom_file_cache
	else readmom_command="cat "tmp_mom_file_cache

	while (readmom_command |& getline)
	{
		#we do a check for completeness of the cached MOM: That the beginning and end of the file are there and also that the mom_version field is there
		#and also that there are not a bunch of null characters which can happen if the file got corrupted somewhere in the middle
		if ($1=="MOSHELL_MOM_CACHE_VERSION" && $2 == supported_cache_version) cache_req["ver"]=1
		else if ($1=="END_MOSHELL_MOM_CACHE") cache_req["end"]=1
		else if ($1=="mom_version:" && NF>1) cache_req["momver"]=1
		else if ($0 ~ /\x000\x000\x000\x000\x000\x000/) cache_req["null"]=1
		else if ($1=="mimCounter:" && $NF==1) cache_req["mimcounter"]=1  #This happens if a Gen1 MOM was parsed in a Gen2 node, using the command "parsemom"
	}
	close(readmom_command)
	if (cache_req["ver"] != 1 || cache_req["end"] != 1 || cache_req["momver"] != 1 || cache_req["null"]==1 || cache_req["mimcounter"]==1)
	{
		fileOps("rm "mom_file_cache)
		fileOps("rm "tmp_mom_file_cache)
		return 1
	}

	customPrint("Parsing MOM (cached): "tmp_mom_file_cache" ","","","noLF")

	#grab the first "known" variables which are not arrays
	readmom_command |& getline;
	readmom_command |& getline; CelloVersion=gensub(/^[^0-9]*/,"",1,$2);  #for cases where the cello version happens to start with a non numerical
	readmom_command |& getline; mom_version=$2
	readmom_command |& getline; cdmaMOM=$2
	readmom_command |& getline; momdocnumber=gensub("momdocnumber: ","",1,$0)
	readmom_command |& getline; momdocrevision=$2
	readmom_command |& getline; mimCounter=$2
	readmom_command |& getline; ComVersion=$2
	readmom_command |& getline; MeRelease=$2
	if (mimCounter > 0 && comcli==0) comcli=1

	#now grab all the array data...
	while (readmom_command |& getline)
	{
        	gsub("\r","") ; gsub("\x000","")
        	if (mosdebug==0) show_progress(500)
        	if ($1=="<MomTable=") arrayname=gensub(/>/,"",1,$2)
        	else if (/^<[^\/].*>$/)
        	{
        		var=gensub(/<|>/,"","g",$0)
        		if (multi) var=sprintf("%s%s%s",mom_version,SUBSEP,var)
        		value=""
			#read in variable for array. Do not exit this if statement until we
			#have the whole variable (it can be many lines long). This speeds up
			#the reading in by a factor of 2
			while (readmom_command |& getline)
			{
				if (!(/^<\//)) { value = value $0 "\n"; }
				else
				{
					gsub(/\n$/,"",value);
					if (arrayname == "class_description")            	class_description[var] = value
					else if (arrayname == "attr_refs")        	        attr_refs[var] = value
					else if (arrayname == "attr_description")        	attr_description[var] = value
					else if (arrayname == "attr_default")        	        attr_default[var] = value
					else if (arrayname == "attr_range")        	        attr_range[var] = value
					else if (arrayname == "attr_unit")        	        attr_unit[var] = value
					else if (arrayname == "attr_length")        	        attr_length[var] = value
					else if (arrayname == "actn_description")        	actn_description[var] = value
					else if (arrayname == "actn_result")        	        actn_result[var] = value
					else if (arrayname == "actn_deprecated")        	actn_deprecated[var] = value
					else if (arrayname == "struct_with_moref")        	struct_with_moref[var] = value
					else if (arrayname == "enum_description")        	enum_description[var] = value
					else if (arrayname == "struct_description")      	struct_description[var] = value
					else if (arrayname == "Pm_attr_description")     	Pm_attr_description[var] = value
					else if (arrayname == "Log_attr_description")    	Log_attr_description[var] = value
					else if (arrayname == "attr_comments")           	attr_comments[var] = value
					else if (arrayname == "Pm_attr_comments")           	Pm_attr_comments[var] = value
					else if (arrayname == "struct_contents")  		struct_contents[var] = value
					else if (arrayname == "sorted_struct_contents")         sorted_struct_contents[var] = value
					else if (arrayname == "struct_key")  		        struct_key[var] = value
					else if (arrayname == "enum")		 		enum[var] = value
					else if (arrayname == "enum_contents")  		enum_contents[var] = value
					else if (arrayname == "attribute_list") 		attribute_list[var] = value
					else if (arrayname == "action")  		        action[var] = value
					else if (arrayname == "action_list")  			action_list[var] = value
					else if (arrayname == "Pm_attribute_list")  		Pm_attribute_list[var] = value
					else if (arrayname == "Log_attribute_list") 		Log_attribute_list[var] = value
					else if (arrayname == "mandatory_attributes")  		mandatory_attributes[var] = value
					else if (arrayname == "restricted_attributes") 		restricted_attributes[var] = value
					else if (arrayname == "sorted_attribute_list") 		sorted_attribute_list[var] = value
					else if (arrayname == "sorted_action_list")  		sorted_action_list[var] = value
					else if (arrayname == "sorted_Pm_attribute_list")  	sorted_Pm_attribute_list[var] = value
					else if (arrayname == "sorted_Log_attribute_list")  	sorted_Log_attribute_list[var] = value
					else if (arrayname == "struct_type")  			struct_type[var] = value
					else if (arrayname == "MoAttributesType")  		MoAttributesType[var] = value
					else if (arrayname == "PmAttributesType")  		PmAttributesType[var] = value
					else if (arrayname == "MoAttributesTypeJava")  		MoAttributesTypeJava[var] = value
					#else if (arrayname == "PmAttributes")  			PmAttributes[var] = value
					else if (arrayname == "LogAttributes") 			LogAttributes[var] = value
					else if (arrayname == "childList")   			childList[var] = value
					else if (arrayname == "parentList")  			parentList[var] = value
					else if (arrayname == "sorted_childList")   		sorted_childList[var] = value
					else if (arrayname == "sorted_parentList")  		sorted_parentList[var] = value
					else if (arrayname == "deprecatedRelationship")  	deprecatedRelationship[var] = value
					else if (arrayname == "cardinality")  			cardinality[var] = value
					else if (arrayname == "pull_molist")                    pull_molist[var] = value
					else if (arrayname == "sorted_pull_attrlist")           sorted_pull_attrlist[var] = value
					else if (arrayname == "mom_moclass_list")               mom_moclass_list[var] = value
					else if (arrayname == "tolower_mom_moclass_list")       tolower_mom_moclass_list[var] = value
					else if (arrayname == "pdf_counter_table")              pdf_counter_table[var] = value
					else if (arrayname == "hidden_attributes")              hidden_attributes[var] = value
					else if (arrayname == "derived_description")            derived_description[var] = value
					else if (arrayname == "derived_type")                   derived_type[var] = value
					else if (arrayname == "momVersionComponents")           momVersionComponents[var] = value
					else if (arrayname == "ecimVersionComponents")          ecimVersionComponents[var] = value
					else if (arrayname == "mimComponents")                  mimComponents[var] = value
					else if (arrayname == "momParts")                       momParts[var] = value
					else if (arrayname == "ecimMomName")                    ecimMomName[var] = value
					else if (arrayname == "mimNames")                       mimNames[var] = value
					else if (arrayname == "ecimMomVer")                     ecimMomVer[var] = value
					else if (arrayname == "takes_effect")                   takes_effect[var] = value
					break
				}
			}
		}
	}
	close(readmom_command)
	customPrint("Done.")
	momfinish()
	if (mosdebug==2) print_mom_tables()
	return 0
}

function sort_out_double_parents(  moclass,i,array,me)
{
	for (moclass in childList) childList[moclass]=childList[moclass]";"
	me="ManagedElement"
	#if (comcli>0) me=t2ecimt("ManagedElement")    --> screws up mimMap dont know why - maybe it works ok now that we put a $ in t2ecim function
	split(childList[me],array,";")
	for (i in array)
	{
		if (array[i] == "") continue
		for (moclass in childList)
		{
			if (moclass != me)
			{
				if (childList[moclass] ~ sprintf(";%s;",array[i]))
				{
					#print childList[moclass],array[i]
					array[i]=""
				}
			}
		}
	}
	childList[me]=""
	for (i in array)
	{
		if (array[i] != "") childList[me]=childList[me]";"array[i]
	}
	for (moclass in childList) gsub(/^;|;$/,"",childList[moclass])
}
function sort_childparentLists( moclass,n,array,i)
{
	delete sorted_childList
	delete sorted_parentList
	for (moclass in childList)
	{
		split(childList[moclass],array,";")
		n=asort(array)
		for (i=1;i<=n;i++)
		{
			if (array[i] != array[i-1]) sorted_childList[moclass]=sorted_childList[moclass]";"array[i]
		}
	}
	for (moclass in sorted_childList)
	{
		gsub(/^;|;$/,"",sorted_childList[moclass])
		#print moclass,sorted_childList[moclass]
	}
	for (moclass in parentList)
	{
		split(parentList[moclass],array,";")
		n=asort(array)
		for (i=1;i<=n;i++)
		{
			if (array[i] != array[i-1]) sorted_parentList[moclass]=sorted_parentList[moclass]";"array[i]
		}
	}
	for (moclass in sorted_parentList)
	{
		gsub(/^;|;$/,"",sorted_parentList[moclass])
		#remove the ManagedElement from the sorted_parentlist if there are other parents in the list
		n=split(sorted_parentList[moclass],array,";")
		sorted_parentList[moclass]=""
		for (i=1;i<=n;i++)
		{
			if (array[i]=="ManagedElement" && n > 1) continue
			sorted_parentList[moclass]=sorted_parentList[moclass]";"array[i]
		}
		gsub(/^;|;$/,"",sorted_parentList[moclass])
		#print moclass,sorted_parentList[moclass]
	}
}
function showParentsWrapper(mo,level,resTable,globalResTable,countTable,     i,j,tmpTable,n,lengthList)
{
	delete resTable
	delete globalResTable
	delete countTable
	showParents(mo,level,resTable,globalResTable,countTable,mo)
	#remove duplicates and lines sort by length
	for (i=1;i<=countTable["global"];i++)
	{
		tmpTable[globalResTable[i]]=globalResTable[i]
		lengthList[length(globalResTable[i])]=length(globalResTable[i])
	}
	n=asort(lengthList)
	for (i=1;i<=n;i++)
	{
		#print "LENGTH:",i,lengthList[i]
		for (j in tmpTable)
		{
			if (length(j)==lengthList[i]) customPrint(j)
		}
	}
}
function showParents(mo,level,resTable,globalResTable,countTable,startMo,      array,i,last,j,latest_j_value,mefilter)
{
	if (comcli>0) mefilter=".ManagedElement$"
	else mefilter="^ManagedElement$"
	last=split(sorted_parentList[mo],array,";")
	#print mo,sorted_parentList[mo]
	for (i=1;i<=last;i++)
	{
		#print i,last,mo,array[i]
		resTable[++countTable["local"]]=array[i]
		if (array[i] ~ mefilter)
		{
			countTable["global"]++
			for (j=countTable["local"];j>=1;j--)
			{
				if (j in resTable && resTable[j] !~ mefilter)
				{
					globalResTable[countTable["global"]]=globalResTable[countTable["global"]]","resTable[j]"["cardinality[resTable[j+1],resTable[j]]"]"
					latest_j_value=j
				}
			}
			#print "latest_j_value="latest_j_value
			globalResTable[countTable["global"]]=globalResTable[countTable["global"]]","startMo"["cardinality[resTable[latest_j_value],startMo]"]"
			sub(/^,/,"",globalResTable[countTable["global"]])
			delete resTable
			countTable["local"]=0
		}
		showParents(array[i],level+10,resTable,globalResTable,countTable,startMo)
	}
	#for (i=1;i<=last;i++)
	#{
	#	customPrint(sprintf("%-*s%s",level,"",array[i]))
	#	showParents(array[i],level+10)
	#}
}
function makeMimMapping(mo,parent,    last,array,i,part,moclass,parentString,a,z,j)
{
	if (comcli==0) return
	if (mo=="")
	{
		delete mimMap
		delete mimRelsDone
		last=split(sorted_mom_list["moclass"],array,",")
		for (i=1;i<=last;i++)
		{
			if (array[i] ~ /(^|\.)ManagedElement$/)
			{
				mo=array[i]
				split(mo,part,".")
				mimMap["."part[2]]=part[1]
				break
			}
		}
	}
	moclass=gensub(/^.*\./,"",1,mo)

	#The parentString consists of the last 6 parts of the parent
	#Example: The NextHop MO can be under Host.RouteTableIPv4Static.Dst or Router.RouteTableIPv4Static.Dst
	#mimMap[.ManagedElement.Transport.Host.RouteTableIPv4Static.Dst.NextHop] = RtnRoutesStaticRouteIPv4
	#mimMap[.ManagedElement.Transport.Router.RouteTableIPv4Static.Dst.NextHop] = RtnRoutesStaticRouteIPv4
	#for this case we had to go all the way to the grandparent (3 levels) which can be Host or Router

	parentString=""
	z=split(parent,a,".")
	#LoopyMOs=".(SchedulerSp|QueueRed|QueueTailDrop|SchedulerDwrr|Shaper)$"  #MO classes in ECIM MOM that can cause endless loops in the "momt" and "momc" command
	if (z>20) return  #Avoid entries containing very long string, most likely this would be due to a loop in the MOM structure
	#special case with the know MO classes that loop around each other
	if (z>9 && mo ~ LoopyMOs) return
	for (j=z;j>=(z-6);j--) parentString=a[j]"."parentString
	gsub(/\.+/,".",parentString) #remove duplicated dots which happen when a parent has less than 6 components
	gsub(/^\.|\.$/,"",parentString)
	last=split(sorted_childList[mo],array,";")
	#Note: here maybe some more levels will be needed to include in mimRelsDone, such as grandgrandparent etc
	for (i=1;i<=last;i++)
	{
		#avoid going in a loop, some MOs can be parents and child with each other, eg:
		#<relationship name="SchedulerDwrr_to_Policer">
		#<relationship name="Policer_to_SchedulerDwrr">
		#therefore we use mimRelsDone which keeps track of which containment relations we've already done

		#print parentString,mo,array[i]
		if (mimRelsDone[parentString,mo,array[i]]==1) continue
		mimRelsDone[parentString,mo,array[i]]=1
		split(array[i],part,".")
		mimMap[parent"."moclass"."part[2]]=part[1]
		makeMimMapping(array[i],parent"."moclass)
	}
	#delete the global table after completion
	if (mo=="") delete mimRelsDone
}
function makeSimpleMimMapping(    i)
{
	#make a table simpleMimMap[moclass]=mim
	#eg: mimMap[.ManagedElement.Transport.Host.RouteTableIPv4Static.Dst.NextHop] = RtnRoutesStaticRouteIPv4
	#becomes: simpleMimMap[NextHop] = RtnRoutesStaticRouteIPv4
	#this is used for PM
	delete simpleMimMap
	for (i in mimMap) simpleMimMap[gensub(/^.*\./,"",1,i)]=mimMap[i]
	#workaround for MpProcessingResource
	if (simpleMimMap["MpProcessingResource"]=="") simpleMimMap["MpProcessingResource"]="Lrat"
}
function showChildren(mo,level,parentmo,what,parentC,outputTable,   array,i,last,tmpclass,output,ldn,forbiddenLdns,z,nok)
{
	forbiddenLdns["PiuDevice,ExchangeTerminalIp,EthernetSwitch"]=1
	forbiddenLdns["PiuDevice,ExchangeTerminalIp,InternalEthernetPort"]=1
	forbiddenLdns["PlugInUnit,Lag,SwitchPortStp"]=1
	last=split(sorted_childList[mo],array,";")
	for (i=1;i<=last;i++)
	{
		if (comcli>0)
		{
			if ((mimRelsDone[mo,array[i]]>5)||(array[i] ~ LoopyMOs && mimRelsDone[mo,array[i]]>1)) continue
			mimRelsDone[mo,array[i]]++
		}
		if (exclude_deprecated>=2 && class_description[array[i]] ~ /Deprecated:|Obsolete:/) continue
		ldn=sprintf("%s,%s",parentmo,array[i])
		ldnc=sprintf("%s,%s[%s]",parentC,array[i],cardinality[mo,array[i]])
		nok=0
		for (z in forbiddenLdns)
		{
			if (ldn ~ sprintf("(,|^)%s($|,)",z)) nok=1
		}
		if (nok==1) continue
		if (what!="")
		{
			output=sprintf("%s%s",ldnc,(what~"s" && array[i] in class_syscreated?"   (systemCreated)":""))
			outputTable[output]=output
		}
		else
		{
			output=sprintf("%-*s%s[%s]%s",level,"",array[i],cardinality[mo,array[i]],(array[i] in class_syscreated?" (systemCreated)":""))
			if (show_colors==1 && comcli==0 && (!(array[i] in cppMoList))) output=sprintf("\033[1;31m%s\033[0m",output)
			customPrint(output)
		}
		#Old code, not working because some MO classes such as "Rule" can be found in Com as well as in application part
		#if (show_colors==1)
		#{
		#	tmpclass=array[i]
		#	if (comcli>0) tmpclass=gensub(/^.*\./,"",1,tmpclass)
		#	if (!(tmpclass in cppMoList)) output=sprintf("\033[1;31m%s\033[0m",output)
		#}
		showChildren(array[i],level+10,ldn,what,ldnc,outputTable)
	}
}
function showChildrenWrapper(mo,level,parentmo)
{
	delete mimRelsDone
	showChildren(mo,level,parentmo)
	delete mimRelsDone
}
function showValidLdns(filter,what,    outputTable,i,n,line,forbiddenLdns,z,me,a)
{
	delete outputTable
	delete mimRelsDone
	me=t2ecimt("ManagedElement")
	showChildren(me,0,me,what,me"[1]",outputTable)
	n=asort(outputTable)
	for (i=1;i<=n;i++)
	{
		line=outputTable[i]
		if (tolower(line) !~ tolower(filter)) continue
		if (comcli>0)
		{
			sub(/^[^.,\[]+\./,"",line)
			gsub(/,[^.,\[]+\./,",",line)
			match(line,/(SchedulerDwrr\[[^\]]+\],SchedulerSp\[[^\]]+\],)/,a)
			gsub(/(SchedulerDwrr\[[^\]]+\],SchedulerSp\[[^\]]+\],)+/,a[1],line)
			match(line,/(SchedulerDwrr\[[^\]]+\],Shaper\[[^\]]+\],)/,a)
			gsub(/(SchedulerDwrr\[[^\]]+\],Shaper\[[^\]]+\],)+/,a[1],line)
			match(line,/(Shaper\[[^\]]+\],SchedulerSp\[[^\]]+\],)/,a)
			gsub(/(Shaper\[[^\]]+\],SchedulerSp\[[^\]]+\],)+/,a[1],line)
		}
		customPrint(line)
		#customPrint(gensub(/^ManagedElement,/,"",1,line))
	}
	delete mimRelsDone
}
function sortTable(table,sorted_table,what,     moclass,array,last,i)
{
	#unr=0 --> unrestricted and unlocked restricted+
	#unr=1 --> locked restricted+
	#unr=2 --> restricted

	delete sorted_table
	for (moclass in table)
	{
		split(table[moclass],array,",")
		last=asort(array)
		for (i=1;i<=last;i++)
		{
			#special case for sorting the table attr_refs, skipping the MO classes that are deprecated
			if (what=="depr" && exclude_deprecated>=2 && class_description[gensub(/\[.*$/,"",1,array[i])] ~ /Deprecated:|Obsolete:/) continue
			if (array[i]!=array[i-1])
			{
				if (tolower(mom_version) ~ "rnc" && unr > 0)
				{
					if (tolower(attr_description[moclass,array[i]]) !~ /ericsson *personn*el/ && tolower(actn_description[moclass,array[i]]) !~ /ericsson *personn*el/)
						sorted_table[moclass]=sprintf("%s,%s",sorted_table[moclass],array[i])
				}
				else sorted_table[moclass]=sprintf("%s,%s",sorted_table[moclass],array[i])
			}
		}
		sub(/^,/,"",sorted_table[moclass])
	}
}
function postprocessing(table,  subscript)
{
	for (subscript in table)
	{
		gsub("\r","",table[subscript])
		gsub("</description>","",table[subscript])
		table[subscript]=replace_signs(table[subscript])
		gsub(/<p *>/,"",table[subscript])
		gsub(/<\/p *>|<br *\/>|<br>/,"\n",table[subscript])
		gsub(/([ \t]*\n)+/,"\n",table[subscript])
		gsub(/\n$|^\n/,"",table[subscript])
	}
}
function replace_signs(string)
{
	#https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references
	gsub(         /&#0*58;/,                    ":",    string)
	gsub(  /&quot;|&#0*34;|&#x0*22;/,           "\"",   string)
	gsub(   /&amp;|&#0*38;|&#x0*26;/,           "\\&",  string)
	gsub(  /&apos;|&#0*39;|&#x0*27;/,           "'",    string)
	gsub(    /&lt;|&#0*60;|&#x0*3[Cc];/,        "<",    string)
	gsub(    /&gt;|&#0*62;|&#x0*3[Ee];/,        ">",    string)
	gsub(  /&copy;|&#0*169;|&#x0*[Aa]9;/,     "(c)",    string) #""
	gsub(  /&deg;C|&#0*176;C|&#x0*[Bb]0;C/,     "C",    string) #"C"
	gsub(   /&deg;|&#0*176;|&#x0*[Bb]0;/,  "degree",    string) #""
	gsub(  /&circ;|&#0*710;|&#x0*2[Cc]6;/,      "^",    string) #""
	gsub( /&tilde;|&#0*732;|&#x0*2[Dd][Cc];/,   "~",    string) #""
	gsub( /&ndash;|&#0*8211;|&#x2013;/,         "-",    string) #""
	gsub( /&mdash;|&#0*8212;|&#x2014;/,         "-",    string) #""
	gsub( /&lsquo;|&#0*8216;|&#x2018;/,         "'",    string) #""
	gsub( /&rsquo;|&#0*8217;|&#x2019;/,         "'",    string) #""
	gsub( /&sbquo;|&#0*8218;|&#x201[Aa];/,      ",",    string) #
	gsub( /&ldquo;|&#0*8220;|&#x201[Cc];/,     "\"",    string) #
	gsub( /&rdquo;|&#0*8221;|&#x201[Dd];/,     "\"",    string) #
	gsub( /&bdquo;|&#0*8222;|&#x201[Ee];/,     "\"",    string) #
	gsub(  /&bull;|&#0*8226;|&#x2022;/,         "-",    string) #
	gsub(/&hellip;|&#0*8230;|&#x2026;/,       "...",    string) #
	gsub(/&curren;|&#0*164;|&#x0*[aA]4;/,       "",    string)
	gsub(  /&nbsp;|&#0*160;|&#x0*[aA]0;/,       " ",    string)
	gsub( /&minus;|&#0*8722;|&#x0*2212;/,       "-",    string)
	gsub( /&acute;|&#0*180;|&#x0*[bB]4;/,       "'",    string) #
	gsub(/&lsaquo;|&#0*8249;|&#x2039;/,         "<",    string) #""
	gsub(/&rsaquo;|&#0*8250;|&#x203[Aa];/,      ">",    string) #""
	gsub(/&#0*13;/,      "\n",    string)
	return string
}

function parseMomRange(range,  last,array,i,min,max,def,foundVal)
{

	#Min=5 Max=5 Min=10 Max=10 Min=15 Max=15 Min=20 Max=20 Min=30 Max=30 Min=40 Max=40 Min=50 Max=50 Default=30
	#Min=-115 Max=-25 Min=100 Max=100 Default=100
	#Min=0 Max=100 Min=18000 Max=18000 Default=50
	#Min=424 Max=699 Min=9675 Max=9950 Min=10575 Max=10850
	#====> convert to:
	#Range: 5, 10, 15, 20, 30, 40, 50,  Default=30
	#Range: -115 to -25, 100, Default=100
	#Range: 0 to 100, 18000, Default=50
	#Range: 424 to 699, 9675 to 9950, 10575 to 10850
	#Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE Default=FALSE
	#====> convert to: Default=FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE
	#Default=false, false, false, false, false -> will be converted to false,false,false,false,false
	if (range ~ /Min=/ && range ~ /Max=/)
	{
		#due to the use of subranges in ECIM , the range can sometimes contain duplicated entries, eg: Min=0 Max=100 Min=0 Max=100
		if (comcli>0)
		{
			delete foundVal
			last=split(range,array," ")
			range=""
			for (i=1;i<=last;i++)
			{
				if (foundVal[array[i]]==1) continue
				foundVal[array[i]]=1
				range=range" "array[i]
				sub(/^ /,"",range)
			}
		}

		newRange="Range: "
		last=split(range,array," ")
		for (i=1;i<=last;i++)
		{
			if (array[i] ~ /^Min=/ && array[i+1] ~ /^Max=/)
			{
				min=gensub(/^Min=/,"",1,array[i])
				max=gensub(/^Max=/,"",1,array[i+1])
				if (min == max) newRange=sprintf("%s%s, ",newRange,min)
				else newRange=sprintf("%s%s to %s, ",newRange,min,max)
				i++
			}
			else if ((comcli>0) &&(array[i] ~ /^Max=/ && array[i+1] ~ /^Min=/))
			{
				#in ECIM MOM, the Max can be before the Min, eg:
			        #<derivedDataType name="Timeout">
			        #    <baseType>
			        #        <uint32>
			        #            <range>
			        #                <max>2147483647</max>
			        #                <min>0</min>
			        #            </range>
			        #        </uint32>
			        #    </baseType>
			        #</derivedDataType>
				min=gensub(/^Min=/,"",1,array[i+1])
				max=gensub(/^Max=/,"",1,array[i])
				if (min == max) newRange=sprintf("%s%s, ",newRange,min)
				else newRange=sprintf("%s%s to %s, ",newRange,min,max)
				delete array[i+1]
				i++
			}
			else if (array[i] !~ /^Max=/)
			{
				newRange=sprintf("%s%s ",newRange,array[i])
			}
		}
		sub(/, *$/,"",newRange)
	}
	else newRange=range
	sub(/[ \t]*$/,"",newRange)
	if (newRange ~ /Default=.* Default=/)
	{
		last=split(newRange,array," Default=")
		newRange=array[1]" Default="
		for (i=2;i<last;i++)
		{
			newRange=sprintf("%s%s,",newRange,array[i])
		}
		newRange=newRange array[last]
	}
	return newRange
}
function convert_attribute_types(mom_type,   java_type,tmp)
{
	#input the mom attribute type, output the java attribute_type
	#possible mom_types= structRef , longlong , enumRef , boolean , long , moRef , sequence, float , string
	#corresponding java_types= sTruct , Long  ,         , Boolean , Integer , Ref,         , Float , String
	if (tolower(mom_type) ~      /^structref/)  java_type="t"
	else if (tolower(mom_type) ~ /^longlong/ )  java_type="l"
	else if (tolower(mom_type) ~ /^long/)       java_type="i"
	else if (tolower(mom_type) ~ /^enumref/)    java_type="i"
	else if (tolower(mom_type) ~ /^boolean/)    java_type="b"
	else if (tolower(mom_type) ~ /^moref/)      java_type="r"
	else if (tolower(mom_type) ~ /^float/)      java_type="f"
	else if (tolower(mom_type) ~ /^string/)     java_type="s"
	else if (tolower(mom_type) ~ /^(sequence.)structref/)  java_type="at"
	else if (tolower(mom_type) ~ /^(sequence.)longlong/ )  java_type="al"
	else if (tolower(mom_type) ~ /^(sequence.)long/)       java_type="ai"
	else if (tolower(mom_type) ~ /^(sequence.)enumref/)    java_type="ai"
	else if (tolower(mom_type) ~ /^(sequence.)boolean/)    java_type="ab"
	else if (tolower(mom_type) ~ /^(sequence.)moref/)      java_type="ar"
	else if (tolower(mom_type) ~ /^(sequence.)float/)      java_type="af"
	else if (tolower(mom_type) ~ /^(sequence.)string/)     java_type="as"
	#comcli
	else if (comcli>0)
	{
		if (tolower(mom_type) ~ /^u?int64/) java_type="l"
		else if (tolower(mom_type) ~ /^u?int/) java_type="i"
		else if (tolower(mom_type) ~ /^sequence.u?int64/) java_type="al"
		else if (tolower(mom_type) ~ /^sequence.u?int/) java_type="ai"
		else if (tolower(mom_type) ~ /derivedref/)
		{
			tmp=gensub(/^.*[-:]/,"",1,mom_type)
			if (tmp in derived_type && derived_type[tmp]!="")
			{
				java_type=convert_attribute_types(derived_type[tmp])
				if (tolower(mom_type) ~ /^sequence/) java_type="a"java_type
				#print mom_type,tmp,derived_type[tmp],java_type
			}
		}
	}
	#print mom_type,java_type
	return java_type
}
function eventcache_is_valid(file,    res,readfile_command,cache_req)
{
	if (fileOps("test -s "file)!=0) return 1
	delete cache_req
	readfile_command="gzip -dc "file
	while (readfile_command |& getline)
	{
		if ($1=="MOSHELL_EVENT_CACHE_VERSION" && $2==supported_eventcache_version) cache_req["ver"]=1
		else if ($1=="END_MOSHELL_EVENT_CACHE") cache_req["end"]=1
	}
	close(readfile_command)
	if (cache_req["ver"] != 1 || cache_req["end"] != 1) return 1
	return 0
}
function comcli_readmom_event(what,     motypes,currmo,attr,currmim,mtList,moc,pmc,pmt,hctab,pmgrp,i,n,t_pm_list,pmcachefile,temppmcachefile,etList,a,tgrp,old_sort_proxy)
{
	if (isarray(eventList)==1 && length(eventList)>0) return 0
	OffOk=1
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)","",1)
	#motypes["eventgroup"]=motypes["eventtype"]=1
	#ConditionalLoad(motypes)
	load_subtree("SystemFunctions=1,PmEventM=1","conditional")
	if (nrOfMoType(fullmoc("eventgroup"))==0 || nrOfMoType(fullmoc("eventtype"))==0) return comcli_error("pmev",what)
	pmcachefile=sprintf("%s/EVENTCACHE_%s.txt.gz",jarxmldir,mom_version)
	temppmcachefile=sprintf("%s/EVENTCACHE_%s.txt",tempdir,mom_version)
	if (eventcache_is_valid(pmcachefile)==0 && fileOps("cp "pmcachefile" "tempetlog".gz")==0 && system("gzip -df "tempetlog".gz")==0)
	{
		customPrint("Parsing EVENT cache: "pmcachefile" ... Done.")
	}
	else
	{
		mo_log(tempetlog,"open","mute","overwrite","silent")
		print "MOSHELL_EVENT_CACHE_VERSION " supported_eventcache_version  >> tempetlog
		#if (node ~ /^OFFLINE/) $0="kget ^(eventgroup|eventtype)=" ; else $0="kgetm ^eventgroup="
		#kget("short","","m")
		old_sort_proxy=sort_proxy
		sort_proxy=1
		$0="pr ^eventtype=" ; pr("short")
		sort_proxy=old_sort_proxy
		print "END_MOSHELL_EVENT_CACHE" >> tempetlog
		mo_log(tempetlog,"close")
		print ""
		if (fileOps("cp "tempetlog" "temppmcachefile)==0 && system("gzip -f "temppmcachefile)==0)
		{
			chmod(00666,temppmcachefile".gz")
			fileOps("mv "temppmcachefile".gz "pmcachefile)
		}
	}
	while (getline < tempetlog)
	{
		# 4943  SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=WIFI,EventType=S1_WIFI_ACCESS_DECISION_RESPONSE
		#Make these tables:
		#eventfileList[Lrat]=1
		#eventList[Lrat,ALWAYS_ACTIVE]=INTERNAL_EVENT_ANR_CONFIG_MISSING;INTERNAL_EVENT_LICENSE_UNAVAILABLE;....
		#EvTypeMo[Lrat,ALWAYS_ACTIVE,INTERNAL_EVENT_ANR_CONFIG_MISSING]=ManagedElement=SFINX01,SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=ALWAYS_ACTIVE,EventType=INTERNAL_EVENT_ANR_CONFIG_MISSING
		#EvTypeMo[ManagedElement=SFINX01,SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=ALWAYS_ACTIVE,EventType=INTERNAL_EVENT_ANR_CONFIG_MISSING]=ALWAYS_ACTIVE,INTERNAL_EVENT_ANR_CONFIG_MISSING

		#EvTypeMo[ManagedElement=SFINX01,SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=ALWAYS_ACTIVE]=ALWAYS_ACTIVE,INTERNAL_EVENT_ANR_CONFIG_MISSING;ALWAYS_ACTIVE,INTERNAL_EVENT_LICENSE_UNAVAILABLE;...

		#EvGroupMo[ManagedElement=SFINX01,SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=ALWAYS_ACTIVE]=Lrat,ALWAYS_ACTIVE
		#EvGroupMo[Lrat,ALWAYS_ACTIVE]=ManagedElement=SFINX01,SystemFunctions=1,PmEventM=1,EventProducer=Lrat,EventGroup=ALWAYS_ACTIVE
		if (NF==2 && $1~/^[0-9]+$/ && $2~/,EventType=[^,]+$/)
		{
			i=ComMe","$2
			split(i,a,/[,=]/)
			eventfileList[a[8]]=1
			if (eventList[a[8],a[10]]=="") eventList[a[8],a[10]]=a[12]
			else eventList[a[8],a[10]]=eventList[a[8],a[10]] ";" a[12]
			EvTypeMo[a[8],a[10],a[12]]=i
			EvTypeMo[i]=a[10]","a[12]
			tgrp=gensub(/,EventType=.*$/,"",1,i)
			EvTypeMo[tgrp]=EvTypeMo[tgrp]";"a[10]","a[12]
			sub(/^;/,"",EvTypeMo[tgrp])
			EvGroupMo[tgrp]=a[8]","a[10]
			EvGroupMo[a[8],a[10]]=tgrp
		}
	}
	close(tempetlog)
	return 0
}
function emom( i,array,type,j,last,array1,Filter1,Filter2,headerprinted,counter)
{
	customPrint("")
	Filter1=tolower($2) ; Filter2=tolower($3)
	if (multi && Start_multi()==1) return
	CheckMom()
	if (mom_version !~ /(PRBS|RNC|^RBS|ERBS|MSRBS)_NODE_MODEL/)
	{
		if (mom_version != "") customPrint("EMOM command is only applicable for RNC/RBS/ENB/MSRBS/PRBS.")
		return
	}
	separator="=================================================================="
	if (is_rcs()==1 || is_pico()==1) comcli_readmom_event("emom")
	else parse_eventfiles()
	for (type in eventfileList)
	{
		if (tolower(type) ~ Filter1 || Filter1=="all")
		{
			customPrint(separator)
			customPrint(sprintf("%s EVENTS",type))
			customPrint(separator)
			for (i in eventList)
			{
				split(i,array,SUBSEP)
				if (array[1]==type)
				{
					last=split(eventList[i],array1,";")
					if (Filter2 != "")
					{
						headerprinted=counter=0
						for (j=1;j<=last;j++) if (tolower(array1[j]) ~ Filter2) counter++
						for (j=1;j<=last;j++)
						{
							if (tolower(array1[j]) ~ Filter2)
							{
								if (headerprinted==0)
								{
									customPrint(sprintf("%-32s  %3s  %s",array[2],counter,array1[j]))
									headerprinted=1
								}
								else customPrint(sprintf("%-32s  %3s  %s","","",array1[j]))
							}
						}
					}
					else
					{
						customPrint(sprintf("%-32s  %3s  %s",array[2],last,array1[1]))
						for (j=2;j<=last;j++) customPrint(sprintf("%-32s  %3s  %s","","",array1[j]))
					}
				}
			}
		}
	}
}
function shortmoc(string)
{
	return gensub(/^.*\./,"",1,string)
}
function multicut(string,what,   array)
{
	if (multi)
	{
		split(string,array,SUBSEP)
		string=momVersionList[array[1]]"."array[2]
	}
	else if (what==1 && comcli>0 && hasDupMocs!=1) sub(/^[^.]+\./,"",string)
	return string
}
function cutmoc(string)
{
	#convert a full MOC to a MOC without the MIM fragment prefix, eg: Lrat.ExternalEUtranCellFDD -> ExternalEUtranCellFDD
	if (comcli>0 && string ~ /^[^.]+\.[^.]+$/) sub(/^[^.]+\./,"",string)
	return string
}
function dbmom(what,     n,i,Filter1,Filter2,Filter3,Filter4,lentab)
{
	lentab["mo"]=26  #ExchangeTerminalIp.Program
	lentab["attr"]=35 #nonSupportedPIUsLockedBeforeUpgrade
	lentab["type"]=30 #sequence:moRef-ManagedObject
	Filter1=tolower($2) ; Filter2=tolower($3) ; Filter3=tolower($4) ; Filter4=tolower($5)
	customPrint("####################################################################################################################################")
	customPrint(sprintf("%-*s  %-*s  %-*s  %s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",lentab["type"],"Table","Type"))
	customPrint("####################################################################################################################################")
	n=asort(modataClassList)
	for (i=1;i<=n;i++)
	{
		if (what ~ "a" && modataClassList[i] in cppMoList) continue
		else if (what ~ "p" && what !~ "a" && (!(modataClassList[i] in cppMoList))) continue
		print_dbmomtable(sorted_maoattrlist,modataClassList[i] ,"mao:"modataRev, Filter1,Filter2,Filter3,Filter4)
		print_dbmomtable(sorted_froattrlist,modataClassList[i] ,"fro:"sqlMapRealTable[sqlMapTable[modataClassList[i]]],Filter1,Filter2,Filter3,Filter4)
		print_dbmomtable(sorted_fro2attrlist,modataClassList[i],"fro2",Filter1,Filter2,Filter3,Filter4)
		print_dbmomtable(sorted_fro3attrlist,modataClassList[i],"fro3",Filter1,Filter2,Filter3,Filter4)
	}
#IuLink  maoTableRef  string  mao
#IuLink  froId        froid   mao
#IuLink  atmUserPlaneTermSubrackRef   mao   moRef:Subrack
#IuLink  atmuserplanetermsubrackfroid fro   froRef:Subrack
#Fach    utrancellfroid  froParentRef:UtranCell  fro
}
function print_dbmomtable(table,moclass,what,filter1,filter2,filter3,filter4,         m,array,j,lentab,type,neg1,neg2,neg3,neg4)
{
	lentab["mo"]=26  #ExchangeTerminalIp.Program
	lentab["attr"]=35 #nonSupportedPIUsLockedBeforeUpgrade
	lentab["type"]=30 #sequence:moRef-ManagedObject
	if (filter1 ~ /^!/) { sub(/^./,"",filter1) ; neg1=1 }
	if (filter2 ~ /^!/) { sub(/^./,"",filter2) ; neg2=1 }
	if (filter3 ~ /^!/) { sub(/^./,"",filter3) ; neg3=1 }
	if (filter4 ~ /^!/) { sub(/^./,"",filter4) ; neg4=1 }
	if (neg1) { if (tolower(moclass) ~ filter1) return } else if (tolower(moclass) !~ filter1) return
	m=split(table[moclass],array,",")
	for (j=1;j<=m;j++)
	{
		if (neg2) { if (tolower(array[j]) ~ filter2) continue } else if (tolower(array[j]) !~ filter2) continue
		if (what=="fro2" && (moclass,"fro2") in otherFroTables) what="fro2:"otherFroTables[moclass,"fro2"]
		else if (what=="fro3" && (moclass,"fro3") in otherFroTables) what="fro3:"otherFroTables[moclass,"fro3"]
		type=""
		if (moclass":"array[j] in MoAttributesType) type=MoAttributesType[moclass":"array[j]]
		if (neg3) { if (tolower(what) ~ filter3) continue } else if (tolower(what) !~ filter3) continue
		if (neg4) { if (tolower(type) ~ filter4) continue } else if (tolower(type) !~ filter4) continue
		customPrint(sprintf("%-*s  %-*s  %-*s  %s",lentab["mo"],moclass,lentab["attr"],array[j],lentab["type"],what,type))
	}
}

#very strange but if the filter used in check_mom_condition (Filter2) is a very long regexp then the next time we try to use check_mom_condition it is very slow
#therefore the need to have separate check_mom_condition functions for each filter, though they all have exactly the same code
function check_mom_condition5(filter,field)
{
	#0=ok, 1=notok
	if (filter ~ /^(|all|\.|\*)$/) return 0
	field=tolower(field)
	if (filter ~ /^!.+/ && field ~ gensub(/^!/,"",1,filter)) return 1
	if (filter ~ /^[^!]/ && field !~ filter) return 1
	return 0
}
function check_mom_condition4(filter,field)
{
	#0=ok, 1=notok
	if (filter ~ /^(|all|\.|\*)$/) return 0
	field=tolower(field)
	if (filter ~ /^!.+/ && field ~ gensub(/^!/,"",1,filter)) return 1
	if (filter ~ /^[^!]/ && field !~ filter) return 1
	return 0
}
function check_mom_condition3(filter,field)
{
	#0=ok, 1=notok
	if (filter ~ /^(|all|\.|\*)$/) return 0
	field=tolower(field)
	if (filter ~ /^!.+/ && field ~ gensub(/^!/,"",1,filter)) return 1
	if (filter ~ /^[^!]/ && field !~ filter) return 1
	return 0
}
function check_mom_condition(filter,field)
{
	#0=ok, 1=notok
	if (filter ~ /^(|all|\.|\*)$/) return 0
	field=tolower(field)
	if (filter ~ /^!.+/ && field ~ gensub(/^!/,"",1,filter)) return 1
	if (filter ~ /^[^!]/ && field !~ filter) return 1
	return 0
}
function filterText(filter,text,    array,i,n,res)
{
	if (filter=="") return text
	n=split(text,array,"\n")
	for (i=1;i<=n;i++)
	{
		if (tolower(array[i]) ~ filter) res=res"\n"array[i]
	}
	sub(/^\n/,"",res)
	return res
}
function mom(what,   ok,structname,structmember,Filter1,Filter2,Filter3,Filter4,Filter5,j,Last,moFilter1,\
headerPrinted,z,arrayz,k,resTable,globalResTable,countTable,lentab,printedMo,nr_mo,nr_count,moattrlength,filter2Table,y,addFilter2,filter1Table,addFilter1,t3,negMo,arr)
{
	nr_mo=nr_count=negMo=0
	if (multi && Start_multi()==1) return
	if ($2 ~ /^!/) { negMo=1 ; sub(/^!/,"",$2) }
	Filter1 = moFilter1 = tolower($2)
	Filter2 = tolower($3)
	Filter3 = tolower($4)
	Filter4 = tolower($5)
	Filter5 = tolower($6)
	if (what !~ "t" && what ~ /[rbli]/)
	{
		if (Filter1=="") Filter1="."
		if (Filter2=="") Filter2="."
	}
	CheckMom()
	lentab["mo"]=24  #Aal2PathDistributionUnit
	lentab["attr"]=37 #trustedCertificateInstallationFailure
	lentab["type"]=49 #sequence:structRef-ConfigurationVersionAttributes
	lentab["enum"]=35 #NodeBFunction_ActivationClockStatus
	lentab["action"]=33 #nonBlockingSelectiveForcedInstall
	lentab["struct"]=37 #RfCableTestFrequencyPlaneResultStruct
	lentab["member"]=30 #plmnOperTargetMsServiceSupport
	lentab["refmo"]=maxLength["refmo"]
	lentab["refattr"]=maxLength["refattr"]
	if (comcli>0)
	{
		lentab["derived"]=maxLength["derived"]
		if (hasDupMocs==1) lentab["mo"]=maxLength["mo"]
		else lentab["mo"]=maxLength["smallmo"]
		#lentab["type"]=maxLength["type"]
		lentab["enum"]=maxLength["enum"]
		lentab["struct"]=maxLength["struct"]
		#for (i in lentab) print i,lentab[i]
	}
	if (multi)
	{
		lentab["mo"]+=maxMomLength
		lentab["enum"]+=maxMomLength
		lentab["action"]+=maxMomLength
		lentab["struct"]+=maxMomLength
		lentab["refmo"]+=maxMomLength
	}
	if (what ~ "t")
	{
		#momtl -> only the ldn table
		#momto -> only mos over
		#momtu -> only mos under
		#momts -> show systemcreated flag in ldn and over table
		#momtls -> only ldn table and include the systemcreated flag
		z=split(sorted_mom_list["moclass"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			moclass=arrayz[k]
			if ((Filter1!="" && tolower(moclass) ~ Filter1)||\
			    (Filter1=="" && moclass ~ /ManagedElement$/))
			{
				if (what ~ "l" || gensub("t","","g",what)~/^s*$/)
				{
					customPrint(sprintf("\n--------------------------------\nLDNs containing %s%s\n--------------------------------",moclass,(moclass in class_syscreated?" (systemCreated)":"")))
					showValidLdns(sprintf("(^|,)%s\\[",moclass),what)
				}
				if (what ~ "o" || gensub("t","","g",what)~/^s*$/)
				{
					customPrint(sprintf("\n--------------------------------\nMO classes over %s%s\n--------------------------------",moclass,(moclass in class_syscreated?" (systemCreated)":"")))
					showValidLdns(sprintf("(^|,)%s\\[[^,]+$",moclass),what)
				}
				if (what ~ "u" || gensub("t","","g",what)~/^s*$/)
				{
					delete mimRelsDone
					customPrint(sprintf("\n--------------------------------\nMO classes under %s%s\n--------------------------------",moclass,(moclass in class_syscreated?" (systemCreated)":"")))
					showChildrenWrapper(moclass,0,moclass)
				}
			}
		}
		return
	}
	if (what ~ "x")
	{
		customPrint("")
		customPrint("####################################################################################################################################")
		customPrint(sprintf("%-*s  %-*s  %s",lentab["refmo"],"MO Class",lentab["refattr"]+4,"Attribute","References"))
		customPrint("####################################################################################################################################")
		z=split(sorted_mom_list["moclass"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			moclass=arrayz[k]
			if (what ~ "a" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "a" && (!(moclass in cppMoList))) continue
			Last=split(sorted_attribute_list[moclass],array,",")
			for (j=1;j<=Last;j++)
			{
				moattribute=array[j]
				moattrlength=""
				if ((moclass,moattribute) in attr_length && attr_length[moclass,moattribute]!="") moattrlength="["attr_length[moclass,moattribute]"]"
				else if ((moclass":"moattribute) in MoAttributesType && MoAttributesType[moclass":"moattribute]~/^sequence:/) moattrlength="[]"
				if ((moclass,moattribute) in sorted_attr_refs && sorted_attr_refs[moclass,moattribute]!="")
				{
					output=sprintf("%-*s  %-*s  %s",lentab["refmo"],multicut(moclass,1),lentab["refattr"]+4,moattribute moattrlength,sorted_attr_refs[moclass,moattribute])
					if ((negMo==0 && tolower(output)~Filter1)||(negMo==1 && tolower(output)!~Filter1)) customPrint(output)
				}
			}
		}
		customPrint("------------------------------------------------------------------------------------------------------------------------------------")
		return
	}

	if (what ~ "c") moFilter1=make_long_filter(moFilter1)
	if (Filter2 == "" || Filter5 != "")
	{
		z=split(sorted_mom_list["moclass"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			if (Filter2 !~ /^(|[.*]|all)$/) continue
			if (Filter3 !~ /^(|[.*]|all)$/) continue
			if (Filter4 !~ /^(|[.*]|all)$/) continue
			moclass=arrayz[k]
			if (exclude_deprecated>=2 && class_description[moclass] ~ /Deprecated:|Obsolete:/) continue
			if (what ~ "a" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "a" && (!(moclass in cppMoList))) continue
			if ((negMo==0 && tolower(multicut(moclass,1))~moFilter1) || (negMo==1 && tolower(multicut(moclass,1))!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (Filter5 != "" && tolower(class_description[moclass]) !~ Filter5) continue
				if (headerPrinted["moclass"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-*s  %s",lentab["mo"],"MO Class",(what!~"d"?"Attributes/Actions":"Attributes")))
					customPrint("##################################################################################")
					headerPrinted["moclass"]=1
				}
				customPrint(sprintf("%-*s  %s",lentab["mo"],multicut(moclass,1),sorted_attribute_list[moclass]))
				if (what !~ "d")
				{
					if (sorted_action_list[moclass] != "") customPrint(sprintf("%-*s  %s",lentab["mo"],"",sorted_action_list[moclass]))
					customPrint(filterText(Filter5,class_description[moclass]))
					customPrint("----------------------------------------------------------------------------------")
				}
			}
		}
		if (what ~ "d")
		{
			headerPrinted["moclass"]=0
			for (k=1;k<=z;k++)
			{
				if (Filter2 !~ /^(|[.*]|all)$/) continue
				if (Filter3 !~ /^(|[.*]|all)$/) continue
				if (Filter4 !~ /^(|[.*]|all)$/) continue
				moclass=arrayz[k]
				if (what ~ "a" && moclass in cppMoList) continue
				else if (what ~ "p" && what !~ "a" && (!(moclass in cppMoList))) continue
				if ((negMo==0 && tolower(multicut(moclass,1))~moFilter1) || (negMo==1 && tolower(multicut(moclass,1))!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
				{
					if (Filter5 != "" && tolower(class_description[moclass]) !~ Filter5) continue
					if (headerPrinted["moclass"] != 1)
					{
						customPrint("")
						customPrint("##################################################################################")
						customPrint(sprintf("%-*s  %s",lentab["mo"],"MO Class","Actions"))
						customPrint("##################################################################################")
						headerPrinted["moclass"]=1
					}
					if (sorted_action_list[moclass] != "") customPrint(sprintf("%-*s  %s",lentab["mo"],multicut(moclass,1),sorted_action_list[moclass]))
				}
			}
		}

		z=split(sorted_mom_list["structure"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			if (Filter2 !~ /^(|[.*]|all)$/) continue
			if (Filter3 !~ /^(|[.*]|all)$/) continue
			if (Filter4 !~ /^(|[.*]|all)$/) continue
			structname=arrayz[k]
			if ((negMo==0 && tolower(structname)~Filter1) || (negMo==1 && tolower(structname)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (Filter5 != "" && tolower(struct_description[structname]) !~ Filter5) continue
				if (headerPrinted["struct"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-*s  %s",lentab["struct"],"Struct","Members"))
					customPrint("##################################################################################")
					headerPrinted["struct"]=1
				}
				customPrint(sprintf("%-*s  %s",lentab["struct"],multicut(structname),struct_contents[structname]))
				if (what !~ "d")
				{
					if (struct_description[structname] != "") customPrint(filterText(Filter5,struct_description[structname]))
					customPrint("----------------------------------------------------------------------------------")
				}
			}
		}
		z=split(sorted_mom_list["enumerate"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			if (Filter2 != "") continue
			enm=arrayz[k]
			if ((negMo==0 && tolower(enm)~Filter1) || (negMo==1 && tolower(enm)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (headerPrinted["enum"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-*s  %s",lentab["enum"],"Enum","Values"))
					customPrint("##################################################################################")
					headerPrinted["enum"]=1
				}
				customPrint(sprintf("%-*s  %s",lentab["enum"],multicut(enm),enum_contents[enm]))
			}
		}
		if (comcli>0)
		{
			z=split(sorted_mom_list["derived"],arrayz,";")
			for (k=1;k<=z;k++)
			{
				if (Filter2 != "") continue
				drv=arrayz[k]
				if ((negMo==0 && tolower(drv)~Filter1) || (negMo==1 && tolower(drv)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
				{
					if (headerPrinted["derived"] != 1)
					{
						customPrint("")
						customPrint("##################################################################################")
						customPrint(sprintf("%-*s  %s",lentab["derived"],"DerivedDataType","Type"))
						customPrint("##################################################################################")
						headerPrinted["derived"]=1
					}
					customPrint(sprintf("%-*s  %s",lentab["derived"],multicut(drv),derived_type[drv]))
				}
			}
		}
		if (mom_version != "" && Filter2 == "") customPrint("\nEnter a second argument in the mom command for more detailed description (or type \"h mom\" for help).")
	}
	if (Filter2 == "") { customPrint("") ; return }

	z=split(sorted_mom_list["moclass"],arrayz,",")
	if (what ~ /[rbl].*[rbl]/) what=what"rbl" #if two or more options r/b/l are used then we will print all 3 fields: range, default value and length
	for (k=1;k<=z;k++)
	{
		moclass=arrayz[k]
		if (what ~ "a" && moclass in cppMoList) continue
		else if (what ~ "p" && what !~ "a" && (!(moclass in cppMoList))) continue
		if ((negMo==0 && tolower(multicut(moclass,1))~moFilter1) || (negMo==1 && tolower(multicut(moclass,1))!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
		{
			Last=split(sorted_attribute_list[moclass],array,",")
			for (j=1;j<=Last;j++)
			{
				moattribute=array[j]
				if (check_mom_condition(Filter2,moattribute)==1) continue
				if (check_mom_condition3(Filter3,MoAttributesType[moclass":"moattribute])==1) continue
				if (check_mom_condition4(Filter4,attr_comments[moclass,moattribute])==1) continue
				if (what~"i" && check_mom_condition4("ericssononly",attr_comments[moclass,moattribute])==1) continue
				if (check_mom_condition5(Filter5,attr_description[moclass,moattribute])==1) continue
				filter1Table[moclass]=1
				filter2Table[moattribute]=1

				if (headerPrinted["moattribute"] != 1)
				{
					customPrint("")
					customPrint("####################################################################################################################################")
					if (what ~ "rbl") customPrint(sprintf("%-*s  %-*s  %s%-6s  %-20s  %-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",(what~"f"?sprintf("%-20s  ","Flags"):""),"Length","Default","Range"))
					else if (what ~ "b") customPrint(sprintf("%-*s  %-*s  %s%-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",(what~"f"?sprintf("%-20s  ","Flags"):""),"Default"))
					else if (what ~ "r") customPrint(sprintf("%-*s  %-*s  %s%-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",(what~"f"?sprintf("%-20s  ","Flags"):""),"Range"))
					else if (what ~ "l") customPrint(sprintf("%-*s  %-*s  %s%-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",(what~"f"?sprintf("%-20s  ","Flags"):""),"Length"))
					else customPrint(sprintf("%-*s  %-*s  %-*s  %-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",lentab["type"],"Type","Flags"))
					customPrint("####################################################################################################################################")
					headerPrinted["moattribute"]=1
				}
				if (what ~ "rbl")
				{
					if (attr_default[moclass,moattribute]!="" || attr_range[moclass,moattribute]!="" || attr_length[moclass,moattribute]!="")
						customPrint(sprintf("%-*s  %-*s  %s%-6s  %-20s  %-s",\
					lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,(what~"f"?sprintf("%-20s  ",attr_comments[moclass,moattribute]):""),\
					attr_length[moclass,moattribute],attr_default[moclass,moattribute],attr_range[moclass,moattribute]))
				}
				else if (what ~ "b")
				{
					if (attr_default[moclass,moattribute]!="")
						customPrint(sprintf("%-*s  %-*s  %s%-s",\
					lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,(what~"f"?sprintf("%-20s  ",attr_comments[moclass,moattribute]):""),attr_default[moclass,moattribute]))
				}
				else if (what ~ "r")
				{
					if (attr_range[moclass,moattribute]!="")
						customPrint(sprintf("%-*s  %-*s  %s%-s",\
					lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,(what~"f"?sprintf("%-20s  ",attr_comments[moclass,moattribute]):""),attr_range[moclass,moattribute]))
				}
				else if (what ~ "l")
				{
					if (attr_length[moclass,moattribute]!="")
						customPrint(sprintf("%-*s  %-*s  %s%-s",\
					lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,(what~"f"?sprintf("%-20s  ",attr_comments[moclass,moattribute]):""),attr_length[moclass,moattribute]))
				}
				else customPrint(sprintf("%-*s  %-*s  %-*s  %-s",lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,lentab["type"],MoAttributesType[moclass":"moattribute],attr_comments[moclass,moattribute]))
				if (what !~ /[drbl]/)
				{
					customPrint(filterText(Filter5,sprintf("------------------------------------------------------------------------------------------------------------------------------------\n%s",attr_description[moclass,moattribute])))
					customPrint("************************************************************************************************************************************")
				}
				printedMo[moclass]=1
				nr_count++
			}
			if (is_rcs()==1 && mom_version!~/_TESTMOM/ && check_append_testmom()!=0)
			{
				Last=split(sorted_imom_list[moclass],array,",")
				for (j=1;j<=Last;j++)
				{
					moattribute=array[j]
					split(imom_table[moclass,moattribute],arr,SUBSEP)
					if (check_mom_condition(Filter2,moattribute)==1) continue
					if (check_mom_condition3(Filter3,arr[1])==1) continue
					if (check_mom_condition4(Filter4,arr[2])==1) continue
					if (what~"i" && check_mom_condition4("ericssononly",arr[2])==1) continue
					if (check_mom_condition5(Filter5,arr[3])==1) continue

					if (headerPrinted["moattribute"] != 1)
					{
						customPrint("")
						customPrint("####################################################################################################################################")
						customPrint(sprintf("%-*s  %-*s  %-*s  %-s",lentab["mo"],"MO Class",lentab["attr"],"Attribute",lentab["type"],"Type","Flags"))
						customPrint("####################################################################################################################################")
						headerPrinted["moattribute"]=1
					}
					customPrint(sprintf("%-*s  %-*s  %-*s  %-s",lentab["mo"],multicut(moclass,1),lentab["attr"],moattribute,lentab["type"],arr[1],arr[2]))
					if (what !~ /[drbl]/)
					{
						customPrint(filterText(Filter5,sprintf("------------------------------------------------------------------------------------------------------------------------------------\n%s",arr[3])))
						customPrint("************************************************************************************************************************************")
					}
					printedMo[moclass]=1
					nr_count++
				}
			}
		}
	}
	for (moclass in printedMo) nr_mo++
	customPrint("\nTotal: "nr_mo" MOs, "nr_count" attributes")
	addFilter1=addFilter2=""
	for (y in filter1Table) addFilter1=addFilter1"|"y
	for (y in filter2Table) addFilter2=addFilter2"|"y
	sub(/^\|/,"",addFilter1)
	sub(/^\|/,"",addFilter2)
	if (addFilter2!="")
	{
		addFilter1="^("addFilter1")$"
		addFilter2="^("addFilter2")$"
		assignCustomVar("$moclass_filter",addFilter1)
		assignCustomVar("$attrib_filter",addFilter2)
	}

	if (what ~ "i") return

	if (what !~ /[brl]/)
	{
		z=split(sorted_mom_list["moclass"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			if (Filter4 !~ /^(|[.*]|all)$/) continue
			moclass=arrayz[k]
			if (what ~ "a" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "a" && (!(moclass in cppMoList))) continue
			if (!(moclass in sorted_action_list)) continue
			if ((negMo==0 && tolower(multicut(moclass,1))~moFilter1) || (negMo==1 && tolower(multicut(moclass,1))!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				Last=split(sorted_action_list[moclass],array,",")
				for (j=1;j<=Last;j++)
				{
					moaction=array[j]
					if (Filter3 != "" && tolower(action[moclass,moaction]) !~ Filter3)
					{
						if (!(Filter3 == "all" || Filter3 == "*")) continue
					}
					if (Filter5 != "" && tolower(actn_description[moclass,moaction]) !~ Filter5) continue
					if ((Filter2 !~ /^!.+/ && tolower(moaction) ~  Filter2) || \
					    (Filter2  ~ /^!.+/ && tolower(moaction) !~ gensub(/^!/,"",1,Filter2)) ||\
					     Filter2 ~ /^(|all|\.|\*)$/)
					{
						if (headerPrinted["moaction"] != 1)
						{
							customPrint("\n\n")
							customPrint("####################################################################################################################################")
							customPrint(sprintf("%-*s  %-*s  %-20s  %-s",lentab["mo"],"MO Class",lentab["action"],"Action","ReturnType","Parameters"))
							customPrint("####################################################################################################################################")
							headerPrinted["moaction"]=1
						}
						customPrint(sprintf("%-*s  %-*s  %-20s  %-s",lentab["mo"],multicut(moclass,1),lentab["action"],moaction,actn_result[moclass,moaction],action[moclass,moaction]))
						if (what !~ "d")
						{
							customPrint(filterText(Filter5,sprintf("------------------------------------------------------------------------------------------------------------------------------------\n%-s",actn_description[moclass,moaction])))
							customPrint("************************************************************************************************************************************")
						}
					}
				}
			}
		}
	}
	if (what ~ "l" && what !~ "rbl") return
	z=split(sorted_mom_list["structure"],arrayz,",")
	for (k=1;k<=z;k++)
	{
		if (Filter4 !~ /^(|[.*]|all)$/) continue
		structname=arrayz[k]
		if ((negMo==0 && tolower(structname)~Filter1) || (negMo==1 && tolower(structname)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
		{
			Last=split(struct_contents[structname],array,",")
			for (j=1;j<=Last;j++)
			{
				structmember=array[j]
				#if (exclude_deprecated>=2 && struct_description[structname,structmember] ~ /Deprecated:|Obsolete:/) continue
				if ((Filter2 !~ /^!.+/ && tolower(structmember) ~  Filter2) || \
				    (Filter2  ~ /^!.+/ && tolower(structmember) !~ gensub(/^!/,"",1,Filter2)) ||\
				     Filter2 ~ /^(|all|\.|\*)$/)
				{
			        	if ((Filter3 ~ /^(|all|\.|\*)$/)||(tolower(struct_type[structname,structmember])~Filter3))
					{
						if ((Filter5 == "")||(Filter5 ~ /^(|all|\.|\*)$/)||(tolower(struct_description[structname,structmember])~Filter5))
						{
							if (headerPrinted["structmember"] != 1)
							{
								customPrint("\n\n")
								customPrint("##################################################################################")
								if (what ~ "rbl") customPrint(sprintf("%-*s  %-*s  %-20s  %-s",lentab["struct"],"Struct",lentab["member"],"StructMember","Default","Range"))
								else if (what ~ "b") customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],"Struct",lentab["member"],"StructMember","Default"))
								else if (what ~ "r") customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],"Struct",lentab["member"],"StructMember","Range"))
								else customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],"Struct",lentab["member"],"StructMember","Type"))
								customPrint("##################################################################################")
								headerPrinted["structmember"]=1
							}
							if (what ~ "rbl")
							{
								if (attr_default[structname,structmember]!="" || attr_range[structname,structmember]!="")
									customPrint(sprintf("%-*s  %-*s  %-20s  %-s",lentab["struct"],multicut(structname),lentab["member"],structmember,attr_default[structname,structmember],attr_range[structname,structmember]))
							}
							else if (what ~ "b")
							{
								if (attr_default[structname,structmember]!="")
									customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],multicut(structname),lentab["member"],structmember,attr_default[structname,structmember]))
							}
							else if (what ~ "r")
							{
								if (attr_range[structname,structmember]!="")
									customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],multicut(structname),lentab["member"],structmember,attr_range[structname,structmember]))
							}
							else customPrint(sprintf("%-*s  %-*s  %-s",lentab["struct"],multicut(structname),lentab["member"],structmember,struct_type[structname,structmember]))
							if (what !~ /[drbl]/)
							{
								customPrint(filterText(Filter5,sprintf("----------------------------------------------------------------------------------\n%-s",struct_description[structname,structmember])))
								customPrint("**********************************************************************************")
							}
						}
					}
				}
			}
		}
	}
	if (what ~ /[brl]/) return
	z=split(sorted_mom_list["enumerate"],arrayz,",")
	for (k=1;k<=z;k++)
	{
		if (Filter3 !~ /^(|[.*]|all)$/) continue
		if (Filter4 !~ /^(|[.*]|all)$/) continue
		enm=arrayz[k]
		if ((negMo==0 && tolower(enm)~Filter1) || (negMo==1 && tolower(enm)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
		{
			if ((Filter2 !~ /^!.+/ && tolower(enum_contents[enm]) ~  Filter2) || \
			    (Filter2  ~ /^!.+/ && tolower(enum_contents[enm]) !~ gensub(/^!/,"",1,Filter2)) ||\
			     Filter2 ~ /^(|all|\.|\*)$/)
			{
				#if (exclude_deprecated>=2 && enum_description[enm] ~ /Deprecated:|Obsolete:/) continue
				if ((Filter5 == "")||(Filter5 ~ /^(|all|\.|\*)$/)||(tolower(enum_description[enm])~Filter5))
				{
					if (headerPrinted["enum"] != 1)
					{
						customPrint("")
						customPrint("##################################################################################")
						customPrint(sprintf("%-*s  %s",lentab["enum"],"Enum","Values"))
						customPrint("##################################################################################")
						headerPrinted["enum"]=1
					}
					customPrint(sprintf("%-*s  %s",lentab["enum"],multicut(enm),enum_contents[enm]))
					if (what !~ "d")
					{
						customPrint(filterText(Filter5,sprintf("----------------------------------------------------------------------------------\n%s",enum_description[enm])))
						customPrint("**********************************************************************************")
					}
				}
			}
		}
	}
	customPrint("")
	if (comcli==0) return
	z=split(sorted_mom_list["derived"],arrayz,";")
	for (k=1;k<=z;k++)
	{
		if (Filter3 !~ /^(|[.*]|all)$/) continue
		if (Filter4 !~ /^(|[.*]|all)$/) continue
		drv=arrayz[k]
		if ((negMo==0 && tolower(drv)~Filter1) || (negMo==1 && tolower(drv)!~Filter1) || (Filter1 ~ /^(|all|\.|\*)$/))
		{
			if ((Filter2 !~ /^!.+/ && tolower(derived_type[drv]) ~  Filter2) || \
			    (Filter2  ~ /^!.+/ && tolower(derived_type[drv]) !~ gensub(/^!/,"",1,Filter2)) ||\
			     Filter2 ~ /^(|all|\.|\*)$/)
			{
				if ((Filter5 == "")||(Filter5 ~ /^(|all|\.|\*)$/)||(tolower(derived_description[drv])~Filter5))
				{
					if (headerPrinted["derived"] != 1)
					{
						customPrint("")
						customPrint("##################################################################################")
						customPrint(sprintf("%-*s  %s",lentab["derived"],"DerivedDataType","Type"))
						customPrint("##################################################################################")
						headerPrinted["derived"]=1
					}
					customPrint(sprintf("%-*s  %s",lentab["derived"],multicut(drv),derived_type[drv]))
					if (what !~ "d")
					{
						customPrint(filterText(Filter5,sprintf("----------------------------------------------------------------------------------\n%s",derived_description[drv])))
						customPrint("**********************************************************************************")
					}
				}
			}
		}
	}
	customPrint("")
}
function ts(string)
{
	#to convert enum number and translation to just show translation: 1 (USED) -> USED
	return gensub(/^[^(]*\(|\).*$/,"","g",string)
}
function fullmoc(moc,   a,i)
{
	#applicable to comcli only. Takes a MOC and returns the full MOC with mimName in front
	#Eg: iub -> epic_wcdma_mom.iub
	#Eg: Iub -> EPIC_WCDMA_MOM.Iub
	if (moc~/^[^.]+\.[^.]+$/) return moc #In case we already entered a full MOC
	if (tolower(moc)==moc)
	{
		#tolower_mom_moclass_list[comfm.fm] = comfm.fm
		for (i in tolower_mom_moclass_list)
		{
			split(i,a,/\./)
			if (a[2]==moc) return i
		}
	}
	else
	{
		for (i in mom_moclass_list)
		{
			split(i,a,/\./)
			if (a[2]==moc) return i
		}
	}
	return moc
}
function make_hctab(hctab)
{
	#hard coding of the counter pmInDiscAReFail which cannot be read in COMCLI on pRBS W13B
	hctab["aggregation"]="2 (SUM)"
	hctab["collectionMethod"]="1 (CC)"
	hctab["condition"]="Incremented when an incoming packet has a sequence number that is outside the anti-replay window"
	hctab["description"]="The number of incoming packets (after reassembly) which are discarded due to failed anti-replay check."
	hctab["measurementName"]="pmInDiscAReFail"
	hctab["measurementStatus"]="1 (USED)"
	hctab["multiplicity"]=1
	hctab["resetAtGranPeriod"]="true"
	hctab["size"]=4
}
function pmcache_is_valid(file,    res,readfile_command,cache_req)
{
	if (fileOps("test -s "file)!=0) return 1
	delete cache_req
	readfile_command="gzip -dc "file
	while (readfile_command |& getline)
	{
		if ($1=="MOSHELL_PM_CACHE_VERSION" && $2==supported_pmcache_version) cache_req["ver"]=1
		else if ($1=="END_MOSHELL_PM_CACHE") cache_req["end"]=1
	}
	close(readfile_command)
	if (cache_req["ver"] != 1 || cache_req["end"] != 1) return 1
	return 0
}
function comcli_readmom_pm(     motypes,currmo,attr,currmim,mtList,moc,pmc,pmt,hctab,pmgrp,i,n,t_pm_list,pmcachefile,temppmcachefile,molist)
{
	if (length(sorted_Pm_attribute_list)>0) return 0
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)","",1)
	#motypes["pmgroup"]=motypes["measurementtype"]=1
	#ConditionalLoad(motypes)
	load_subtree("SystemFunctions=1,Pm=1","conditional")
	if (nrOfMoType(fullmoc("pmgroup"))==0 || nrOfMoType(fullmoc("measurementtype"))==0) return comcli_error("pm")
	pmcachefile=sprintf("%s/PMCACHE_%s.txt.gz",jarxmldir,mom_version)
	temppmcachefile=sprintf("%s/PMCACHE_%s.txt",tempdir,mom_version)
	if (pmcache_is_valid(pmcachefile)==0 && fileOps("cp "pmcachefile" "tempmtlog".gz")==0 && system("gzip -df "tempmtlog".gz")==0)
	{
		customPrint("Parsing PM cache: "pmcachefile" ... Done.")
	}
	else
	{
		mo_log(tempmtlog,"open","mute","overwrite","silent")
		print "MOSHELL_PM_CACHE_VERSION " supported_pmcache_version  >> tempmtlog
		if (node ~ /^OFFLINE/) $0="kget ^(pmgroup|measurementtype)=" ; else $0="kgetm ^pmgroup="
		kget("short","","m")
		print "END_MOSHELL_PM_CACHE" >> tempmtlog
		mo_log(tempmtlog,"close")
		print ""
		if (fileOps("cp "tempmtlog" "temppmcachefile)==0 && system("gzip -f "temppmcachefile)==0)
		{
			chmod(00666,temppmcachefile".gz")
			fileOps("mv "temppmcachefile".gz "pmcachefile)
		}
	}
	make_hctab(hctab)
	delete correctedPmName
	while (getline < tempmtlog)
	{
		#MO                                   ONRM_ROOTMO_R,SubNetwork=eRBS,MeContext=LTE71Node1,ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup
		# >>> 1.mimName = EPIC_T_L2_VlanPort
		# >>> 4.moClassName = VlanPort
		#MO                                   ONRM_ROOTMO_R,SubNetwork=eRBS,MeContext=LTE71Node1,ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup,MeasurementType=pmDot1qTpVlanPortInFrames
		#aggregation                          2 (SUM)
		#collectionMethod                     1 (CC)
		#condition                            1000 ethernet frames are received on this port with this VLAN and a protocol which is supported by the forwarding process. A frame received on this port is counted by this object if and only if it is for a protocol being processed by the local forwarding process for this VLAN. This object includes received bridge management frames classified as belonging to this VLAN (e.g. GMRP, but not GVRP or STP).
		#derSampleRate                        1
		#description                          The number of valid frames received on this port, belonging to this VLAN and IP interface. If there are more than one IP interface belonging to the same VLAN, the total number of frames for a specific VLAN is the sum of the pmDot1qTpVlanPortInFrames counter for all IP interfaces belonging to the VLAN.
		#fmAlarmType
		#initialValue                         0
		#measurementName                      pmDot1qTpVlanPortInFrames
		#measurementResult                    a single integer value, long type
		#measurementStatus                    1 (USED)
		#measurementTypeId                    pmDot1qTpVlanPortInFrames
		#multiplicity                         1
		#resetAtGranPeriod                    true
		#size                                 4
		#thresholdDirection

		#workaround for pmInDiscAReFail cannot be read
		if (currmo ~ /PmGroup=IpsecTunnelCounterGroup,MeasurementType=pmInDiscAReFail$/ && $2=="!!!!")
		{
			$0=$1" "hctab[$1]
			correctedPmName[currmo]=currmo" "
		}

		if ($1=="MO" && NF==2)
		{
			currmo=gensub(/^(.*,)?ManagedElement=[^,]+/,ComMe,1,$2)
			if (s2t(currmo)~/\.MeasurementType$/) mtList[currmo]=1
		}
		else if ($2~/^[1-9].mimName$/)
		{
			currmim=$4
			#workaround for PmGroup=TR_L2_EthernetPort_CounterGroup and PmGroup=qosTailDropQueueStats , have wrong mimName --> handle below
			#if (currmim=="EthernetPort_Statistics") currmim="RtnL2EthernetPort"
			#else if (currmim=="QueueTailDropStatistics") currmim="RtnQoSSystem"
		}
		else if ($2~/^[1-9].moClassName$/)
		{
			if (mom_version ~ /^(RCS|CRBS|MSRBS)_NODE_MODEL_/) currmim=simpleMimMap[$4]  #on RBSG2/TCU03, the mimName field is not correct
			moc=currmim"."$4
			attr[currmo,"moClass"]=moc
			if (length(moc) > maxLength["pm_moc"]) maxLength["pm_moc"]=length(moc)
		}
		else if (NF>=2)
		{
			attr[currmo,$1]=gensub(/^[^ ]+ +/,"",1,$0)
			if ($1=="measurementName" && length($2) > maxLength["pm_counter"]) maxLength["pm_counter"]=length($2)
		}
	}
	close(tempmtlog)
	#make the following tables PmAttributesType,Pm_attr_comments,Pm_attr_description,pdf_counter_table,pm_deprecated,Pm_attribute_list,sorted_Pm_attribute_list,Pm_counter_list,sorted_Pm_counter_list
	#PmAttributesType[mo:counter]  : long,sequence:long
	#Pm_attr_comments[mo,counter]  : CC,SUM,deprecated
	#Pm_attr_description[mo,counter]
	#pdf_counter_table[counter] = size
	#pm_deprecated[mo,counter]=1
	#pm_deprecated[pmgroup,counter]=1
	#Pm_attribute_list[mo] = counter2,counter3,counter1
	#sorted_Pm_attribute_list[mo] = counter1,counter2,counter3   : does not include the deprecated counters !
	#sorted_Pm_counter_list[pmgroup] = counter1,counter2,counter3: includes the deprecated counters !
	#MeasTypeMo[ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup]=moclass
	#MeasTypeMo[moclass]=ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup
	#MeasTypeMo[mo,counter]=ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup,MeasurementType=pmDot1qTpVlanPortInFrames
	#MeasTypeMo[ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=VlanPortCounterGroup,MeasurementType=pmDot1qTpVlanPortInFrames]=moclass,counter
	for (i in mtList)
	{
		pmgrp=gensub(/,MeasurementType=[^,]+$/,"",1,i)
		moc=attr[pmgrp,"moClass"]
		pmc=attr[i,"measurementName"]
		if (mom_version ~ /^IPWORKS_NODE_MODEL_/ && attr[i,"measurementName"]=="") pmc=attr[i,"measurementTypeId"]
		MeasTypeMo[moc,pmc]=i
		MeasTypeMo[i]=moc","pmc
		MeasTypeMo[moc]=pmgrp
		MeasTypeMo[pmgrp]=moc
		Pm_counter_list[pmgrp]=Pm_counter_list[pmgrp]","pmc
		if (tolower(attr[i,"measurementStatus"]) ~ /deprec|obsol/)
		{
			pm_deprecated[moc,pmc]=1
			pm_deprecated[pmgrp,pmc]=1
			if (exclude_deprecated>0) continue
		}
		Pm_attribute_list[moc]=Pm_attribute_list[moc]","pmc
		attr[i,"size"]+=0
		attr[i,"multiplicity"]+=0
		if (attr[i,"size"] > 4) pmt="longlong"
		else pmt="long"
		if (attr[i,"multiplicity"] > 1)
		{
			PmAttributesType[moc":"pmc]="sequence:"pmt
			pdf_counter_table[pmc]=attr[i,"multiplicity"]
			attr_length[moc,pmc]=attr[i,"multiplicity"]
		}
		else PmAttributesType[moc":"pmc]=pmt
		if (attr[i,"resetAtGranPeriod"]=="false") pmf="noReset" ; else pmf="ropReset"
		if (tolower(ts(attr[i,"measurementStatus"]))!="used") pmf=tolower(ts(attr[i,"measurementStatus"]))","pmf
		Pm_attr_comments[moc,pmc]=pmf","ts(attr[i,"collectionMethod"])","ts(attr[i,"aggregation"])
		Pm_attr_description[moc,pmc]=attr[i,"description"]
		if (attr[i,"condition"]!="") Pm_attr_description[moc,pmc]=Pm_attr_description[moc,pmc]"\nCondition: "attr[i,"condition"]
		sub(/^\n/,"",Pm_attr_description[moc,pmc])
		gsub(/(\\n)+/,"\n",Pm_attr_description[moc,pmc])
	}
	sortTable(Pm_attribute_list,sorted_Pm_attribute_list)
	sortTable(Pm_counter_list,sorted_Pm_counter_list)
	#make the entry sorted_mom_list["pmclass"] containing the keys of the table sorted_Pm_attribute_list
	delete sorted_mom_list["pmclass"]
	for (i in sorted_Pm_attribute_list) t_pm_list[i]=i
	n=asort(t_pm_list)
	for (i=1;i<=n;i++) if (t_pm_list[i]!="") sorted_mom_list["pmclass"]=sorted_mom_list["pmclass"]","t_pm_list[i]
	sub(/^,/,"",sorted_mom_list["pmclass"])
	make_pmxl_pmomfile()
	return 0
}
function make_pmxl_pmomfile()
{
	old_muteFactor=muteFactor
	muteFactor=9999999999999999999
	mo_log(tempmxlpmomlog,"open","mute","overwrite","silent")
	$0="pmom . . "; pmom()
	mo_log(tempmxlpmomlog,"close")
	muteFactor=old_muteFactor
}
function pmom(what,   moclass,ok,structname,structmember,Filter1,Filter2,Filter3,Filter4,Filter5,\
last,i,j,Last,moFilter1,headerPrinted,z,arrayz,k,lentab,field3,Last2,array2,last2,nr_count,nr_count_pdf,printedMo,nr_mo,thePmEntry,negMo)
{
	if (multi && Start_multi()==1) return
	nr_count=nr_count_pdf=nr_mo=negMo=0
	if (multi) lentab["mo"]+=maxMomLength
	if ($2 ~ /^!/) { negMo=1 ; sub(/^!/,"",$2) }
	Filter1 = moFilter1 = tolower($2)
	Filter2 = tolower($3)
	Filter3 = tolower($4) ; if (Filter3=="*" || Filter3=="all") Filter3=".*"
	Filter4 = tolower($5) ; if (Filter4=="*" || Filter4=="all") Filter4=".*"
	Filter5 = tolower($6) ; if (Filter5=="*" || Filter5=="all") Filter5=".*"
	if (comcli==0)
	{
		CheckMom()
		if (mom_version ~ "RNC" && node !~ /^OFFLINE/) make_eventfiles()
		make_pdf_counter_table()
		lentab["mo"]=24
		lentab["pm"]=65
	}
	if (what ~ "k")
	{
		kmom(what,Filter1,Filter2,Filter3,Filter4,Filter5,negMo)
		return
	}
	if (what ~ "c") moFilter1=make_long_filter(moFilter1)
	if (comcli>0)
	{
		if (comcli_readmom_pm()!=0) return
		lentab["mo"]=maxLength["pm_moc"]
		lentab["pm"]=maxLength["pm_counter"]
	}
	if (what ~ "a" && Filter2=="")
	{
		z=split(sorted_mom_list["pull_mo"],arrayz,",")
		for (k=1;k<=z;k++)
		{
			moclass=arrayz[k]
			if (what ~ "o" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "o" && (!(moclass in cppMoList))) continue
			if ((negMo==0 && tolower(moclass)~moFilter1) || (negMo==1 && tolower(moclass)!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (headerPrinted["class"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-*s  %s",lentab["mo"],"MO Class","Attributes Supported in Scanner"))
					customPrint("##################################################################################")
					headerPrinted["class"]=1
				}
				last=split(sorted_pull_attrlist[moclass],array,",")
				if (last > 0)
				{
					customPrint(sprintf("%-*s  %s",lentab["mo"],multicut(moclass,1),last))
					for (i=1;i<=last;i++) customPrint(sprintf("%-*s  %s",lentab["mo"],"",array[i]))
					customPrint("----------------------------------------------------------------------------------")
				}
			}
		}
		return
	}
	if (Filter2 == "")
	{
		if (comcli>0) thePmEntry="pmclass" ; else thePmEntry="moclass"
		z=split(sorted_mom_list[thePmEntry],arrayz,",")
		for (k=1;k<=z;k++)
		{
			moclass=arrayz[k]
			if (what ~ "o" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "o" && (!(moclass in cppMoList))) continue
			if ((negMo==0 && tolower(multicut(moclass,1))~moFilter1) || (negMo==1 && tolower(multicut(moclass,1))!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (headerPrinted["class"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-*s  %s",lentab["mo"],"MO Class","Pm Counters"))
					customPrint("##################################################################################")
					headerPrinted["class"]=1
				}
				if (moclass in sorted_Pm_attribute_list)
				{
					last=split(sorted_Pm_attribute_list[moclass],array,",")
					if (moclass in pm_notInMOM)
					{
						last2=split(pm_notInMOM[moclass],array2,",")
						for (i=1;i<=last2;i++) array[++last]=array2[i]
					}
					customPrint(sprintf("%-*s  %s",lentab["mo"],multicut(moclass,1),last))
					for (i=1;i<=last;i++)
					{
						moattribute=array[i]
						if (moclass":"moattribute in PmAttributesType)
						{
							field3=sprintf("%s%s%s",\
						       (sprintf("%s%s%s",moclass,SUBSEP,moattribute) in attr_length?" ["attr_length[moclass,moattribute]"]":""),\
						       (moclass in pm_implemented && (!(moclass":"moattribute in pm_implemented))?" (notImplemented)":""),\
						       ((moclass,moattribute) in pm_deprecated?" (deprecated)":""))
						}
						else field3=((moclass,moattribute) in attr_length?" ["attr_length[moclass,moattribute]"]":"") " (notInMOM)"
						customPrint(sprintf("%-*s  %s%s",lentab["mo"],"",moattribute,field3))
						if ((moclass,moattribute) in attr_length) nr_count_pdf=nr_count_pdf+attr_length[moclass,moattribute]
						else nr_count_pdf++
						nr_count++
						printedMo[moclass]=1
					}
					customPrint("----------------------------------------------------------------------------------")
				}
			}
		}
		if (mom_version != "") customPrint("\nEnter a second argument in the pmom command for description of a counter (or type \"h pmom\" for help).")
	}
	else
	{
		if (comcli>0) thePmEntry="pmclass" ; else thePmEntry="moclass"
		z=split(sorted_mom_list[thePmEntry],arrayz,",")
		for (k=1;k<=z;k++)
		{
			moclass=arrayz[k]
			if (what ~ "o" && moclass in cppMoList) continue
			else if (what ~ "p" && what !~ "o" && (!(moclass in cppMoList))) continue
			if (what ~ "a") { if (!(moclass in sorted_pull_attrlist)) continue }
			else { if (!(moclass in sorted_Pm_attribute_list)) continue }
			if (!((negMo==0 && tolower(moclass)~moFilter1) || (negMo==1 && tolower(moclass)!~moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))) continue
			if (what ~ "a") Last=split(sorted_pull_attrlist[moclass],array,",")
			else Last=split(sorted_Pm_attribute_list[moclass],array,",")
			if (moclass in pm_notInMOM)
			{
				Last2=split(pm_notInMOM[moclass],array2,",")
				for (j=1;j<=Last2;j++) array[++Last]=array2[j]
			}
			for (j=1;j<=Last;j++)
			{
				moattribute=array[j]
				field3=field4=field5=""
				if (what ~ "a")
				{
					if (moclass":"moattribute in MoAttributesType)
					{
						field5=attr_description[moclass,moattribute]
						field4=attr_comments[moclass,moattribute]
						field3=MoAttributesType[moclass":"moattribute]
					}
				}
				else
				{
					if (moclass":"moattribute in PmAttributesType)
					{
						field5=Pm_attr_description[moclass,moattribute]
						field4=Pm_attr_comments[moclass,moattribute]
						field3=sprintf("%s%s%s",PmAttributesType[moclass":"moattribute],\
					       (sprintf("%s%s%s",moclass,SUBSEP,moattribute) in attr_length?" ["attr_length[moclass,moattribute]"]":""),\
					       (moclass in pm_implemented && (!(moclass":"moattribute in pm_implemented))?" (notImplemented)":""))
					}
					else
					{
						field3=((moclass,moattribute) in attr_length?"["attr_length[moclass,moattribute]"]":"?")
						field4="notInMOM"
						field5=""
					}
				}

				if (check_mom_condition(Filter2,moattribute)==1) continue
				if (check_mom_condition3(Filter3,field3)==1) continue
				if (check_mom_condition4(Filter4,field4)==1) continue
				if (check_mom_condition5(Filter5,field5)==1) continue

				if (headerPrinted["counter"] != 1)
				{
					customPrint("")
					customPrint("####################################################################################################################################")
					customPrint(sprintf("%-*s  %-*s  %-19s  %s",lentab["mo"],"MO Class",lentab["pm"],(what ~ "a"?"Attributes Supported in Scanner":"Pm Counter"),"Type","Flags"))
					customPrint("####################################################################################################################################")
					headerPrinted["counter"]=1
				}
				customPrint(sprintf("%-*s  %-*s  %-19s  %s",lentab["mo"],multicut(moclass,1),lentab["pm"],moattribute,field3,field4))
				if (what !~ "d")
				{
					customPrint(filterText(Filter5,sprintf("------------------------------------------------------------------------------------------------------------------------------------\n%s",field5)))
					customPrint("************************************************************************************************************************************")
				}
				if ((moclass,moattribute) in attr_length) nr_count_pdf=nr_count_pdf+attr_length[moclass,moattribute]
				else nr_count_pdf++
				nr_count++
				printedMo[moclass]=1
			}
		}
	}
	customPrint("")
	for (moclass in printedMo) nr_mo++
	customPrint("Total: "nr_mo" MOs, "nr_count" counters "(nr_count!=nr_count_pdf?" ("nr_count_pdf" including PDF)":""))
}
function lmom(what,   moclass,ok,structname,structmember,Filter1,Filter2,Filter3,Filter4,Filter5,last,i,moFilter1,headerPrinted,Last)
{
	if (multi) return multi_error()
	if (comcli>0) return comcli_error()
	Filter1 = moFilter1 = tolower($2)
	Filter2 = tolower($3)
	Filter3 = "all"
	Filter4 = "all"
	Filter5 = tolower($4)
	if (what ~ "c") moFilter1=make_long_filter(moFilter1)
	CheckMom()
	if (cdmaMOM != 1)
	{
		if (mom_version != "") customPrint("\nLMOM command is only applicable for CDMA nodes.")
		return
	}
	if (Filter2 == "")
	{
		for (moclass in sorted_Log_attribute_list)
		{
			if ((tolower(moclass) ~ moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				if (headerPrinted["class"] != 1)
				{
					customPrint("")
					customPrint("##################################################################################")
					customPrint(sprintf("%-20s  %s","MO Class","LogAttributes"))
					customPrint("##################################################################################")
					headerPrinted["class"]=1
				}
				last=split(sorted_Log_attribute_list[moclass],array,",")
				customPrint(sprintf("%-20s  %s",moclass,last))
				for (i=1;i<=last;i++) customPrint(sprintf("%-20s  %s","",array[i]))
				customPrint("----------------------------------------------------------------------------------")
			}
		}
		customPrint("\nEnter a second argument in the lmom command for description of a LogAttribute")
	}
	else
	{
		for (moclass in sorted_Log_attribute_list)
		{
			if ((tolower(moclass) ~ moFilter1) || (Filter1 ~ /^(|all|\.|\*)$/))
			{
				Last=split(sorted_Log_attribute_list[moclass],array,",")
				for (j=1;j<=Last;j++)
				{
					moattribute=array[j]
					if (tolower(moattribute) ~ Filter2 || Filter2 ~ /^(|all|\.|\*)$/)
					{
						if ((Filter5 == "")||(Filter5 ~ /^(|all|\.|\*)$/)||(tolower(Log_attr_description[moclass,moattribute])~Filter5))
						{
							if (headerPrinted["counter"] != 1)
							{
								customPrint("")
								customPrint("##################################################################################")
								customPrint(sprintf("%-20s  %-s","MO Class","LogAttribute"))
								customPrint("##################################################################################")
								headerPrinted["counter"]=1
							}
							customPrint(sprintf("%-20s  %-s",moclass,moattribute))
							customPrint("----------------------------------------------------------------------------------")
							customPrint(sprintf("%s",Log_attr_description[moclass,moattribute]))
							customPrint("**********************************************************************************")
						}
					}
				}
			}
		}

	}
	customPrint("")
}
function kmom(what,Filter1,Filter2,Filter3,Filter4,Filter5,negMo,    dfile,afile,n,p,i,j,output,ufile,mfile,sepline,tot,printedKpiList,ffile,trel)
{
	if (Filter3==".") Filter3=".*"  #the unit is sometimes empty
	if (mom_version !~ /(RNC|^W?P?RBS)_NODE_MODEL/)
	{
		customPrint("\nKPI descriptions are currently only available for WCDMA RNC/RBS.")
		return
	}
	if (kmom_done!=1)
	{
		kmom_done=1
		if ((mom_version ~ "RNC" && mom_version >= "RNC_NODE_MODEL_V")||(mom_version ~ "RBS" && mom_version >= "RBS_NODE_MODEL_U")) trel="W15A"
		else trel="W13B"
		dfile=commonjardir"/pm/"trel"_kpidescriptions.txt"
		afile=commonjardir"/pm/"trel"_kpiareas.txt"
		ufile=commonjardir"/pm/"trel"_kpiunits.txt"
		mfile=commonjardir"/pm/"trel"_kpimos.txt"
		if (mom_version ~ /RNC/) ffile=commonjardir"/pm/FORMULA_RNC_"trel"_official.txt"
		else if (mom_version ~ /RBS/) ffile=commonjardir"/pm/FORMULA_RBS_"trel"_official.txt"
		parse_kfile(dfile,"d")
		parse_kfile(afile,"a")
		parse_kfile(ufile,"u")
		parse_kfile(mfile,"m")
		parse_kfile(ffile,"f")
	}
	n=asort(kmomKpiAreaList)
	p=asort(kmomKpiList)
	sepline="------------------------------------------------------------------------------------------------------------------------------------"
customPrint(sprintf("\n####################################################################################################################################\n\
%-*s  %-*s  %-4s  %s\n\
####################################################################################################################################",\
kmomLength["area"],"KPI Area",kmomLength["kpi"],"Name","Unit","MOs"))
	tot=0
	for (i=1;i<=n;i++)
	{
		for(j=1;j<=p;j++)
		{
			if (kmomKpiArea[kmomKpiList[j]]!=kmomKpiAreaList[i]) continue
			if (negMo==0 && tolower(kmomKpiAreaList[i])!~Filter1) continue
			if (negMo==1 && tolower(kmomKpiAreaList[i])~Filter1) continue
			if (tolower(kmomKpiList[j])!~Filter2) continue
			if (tolower(kmomKpiMos[kmomKpiList[j]])!~Filter3) continue
			if (tolower(kmomKpiForm[kmomKpiList[j]])!~Filter4) continue
			if (tolower(kmomKpiDesc[kmomKpiList[j]])!~Filter5) continue
			output=sprintf("%-*s  %-*s  %4s  %s",kmomLength["area"],kmomKpiAreaList[i],kmomLength["kpi"],kmomKpiList[j],kmomKpiUnit[kmomKpiList[j]],kmomKpiMos[kmomKpiList[j]])
			if (what!~"d") output=sprintf("%s\n%s\n%s = %s\n%s",output,kmomKpiDesc[kmomKpiList[j]],kmomKpiList[j],kmomKpiForm[kmomKpiList[j]],sepline)
			customPrint(output)
			printedKpiList=printedKpiList","kmomKpiList[j]
			tot++
		}
	}
	customPrint(sprintf("\n>>> Total: %s KPIs",tot))
	if (mosdebug==1) print gensub(/^,/,"",1,printedKpiList)

}
function parse_kfile(file,what,   kpi,contents)
{
	if (fileOps("test -s "file)!=0) { customPrint("ERROR: cannot find "file) ; return }
	while (getline<file)
	{
		gsub("\r","")
		if (what!="f" && mom_version ~ "RNC" && $2!="RNC") continue
		if (what!="f" && mom_version ~ "RBS" && $2!="RBS") continue
		if (what=="f" && $2!="=") continue
		if ($1~/^#/) continue
		if (NF<3) continue
		gsub(/[\t]/," ")
		kpi=$1
		kmomKpiList[kpi]=kpi
		if (length(kpi)>kmomLength["kpi"])kmomLength["kpi"]=length(kpi)
		contents=gensub(/^[ ]*[^ ]+[ ]+[^ ]+[ ]+/,"",1,$0)
		gsub(/[ ]*<br>[ ]*/,". ",contents)
		gsub(/^[ ]*|[ ]*$/,"",contents)
		gsub(/[ ][ ]+/," ",contents)
		if (what=="a")
		{
			gsub(/ /,"",contents)
			if (contents ~ /CCSR/) contents="CCSR"
			kmomKpiAreaList[contents]=contents
			kmomKpiArea[kpi]=contents
			if (length(contents)>kmomLength["area"])kmomLength["area"]=length(contents)
		}
		else if (what=="u") kmomKpiUnit[kpi]=contents
		else if (what=="m") kmomKpiMos[kpi]=contents
		else if (what=="d") kmomKpiDesc[kpi]=contents
		else if (what=="f") kmomKpiForm[kpi]=contents

	}
	close(file)
}

function reconnect_java(what)
{
	#Check if we are offline:
	if (node ~ /^OFFLINE/)
	{
		customPrint("\nCommand unavailable in offline mode.")
		return
	}

	if (comcli>0)
	{
		return close_comcli()
		#return comcli_error()
	}
	if (multi)
	{
		#if (what ~ "i") for (i=1;i<=nrOfNodes;i++) httpget(nodeList[i],"/cello/ior_files/nameroot.ior",iorfile,"ior")
		ReConnectNeal(1)
	}
	else
	{
		if (what ~ "i")
		{
			Poll("h",0,0)
			httpget(node_address,"/cello/ior_files/nameroot.ior",iorfile,"ior","","",medium_timeout)
		}
		ReConnect(10,1,what)
		customPrint("")
		if (pmtesterStarted==1) ReConnectPm(10,1,what)
	}
}
function ReConnect(timer,disconnect,what,forceior,ltall)
{
	if (disconnect == 1 && mobrowserStarted==1 && is_process_there(moshell_java_proc["mobrowser"]) == 0)
	{
		if (what !~ "c")
		{
			#the "c" option can be used in case we had done ctrl-c previously (by doing the command "rec")
			#then the mobrowser process is already dead so we shouldnt try to input/output to it or it will crash moshell
			print 9  |& TestClient
			while (TestClient |& getline) {}
		}
		close(TestClient)
		delete moshell_java_proclist[moshell_java_proc["mobrowser"]]
		#sleep(timer)
	}
	TestClient=make_java_command("mobrowser","",forceior)
	if (TestClient==99) return 99
	if (Restart_MoBrowser(timer)==99) return 99
	$0="" ; Load_Proxys("rootstart")
	ReadNodeName()
	if (ltall=="ltall")
	{
		$0="lt all" ; Load_Proxys("all")
	}
}
function ReConnectPm(timer,disconnect,what,forceior)
{
	if (disconnect == 1 && pmtesterStarted==1 && is_process_there(moshell_java_proc["pmtester"]) == 0)
	{
		if (what !~ "c")
		{
			#the "c" option can be used in case we had done ctrl-c previously (by doing the command "rec")
			#then the mobrowser process is already dead so we shouldnt try to input/output to it or it will crash moshell
			print 10  |& PmClient
			while (PmClient |& getline) {}
		}
		close(PmClient)
		delete moshell_java_proclist[moshell_java_proc["pmtester"]]
		#sleep(timer)
	}
	PmClient=make_java_command("pmtester_with_fix","",forceior)
	if (PmClient==99) return 99
	if (Restart_PmTester(timer)==99) return 99
}
function ReConnectNeal(disconnect)
{
	if (disconnect == 2)
	{
		print "kill "moshell_java_proc["nealbrowser"]
		system("kill "moshell_java_proc["nealbrowser"])
		delete moshell_java_proclist[moshell_java_proc["nealbrowser"]]
	}
	else if (disconnect == 1 && nealStarted==1 && is_process_there(moshell_java_proc["nealbrowser"]) == 0)
	{
		print 9 |& TestClient
		while (TestClient |& getline) {}
		close(TestClient)
		delete moshell_java_proclist[moshell_java_proc["nealbrowser"]]
	}
	TestClient=make_java_command("nealmob")
	if (TestClient==99) return 99
	PmClient=TestClient
	system("")
	close(TestClient)
	nealStarted=0
	clear_internal_proxy_table()
    	while (TestClient |& getline)
	{
		gsub("\r","")
		if ($1 == "Enter_choice_or_type_8_for_help")
		{
			nealStarted=1
			customPrint("")
			find_javaprocess(gawk_pid,"nealbrowser")
			break
		}
		else if (/^Connecting to /) customPrint(sprintf("%s(%s)... ",$0,nodeName[$3]),"","","noLF")
		else if (NF > 0) customPrint($0)
		#if ($0 ~ javaErrorString) fatal_error=$0
	}
	$0="" ; Load_Proxys("rootstart")
}
function check_whoami(   res,whoami_session)
{
	if (whoAmI=="")
	{
		whoami_session="whoami 2>&1"
		whoami_session | getline res
		close(whoami_session)
		whoAmI=res
	}
}
function find_javaprocess(pid,what,theport,   line,pscom,procchildren,procname,array,array1,i,j,s,res,tres)
{
	if (mosdebug==3) print "DEBUG0: pid="pid", what="what
	#to find the pid of the java process, child of gawk_pid
	pscom="/bin/ps -fu "PROCINFO["uid"]" 2>&1"
	if (os=="cygwin")
	{
		check_whoami()
		if (whoAmI ~ /\+/) pscom="/bin/ps -fu "whoAmI" 2>&1"
	}
	#ps -fu <user>
	#eanzmagn    1352    3000  12  08:30:59 /usr/bin/ps
	#Martin A    4060       1 con  09:54:52 /usr/bin/rxvt
	if (mosdebug==3) print "DEBUG: pscom="pscom
	while (pscom |& getline line)
	{
		gsub("\r","",line)
		if (os=="cygwin" && line ~ /user .* unknown/)
		{
			customPrint(line)
			customPrint("\nTry running the following command from the cygwin prompt: \nmkpasswd -l -c > /etc/passwd && mkgroup -l -c > /etc/group\n")
		}
		split(line,array," ")
		if (mosdebug==3) print "DEBUG: line="line
		if (array[2]~/^[0-9]+$/) s=2 ; else s=3
		procchildren[array[s+1]]=procchildren[array[s+1]]","array[s]
		procname[array[s]]=line
	}
	close(pscom)
	for (i in procchildren) gsub(/^,/,"",procchildren[i])
	if (mosdebug==3)
	{
		print "\nprocchildren:"
		for (i in procchildren) print "DEBUG: "i,procchildren[i]
		print "\nprocname:"
		for (i in procname)     print "DEBUG: "i,procname[i]
	}
	split(procchildren[pid],array,",")
	for (i in array)
	{
		if (what~/^(rtrdb|postgres)$/)
		{
			res=analyse_proc(array[i],procname[array[i]],what)
			if (res ~ /^[0-9]+$/) return res
			#sometimes the rtrdb process is a child of "sh -c"
			split(procchildren[array[i]],array1,",")
			for (j in array1)
			{
				res=analyse_proc(array1[j],procname[array1[j]],what)
				if (res ~ /^[0-9]+$/) return res
			}
		}
		else
		{
			#mobrowser, pmtester, nealbrowser, ...
			#1. analyse the children's children
			split(procchildren[array[i]],array1,",")
			for (j in array1)
			{
				tres=analyse_proc(array1[j],procname[array1[j]],what,theport)
				if (tres ~ /^[0-9]+$/) res=tres
			}
		}
	}
	#2. if java pid not found, analyse the direct children (happens in solaris 11, the java process is direct child of the gawk process, instead of grandchild)
	if (res !~ /^[0-9]+$/)
	{
		for (i in array)
		{
			res=analyse_proc(array[i],procname[array[i]],what,theport)
		}
	}
	return res
}
function analyse_proc(process_id,process_name,what,theport,    ppid)
{
	if (process_name ~ /ps($| -fu)/) return ""
	if (process_id in moshell_java_proclist) return ""
	if (what=="rtrdb")
	{
		if (process_name !~ /\/rtrdb/) return ""
		if (process_name ~ / sh -c /) return ""
	}
	else if (what=="postgres")
	{
		if (process_name !~ /\/postgres/) return ""
		if (process_name ~ / sh -c /) return ""
	}
	else if (what=="ssh" && process_name ~ /sshd/) return ""
	#else if (what=="netconf" && os!="cygwin" && process_name !~ sprintf(" -p %s | -connect .*:%s ",theport,theport)) return ""
	moshell_java_proc[what]=process_id    #global variable
	moshell_java_proclist[process_id]=1   #global variable
	ppid=find_ppid(process_id)
	if (ppid!="") moshell_java_procparent[process_id]=ppid
	assignCustomVar("$"what"_pid",process_id,"","system")
	if (what=="rtrdb" || what=="postgres") return process_id
	customPrint("$"what"_pid = "process_id"\n")
	return process_id
	#return ""
}
function Restart_MoBrowser(timer,counter,  fatal_error,i,linePrinted)
{
	#timer in seconds, time between each reconnection attempt, after 600 sec (10 mins), give up.
	system("")
	close(TestClient)
	mobrowserStarted=0
	if (node !~ /^OFFLINE/) clear_internal_proxy_table() #when we do a trun in offline mode we do not want to clear the proxy table
	#tid(1)
    	while (TestClient |& getline)
	{
		gsub("\r","")
		if ($1 == "Enter_choice_or_type_8_for_help")
		{
			#tid(2)
			mobrowserStarted=1
			find_javaprocess(gawk_pid,"mobrowser")
			break
		}
		else if (linePrinted[$0]!=1)
		{
			if ($1!="at") customPrint($0)
			else if (mosdebug==1) print $0
			linePrinted[$0]=1
		}
		if ($0 ~ javaErrorString) fatal_error=$0
		#if we entered the wrong password from command line, we reset it here
		if (sls_password_was_read_from_prompt==1 && /FailedLoginException|Wrong username or password/)
		{
			sls_password=""
			sls_password_was_read_from_prompt=0
		}
	}
	#tid(3)
	if (mobrowserStarted==0)
	{
		close(TestClient)
		if (corba_class==2 && CorbaSecurity=="ON")
		{
			if (exit_with_error("conditional")==1) return 99
		}
		if (fatal_error != "")
		{
			for (i=1;i<=javaErrorNumber;i++)
			{
				if (fatal_error ~ javaErrorList[i])
				{
					if (i in javaErrorMessage) customPrint(javaErrorMessage[i])
					break
				}
			}
			if (exit_with_error("conditional")==1)
			{
				return 99
			}
		}
		counter++
		if (counter*timer >= max_poll_time)
		{
			if (exit_with_error("conditional")==1) return 99
		}
		customPrint(sprintf("MO service not ready, retrying in %s seconds...",timer))
		mysleep(timer)
		if (Restart_MoBrowser(timer,counter)==99) return 99
	}

}
function Restart_PmTester(timer,counter,  fatal_error,i,linePrinted)
{
	#timer in seconds, time between each reconnection attempt, after 600 sec (10 mins), give up.
	system("")
	close(PmClient)
	pmtesterStarted=0
	#clear_internal_proxy_table()
    	while (PmClient |& getline)
	{
		gsub("\r","") ; if (corba_debug >= 1) customPrint($0)
		if ($1 == pmStop)
		{
			pmtesterStarted=1
			find_javaprocess(gawk_pid,"pmtester")
			break
		}
		else if (linePrinted[$0]!=1)
		{
			if ($1!="at") customPrint($0)
			else if (mosdebug==1) print $0
			linePrinted[$0]=1
		}
		if ($0 ~ javaErrorString) fatal_error=$0
		if (sls_password_was_read_from_prompt==1 && /FailedLoginException|Wrong username or password/)
		{
			sls_password=""
			sls_password_was_read_from_prompt=0
		}
	}
	if (pmtesterStarted==0)
	{
		close(PmClient)
		if (corba_class==2 && CorbaSecurity=="ON")
		{
			if (exit_with_error("conditional")==1) return 99
		}
		if (fatal_error != "")
		{
			for (i=1;i<=javaErrorNumber;i++)
			{
				if (fatal_error ~ javaErrorList[i])
				{
					if (i in javaErrorMessage) customPrint(javaErrorMessage[i])
					break
				}
			}
			if (exit_with_error("conditional")==1) return 99
		}
		counter++
		if (counter*timer >= max_poll_time)
		{
			if  (exit_with_error("conditional")==1) return 99
		}
		customPrint(sprintf("PM service not ready, retrying in %s seconds...",timer))
		mysleep(timer)
		if (Restart_PmTester(timer,counter)==99) return 99
	}
}

function create_session(what,    result)
{
	if (node ~ /^OFFLINE/) return ""
	if (comcli>0) return ""
	if (what=="commit") print 79 |& TestClient
	else if (what=="rollback") print 80 |& TestClient
	else print 78 |& TestClient
	while (TestClient |& getline)
	{
		gsub("\r","")
		gsub("Your choice: ","")
		if ($1 == "Enter_choice_or_type_8_for_help") break
		else if (NF>0) result=result"\n"$0
	}
	return gensub(/^\n/,"",1,result)
}
function jvm_gc()
{
	#print "GARBAGE COLLECT"
	if (node ~ /^OFFLINE/ || comcli>0) return
	print 72 |& TestClient
	while (TestClient |& getline)
	{
		gsub("\r","")
		if ($1 == "Enter_choice_or_type_8_for_help") break
	}
}
function prepare_mib_loading(   array,i,moclass)
{
	if (MomHasBeenRead !=1)
	{
#		customPrint(sprintf("\nPlease parse a MOM before proceeding.\n\
#MOM files are stored in %s/jarxml and can be parsed using the \"parsemom\" command.",moshelldir))
#		customPrint("Then run command \"lt <modump>\".")
		return 2
	}
	mib_maxProxy=-1
	delete mom_DirectMeChildren
	dn_prefix=""
	#make global tables mom_DirectMeChildren and first_attribute_table
	split(sorted_childList["ManagedElement"],array,";")
	for (i in array) mom_DirectMeChildren[array[i]]=array[i]
	for (moclass in sorted_attribute_list) first_attribute_table[gensub(/,.*$/,"",1,sorted_attribute_list[moclass])]=1
	if (mibtype=="get") { MO_POS=1 ; ATT_POS=2 }
	else if (mibtype=="getp") { MO_POS=2 ; ATT_POS=3 }
	return 1
}
function unzip_mibfile(file,destdir,what,what2,what3,     tmpmomf,fileList,tmpfile,tmpmibf,n,i,unzip_session,infostring)
{
	if (dbdat) infostring="db.dat" ; else infostring="MO dump"
	if (fileOps("test -d "destdir)!=0 || file != unzipList["dump"] || what3=="fresh")
	{
		if ((what3=="fresh")||(file != unzipList["dump"] && unzipList["dump"] != "")) system("rm -rf "destdir)
		system("mkdir -p "destdir)
		chmod(00777,destdir)
		unzip_session="unzip -ojq "file" -d "destdir
		customPrint(unzip_session)
		system(unzip_session)
		customPrint("")
		unzipList["dump"]=file
	}
	n=fileOps("ftree "destdir,fileList)
	n=asort(fileList)   #sort the fileList in alphabetical order so the dcg_k.log.gz file will come before the showall.log.gz file
	for (i=1;i<=n;i++)
	{
		tmpfile=fileList[i]
		if (dbdat)
		{
			if (tmpfile ~ /\.dat$/) tmpmibf=fileList[i]
			continue
		}
		tmpmomf=jarxmldir"/"gensub(/^.*\//,"",1,tmpfile)
		if (tmpfile ~ /\.xml(\.(gz|jar)$)?/ && fileOps("test -s "tmpmomf)!=0 &&\
		    fileOps("grep </models> "tmpfile)==0 && fileOps("grep \x000\x000\x000\x000\x000\x000 "tmpfile)!=0)
		{
			customPrint("Moving "tmpfile" to "tmpmomf" ...Done.")
			fileOps("mv "tmpfile" "tmpmomf)
			chmod(00666,tmpmomf)
			if (tmpmomf ~ /\.xml$/ && system("gzip -f "tmpmomf)==0)
			{
				customPrint("Compressing File to "tmpmomf".gz ...Done.")
				chmod(00666,tmpmomf)
			}
			customPrint("")
		}
		else if (tmpfile ~ "drhlog.txt")
		{
			customPrint("Found RNC device/module data: "tmpfile)
			fileOps("cp "tmpfile" "tempdrhlog)
		}
		else if (tmpfile ~ "cppbdlog.txt")
		{
			customPrint("Found CPP board data: "tmpfile)
			fileOps("cp "tmpfile" "tempcpplog)
		}
		else if (tmpfile ~ "rbsbdlog.txt")
		{
			customPrint("Found RBS board data: "tmpfile)
			fileOps("cp "tmpfile" "temprbslog)
		}
		else if (tmpfile ~ "rfbdlog.txt")
		{
			customPrint("Found RBS HW data: "tmpfile)
			fileOps("cp "tmpfile" "tempxmulog)
		}
		else if (tmpfile ~ "rnclog.txt")
		{
			customPrint("Found RNC board data: "tmpfile)
			fileOps("cp "tmpfile" "temprnclog)
			coliLog[++NColi]=tmpfile
		}
		else if (tmpfile ~ "invllog.txt")
		{
			customPrint("Found license data: "tmpfile)
			fileOps("cp "tmpfile" "tempinvllog)
		}
		else if (tmpfile ~ "alarmlist.txt$")
		{
			customPrint("Found alarm data: "tmpfile)
			fileOps("cp "tmpfile" "tempalliplog)
		}
		else if (tmpfile ~ "pmscanners.txt$")
		{
			customPrint("Found pm scanner data: "tmpfile)
			fileOps("cp "tmpfile" "tempscannerlog)
		}
		else if (tmpfile ~ "rftlog.txt")
		{
			customPrint("Found RF data: "tmpfile)
			fileOps("cp "tmpfile" "temprftlog)
			#coliLog[++NColi]=tmpfile
		}
		else if (tmpfile ~ "tnplog.txt")
		{
			customPrint("Found TN data: "tmpfile)
			fileOps("cp "tmpfile" "temptnlog)
		}
		else if (tmpfile ~ "intmomlog.txt")
		{
			customPrint("Found internalmom data: "tmpfile)
			fileOps("cp "tmpfile" "tempintmomlog)
			coliLog[++NColi]=tmpfile
		}
		else if (tmpfile ~ "intmomlog2.txt")
		{
			customPrint("Found internalmom data: "tmpfile)
			fileOps("cp "tmpfile" "tempintmomlog2)
			coliLog[++NColi]=tmpfile
		}
		else if (use_testmomdump==1 && tmpfile ~ "intmomlog3.txt")
		{
			customPrint("Found testmom data: "tmpfile)
			fileOps("cp "tmpfile" "tempintmomlog3)
		}
		else if (tmpfile ~ "bglog_[0-9]+.log(.gz)?$") { }  #ignore the bglog files, used only for debug purpose
		else if (comcli>0 && what2=="" && tmpfile ~ "showall.log") tmpmibf=fileList[i]   #what2 can be used to override not using the showall file, eg in diff function
		else if (comcli>0 && what2!="" && tmpfile !~ /\.xml(\.(gz|jar)$)?/ && tmpmibf=="")  tmpmibf=fileList[i]  #this instruction should only happen when processing a modump from the diff command in a COM node
		else if (comcli==0 && tmpfile !~ /uvpv\.txt$|\.xml(\.(gz|jar)$)?/ && tmpmibf=="") tmpmibf=fileList[i]
		else if (tmpfile ~ /.+_modump.zip/) tmpmibf=fileList[i]  #in case we gave a zipfile containing a modump.zip
		else if (tmpfile ~ /.+_offline.zip/) tmpmibf=fileList[i]  #in case we gave a zipfile containing a offline.zip
	}
	if (tmpmibf!="") customPrint("Found "infostring": "tmpmibf"\n") ; else customPrint("Unable to find a "infostring"!")
	if (what=="dcgk" && tmpmibf ~ /.+_modump.zip/)
	{
		#we need to continue unzipping till we find a dcg_k.log.gz
		fileOps("mv "tmpmibf" "tempdir)
		tmpmibf=tempdir"/"gensub(/^.*\//,"",1,tmpmibf)
		return unzip_mibfile(tmpmibf,destdir,"",what2)
	}
	return tmpmibf
}
function remove_corrupted_mom_file(file)
{
	#check if the file is not gzipped. in that case, gzip it
	if (file ~ /\.xml$/ && fileOps("test -s "file)==0 && system("gzip -f "file)==0)
	{
		customPrint("Compressing File to "file".gz ...Done.")
		chmod(00666,file)
	}
	#to check if a mom_file is corrupted. if yes, it is removed
	if (fileOps("test -s "file".gz")==0) file=file".gz"
	else if (fileOps("test -s "file".jar")==0) file=file".jar"
	if (fileOps("test -s "file)==0)
	{
		if (fileOps("grep </models> "file)!=0 || fileOps("grep \x000\x000\x000\x000\x000\x000 "file)==0) fileOps("rm "file)
	}
}
function find_mom_file(mom_file,silent,    result)
{
	#first check if the momfile if is corrupted. if it is corrupted, it will be removed
	remove_corrupted_mom_file(mom_file)
	#now check
	if (fileOps("test -s "mom_file".gz")==0) mom_file=mom_file".gz"
	else if (fileOps("test -s "mom_file".jar")==0) mom_file=mom_file".jar"
	else
	{
		fetch_mom_from_utran01(mom_file".gz")
		if (fileOps("test -s "mom_file".gz")==0) mom_file=mom_file".gz"
	}
	if (fileOps("test -s "mom_file) != 0)
	{
		if (silent!="silent") customPrint("MOM file: "mom_file" not found! Please find this file and try again.")
		result=1
	}
	else
	{
		result=0
	}
	return result
}
function dbpgets(what,     n,i,Filter1,Filter2,proxy,line,tot,output)
{
	Filter1=tolower($2)
	Filter2=tolower($3)
	tot=0
	n=asort(pmrowlist)
	#for (i=1;i<=n;i++) print pmrowlist[i],mibtablePM[pmrowlist[i]]
	line="================================================================================"
	if (what=="pst") customPrint(sprintf("%s\n  PROXY  SCANNER-NAME                                                  STATE\n%s",line,line))
	for (i=1;i<=n;i++)
	{
		proxy=pmrowlist[i]
		if (Filter1~/^[0-9]+$/){ if (proxy!=Filter1) continue }
		else if (tolower(mibtablePM[proxy,"name"]) !~ Filter1) continue
		if (what=="pst") customPrint(sprintf("%7s  %-62s  %s",proxy,mibtablePM[proxy,"name"],mibtablePM[proxy,"state"]))
		else
		{
			output=sprintf("%s\n%-7s  %-40s  %-9s  %-3s  %s\n%s%s",line,proxy,mibtablePM[proxy,"name"],mibtablePM[proxy,"state"],\
mibtablePM[proxy,"gran"],mibtablePM[proxy,"nr_cnt"],line,mibtablePM[proxy,"data"])
			if (tolower(output) !~ Filter2) continue
			customPrint(output)
		}
		tot++
	}
	customPrint(sprintf("%s\n>>> Total: %s Scanners",line,tot))
}
function dbscannercheck(     n,i,proxy,array,last,j)
{
	n=asort(pmrowlist)
	for (i=1;i<=n;i++)
	{
		proxy=pmrowlist[i]
		split(mibtablePM[proxy,"data"],array,"\n")
	}
}
function dbget(molength,mget,fro,kget_format,      proxyList,otherVars,i,p,varName,Filter2,Filter3,count,array,j,n,output,resTable,varValue,neg2,neg3)
{
	if (fro=="fro" && $3=="") $3="."
	if ($4 == ">" && NF == 5 && $5 ~ /^\$/) varName=convertWord($5)
	buildProxyList(molength,proxyList,otherVars)
	Filter2=otherVars["Filter2"]
	if (varName == "") Filter3=otherVars["Filter3"]
	if (Filter2 ~ /^![^!]+/) { sub(/^!/,"",Filter2) ; neg2=1 }
	if (Filter3 ~ /^![^!]+/) { sub(/^!/,"",Filter3) ; neg3=1 }
	if (Filter2 != "") customPrint(sprintf("\
=================================================================================================================\n\
%s%-80s %-17s %s\n\
=================================================================================================================",\
(get_printoutformat == "proxy"?sprintf("%-5s ","Proxy"):""),"MO","Attribute","Value"))
	for (i=1;i<=otherVars["p"];i++)
	{
		resTable["ok"]=0
		if (Filter2 == "")
		{
			if (kget_format=="kget_format") customPrint(sprintf("\
=================================================================================================================\n\
Proxy Id                             %s\n\
MO                                   %s\n\
=================================================================================================================",proxyList[i],p2s("FdnMo",proxyList[i])))
			else customPrint(sprintf("\
=================================================================================================================\n\
%-5s                                %s\n\
=================================================================================================================",\
proxyList[i],p2s("Mo",proxyList[i])))
		}
		db_printattrs(proxyList[i],mibtableMAO,sorted_maoattrlist,neg2,neg3,Filter2,Filter3,mget,resTable,fro,kget_format)
		if (fro=="fro")
		{
			if (resTable["ok"]==1) count++
			continue
		}
		db_printattrs(proxyList[i],mibtableFRO,sorted_froattrlist,neg2,neg3,Filter2,Filter3,mget,resTable)
		db_printattrs(proxyList[i],mibtableFRO,sorted_fro2attrlist,neg2,neg3,Filter2,Filter3,mget,resTable)
		db_printattrs(proxyList[i],mibtableFRO,sorted_fro3attrlist,neg2,neg3,Filter2,Filter3,mget,resTable)
		if (resTable["ok"]==1) count++
	}
	customPrint("=================================================================================================================");
	customPrint("Total: " count " MOs");
	assignCustomVar("$nr_of_mos",count)
	if (varName != "") assignCustomVar(varName,resTable["varValue"],"print")
}
function db_printattrs(proxy,whichmibtable,sorted_attrlist,neg2,neg3,Filter2,Filter3,mget,resTable,fro,kget_format,     output,j,n,array)
{
	n=split(sorted_attrlist[MoType[proxy]],array,",")
	for (j=1;j<=n;j++)
	{
		if (fro=="fro" && (!(array[j] == sqlMapFro[MoType[proxy]] || tolower(array[j])=="vccepfroid"))) continue
		if (neg2==1) { if (tolower(array[j]) ~ Filter2) continue }
		else if (tolower(array[j]) !~ Filter2) continue
		if (neg3==1) { if (tolower(whichmibtable[proxy,array[j]]) ~ Filter3) continue }
		else if (tolower(whichmibtable[proxy,array[j]]) !~ Filter3) continue
		if (Filter2 == "")
		{
			if (kget_format=="kget_format" && whichmibtable[proxy,array[j]] ~ /^Struct\{/) output=sprintf("Struct %s has %s members:\n%s",array[j],gensub(/^Struct\{|\}.*$/,"","g",whichmibtable[proxy,array[j]]),gensub(/^Struct[^\n]+\n/,"",1,whichmibtable[proxy,array[j]]))
			else output=sprintf("%-35s  %s",array[j],whichmibtable[proxy,array[j]])
		}
		else output=sprintf("%s%-80s %-17s %s",(get_printoutformat == "proxy"?sprintf("%-5s ",proxy):""),\
(mget=="mget"?p2s("Mo",proxy):p2s("MediumMo",proxy)),array[j],whichmibtable[proxy,array[j]])
		customPrint(output)
		resTable["ok"]=1
		resTable["varValue"]=whichmibtable[proxy,array[j]]
	}
}
function db_motype(input,ldn,    motype,array)
{
	#input can be a proxy or a motype
	#if input is a motype, then the ldn is given as input as well
	#the function is used to append the device parent for MO class "Program"
	if (input in Ldn) { motype=s2t(Ldn[input]) ; ldn=Ldn[input] }  #input was a proxy
	else motype=input   #input was a motype and ldn
	if (motype=="Program")
	{
		if (ldn ~ /,PlugInUnit=[^,]+,[^,]+,.*Program=/)
		{
			match(ldn,/,([^=,]+)=[^=,]+,Program=/,array)
			motype=array[1]".Program"
		}
		else if (ldn ~ /,Fan=/) motype="Fan.Program"
		else if (ldn ~ /,PfmUnit=/) motype="PfmUnit.Program"
	}
	return motype
}

function getModataRev(force,     sqlMaxLines,res)
{
	if (modataRev ~ "modata_r" && force=="" && modataRev_hasbeenmade==1) return modataRev
	mo_log(tempsqlmodatarev,"open","mute","overwrite","silent")
	$0="sql select COUNT(*) from modata_r3;"
	if (dbdat) run_sql_command($0)
	else cmd()
	mo_log(tempsqlmodatarev,"close");
	cv_is_not_there=0
	while (getline < tempsqlmodatarev)
	{
		gsub("\r","") ; gsub("\x000","")
		if ($1=="|" && $2 ~ /^[0-9]+$/ && $3=="|" && NF==3 && sqlMaxLines=="") sqlMaxLines=$2
		if ($0 == sqlOfflineError)
		{
			customPrint(sqlOfflineError)
			cv_is_not_there=1
		}
		modataRev_hasbeenmade=1
	}
	close(tempsqlmodatarev)
	if (sqlMaxLines > 0) res="modata_r3"
	else res="modata_r2"
	if (res=="modata_r3") buildMoAttrTable("silent")
	return res
}

function buildMoAttrTable(silent)
{
	# Read MO attribute table
	delete moAttrTable
	mo_log(tempsqlattrlog,"open","mute","overwrite",silent)
	$0="sql select id,data from mo_attribute_name_r1;"
	if (dbdat) run_sql_command($0)
	else cmd()
	mo_log(tempsqlattrlog,"close");
	while (getline < tempsqlattrlog)
	{
		gsub("\r","") ; gsub("\x000","")
		if ($1=="|" && $2 ~ /^[0-9]+$/ && $3=="|" && NF==5) moAttrTable[$2] = gensub("'", "", "g", $4)
	}
	close(tempsqlattrlog)
}

function buildFroAttrTable(silent,   i,n,array,tmpTable,prefix,suffix,j)
{
	# Read Fro attributes table
	delete froAttrTable
	delete tmpTable
	mo_log(tempsqlmaolog,"open","mute","overwrite",silent)
	if (cpplinux==1) $0="sql SELECT table_name,column_name from information_schema.columns;"
	else $0="sql select table_name,name from attributes;"
	if (dbdat) run_sql_command($0)
	else cmd()
	mo_log(tempsqlmaolog,"close");
	while (getline < tempsqlmaolog)
	{
		#| 'dscpgfro'                                 | 'froid'                                            |
		#| 'dscpgfro'                                 | 'dscplist'                                         |
		#| 'dscpgfro'                                 | 'samplinginterval'                                 |
		#| 'dscpgfro'                                 | 'ipiffroid'                                        |
		#| 'dscpgfro'                                 | 'piuid'                                            |
		gsub("\r","") ; gsub("\x000","")
		if ($1=="|" && $3=="|" && NF==5)
		{
			gsub("'", "", $2)
			gsub("'", "", $4)
			if ($4 ~ /[0-9]+$/)
			{
				#we put the numbers with zeros in front, for sorting purpose, otherwise we have _9 that is after _60 (for instance)
				prefix=gensub(/[0-9]+$/,"",1,$4)
				match($4,/([0-9]+)$/,array)
				suffix=array[1]
				$4=sprintf("%s%03d%s%s",prefix,suffix,SUBSEP,$4) #example: equivalentplmnidentitygroupfroid_13 is renamed to equivalentplmnidentitygroupfroid_013 <subsep> equivalentplmnidentitygroupfroid_13
			}
			tmpTable[$2] = tmpTable[$2]","$4
		}
	}
	close(tempsqlmaolog)
	for (i in tmpTable)
	{
		split(tmpTable[i],array,",")
		n=asort(array)
		for (j=1;j<=n;j++)
		{
			if (array[j] ~ SUBSEP) sub(sprintf("^.*%s",SUBSEP),"",array[j])
			if (array[j]!="") froAttrTable[i]=froAttrTable[i]","array[j]
		}
		sub(/^,/,"",froAttrTable[i])
	}
}
function read_scannerdata(    line,a,i,n,row,data,inbrokenline,havemoi,inmoc,nr_mois,t_mdn,dbres)
{
	run_mibtablePM=1
	dbValFailed=dbres=0
	if (dbdat)
	{
		customPrint("\nReading PM scanner data ("pmMaxLines+0" lines)","","","noLF")
		run_sql_command("select id,data from scannerdata order by id;","","silent","","",tempsqlcsvlog)
	}
	else
	{
		customPrint("\nReading PM scanner data")
		$0=""; dbres=dbval("","select id,data from scannerdata order by id;","","csv")
	}
	if (fileOps("test -s "tempsqlcsvlog)!=0)
	{
		dbValFailed=dbres   #dbValFailed is global variable
		return
	}
	while (getline < tempsqlcsvlog)
	{
		#OSE:   2,X'aced0005740327325e5052454445462e50.....'
		#Linux: 1,'\xaced000574084b315e555345524445462...'
		if (cpplinux==1) sub(/,'\\x/,",X'")
		if ($0 ~ /^[0-9]+,X\x27/)
		{
			line=$0
			if ($0 !~ /\x027$/) { inbrokenline=1 ; continue }
		}
		else if (inbrokenline==1)
		{
			line=line""$0
			if ($0 ~ /\x027$/) inbrokenline=0
			else continue
		}
		else continue
		#Conversion of binary characters to ascii characters
		split(line,a,",X\x27")
		row=a[1]
		data=gensub(/\x27$/,"",1,a[2])
		n=split(data,a,"")
		data=""
		#the first 7 bytes are binary, skip them because in some case there might be a caret sign (^) which would mess up the data
		for(i=15;i<=n;i+=2) data=data sprintf("%c",strtonum("0x"a[i] a[i+1]))
		#example of data that contains a caret sign _before_ the proxy id of the scanner:
		#t.^94^USERDEF.Device.STATS^1^900^3^CcDevice^17^pmCcDeviceReceivedData^pmCcDeviceTransmittedData^pmCcSpAal2CepAllocUtil^pmCcSpAal5CepAllocUtil^pmCcSpBwUtilRx^pmCcSpBwUtilTx^pmCcSpMeasLoad^pmSamplesCcSpBwUtilRx^pmSamplesCcSpBwUtilTx^pmSamplesMeasuredCcSpLoad^pmSumCcSpBwUtilRx^pmSumCcSpBwUtilTx^pmSumMeasuredCcSpLoad^pmSumSqrCcSpBwUtilRx^pmSumSqrCcSpBwUtilTx^pmSumSqrCcSpMeasLoad^pmUeInCellFachUtil^DcDevice^17^pmDcDeviceReceivedData^pmDcDeviceTransmittedData^pmDcSpAal2CepAllocUtil^pmDcSpAal5CepAllocUtil^pmDcSpBwUtilRx^pmDcSpBwUtilTx^pmDcSpMeasLoad^pmMacDInstancesUtil^pmSamplesDcSpBwUtilRx^pmSamplesDcSpBwUtilTx^pmSamplesMeasuredDcSpLoad^pmSumDcSpBwUtilRx^pmSumDcSpBwUtilTx^pmSumMeasuredDcSpLoad^pmSumSqrDcSpBwUtilRx^pmSumSqrDcSpBwUtilTx^pmSumSqrDcSpMeasLoad^PdrDevice^16^pmPdrDeviceReceivedData^pmPdrDeviceTransmittedData^pmPdrSpAal2CepAllocUtil^pmPdrSpAal5CepAllocUtil^pmPdrSpBwUtilRx^pmPdrSpBwUtilTx^pmPdrSpMeasLoad^pmSamplesMeasuredPdrSpLoad^pmSamplesPdrSpBwUtilRx^pmSamplesPdrSpBwUtilTx^pmSumMeasuredPdrSpLoad^pmSumPdrSpBwUtilRx^pmSumPdrSpBwUtilTx^pmSumSqrPdrSpBwUtilRx^pmSumSqrPdrSpBwUtilTx^pmSumSqrPdrSpMeasLoad^0
		#usually no caret in front of the proxy number:
		#t305^USERDEF.hello.STATS^1^900^2^VpcTp^1^pmBwErrBlocks^VplTp^2^pmReceivedAtmCells^pmTransmittedAtmCells^0
		#t264^USERDEF.test1.STATS^1^900^1^UeRc^1^pmTransportBlocksAcUl^2^1^pmReceivedAtmCells^1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-100^1^pmReceivedAtmCells^1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1
		#262^USERDEF.test.STATS^1^900^0^4^1^pmReceivedAtmCells^3^ManagedElement=1,TransportNetwork=1,AtmPort=MS-27-1-1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-27-2-1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1^3^pmBwUtilizationRx^pmBwUtilizationTx^pmReceivedAtmCells^14^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-100^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-101^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-102^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-103^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-90^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-91^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-92^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-93^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-94^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-95^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-96^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-97^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-98^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1,VclTp=Iuc-99^2^pmBwLostCells^pmFwLostCells^1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2,VpcTp=1^1^pmReceivedAtmCells^1^ManagedElement=1,TransportNetwork=1,AtmPort=MS-6-1-1,VplTp=2
		n=split(data,a,"^")
		# - name
		# - state
		# - granularity
		# - nr of MOC based observartion objects, followed by: MOC , nr of counters, counter list
		# - nr of MO instance based observation objects, folowed by: nr of counters, counter list, nr of MO instances, MO list
		mibtablePM[row,"name"]=a[2]
		mibtablePM[row,"state"]=(a[3]==0?"SUSPENDED":"ACTIVE")
		mibtablePM[row,"gran"]=a[4]
		havemoi=inmoc=nr_mois=0
		if ((a[5]+0)>0) inmoc=1
		if (data ~ /ManagedElement=1,/ && a[n]!=0) havemoi=1
		for (i=6;i<=n;i++)
		{
			if (a[i]~/^[0-9]+$/) a[i]+=0
			#the MO instance based obs objects start after the MOC based obs objects and are characterised by two consecutive integer fields: the number of MOI based obs objects followed by nr of counters
			if (havemoi==1 && a[i]~/^[0-9]+$/ && a[i+1]~/^[0-9]+$/ && a[i]>0 && a[i+1]>0) { inmoc=0  ; continue } #this is the start of MOI based obs objects
			if (inmoc==1)
			{
				#MOC based obs objects
				if (i==n) continue #the last field of the data contains the number of MOI based obs objects
				if (a[i]~/^[A-Z][^=]+$/&&a[i]!~/^[A-Z].*Id$/) mibtablePM[row,"data"]=sprintf("%s\n%-30s  ",mibtablePM[row,"data"],a[i])
				else if (a[i]~/^[0-9]+$/)
				{
					mibtablePM[row,"data"]=sprintf("%s%3s  ",mibtablePM[row,"data"],a[i])
					mibtablePM[row,"nr_cnt"]+=a[i]
					if (a[i]>0) mibtablePM[row,"data"]=sprintf("%s%s",mibtablePM[row,"data"],a[++i])
				}
				else mibtablePM[row,"data"]=sprintf("%s\n%-35s  %s",mibtablePM[row,"data"],"",a[i])
			}
			else if (havemoi==1)
			{
				#MOI based obs objects
				if (a[i]~/^[0-9]+$/)
				{
					if (a[i+1]~"ManagedElement=") mibtablePM[row,"data"]=sprintf("%s\n%10s  %s",mibtablePM[row,"data"],a[i],a[i+1])
					else mibtablePM[row,"data"]=sprintf("%s\n%s",mibtablePM[row,"data"],a[i+1])
					i++
				}
				else if (a[i]~"ManagedElement=")
				{
					mibtablePM[row,"data"]=sprintf("%s\n%10s  %s",mibtablePM[row,"data"],"",a[i])
					nr_mois++
					t_mdn=l2m(a[i])
					if (!(t_mdn in MoProxy && MoProxy[t_mdn]>0))
					{
						corruptedScannerList[row]=row
						missingMOInstancesPM[row]=sprintf("%s\n%10s%s",missingMOInstancesPM[row],"",t_mdn)
					}
					if (nr_mois>=1000)
					{
						heavyScannerList[row]=row
						nrMOInstancesPM[row]=nr_mois+1
						tooManyInstancesInPM=1
					}
				}
				else mibtablePM[row,"data"]=sprintf("%s\n%s",mibtablePM[row,"data"],a[i])
			}
		}
		pmrowlist[row]=row
		printf "."
	}
	close(tempsqlcsvlog)
	fileOps("rm "tempsqlcsvlog)
	customPrint("")
	have_mibtablePM=1
}

function build_dbdat_motables(     queryres,last,ldn,array,row,sqlcom,i,momInfo,currProg,oldProg,respair,motype,currFroTable,\
moname,lineCount,mibprefix,inbrokenline,query1,query2,tmpclass,sqlMaxLines,line,froattr,curval,n,maoattrlist,froattrlist,last2,array2,j,\
fro2attrlist,fro3attrlist,whichfro,maofroid,tmpproxy,tmpmaoparent,tmpfroparent,tmpmaoref,tmpfroref,z,valarray,k,tmprefldn,tmpfrotype,a,froidpos,data,\
lastx,x,xmlpart,xmlattr,xmlval,foundHeader,tmpFroIndex,tmpFroIndex2,froidpos2,t_froid,t_froProxy,maxPri,sorted_sqlMapRealTable,sqlCount,ok,backdoorpos,sep,haslocalmopos,tmpdata,xmlp)
{
	oldProg=currProg=0
	mib_maxProxy=-1
	lineCount=0
	inbrokenline=0
	dbhasPmService=0
	dbLmVersion=0

	modataRev=getModataRev()
	if (cpplinux==0) sep="'"

	dbNodeIpOamLink=""
	sqlcom=run_sql_command(sprintf("%sselect COUNT(*) from %s;select COUNT(*) from scannerdata;\
select * from %s where data like '%s^%';select * from %s where data like '%s^%';",\
(oamLinkTable!=""?"select ipaddress from "oamLinkTable";":""),\
modataRev,modataRev,motype_r1Table["PmService"],modataRev,motype_r1Table["LoadModule"]),"","","norun")
	while (sqlcom |& getline)
	{
		gsub("\r","") ; gsub("\x000","")
		if ($1=="|" && $2 ~ /^[0-9]+$/ && $3=="|")
		{
			if (NF==3 && sqlMaxLines=="") sqlMaxLines=$2
			else if (NF==3) pmMaxLines=$2
			else if ($4 ~ sprintf("^%s%s\\^",sep,motype_r1Table["PmService"])) dbhasPmService=1
			else if ($4 ~ sprintf("^%s%s\\^",sep,motype_r1Table["LoadModule"])) dbLmVersion=gensub(/[\^].*$/,"",1,gensub(/^[']?[0-9]+[\^]/,"",1,$4))+0
		}
		else if ($1=="|" && $2 ~ /^'/ && $3=="|")
		{
			#select ipaddress from oamlinkaddresses_01;
			#| '137.58.152.14' |
			dbNodeIpOamLink=dbNodeIpOamLink gensub(/'/,"","g",$2)"/"
		}
	}
	close(sqlcom)
	sub(/\/$/,"",dbNodeIpOamLink)

	if (mosdebug==1) print "Has PmService="dbhasPmService", dbLmVersion="dbLmVersion

	#reading the binary tables mopplet and upgradedata
	#customPrint("\nReading upgrade data ("pmMaxLines+0" lines)","","","noLF")
	#run_sql_command("select id,data from mopplet;","","silent","","",tempsqlcsvlog)
	#while (getline < tempsqlcsvlog)
	#{
	#	#2,X'aced0005740327325e5052454445462e50.....'
	#	if ($0 ~ /^[0-9]+,X\x27/)
	#	{
	#		line=$0
	#		if ($0 !~ /\x027$/) { inbrokenline=1 ; continue }
	#	}
	#	else if (inbrokenline==1)
	#	{
	#		line=line""$0
	#		if ($0 ~ /\x027$/) inbrokenline=0
	#		else continue
	#	}
	#	else continue
	#	#Conversion of binary characters to ascii characters
	#	split(line,a,",X\x27")
	#	row=a[1]
	#	data=gensub(/\x27$/,"",1,a[2])
	#	n=split(data,a,"")
	#	data=""
	#	for(i=1;i<=n;i+=2) data=data sprintf("%c",strtonum("0x"a[i] a[i+1]))
	#	print row,data
	#	n=split(data,a,"^")
	#	printf "."
	#}
	#close(tempsqlcsvlog)
	#fileOps("rm "tempsqlcsvlog)
	#customPrint("")

	customPrint("\nReading MAO data ("sqlMaxLines" lines) ...","","force")
	#### sqlcom=run_sql_command("select * from modata_r2;","","","norun")
	run_sql_command(sprintf("select * from %s order by id;",modataRev),"","silent","","",tempsqlcsvlog)
	#### while (sqlcom |& getline)
	#print tempsqlcsvlog
	while (getline < tempsqlcsvlog)
	{
		####  gsub("\r","") ; gsub("\x000","")
		#if (!($1 == "|" && $2 ~ /^[0-9]+$/ && $3=="|")) continue
		#### if ($1 == "|" && $2 ~ /^[0-9]+$/ && $3=="|")
		if ($0 ~ /^[0-9]+,\x027/)
		{
			line=$0
			#### if ($NF != "|") { inbrokenline=1 ; continue }
			if ($0 !~ /\x027$/) { inbrokenline=1 ; continue }
		}
		else if ($0 ~ /^[0-9]+,NULL$/) line=gensub(",",",'",1,$0)"'"
		else if (inbrokenline==1)
		{
			line=line" "gensub(/^[ \t]+/," ",1,$0)
			#### if ($NF=="|") inbrokenline=0
			if ($0 ~ /\x027$/) inbrokenline=0
			else continue
		}
		else continue
		$0=line
		#gsub(/\\uffffffc2/,"") ; gsub(/\\uffffffa4/,"")
		#Conversion of Unicoded characters to ascii characters, eg: \uffffffc2 -> 
		while ($0 ~ /\\u(ffffff|00)/)
		{
			match($0,/\\u(ffffff|00)(..)/,a)
			gsub(sprintf("\\\\u(ffffff|00)%s",a[2]),sprintf("%c",strtonum("0x"a[2])),$0)
		}
		#if ($0 !~ /^\|.*\^.*\|$/) continue
		#|    1 | '1^5100^1=1^1^userLabel^sTRNC11^ProductType^sFNode^MibPrefix^sF^ModelVersion^sF5.30^ModelType^sFRNC_NODE_MODEL_G^ApplicationConfiguration^qT0|^' |
		#1,'1^6100^1=1^1^userLabel^sT1301_ernRNCtkt01^ProductType^sFNode^MibPrefix^sFSubNetwork=TKT_RootMo_R,SubNetwork=1301_ernRNCtkt01,MeContext=1301_ernRNCtkt01^ApplicationConfiguration^qT0|^mimName^sFRNC_NODE_MODEL_K^mimVersion^sF9.16^mimRelease^sF^healthCheckSchedule^qF0|^applicationConfiguration^qT0|^'
		#### row=$2
		row=gensub(/,\x027.*$/,"",1,$0)
		#queryres=gensub(/(^\| *[0-9]+ *\| *')/,"",1,gensub(/\^' *\|/,"",1))
		#### queryres=gensub(/^. +[0-9]+ +\| *\x027/,"",1,gensub(/\^\x027 *\|/,"",1,$0))
		queryres=gensub(/^[0-9]+,\x027|\x027$/,"","g",$0)
		#1^4300^1=1^1^userLabel^sT^ProductType^sFNode^MibPrefix^sFSubNetwork=RAN,SubNetwork=STP49,MeContext=RNC49^ModelVersion^sF1.4^ModelType^sFRNC_NODE_MODEL_G
		#96^2000^1=1,26=1,96=10^3151^IubLinkId^sF10^userLabel^sTIublinkRbs10^rbsId^iT10^rncModuleRef^rF1=1,26=1,50=1^reservedBy^qT3|ManagedElement=1,RncFunction=1,UtranCell=30128|rT1=1,26=1,104=30128|ManagedElement=1,RncFunction=1,UtranCell=30129|rT1=1,26=1,104=30129|ManagedElement=1,RncFunction=1,UtranCell=30130|rT1=1,26=1,104=30130|^froId^iF9
		last=split(queryres,array,"^")
		split(give_ldn_and_moname(array[1],array[3]),respair,SUBSEP)
		ldn=respair[1]
		moname=respair[2]
		motype=db_motype(rev_motype_r1Table[array[1]],ldn)
		maofroid=""
		# Replace numerical attribute values with proper names
		if (modataRev == "modata_r3")
		{
		     for (i=5;i<last;i+=2) { if (array[i] in moAttrTable && moAttrTable[array[i]] != "") array[i] = moAttrTable[array[i]] }
		}
		if (motype=="ManagedElement")
		{
			for (i in array)
			{
				if (array[i] ~ /^(ModelType|mimName)$/) momInfo["mimName"]=gensub(/^../,"",1,array[i+1])
				else if (array[i] ~ /^(ModelVersion|mimVersion|mimRelease)$/)
				{
					sub("ModelVersion","mimVersion",array[i])
					if (array[i+1]!~/^..$/) momInfo[array[i]]="_"gensub(/^../,"",1,gensub(/\./,"_",1,array[i+1]))
				}
				else if (array[i] == "MibPrefix") mibprefix=gensub(/^../,"",1,array[i+1])
			}
			mom_version=momInfo["mimName"] momInfo["mimVersion"] momInfo["mimRelease"]
			if (mom_version ~ /^MRS/) sub(/^MRS/,"MRSMGW",mom_version)
			if (mom_version == "")
			{
				#in MGW R3/R4, the ModelType and ModelVersion/mimVersion are not set, we use the maoRev instead
				if (array[2] ~ /^4/) mom_version="MGW_NODE_MODEL_R3x"
				else if (array[2] ~ /^5/ && dbhasPmService!=1) mom_version="MGW_NODE_MODEL_R4x"
				else if (dbhasPmService==1)
				{
					if (dbLmVersion > 1 && dbLmVersion < 7000) CelloVersion=6
					else CelloVersion=7  #on CPP7 and higher the maoClassRev of LoadModule is 7000
				}
				else CelloVersion=5
				if ("NodeBLocalCell" in motype_r1Table && motype_r1Table["NodeBLocalCell"]!="") mom_version="WRBS_NODE_MODEL_A"
			}
			if (mom_version != "") CelloVersion=make_fake_celloversion()
			assignCustomVar("$cellomomversion",CelloVersion,"","system")
			assignCustomVar("$celloversion",CelloVersion,"","system")
			assignCustomVar("$momversion",mom_version,   "","system")
			make_sqlmap()
			processSqlMapTableFile(tempsqltablenames)
		}
		else if (motype=="NodeClusterCommunication") RinP=1
		#Do some syntax check on the modata_r2 entry:
		#MoType^Revision^LDN^PrimaryKey^attributeName^attributeData^
		#
		#MoType:     Replaced with an integer mapping to the MoType name.
		#LDN   :     All mo type names in the MoName are replaced with an integer according to description of MoType.
		#PrimaryKey: Same as the modata_r2 row number
		#
		#attributeData: dataType AVCflag Data
		#   - dataType:  s=String, r=Reference, t=Struct, f=Float, q=Sequence, i=Integer, l=Long, b=Boolean
		#   - AVCflag:   T=isAVCNotifier , F=notAVCNotifier
		#   - Sequence:  dataType AVCflag noOfElements|attributeName|attributeData|....
		#   - Struct:    dataType AVCflag noOfElementsattributeNameattibuteData....
		#   - Reference: All mo type names in the LDN reference are replaced with an integer according to description of MoType.

		if (queryres=="NULL")
		{
			sqlCorruptedMAOTable[++sqlCorruptedMAOs]=sprintf("%s%s %s id=%s: entry is NULL",lineCount,SUBSEP,modataRev,row)
		}
		else
		{
			if (array[last]!="")
			{
				sqlCorruptedMAOTable[++sqlCorruptedMAOs]=sprintf("%s%s %s id=%s: entry does not end with ^",lineCount,SUBSEP,modataRev,row)
			}
			if (array[4]!=row)
			{
				sqlCorruptedMAOTable[++sqlCorruptedMAOs]=sprintf("%s%s %s id=%s: PrimaryKey field is not equal to row id (%s != %s)",lineCount,SUBSEP,modataRev,row,array[4],row)
			}
			if (array[1]!=s2t(array[3]))
			{
				sqlCorruptedMAOTable[++sqlCorruptedMAOs]=sprintf("%s%s %s id=%s: MoType field is not equal to MoType in LDN (%s != %s)",lineCount,SUBSEP,modataRev,row,array[1],s2t(array[3]))
			}
			if (array[2]!~/^[0-9]+$/)
			{
				sqlCorruptedMAOTable[++sqlCorruptedMAOs]=sprintf("%s%s %s id=%s: Revision field is not an integer (%s)",lineCount,SUBSEP,modataRev,row,array[2])
			}
		}

		for (i=5;i<last;i+=2)
		{
			#Here we read all MAO attributes in the modata_r2 table for that MO
			#Since the row finishes with ^, the last element of the array is always empty so we don't check the last element
			curval=fro_process(array[i+1],array[i],motype,lineCount)
			mibtableMAO[lineCount,array[i]]=curval
			maoattrlist[motype,array[i]]=motype SUBSEP array[i]
			#print "DEBUG: "motype,array[i],sqlMapFro[motype],ldn,curval
			if ((motype,array[i]) in sqlMapTo)
			{
				if (curval ~ "\n")
				{
					z=split(curval,valarray,"\n")
					for (k=2;k<=z;k++)
					{
						tmprefldn=gensub(/^ >>> [^ ]+ = ([^,]+,)?/,"",1,valarray[k])
						if (tmprefldn ~ /^[^,=]+=[^,=]+/) sqlToRelation[gensub(/^ManagedElement=1,([^,]+,)?/,"",1,ldn),tmprefldn]=lineCount SUBSEP array[i]
					}
				}
				else if (curval ~ /^[^,=]+=[^,=]+/)
				{
					sqlToRelation[gensub(/^ManagedElement=1,([^,]+,)?/,"",1,ldn),curval]=lineCount SUBSEP array[i]
				}
			}
			if (((motype,array[i]) in sqlMapBack) ||\
			    ((!((motype,array[i]) in sqlMapBack)) && (motype in sqlMapResattr && array[i]~/^(persistentReservers|reservedByMos)$/)))
			{
				if (curval ~ "\n")
				{
					z=split(curval,valarray,"\n")
					for (k=2;k<=z;k++)
					{
						tmprefldn=gensub(/^ >>> [^ ]+ = ([^,]+,)?/,"",1,valarray[k])
						if (tmprefldn !~ /^[^,=]+=[^,=]+/) continue
						sqlBackRelation[tmprefldn,gensub(/^ManagedElement=1,([^,]+,)?/,"",1,ldn)]=lineCount SUBSEP array[i]
					}
				}
				else if (curval ~ /^[^,=]+=[^,=]+/)
				{
					sqlBackRelation[curval,gensub(/^ManagedElement=1,([^,]+,)?/,"",1,ldn)]=lineCount SUBSEP array[i]
				}
			}

			if (array[i] == sqlMapFro[motype] && motype in sqlMapTable && sqlMapRealTable[sqlMapTable[motype]] != "")
			{
				if (!(motype=="SwitchExtensionUnit" && ldn !~ /Subrack=(1|MAIN|MS),/))
				{
					froProxy[sqlMapRealTable[sqlMapTable[motype]],curval]=lineCount
					maofroid=curval
				}
			}
			if (tolower(array[i]) == "vccepfroid" && motype ~ /^(Aal[015]TpVccTp|Aal2PathVccTp)$/ && "vccepfrotable" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["vccepfrotable"],curval]=lineCount
			}
			else if (tolower(array[i]) == "pcfroid" && motype ~/^(Aal[05]TpVccTp)$/ && "aalpermconnfrotable" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["aalpermconnfrotable"],curval]=lineCount
			}
			else if (tolower(array[i]) == "spasresourceid" && motype=="SwitchInternalLink" && "physicallink" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["physicallink"],curval]=lineCount
			}
			else if (tolower(array[i]) == "sairesourceid" && motype=="PlugInUnit" && "sai" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["sai"],curval]=lineCount
			}
			else if (tolower(array[i]) == "spas_resourceid" && motype ~ /^(SwitchCoreUnit|SwitchExtensionUnit)$/ && "sili" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["sili"],curval]=lineCount
			}
			else if (tolower(array[i]) == "lhfroid" && motype == "FastEthernet" && "ipcpadmlhfrotable" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["ipcpadmlhfrotable"],curval]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) ~ /^(aux)?devicefroid$/ && motype ~ /^(AcDevice|AiDevice|AlmDevice|BfDevice|ClDevice|DbccDevice|DpclDevice|OutDevice|PdDevice|PsDevice|RetDevice|TimDevice|TmaDevice|TpaDevice|TrDevice)$/ && "ecdevmgtdata" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["ecdevmgtdata"],curval]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) ~ /^(aux)?devsetfroid$/ && motype ~ /^(AcDeviceSet|AiDeviceSet|AlmDeviceSet|BfDeviceSet|ClDeviceSet|DbccDeviceSet|DbchDeviceSet|DpclDeviceSet|EDbchDeviceSet|EScDeviceSet|HsDbchDeviceSet|OutDeviceSet|PdDeviceSet|PsDeviceSet|RetDeviceSet|TimDeviceSet|TmaDeviceSet|TpaDeviceSet|TrDeviceSet|UbchDeviceSet)$/ && "ecdevsetmgtdata" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["ecdevsetmgtdata"],curval]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) == "cellcarrierfroid" && motype == "Carrier" && "chchschcarriermgrc" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["chchschcarriermgrc"],curval]=lineCount
			}
			#else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) == "abfroid" && motype == "AntennaBranch" && "sccrcantennabranch" in sqlMapRealTable)
			#{
			#	froProxy[sqlMapRealTable["sccrcantennabranch"],curval]=lineCount
			#}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) == "rfaccesspointfroid" && motype == "Sector" && "sccrcresmgrc" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["sccrcresmgrc"],curval]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && tolower(array[i]) == "rbslocalcellfroid" && motype == "RbsLocalCell" && ("chchschcellmgrc" in sqlMapRealTable || "scccemdbid" in sqlMapRealTable))
			{
				if ("chchschcellmgrc" in sqlMapRealTable) froProxy[sqlMapRealTable["chchschcellmgrc"],curval]=lineCount
				if ("scccemdbid" in sqlMapRealTable)      froProxy[sqlMapRealTable["scccemdbid"],curval]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && motype == "NbapCommon" && "bcnmauditcontrollerc" in sqlMapRealTable)
			{
				froProxy[sqlMapRealTable["bcnmauditcontrollerc"],"0"]=lineCount
			}
			else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && motype == "NodeBFunction" && ("chchschrbsmgrc" in sqlMapRealTable || "chcrrhomnodebdata" in sqlMapRealTable))
			{
				if ("chchschrbsmgrc" in sqlMapRealTable)    froProxy[sqlMapRealTable["chchschrbsmgrc"],"0"]=lineCount
				if ("chcrrhomnodebdata" in sqlMapRealTable) froProxy[sqlMapRealTable["chcrrhomnodebdata"],"1"]=lineCount
			}
		}
		if (last <= 5) maoattrlist[motype]=motype #entries that have no attributes
		#print "SQLDEBUG3: "lineCount,motype,sqlMapFro[motype],sqlMapTable[motype],sqlMapRealTable[sqlMapTable[motype]],sqlMapIndex[motype]
		if (sqlMapFro[motype]=="-" && sqlMapRealTable[sqlMapTable[motype]] != "" && sqlMapIndex[motype] ~ /^[a-z]+=[0-9]+$/)
		{
			maofroid=gensub(/^.*=/,"",1,sqlMapIndex[motype])
			froProxy[sqlMapRealTable[sqlMapTable[motype]],maofroid]=lineCount
		}
		#if (mospace_convert==1 && ldn ~ / /) gsub(/ /,space_sign,ldn)
		#transformed_line=transform_mib_line(row" "ldn,"geta")
		#if (mosdebug==1) print row" "ldn"\n"transformed_line
		#add_Proxys_to_table(transformed_line,row)
		mibtableMAO[lineCount,"maoTableRef"]=modataRev
		mibtableMAO[lineCount,"maoTableIndex"]="id="row
		mibtableMAO[lineCount,"maoClassRev"]=array[2]
		mibtableMAO[lineCount,"maoClass"]=motype
		mibtableMAO[lineCount,"maoName"]=moname
		add_id_to_modata(row,lineCount,ldn,motype,moname,array[2],mibprefix,maofroid)
		lineCount++
		currProg=int(100*lineCount/sqlMaxLines)
		if (currProg > oldProg)
		{
			printf "."
			oldProg=currProg
		}
	}
	#### close(sqlcom)
	close(tempsqlcsvlog)
	fileOps("rm "tempsqlcsvlog)
	customPrint(sprintf("\nLast MO: %5s. Loaded %4s MOs. Total: %5s MOs.",maxProxy,maxProxy,maxProxy+1))
	make_directMeChildrenString()

	#sqlMapFro[Aal0TpVccTp]=aal0CepFroId
	#sqlMapTable[Aal0TpVccTp]=aal0cepfrotable
	#sqlMapTableList[aal0cepfrotable]=1
	#sqlMapIndex[Aal0TpVccTp]=froid
	#sqlMapRealTable[aal0cepfrotable]=aal0cepfrotable_01

	oldProg=currProg=lineCount=inbrokenline=sqlMaxLines=0
	query1=query2=""

	delete sorted_sqlMapRealTable
	sqlCount=0
	maxPri=asort(sqlPrioList)
	for (j=1;j<=maxPri;j++)
	{
		for (i in sqlMapRealTable)
		{
			if (sqlMapPrio[i]==sqlPrioList[j] && sqlMapRealTable[i]!="") sorted_sqlMapRealTable[++sqlCount]=sqlMapRealTable[i]
		}
	}
	#now add all remaining tables that don't have a priority
	for (i in sqlMapRealTable)
	{
		if (sqlMapPrio[i]=="" && sqlMapRealTable[i]!="") sorted_sqlMapRealTable[++sqlCount]=sqlMapRealTable[i]
	}

	for (i=1;i<=sqlCount;i++)
	{
		query1=query1 "select count(*) as "sorted_sqlMapRealTable[i]" from "sorted_sqlMapRealTable[i]";"
		#For the attributes where we need to compare some attributes of type sequence:moRef between MAO and FRO we will read the attributes in alphabetical order
		if (sqlMapMoClass[sorted_sqlMapRealTable[i]] in sqlMapMoArray && sqlMapMoArray[sqlMapMoClass[sorted_sqlMapRealTable[i]]]==1 && sorted_sqlMapRealTable[i] in froAttrTable && froAttrTable[sorted_sqlMapRealTable[i]] ~ /[^,],[^,]/) query2=query2 (cpplinux==1?"\\echo Error: unknown command: ":"") "echo "sorted_sqlMapRealTable[i]";select "froAttrTable[sorted_sqlMapRealTable[i]]" from "sorted_sqlMapRealTable[i]";"
		else query2=query2 (cpplinux==1?"\\echo Error: unknown command: ":"") "echo "sorted_sqlMapRealTable[i]";select * from "sorted_sqlMapRealTable[i]";"
	}
	#print query2
	sqlcom=run_sql_command(query1,"","","norun")
	while (sqlcom |& getline)
	{
		gsub("\r","") ; gsub("\x000","")
		#| Aal0TpVccTp |
		#|           4 |
		if ($1=="|" && $2 ~ /^[0-9]+$/) { nrFro[tmpclass]=$2 ; sqlMaxLines+=$2 }
		else if ($1=="|") tmpclass=$2
	}
	close(sqlcom)
	delete foundHeader
	customPrint("\nReading FRO data ("sqlMaxLines" lines) ...","","force")
	customPrint(sprintf("%-47s%-47s%s","0%","~50%","~100%"),"","force")
	sqlcom=run_sql_command(query2,"","","norun")
	while (sqlcom |& getline)
	{
		gsub("\r","") ; gsub("\x000","")
		if (/Error: unknown command: echo /)
		{
			#Error: unknown command: echo phy_os155_01;
			currFroTable=gensub(/;$/,"",1,$NF)
			#by default, the froid is always the second word (first column of the table) except for cslogresource
			froidpos=2
			if (currFroTable ~ /^cslogresource/) froidpos=3
			froidpos2=""
			delete froattr
			continue
		}
		if ($1 == "|" && $3=="|")
		{
			line=$0
			if ($NF != "|") { inbrokenline=1 ; continue }
		}
		else if (inbrokenline==1)
		{
			line=line" "gensub(/^[ \t]+/," ",1,$0)
			if ($NF=="|") inbrokenline=0
			else continue
		}
		else continue
		$0=line
		last=split($0,array,"|")
		for (i=2;i<=last;i++) gsub(/^ *| *$/,"",array[i])
		if (currProg > oldProg)
		{
			printf "."
			oldProg=currProg
		}
		if (foundHeader[currFroTable]!=1)
		{
			tmpFroIndex=gensub(/=.*$/,"",1,sqlMapIndex[currFroTable])
			tmpFroIndex2=""
			if (currFroTable in sqlMapIndex2 && sqlMapIndex2[currFroTable] != "") tmpFroIndex2=sqlMapIndex2[currFroTable]
			for (i=2;i<=last;i++)
			{
				if (array[i]==tmpFroIndex)
				{
					froidpos=i
					foundHeader[currFroTable]=1
				}
				else if (tmpFroIndex2!="" && array[i]==tmpFroIndex2) froidpos2=i
				else if (currFroTable ~ /^iphostlinketh_/ && array[i]=="backdoor") backdoorpos=i
				else if (currFroTable ~ /^sccp_(gt|es)_frotable_/ && array[i]=="haslocalmo") haslocalmopos=i
			}
		}
		if (array[froidpos] ~ /^[0-9]+$/)
		{
			lineCount++
			currProg=int(100*lineCount/sqlMaxLines)
			#print "SQLDEBUG2: "$0
			#print "SQLDEBUG: "currFroTable,array[froidpos],froProxy[currFroTable,array[froidpos]]
			#if (froidpos2!="") print "SQLDEBUG: "$0"\n"currFroTable,froidpos2,array[froidpos2],froProxy[currFroTable,array[froidpos2]]
			#|       1000 |       6 |       0 |            2 |            1 |          30 |         7 |                  19 |             0 |               1 |        1800 |

			ok=0
			#The method below to count the number of FRO instances can only work when the FRO table is only used by one MO class.
			#Therefore we currently use it only on RNC and ENB application tables (roam/frodata)
			if (currFroTable ~ /^roam|frodata_/) ok=1
			if (ok==1) nrFroInstances[sqlMapMoClass[currFroTable]]++
			if (((currFroTable,array[froidpos]) in froProxy && froProxy[currFroTable,array[froidpos]] ~ /^[0-9]+$/)||\
			    (froidpos2!="" && (currFroTable,array[froidpos2]) in froProxy && froProxy[currFroTable,array[froidpos2]] ~ /^[0-9]+$/))
			{
				t_froid=array[froidpos]
				if (froidpos2!="" && (currFroTable,array[froidpos2]) in froProxy && froProxy[currFroTable,array[froidpos2]] ~ /^[0-9]+$/)
				{
					t_froid=array[froidpos2]
					#print currFroTable,t_froid,froProxy[currFroTable,t_froid],p2s("MoType",froProxy[currFroTable,t_froid]),array[froidpos]
					froIdList[p2s("MoType",froProxy[currFroTable,t_froid]),array[froidpos]]=froProxy[currFroTable,t_froid]
					#print "froIdList["p2s("MoType",froProxy[currFroTable,t_froid])","array[froidpos]"]="froProxy[currFroTable,t_froid]
					#save the froProxy entry because it will be deleted further down
					t_froProxy[currFroTable,t_froid]=froProxy[currFroTable,t_froid]
				}
				#old method below: does not work for a FRO without MAO since then there is no corresponding LDN from where to find out the MO class
				#but we still use it for all CPP/RBS/MGW fro tables since we cannot be sure that they are only used by one single MO class
				if (ok==0) nrFroInstances[db_motype(froProxy[currFroTable,t_froid])]++
				if (currFroTable in fro2Tables) whichfro=2
				else if (currFroTable in fro3Tables) whichfro=3
				else whichfro=""
				mibtableFRO[froProxy[currFroTable,t_froid],"fro"whichfro"TableRef"]=currFroTable
				mibtableFRO[froProxy[currFroTable,t_froid],"fro"whichfro"TableIndex"]=froattr[froidpos]"="array[froidpos]
				#print froProxy[currFroTable,t_froid],p2s("MoType",froProxy[currFroTable,t_froid])
				otherFroTables[p2s("MoType",froProxy[currFroTable,t_froid]),"fro"whichfro]=currFroTable
				for (i=2;i<=last;i++)
				{
					if (array[i]=="") continue
					tmpproxy=froProxy[currFroTable,t_froid]
					mibtableFRO[tmpproxy,froattr[i]]=array[i]
					#sqlParentTable[VclTp,vpcepfroid]=1  (pointer to the parent froid)
					#sqlMoRefTable[Aal2Ap,mtp3id]=sigLinkId
					#Ldn[maxProxy]=ldn
					#MoType[maxProxy]=motype
					#froIdList[motype,froId]=froIdList[motype,froId]","maxProxy

					#expand xml attributes, eg: xxx.froId, xxx.ldn, xxx.froType
					#RbsSubrack=1,RbsSlot=6,AuxPlugInUnit=RU-1-6,RiPort=DATA_2                        parentref         '<moref name="parentRef"> <attr name="ldn" type="STRING" value="ManagedElement=1,Equipment=1,RbsSubrack=1,RbsSlot=6,AuxPlugInUnit=RU-1-6"/> <attr name="froType" type="S32" value="117440512"/> <attr name="froId" type="S32" value="5"/> </moref> '
					if (array[i] ~ /<attr name=\"/ && array[i] !~ /<array name=\"/ && array[i]!~/<complex>/)
					{
						#TR HR88263 : some MOs in ENB are missing the field: attr name="ldn"
						dbcLdnFieldCheck=1
						if (array[i] ~ "<attr name=\"froId\"" && array[i] !~ "<attr name=\"ldn\"")
						{
							dbcLdnFieldCheckFail=1
							dbcLdnFieldMoTable[tmpproxy]=tmpproxy
							dbcLdnFieldAttrTable[tmpproxy]=dbcLdnFieldAttrTable[tmpproxy]","froattr[i]
							sub(/^,/,"",dbcLdnFieldAttrTable[tmpproxy])
						}
						lastx=split(array[i],xmlpart,"<attr name=\"")
						for (x=2;x<=lastx;x++)
						{
							#ldn" type="STRING" value="ManagedElement=1,Equipment=1,RbsSubrack=1,RbsSlot=6,AuxPlugInUnit=RU-1-6"/>
							#froType" type="S32" value="117440512"/>
							#froId" type="S32" value="5"/> </moref>
							xmlattr=gensub(/\".*$/,"",1,xmlpart[x])
							xmlval=gensub(/\".*$/,"",1,gensub(/^.* value=\"/,"",1,xmlpart[x]))
							mibtableFRO[tmpproxy,froattr[i]"."xmlattr]=xmlval

							#print tmpproxy,froattr[i]"."xmlattr,xmlval
							last2=split(sqlMapMoClass[currFroTable],array2,",")
							#if (currFroTable in fro2Tables) { for (j=1;j<=last2;j++) fro2attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
							#else if (currFroTable in fro3Tables) { for (j=1;j<=last2;j++) fro3attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
							#else
							for (j=1;j<=last2;j++)
							{
								froattrlist[array2[j],froattr[i]"."xmlattr]=array2[j] SUBSEP froattr[i]"."xmlattr
								#print currFroTable,sqlMapMoClass[currFroTable],array2[j],froattr[i]"."xmlattr
							}
						}
						for (x=2;x<=last;x++)
						{
							#must do the fro checks after mibtableFRO has been made for all members since mibtableFRO is used in make_fro_checks
							xmlattr=gensub(/\".*$/,"",1,xmlpart[x])
							make_fro_checks(tmpproxy,froattr[i]"."xmlattr,mibtableFRO[tmpproxy,froattr[i]"."xmlattr])
						}
					}
					#expand xml attributes, eg: xxx.froId, xxx.ldn, xxx.froType
					#parentref         '<complex> <moref name="parentRef"/> <data>ManagedElement=1\,ENodeBFunction=1\,EUtranCellFDD=ENB2_188_UCTOOL\,UeMeasControl=1,117506068,17</data> </complex>'
					#parentref         '<complex><moref name="parentRef"/><data>ManagedElement=1\,ENodeBFunction=1,117637120,0</data></complex>'
					else if (array[i] ~ /<complex>/ && array[i] ~ /<moref name=/)
					{
						tmpdata=gensub(/^.*<data> *| *<\/data>.*$/,"","g",array[i])
						lastx=split(tmpdata,xmlp,",")
						xmlpart[1]="ldn" SUBSEP gensub(/\\/,"","g",gensub(/,[^,]*,[^,]*$/,"",1,tmpdata))
						xmlpart[2]="froType" SUBSEP xmlp[lastx-1]
						xmlpart[3]="froId" SUBSEP xmlp[lastx]
						for (x=1;x<=3;x++)
						{
							#xmlpart[1]=ManagedElement=1,Equipment=1,RbsSubrack=1,RbsSlot=6,AuxPlugInUnit=RU-1-6   (ldn)
							#xmlpart[2]=117440512 (froType)
							#xmlpart[3]=5 (froId)
							split(xmlpart[x],xmlp,SUBSEP)
							xmlattr=xmlp[1]
							xmlval=xmlp[2]
							mibtableFRO[tmpproxy,froattr[i]"."xmlattr]=xmlval

							#print tmpproxy,froattr[i]"."xmlattr,xmlval
							last2=split(sqlMapMoClass[currFroTable],array2,",")
							#if (currFroTable in fro2Tables) { for (j=1;j<=last2;j++) fro2attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
							#else if (currFroTable in fro3Tables) { for (j=1;j<=last2;j++) fro3attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
							#else
							for (j=1;j<=last2;j++)
							{
								froattrlist[array2[j],froattr[i]"."xmlattr]=array2[j] SUBSEP froattr[i]"."xmlattr
								#print currFroTable,sqlMapMoClass[currFroTable],array2[j],froattr[i]"."xmlattr
							}
						}
						for (x=1;x<=3;x++)
						{
							#must do the fro checks after mibtableFRO has been made for all members since mibtableFRO is used in make_fro_checks
							split(xmlpart[x],xmlp,SUBSEP)
							xmlattr=xmlp[1]
							make_fro_checks(tmpproxy,froattr[i]"."xmlattr,mibtableFRO[tmpproxy,froattr[i]"."xmlattr])
						}
					}
					#expand xml attributes, eg: xxx.froId, xxx.ldn, xxx.froType
					#acbarringpresence '<complex> <strct name="acBarringPresence"> <attr name="acBarringForMoDataPresence" type="S32"/> <attr name="acBarringForMoSignPresence" type="S32"/> <attr name="acBarringForCsfbPresence" type="S32"/> </strct> <data>0,0,0</data> </complex>'
					else if (array[i] ~ /<complex>/ && array[i] ~ /<strct name=/ && array[i] ~ /<attr (type=[^ ]+ +)?name=\"/ && array[i] !~ /<array name=\"/)
					{
						tmpdata=gensub(/^.*<data> *| *<\/data>.*$/,"","g",array[i])
						gsub(/\\,/,SUBSEP,tmpdata)
						split(tmpdata,xmlp,",")
						lastx=split(array[i],xmlpart,"<attr (type=[^ ]+ +)?name=\"")
						for (x=2;x<=lastx;x++)
						{
							xmlattr=gensub(/\".*$/,"",1,xmlpart[x])
							xmlval=gensub(SUBSEP,",","g",xmlp[x-1])
							mibtableFRO[tmpproxy,froattr[i]"."xmlattr]=xmlval
							last2=split(sqlMapMoClass[currFroTable],array2,",")
							for (j=1;j<=last2;j++)
							{
								froattrlist[array2[j],froattr[i]"."xmlattr]=array2[j] SUBSEP froattr[i]"."xmlattr
							}
						}
					}

					make_fro_checks(tmpproxy,froattr[i],array[i])

				}
				delete froProxy[currFroTable,t_froid]
			}
			else if (froidpos2!="" && (currFroTable,array[froidpos2]) in t_froProxy && t_froProxy[currFroTable,array[froidpos2]] ~ /^[0-9]+$/)
			{
				#this is the second or third fro of AIR as one unit MOs
				t_froid=array[froidpos2]
				froIdList[p2s("MoType",t_froProxy[currFroTable,t_froid]),array[froidpos]]=t_froProxy[currFroTable,t_froid]
				#print "froIdList["p2s("MoType",t_froProxy[currFroTable,t_froid])","array[froidpos]"]="t_froProxy[currFroTable,t_froid]
			}
			else
			{
				#in the table moamtonesenderdb, there are 6 hardcoded FROs without a MAO (96 to 101), this is ok.
				#in the table eqcnprslotdata, there are more rows than RbsSlot MO, this is ok
				#in the table eqcbdhsubrackdata, there can be more rows than RbsSubrack MO, this is ok
				#in the table iphostlinketh, there can be FROs without MAO, this is indicated when the fro attribute backdoor has the value 1 (Marko Burazin)
				#in the tables sccp_es_frotable and sccp_gt_frotable, there can be FROs without MAOs, this is indicated when the fro attribute haslocalmo has the value 0 (Nikolay Kartalov)
				if (!((currFroTable ~ /^moamtonesenderdb/ && froattr[froidpos]=="theclientsuniqueid" && (array[froidpos]+0) >= 96 && (array[froidpos]+0) <= 101)||\
				      (currFroTable ~ /^eqcnprslotdata/ && froattr[froidpos]=="theclientsuniqueid")||\
				      (currFroTable ~ /^eqcbdhsubrackdata/ && froattr[froidpos]=="theclientsuniqueid")||\
				      (currFroTable ~ /^iphostlinketh_/ && froattr[backdoorpos]=="backdoor" && array[backdoorpos]==1)||\
				      (currFroTable ~ /^sccp_(gt|es)_frotable_/ && froattr[haslocalmopos]=="haslocalmo" && array[haslocalmopos]==0)))
				{
					froWithoutMao[++froMissingMao]=sqlMapMoClass[currFroTable] SUBSEP froattr[froidpos] SUBSEP array[froidpos] SUBSEP currFroTable
				}
			}
		}
		else if (array[froidpos]==gensub(/=.*$/,"",1,sqlMapIndex[currFroTable])) #e.g. ManagedElement,Jvm,etc
		{
			#print "SQLDEBUG1: "$0
			#| os155froid | eqfroid | linenum | os155muxmode | os155stdmode | os155degthr | os155degm | os155alarmreporting | os155loopback | os155adminstate | shutdowntmo |
			for (i=2;i<=last;i++)
			{
				if (array[i]=="") continue
				last2=split(sqlMapMoClass[currFroTable],array2,",")
				if (currFroTable in fro2Tables) { for (j=1;j<=last2;j++) fro2attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
				else if (currFroTable in fro3Tables) { for (j=1;j<=last2;j++) fro3attrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
				else { for (j=1;j<=last2;j++) froattrlist[array2[j],array[i]]=array2[j] SUBSEP array[i] }
				froattr[i]=array[i]
			}
		}
	}
	close(sqlcom)
	for (i in froProxy)
	{
		if (froProxy[i] !~ /^[0-9]+$/) continue
		split(i,array,SUBSEP)
		#motype,froid,proxyId,frotable,index
		maoWithoutFro[++maoMissingFro]=db_motype(froProxy[i])","array[2]","froProxy[i]","array[1]","sqlMapIndex[sqlMapTable[db_motype(froProxy[i])]]
	}
	make_sorted_dbattrlist(sorted_maoattrlist,maoattrlist,"maoTableRef,maoTableIndex,maoClassRev,maoClass,maoName",nrmaoattrlist)
	make_sorted_dbattrlist(sorted_froattrlist,froattrlist,"froTableRef,froTableIndex",nrfroattrlist)
	make_sorted_dbattrlist(sorted_fro2attrlist,fro2attrlist,"fro2TableRef,fro2TableIndex",nrfro2attrlist)
	make_sorted_dbattrlist(sorted_fro3attrlist,fro3attrlist,"fro3TableRef,fro3TableIndex",nrfro3attrlist)
	delete nrattrlist
	for (i in nrmaoattrlist)
	{
		nrattrlist[i]=nrmaoattrlist[i]+nrfroattrlist[i]+nrfro2attrlist[i]+nrfro3attrlist[i]
		#print i,nrattrlist[i]
	}
}
function make_fro_checks(tmpProxy,tmpFroAttr,tmpFroVal,   \
tmpmaoparent,tmpfroparent,tmpmaoref,tmpfroref,tmprefldn,tmpfrotype,z,rangeval,tstart,tstop,indexval,morefarray,n,k,upadmdata)
{
	if ((MoType[tmpProxy],tmpFroAttr) in sqlParentTable)
	{
		#Cbu=1, Etmc1, Etmc41, Etm1, Etm3, Etm4
		tmpmaoparent=gensub(/(,(Cbu|Etm(c1|c41|[134]))=1)?,[^=,]+=[^=,]+$/,"",1,Ldn[tmpProxy])
		tmpfroparent=p2s("LdnMo",froIdList[s2t(tmpmaoparent),tmpFroVal])
		#on some MO types, the parentref.froId field is not used only the field parentref.ldn
		if (tmpFroAttr ~ /\.froId$/ && tmpFroVal ~ /^(-1|0|1)$/ && tmpfroparent=="" && tmpmaoparent!="") tmpfroparent=mibtableFRO[tmpProxy,gensub(/\.froId$/,".ldn",1,tmpFroAttr)]
		if (tmpmaoparent != tmpfroparent)
		{
			#exception for WcdmaCarrier which can be under RncFunction or IurLink. we only check IurLink
			#exception for MpProcessingResource , we dont check it on CXP102051/23_R10 to CXP102051/23_R17 , TR HT79910
			if (MoType[tmpProxy]=="MpProcessingResource") upadmdata=mibtableMAO[s2p(mibtableMAO[s2p("ManagedElement=1,SwManagement=1,ConfigurationVersion=1"),"currentUpgradePackage"]),"UpgradePackageDocumentId"]
			if (!((MoType[tmpProxy]=="WcdmaCarrier" && tmpmaoparent=="ManagedElement=1,RncFunction=1")||(MoType[tmpProxy]=="MpProcessingResource" && upadmdata~/^CXP102051\/23_R1[0-7][A-Z]/)))
			{
				#parentMismatch[tmpProxy]=tmpmaoparent SUBSEP tmpfroparent
				parentMismatch[tmpProxy]=sprintf("maoParent: %s  (%s) froParent: %s (%s)",\
					gensub(/ManagedElement=1,([^,]+,)?/,"",1,tmpmaoparent),froIdTable[tmpmaoparent],\
					tmpFroVal,plist_to_mo(froIdList[s2t(tmpmaoparent),tmpFroVal]))
				parentMismatchYes=1
			}
		}
		#on some MO instances, the parentref.froId field is pointing to correct parent but the field parentref.ldn is not
		else if (tmpFroAttr ~ /\.froId$/ && tmpfroparent==tmpmaoparent)
		{
			tmpfroparent=mibtableFRO[tmpProxy,gensub(/\.froId$/,".ldn",1,tmpFroAttr)]
			if (tmpmaoparent != tmpfroparent)
			{
				parentMismatch[tmpProxy]=sprintf("maoParent: %s  froParent: %s",\
					gensub(/ManagedElement=1,([^,]+,)?/,"",1,tmpmaoparent),gensub(/ManagedElement=1,([^,]+,)?/,"",1,tmpfroparent))
				parentMismatchYes=1
			}
		}
		#print "SQLDEBUG: "tmpProxy,Ldn[tmpProxy],tmpmaoparent,tmpfroparent
		mibtableFRO[tmpProxy,tmpFroAttr]=tmpFroVal" ("plist_to_mo(froIdList[s2t(tmpmaoparent),tmpFroVal])")"
	}
	if ((MoType[tmpProxy],tmpFroAttr) in sqlMoRefTable)
	{
		tmpmaoref=mibtableMAO[tmpProxy,sqlMoRefTable[MoType[tmpProxy],tmpFroAttr]]
		tmpfroref=p2s("MediumMo",froIdList[s2t(tmpmaoref),tmpFroVal])
		#print "SQLDEBUG: "tmpProxy,p2s("Mo",tmpProxy),sqlMoRefTable[MoType[tmpProxy],tmpFroAttr],tmpmaoref,tmpfroref
		if ((!((tmpmaoref == tmpfroref)||(tmpmaoref=="null" && tmpfroref=="")))||\
		    (tmpmaoref=="null" && (tmpFroVal+0) > 0 && (!(MoType[tmpProxy]=="M3uAssociation" && RinP==1)))) #the MO ref in MAO is null but the MO ref in FRO is not null. Not applies to M3uAssociation with Rnc in pool
		{
			#print "DEBUG: "MoType[tmpProxy]" RinP="RinP
			#special case for Aal2Ap
			if ((p2s("MoType",tmpProxy)=="Aal2Ap") && ((tmpFroAttr=="usaalid_1" && s2t(tmpmaoref)=="Mtp3bAp")||(tmpFroAttr=="mtp3id" && s2t(tmpmaoref)=="UniSaalTp"))){}
			else
			{
				morefMismatch[tmpProxy]=sprintf("%s: %s (%s) %s: %s (%s)",\
					sqlMoRefTable[MoType[tmpProxy],tmpFroAttr],tmpmaoref,froIdTable[tmpmaoref],\
					tmpFroAttr,tmpFroVal,plist_to_mo(froIdList[s2t(tmpmaoref),tmpFroVal]))
				morefMismatchYes=1
				if (p2s("MoType",tmpProxy)=="EcPort" && sqlMoRefTable[MoType[tmpProxy],tmpFroAttr]=="ecBusRef") morefMismatch[tmpProxy]=morefMismatch[tmpProxy]"  (known issue: TR HT31160 - no impact)"
				else morefMismatchYesDbNotOk=1
			}
		}
	}

	if ((MoType[tmpProxy],tmpFroAttr) in sqlMapTo)
	{
		if (MoType[tmpProxy]":"tmpFroAttr ~ /^UeTac:rncfeatureids_/)
		{
			tmprefldn=rlibMapTable[tmpFroVal]
		}
		else if (MoType[tmpProxy]":"tmpFroAttr ~ /^UeTac:uefunctionalityids_/)
		{
			tmprefldn=rlibFuncTable[tmpFroVal]
		}
		else tmprefldn=p2s("MediumMo",froIdList[sqlMapTo[MoType[tmpProxy],tmpFroAttr],tmpFroVal])
		#special case for IpInterfaceGroup:primaryfroid/secondaryfroid which is defined in sqlRefMap as IpInterface but can also be Ipv6Interface
		if (MoType[tmpProxy]":"tmpFroAttr ~ /^IpInterfaceGroup:(primaryfroid|secondaryfroid)$/ && tmprefldn !~ /^[^=,]+=[^=,]+/)
		{
			tmprefldn=p2s("MediumMo",froIdList["Ipv6Interface",tmpFroVal])
		}
		if (tmprefldn ~ /^[^=,]+=[^=,]+/)
		{
			sqlToRelation[p2s("MediumMo",tmpProxy),tmprefldn]=tmpProxy SUBSEP tmpFroAttr
		}
		#print tmpProxy,p2s("MediumMo",tmpProxy),tmpFroAttr,tmprefldn
	}
	if ((MoType[tmpProxy],tmpFroAttr) in sqlMapFroMo && tmpFroVal ~ /^[0-9]+$/ && \
	     MoType[tmpProxy]":"tmpFroAttr !~ /^(Aal5TpVccTp:resourceid|IuLink:packetdatarouterfroid_[0-9]+|VpnInterface:ipinterfaceref|RncModule:devicereferencefroid)$/)
	{
		#for the resourceid attribute in Aal5TpVccTp we use the resourcetype to do the translation, see below
		#for the packetdatarouterfroid_x in IuLink we use the packetdatarouterpdrtype_x to do the translation, see below
		#for the ipinterfaceref in VpnInterface we use the ipversion to do the translation (ipversion=0 for IpInterface and ipversion=1 for Ipv6Interface)
		#for the devicereferencefroid in RncModule we use the programinstanceid to do the translation to know if it maps to PlugInUnit or PiuDevice
		tmpfrotype=sqlMapFroMo[MoType[tmpProxy],tmpFroAttr]
		if (!(tmpfrotype in sqlMapFroMo))
		{
			#we must find out the motype from the mao attribute
			tmpfrotype=s2t(mibtableMAO[tmpProxy,tmpfrotype])
		}
		tmprefldn=p2s("MediumMo",froIdList[tmpfrotype,tmpFroVal])
		#special case for IpAccessHostSpb::spmid which is defined in sqlRefMap as Spm but can also be PiuDevice
		if (tmprefldn=="" && MoType[tmpProxy]":"tmpFroAttr == "IpAccessHostSpb:spmid")
		{
			tmprefldn=p2s("MediumMo",froIdList["PiuDevice",tmpFroVal])
		}
		#special case for IpInterfaceGroup::primary/secondaryfroid which is defined in sqlRefMap as IpInterface but can also be Ipv6Interface
		else if (tmprefldn=="" && MoType[tmpProxy]":"tmpFroAttr ~ /^IpInterfaceGroup:(primaryfroid|secondaryfroid)$/)
		{
			tmprefldn=p2s("MediumMo",froIdList["Ipv6Interface",tmpFroVal])
		}
		#special case for UeTac::rncfeatureids_XX where the number is not the froId of the RncFeature but the rlib Id as per moshell/commonjars/rlibRncLicensingConstData.h
		if (MoType[tmpProxy]":"tmpFroAttr ~ /^UeTac:rncfeatureids_/)
		{
			tmprefldn=rlibMapTable[tmpFroVal]
		}
		if (MoType[tmpProxy]":"tmpFroAttr ~ /^UeTac:uefunctionalityids_/)
		{
			tmprefldn=rlibFuncTable[tmpFroVal]
		}
		if (!(tmpFroVal==0 && tmprefldn !~ /^[^=,]+=[^=,]+/))
		{
			mibtableFRO[tmpProxy,tmpFroAttr]=tmpFroVal" ("tmprefldn")"
			if (tmprefldn == "" && ((MoType[tmpProxy],tmpFroAttr) in sqlMapFroFro))
			{
				nonexistFroRefList[++nonexistFroRefCount]=sprintf("%5s %s %s %s%s",tmpProxy,p2s("MediumMo",tmpProxy),tmpFroAttr,mibtableFRO[tmpProxy,tmpFroAttr],\
				(tmpFroAttr~/^rpufroid[0-9]$/?" (known issue: TR HN28408)":""))
			}
		}
	}
	else if (MoType[tmpProxy]":"tmpFroAttr == "Aal5TpVccTp:resourcetype")
	{
		#In CPP5 and above resourceId is only found in FRO part of Aal5TpVccTp so we look at resourcetype attribute to know if it is a Spm or a PlugInUnit
		if (tmpFroVal==0) tmpfrotype="Spm" ; else tmpfrotype="PlugInUnit"
		tmprefldn=p2s("MediumMo",froIdList[tmpfrotype,mibtableFRO[tmpProxy,"resourceid"]])
		if (!(mibtableFRO[tmpProxy,"resourceid"]==0 && tmprefldn !~ /^[^=,]+=[^=,]+/))
		{
			mibtableFRO[tmpProxy,"resourceid"]=mibtableFRO[tmpProxy,"resourceid"]" ("tmprefldn")"
		}
	}
	else if (MoType[tmpProxy]":"tmpFroAttr ~ /^IuLink:packetdatarouterpdrtype_[0-9]+$/)
	{
		match(tmpFroAttr,/([0-9]+)$/,indexval)
		if (tmpFroVal==0) tmpfrotype="PacketDataRouter" ; else tmpfrotype="IpEthPacketDataRouter"
		tmprefldn=p2s("MediumMo",froIdList[tmpfrotype,mibtableFRO[tmpProxy,"packetdatarouterfroid_"indexval[1]]])
		if (!(mibtableFRO[tmpProxy,"packetdatarouterfroid_"indexval[1]]~/^(-1)$/ && tmprefldn !~ /^[^=,]+=[^=,]+/))
		{
			mibtableFRO[tmpProxy,"packetdatarouterfroid_"indexval[1]]=mibtableFRO[tmpProxy,"packetdatarouterfroid_"indexval[1]]" ("tmprefldn")"
		}
	}
	else if (MoType[tmpProxy]":"tmpFroAttr == "VpnInterface:ipversion")
	{
		if (tmpFroVal==0) tmpfrotype="IpInterface" ; else tmpfrotype="Ipv6Interface"
		tmprefldn=p2s("MediumMo",froIdList[tmpfrotype,mibtableFRO[tmpProxy,"ipinterfaceref"]])
		if (!(mibtableFRO[tmpProxy,"ipinterfaceref"]==0 && tmprefldn !~ /^[^=,]+=[^=,]+/))
		{
			mibtableFRO[tmpProxy,"ipinterfaceref"]=mibtableFRO[tmpProxy,"ipinterfaceref"]" ("tmprefldn")"
		}
	}
	else if (MoType[tmpProxy]":"tmpFroAttr == "RncModule:programinstanceid")
	{
		tmpfrotype="PlugInUnit"
		if (cpplinux==1 && tmpFroVal>=5) tmpfrotype="PiuDevice"
		tmprefldn=p2s("MediumMo",froIdList[tmpfrotype,mibtableFRO[tmpProxy,"devicereferencefroid"]])
		if (!(mibtableFRO[tmpProxy,"devicereferencefroid"]==0 && tmprefldn !~ /^[^=,]+=[^=,]+/))
		{
			mibtableFRO[tmpProxy,"devicereferencefroid"]=mibtableFRO[tmpProxy,"devicereferencefroid"]" ("tmprefldn")"
		}
	}
	else if (tmpFroAttr=="localpointcode")
	{
		opcList[p2s("MediumMo",tmpProxy),tmpFroVal]=tmpProxy
		dopccheck=1
	}
	else if (tmpFroAttr=="destpointcode")
	{
		dpcList[gensub(/,Mtp3bSrs=.*$/,"",1,p2s("MediumMo",tmpProxy)),tmpFroVal]=tmpProxy
		dopccheck=1
	}
	else if (tmpFroAttr ~ /ipad|^subnet|broadcastaddress|^defaultrouter.?$/ && tmpFroVal ~ /^-?[0-9]+$/ && tmpFroVal != 0)
	{
		mibtableFRO[tmpProxy,tmpFroAttr]=tmpFroVal d2ip_function(tmpFroVal,"brackets")
	}
	else if (tmpFroAttr ~ /\.froType$/ && tmpFroVal ~ /^[1-9][0-9]*$/ && sqlFroType[tmpFroVal]!="")
	{
		mibtableFRO[tmpProxy,tmpFroAttr]=tmpFroVal " ("sqlFroType[tmpFroVal]")"
	}

	if ((MoType[tmpProxy],tmpFroAttr) in sqlMapMoArray && sqlMapMoArray[MoType[tmpProxy],tmpFroAttr]!="")
	{
		#sqlMapMoArray[IuLink,packetDataRouterRef]=0-19
		#sqlMapMoArray[IuLink,packetdataroutertype_0]=packetDataRouterRef
		#sqlMapMoArray[IuLink,packetdataroutertype_1]=packetDataRouterRef
		#sqlMapMoArray[IuLink,packetdataroutertype_2]=packetDataRouterRef
		split(sqlMapMoArray[MoType[tmpProxy],sqlMapMoArray[MoType[tmpProxy],tmpFroAttr]],rangeval,"-")
		tstart=rangeval[1]+0
		tstop=rangeval[2]+0
		match(tmpFroAttr,/([0-9]+)$/,indexval)
		if (indexval[1]==tstart) sqlFroArrayVal=sqlMaoArrayVal=""
		if (tmprefldn != "") sqlFroArrayVal=sqlFroArrayVal" "tmprefldn
		#print "debug2: "tmpProxy,Ldn[tmpProxy],tmpFroAttr,indexval[1],tmprefldn
		if (indexval[1]==tstop)
		{
			sub(/^ +/,"",sqlFroArrayVal)
			# >>> uraRef = RncFunction=1,Ura=1
			n=split(mibtableMAO[tmpProxy,sqlMapMoArray[MoType[tmpProxy],tmpFroAttr]],morefarray,"\n")
			n=asort(morefarray)
			for (k=1;k<=n;k++)
			{
				if (morefarray[k] ~ /[^ \t]+=[^ \t]+/) sqlMaoArrayVal=sqlMaoArrayVal" "gensub(/^.* = ([^=]+=[^=]+,)?/,"",1,morefarray[k])
			}
			sub(/^ +/,"",sqlMaoArrayVal)
			n=split(sqlFroArrayVal,morefarray," ")
			n=asort(morefarray)
			sqlFroArrayVal=""
			for (k=1;k<=n;k++) sqlFroArrayVal=sqlFroArrayVal" "morefarray[k]
			sub(/^ +/,"",sqlFroArrayVal)
			#print "debug: "tmpProxy,Ldn[tmpProxy],MoType[tmpProxy],tmpFroAttr,sqlMapMoArray[MoType[tmpProxy],tmpFroAttr],tstart,tstop,indexval[1],sqlMaoArrayVal,sqlFroArrayVal
			if (sqlMaoArrayVal != sqlFroArrayVal)
			{
				#print tmpProxy,Ldn[tmpProxy],sqlMapMoArray[MoType[tmpProxy],tmpFroAttr],sqlMaoArrayVal,sqlFroArrayVal
				morefMismatch[tmpProxy]=sprintf("%s: %s  %s: %s",sqlMapMoArray[MoType[tmpProxy],tmpFroAttr],sqlMaoArrayVal,gensub(/[0-9]+$/,"",1,tmpFroAttr),sqlFroArrayVal)
				morefMismatchYes=morefMismatchYesDbNotOk=1
			}
		}
	}
}
function plist_to_mo(plist,   last,array,i,res)
{
	last=split(plist,array,",")
	for (i=1;i<=last;i++) res=res" "p2s("MediumMo",array[i])
	sub(/^ /,"",res)
	return res
}
function make_sorted_dbattrlist(sorted_attrlist,unsorted_attrlist,firstargs,nr_attrlist,   i,n,array)
{
	#unsorted_attrlist[moclass,attribute]=moclass SUBSEP attribute
	n=asort(unsorted_attrlist)
	delete sorted_attrlist
	delete nr_attrlist
	for (i=1;i<=n;i++)
	{
		split(unsorted_attrlist[i],array,SUBSEP)
		if (!(array[1] in sorted_attrlist)) sorted_attrlist[array[1]]=firstargs
		if (array[2] != "") sorted_attrlist[array[1]]=sorted_attrlist[array[1]]","array[2]
	}
	for (i in sorted_attrlist)
	{
		nr_attrlist[i]=split(sorted_attrlist[i],array,",")
		#print i,nr_attrlist[i]
	}
}

function add_id_to_modata(row,proxy,ldn,motype,moname,morev,mibprefix,froId,   array,tmp)
{
	#MaoId   MoClass  MaoRev  FroId   MoName  LDN
	#modataMoClassList=moclass,moclass,....
	#nrFroInstances[moclass]++ --> done in build_db function

	maxModataId=row
	maxProxy=proxy
	modataClassList[motype]=motype
	if (length(motype) > maxMotypeLength) maxMotypeLength=length(motype)
	if (motype in sqlMapTable)
	{
		if (froId != "") nrMaoInstances[motype]++
	}
	else unusedMao[motype]=motype
	if (moname ~ /[`,=^"|']|^$/) dangerousMonameList[maxProxy]=maxProxy
	else if (moname !~ /^[-_/.A-Za-z0-9!%:*]+$/) invalidMonameList[maxProxy]=maxProxy
	LdnList[ldn]=LdnList[ldn]","maxProxy
	if (froId != "")
	{
		froIdList[motype,froId]=froIdList[motype,froId]","maxProxy
		froIdTable[ldn]=froId
		froIdTable[l2m(ldn)]=froId
	}
	sub(/^,/,"",LdnList[ldn])
	sub(/^,/,"",froIdList[motype,froId])

	if (motype in sqlMapFro && sqlMapFro[motype]~/^[a-zA-Z]/ && froId !~ /^-?[0-9]+$/)
	{
		suspectedFroIdTable[proxy]=sqlMapFro[motype]
		#print proxy,motype,ldn,sqlMapFro[motype],froId
	}

        #print "row="row,"proxy="proxy,"froid="froId ,"motype="motype,"froAttr="sqlMapFro[motype],"moname="moname,"morev="morev,"ldn="ldn,"mibprefix="mibprefix
        #Examples:
	#Aal2Ap               row=267053 proxy=43143 froAttr=froId moname=AAL2AP_b104 morev=6000 froid=51 ldn=ManagedElement=1,TransportNetwork=1,Aal2Sp=1,Aal2Ap=AAL2AP_b104
	#Aal2PathDistributionUnit row=267054 proxy=43144 froAttr=froId moname=1 morev=6000 froid=60 ldn=ManagedElement=1,TransportNetwork=1,Aal2Sp=1,Aal2Ap=AAL2AP_b104,Aal2PathDistributionUnit=1
	#Aal2PathVccTp        row=267140 proxy=43230 froAttr=aal2pepFroId moname=b104aal2_4 morev=5100 froid=461 ldn=ManagedElement=1,TransportNetwork=1,Aal2PathVccTp=b104aal2_4
	#Aal2QosCodePointProfile row=4695 proxy=2151 froAttr=aal2QosCppFroId moname=1 morev=4200 froid=1 ldn=ManagedElement=1,TransportNetwork=1,Aal2QosCodePointProfile=1
	#Aal2QosProfile       row=4696 proxy=2152 froAttr=aal2QospFroId moname=ad10bd20 morev=4220 froid=1 ldn=ManagedElement=1,TransportNetwork=1,Aal2QosProfile=ad10bd20
	#Aal2RoutingCase      row=267055 proxy=43145 froAttr=routingCaseFroId moname=10030021170104 morev=3020 froid=5 ldn=ManagedElement=1,TransportNetwork=1,Aal2RoutingCase=10030021170104
	#Aal2Sp               row=4737 proxy=2153 froAttr=aal2SpFroId moname=1 morev=3000 froid=1 ldn=ManagedElement=1,TransportNetwork=1,Aal2Sp=1
	#Aal5TpVccTp          row=267047 proxy=43137 froAttr=aal5CepFroId moname=b104qa morev=5100 froid=30 ldn=ManagedElement=1,TransportNetwork=1,Aal5TpVccTp=b104qa
	#ActiveOtherLMs       row=81907 proxy=7942 froAttr=- moname=1 morev=7000 froid= ldn=ManagedElement=1,SwManagement=1,ActiveOtherLMs=1
	#AgpsPositioning      row=917 proxy=195 froAttr=froId moname=1 morev=6010 froid=0 ldn=ManagedElement=1,RncFunction=1,UePositioning=1,AgpsPositioning=1
	#ArpMap               row=1029 proxy=307 froAttr=froId moname=1 morev=6000 froid=11 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,ArpQosClassProfile=1,TrafficClassPsInt=1,ArpMap=1
	#ArpQosClassProfile   row=926 proxy=204 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,ArpQosClassProfile=1
	#AtmConfService       row=15900 proxy=6685 froAttr=- moname=1 morev=6000 froid= ldn=ManagedElement=1,TransportNetwork=1,AtmConfService=1
	#AtmCrossConnection   row=267063 proxy=43153 froAttr=AtmCcFroId moname=vc33_vc104 morev=5100 froid=59 ldn=ManagedElement=1,TransportNetwork=1,AtmCrossConnection=vc33_vc104
	#AtmPort              row=267035 proxy=43125 froAttr=froId moname=ES-2-27-4-ima54 morev=5100 froid=31 ldn=ManagedElement=1,TransportNetwork=1,AtmPort=ES-2-27-4-ima54
	#AtmTrafficDescriptor row=74514 proxy=7875 froAttr=atmTrafficDescriptorFroId moname=U3P17600M8800 morev=3300 froid=22 ldn=ManagedElement=1,TransportNetwork=1,AtmTrafficDescriptor=U3P17600M8800
	#CcDevice             row=12046 proxy=4495 froAttr=froId moname=15 morev=6000 froid=14 ldn=ManagedElement=1,Equipment=1,SpDevicePool=CcDevice,CcDevice=15
	#CchFrameSynch        row=1039 proxy=317 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,CchFrameSynch=1
	#CellUpdate           row=1038 proxy=316 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,CellUpdate=1
	#ChannelSwitching     row=1037 proxy=315 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,ChannelSwitching=1
	#CnOperator           row=4580 proxy=2100 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,CnOperator=1
	#ConfigurationVersion row=10 proxy=9 froAttr=- moname=1 morev=7000 froid= ldn=ManagedElement=1,SwManagement=1,ConfigurationVersion=1
	#CoverageRelation     row=267152 proxy=43242 froAttr=froId moname=WBJ05780C1 morev=6000 froid=341 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,CoverageRelation=WBJ05780C1
	#Cpc                  row=181659 proxy=15839 froAttr=froId moname=1 morev=8000 froid=0 ldn=ManagedElement=1,RncFunction=1,Cpc=1
	#CpmTransGapPattSeq   row=1036 proxy=314 froAttr=froId moname=4 morev=6000 froid=3 ldn=ManagedElement=1,RncFunction=1,CpmTransGapPattSeq=4
	#DcDevice             row=12053 proxy=4500 froAttr=froId moname=65 morev=6000 froid=64 ldn=ManagedElement=1,Equipment=1,SpDevicePool=DcDevice,DcDevice=65
	#DchFrameSynch        row=2495 proxy=709 froAttr=froId moname=5 morev=6000 froid=5 ldn=ManagedElement=1,RncFunction=1,DchFrameSynch=5
	#DchMap               row=161552 proxy=14933 froAttr=froId moname=1 morev=6000 froid=1 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlDchQosClassProfile=0,TrafficClass=6,DchMap=1
	#Dhcp                 row=17 proxy=16 froAttr=- moname=1 morev=6000 froid=1 ldn=ManagedElement=1,IpOam=1,Dhcp=1
	#E1PhysPathTerm       row=26338 proxy=7243 froAttr=phyPortFroId moname=pp8 morev=3500 froid=7 ldn=ManagedElement=1,Equipment=1,Subrack=ES-1,Slot=24,PlugInUnit=1,ExchangeTerminal=1,E1PhysPathTerm=pp8
	#E1Ttp                row=15270 proxy=6629 froAttr=e1TtpFroId moname=1 morev=3600 froid=10430062 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=27,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=ES-2-27-4,Vc4Ttp=1,Vc12Ttp=63,E1Ttp=1
	#Equipment            row=7 proxy=6 froAttr=- moname=1 morev=8000 froid= ldn=ManagedElement=1,Equipment=1
	#EthernetLink         row=2399 proxy=613 froAttr=ethernetFroId moname=1 morev=5000 froid=0 ldn=ManagedElement=1,IpOam=1,Ip=1,EthernetLink=1
	#EthernetSwitch       row=154823 proxy=14459 froAttr=froId moname=1 morev=6001 froid=4 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,EthernetSwitch=1
	#EthernetSwitchFabric row=20 proxy=19 froAttr=- moname=1 morev=7000 froid= ldn=ManagedElement=1,EthernetSwitchFabric=1
	#EthernetSwitchPort   row=154852 proxy=14488 froAttr=froId moname=7 morev=8001 froid=28 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,EthernetSwitch=1,EthernetSwitchPort=7
	#Eul                  row=267135 proxy=43225 froAttr=froId moname=1 morev=6000 froid=246 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Hsdsch=1,Eul=1
	#ExchangeTerminal     row=13053 proxy=5077 froAttr=froId moname=1 morev=5000 froid=74 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=26,PlugInUnit=1,ExchangeTerminal=1
	#ExchangeTerminal.Program row=212026 proxy=20346 froAttr=resourceId moname=CXC1723512_R74G03 morev=6000 froid=124 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=26,PlugInUnit=1,ExchangeTerminal=1,Program=CXC1723512_R74G03
	#ExchangeTerminalIp   row=154805 proxy=14455 froAttr=froId moname=1 morev=6000 froid=6 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1
	#ExchangeTerminalIp.Program row=212046 proxy=20366 froAttr=resourceId moname=CXC1729756_R74G02 morev=6000 froid=114 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,Program=CXC1729756_R74G02
	#ExternalGsmCell      row=268474 proxy=44564 froAttr=froId moname=E09567 morev=6000 froid=239 ldn=ManagedElement=1,RncFunction=1,ExternalGsmNetwork=GSM_1,ExternalGsmCell=E09567
	#ExternalGsmNetwork   row=4579 proxy=2099 froAttr=froId moname=GSM_1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,ExternalGsmNetwork=GSM_1
	#ExternalUtranCell    row=268476 proxy=44566 froAttr=froId moname=WBJ05382A2 morev=6000 froid=648 ldn=ManagedElement=1,RncFunction=1,IurLink=IUR_BJECR03,ExternalUtranCell=WBJ05382A2
	#Fach                 row=267106 proxy=43196 froAttr=froId moname=1 morev=6000 froid=242 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Fach=1
	#Fan                  row=11949 proxy=4412 froAttr=resourceId moname=1 morev=7000 froid=3 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Fan=1
	#Fan.Program          row=11950 proxy=4413 froAttr=resourceId moname=CXP901802/2_R18D01 morev=6000 froid=3 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Fan=1,Program=CXP901802/2_R18D01
	#GeneralProcessorUnit row=11774 proxy=4383 froAttr=- moname=1 morev=4230 froid= ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=17,PlugInUnit=1,GeneralProcessorUnit=1
	#GigaBitEthernet      row=2394 proxy=608 froAttr=froId moname=1 morev=5000 froid=2 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=26,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1
	#GpsReceiver          row=82533 proxy=7985 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,Equipment=1,Subrack=MS,GpsReceiver=1
	#GsmRelation          row=268475 proxy=44565 froAttr=froId moname=WBJ97425A1-E09567 morev=2010 froid=1712 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ97425A1,GsmRelation=WBJ97425A1-E09567
	#Handover             row=1032 proxy=310 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Handover=1
	#Hsdsch               row=267117 proxy=43207 froAttr=froId moname=1 morev=8000 froid=242 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Hsdsch=1
	#ImaGroup             row=267030 proxy=43120 froAttr=imaGroupFroId moname=ES-2-27-4-ima54 morev=5000 froid=30 ldn=ManagedElement=1,TransportNetwork=1,ImaGroup=ES-2-27-4-ima54
	#ImaLink              row=267034 proxy=43124 froAttr=froId moname=4 morev=3600 froid=120 ldn=ManagedElement=1,TransportNetwork=1,ImaGroup=ES-2-27-4-ima54,ImaLink=4
	#InternalEthernetPort row=154825 proxy=14461 froAttr=froId moname=1 morev=6000 froid=6 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,InternalEthernetPort=1
	#InternalLinkGroup    row=11397 proxy=4328 froAttr=resourceId moname=ISL-2 morev=3000 froid=537001984 ldn=ManagedElement=1,SwitchFabric=1,InternalLinkGroup=ISL-2
	#Ip                   row=2395 proxy=609 froAttr=ipFroId moname=1 morev=8000 froid=1 ldn=ManagedElement=1,IpOam=1,Ip=1
	#IpAccessHostEt       row=190998 proxy=15925 froAttr=ipacHostEtFroId moname=MS-26-1 morev=6100 froid=12 ldn=ManagedElement=1,IpSystem=1,IpAccessHostEt=MS-26-1
	#IpAccessHostGpb      row=6000 proxy=2174 froAttr=ipacHostGpbFroId moname=MS-8 morev=5001 froid=6 ldn=ManagedElement=1,IpSystem=1,IpAccessHostGpb=MS-8
	#IpAccessHostPool     row=190999 proxy=15926 froAttr=froId moname=IUR_UP morev=6020 froid=1 ldn=ManagedElement=1,IpSystem=1,IpAccessHostPool=IUR_UP
	#IpAccessHostSpb      row=5997 proxy=2171 froAttr=froId moname=MS-23 morev=5001 froid=5 ldn=ManagedElement=1,IpSystem=1,IpAccessHostSpb=MS-23
	#IpAtmLink            row=7849 proxy=2243 froAttr=IpOverAtmFroId moname=secondOAMatm morev=5000 froid=1 ldn=ManagedElement=1,IpOam=1,Ip=1,IpAtmLink=secondOAMatm
	#IpEthPacketDataRouter row=6018 proxy=2185 froAttr=froId moname=MS-23_2 morev=6010 froid=9 ldn=ManagedElement=1,Equipment=1,SpDevicePool=PdrDevice,PdrDevice=5,IpEthPacketDataRouter=MS-23_2
	#IpInterface          row=190996 proxy=15923 froAttr=froId moname=MS-26_IUR_UP morev=8000 froid=10 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=26,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=MS-26_IUR_UP
	#IpOam                row=16 proxy=15 froAttr=resourceId moname=1 morev=6000 froid=1 ldn=ManagedElement=1,IpOam=1
	#IpRoutingTable       row=2396 proxy=610 froAttr=resourceId moname=1 morev=3000 froid= ldn=ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1
	#IpSystem             row=19 proxy=18 froAttr=resourceId moname=1 morev=6000 froid= ldn=ManagedElement=1,IpSystem=1
	#IuLink               row=253130 proxy=30475 froAttr=froId moname=IU_SGSN7 morev=7000 froid=4 ldn=ManagedElement=1,RncFunction=1,CnOperator=1,IuLink=IU_SGSN7
	#IubEdch              row=267118 proxy=43208 froAttr=froId moname=1 morev=6000 froid=3 ldn=ManagedElement=1,RncFunction=1,IubLink=Iub_WBJ05780,IubEdch=1
	#IubLink              row=267056 proxy=43146 froAttr=froId moname=Iub_WBJ05780 morev=7000 froid=3 ldn=ManagedElement=1,RncFunction=1,IubLink=Iub_WBJ05780
	#IurLink              row=268490 proxy=44580 froAttr=froId moname=IUR_BJECR92 morev=7000 froid=32 ldn=ManagedElement=1,RncFunction=1,IurLink=IUR_BJECR92
	#Jvm                  row=8 proxy=7 froAttr=- moname=1 morev=6000 froid=0 ldn=ManagedElement=1,Equipment=1,Jvm=1
	#Licensing            row=14 proxy=13 froAttr=- moname=1 morev=8000 froid= ldn=ManagedElement=1,SystemFunctions=1,Licensing=1
	#LoadControl          row=12004 proxy=4467 froAttr=froId moname=1 morev=6000 froid= ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=17,PlugInUnit=1,GeneralProcessorUnit=1,LoadControl=1
	#LoadModule           row=210448 proxy=18774 froAttr=- moname=CXC1727653/4_R3EA01 morev=7000 froid= ldn=ManagedElement=1,SwManagement=1,LoadModule=CXC1727653/4_R3EA01
	#LocationArea         row=6062 proxy=2190 froAttr=froId moname=40978 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,LocationArea=40978
	#LogService           row=15 proxy=14 froAttr=- moname=1 morev=6000 froid= ldn=ManagedElement=1,SystemFunctions=1,LogService=1
	#M3uAssociation       row=268486 proxy=44576 froAttr=M3uAssociationId moname=Iur_ECR17_ECR92_1 morev=4200 froid=24 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,M3uAssociation=Iur_ECR17_ECR92_1
	#ManagedElement       row=1 proxy=0 froAttr=- moname=1 morev=6100 froid=0 ldn=ManagedElement=1
	#ManagedElementData   row=2 proxy=1 froAttr= moname=1 morev=7000 froid= ldn=ManagedElement=1,ManagedElementData=1
	#MediumAccessUnit     row=2398 proxy=612 froAttr=mauId moname=1 morev=3050 froid=1 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=11,PlugInUnit=1,GeneralProcessorUnit=1,MediumAccessUnit=1
	#Mtp3bAp              row=268488 proxy=44578 froAttr=mtp3bApFroId moname=MTP3AP_BJECR92_S morev=7000 froid=37 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,Mtp3bAp=MTP3AP_BJECR92_S
	#Mtp3bSlItu           row=161700 proxy=14963 froAttr=mtp3bSlFroId moname=SL_BJECR38_01 morev=3000 froid=20 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,Mtp3bSls=SLS_BJECR38,Mtp3bSlItu=SL_BJECR38_01
	#Mtp3bSls             row=161698 proxy=14961 froAttr=mtp3bSlsFroId moname=SLS_BJECR38 morev=3000 froid=3 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,Mtp3bSls=SLS_BJECR38
	#Mtp3bSpItu           row=4691 proxy=2147 froAttr=froId moname=1 morev=6010 froid=1 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1
	#Mtp3bSr              row=268487 proxy=44577 froAttr=mtp3bSrFroId moname=SR_BJECR92_IUR_CP1 morev=3000 froid=32 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,Mtp3bSrs=SRS_BJECR92,Mtp3bSr=SR_BJECR92_IUR_CP1
	#Mtp3bSrs             row=268485 proxy=44575 froAttr=mtp3bSrsFroId moname=SRS_BJECR92 morev=7000 froid=31 ldn=ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=1,Mtp3bSrs=SRS_BJECR92
	#MultiCarrier         row=267136 proxy=43226 froAttr=froId moname=1 morev=8010 froid=231 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Hsdsch=1,Eul=1,MultiCarrier=1
	#NbapCommon           row=267058 proxy=43148 froAttr=froId moname=05780 morev=6000 froid=3 ldn=ManagedElement=1,RncFunction=1,IubLink=Iub_WBJ05780,NbapCommon=05780
	#NbapDedicated        row=267059 proxy=43149 froAttr=froId moname=05780 morev=6000 froid=3 ldn=ManagedElement=1,RncFunction=1,IubLink=Iub_WBJ05780,NbapDedicated=05780
	#Ncli                 row=221 proxy=71 froAttr=- moname=1 morev=5100 froid= ldn=ManagedElement=1,SystemFunctions=1,Ncli=1
	#NniSaalProfile       row=32737 proxy=7305 froAttr=- moname=win100 morev=5000 froid= ldn=ManagedElement=1,TransportNetwork=1,NniSaalProfile=win100
	#NniSaalTp            row=161690 proxy=14953 froAttr=nsaalCepFroId moname=NNI_BJECR38_02 morev=5100 froid=20 ldn=ManagedElement=1,TransportNetwork=1,NniSaalTp=NNI_BJECR38_02
	#NodeSynch            row=267057 proxy=43147 froAttr=froId moname=1 morev=6010 froid=3 ldn=ManagedElement=1,RncFunction=1,IubLink=Iub_WBJ05780,NodeSynch=1
	#Os155SpiTtp          row=15143 proxy=6502 froAttr=Os155FroId moname=ES-2-27-4 morev=3500 froid=1043 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=27,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=ES-2-27-4
	#Paging               row=1031 proxy=309 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Paging=1
	#Pch                  row=267108 proxy=43198 froAttr=froId moname=1 morev=6000 froid=242 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Pch=1
	#PdrDevice            row=2388 proxy=602 froAttr=froId moname=5 morev=6000 froid=4 ldn=ManagedElement=1,Equipment=1,SpDevicePool=PdrDevice,PdrDevice=5
	#PiuType              row=210506 proxy=18832 froAttr=- moname=KDU137557/4_* morev=6100 froid= ldn=ManagedElement=1,SwManagement=1,PiuType=KDU137557/4_*
	#PlmnIdentityGroup    row=4577 proxy=2097 froAttr=froId moname=PLMN_1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,PlmnIdentityGroup=PLMN_1
	#PlugInUnit           row=154804 proxy=14454 froAttr=resourceId moname=1 morev=8003 froid=76 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1
	#PmService            row=6 proxy=5 froAttr=- moname=1 morev=6000 froid= ldn=ManagedElement=1,SystemFunctions=1,PmService=1
	#PositioningServiceClass row=916 proxy=194 froAttr=froId moname=2 morev=6000 froid=2 ldn=ManagedElement=1,RncFunction=1,UePositioning=1,PositioningServiceClass=2
	#PowerControl         row=1030 proxy=308 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,PowerControl=1
	#Program              row=212043 proxy=20363 froAttr=resourceId moname=CXC1321121_R74G36 morev=6000 froid=10175 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,Program=CXC1321121_R74G36
	#RabHandling          row=925 proxy=203 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RabHandling=1
	#Rach                 row=267107 proxy=43197 froAttr=froId moname=1 morev=6000 froid=242 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3,Rach=1
	#Ranap                row=253131 proxy=30476 froAttr=froId moname=SGSN7 morev=6010 froid=4 ldn=ManagedElement=1,RncFunction=1,CnOperator=1,IuLink=IU_SGSN7,Ranap=SGSN7
	#Rcs                  row=924 proxy=202 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Rcs=1
	#ReliableProgramUniter row=11998 proxy=4461 froAttr=rpuId moname=sctp_host_12 morev=3000 froid=173 ldn=ManagedElement=1,SwManagement=1,ReliableProgramUniter=sctp_host_12
	#Repertoire           row=210590 proxy=18916 froAttr=- moname=CPP_ETMF4 morev=7000 froid= ldn=ManagedElement=1,SwManagement=1,Repertoire=CPP_ETMF4
	#ResMeasControl       row=923 proxy=201 froAttr=- moname=1 morev=7000 froid= ldn=ManagedElement=1,RncFunction=1,ResMeasControl=1
	#RncCapacity          row=907 proxy=185 froAttr=froId moname=FachDchHsUsers morev=6000 froid=1 ldn=ManagedElement=1,SystemFunctions=1,Licensing=1,RncCapacity=FachDchHsUsers
	#RncConfigLimits      row=181658 proxy=15838 froAttr= moname=1 morev=8000 froid= ldn=ManagedElement=1,RncFunction=1,RncConfigLimits=1
	#RncDeployment        row=795 proxy=76 froAttr=- moname=1 morev=6000 froid= ldn=ManagedElement=1,RncDeployment=1
	#RncFeature           row=212348 proxy=20668 froAttr=froId moname=RabCombination176 morev=6000 froid=141 ldn=ManagedElement=1,SystemFunctions=1,Licensing=1,RncFeature=RabCombination176
	#RncFunction          row=908 proxy=186 froAttr=froId moname=1 morev=8000 froid=0 ldn=ManagedElement=1,RncFunction=1
	#RncModule            row=12010 proxy=4473 froAttr=froId moname=12 morev=6000 froid=14 ldn=ManagedElement=1,RncFunction=1,RncModule=12
	#RncRealtimeIndicators row=181660 proxy=15840 froAttr=froId moname=1 morev=8000 froid=0 ldn=ManagedElement=1,RncFunction=1,RncRealtimeIndicators=1
	#RncSystemParameters  row=922 proxy=200 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RncSystemParameters=1
	#RnlQosClassProfile   row=947 proxy=225 froAttr=froId moname=Downlink morev=8000 froid=1 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,RnlQosClassProfile=Downlink
	#Rnsap                row=268491 proxy=44581 froAttr=froId moname=BJECR92 morev=6000 froid=27 ldn=ManagedElement=1,RncFunction=1,IurLink=IUR_BJECR92,Rnsap=BJECR92
	#RoutingArea          row=9937 proxy=4296 froAttr=froId moname=18 morev=6000 froid=1 ldn=ManagedElement=1,RncFunction=1,LocationArea=40978,RoutingArea=18
	#Rrc                  row=921 proxy=199 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Rrc=1
	#RttPositioning       row=913 proxy=191 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,UePositioning=1,RttPositioning=1
	#SasPositioning       row=909 proxy=187 froAttr=froId moname=1 morev=7000 froid=0 ldn=ManagedElement=1,RncFunction=1,SasPositioning=1
	#SccpApLocal          row=13657 proxy=5084 froAttr=sccpApFroId moname=RNSAP morev=43200 froid=2 ldn=ManagedElement=1,TransportNetwork=1,SccpSp=1,SccpScrc=1,SccpApLocal=RNSAP
	#SccpApRemote         row=268489 proxy=44579 froAttr=sccpApFroId moname=SCCP_BJECR92 morev=42000 froid=30 ldn=ManagedElement=1,TransportNetwork=1,SccpSp=1,SccpScrc=1,SccpApRemote=SCCP_BJECR92
	#SccpScrc             row=4693 proxy=2149 froAttr=sccpScrcFroId moname=1 morev=3000 froid=1 ldn=ManagedElement=1,TransportNetwork=1,SccpSp=1,SccpScrc=1
	#SccpSp               row=4692 proxy=2148 froAttr=sccpSpFroId moname=1 morev=4300 froid=1 ldn=ManagedElement=1,TransportNetwork=1,SccpSp=1
	#Sctp                 row=6001 proxy=2175 froAttr=sctpFroId moname=MS-8 morev=7000 froid=1 ldn=ManagedElement=1,TransportNetwork=1,Sctp=MS-8
	#SduFormat            row=2534 proxy=748 froAttr=froId moname=4 morev=6000 froid=22 ldn=ManagedElement=1,RncFunction=1,UeRabType=6,Subflow=2,SduFormat=4
	#Security             row=13 proxy=12 froAttr=- moname=1 morev=5100 froid= ldn=ManagedElement=1,SystemFunctions=1,Security=1
	#SecurityHandling     row=920 proxy=198 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,SecurityHandling=1
	#ServiceArea          row=267072 proxy=43162 froAttr=froId moname=10433 morev=6000 froid=241 ldn=ManagedElement=1,RncFunction=1,LocationArea=40978,ServiceArea=10433
	#Sid                  row=919 proxy=197 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Sid=1
	#Slot                 row=11396 proxy=4327 froAttr=resourceId moname=28 morev=7000 froid=140 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=28
	#SpDevicePool         row=905 proxy=183 froAttr=froId moname=PdrDevice morev=6010 froid=2 ldn=ManagedElement=1,Equipment=1,SpDevicePool=PdrDevice
	#SpiQosClass          row=991 proxy=269 froAttr=froId moname=0 morev=6000 froid=29 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,RnlQosClassProfile=Downlink,SpiQosClass=0
	#Spm                  row=11926 proxy=4411 froAttr=spmInstanceId moname=5 morev=3000 froid=32882 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=23,PlugInUnit=1,Spu=1,Spm=5
	#Spm.Program          row=211990 proxy=20310 froAttr=resourceId moname=CXC1325827_R74G97 morev=6000 froid=3886 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=23,PlugInUnit=1,Spu=1,Spm=5,Program=CXC1325827_R74G97
	#Spu                  row=11921 proxy=4406 froAttr=spuInstanceId moname=1 morev=3000 froid=23 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=23,PlugInUnit=1,Spu=1
	#Spu.Program          row=180473 proxy=15613 froAttr=resourceId moname=CXC1327680_R60AK18 morev=6000 froid=126 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=23,PlugInUnit=1,Spu=1,Program=CXC1327680_R60AK18
	#Subflow              row=2530 proxy=744 froAttr=froId moname=2 morev=6000 froid=8 ldn=ManagedElement=1,RncFunction=1,UeRabType=6,Subflow=2
	#Subrack              row=11368 proxy=4299 froAttr=resourceId moname=ES-2 morev=7000 froid=5 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2
	#SubrackProdType      row=210459 proxy=18785 froAttr=- moname=ROJ999999_P1 morev=7000 froid= ldn=ManagedElement=1,Equipment=1,SubrackProdType=ROJ999999_P1
	#SwAllocation         row=210597 proxy=18917 froAttr=- moname=ETIPG morev=3020 froid= ldn=ManagedElement=1,SwManagement=1,SwAllocation=ETIPG
	#SwManagement         row=9 proxy=8 froAttr=- moname=1 morev=8000 froid= ldn=ManagedElement=1,SwManagement=1
	#SwitchCoreUnit       row=11401 proxy=4332 froAttr=nss_resourceId moname=1 morev=3000 froid=131072 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=28,PlugInUnit=1,SwitchCoreUnit=1
	#SwitchExtensionUnit  row=1549 proxy=442 froAttr=nss_resourceId moname=1 morev=3000 froid=2 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=2,PlugInUnit=1,SwitchExtensionUnit=1
	#SwitchFabric         row=12 proxy=11 froAttr=- moname=1 morev=3000 froid=0 ldn=ManagedElement=1,SwitchFabric=1
	#SwitchInternalLink   row=11403 proxy=4334 froAttr=nssResourceId moname=ISL-2-B morev=3500 froid=65536 ldn=ManagedElement=1,SwitchFabric=1,InternalLinkGroup=ISL-2,SwitchInternalLink=ISL-2-B
	#SwitchModule         row=11338 proxy=4298 froAttr=switchModuleFroId moname=ES-2 morev=3001 froid=268566528 ldn=ManagedElement=1,SwitchFabric=1,SwitchModule=ES-2
	#SwitchPortStp        row=154853 proxy=14489 froAttr=froId moname=1 morev=6000 froid=28 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,EthernetSwitch=1,EthernetSwitchPort=7,SwitchPortStp=1
	#SwitchStp            row=154824 proxy=14460 froAttr=froId moname=1 morev=6000 froid=4 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,EthernetSwitch=1,SwitchStp=1
	#Synchronization      row=18 proxy=17 froAttr=- moname=1 morev=3000 froid= ldn=ManagedElement=1,TransportNetwork=1,Synchronization=1
	#SystemFunctions      row=3 proxy=2 froAttr=- moname=1 morev=4200 froid= ldn=ManagedElement=1,SystemFunctions=1
	#TimDevice            row=2392 proxy=606 froAttr=froId moname=1 morev=6010 froid=1 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=5,PlugInUnit=1,TimDevice=1
	#TimingUnit           row=1721 proxy=459 froAttr=froId moname=1 morev=3000 froid=1 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=5,PlugInUnit=1,TimingUnit=1
	#TimingUnit.Program   row=211103 proxy=19423 froAttr=resourceId moname=CXC1321123/2_R74G02 morev=6000 froid=12 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=5,PlugInUnit=1,TimingUnit=1,Program=CXC1321123/2_R74G02
	#TnlCchQosClassProfile row=910 proxy=188 froAttr=froId moname=1 morev=7000 froid=0 ldn=ManagedElement=1,RncFunction=1,TnlCchQosClassProfile=1
	#TnlDchQosClassProfile row=939 proxy=217 froAttr=froId moname=0 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlDchQosClassProfile=0
	#TnlHspaQosClassProfile row=992 proxy=270 froAttr=froId moname=0 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlHspaQosClassProfile=0
	#TnlIuQosClassProfile row=1009 proxy=287 froAttr=froId moname=0 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlIuQosClassProfile=0
	#TnlQosClass          row=161550 proxy=14931 froAttr=froId moname=5 morev=6000 froid=21 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlDchQosClassProfile=0,TnlQosClass=5
	#TrafficClass         row=1013 proxy=291 froAttr=froId moname=4 morev=8000 froid=23 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlIuQosClassProfile=0,TrafficClass=4
	#TrafficClassPsInt    row=1025 proxy=303 froAttr=froId moname=2 morev=8000 froid=15 ldn=ManagedElement=1,RncFunction=1,RabHandling=1,TnlIuQosClassProfile=0,TrafficClassPsInt=2
	#TransportNetwork     row=5 proxy=4 froAttr=- moname=1 morev=3000 froid= ldn=ManagedElement=1,TransportNetwork=1
	#TuSyncRef            row=3935 proxy=2083 froAttr=froId moname=1 morev=6000 froid=1 ldn=ManagedElement=1,Equipment=1,Subrack=MS,Slot=5,PlugInUnit=1,TimingUnit=1,TuSyncRef=1
	#UeMeasControl        row=918 proxy=196 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,UeMeasControl=1
	#UePositioning        row=912 proxy=190 froAttr=froId moname=1 morev=6010 froid=0 ldn=ManagedElement=1,RncFunction=1,UePositioning=1
	#UeRabType            row=2524 proxy=738 froAttr=froId moname=6 morev=6000 froid=5 ldn=ManagedElement=1,RncFunction=1,UeRabType=6
	#UeRc                 row=212109 proxy=20429 froAttr=froId moname=176 morev=6010 froid=176 ldn=ManagedElement=1,RncFunction=1,UeRc=176
	#UeRcEdchFlow         row=212229 proxy=20549 froAttr=froId moname=2 morev=6010 froid=32 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcEdchFlow=2
	#UeRcEdchGainFactors  row=212265 proxy=20585 froAttr=froId moname=1 morev=6010 froid=45 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcPhyChEdch=2,UeRcEdchGainFactors=1
	#UeRcHsdsch           row=212207 proxy=20527 froAttr=froId moname=1 morev=6000 froid=38 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcHsdsch=1
	#UeRcPhyChDl          row=212119 proxy=20439 froAttr=froId moname=1 morev=6000 froid=90 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcPhyChDl=1
	#UeRcPhyChEdch        row=212239 proxy=20559 froAttr=froId moname=2 morev=6010 froid=14 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcPhyChEdch=2
	#UeRcPhyChUl          row=212114 proxy=20434 froAttr=froId moname=1 morev=6000 froid=90 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcPhyChUl=1
	#UeRcRab              row=212185 proxy=20505 froAttr=froId moname=3 morev=6000 froid=245 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcRab=3
	#UeRcRb               row=212161 proxy=20481 froAttr=froId moname=8 morev=6000 froid=649 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcRb=8
	#UeRcRbRlc            row=212339 proxy=20659 froAttr=froId moname=6 morev=7000 froid=97 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcRb=5,UeRcRbRlc=6
	#UeRcTrCh             row=212202 proxy=20522 froAttr=froId moname=4 morev=6000 froid=325 ldn=ManagedElement=1,RncFunction=1,UeRc=176,UeRcTrCh=4
	#UeRrcType            row=2496 proxy=710 froAttr=froId moname=1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,UeRrcType=1
	#UniSaalProfile       row=5284 proxy=2156 froAttr=- moname=win100 morev=3300 froid= ldn=ManagedElement=1,TransportNetwork=1,UniSaalProfile=win100
	#UniSaalTp            row=267052 proxy=43142 froAttr=usaalCepFroId moname=b104qa morev=5100 froid=12 ldn=ManagedElement=1,TransportNetwork=1,UniSaalTp=b104qa
	#UpgradePackage       row=210090 proxy=18416 froAttr=- moname=CXP9014711/4_R4EA08 morev=6100 froid= ldn=ManagedElement=1,SwManagement=1,UpgradePackage=CXP9014711/4_R4EA08
	#UpgradeTrace         row=11 proxy=10 froAttr=- moname=1 morev=6000 froid= ldn=ManagedElement=1,SwManagement=1,UpgradeTrace=1
	#Ura                  row=9933 proxy=4292 froAttr=froId moname=11 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,Ura=11
	#UtranCell            row=267105 proxy=43195 froAttr=froId moname=WBJ05780C3 morev=8000 froid=241 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ05780C3
	#UtranNetwork         row=4578 proxy=2098 froAttr=froId moname=UTRAN_1 morev=6000 froid=0 ldn=ManagedElement=1,RncFunction=1,UtranNetwork=UTRAN_1
	#UtranRelation        row=268477 proxy=44567 froAttr=froId moname=WBJ03157B2-WBJ05382A2 morev=2010 froid=8250 ldn=ManagedElement=1,RncFunction=1,UtranCell=WBJ03157B2,UtranRelation=WBJ03157B2-WBJ05382A2
	#Vc12Ttp              row=15269 proxy=6628 froAttr=vc12TtpFroId moname=63 morev=3400 froid=10430062 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=27,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=ES-2-27-4,Vc4Ttp=1,Vc12Ttp=63
	#Vc4Ttp               row=15144 proxy=6503 froAttr=Vc4TtpFroId moname=1 morev=3500 froid=104300 ldn=ManagedElement=1,Equipment=1,Subrack=ES-2,Slot=27,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=ES-2-27-4,Vc4Ttp=1
	#VclTp                row=267138 proxy=43228 froAttr=vcCpFroId moname=vc104 morev=6000 froid=681 ldn=ManagedElement=1,TransportNetwork=1,AtmPort=ES-2-27-4-ima54,VplTp=vp1,VpcTp=1,VclTp=vc104
	#VpcTp                row=267037 proxy=43127 froAttr=VpcTpId moname=1 morev=3000 froid=39 ldn=ManagedElement=1,TransportNetwork=1,AtmPort=ES-2-27-4-ima54,VplTp=vp1,VpcTp=1
	#VplTp                row=267036 proxy=43126 froAttr=vplTpFroId moname=vp1 morev=6000 froid=39 ldn=ManagedElement=1,TransportNetwork=1,AtmPort=ES-2-27-4-ima54,VplTp=vp1
	#WcdmaCarrier         row=267023 proxy=43113 froAttr=froId moname=CU_Carrier_3 morev=6000 froid=17 ldn=ManagedElement=1,RncFunction=1,IurLink=IUR_BJECR90,WcdmaCarrier=CU_Carrier_3
	#WebServer            row=4 proxy=3 froAttr=- moname=1 morev=3006 froid=0 ldn=ManagedElement=1,SystemFunctions=1,WebServer=1


	if (maxProxy == 0)
	{
		MibPrefix=mibprefix
		Ldn[0]="ManagedElement=1"
		MoType[0]="ManagedElement"
		MoProxy["managedelement=1"]=MoProxy["ManagedElement=1"]=0
		tmp=mibtableMAO[0,"userLabel"]
		if (tmp=="" && MibPrefix ~ "MeContext=") tmp=gensub(/,.*$/,"",1,gensub(/^.*MeContext=/,"",1,MibPrefix))
		if (tmp!="") dbNodeName=tmp
		customPrint(sprintf("Connected to %s%s (%sManagedElement=1)",node_address,(tmp!=""?", Node: "tmp:""),(MibPrefix!=""?MibPrefix",":"")),"","force")
		if (mom_version != "") customPrint(sprintf("MOM version: %s (CPP%s)",mom_version,gensub(/-FAKE/,"",1,CelloVersion)))
		customPrint(sprintf("%-47s%-47s%s","0%","~50%","~100%"),"","force")
		ClassProxy["ManagedElement"]=0
		modataId[0]=row

	}
	else
	{
		Ldn[maxProxy]=ldn
		MoType[maxProxy]=motype
		MoProxy[l2m(ldn)]=maxProxy
		MoProxy[tolower(l2m(ldn))]=maxProxy
		split(ldn,array,",")
		DirectMeChildren[array[2]]=array[2]
		nrOfMoTypes[tolower(motype)]++
		ClassProxy[tolower(motype)]=maxProxy
		modataId[maxProxy]=row
		if (motype=="EthernetLink") mibtableExtra["ethernetproxy"]=maxProxy
		else if (motype=="IpHostLink") mibtableExtra["iphostlinkproxy"]=maxProxy
	}
	#MaoData[row]=motype SUBSEP morev SUBSEP maxProxy SUBSEP froId SUBSEP moname SUBSEP ldn
}

function dbcheck(silent,      i,array,last,j,last2,array2,n,word,f1d,f2d,f1u,f2u,k,pcell,intercntr,intracntr,result,upadmdata,cellcntrtable,relationdata,dupLdnCount,\
nonexistMaoRefCount,maoFroMismatchCount,dupFroidCount,hangingReserved,missingReserved,aline,bline,pointCodeCollision,z,invalidSeqRef,fanconf,curr_sr,nr_fans,\
fanCorruptionLine,fanCorruption,dbcFanCheck,MoLdnList,tmpparent,tline,parentLineList,missingParent,m,invalidFroId,outputLine,t_prox,extra,moc,nrOfRels,nrOfRncRels,\
handoverOnlyCntr,cellReselectionCntr,gsmRelHoAndCellReselCntr,g,c,h)
{
	if (! dbdat) return
	#tablePrint(froIdList,"froIdList")
	aline="=============================================================================="
	bline="------------------------------------------------------------------------------"
	#for (i=0;i<=maxProxy;i++)
	#{
	#	row=modataId[i]
	#	split(MaoData[row],array,SUBSEP)
	#	customPrint(sprintf("%-5s  %-6s  %-4s  %-*s  %-30s  %s",array[3],row,array[4],maxMotypeLength,array[1],array[5],array[6]))
	#}

	#delete sql_moclass_list
	#for (i in nrOfMoTypes) sql_moclass_list[i]=i
	#n=asort(sql_moclass_list)
	#for (i=1;i<=n;i++)
	#{
	#	customPrint(sprintf("%-30s  %s",sql_moclass_list[i],nrOfMoTypes[sql_moclass_list[i]]))
	#}
	result="OK"
	upadmdata=mibtableMAO[s2p(mibtableMAO[s2p("ManagedElement=1,SwManagement=1,ConfigurationVersion=1"),"currentUpgradePackage"]),"UpgradePackageDocumentId"]
	dbNodeIp=gensub(/^.*\(|\).*$/,"","g",mibtableFRO[mibtableExtra["ethernetproxy"],"ipaddress"])
	if (dbNodeIp ~ "169.254.")
	{
		tmp_dbNodeIp=gensub(/^.*\(|\).*$/,"","g",mibtableFRO[mibtableExtra["iphostlinkproxy"],"ipaddress"])
		if (is_ip_addr(tmp_dbNodeIp)==1) dbNodeIp=tmp_dbNodeIp
	}
	else if (dbNodeIp=="") dbNodeIp=dbNodeIpOamLink
	if (silent=="")
	{
		customPrint(sprintf("\n%s\nDatabase Consistency Check for node: %s, ip=%s, mom=%s, up=%s %s\nFile: %s\n%s",aline,\
dbNodeName,dbNodeIp,gensub(/_NODE_MODEL/,"",1,mom_version),upadmdata,up_translate(upadmdata,"short"),iorfile,aline))
	}
	n=asort(invalidMonameList)
	if (n > 0)
	{
		if (tooManyInstancesInPM==1) result="OK with Warnings: non-recommended characters in MAO names and too many MO instances in instance-based PM scanners."
		else result="OK with Warnings: non-recommended characters in MAO names."
	}
	else if (tooManyInstancesInPM==1) result="OK with Warnings: too many MO instances in instance-based PM scanners."

	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs with non-recommended characters in the MAO name (recommended range: -_/.A-Za-z0-9!%:*): %s",\
++z,(n > 0 ? "YES" : "NO")))
		for (i=1;i<=n;i++)
		{
			customPrint(sprintf("%5s %s  MAO name: %s",invalidMonameList[i],p2s("Mo",invalidMonameList[i]),mibtableMAO[invalidMonameList[i],"maoName"]))
		}
		customPrint(bline)
	}
	n=asort(dangerousMonameList)
	if (n > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs with dangerous characters in the MAO name `,=^\"|' (HL11572/UABtr75948): %s",\
++z,(n > 0 ? "YES" : "NO")))
		for (i=1;i<=n;i++)
		{
			customPrint(sprintf("%5s %s  MAO name: %s",dangerousMonameList[i],p2s("Mo",dangerousMonameList[i]),mibtableMAO[dangerousMonameList[i],"maoName"]))
		}
		customPrint(bline)
	}
	if (maoMissingFro > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs without FROs: %s",++z,(maoMissingFro > 0 ? "YES" : "NO")))
		for (i=1;i<=maoMissingFro;i++)
		{
			split(maoWithoutFro[i],array,",")
			customPrint(sprintf("%5s %s : %s=%s not found in table %s",array[3],p2s("MediumMo",array[3]),array[5],array[2],array[4]))
		}
		customPrint(bline)
	}
	if (froMissingMao > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) FROs without MAOs: %s",++z,(froMissingMao > 0 ? "YES" : "NO")))
		for (i=1;i<=froMissingMao;i++)
		{
			split(froWithoutMao[i],array,SUBSEP)
			customPrint(sprintf("%s=%s in %s (%s)",array[2],array[3],array[4],array[1]))
		}
		customPrint(bline)
	}
	for (i in LdnList)
	{
		last=split(LdnList[i],array,",")
		if (last > 1)
		{
			for (j=1;j<=last;j++) duplicateLdnList[++dupLdnCount]=array[j]
		}
	}
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs with duplicate LDN: %s",++z,(dupLdnCount > 0 ? "YES" : "NO")))
		for (i=1;i<=dupLdnCount;i++)
		{
			customPrint(sprintf("%5s %s%s",duplicateLdnList[i],p2s("Mo",duplicateLdnList[i]),\
(p2s("MoType",duplicateLdnList[i])=="Licensing"?" (known issue: TR UABtr63243 - no impact)":"")))
			if (p2s("MoType",duplicateLdnList[i])!="Licensing") result="NOT OK"
		}
		customPrint(bline)
	}
	else
	{
		for (i=1;i<=dupLdnCount;i++) if (p2s("MoType",duplicateLdnList[i])!="Licensing") result="NOT OK"
	}

	for (i in froIdList)
	{
		#froIdList[IubLink,30]=3440,3443
		last=split(froIdList[i],array,",")
		last2=split(i,array2,SUBSEP)
		#print "froIdList["array2[1]","array2[2]"]="froIdList[i]
		if (last > 1)
		{
			for (j=1;j<=last;j++) duplicateFroidList[++dupFroidCount]=array[j]","array2[2]
		}
	}
	if (dupFroidCount > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs with duplicate froId: %s",++z,(dupFroidCount > 0 ? "YES" : "NO")))
		for (i=1;i<=dupFroidCount;i++)
		{
			split(duplicateFroidList[i],array,",")
			customPrint(sprintf("%5s %s  froid=%s",array[1],p2s("MediumMo",array[1]),array[2]))
		}
		customPrint(bline)
	}
	n=asort(modataClassList)
	for (i=1;i<=n;i++)
	{
		if (modataClassList[i] ~ /^(Aal1TpVccTp|Aal2PathVccTp|SwitchInternalLink|SwitchCoreUnit|FastEthernet)$/||\
		    (modataClassList[i]=="PlugInUnit" && "sai" in sqlMapRealTable) ||\
		    (modataClassList[i]=="Aal5TpVccTp" && ("aal5apfrodata" in sqlMapRealTable || "aal5apfroevodata" in sqlMapRealTable)))
		{
			if ((nrMaoInstances[modataClassList[i]] * 2) != nrFroInstances[modataClassList[i]]) maofroMismatch[++maoFroMismatchCount]=sprintf("%-30s: %-4s MAOs, %-4s FROs (For %s, there should be 2 FROs per MAO).",modataClassList[i],nrMaoInstances[modataClassList[i]]+0,nrFroInstances[modataClassList[i]]+0,modataClassList[i])
		}
		else if (modataClassList[i] ~ /^(Aal[05]TpVccTp)$/)
		{
			if ((nrMaoInstances[modataClassList[i]] * 3) != nrFroInstances[modataClassList[i]]) maofroMismatch[++maoFroMismatchCount]=sprintf("%-30s: %-4s MAOs, %-4s FROs (For %s, there should be 3 FROs per MAO).",modataClassList[i],nrMaoInstances[modataClassList[i]]+0,nrFroInstances[modataClassList[i]]+0,modataClassList[i])
		}
		else if (mom_version ~ /^RBS_NODE_MODEL_[TU]_/ && modataClassList[i]~/^(AcDevice|AiDevice|AlmDevice|BfDevice|ClDevice|DbccDevice|DpclDevice|OutDevice|PdDevice|PsDevice|RetDevice|TimDevice|TmaDevice|TpaDevice|TrDevice|AcDeviceSet|AiDeviceSet|AlmDeviceSet|BfDeviceSet|ClDeviceSet|DbccDeviceSet|DbchDeviceSet|DpclDeviceSet|EDbchDeviceSet|EScDeviceSet|HsDbchDeviceSet|OutDeviceSet|PdDeviceSet|PsDeviceSet|RetDeviceSet|TimDeviceSet|TmaDeviceSet|TpaDeviceSet|TrDeviceSet|UbchDeviceSet|Carrier|RbsLocalCell|Sector|NbapCommon|NodeBFunction|Iub)$/)
		{
			# we currently don't check the RBS MOs that have more than 1 FRO, maybe can do that in a later release
		}
		else if (modataClassList[i] != "SwitchExtensionUnit")
		{
			# we don't check SwitchExtensionUnit because the number of FRO is different in main subrack (2 FROs) compared to extension subrack (1 FRO)
			if (nrMaoInstances[modataClassList[i]] != nrFroInstances[modataClassList[i]])
			{
				maofroMismatch[++maoFroMismatchCount]=sprintf("%-30s: %-4s MAOs, %-4s FROs",modataClassList[i],nrMaoInstances[modataClassList[i]]+0,nrFroInstances[modataClassList[i]]+0)
			}
		}
	}
	if (maoFroMismatchCount > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Mismatch between number of MAO and FRO instances: %s",++z,(maoFroMismatchCount > 0 ? "YES" : "NO")))
		for (i=1;i<=maoFroMismatchCount;i++) customPrint(maofroMismatch[i])
		customPrint(bline)
	}
	for (i=1;i<=maxMaoRef;i++)
	{
		split(maoRefCheck[i],array,SUBSEP)
		#print "DEBUGGG: "gensub(SUBSEP,"XX","g",maoRefCheck[i])
		#print p2s("MoType",array[1]),array[2],MoAttributesTypeJava[p2s("MoType",array[1])":"array[2]],array[3]
		if ((MoAttributesTypeJava[p2s("MoType",array[1])":"array[2]]=="ar" && array[3] !~ directMeChildrenString)||\
		    (p2s("MoType",array[1])":"array[2] ~ /^(Repertoire:connectedList|UpgradePackage:(faulty|nonSupported)PIUsLockedB(y|efore)Upgrade)$/))
		{
			fakeMoRef[p2s("MoType",array[1])":"array[2]]=1
			continue
		}
		if ((p2s("MoType",array[1])":"array[2]) in fakeMoRef) continue  #in case this is the second time we run dbcheck() in the session, then we arrive here
		if (s2p(array[3])=="") nonexistMaoRefList[++nonexistMaoRefCount]=sprintf("%5s %s %s %s",array[1],p2s("MediumMo",array[1]),array[2],array[3])
	}
	for (i in fakeMoRef)
	{
		#print "fakeMoRef: "i
		delete MoAttributesTypeJava[i]
		delete MoAttributesType[i]
	}
	if (nonexistMaoRefCount > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs referring to non-existent MAOs: %s",++z,(nonexistMaoRefCount > 0 ? "YES" : "NO")))
		for (i=1;i<=nonexistMaoRefCount;i++)
		{
			customPrint(nonexistMaoRefList[i])
		}
		customPrint(bline)
	}
	if (parentMismatchYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs defined under a different parent than FRO: %s",++z,(parentMismatchYes ? "YES" : "NO")))
		for (i=1;i<=maxProxy;i++)
		{
			if (i in parentMismatch)
			{
				#split(parentMismatch[i],array,SUBSEP)
				#sub(/ManagedElement=1,([^,]+,)?/,"",array[1]) ; sub(/ManagedElement=1,([^,]+,)?/,"",array[2])
				#customPrint(sprintf("%5s %s  maoParent: %s froParent: %s",i,p2s("MediumMo",i),array[1],array[2]))
				customPrint(sprintf("%5s %s  %s",i,p2s("MediumMo",i),parentMismatch[i]))
			}
		}
		customPrint(bline)
	}
	if (morefMismatchYesDbNotOk) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistent MO references between MAO and FRO: %s",++z,(morefMismatchYes ? "YES" : "NO")))
		for (i=1;i<=maxProxy;i++)
		{
			if (i in morefMismatch)
			{
				customPrint(sprintf("%5s %s  %s",i,p2s("MediumMo",i),morefMismatch[i]))
			}
		}
		customPrint(bline)
	}
	for (i in sqlToRelation)
	{
		if (!(i in sqlBackRelation))
		{
			split(i,array,SUBSEP)
			split(sqlToRelation[i],word,SUBSEP)
			missingReserved[i]=sprintf("%5s %s %s %s %s",word[1],array[1],word[2],array[2],sqlMapResattr[s2t(array[2])])
			if (s2t(array[1])=="EcBus" && word[2]=="ecBusConnectorRef" && s2t(array[2])=="PlugInUnit") missingReserved[i]=missingReserved[i]"  (known issue: TR HT31166 - no impact)"
			else if (s2t(array[1])=="EcPort" && word[2]=="ecBusRef" && s2t(array[2])=="EcBus") missingReserved[i]=missingReserved[i]"  (known issue: TR HT31166 - no impact)"
			else missingReservedYes=1
		}
	}
	if (missingReservedYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs missing from reservedBy list: %s",++z,(missingReservedYes ? "YES" : "NO")))
		n=asort(missingReserved)
		for (i=1;i<=n;i++) customPrint(missingReserved[i])
		customPrint(bline)
	}
	for (i in sqlBackRelation)
	{
		if (!(i in sqlToRelation))
		{
			split(i,array,SUBSEP)
			if (!(s2t(array[1]) in sqlMapToMos))
			{
				if (mosdebug==1 && silent=="") print "Skipping "array[1]" : not in sqlmap"
				continue
			}
			split(sqlBackRelation[i],word,SUBSEP)
			hangingReserved[i]=sprintf("%5s %s %s %s",word[1],array[2],word[2],array[1])
			hangingReservedYes=1
		}
	}
	if (hangingReservedYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs found only in reservedBy list: %s",++z,(hangingReservedYes ? "YES" : "NO")))
		n=asort(hangingReserved)
		for (i=1;i<=n;i++) customPrint(hangingReserved[i])
		customPrint(bline)
	}
	k=0
	for (i=0;i<=maxProxy;i++)
	{
		if (!(i in seqRefCheckList)) continue
		n=split(seqRefCheckList[i],array,",")
		for (j=2;j<=n;j++)
		{
			seqRefCheck[i,array[j],"specified"]+=0
			seqRefCheck[i,array[j],"actual"]+=0
			if (seqRefCheck[i,array[j],"specified"] != seqRefCheck[i,array[j],"actual"]) invalidSeqRef[++k]=sprintf("%5s %s %s: %s, actual: %s",i,p2s("MediumMo",i),array[j],seqRefCheck[i,array[j],"specified"],seqRefCheck[i,array[j],"actual"])
		}
	}
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistent sequence of moRefs in MAO: %s",++z,(k>0 ? "YES" : "NO")))
		for (i=1;i<=k;i++) customPrint(invalidSeqRef[i])
		customPrint(bline)
	}
	if (k>0) result="NOT OK"
	if (nonexistFroRefCount > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) FROs referring to non-existent FROs (CSR1473974): %s",++z,(nonexistFroRefCount > 0 ? "YES" : "NO")))
		for (i=1;i<=nonexistFroRefCount;i++)
		{
			customPrint(nonexistFroRefList[i])
		}
		customPrint(bline)
	}
	if (sqlDuplicateFroTableMax > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Remaining old FRO table versions (HL93894/WRNae89948/HM76376/HS48645/HR63086): %s",++z,(sqlDuplicateFroTableMax > 0 ? "YES" : "NO")))
		for (i=1;i<=sqlDuplicateFroTableMax;i++)
		{
			extra=""
			if (sqlDuplicateFroTable[i] ~ /: (cmarev_r1|ds0bundlefrotable|phy_lp|phy_mspg)$/) extra=" (known issue - no impact)"
			customPrint(sprintf("%6s%s (old)%s","",gensub(/: /," (current): ",1,sqlDuplicateFroTable[i]),extra))
		}
		customPrint(bline)
	}
	if (sqlCorruptedMAOs > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Corrupted MAO entries in modata table: %s",++z,(sqlCorruptedMAOs > 0 ? "YES" : "NO")))
		for (i=1;i<=sqlCorruptedMAOs;i++)
		{
			split(sqlCorruptedMAOTable[i],array,SUBSEP)
			customPrint(sprintf("%5s %s %s",array[1],p2s("MediumMo",array[1]),array[2]))
		}
		customPrint(bline)
	}
	#check for MAOs with missing parents
	for (i in Ldn) MoLdnList[Ldn[i]]=1
	for (i in Ldn)
	{
		tmpparent=gensub(/,[^,]+$/,"",1,Ldn[i])
		if (MoLdnList[tmpparent]!=1)
		{
			tline=sprintf("%5s %s  missingParent: %s",i,p2s("MediumMo",i),gensub(/,[^,]+$/,"",1,p2s("MediumMo",i)))
			parentLineList[tline]=tline
			missingParent=1
			result="NOT OK"
		}
	}
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs without parent: %s",++z,(missingParent > 0 ? "YES" : "NO")))
		n=asort(parentLineList)
		for (i=1;i<=n;i++) customPrint(parentLineList[i])
		customPrint(bline)
	}
	#check for MAOs with invalid froId (empty or not integer)
	for (i in suspectedFroIdTable)
	{
		#print i,Ldn[i],suspectedFroIdTable[i],mibtableMAO[i,"maoClass"],sqlMapFro[mibtableMAO[i,"maoClass"]],sorted_maoattrlist[mibtableMAO[i,"maoClass"]]
		#sometimes the froId attribute in suspectedFroIdTable does not exist at all in the modata table
		#so we check if it is in the sorted_maoattrlist table
		split(sorted_maoattrlist[mibtableMAO[i,"maoClass"]],array,",")
		for (m in array)
		{
			if (array[m]==suspectedFroIdTable[i])
			{
				if (mibtableMAO[i,suspectedFroIdTable[i]] !~ /^-?[0-9]+$/)
				{
					#print i,Ldn[i],suspectedFroIdTable[i],mibtableMAO[i,suspectedFroIdTable[i]]
					tline=sprintf("%5s %s  %s=%s",i,p2s("MediumMo",i),suspectedFroIdTable[i],mibtableMAO[i,suspectedFroIdTable[i]])
					outputLine[tline]=tline
					invalidFroId=1
					result="NOT OK"
				}
				break
			}
		}
	}
	if (silent=="")
	{
		customPrint(sprintf("%3s) MAOs with invalid froId: %s",++z,(invalidFroId > 0 ? "YES" : "NO")))
		n=asort(outputLine)
		for (i=1;i<=n;i++) customPrint(outputLine[i])
		customPrint(bline)
	}
	#check for MOI based scanners containing missing MO instances
	n=asort(corruptedScannerList)
	if (n > 0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Instance-based PM Scanners containing missing MO instances (HR95951/CSR2375943/CSR2375969/ER690205): %s",\
++z,(n > 0 ? "YES" : "NO")))
		for (i=1;i<=n;i++)
		{
			customPrint(sprintf("%5s %s  missing MO instances: %s",corruptedScannerList[i],mibtablePM[corruptedScannerList[i],"name"],missingMOInstancesPM[corruptedScannerList[i]]))
		}
		customPrint(bline)
	}
	#check for too many MO instances in MO instance based PM scanners
	if (silent=="")
	{
		n=asort(heavyScannerList)
		customPrint(sprintf("%3s) Instance-based PM Scanners containing more than 1000 MO instances (HR95951/CSR2375943/CSR2375969/ER690205): %s",\
++z,(tooManyInstancesInPM==1 ? "YES" : "NO")))
		for (i=1;i<=n;i++)
		{
			customPrint(sprintf("%5s %s  number of MO instances: %s",heavyScannerList[i],mibtablePM[heavyScannerList[i],"name"],nrMOInstancesPM[heavyScannerList[i]]))
		}
		customPrint(bline)
	}
	#check for LMs in Jvm::admClassPath that are not in the ConfigurationVersion::currentUpgradePackage
	jvm_admclasspath_check()
	if (jvmFaultyClassPath==1) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Jvm admClassPath containing LoadModules not part of the current UpgradePackage (CSR2447811): %s",++z,(jvmFaultyClassPath==1 ? "YES" : "NO")))
		if (jvmFaultyClassPath==1) customPrint(sprintf("%5s Jvm=1 incorrect LMs in admClassPath: %s",jvmProxy,jvmFaultyLMs))
		customPrint(bline)
	}
	#check to see if there are any missing FRO tables
	k=0
	delete outputLine
	n=asort(modataClassList)
	for (i=1;i<=n;i++)
	{
		moc=modataClassList[i]
		#The SwitchFabric MO only has a FRO table on CPP Classic
		#The MGW MO SignallingProxy does not seem to have a proxy table anymore
		#A number of MOCs in ENB dont seem to have a fro table: EUtraNetwork|Cdma2000Network|UtraNetwork|GeraNetwork|OptionalFeatures|ParameterChangeRequests|RbsConfiguration|SupportSystemConfiguration|SubscriberProfileID
		if (moc~/^(SwitchFabric|SignallingProxy|EUtraNetwork|Cdma2000Network|UtraNetwork|GeraNetwork|OptionalFeatures|ParameterChangeRequests|RbsConfiguration|SupportSystemConfiguration|SubscriberProfileID)$/) continue
		#In L16A the FROs for some Feature MOCs will be removed, the MAO will be there but not the FRO table.
		if (moc in sqlNoFro && sqlNoFro[moc]==1 && sqlFroType[moc]=="") continue

		if (moc in sqlMapTable && sqlMapTable[moc]!~/^(|-)$/)
		{
			if ((moc,"fro") in otherFroTables && otherFroTables[moc,"fro"]!="") continue
			if ((moc,"fro2") in otherFroTables && otherFroTables[moc,"fro2"]!="") continue
			if ((moc,"fro3") in otherFroTables && otherFroTables[moc,"fro3"]!="") continue
			if (sqlMapTable[moc] in sqlMapRealTable && sqlMapRealTable[sqlMapTable[moc]]!="") continue
			#In some SW there are some MOCs that have a FRO while in other SW they dont have a FRO
			if (moc=="EutraNetwork" && sorted_maoattrlist[moc]!~sqlMapFro[moc]) continue #the froId attribute is not part of the attributes of this MAO
			outputLine[++k]=sprintf("%6s%s (%s)","",sqlMapTable[moc],moc)
		}
	}
	if (k>0) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Missing FRO tables: %s",++z,(k > 0 ? "YES" : "NO")))
		for (i=1;i<=k;i++) customPrint(outputLine[i])
		customPrint(bline)
	}


	#From here start the checks which are not common to all nodes and only found in certain node types
	z=100

	#Check for MoRef attributes that are missing the xml field "ldn", only ENB/RBS APC
	if (dbcLdnFieldCheck==1)
	{
		if (dbcLdnFieldCheckFail==1) result="NOT OK"
		if (silent=="")
		{
			customPrint(sprintf("%3s) FRO attributes containing the froId field but not the ldn field (HR88263): %s",++z,(dbcLdnFieldCheckFail==1 ? "YES" : "NO")))
			n=asort(dbcLdnFieldMoTable)
			for (i=1;i<=n;i++)
			{
				customPrint(sprintf("%5s %s %s",dbcLdnFieldMoTable[i],p2s("MediumMo",dbcLdnFieldMoTable[i]),dbcLdnFieldAttrTable[dbcLdnFieldMoTable[i]]))
			}
			customPrint(bline)
		}
	}

	if (dopccheck==1)
	{
		#Check if some Mtp3bSp have OPC equal to the DPC of a Mtp3bSrs, except in the case where
		#Mtp3bSp has attribute m3uaproductnumber=2 (ietf) && nodebehaviour=0 (sep) && has no Mtp3bAp children
		#According to the MOM:
		#Mtp3bSrs                  destPointCode                          long                                               restricted,noNotification,mandatory
		#The Destination Point Code in a Route Set has to be unique within each Signaling Point.
		#In SS7 and E-SIGTRAN configurations, a route set must not have DPC equal to the local point code.
		#In an IETF M3UA configuration, a DPC can be equal to the local point code, if the DPC represents a destination reachable via the IP network.
		#This is a normal casefor Associated Signalling Mode in SGW function (ASM), where an SGW and ASP are configured with equal point codes.
		#Such a configuration is allowed only if the parent Mtp3bSp has SEP node behavior, to avoid unexpected traffic losses.
		#Such a route set cannot be used for MTP3 traffic. That is, it cannot have routes and it cannot be reserved by Mtp3bAp MOs.
		for (i in opcList)
		{
			if (i in dpcList)
			{
				#if the Mtp3bSp has attribute m3uaproductnumber=2 (ietf) && nodebehaviour=0 (sep) && has no Mtp3bAp children, we skip
				#note: m3uaproductnumber=1 (sigtran)
				split(i,array,SUBSEP)
				t_prox=s2p(array[1])
				if (mibtableFRO[t_prox,"m3uaproductnumber"]==2 && mibtableFRO[t_prox,"nodebehaviour"]==0)
				{
					ok=1
					for (j in MoProxy)
					{
						if (s2t(j)=="Mtp3bAp" && gensub(/,Mtp3bAp=.*$/,"",1,j)==array[1]) ok=0  #the SP has Mtp3bAp children so it should be checked
					}
					if (ok==1) continue  #we dont include this SP in the faulty list
				}
				pointCodeCollision[i]=i
				pointCodeCollisionYes=1
			}
		}
		if (pointCodeCollisionYes) result="NOT OK"
		if (silent=="")
		{
			customPrint(sprintf("%3s) MTP3 pointCode collision (WRNae82362, SCS695737): %s",++z,(pointCodeCollisionYes ? "YES" : "NO")))
			n=asort(pointCodeCollision)
			for (i=1;i<=n;i++)
			{
				split(pointCodeCollision[i],array,SUBSEP)
				customPrint(sprintf("Point code %s used by %s and %s",array[2],p2s("MediumMo",opcList[pointCodeCollision[i]]),p2s("MediumMo",dpcList[pointCodeCollision[i]])))
			}
			customPrint(bline)
		}
	}
	for (i=0;i<=maxProxy;i++)
	{
		if (p2s("MoType",i)!="Subrack") continue
		curr_sr=p2s("Mo",i)
		nr_fans=0
		fanconf=mibtableMAO[s2p(mibtableMAO[i,"subrackProdTypeRef"]),"fanConfiguration"]
		if (fanconf ~ /^[23]$/)
		{
			dbcFanCheck=1
			nr_denib=mibtableFRO[i,"nrofdenibdevices"]
			for (j=0;j<=maxProxy;j++) if (Ldn[j] ~ sprintf("%s,Fan=[^,]+$",curr_sr)) nr_fans++
			#print curr_sr,nr_fans,fanconf,nr_denib
			if (nr_denib=="-1") nr_denib=fanconf-1   #the attribute fanConfiguration is a enum: 2 means 1 fan, 3 means 2 fans
			if (nr_fans != nr_denib)
			{
				fanCorruptionLine[++fanCorruption]=sprintf("%5s %s nrOfFans: %s nr_denib: %s",i,curr_sr,nr_fans,nr_denib)
				result="NOT OK"
			}
		}
	}
	if ((dbcFanCheck==1 || mom_version ~ /^RNC_NODE_MODEL/) && silent=="")
	{
		customPrint(sprintf("%3s) Number of Fans mismatch (CSR 2101402/HQ64197): %s",++z,(fanCorruption>0 ? "YES" : "NO")))
		for (i=1;i<=fanCorruption;i++) customPrint(fanCorruptionLine[i])
		customPrint(bline)
	}

	if (mom_version !~ "RNC")
	{
		if (nomo==0)
		{
			if (silent=="") customPrint("\nConclusion: the database is "result)
			else customPrint("\n\nThe database is "result"\nTo print the consistency check result, type \"dbc\".\nTo print the list of available commands, type \"h\".")
			#customPrint("\n\n")
		}
		return
	}
	k=0
	for (i=1;i<=maxProxy;i++)
	{
		if (p2s("MoType",i)=="GsmRelation")
		{
			pcell=s2p(gensub(/,GsmRelation=.*$/,"",1,p2s("Mo",i)))
			if (mibtableFRO[i,"mobilityrelationtype"]==0) cellcntrtable[pcell,"gsmRelHoAndCellReselCntr"]++
			continue
		}
		if (p2s("MoType",i)!="UtranRelation") continue
		if (mibtableMAO[i,"utranCellRef"] ~ "ExternalUtranCell=") relationdata[i,"noderelationtype"]=1
		else if (mibtableMAO[i,"utranCellRef"] ~ "RemoteUtranCell=") relationdata[i,"noderelationtype"]=2
		else if (mibtableMAO[i,"utranCellRef"] ~ "UtranCell=") relationdata[i,"noderelationtype"]=0
		else relationdata[i,"noderelationtype"]="?"
		pcell=s2p(gensub(/,UtranRelation=.*$/,"",1,p2s("Mo",i)))
		f1d=mibtableFRO[pcell,"uarfcndl"]
		f2d=mibtableFRO[s2p(mibtableMAO[i,"utranCellRef"]),"uarfcndl"]
		f1u=mibtableFRO[pcell,"uarfcnul"]
		f2u=mibtableFRO[s2p(mibtableMAO[i,"utranCellRef"]),"uarfcnul"]
		if (f1d=="" || f2d=="" || f1u=="" || f2u=="") relationdata[i,"frequencyrelationtype"]="?"
		else if ((f1d == f2d) && (f1u == f2u))
		{
			relationdata[i,"frequencyrelationtype"]=0
			cellcntrtable[pcell,"intraFreqRelCntr","bycellarfcn"]++
		}
		else
		{
			relationdata[i,"frequencyrelationtype"]=1
			cellcntrtable[pcell,"interFreqRelCntr","bycellarfcn"]++
		}
		if (mibtableFRO[i,"frequencyrelationtype"]==0)
		{
			cellcntrtable[pcell,"intraFreqRelCntr","byrelattr"]++
		}
		else
		{
			cellcntrtable[pcell,"interFreqRelCntr","byrelattr"]++
			if (mibtableFRO[i,"frequencyrelationtype"]==1)
			{
				if (mibtableFRO[i,"mobilityrelationtype"]~/^(0|2)$/) cellcntrtable[pcell,"cellReselectionCntr"]++
				if (mibtableFRO[i,"mobilityrelationtype"]~/^(0|1)$/) cellcntrtable[pcell,"handoverOnlyCntr"]++
			}
		}
		if (relationdata[i,"frequencyrelationtype"] != mibtableFRO[i,"frequencyrelationtype"])
		{
			relMismatchYes=1
			relMismatchTable[++k]=sprintf("%5s %s frequencyRelationType: %s, actual: %s (%s)",\
				i,p2s("MediumMo",i),mibtableFRO[i,"frequencyrelationtype"],relationdata[i,"frequencyrelationtype"],\
				(relationdata[i,"frequencyrelationtype"]==0?"f1d=f2d="f1d", f1u=f2u="f1u:(f1d!=f2d?"f1d="f1d", f2d="f2d:"f1u="f1u", f2u="f2u)))
		}
		if (relationdata[i,"noderelationtype"] != mibtableFRO[i,"noderelationtype"])
		{
			relMismatchYes=1
			relMismatchTable[++k]=sprintf("%5s %s nodeRelationType: %s, actual: %s (cellRef:%s)",\
				i,p2s("MediumMo",i),mibtableFRO[i,"noderelationtype"],relationdata[i,"noderelationtype"],gensub(/^.*,/,"",1,mibtableMAO[i,"utranCellRef"]))
		}
	}
	if (relMismatchYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistency in UtranRelation nodeRelationType or frequencyRelationType (HP94489/WRNae68940/WRNae72810): %s",++z,(relMismatchYes ? "YES" : "NO")))
		for (i=1;i<=k;i++) customPrint(relMismatchTable[i])
		customPrint(bline)
	}
	k=0
	g=c=h=0
	for (i=1;i<=maxProxy;i++)
	{
		if (p2s("MoType",i)!="UtranCell") continue
		#interFreqRelCntr/intraFreqRelCntr/gsmRelHoAndCellReselCntr do not exist in later RNC SW so they can have an empty value
		intracntr=mibtableMAO[i,"intraFreqRelCntr"]
		intercntr=mibtableMAO[i,"interFreqRelCntr"]
		gsmRelHoAndCellReselCntr=mibtableMAO[i,"gsmRelHoAndCellReselCntr"]
		#cellReselectionCntr and handoverOnlyCntr only exist in later RNC SW so it can have a empty value
		cellReselectionCntr=mibtableMAO[i,"cellReselectionCntr"]
		handoverOnlyCntr=mibtableMAO[i,"handoverOnlyCntr"]
		if (intracntr !="" && intracntr != (cellcntrtable[i,"intraFreqRelCntr","byrelattr"]+0))
		{
			cntrMismatchYes=1
			cntrMismatchTable[++k]=sprintf("%5s %s intraFreqRelCntr: %2s, actual: %2s (by frequencyRelationType%s)",i,p2s("MediumMo",i),intracntr,cellcntrtable[i,"intraFreqRelCntr","byrelattr"]+0,(intracntr != cellcntrtable[i,"intraFreqRelCntr","bycellarfcn"]?" and uarfcnDl":""))
		}
		else if (intracntr !="" && intracntr != (cellcntrtable[i,"intraFreqRelCntr","bycellarfcn"]+0))
		{
			cntrMismatchYes=1
			cntrMismatchTable[++k]=sprintf("%5s %s intraFreqRelCntr: %2s, actual: %2s (by uarfcnDl)",i,p2s("MediumMo",i),intracntr,cellcntrtable[i,"intraFreqRelCntr","bycellarfcn"]+0)
		}
		if (intercntr != "" && intercntr != (cellcntrtable[i,"interFreqRelCntr","byrelattr"]+0))
		{
			cntrMismatchYes=1
			cntrMismatchTable[++k]=sprintf("%5s %s interFreqRelCntr: %2s, actual: %2s (by frequencyRelationType%s)",i,p2s("MediumMo",i),intercntr,cellcntrtable[i,"interFreqRelCntr","byrelattr"]+0,(intercntr != cellcntrtable[i,"interFreqRelCntr","bycellarfcn"]?" and uarfcnDl":""))
		}
		else if (intercntr != "" && intercntr != (cellcntrtable[i,"interFreqRelCntr","bycellarfcn"]+0))
		{
			cntrMismatchYes=1
			cntrMismatchTable[++k]=sprintf("%5s %s interFreqRelCntr: %2s, actual: %2s (by uarfcnDl)",i,p2s("MediumMo",i),intercntr,cellcntrtable[i,"interFreqRelCntr","bycellarfcn"]+0)
		}
		if (gsmRelHoAndCellReselCntr!="" && gsmRelHoAndCellReselCntr!=(cellcntrtable[i,"gsmRelHoAndCellReselCntr"]+0))
		{
			gsmRelHoAndCellReselCntrMismatchYes=1
			gsmRelHoAndCellReselCntrMismatchTable[++g]=sprintf("%5s %s gsmRelHoAndCellReselCntr: %2s, actual: %2s",i,p2s("MediumMo",i),gsmRelHoAndCellReselCntr,cellcntrtable[i,"gsmRelHoAndCellReselCntr"]+0)
		}
		if (cellReselectionCntr!~/^(|-1)$/ && cellReselectionCntr!=(cellcntrtable[i,"cellReselectionCntr"]+0))
		{
			cellReselectionCntrMismatchYes=1
			cellReselectionCntrMismatchTable[++c]=sprintf("%5s %s cellReselectionCntr: %2s, actual: %2s",i,p2s("MediumMo",i),cellReselectionCntr,cellcntrtable[i,"cellReselectionCntr"]+0)
		}
		if (handoverOnlyCntr!~/^(|-1)$/ && handoverOnlyCntr!=(cellcntrtable[i,"handoverOnlyCntr"]+0))
		{
			handoverOnlyCntrMismatchYes=1
			handoverOnlyCntrMismatchTable[++h]=sprintf("%5s %s handoverOnlyCntr: %2s, actual: %2s",i,p2s("MediumMo",i),handoverOnlyCntr,cellcntrtable[i,"handoverOnlyCntr"]+0)
		}
	}
	if (cntrMismatchYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistency in UtranCell interFreqRelCntr or intraFreqRelCntr (HP94489/WRNae68940/WRNae72810): %s",++z,(cntrMismatchYes ? "YES" : "NO")))
		for (i=1;i<=k;i++) customPrint(cntrMismatchTable[i])
		customPrint(bline)
	}
	k=0

	#Inconsistency in RncFunction:cellRelCntr  -> this attribute does not exist in later RNC SW and can be empty
	nrOfRels=nrOfMoTypes["coveragerelation"]+nrOfMoTypes["eutranfreqrelation"]+nrOfMoTypes["utranrelation"]+nrOfMoTypes["gsmrelation"]
	nrOfRncRels=mibtableMAO[s2p("ManagedElement=1,RncFunction=1"),"cellRelCntr"]
	if (nrOfRncRels!="" && nrOfRels!=nrOfRncRels) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistency in RncFunction cellRelCntr (HT37388): %s",++z,(nrOfRncRels!="" && nrOfRels!=nrOfRncRels ? "YES" : "NO")))
		if (nrOfRncRels!="" && nrOfRels!=nrOfRncRels) customPrint(sprintf("RncFunction=1 cellRelCntr=%d, nrOfRelations=%d \
(%d CoverageRelation, %d EutranFreqRelation, %d GsmRelation, %d UtranRelation)",\
nrOfRncRels,nrOfRels,nrOfMoTypes["coveragerelation"],nrOfMoTypes["eutranfreqrelation"],nrOfMoTypes["gsmrelation"],nrOfMoTypes["utranrelation"]))
		customPrint(bline)
	}

	if (gsmRelHoAndCellReselCntrMismatchYes) result="NOT OK"
	if (silent=="")
	{
		customPrint(sprintf("%3s) Inconsistency in UtranCell gsmRelHoAndCellReselCntr: %s",++z,(gsmRelHoAndCellReselCntrMismatchYes ? "YES" : "NO")))
		for (i=1;i<=g;i++) customPrint(gsmRelHoAndCellReselCntrMismatchTable[i])
		customPrint(bline)
	}

	if (upadmdata ~ /^CXP9021776/ && upadmdata !~ /^CXP9021776\/[1-3]_/)
	{
		if (cellReselectionCntrMismatchYes) result="NOT OK"
		if (silent=="")
		{
			customPrint(sprintf("%3s) Inconsistency in UtranCell cellReselectionCntr: %s",++z,(cellReselectionCntrMismatchYes ? "YES" : "NO")))
			for (i=1;i<=c;i++) customPrint(cellReselectionCntrMismatchTable[i])
			customPrint(bline)
		}

		if (handoverOnlyCntrMismatchYes) result="NOT OK"
		if (silent=="")
		{
			customPrint(sprintf("%3s) Inconsistency in UtranCell handoverOnlyCntr: %s",++z,(handoverOnlyCntrMismatchYes ? "YES" : "NO")))
			for (i=1;i<=h;i++) customPrint(handoverOnlyCntrMismatchTable[i])
			customPrint(bline)
		}
	}
	g=c=h=0

	if (nomo==0)
	{
		if (silent=="") customPrint("\nConclusion: the database is "result)
		else customPrint("\n\nThe database is "result"\nTo print the consistency check result, type \"dbc\".\nTo print the list of available commands, type \"h\".")
	}
}
function jvm_admclasspath_check(   array,i,jvmClassList,currUpProxy,cvProxy,upLMList,upLMListValid,currUpMO)
{
	if (jvmClassPathCheckDone==1) return
	jvmFaultyClassPath=0  #global
	jvmFaultyLMs=""       #global
	jvmClassPathCheckDone=1  #global
	upLMListValid=0          #local
	jvmProxy=giveMoProxy("Equipment=1,Jvm=1")   #global
	cvProxy=giveMoProxy("SwManagement=1,ConfigurationVersion=1")  #local
	currUpMO=mibtableMAO[cvProxy,"currentUpgradePackage"]         #local
	currUpProxy=giveMoProxy("SwManagement=1,"currUpMO)            #local
	#debug:
	#print jvmProxy,Ldn[jvmProxy]
	#print cvProxy,Ldn[cvProxy]
	#print currUpMO
	#print currUpProxy,Ldn[currUpProxy]
	split(mibtableMAO[jvmProxy,"admClasspath"],array,"\n")
	for (i in array)
	{
		sub(/^.*SwManagement=1,/,"",array[i])
		if (array[i] ~ /LoadModule=/) jvmClassList[array[i]]=array[i]  #local
	}
	if (p2s("MoType",currUpProxy)!="UpgradePackage") return  #there is no current UpgradePackage, eg it is a empty CV
	split(mibtableMAO[currUpProxy,"loadModuleList"],array,"\n")
	for (i in array)
	{
		sub(/^.*SwManagement=1,/,"",array[i])
		if (array[i] ~ /LoadModule=/)
		{
			upLMListValid=1
			upLMList[array[i]]=array[i]  #local
		}
	}
	if (upLMListValid==0) return  #there were no LMs found in UpgradePackage::loadModuleList, maybe this is a basic package with no UP associated
	for (i in jvmClassList)
	{
		if (i ~ /LoadModule=CXC1729990_/) continue #TR HS47647
		if (upLMList[i] != i)
		{
			jvmFaultyLMs=jvmFaultyLMs" "gensub(/^.*LoadModule=/,"",1,i)
			jvmFaultyClassPath=1
		}
	}
}

function Load_dbdat(file,   pscom,array,busyports,i,killports,filecmd,nounzip,n,filepath,cpcom,rtstart,filecmd2)
{
	#check if this is a CPP linux db.dat
	filecmd="file "file
	while (filecmd |& getline)
	{
		#uncompressed CPP Linux db.dat wll give:  db.dat: PostgreSQL custom database dump - v1.12-0
		#on solaris or older linux versions, the "file" command may show "ascii text" or "text" or "data" for a PostgreSQL db.dat
		if ($0 ~ /PostgreSQL| text/) cpplinux=1
	}
	close(filecmd)
	if (cpplinux==0)
	{
		#the file command gave output like "data", then we cannot be fully sure if this is a CPP linux or CPP OSE db.dat , depending on the version of the "file" utility and associated magic file
		filecmd2="strings "file" | head -1"
		while (filecmd2 |& getline)
		{
			if ($0 ~ /PGDMP/) cpplinux=1
		}
		close(filecomd2)
	}
	if (cpplinux==1) return Load_dbdat_postgres(file)
	if (fetch_sqlc_from_utran01()!=0) exit_with_error()
	#on solaris the ps command only returns the first 80 characters so the rtrdb path should not be longer than 60 characters if we want to detect the port in existing sessions
	if (os ~ /^sun/ && length(rtrdb) >= 60)
	{
		customPrint("Error: the path of rtrdb may not be longer than 60 characters, please install moshell in another directory higher up in the directory tree.")
		exit_with_error()
	}
	#we don't replace spaces by @ sign in SQL mode
	mospace_convert=0
	#check if the db.dat file is already ungzipped
	while (filecmd |& getline)
	{
		#uncompressed polyhedra db.dat will give: db.dat: data
		#compressed polyhedra db.dat will give:   db.dat: gzip compressed data, was "db.dat", from Unix, last modified: Thu Mar  4 03:51:41 2010
		if (/:[ \t]+data/) nounzip=1
	}
	close(filecmd)
	#first put the file in the tempdir in case it was not already there
	filename=gensub(/^.*\//,"",1,file)
	filepath=gensub(/\/[^/]+$/,"",1,file)
	if (filepath != tempdir)
	{
		#if we write cpcom=sprintf("cp "file" "tempdir"/"filename) it can crash when special characters like % appear
		cpcom=sprintf("cp %s %s/%s",file,tempdir,filename)
		if (mosdebug==1) print cpcom
		if (system(cpcom)!=0) return 99
		file=tempdir"/"filename
	}
	#if it is not already ungzipped we ungzip it
	if (nounzip != 1)
	{
		if (fileOps("mv "file" "file".gz")!=0) return 99
		if (system("gzip -d "file".gz")!=0) return 99
	}
	rt_start=systime()
	while (rtrdb_pid !~ /^[0-9]+$/)
	{
		start_rtrdb(file)
		if ((rtrdb_pid !~ /^[0-9]+$/) && ((systime() - rt_start) > 60)) exit_with_error() #give up after 60 seconds
	}
	if (buildmotypeTable("silent") != 0)
	{
		customPrint("Invalid db.dat file, motype_r1 table not found. Exiting...")
		exit_with_error()
	}
	if (nomo==0)
	{
		build_dbdat_motables()
		make_testclassgroup()
		read_scannerdata()
	}
	if (mosdebug==1)
	{
		n=asort(unusedMao)
		print "MO classes not specified in the sqlMap.txt file:"
		for (i=1;i<=n;i++) print unusedMao[i]
	}
}
function start_rtrdb(file,          pscom,array,busyports,i,killports,filecmd,nounzip,n,filepath,cpcom,delay,cygwport,res,maxIndex,nr,j,thepid)
{
	setUID()
	if (os=="cygwin")
	{
		file=make_cygpath(file)
		pscom="ps -f"
	}
	else pscom="ps -e -o user,pid,stime,args"
	while (pscom |& getline)
	{
		#solaris/linux:
		#eanzmagn 10691 03:49 /home/eanzmagn/moshell/commonjars/rtrdb -rdata_service=8003 -r load_file=/home/eanzmagn/CPPOLY/dbcpp8.dat DB
		#eanzmagn 10691 Feb16 /home/eanzmagn/moshell/commonjars/rtrdb -rdata_service=8003 -r load_file=/home/eanzmagn/CPPOLY/dbcpp8.dat DB
		#eanzmagn 25709 07:31 /home/eanzmagn/moshell/commonjars/rtrdb.linux -rdata_service=8001 -r load_file=CPPOLY/dbcpp7.dat -r suppress_dvi=true -r suppress_log=true -r type=rtrdb DB
		#cygwin:
		#eanzmagn    2576    1908   3  17:08:07 /home/eanzmagn/tools/moshell/jarxml/rtrdb83
		if (os=="cygwin")
		{
			#do nothing on cygwin
			#if ($1==ENVIRON["USER"] && $NF ~ /\/rtrdb/) killports[$2]=$2 #only one rtrdb allowed per user on cygwin
		}
		else if (/\/rtrdb(\.[^ ]+)? -rdata_service=[0-9][0-9][0-9][0-9]/)
		{
			match($0,/-rdata_service=([0-9][0-9][0-9][0-9][0-9]?)/,array)
			#if the rtrdb has been running for more than 24 hrs, kill it
			if ($3 ~ /^[A-Z]/ && ($1==ENVIRON["USER"] || $1==ENVIRON["UID"])) killports[array[1]]=$2
			else busyports[array[1]]=1
		}
	}
	close(pscom)
	for (i in killports)
	{
		if (i < sql_port) continue
		if (os=="cygwin")
		{
			customPrint("Closing down old rtrdb session on port "i)
			system("kill -9 "i)
		}
		else
		{
			customPrint("Closing down old rtrdb session on port "i"... ","","","noLF")
			#old method , sometimes hangs
			#res=run_sql_command("shutdown;",i,(mosdebug==1?"":"silent"),"","","","nocheck")
			#if (res == 0) customPrint("OK")
			#else { customPrint("Failed") ; busyports[i]=1 }
			thepid=killports[i]
			system("kill "thepid)
			mysleep(2)
			if (is_process_there(thepid)==0)
			{
				system("kill -9 "thepid)
				mysleep(2)
			}
			if (is_process_there(thepid)==0) customPrint("Failed")
			else customPrint("OK")
		}
	}
	delete sqlPortList
	for (i=sql_port;i<=(sql_port+sql_range);i++) sqlPortList[++maxIndex]=i
	if (sql_random>=1)
	{
		shuffleTable(sqlPortList)
		if (sql_random==1) match(gawk_pid,/([0-9])$/,nr)
		else if (sql_random==2) match(gawk_pid,/([0-9]?[0-9])$/,nr)
		else if (sql_random==3)  match(gawk_pid,/([0-9]?[0-9]?[0-9])$/,nr)
		for (j=1;j<=nr[1];j++) shuffleTable(sqlPortList)
	}
	#for (i=1;i<=maxIndex;i++) printf("%-4s %s\n", i,sqlPortList[i])
	#print gawk_pid,nr[1]
	for (i=1;i<=maxIndex;i++)
	{
		if (sqlPortList[i] in busyports) continue
		sqlport=sqlPortList[i]
		break
	}
	chmod(00777,rtrdb) ; chmod(00777,sqlc)
	customPrint("Starting Polyhedra SQL server on port "sqlport"...","","","noLF")
	rtrdbcom=sprintf("%s -rdata_service=%s -r load_file=%s -r suppress_dvi=true -r suppress_log=true -r type=%s DB",rtrdb,sqlport,file,(polyversion>0?"polyview":"rtrdb"))
	if (mosdebug==1) print rtrdbcom
	while (rtrdbcom |& getline)
	{
		gsub("\r","")
		if (mosdebug==1) print
		else if (polyversion>0 && tolower($0) ~ /error:/) customPrint($0)  #polyversion=0 gives errors but starts anyway
		if ($1=="Ready") break
	}
	if ($1!="Ready")
	{
		customPrint("Failed")
		exit_with_error()
	}
	#wait 2 seconds to make sure that the rtrdb server has correctly started - if the port was already taken we'd get error message and exit: "TCP transport: unable to bind '8001': 98"
	mysleep(2)
	#now double-check that we have a child rtrdb process
	rtrdb_pid=find_javaprocess(gawk_pid,"rtrdb")
	if (rtrdb_pid ~ /^[0-9]+$/)
	{
		rtrdbStarted=1
		customPrint(" OK")
		if (mosdebug==1) print "$rtrdb_pid = "rtrdb_pid
	}
	else
	{
		#delay=sprintf("%0.f",rand()*10)
		delay=10
		customPrint("Failed. Retrying in "delay" seconds ...")
		mysleep(delay)
		#exit_with_error()
	}
}
function Load_dbdat_postgres(file,   pscom,array,busyports,i,killports,filecmd,nounzip,n,filepath,cpcom,rtstart)
{
	if (find_postgres()!=0) exit_with_error()
	gsub(/[/]+$/,"",psqldir)
	psql_port=sql_port+sql_range+1
	postg=psqldir"/postgres"
	initdb=psqldir"/initdb"
	pg_restore=psqldir"/pg_restore"
	pg_ctl=psqldir"/pg_ctl"
	psql=psqldir"/psql"
	if (os=="cygwin") psql="/usr/bin/psql"
	psqldb=tempdir"/psqldb"
	#on solaris the ps command only returns the first 80 characters so the postgres path should not be longer than 60 characters if we want to detect the port in existing sessions
	#if (os ~ /^sun/ && length(postg) >= 60)
	#{
	#	customPrint("Error: the path of postgres may not be longer than 60 characters, please install moshell in another directory higher up in the directory tree.")
	#	exit_with_error()
	#}
	#we don't replace spaces by @ sign in SQL mode
	mospace_convert=0
	#first put the file in the tempdir in case it was not already there
	filename=gensub(/^.*\//,"",1,file)
	filepath=gensub(/\/[^/]+$/,"",1,file)
	if (filepath != tempdir)
	{
		#if we write cpcom=sprintf("cp "file" "tempdir"/"filename) it can crash when special characters like % appear
		cpcom=sprintf("cp %s %s/%s",file,tempdir,filename)
		if (mosdebug==1) print cpcom
		if (system(cpcom)!=0) return 99
		file=tempdir"/"filename
	}
	rt_start=systime()
	while (postgres_pid !~ /^[0-9]+$/)
	{
		start_postgres(file)
		if ((postgres_pid !~ /^[0-9]+$/) && ((systime() - rt_start) > 60)) exit_with_error() #give up after 60 seconds
	}
	if (buildmotypeTable("silent") != 0)
	{
		customPrint("Invalid db.dat file, motype_r1 table not found. Exiting...")
		exit_with_error()
	}
	if (nomo==0)
	{
		build_dbdat_motables()
		make_testclassgroup()
		read_scannerdata()
	}
	if (mosdebug==1)
	{
		n=asort(unusedMao)
		print "MO classes not specified in the sqlMap.txt file:"
		for (i=1;i<=n;i++) print unusedMao[i]
	}
}
function find_postgres(    res,whichcmd,modulecmd)
{
	#postgres is an optional uv where the user can set the path to postgres
	#postg is an internal global variable that has the path to postgres
	if (psqldir!="") return 0
	if (os=="cygwin" && postgres=="") postgres="/usr/sbin/postgres"
	if (postgres!="")
	{
		if (fileOps("test -s "postgres)==0)
		{
			psqldir=gensub(/[^/]+$/,"",1,postgres)
			return 0
		}
	}
	whichcmd="which postgres 2>/dev/null"
	while (whichcmd |& getline)
	{
		#/app/vbuild/RHEL6-x86_64/postgresql/9.3.4/bin/postgres
		if ($1~/^\/.*postgres/) psqldir=gensub(/[^/]+$/,"",1,$1)
	}
	close(whichcmd)
	if (psqldir!="") return 0
	if (AfsAccess==1)
	{
		modulecmd="tcsh -c 'module add postgresql && which postgres' 2>&1"
		while (modulecmd |& getline)
		{
			if (mosdebug==1) print
			if ($1~/^\/.*postgres/) psqldir=gensub(/[^/]+$/,"",1,$1)
		}
		close(modulecmd)
		if (psqldir!="") return 0
	}
	customPrint("Unable to find the location of postgres.")
	customPrint("Please specify the path of postgres in the uservariable \"postgres\".")
	return 1
}
function find_curl(    res,modulecmd)
{
	if (os=="linux")
	{
		if (linarch=="64") return "LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:"moshelldir"/commonjars/lib/linux "moscurl
		return moscurl
	}
	else if (os=="cygwin")
	{
		if (fileOps("test -s /usr/bin/curl")==0) return "/usr/bin/curl"
		customPrint("\nPlease install curl first:")
		customPrint(" - close all cygwin sessions.")
		customPrint(" - rerun the cygwin setup-x86.exe from www.cygwin.com")
		customPrint(" - at the \"select packages\" window, select Net/curl.")
	}
	return ""
}
function start_postgres(file,          pscom,array,busyports,i,killports,filecmd,nounzip,n,filepath,cpcom,delay,cygwport,res,maxIndex,nr,j,initcmd,ibuffer,iok,postgcmd,gok,gbuffer,pgrcmd,pbuffer,thepid)
{
	setUID()
	if (os=="cygwin")
	{
		if (cpplinux==0) file=make_cygpath(file)
		pscom="ps -f"
	}
	else pscom="ps -e -o user,pid,stime,args"
	while (pscom |& getline)
	{
		#solaris/linux: when the username has more than 8 letters then it shows the UID instead
		#eanzmagn 28640 02:32 /app/vbuild/RHEL6-x86_64/postgresql/9.3.4/bin/postgres -p 9001 -D /tmp/psqldb
		#122261    2894 Dec23 /app/vbuild/SLED11-x86_64/postgresql/9.3.4/bin/postgres -p 9423 -D /home/edailytest/moshell_logfiles/logs_moshell/tempfiles/20151223-153434_26204/psqldb
		#cygwin:
		#eanzmagn    2576    1908   3  17:08:07 /usr/bin/postgres
		if (os=="cygwin")
		{
			#do nothing
			#if ($NF ~ /\/postgres/) killports[$2]=1 #only one postgres allowed on cygwin
		}
		else if (/\/postgres(\.[^ ]+)? -p [0-9][0-9][0-9][0-9][0-9]?/)
		{
			match($0,/ -p ([0-9][0-9][0-9][0-9][0-9]?)/,array)
			#if the postgres has been running for more than 24 hrs, kill it
			if ($3 ~ /^[A-Z]/ && ($1==ENVIRON["USER"] || $1==ENVIRON["UID"])) killports[array[1]]=$2
			else busyports[array[1]]=1
		}
	}
	close(pscom)
	for (i in killports)
	{
		if (i < psql_port) continue
		thepid=killports[i]
		customPrint("Closing down old postgres session on port "i"... ","","","noLF")
		system("kill "thepid)
		mysleep(2)
		if (is_process_there(thepid)==0)
		{
			system("kill -9 "thepid)
			mysleep(2)
		}
		if (is_process_there(thepid)==0) customPrint("Failed")
		else customPrint("OK")
	}
	delete sqlPortList
	for (i=psql_port;i<=(psql_port+sql_range);i++) sqlPortList[++maxIndex]=i
	if (sql_random>=1)
	{
		shuffleTable(sqlPortList)
		if (sql_random==1) match(gawk_pid,/([0-9])$/,nr)
		else if (sql_random==2) match(gawk_pid,/([0-9]?[0-9])$/,nr)
		else if (sql_random==3)  match(gawk_pid,/([0-9]?[0-9]?[0-9])$/,nr)
		for (j=1;j<=nr[1];j++) shuffleTable(sqlPortList)
	}
	#for (i=1;i<=maxIndex;i++) printf("%-4s %s\n", i,sqlPortList[i])
	#print gawk_pid,nr[1]
	for (i=1;i<=maxIndex;i++)
	{
		if (sqlPortList[i] in busyports) continue
		sqlport=sqlPortList[i]
		break
	}
	customPrint("Starting PostgreSQL server on port "sqlport"...","","","noLF")
	system("rm -rf "psqldb)
	initcmd=initdb" -U postgres -A trust "psqldb" 2>&1"
	if (mosdebug==1) print "DEBUG: "initcmd
	while (initcmd |& getline)
	{
		ibuffer=ibuffer"\n"$0
		if (/^Success/) iok=1
	}
	close(initcmd)
	if (iok!=1)
	{
		customPrint("Failed")
		customPrint(ibuffer)
		if (os=="cygwin") customPrint("\nINFO: Make sure to start the cygserver https://cygwin.com/cygwin-ug-net/using-cygserver.html#start-cygserver")
		exit_with_error()
	}
	postgcmd=postg" -p "sqlport" -D "psqldb" -c logging_collector=false 2>&1"
	if (mosdebug==1) print postgcmd
	while (postgcmd |& getline)
	{
		gsub("\r","")
		#if (mosdebug==1) print
		gbuffer=gbuffer"\n"$0
		if (/database system is ready/)
		{
			gok=1
			break
		}
	}
	if (gok!=1)
	{
		customPrint("Failed")
		customPrint(gbuffer)
		exit_with_error()
	}
	mysleep(1)
	#now double-check that we have a child rtrdb process
	postgres_pid=find_javaprocess(gawk_pid,"postgres")
	if (postgres_pid ~ /^[0-9]+$/)
	{
		pgrcmd=pg_restore" -U postgres --no-owner --disable-triggers --no-privileges -d postgres -p "sqlport" --no-security-labels "file" 2>&1"
		if (mosdebug==1) print pgrcmd
		while (pgrcmd |& getline)
		{
			gsub("\r","")
			pbuffer=pbuffer"\n"$0
		}
		close(pgrcmd)
		if (ENVIRON["?"]!=0)
		{
			customPrint("Failed")
			customPrint(pbuffer)
			exit_with_error()
		}
		postgresStarted=1
		customPrint(" OK")
		if (mosdebug==1) print "$postgres_pid = "postgres_pid
	}
	else
	{
		#delay=sprintf("%0.f",rand()*10)
		delay=10
		customPrint("Failed. Retrying in "delay" seconds ...")
		mysleep(delay)
		#exit_with_error()
	}
}
function sshd_function(what)
{
	if (what=="+") start_sshd("print")
	else if (what=="-") stop_sshd("print")
	else if (what=="?") status_sshd()
	else customPrint("Syntax: sshd [start|stop]")
}
function status_sshd()
{
	if (export_method>=1) return 0
	customPrint("")
	if (sshdStarted==1 && is_process_there(sshd_pid)==0) customPrint(sprintf("sshd started with pid %d on port %d",sshd_pid,sshdport))
	else customPrint("sshd not started")
}

function start_sshd(what,theserverport,          pscom,array,busyports,i,killports,filecmd,nounzip,n,filepath,cpcom,delay,cygwport,res,maxIndex,nr,j,sshd_errors,sshdpidfile,line,sshd_pid2,f)
{
	if (export_method>=1)
	{
		if (theserverport=="") theserverport=22
		sshdport=theserverport
		return 0
	}
	res=1
#	if (os=="cygwin") pscom="ps -f"
#	else pscom="ps -e -o pid,stime,args"
#	while (pscom |& getline)
#	{
#		#solaris/linux:
#		#10691 03:49 /home/eanzmagn/moshell/commonjars/sshd.solaris -oport=11234  ...
#		#10691 Feb16 /home/eanzmagn/moshell/commonjars/sshd.solaris -oport=11234  ...
#		#cygwin:
#		#eanzmagn    6756    5028 pty5     20:10:01 /home/eanzmagn/tools/moshell/commonjars/sshd
#		if (os=="cygwin" && $NF ~ /\/sshd/) killports[$2]=1 #only one sshd allowed on cygwin
#		else if (/\/sshd(\.[^ ]+)? -oport=[0-9][0-9][0-9][0-9]/)
#		{
#			match($0,/-oport=([0-9][0-9][0-9][0-9])/,array)
#			#if the sshd has been running for more than 24 hrs, kill it
#			if ($2 ~ /^[A-Z]/) killports[array[1]]=1
#			else busyports[array[1]]=1
#		}
#	}
#	close(pscom)
#	for (i in killports)
#	{
#		if (os=="cygwin")
#		{
#			customPrint("Closing down old sshd session")
#			system("kill -9 "i)
#		}
#		else if (i < sshd_port) continue
#		else
#		{
#			customPrint("Closing down old sshd session on port "i"... ","","","noLF")
#			res=run_sshd_command("shutdown;",i,(mosdebug==1?"":"silent"),"","","","nocheck")
#			if (res == 0) customPrint("OK")
#			else { customPrint("Failed") ; busyports[i]=1 }
#		}
#	}
#	#check the processes are not there anymore if yes, kill with kill -9
#	#TO BE IMPLEMENTED !!

	stop_sshd(what)

	f[1]="moshell_dsa_key"
	f[2]="moshell_ecdsa_key"
	f[3]="moshell_rsa_key"
	f[4]="moshell_dsa_key.pub"
	f[5]="moshell_ecdsa_key.pub"
	f[6]="moshell_rsa_key.pub"
	system("rm -rf "tempdir"/sshkeys")
	system("rm -rf "tempdir"/cspare")
	system("unzip -oq -P chash "commonjardir"/cspare.zip -d "tempdir)
	system("mv "tempdir"/cspare "tempdir"/sshkeys")
	for (i=1;i<=6;i++) system("mv "tempdir"/sshkeys/"i" "tempdir"/sshkeys/"f[i])

	#system("cp -R "commonjardir"/sshkeys "tempdir)
	system("chmod 600 "tempdir"/sshkeys/moshell_*_key")
	system("chmod 755 "tempdir"/sshkeys/moshell_*_key.pub")

	sshdpidfile=tempdir"/sshdpid.log"
	delete sshdPortList
	for (i=sshd_port;i<=(sshd_port+sshd_range);i++) sshdPortList[++maxIndex]=i
	if (sshd_random>=1)
	{
		shuffleTable(sshdPortList)
		if (sshd_random==1) match(gawk_pid,/([0-9])$/,nr)
		else if (sshd_random==2) match(gawk_pid,/([0-9]?[0-9])$/,nr)
		else if (sshd_random==3)  match(gawk_pid,/([0-9]?[0-9]?[0-9])$/,nr)
		for (j=1;j<=nr[1];j++) shuffleTable(sshdPortList)
	}
	#for (i=1;i<=maxIndex;i++) printf("%-4s %s\n", i,sshdPortList[i])
	#print gawk_pid,nr[1]
	for (i=1;i<=maxIndex;i++)
	{
		if (sshdPortList[i] in busyports) continue
		sshdport=sshdPortList[i]
		break
	}
	customPrint("\nStarting sshd on port "sshdport"...","","","noLF")
	sshdcom=sprintf("%s -oPort=%d -f /dev/null -D -e -h %s/sshkeys/moshell_dsa_key -h %s/sshkeys/moshell_rsa_key -h %s/sshkeys/moshell_ecdsa_key -o UsePrivilegeSeparation=no -o Subsystem=\"sftp %s\" -oPidFile=%s 2>&1",sshd,sshdport,tempdir,tempdir,tempdir,"internal-sftp",sshdpidfile)  #replaced sftpserv with "internal-sftp"
	if (mosdebug==1) print sshdcom
	while (sshdcom |& getline)
	{
		gsub("\r","")
		if (mosdebug==1) print
		if (/^Server listening on /) break
		else sshd_errors=sshd_errors"\n"$0
	}
	if ($0!~/^Server listening on /)
	{
		close(sshdcom)
		customPrint("Failed")
		customPrint(gensub(/^\n/,"",1,sshd_errors))
		return 1
	}
	#wait 2 seconds to make sure that the sshd server has correctly started - if the port was already taken we'd get error message and exit: "TCP transport: unable to bind '8001': 98"
	mysleep(2)
	#now double-check that we have a child sshd process
	#sshd_pid=find_javaprocess(gawk_pid,"sshd")
	if (fileOps("test -s "sshdpidfile)==0)
	{
		close(sshdpidfile)
		getline sshd_pid < sshdpidfile
		close(sshdpidfile)
	}
	if (sshd_pid ~ /^[0-9]+$/)
	{
		sshdStarted=1
		customPrint(" OK")
		#sshd_pid2=find_javaprocess(gawk_pid,"sshd")
		#if (sshd_pid2!=sshd_pid)
		#{
		#	customPrint("ERROR: mismatch in sshd pid "sshd_pid","sshd_pid2)
		#	system("kill "sshd_pid2)
		#	stop_sshd()
		#	return 1
		#}
		assignCustomVar("$sshdpid",sshd_pid,what,"system")
		assignCustomVar("$sshdport",sshdport,what,"system")
		return 0
	}
	#else
	#{
	#	#delay=sprintf("%0.f",rand()*10)
	#	delay=10
	#	customPrint("Failed. Retrying in "delay" seconds ...")
	#	mysleep(delay)
	#	#exit_with_error()
	#}
}
function stop_sshd(what)
{
	if (export_method>=1) return 0
	if (sshdStarted==1 && is_process_there(sshd_pid)==0)
	{
		sshdStarted=0
		if (what=="print") customPrint("\nStopping sshd pid "sshd_pid"...","","","noLF")
		system("kill "sshd_pid)
		mysleep(2)
		if (is_process_there(sshd_pid)==0)
		{
			system("kill -9 "sshd_pid)
			mysleep(2)
		}
		if (what=="print")
		{
			if (is_process_there(sshd_pid)==0) customPrint("Failed")
			else customPrint("OK")
		}
		close(sshdcom)
		fileOps("rm -f "tempdir"/sshdpid.log")
	}
}
#function shuffleTable(table, temptable,i,j)
#{
#	After gawk 4.1.0 this function does not work anymore since the order of cycling through a table is not random anymore in the new gawk version
#	#the shuffleTable function is the opposite of the asort function
#	#it shuffles the elements of the table in any order and replaces the table with a table containing an integer 1 to returnValue and the value of the table
#	for (i in table) temptable[++j]=table[i]
#	delete table
#	for (i=1;i<=j;i++) table[i]=temptable[i]
#	return j
#}
function shuffleTable(table, len,temp,i,j)
{
     # The shuffleTable function is the opposite of the asort function
     # it shuffles the elements of the table in any order and replaces the table with a table containing an integer 1 to returnValue and the value of the table
     #for (j in table) print j,table[j]
     len = length(table)
     for (i=1; i<=len; i++)
     {
        j = i + int(rand() * (len - i) + 0.5)
        temp = table[j]
        table[j] = table[i]
        table[i] = temp
     }
     #for (j in table) print j,table[j]
     return len
}
function find_offline_zipfiles(file,  tmpdir,tmpzip,tmpnode,fileList,nr_files,pwd,tnode,i,tfile)
{
	#try to see if there is a logfiles.zip and/or ropfiles.zip and/or cv.zip in the same folder as the modump.zip
	#if yes we store their path in the global variables logfiles_zip and ropfiles_zip
	#if the path is not absolute, then we make it an absolute path, otherwise the commands won't work when we change to a different directory with "lcd"
	#print "file="file
	pwd=fileOps("pwd")
	tmpdir=gensub(/[^/]+$/,"",1,file)
	if (tmpdir !~ /^\//) tmpdir=pwd"/"tmpdir
	tmpnode=gensub(/^.*\/|_modump.zip$/,"","g",file)
	tnode=gensub(/^.*\/|_(offline|modump).zip$/,"","g",file)
	tmpzip=sprintf("%s%s_logfiles.zip",tmpdir,tmpnode)
	if (fileOps("test -f "tmpzip)==0) logfiles_zip=tmpzip
	tmpzip=sprintf("%s%s_ropfiles.zip",tmpdir,tmpnode)
	if (fileOps("test -f "tmpzip)==0) ropfiles_zip=tmpzip
	nr_files=fileOps("ls "(tmpdir==""?".":tmpdir),fileList)
	#From 11.0p, the filenames are compared in lower case since sometimes the nodename can be in uppercase or lowercase, depending on the ipdatabase
	for (i=1;i<=nr_files;i++)
	{
		#print fileList[i], sprintf("^%s_dcg_[aeimrsx].log.gz$",tnode)
		if (tolower(fileList[i]) ~ tolower(sprintf("^%s_dcg(proxy)?_([aeimrsx]|m2|e2|x2|rrus31b?).log.gz$",tnode)))
		{
			tfile=sprintf("%s%s",tmpdir,fileList[i])
			coliFile[tfile]=tfile
		}
	}
	for (i=1;i<=nr_files;i++)
	{
		if (tolower(fileList[i]) ~ tolower(sprintf("^%s_DCG_[0-9]+_[0-9]+_duringfault.zip$",tmpnode)))
		{
			dcgcv_zip=sprintf("%s%s",tmpdir,fileList[i])
			break
		}
	}
	for (i=1;i<=nr_files;i++)
	{
		if (tolower(fileList[i]) ~ tolower(sprintf("^%s_cv.zip$",tmpnode)))
		{
			dcgcvfolder_zip=sprintf("%s%s",tmpdir,fileList[i])
			break
		}
	}
}
function find_coli_files(file,   tmpdir,tnode,i,nr_files,fileList,pwd,tfile)
{
	#this function used only when the user runs moshell /path/to/xxx_offline.zip
	pwd=fileOps("pwd")
	tmpdir=gensub(/[^/]+$/,"",1,file)
	if (tmpdir !~ /^\//) tmpdir=pwd"/"tmpdir
	tnode=gensub(/^.*\/|_offline.zip$/,"","g",file)
	nr_files=fileOps("ls "(tmpdir==""?".":tmpdir),fileList)
	for (i=1;i<=nr_files;i++)
	{
		#print fileList[i], sprintf("^%s_dcg_[aeimrsx].log.gz$",tnode)
		if (tolower(fileList[i]) ~ tolower(sprintf("^%s_dcg_([aeimrsx]|m2|e2|x2|rrus31b?).log.gz$",tnode)))
		{
			tfile=sprintf("%s%s",tmpdir,fileList[i])
			coliFile[tfile]=tfile
		}
	}
}

function correct_mo_case(dn,   last,array,i,part,moclass,moid)
{
	if (comcli==0) return ""
	last=split(dn,array,",")
	#dn="ManagedElement=1"
	dn=Ldn[0]
	for (i=1;i<=last;i++)
	{
		split(array[i],part,"=")
		moclass=tolower(part[1])
		moid=part[2]
		if (moclass=="managedelement") { dn=Ldn[0] ; continue }
		if (moclass in com_moclass_list && com_moclass_list[moclass]!="") moclass=com_moclass_list[moclass]
		else moclass=part[1]
		dn=dn","moclass"="moid
	}
	return dn
}
function correct_mo_spaces(dn)
{
	if (dn ~ space_sign)
	{
		gsub(space_sign," ",dn)
		gsub(/=/,"=\"",dn)
		gsub(/,/,"\",",dn)
		dn=dn"\""
	}
	return dn
}
function removeDots(tldn,   last,a,i,b)
{
	if (tldn !~ /,[^=]+\.[^=]+=/) return tldn
	#When the key attribute is not called like <moclass>Id then the LDN will look like this:
	#ManagedElement=1,HSS-Function.applicationName=HSS_FUNCTION,DIA-CFG-Application.applicationName=DIA,DIA-CFG-StackContainer.stackContainerId=HSS
	last=split(tldn,a,",")
	for (i=1;i<=last;i++)
	{
		split(a[i],b,"=")
		sub(/\..+$/,"",b[1])
		a[i]=b[1]"="b[2]
	}
	tldn=""
	for (i=1;i<=last;i++) tldn=tldn","a[i]
	sub(/^,/,"",tldn)
	return tldn
	#return gensub(/\.[^=]+=/,"=","g",tldn)  --> does not work properly
}
function reduce_filesize(file,   read_command,ok,newfile,gzip_session,bufferfile,currbd,currlhsh)
{
	if (file ~ /_dcg_m.log.gz$/ && fileOps("stat size "file)>max_dcgm_file_size)
	{
		customPrint("Removing \"rof_info_esig all\" printouts from large COLI file: "file"...","","","noLF")
		newfile=gensub(/_dcg_m.log.gz$/,"_dcg_m0.log",1,file)
		fileOps("rm "newfile)
		fileOps("rm "newfile".gz")
		read_command="gzip -dc "file
		#gzip_session="gzip >> "newfile".gz"
		ok=1
		while (read_command |& getline)
		{
			gsub("\r","")
			if ($1=="$" && $2=="lhsh")
			{
				ok=1
				if ($4=="rof_info_esig" && $5=="all") ok=0
			}
			#if (ok==1) print $0 | gzip_session
			if (ok==1) print $0 >> newfile
		}
		close(read_command)
		#close(gzip_session)
		close(newfile)
		close(newfile".gz")
		system("gzip -f "newfile)
		customPrint("Done.\n")
		return newfile".gz"
	}
	else if (file ~ /_dcg_(m|e2).log.gz$/ && ((fileOps("grep <ru_dcg> "file)==0 && fileOps("grep </ru_dcg> "file)==0)||(fileOps("grep DCG.run.for.XMU02 "file)==0)))
	{
		customPrint("Splitting \"dcg run\" printouts from COLI file: "file"...","","","noLF")
		newfile=gensub(/_dcg_(m|e2).log.gz$/,"_dcg_m0.log",1,file)
		bufferfile=gensub(/_dcg_(m|e2).log.gz$/,"_rubuffer.log",1,file)
		fileOps("rm "newfile)
		fileOps("rm "newfile".gz")
		fileOps("rm "bufferfile)
		read_command="gzip -dc "file
		ok=1
		while (read_command |& getline)
		{
			gsub("\r","")
			#$ lhsh 000100/port_0_dev_16 dcg run
			#0001p0d16: $ carrierListHandler print
			#0001p0d16: $ trx pid
			#0001p0d16: </ru_dcg>
			#$ lhsh 000100/BXP_0 dcg run
			#0001BXP_0: DCG run for XMU02 begin
			#0001BXP_0: DCG run for XMU02 end

			#Gen2:
			#coli>/fruacc/lhsh BXP_0 dcg run
			#BXP_0: <ru_dcg>
			#BXP_0: $ carrierListHandler print
			#BXP_0: </ru_dcg>

			print $0 >> newfile
			if ($1=="$" && $2=="lhsh" && $4=="dcg" && $5=="run")        { ok=1 ; currbd=$3 ; currlhsh="$ lhsh"}
			else if ($1=="coli>/fruacc/lhsh" && $3=="dcg" && $4=="run") { ok=1 ; currbd=$2 ; currlhsh="coli>/fruacc/lhsh" }
			else if (ok>0 && $2=="</ru_dcg>") ok=0
			else if (ok>0 && $2=="DCG" && $3=="run" && $4=="for" && $5=="XMU02" && $6=="end") ok=0
			else if (ok>0 && $2=="$" && NF>2)
			{
				ok++
				print "=============================================================================================" >> bufferfile
				print currlhsh" "currbd" "gensub(/^[ \t]*[^ \t]+[ \t]+[$][ \t]+/,"",1,$0) >> bufferfile
			}
			else if (ok>1) print $0 >> bufferfile
		}
		print "=============================================================================================" >> bufferfile
		close(read_command)
		close(bufferfile)
		while (getline < bufferfile) print $0 >> newfile
		close(bufferfile)
		close(newfile)
		system("gzip -f "newfile)
		customPrint("Done.\n")
		return newfile".gz"
	}
	return file
}
function Load_Proxys(scope,moscope,force,silent,confirmation,conditional,special,user,fromfile,     z,i,j,n,k,l,q,answer,moprox,Proxy,mopart,mopart_type,\
mopart_id,b,moclass,array,already_loaded,Filter1,Filter2,Filter3,Filter4,proxyList,m,p,inmib,tmpmomversion,readmib_command,tmpline,motypes,\
currRdn,currLdn,dn,parentMo,indentation,a,countMo,comOk,tmp,notFound,unzip_session,r,tfile,neg,par,dest,theldns,motype_scope)
{
	if (dbdat)
	{
		mibfile=$2
		if (mibfile !~ /\.(dat|zip)$/)
		{
			customPrint("Invalid file type, must be a db.dat or a cv.zip. Exiting...")
			exit_with_error()
		}
		if (fileOps("test -s "mibfile) != 0)
		{
			if (mibfile ~ /.dat$/) customPrint("Unable to read the db.dat file, check that the correct file path has been specified. Exiting...")
			else customPrint("Unable to read the cv.zip file, check that the correct file path has been specified. Exiting...")
			exit_with_error()
		}
	}
	#check if we are trying to load an offline MIB
	if (node ~ /^OFFLINE/)
	{
		if (tolower($2)=="all")
		{
			#lt all interactively re-reads the MIB but not when run from a script
			#flt all re-reads the MIB always
			if ((user=="user")&&(reading_script==0 || force=="force")) $2=mibfile
			else return
		}
		else if (fileOps("test -s "$2)==0 && tolower($2)!="root"){}  #the user have specified a file and the filename is not called "root"
		else if ($1=="ld" && $3=="#SystemCreated")
		{
			#ld RncFunction=1,IubLink=Iub-1523,NodeSynch=1 #SystemCreated
			tmp=giveMoProxy($2)
			#print $2" "tmp
			if (tmp==0)
			{
				par=gensub(/,[^,]+$/,"",1,$2)
				tmp=giveMoProxy(par)
				#print par" "tmp
				if (tmp!=0)
				{
					OffOk=1
					$0="cr "$2
					create()
				}
			}
			return
		}
		else
		{
			customPrint("\nIn offline mode, the syntax is: \"lt all\" or \"lt /path/to/modump\"")
			return
		}
		#mibfile, mibline and mibtype are global variables
		mibfile=$2
		#print "mibfile="mibfile
		if (mibfile ~ /.+_modump\.zip$/)
		{
			find_offline_zipfiles(mibfile)
			mibfile=unzip_mibfile(mibfile,tempdir"/modump")
			if (mibfile=="") exit_with_error()
		}
		else if (mibfile ~ /\.(zip|ZIP)$/)
		{
			if (mibfile ~ /_offline.zip$/) find_coli_files(mibfile)
			mibfile=unzip_mibfile(mibfile,tempdir"/modump")
			if (mibfile ~ /_modump.zip$/)
			{
				#the zipfile given as argument contained the dcg logs (modump, dbdat, ropfiles, logfiles, etc)
				find_offline_zipfiles(mibfile)
				mibfile=unzip_mibfile(mibfile,tempdir"/modump/modump")
			}
			else if (mibfile ~ /_offline.zip$/)
			{
				find_offline_zipfiles(mibfile)
				mibfile=unzip_mibfile(mibfile,tempdir"/modump/modump")
				if (mibfile ~ /_modump.zip$/)
				{
					find_offline_zipfiles(mibfile)
					mibfile=unzip_mibfile(mibfile,tempdir"/modump/modump/modump")
				}
			}
			if (mibfile=="") exit_with_error()
		}
		if (logfiles_zip != "") customPrint("Found logfiles:  "logfiles_zip"\n")
		if (ropfiles_zip != "") customPrint("Found ropfiles:  "ropfiles_zip"\n")
		if (dcgcv_zip    != "") customPrint("Found dcg CV:    "dcgcv_zip"\n")
		if (dcgcvfolder_zip!="")
		{
			customPrint("Found CV folder: "dcgcvfolder_zip"\n")
			unzip_session="unzip -oq "dcgcvfolder_zip" -d "tempdir"/modump 2>/dev/null"
			#customPrint(unzip_session)
			system(unzip_session)
		}


		if (dbdat)
		{
			if (Load_dbdat(mibfile)==99) exit_with_error()
			return
		}
		if (logfiles_zip != "")
		{
			unzip_session="unzip -oq "logfiles_zip" -d "tempdir"/modump teread.log llog.log 2>/dev/null"
			#customPrint(unzip_session)
			if (system(unzip_session)==0)
			{
				tfile=tempdir"/modump/teread.log" ; if (fileOps("test -s "tfile)==0) coliLog[++NColi]=tfile
				tfile=tempdir"/modump/llog.log"   ; if (fileOps("test -s "tfile)==0) coliLog[++NColi]=tfile
			}
		}
		r=asort(coliFile)
		for(i=1;i<=r;i++) coliLog[++NColi]=reduce_filesize(coliFile[i])
		if (NColi > 0)
		{
			remove_duplicate_colilogs()
			customPrint("Found COLI logs:")
			for(i=1;i<=NColi;i++) { if (coliLog[i]!="") customPrint("  "coliLog[i]) }
			customPrint("Use command \"lfc <file>\" to load more COLI files.")
			customPrint("")
			build_coli_list()
		}
		if (mibfile ~ /\.(gz|GZ)$/) readmib_command="gzip -dc "mibfile ; else readmib_command="cat "mibfile
		clear_internal_proxy_table()
		mibline=0
		inmib=0
		#print "comcli="comcli
		while (readmib_command |& getline)
		{
			gsub("\r","") ;mibline++
			#if (mosdebug==1) print mibline,"comcli="comcli,$0
			#060305-18:18:09 172.31.98.137 6.1ze RNC_NODE_MODEL_G_5_0 stopfile=/tmp/2638 (if show_timestamp==1)
			#*** 172.31.98.137 6.1ze RNC_NODE_MODEL_G_5_0 stopfile=/tmp/2638             (if show_timestamp==0)
			#060328-05:54:42 10.172.96.5 6.1zg MOM-CELLO_4.3.2-3_5_1
			#071107-17:36:33 137.58.194.147 7.0r LIMITED RNC_NODE_MODEL_G_5_28 stopfile=/tmp/12588  (if restricted/limited)
			if (inmib==0)
			{
				if ($0 ~ dump_header_line)
				{
					modump_moshellversion=$3
					tmpmomversion=($4 ~ /^(LIMITED|READONLY|RESTRICTED)/ ? $5 : $4)
					if (mom_version != tmpmomversion)
					{
						mom_version=tmpmomversion
						mom_file=jarxmldir"/"mom_version".xml"
						if (find_mom_file(mom_file)==0) readmom(mom_file)
						else inmib=2
					}
					#comcli will be set to 1 after reading the MOM
					if (comcli>0 && com_mibtype=="showall")
					{
						countMo=-1
						prepare_mib_loading()
					}
				}
				else if ($0 ~ "> show all verbose") com_mibtype="showall"
				#Usually the dump starts with the proxy 0 ManagedElement
				#However if the dump was taken while sort_proxy=1 (s+) then the Equipment or ENodeBFunction or AccessSignaling MO will be at the top
				else if (/^(Me=[^,]+,)?ManagedElement=1 +ManagedElementId +1$/) { mibtype="get"  ; inmib=prepare_mib_loading()}
				else if (/^0 +(Me=[^,]+,)?ManagedElement=1$/)              { mibtype="geta" ; inmib=prepare_mib_loading()}
				else if (/^(Proxy Id +0|MO +[^ ]+,Equipment=1)$/)          { mibtype="kget" ; inmib=prepare_mib_loading()}
				else if (/^ +0 +(Me=[^,]+,)?ManagedElement=1 +ManagedElementId +1$/) { mibtype="getp" ; inmib=prepare_mib_loading()}
			}
			if (comcli>0 && com_mibtype=="showall")
			{
				#is like:
				#SystemFunctions=1
				#Lm=1 <preliminary>
				#ReportConfigB2CdmaRttUlTrig=1 <deprecated>
				#PmGroup="Cell codes"
				#change to:
				#>>>  [Proxy ID = 1] MO name :ManagedElement=1,SystemFunctions=1
				#>>>  [Proxy ID = 2] MO name :ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=Cell codes

				if (inmib==0 && $0~/^ManagedElement=/) inmib=1
				if (inmib==1 && $1~/^[A-Z].*=/ && gensub(/=.*$/,"",1,$1) in com_moclass_list && com_moclass_list[gensub(/=.*$/,"",1,$1)]!="")
				{
					sub(/ <preliminary>$/,"")
					sub(/ <deprecated>$/,"")
					countMo++
					if (NF==1) currRdn=$1
					else currRdn=gensub(/^[ \t]*|[ \t]*$|\"/,"","g",$0)
					indentation=length(gensub(/[A-Z].*$/,"",1,$0))
					dn[indentation]=currRdn
					parentMo=""
					for(a=0;a<indentation;a++)
					{
						if (a in dn && dn[a]!="") parentMo=parentMo dn[a]","
					}
					currLdn=parentMo currRdn
					add_Proxys_to_table(transform_mib_line(countMo" "gensub(/ManagedElement=[^,]+,/,"",1,currLdn),"geta"))
				}
				#look for the end of the printout:
				if ((inmib==1)&&($0==">exit" || $0~/^Connection to.*closed./))
				{
					#>exit
					#Connection to 10.64.86.130 closed.
					mib_eline[mib_maxProxy]=mibline-1
					inmib=3
				}
				continue
			}
			if (inmib==1)
			{
				if ($1=="Total:" && $3=="MOs" && $2~/^[0-9]+$/)
				{
					inmib=0
					mib_eline[mib_maxProxy]=mibline-2
				}
				else
				{
					add_Proxys_to_table(transform_mib_line($0,mibtype))
				}
			}
			else if (inmib==2) break
		}
		close(readmib_command)
		if (inmib==1) mib_eline[mib_maxProxy]=mibline #in case we had an incomplete MO dump where end of file is reached before the line "Total: xxx MOs"
		if (inmib==2) return
		remove_proxy_duplicates()
		customPrint(sprintf("Last MO: %5s. Loaded %4s MOs. Total: %5s MOs.",maxProxy,maxProxy,maxProxy+1))
		make_testclassgroup()
		customPrint("\nMoshell version of the MO dump: "modump_moshellversion)
		populate_mib_table()
		node=node_address="OFFLINE_"gensub(/.*\/|\.[a-zA-Z]+(\.gz)?$/,"","g",mibfile)
		iorfile=mibfile
		find_rat()
		if (mosdebug==3)
		{
			tablePrint(Ldn,"Ldn" )
			tablePrint(origLdn,"origLdn" )
			tablePrint(MoProxy,"MoProxy")
			tablePrint(DirectMeChildren,"DirectMeChildren" )
			tablePrint(motypeToFindAlreadyLoaded,"motypeToFindAlreadyLoaded" )
			tablePrint(nrOfMoTypes,"nrOfMoTypes" )
			tablePrint(modataId,"modataId" )
			tablePrint(mimTable,"mimTable" )
			tablePrint(ClassProxy,"ClassProxy")
		}
		if (prompt_has_been_manually_set != 1) Set_prompt("",evalnodecase(node))
		return
	}

	if (silent == "silent" && node ~ /^OFFLINE_/) return
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	if (comcli>0)
	{
		if (scope=="ldn")
		{
			#INFO : there is also the function is_mo_there(ldn)  , which is similar but does not load a proxy for the MO, just checks if it exists on the node
			cliMode="unknown"
			comOk=0
			notFound=0
			Filter1=$2
			Filter1=correct_mo_case(Filter1)
			tmp=giveMoProxy(Filter1,"","","","noload")
			if (tmp > 0)
			{
				if (silent=="") customPrint("\nThis MO is already loaded.")
				return
			}
			print "show "correct_mo_spaces(Filter1) |& SshClient
			while (SshClient |& getline)
			{
				gsub("\r","") ; gsub("\x000","")
				if (mosdebug==1) print $0
				if ($1=="EndOfPrint") { comOk=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break}
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($1=="ERROR:")
				{
					if (silent=="") customPrint("!!!! "$0)
					notFound=1
				}
			}
			if (comOk==1 && notFound==0)
			{
				countMo++
				add_Proxys_to_table(transform_mib_line(countMo" "gensub(/ManagedElement=[^,]+,/,"",1,Filter1),"geta"))
				if (silent != "silent") customPrint(sprintf("\nLast MO: %5s. Loaded %4s MOs. Total: %5s MOs.",maxProxy,1,maxProxy+1))
			}
		}
		else if (tolower($2) == "root")
		{
			clear_comcli_proxy_counts()
			clear_internal_proxy_table()
			clear_mom_tables("pm")
			if (load_rootmo()==1) return
			countMo++
			add_Proxys_to_table(transform_mib_line(countMo" "ComMe,"geta"))
		}
		else if (tolower($2) == "all")
		{
			#lt all
			clear_comcli_proxy_counts()
			clear_internal_proxy_table()
			#clear_mom_tables("pm")
			if (load_rootmo(special)==1) return
			if (fromfile=="fromfile")
			{
				showmibOk=1
				close(tempshowmiblog)
				while (getline < tempshowmiblog)
				{
					if ($1 !~ /^ManagedElement=/) continue
					countMo++
					if (NF==1) currLdn=$1
					else currLdn=gensub(/^[ \t]*|[ \t]*$|\"/,"","g",$0)
					currLdn=removeDots(currLdn)
					add_Proxys_to_table(transform_mib_line(countMo" "gensub(/ManagedElement=[^,]+,/,"",1,currLdn),"geta"))
				}
				close(tempshowmiblog)
				customPrint(sprintf("\nLast MO: %5s. Loaded %4s MOs. Total: %5s MOs.",maxProxy,maxProxy,maxProxy+1))
				make_testclassgroup()
				remove_proxy_duplicates()
				return
			}
			print "show-mib -v" |& SshClient
			while (SshClient |& getline)
			{
				#COM < 3.3:
				#ERROR: Command not found.
				#COM >= 3.3:
				#ManagedElement=1
				#   ManagedElement=1,SystemFunctions=1
				#When the key attribute is not called like <moclass>Id then the LDN will look like this:
				#ManagedElement=1,HSS-Function.applicationName=HSS_FUNCTION,DIA-CFG-Application.applicationName=DIA,DIA-CFG-StackContainer.stackContainerId=HSS
				gsub("\r","") ; gsub("\x000","")
				if (mosdebug==1) print $0
				if ($1=="EndOfPrint")
				{
					if (showmibOk==1) { comOk=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) }
					break
				}
				if ($1=="ERROR:" && $0!~/ERROR: Command not found./) { customPrint("!!!! "$0) }
				else if (/\[Read error code [^ ]+\]/) { customPrint("!!!! "$0) }
				else if ($1=="ssh_dispatch_run_fatal:") { customPrint("!!!! "$0) }
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($1 ~ /^ManagedElement=/)
				{
					showmibOk=1
					countMo++
					if (NF==1) currLdn=$1
					else currLdn=gensub(/^[ \t]*|[ \t]*$|\"/,"","g",$0)
					currLdn=removeDots(currLdn)
					add_Proxys_to_table(transform_mib_line(countMo" "gensub(/ManagedElement=[^,]+,/,"",1,currLdn),"geta"))
				}
			}
			if (showmibOk==0)
			{
				#on PICO "show all" takes very long
				#so the "lt all" command will only do "show configuration" and that should show all MOs
				#if some MOs are missing, we can use "ltc all" instead of "lt all", then it will do "show all"
				if (mom_version ~ /PRBS_NODE_MODEL/ && moscope==0) print "show configuration" |& SshClient
				else print "show all" |& SshClient
				while (SshClient |& getline)
				{
					gsub("\r","") ; gsub("\x000","")
					if (mosdebug==1) print $0
					if ($1=="EndOfPrint") { comOk=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break}
					if ($1=="ERROR:") { customPrint("!!!! "$0) }
					else if (/\[Read error code [^ ]+\]/) { customPrint("!!!! "$0) }
					else if ($1=="ssh_dispatch_run_fatal:") { customPrint("!!!! "$0) }
					if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
					#is like:
					#SystemFunctions=1
					#PmGroup="Cell codes"
					#Lm=1 <preliminary>
					#ReportConfigB2CdmaRttUlTrig=1 <deprecated>
					#change to:
					#>>>  [Proxy ID = 1] MO name :ManagedElement=1,SystemFunctions=1
					#>>>  [Proxy ID = 2] MO name :ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=Cell codes
					if (inmib==0 && $0~/^ManagedElement=/) inmib=1
					if (inmib==1 && $1~/^[A-Z].*=/ && gensub(/=.*$/,"",1,$1) in com_moclass_list && com_moclass_list[gensub(/=.*$/,"",1,$1)]!="")
					{
						sub(/ <preliminary>$/,"")
						sub(/ <deprecated>$/,"")
						countMo++
						if (countMo >=300 && countMo%300==0) printf "."
						if (NF==1) currRdn=$1
						else currRdn=gensub(/^[ \t]*|[ \t]*$|\"/,"","g",$0)
						indentation=length(gensub(/[A-Z].*$/,"",1,$0))
						dn[indentation]=currRdn
						parentMo=""
						for(a=0;a<indentation;a++)
						{
							if (a in dn && dn[a]!="") parentMo=parentMo dn[a]","
						}
						currLdn=parentMo currRdn
						add_Proxys_to_table(transform_mib_line(countMo" "gensub(/ManagedElement=[^,]+,/,"",1,currLdn),"geta"))
					}
					if (inmib==1 && $0 ~ /[> ]exit$|^Connection to.*closed./)
					{
						#(exec )
						#erv@1>exit
						#bash-3.2$ exit
						#Connection to epg103-4 closed.
						inmib=3
					}
				}
			}
			if (comOk==1 || /^Connection to.*closed./)
			{
				customPrint(sprintf("\nLast MO: %5s. Loaded %4s MOs. Total: %5s MOs.",maxProxy,maxProxy,maxProxy+1))
				make_testclassgroup()
				ltall_done=1
			}
		}
		else if (scope ~ "children"  && $2 != "")
		{
			buildProxyList("short",moprox,otherVars)
			i=otherVars["p"]
			if (silent != "silent" && muteLog != "mute")
			{
				customPrint(sprintf("\nLoad Proxys for children of following MOs ..."))
				customPrint("===================================================================================")
		        	for (j=1;j<=i;j++) customPrint(sprintf("%5s  %s",moprox[j],p2s("Mo",moprox[j])))
				customPrint("===================================================================================")
		        	#customPrint("Please Confirm [y/n]: ","","","noLF")
			}
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
	        	if (tolower(answer) !~ /^y+(es)?$/)
	        	{
	        		add_to_moscomlog("","%@> Fail (Command aborted)")
	        		return
	        	}
			answer = ""
			if (silent != "silent" && muteLog != "mute") print ""
			theldns=""
			for (j=1;j<=i;j++) theldns=theldns";"p2s("Mo",moprox[j])
			sub(/^;/,"",theldns)
			load_subtree(theldns)
			remove_proxy_duplicates()
			delete moprox
		}
		else if (moscope==0 && $2 != "")
		{
			Filter1=tolower($2)
			i=0
			q=asort(com_moclass_list,dest)
			for (j=1;j<=q;j++)
			{
				if (array[j]=="ManagedElement" || dest[j]=="") continue
				if (tolower(dest[j]) ~ Filter1) motype_scope[dest[j]]=dest[j]
			}
			if (silent != "silent" && muteLog != "mute")
			{
				i=asort(motype_scope)
				customPrint(sprintf("\n%sLoad Proxys for MOs of following type ...",(conditional=="conditional"?"Conditionally ":"")))
				customPrint("===================================================================================")
	        		for (j=1;j<=i;j++) customPrint(motype_scope[j])
				customPrint("===================================================================================")
			}
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
	        	if (tolower(answer) !~ /^y+(es)?$/)
	        	{
	        		add_to_moscomlog("","%@> Fail (Command aborted)")
	        		return
	        	}
			answer = ""
			if (silent != "silent" && muteLog != "mute") print ""
			delete motypes
			for (j=1;j<=i;j++) motypes[tolower(motype_scope[j])]=1
			delete motype_scope
			ConditionalLoad(motypes,(conditional=="conditional"?"":"force"))
		}
		else
		{
			customPrint("\nOnly the following options are supported on COM nodes: lt root, lt all, lt <moclass>, lcc <mo-filter>|<proxy>, and ld[c] <ldn>")
			customPrint("Type \"h lt\", \"h lcc\", or \"h ld\" for more info.")
		}
		remove_proxy_duplicates()
		if (mosdebug==3)
		{
			tablePrint(Ldn,"Ldn" )
			tablePrint(origLdn,"origLdn" )
			tablePrint(MoProxy,"MoProxy")
			tablePrint(DirectMeChildren,"DirectMeChildren" )
			tablePrint(motypeToFindAlreadyLoaded,"motypeToFindAlreadyLoaded" )
			tablePrint(nrOfMoTypes,"nrOfMoTypes" )
			tablePrint(modataId,"modataId" )
			tablePrint(mimTable,"mimTable" )
			tablePrint(ClassProxy,"ClassProxy")
		}
		return
	}

	#special case :
	#lt all!fake
	#lt all!relation

	if (NF == 2 && $2 ~ /^all\!.+/)
	{
		sub(/^all/,"",$2)
		Filter1=tolower($2)
		$0="lt root"; Load_Proxys("type",0)
		$0="lt "Filter1; Load_Proxys("type",0,"","silent","noconfirm")
		return
	}

	if (NF == 3 && $3 == ";") $3=""
	if ((scope ~ "children") &&(tolower($2) == "all"))
	{
		Load_Proxys("all")
	}
	else if ((scope ~ "children")  && ($2 != ""))
	{
		buildProxyList("long",moprox,otherVars)
		i=otherVars["p"]
		if (silent != "silent" && muteLog != "mute")
		{
			customPrint(sprintf("\nLoad Proxys for children of following MOs%s ...",(moscope>1?" and all subsequent children":"")))
			customPrint("===================================================================================")
	        	for (j=1;j<=i;j++) customPrint(sprintf("%5s  %s",moprox[j],p2s("Mo",moprox[j])))
			customPrint("===================================================================================")
	        	#customPrint("Please Confirm [y/n]: ","","","noLF")
		}
		if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
		else answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
	        if (tolower(answer) ~ /^y+(es)?$/)
	        {
			if (silent != "silent") print ""
			for (j=1;j<=i;j++)
			{
				#print j,p2s("Mo",moprox[j])
				if (p2s("Mo",moprox[j]) != "")
				{
					$0="" ; $2=p2s("Mo",moprox[j])","
					buildProxyList("long",proxyList)
					for (m in proxyList)
					{
						if (p2s("Mo",proxyList[m]) != p2s("Mo",moprox[j])) removeProxy(proxyList[m])
					}
					delete proxyList
					if ( SubLoad_Proxys(11,moprox[j],moscope,"","",silent) == 1) break
				}
			}
			remove_proxy_duplicates()
		}
		else add_to_moscomlog("","%@> Fail (Command aborted)")
		delete moprox
	}
	else if (scope == "ldn")
	{
		Filter1=$2
		split(Filter1,array,"\n") ; Filter1=array[1]         # to fix a bug in lk command
		Filter1=gensub(/[mM]anaged[eE]lement=[^,]+,/,"","g",Filter1)
		last=split(Filter1,array,",")
		for (i=1;i<=last;i++)
		{
			#print "i: " i
			for (j=1;j<=i;j++)
				mopart[i]=mopart[i]","array[j]
			split(array[i],arraytype,"=")
			for (moclass in attribute_list)
				if (tolower(moclass)==tolower(arraytype[1]))
					mopart_type[i]=moclass
			mopart_id[i]=arraytype[2]
			sub(/^,/,"",mopart[i])
			#print mopart[i] "      "mopart_id[i]
			already_loaded=0
			for (b in Ldn)
			       if (tolower(mopart[i]) == tolower(p2s("Mo",b))) already_loaded=1
			if (already_loaded == 0)
			{
				if (i==1) parent_proxy=0
				else
				{
					for (b in Ldn)
					{
						if (tolower(mopart[i-1])==tolower(p2s("Mo",b)))
						{
							parent_proxy=b
						}
					}
				}
				#print "Subload: "parent_proxy" "mopart_type[i]" "sprintf("%sId==\x027%s\x027",mopart_type[i],mopart_id[i])
				SubLoad_Proxys(12,parent_proxy,1,mopart_type[i],sprintf("%sId==\x027%s\x027",mopart_type[i],mopart_id[i]),silent)
				#print "Subloadafter: "parent_proxy" "mopart_type[i]" "sprintf("%sId==\x027%s\x027",mopart_type[i],mopart_id[i])
			}
		}
		if (already_loaded == 1) customPrint("\nThis MO already has a proxy")
	}
	else if ($3 == "")
	{
		i=0
		Filter1=tolower($2)
		if (Filter1 == "all") scope="all"
		if (Filter1 == "root") scope="root"
		$0 = ""
		if (scope == "all")
		{
			#maxProxy=0
			clear_internal_proxy_table()
			SubLoad_Proxys(1)
			remove_proxy_duplicates()
			make_testclassgroup()
			#print ""
			#Load_Proxys("rootstart")
			#printf "\rPlease wait (up to 1min)..."
			#SubLoad_Proxys(11,0,20)
		}
		else if (scope == "root")
		{
			clear_internal_proxy_table()
			SubLoad_Proxys(10)
		}
		else if (scope == "rootstart")
		{
			clear_internal_proxy_table()
			SubLoad_Proxys(10)
		}
		else if (Filter1 != "")
		{
			if (force == "force")
			{
				motype_scope[1]=Filter1
				i=1
			}
			else if (multi)
			{
				for (moclass in multi_moclasslist)
				       if (tolower(moclass) ~ Filter1 && moclass != "ManagedElement")
		       				motype_scope[++i]=moclass
		       	}
			else
			{
				q=split(sorted_mom_list["moclass"],array,",")
				neg=0
				if (Filter1 ~ /^!/) { neg=1 ; sub(/^!/,"",Filter1) }
				for (j=1;j<=q;j++)
				{
					if (array[j]=="ManagedElement" || array[j]=="") continue
					if ((neg==1 && tolower(array[j]) !~ Filter1)||(neg==0 && tolower(array[j]) ~ Filter1)) motype_scope[++i]=array[j]
				}
				#for (moclass in attribute_list)
				#       if (tolower(moclass) ~ Filter1 && moclass != "ManagedElement")
		       		#		motype_scope[++i]=moclass
			}
			if (silent != "silent" && muteLog != "mute")
			{
				customPrint(sprintf("\n%sLoad Proxys for MOs of following type%s ...",(conditional=="conditional"?"Conditionally ":""),(moscope>0?" and all subsequent children":"")))
				customPrint("===================================================================================")
	        		for (j=1;j<=i;j++) customPrint(motype_scope[j])
				customPrint("===================================================================================")
			}
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else
			{
				#customPrint("Please Confirm [y/n]: ","","","noLF")
				answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
			}
	        	if (tolower(answer) ~ /^y+(es)?$/)
	        	{
				answer = ""
				if (silent != "silent" && muteLog != "mute") print ""
				if (conditional=="conditional")
				{
					for (j=1;j<=i;j++) motypes[tolower(motype_scope[j])]=1
					ConditionalLoad(motypes)
					return
				}
				for (j=1;j<=i;j++)
				{
					for (Proxy in Ldn)
					{
						if (tolower(p2s("MoType",Proxy)) == tolower(motype_scope[j])) removeProxy(Proxy)
					}
					if ( SubLoad_Proxys(14,motype_scope[j]) == 1) break
					if (moscope  > 0 )
					{
						l=0
						#if ( SubLoad_Proxys(15,motype_scope[j]) == 1) break #old method
						#if ( SubLoad_Proxys(14,motype_scope[j]) == 1) break
						#remove_proxy_duplicates()
		        			for (Proxy = 0; Proxy <= maxProxy; Proxy++)
							if ((tolower(p2s("MoType",Proxy)) == tolower(motype_scope[j]))&&(p2s("MoType",Proxy) != ""))
								moprox[++l]=Proxy
						for (k=1;k<=l;k++)
						{
							if (p2s("Mo",moprox[k]) != "")
							{
								$0="" ; $2=p2s("Mo",moprox[k])","
								buildProxyList("long",proxyList)
								for (m in proxyList)
								{
									if (p2s("Mo",proxyList[m]) != p2s("Mo",moprox[k])) removeProxy(proxyList[m])
								}
								delete proxyList
								if ( SubLoad_Proxys(11,moprox[k],moscope) == 1) break
							}
						}
					}
				}
				delete motype_scope
				remove_proxy_duplicates()
			}
			else add_to_moscomlog("","%@> Fail (Command aborted)")
		}
		else if (Filter1 == "") customPrint("\nPlease enter an argument for this command.")
	}
	else
	{
		#lt <mo-type> <attr==value>
		i=0
		Filter1=tolower($2)
		Filter2=""
		for (j=3 ; j<=NF ; j++)
			Filter2=sprintf("%s %s",Filter2,$j)
		sub(/^ /,"",Filter2)
		if (Filter1 == "all") scope="all"
		if (Filter1 == "root") scope="root"
		$0 = ""
		if (scope == "all")
		{
			#maxProxy=0
			#SubLoad_Proxys(1)  --> This mobrowser method uses more memory and is slower
	        	#customPrint(sprintf("\nRunning this command on a node containing a large number of MOs (e.g an RNC)\nwill take a very long time and might overload the node.\nOK to proceed? [y/n]: "),"","","noLF")
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else answer=Read_Answer(reading_script,"","","","","yesno",sprintf("\nRunning this command on a node containing a large number of MOs (e.g an RNC)\nwill take a very long time and might overload the node.\nOK to proceed? [y/n]: "))
	        	if (tolower(answer) ~ /^y+(es)?$/)
			{
				#printf "\rPlease wait (up to 1min)..."
				SubLoad_Proxys(12,0,20,"",Filter2)
				remove_proxy_duplicates()
			}
			else add_to_moscomlog("","%@> Fail (Command aborted)")
		}
		else if (scope == "root")
		{
			clear_internal_proxy_table()
			SubLoad_Proxys(10)
		}
		else if (scope == "rootstart")
		{
			clear_internal_proxy_table()
			SubLoad_Proxys(10)
		}
		else if ((Filter1 != "")&&(moscope==0))
		{
			if (force == "force")
			{
				motype_scope[1]=Filter1
				i=1
			}
			else if (multi)
			{
				for (moclass in multi_moclasslist)
				       if (tolower(moclass) ~ Filter1 && moclass != "ManagedElement")
		       				motype_scope[++i]=moclass
			}
			else
			{
				for (moclass in attribute_list)
				       if (tolower(moclass) ~ Filter1)
		       				motype_scope[++i]=moclass
			}
			customPrint("\nLoad Proxys for MOs of following type using the attribute Filter: "Filter2" ...")
			#if (moscope > 1)  printf " and all subsequent children"
			customPrint("===================================================================================")
	        	for (j=1;j<=i;j++) print customPrint(motype_scope[j])
			customPrint("===================================================================================")
	        	#customPrint("Please Confirm [y/n]: ","","","noLF")
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
	        	if (tolower(answer) ~ /^y+(es)?$/)
	        	{
				answer = ""
				print ""
				for (j=1;j<=i;j++)
				{
					 	if ( SubLoad_Proxys(12,0,20,motype_scope[j],Filter2) == 1) break
				}
				delete motype_scope
				remove_proxy_duplicates()
			}
			else add_to_moscomlog("","%@> Fail (Command aborted)")
		}
		else if ((Filter1 !="")&&(moscope>0))
		{
			 #print "\nFunction not supported. Use lt command instead."
			if (multi)
			{
				for (moclass in multi_moclasslist)
				       if (tolower(moclass) ~ Filter1)
		       				motype_scope[++i]=moclass
			}
			else
			{
				for (moclass in attribute_list)
				       if (tolower(moclass) ~ Filter1)
			       			motype_scope[++i]=moclass
			}
			customPrint("\nLoad Proxys for MOs of following type and all subsequent children using the attribute Filter: "Filter2" ...")
			customPrint("===================================================================================")
	        	for (j=1;j<=i;j++) customPrint(motype_scope[j])
			customPrint("===================================================================================")
	        	#customPrint("Please Confirm [y/n]: ","","","noLF")
			if ((confirmation == "noconfirm")||(lt_confirmation==0)) answer="y"
			else answer=Read_Answer(reading_script,"","","","","yesno","Please Confirm [y/n]: ")
	        	if (tolower(answer) ~ /^y+(es)?$/)
	        	{
				answer = ""
				print ""
				for (j=1;j<=i;j++)
				{
					l=0
					#if ( SubLoad_Proxys(12,0,20,motype_scope[j],"") == 1) break
					if ( SubLoad_Proxys(14,motype_scope[j]) == 1) break
					remove_proxy_duplicates()
		        		for (Proxy = 0; Proxy <= maxProxy; Proxy++)
						if ((tolower(p2s("MoType",Proxy)) == tolower(motype_scope[j]))&&(p2s("MoType",Proxy) != ""))
							moprox[++l]=Proxy
					for (k=1;k<=l;k++)
					{
						  if ( SubLoad_Proxys(12,moprox[k],moscope,"",Filter2) == 1) break
					}
				}
				delete motype_scope
				remove_proxy_duplicates()
			}
			else add_to_moscomlog("","%@> Fail (Command aborted)")
		}
	}
	jvm_gc()
}
function ldc(Filter1)
{
	Filter1=$2
	Load_Proxys("ldn")
	$0="lcc "Filter1"$"
	Load_Proxys("childrenlong",20)
}

function make_testclassgroup(    i,j,k,m)
{
	#make an mogroup which contains one MO instance of each MO class
	#this is used for test purpose, to test that certain commands like get, kget, from, work correctly on each MO class
	$0="mr moclass_group" ; buildMoGroup("remove","short","silent")
	for (i in ClassProxy)
	{
		$0="ma moclass_group "ClassProxy[i] ; buildMoGroup("add","short","silent")
		if (i in cppMoList)
		{
			$0="ma "(comcli>0?"com":"cpp")"_moclass_group "ClassProxy[i] ; buildMoGroup("add","short","silent")
			k++
		}
		else
		{
			$0="ma app_moclass_group "ClassProxy[i] ; buildMoGroup("add","short","silent")
			m++
		}
		j++
	}
	if (mosdebug==1)
	{
		customPrint(sprintf("Added %s MOs to group: %s",j,"moclass_group"))
		customPrint(sprintf("Added %s MOs to group: %s",k,"cpp_moclass_group"))
		customPrint(sprintf("Added %s MOs to group: %s",m,"app_moclass_group"))
	}
}

function SubLoad_Proxys(menu_choice,motypeprox,moscope,motypetype,mofilter,silent,   i,j,l,z,mobrowser_error,array,count)
{
	$0=""
	print menu_choice |& TestClient
	if (motypeprox != "") print motypeprox |& TestClient
	if (moscope != "")    print moscope |& TestClient
	if (mofilter != "")
	{
		print motypetype |& TestClient
		print mofilter |& TestClient
	}
	#print "motypeprox " motypeprox " moscope " moscope " motypetype " motypetype " mofilter " mofilter
	while (TestClient |& getline)
	{
		gsub("\r","") ; if (corba_debug >= 1) customPrint($0)
		#print $0
		#if ($1 !~ ")" && NF != 0)
		if ($1 == "Enter_choice_or_type_8_for_help") break
		if (($0 ~ "!!!!")||($0 ~ "org.omg.CORBA")||($0 ~ "(Compiled Code)")||($0 ~ "completed: No"))
		{
			if ($0 ~ "!!!!") { split($0,array,"!!!!") ; customPrint("!!!!" array[2]) }
			else customPrint($0)
		}
		if ($0 ~ "se.ericsson.cello.configtestclient.SimpleMoBrowser.main")
		{
			customPrint($0)
			#dont restart the MO browser in this case since some non-fatal errors like CORBA.TIMEOUT may print the stack trace
			#mobrowser_error = 1
			#break
		}
		if ($0 ~ "java.lang.OutOfMemory")
		{
			customPrint(gensub(/Your choice.* Exception/,"\nException","g",$0))
			mobrowser_error = 1
			break
		}
		if ($0 ~ />>>  \[Proxy ID/)
		{
			add_Proxys_to_table($0)
			if (silent != "silent" && maxProxy != 0)
			{
				count++
				if (PrintProxySilent == 0)
				{
					if (PrintProxyLDN==0) printf("\rLoading Proxy Information: %s", maxProxy)
					else  printf("\r%-5s%s",maxProxy,p2s("Mo",maxProxy))
				}
			}
		}
	}
	if (mobrowser_error == 1 || $1 !=  "Enter_choice_or_type_8_for_help")
	{
		if (mobrowser_error != 1) customPrint($0)
		customPrint("\nMoBrowser got disconnected, reconnecting ...")
		if (multi) ReConnectNeal(2)
		else ReConnect(5,0,"","","ltall")
	}
	else mobrowser_error = 0
	if (silent != "silent" && maxProxy != 0 && count > 0)
	{
		if (PrintProxySilent==1) customPrint(sprintf("Last MO: %5s. Loaded %4s MOs. Total: %5s MOs."(menu_choice==14 ? " MO Class: "motypeprox"." : ""),maxProxy,count,count_nr_of_mos()))
		else if (PrintProxySilent==0) print ""
	}
	return mobrowser_error
}
function clear_comcli_proxy_counts()
{
	showmibOk=0
	cliMode="unknown"
	comOk=0
	inmib=0
	countMo=-1
	mib_maxProxy=-1
	dn_prefix=""
}
function clear_internal_proxy_table()
{
	maxProxy=0
	delete Ldn
	delete origLdn
	delete MoProxy
	delete DirectMeChildren
	delete motypeToFindAlreadyLoaded
	delete nrOfMoTypes
	delete modataId
	delete mimTable
	delete ClassProxy
	motypeTable_hasbeenmade=0
	modataRev_hasbeenmade=0
	mimLength=0
	ltall_done=0
}
function remove_proxy_duplicates_obsolete(   i,l,Mo_norepl,Mo_norepl_index,modn)
{
	#Removing duplicate MO references from internal table
	for (l=0;l<=maxProxy;l++)
	{
		Mo_norepl[p2s("Mo",l)]=l
	}
	for (modn in Mo_norepl)
	{
		Mo_norepl_index[Mo_norepl[modn]]=modn
	}
	for (l=0;l<=maxProxy;l++)
	{
		if (Mo_norepl_index[l]=="")
		{
			#print Ldn[l],tolower(s2t(Ldn[l])),nrOfMoTypes[tolower(s2t(Ldn[l]))]
			nrOfMoTypes[tolower(s2t(Ldn[l]))]--
			delete Ldn[l]
		}
	}
	make_directMeChildrenString()
	if (exclude_deprecated>0 && mom_version ~ /^ERBS_NODE_MODEL_[D-Z]/)
	{
		#hide the MOs SystemConstants and RbsConfiguration under ENodeBFunction=1 -> to use the ones under NodeManagement instead
		hide_obsolete_mo("ManagedElement=1,ENodeBFunction=1,SystemConstants=1","ManagedElement=1,NodeManagementFunction=1,SystemConstants=1")
		hide_obsolete_mo("ManagedElement=1,ENodeBFunction=1,RbsConfiguration=1","ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1")
	}
	populate_origLdn()
	#VERY IMPORTANT TO PRINT THE STUFF BELOW FOR DEBUGGING
	#for (l=0;l<=maxProxy;l++) printf("%sX%sX%sX%sX%sX%s\n",l,Ldn[l],l2m(Ldn[l]),MoProxy[l2m(Ldn[l])],MoProxy[tolower(l2m(Ldn[l]))],tolower(s2t(Ldn[l])),nrOfMoTypes[tolower(s2t(Ldn[l]))])
}
function remove_proxy_duplicates(   i,l,Mo_norepl,moty)
{
	#Removing duplicate MO references from internal table
	delete Mo_norepl
	for (l=maxProxy;l>=0;l--)
	{
		#if (l in Ldn && Ldn[l]!="") print l,Ldn[l]
		if (Mo_norepl[Ldn[l]]==1)
		{
			moty=tolower(s2t(Ldn[l]))
			if (moty!="") nrOfMoTypes[moty]--
			delete Ldn[l]
		}
		else if (Ldn[l]=="") delete Ldn[l]
		else Mo_norepl[Ldn[l]]=1
	}
	make_directMeChildrenString()
	if (exclude_deprecated>0 && mom_version ~ /^ERBS_NODE_MODEL_[D-Z]/)
	{
		#hide the MOs SystemConstants and RbsConfiguration under ENodeBFunction=1 -> to use the ones under NodeManagement instead
		hide_obsolete_mo("ManagedElement=1,ENodeBFunction=1,SystemConstants=1","ManagedElement=1,NodeManagementFunction=1,SystemConstants=1")
		hide_obsolete_mo("ManagedElement=1,ENodeBFunction=1,RbsConfiguration=1","ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1")
	}
	populate_origLdn()
	#VERY IMPORTANT TO PRINT THE STUFF BELOW FOR DEBUGGING
	#for (l=0;l<=maxProxy;l++) printf("%sX%sX%sX%sX%sX%s\n",l,Ldn[l],l2m(Ldn[l]),MoProxy[l2m(Ldn[l])],MoProxy[tolower(l2m(Ldn[l]))],tolower(s2t(Ldn[l])),nrOfMoTypes[tolower(s2t(Ldn[l]))])
}
function populate_origLdn(  i)
{
	#always populate the table origLdn in comcli
	if (comcli == 0) return
	for (i in Ldn)
	{
		if (origLdn[i]=="") origLdn[i]=correct_mo_spaces(Ldn[i])
	}
}
function hide_obsolete_mo(oldmo,newmo,    l)
{
	for (l=0;l<=maxProxy;l++)
	{
		if (Ldn[l]==newmo)
		{
			for (l=0;l<=maxProxy;l++)
			{
				if (Ldn[l]==oldmo)
				{
					nrOfMoTypes[tolower(s2t(Ldn[l]))]--
					delete Ldn[l]
				}
			}
		}
	}
}
function make_directMeChildrenString(   l)
{
	directMeChildrenString=""
	for (l in DirectMeChildren) directMeChildrenString=sprintf("%s|%s",directMeChildrenString,DirectMeChildren[l])
	sub(/^\|/,"",directMeChildrenString)
	directMeChildrenString=sprintf("^(%s),",directMeChildrenString)
	#print "directMeChildrenString: "directMeChildrenString
}

function count_nr_of_mos(    i,count)
{
	#sometimes, there is an empty element which sneaks into the table, eg after doing get mo attr > $var
	#therefore we need to only increment the count if the element is not empty
	for (i in Ldn) if (Ldn[i] != "") count++
	return count
}
function add_Proxys_to_table(line,   array,z,i,tmpclass,last,tstring,tclass,old_tclass)
{
	#if (line != "") print line
	if (line !~ />>>  \[Proxy ID/) return
	if (multi || multioffline) return add_Proxys_to_table_MULTI(line)
	split(line,array,/>>>  \[Proxy ID = /)
	split(array[2],array,/\] MO name :/)
	maxProxy=array[1]
	if (maxProxy == 0)
	{
		#>>>  [Proxy ID = 0] MO name :SubNetwork=ONRM_RootMo,MeContext=MGW04,ManagedElement=1 MO type :ManagedElement
		split(line,array,"MO name :")
		split(array[2],array," MO type :")
		gsub(/ *$/,"",array[1])
		Ldn[0]="ManagedElement="gensub(/^.*ManagedElement=/,"",1,array[1])
		MoProxy[tolower(Ldn[0])]=MoProxy[Ldn[0]]=0
		#in CPP and COMCLI offline against kget, the MibPrefix is read from the ManagedElement MO FDN
		#in COMCLI online and offline showall, the mibprefix is read from dnPrefix attribute
		if (comcli==0)
		{
			MibPrefix=fix_mibprefix(gensub(/,*ManagedElement=[^,]+/,"",1,array[1]))
			ClassProxy["ManagedElement"]=0
			customPrint("Connected to "node_address" ("array[1]")")
		}
		else if (comcli>0)
		{
			#in COM nodes, the ManagedElement MO can be different than 1 and also have a space in the name, eg ManagedElement=RBS 32
			if (mospace_convert==1 && Ldn[0] ~ / /)
			{
				#we change the LDN to replace the white space with space_sign
				origLdn[0]=Ldn[0]
				gsub(/ /,space_sign,Ldn[0])
				#put quotes around the MO name if there is spaces in it, eg: ManagedElement="Node Name"
				origLdn[0]=gensub(/=/,"=\"",1,origLdn[0])"\""
				ComMe=origLdn[0]
				MoProxy[Ldn[0]]=maxProxy
				MoProxy[tolower(Ldn[0])]=maxProxy
			}
			if (node ~ /^OFFLINE_/)
			{
				MibPrefix=fix_mibprefix(gensub(/,*ManagedElement=[^,]+/,"",1,array[1]))
				ComMe=Ldn[0]
				assignCustomVar("$Me",ComMe,"","system")
			}
		}
	}
	else
	{
		#>>>  [Proxy ID = 1] MO name :ManagedElement=1,Equipment=1,Subrack=3,Slot=28,PlugInUnit=1
		#>>>  [Proxy ID = 2] MO name :ManagedElement=1,RncFunction=1,IubLink=iub 999
		Ldn[maxProxy]=gensub(/^.*MO name :/,"",1,line)
		MoProxy[l2m(Ldn[maxProxy])]=maxProxy
		MoProxy[tolower(l2m(Ldn[maxProxy]))]=maxProxy
		split(Ldn[maxProxy],array,",")
		DirectMeChildren[array[2]]=array[2]
		tmpclass=tolower(s2t(Ldn[maxProxy]))
		if (comcli==0)
		{
			ClassProxy[tmpclass]=maxProxy
			nrOfMoTypes[tmpclass]++
		}
		if (mospace_convert==1 && Ldn[maxProxy] ~ / /)
		{
			#we change the LDN to replace the white space with space_sign
			origLdn[maxProxy]=Ldn[maxProxy]
			gsub(/ /,space_sign,Ldn[maxProxy])
			MoProxy[l2m(Ldn[maxProxy])]=maxProxy
			MoProxy[tolower(l2m(Ldn[maxProxy]))]=maxProxy
			if (comcli>0)
			{
				gsub(space_sign," ",origLdn[maxProxy])
				#put quotes around all the MO ids in the origLdn
				gsub(/,/,"\",",origLdn[maxProxy])
				gsub(/=/,"=\"",origLdn[maxProxy])
				origLdn[maxProxy]=origLdn[maxProxy]"\""
				MoProxy[l2m(origLdn[maxProxy])]=maxProxy
				MoProxy[tolower(l2m(origLdn[maxProxy]))]=maxProxy
			}
		}
		#print ""
		#print "DirectMeChildrenString:"directMeChildrenString
		#print DirectMeChildren[array[2]], Ldn[maxProxy],l2m(Ldn[maxProxy]),maxProxy,MoProxy[l2m(Ldn[maxProxy])]
		#print tolower(l2m(Ldn[maxProxy])),maxProxy
		#print tolower(s2t(Ldn[maxProxy])),nrOfMoTypes[tolower(s2t(Ldn[maxProxy]))]
	}
	if (comcli>0)
	{
		tstring=""
		last=split(Ldn[maxProxy],array,",")
		for (i=1;i<=last;i++)
		{
			tclass=gensub(/=.*$/,"",1,array[i])
			if (tclass!=old_tclass) tstring=tstring"."tclass  #in the case where we have recursive MOs like FileGroup=xxx,FileGroup=yyy,FileGroup=zzz
			#else { if (mosdebug==1) print "Recursive MO: "Ldn[maxProxy] }
			old_tclass=tclass
		}
		#print tstring,mimMap[tstring]
		mimTable[maxProxy]=mimMap[tstring]
		tmpclass=tolower(mimTable[maxProxy]"."gensub(/=.*$/,"",1,array[last]))
		nrOfMoTypes[tmpclass]++
		ClassProxy[tmpclass]=maxProxy
		if (length(mimMap[tstring]) > mimLength) mimLength=length(mimMap[tstring])
	}
}
function add_Proxys_to_table_MULTI(line,    array,z,i,tmpclass,currentnode,fdn,root,ldn)
{
	#>>>  [Proxy ID = 0] MO name :134.138.65.24;ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 3] MO name :137.58.194.43;ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 4] MO name :172.31.68.99;SubNetwork=ONRM_ROOT_MO,MeContext=MGW1,ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 3397] MO name :172.31.68.99;SubNetwork=ONRM_ROOT_MO,MeContext=MGW1,ManagedElement=1,AccessSignalling=1,Lapd=acsg_lapd_32
	split(line,array,/>>>  \[Proxy ID = /)
	split(array[2],array,/\] MO name :/)
	maxProxy=array[1]
	if (line ~ /MO type :ManagedElement/) { root=1 ; sub(/ +MO type :ManagedElement.*$/,"",array[2]) } else root=0
	split(array[2],array,";")
	if (multioffline && (!(array[1] in nodeName))) nodeName[array[1]]=array[1]
	currentnode=nodeName[array[1]]
	fdn="Me="currentnode","array[2]
	ldn="Me="currentnode","gensub(/^.*,ManagedElement=1/,"ManagedElement=1",1,fdn)
	if (root)
	{
		MibPrefixTable["Me="currentnode]=gensub(/ManagedElement=1/,"",1,array[2])
		customPrint(sprintf("Connected to %-15s (%s)",array[1],fdn))
	}
	Ldn[maxProxy]=ldn
	MoProxy[l2m(Ldn[maxProxy])]=maxProxy
	MoProxy[tolower(l2m(Ldn[maxProxy]))]=maxProxy
	split(Ldn[maxProxy],array,",")
	DirectMeChildren[array[3]]=array[3]
	tmpclass=tolower(s2t(Ldn[maxProxy]))
	nrOfMoTypes[tmpclass]++
	ClassProxy[tmpclass]=maxProxy
	if (mospace_convert==1 && Ldn[maxProxy] ~ / /)
	{
		#we change the LDN to replace the white space with space_sign
		origLdn[maxProxy]=Ldn[maxProxy]
		gsub(/ /,space_sign,Ldn[maxProxy])
		MoProxy[l2m(Ldn[maxProxy])]=maxProxy
		MoProxy[tolower(l2m(Ldn[maxProxy]))]=maxProxy
	}
	#print ""
	#print "DirectMeChildrenString:"directMeChildrenString
	#print DirectMeChildren[array[2]], Ldn[maxProxy],l2m(Ldn[maxProxy]),maxProxy,MoProxy[l2m(Ldn[maxProxy])]
	#print tolower(l2m(Ldn[maxProxy])),maxProxy
	#print tolower(s2t(Ldn[maxProxy])),nrOfMoTypes[tolower(s2t(Ldn[maxProxy]))]
}
function transform_mib_line(line,mibtype,  dn,last,i,array,tmp_motype,res,me)
{
	#Note: mib_maxProxy is a global variable
	$0=line
	#print mibtype,$0
	if ($1==">>>") return ""
	if (mibtype=="kget" && $1=="MO" && $2~"ManagedElement=")
	{
		#Proxy Id                             1
		#MO                                   Me=rnc11,SubNetwork=RNS1,MeContext=RNC11,ManagedElement=1,Equipment=1
		#MO                                   SubNetwork=OSS27_RootMo_R,SubNetwork=RNC37,MeContext=RNC37,ManagedElement=1
		#MO                                   SubNetwork=OSS27_RootMo_R,SubNetwork=RNC37,MeContext=RNC37,ManagedElement=1,ManagedElementData=1
		#MO                                   SubNetwork=OSS27_RootMo_R,SubNetwork=RNC37,MeContext=RNC37,ManagedElement=1,Licensing=1,RncFeature=RabCombination 024
		#MO                                   MGW_NODE_MODEL_R5_1,ManagedElement=1,ManagedElementData=1
		if ($2 ~ /^Me=/) { me=gensub(/^Me=|,.*$/,"","g",$2) ; sub(/^Me=[^,]+,/,"",$2) }
		if ($2~/,ManagedElement=[^,]+$/) dn=$2  #for the ManagedElement we give the FDN so that the MibPrefix can be known
		else dn=gensub(/^MO +.*ManagedElement=/,"ManagedElement=",1,$0)
	}
	else if (mibtype=="geta" && $1~/^[0-9]+$/ && $2~/^[A-Z][-_a-zA-Z0-9]+=/)
	{
		#0                                    Me=rnc11,ManagedElement=1
		#1                                    Me=rnc11,ManagedElementData=1
		#5                                    Licensing=1,RncFeature=RabCombination 024
		if ($2 ~ /^Me=/) { me=gensub(/^Me=|,.*$/,"","g",$2) ; sub(/^Me=[^,]+,/,"",$2) }
		dn=gensub(/^[0-9]+ +/,"",1,$0)
		if (dn !~ /ManagedElement=[^,]+$/) dn=Ldn[0]","dn
	}
	else if (mibtype~/^getp*$/ && $(ATT_POS) in first_attribute_table)
	{
		#mibtype=get
		#    ManagedElement=1                                       ManagedElementId  1
		#    ManagedElementData=1                                   ManagedElementDataId 1
		#    Licensing=1,RncFeature=RabCombination024               RncFeatureId      RabCombination 024
		#mibtype=getp
		#    0 ManagedElement=1                                       ManagedElementId  1
		#    1 ManagedElementData=1                                   ManagedElementDataId 1
		#    5 Licensing=1,RncFeature=RabCombination024               RncFeatureId      RabCombination 024
		dn=$(MO_POS)
		tmp_motype=s2t(dn)
		if (dn ~ /^Me=/) { me=gensub(/^Me=|,.*$/,"","g",dn) ; sub(/^Me=[^,]+,/,"",dn) }
		if (! (tmp_motype in mom_DirectMeChildren)) dn=dn_prefix dn
		else
		{
			dn=Ldn[0]","dn
			dn_prefix=dn","
		}
	}
	else if ($1=="unitType" && $2=="EPB2" && comcli==0 && node~/^OFFLINE_/) cpplinux=1
	if (dn=="") return ""
	#>>>  [Proxy ID = 0] MO name :137.58.194.147;ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 0] MO name :ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 0] MO name :SubNetwork=ONRM_RootMo,MeContext=MGW04,ManagedElement=1 MO type :ManagedElement
	#>>>  [Proxy ID = 1] MO name :ManagedElement=1,Equipment=1,Subrack=3,Slot=28,PlugInUnit=1
	#>>>  [Proxy ID = 2] MO name :ManagedElement=1,RncFunction=1,IubLink=iub 999
	if (me!="") multioffline=1
	if (dn !~ /ManagedElement=[^,]+$/) res=sprintf(">>>  [Proxy ID = %s] MO name :%s%s",++mib_maxProxy,(me!=""?me";":""),dn)
	else res=sprintf(">>>  [Proxy ID = %s] MO name :%s%s MO type :ManagedElement",++mib_maxProxy,(me!=""?me";":""),dn)
	if (mibtype ~ /^getp*$/ || (comcli>0 && com_mibtype=="showall"))
	{
		mib_sline_proxy[mibline]=mib_maxProxy
		if (mib_maxProxy==0) mibline_FIRST=mibline
		else mib_eline[mib_maxProxy-1]=mibline-1
	}
	else
	{
		mib_sline_proxy[mibline+2]=mib_maxProxy
		if (mib_maxProxy==0) mibline_FIRST=mibline+2
		else if (mibtype == "kget") mib_eline[mib_maxProxy-1]=mibline-3
		else mib_eline[mib_maxProxy-1]=mibline-2
	}
	return res
}
function process_showall_line(moclass,proxy,pm,showmoc,   array,part,t_attr,i,t_structname,t_memb,t_line,t_flex)
{
	#ManagedElement=1
	#   dateTimeOffset="-01:00" <read-only>
	#   no dnPrefix
	#   localDateTime="2012-07-14T17:42:19"
	#   managedElementId="1"
	#   networkManagedElementId="1"
	#   siteLocation="Gothenburg"
	#   timeZone="Etc/GMT-01:00"
	#   userLabel=""
	#   productIdentity
	#      productDesignation="product designation"
	#      productNumber="product number"
	#      productRevision="product revision"
	#BufferPendingAuthorization=1
	#accessControlRule
	#  "1001"
	#  "1002"
	#  "1003"
	#  "2001"
	#bufferLimit=5
	#bufferPendingAuthorizationID="1"
	#FmAlarm=8
	#   activeSeverity=CRITICAL <read-only>
	#   eventType=COMMUNICATIONSALARM <read-only>
	#   majorType=193 <read-only>
	#   minorType=3188851032 <read-only>
	#   probableCause=1024 <read-only>
	#   sequenceNumber=8 <read-only>
	#   source="ManagedElement=1,Equipment=1,Slot=24" <read-only>
	#Sgw=1
	# node="PPL9"
	# sgwID="1"
	# statistics()
	# userInfo()
	#NodeBLocalCell=1
	#   nodeBLocalCellId="1"
	#   [Read error code -1] administrativeState
	#   availabilityStatus=OFF_LINE <read-only>
	#   bandwidthDl=50 <default>

	#MOs that have a regular attribute with the same name as a struct member:
        #AuthenticationOrder=1
        #   authenticationOrderId="1"
        #   no userLabel
        #   authenticationMethodOrder <read-only>
        #      methodReference="ManagedElement=1,SystemFunctions=1,SecM=1,UserManagement=1,LdapAuthenticationMethod=1" <read-only>
        #      orderNumber=1 <read-only>
        #      userLabel="" <read-only>

	#This format now handled since 10.0c (was reading the attribute state from the attribute reportProgress.state)
        #UpgradePackage=1
	#   created="2013-10-02T09:42:46" <read-only>
	#   no directoryPathExtension <read-only>
	#   no ignoreBreakPoints
	#   no isLocallyStored <read-only>
	#   no remoteFileStore <read-only>
	#   state=PREPARE_IN_PROGRESS <read-only>
	#   upgradePackageId="1"
	#   no uri <read-only>
	#   no userLabel
	#   activationStep <read-only>
	#      no description
	#      no name
	#      serialNumber=0 <read-only>
	#   administrativeData <read-only>
	#      no description
	#      productionDate="2013-09-19T15:27:38" <read-only>
	#      productName="RBS6401" <read-only>
	#      productNumber="CXP 902 3306/1" <read-only>
	#      productRevision="R27J" <read-only>
	#      no type
	#   reportProgress <read-only>
	#      actionId=0 <read-only>
	#      actionName="prepare()" <read-only>
	#      no additionalInfo
	#      no progressInfo
	#      progressPercentage=0 <read-only>
	#      result=NOT_AVAILABLE <read-only>
	#      no resultInfo
	#      state=RUNNING <read-only>
	#      step=0 <read-only>
	#      stepProgressPercentage=0 <read-only>
	#      no timeActionCompleted
	#      timeActionStarted="2013-10-02T09:44:40" <read-only>
	#      timeOfLastStatusUpdate="2013-10-02T09:45:34" <read-only>
	#   activate()
	#   cancel()
	#   commit()
	#   prepare()
	#   verify()

	#These formats now handled since 10.0k (was reading the attribute state from the attribute reportProgress.state)
        # UpgradePackage=1
        #    created="2014-01-30T10:52:18" <read-only>
        #    directoryPathExtension="" <read-only>
        #    ignoreBreakPoints=""
        #    isLocallyStored="" <read-only>
        #    no remoteFileStore <read-only>
        #    state=WAITING_FOR_COMMIT <read-only>
        #    upgradePackageId="1"
        #    uri="" <read-only>
        #    userLabel=""
        #    activationStep <read-only>
        #       description="" <read-only>
        #       name="" <read-only>
        #       serialNumber=0 <read-only>
        #    administrativeData <read-only>
        #       description="" <read-only>
        #       productionDate="2014-01-23T22:16:08" <read-only>
        #       productName="RBS6401" <read-only>
        #       productNumber="CXP 902 3306/1" <read-only>
        #       productRevision="RND_W_W13B" <read-only>
        #       type="" <read-only>
        #    reportProgress <read-only>
        #       actionId=0 <read-only>
        #       actionName="activate()" <read-only>
        #       additionalInfo[]
        #          "" <read-only>
        #       progressInfo="activate() action finished" <read-only>
        #       progressPercentage=100 <read-only>
        #       result=SUCCESS <read-only>
        #       resultInfo="activate() action successful" <read-only>
        #       state=FINISHED <read-only>
        #       step=0 <read-only>
        #       stepProgressPercentage=0 <read-only>
        #       timeActionCompleted="2010-01-01T00:00:17" <read-only>
        #       timeActionStarted="2014-01-30T10:57:13" <read-only>
        #       timeOfLastStatusUpdate="2010-01-01T00:00:17" <read-only>
        #    activate()
        #    cancel()
        #    commit()
        #    prepare()
        #    verify()

        # UpgradePackage=1
        #    created="2014-03-04T08:01:11" <read-only>
        #    directoryPathExtension="" <read-only>
        #    ignoreBreakPoints=true <default>
        #    isLocallyStored=false <read-only>
        #    no remoteFileStore <read-only>
        #    state=WAITING_FOR_COMMIT <read-only>
        #    upgradePackageId="1"
        #    uri="sftp://iv@10.33.12.232:/home/iv/SMRS/wcdma_daily_build_clean_latest_official" <read-only>
        #    userLabel=""
        #    activationStep <read-only>
        #       description="" <read-only>
        #       name="" <read-only>
        #       serialNumber=1 <read-only>
        #    administrativeData <read-only>
        #       description="" <read-only>
        #       productionDate="2014-02-19T00:08:26" <read-only>
        #       productName="RBS6401" <read-only>
        #       productNumber="CXP 902 3306/1" <read-only>
        #       productRevision="CLN_W_MAINLINE" <read-only>
        #       type="" <read-only>
        #    reportProgress <read-only>
        #       actionId=1 <read-only>
        #       actionName="activate()" <read-only>
        #       additionalInfo[]
        #          "commit() not given, reboot in 840 sec." <read-only>
        #       progressInfo="activate() action finished" <read-only>
        #       progressPercentage=100 <read-only>
        #       result=SUCCESS <read-only>
        #       resultInfo="activate() action successful" <read-only>
        #       state=FINISHED <read-only>
        #       step=0 <read-only>
        #       stepProgressPercentage=0 <read-only>
        #       timeActionCompleted="2010-01-01T00:00:18" <read-only>
        #       timeActionStarted="2014-03-04T08:02:24" <read-only>
        #       timeOfLastStatusUpdate="2010-01-01T00:00:18" <read-only>
        #    activate()
        #    cancel()
        #    commit()
        #    prepare()
        #    verify()


	#New format in COM 3.3 for empty attributes.
	#instead of:
	#      no productIdentity
	#there is:
	#   productIdentity=[] <empty>
	#   reportProgress=[] <empty> <read-only>

	#Messages from transaction participants:
	#Invalid return from getMoAttribute of ManagedElement=1,NodeBFunction=1,NodeBLocalCellGroup=1,NodeBLocalCell=1,administrativeState
	#print showall_instruct,$0

	#if a MO does not exist:
	#>show verbose ManagedElement=1,SystemFunctions=1,Pm=1,PmJob=1,MeasurementReader=1
	#ERROR: Specific element not found
	#EndOfPrint exec<@%>

	#show-counters format:
	#ManagedElement=1,Equipment=1,FieldReplaceableUnit=5,RiPort=DATA_2
	#   pmBitError=[]
	#EthernetPort=TN_C
	#   ifHCInBroadcastPkts=0
	#   ifHCInMulticastPkts=0
	#   ifHCInOctets=0
	#   ifHCInUcastPkts=0
	#   ifHCOutBroadcastPkts=0
	#   ifHCOutMulticastPkts=8
	#   ifHCOutOctets=994
	#   ifHCOutUcastPkts=0
	#   ifInDiscards=0
	#   ifInErrors=0
	#   ifInUnknownProtos=0
	#   ifInUnknownTags=4
	#   ifOutDiscards=0
	#   ifOutErrors=0
	#   pmUsedHsPdschCodes
	#      600
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#      0
	#show-counters new format for sequence:
	#ManagedElement=rbs536,Transport=1,Router=1,TwampInitiator=1,TwampTestSession=2
	#   rxPkts=600, 600, 600, 598, 599, 600, 599, 599, 600, 600, 599, 599, -2, -2, -2
	#   pmPowerConsumption=69, 74, 69, 75, 70, 74, 71, 74, 70, 75, 69, 72, 71, 70, 73, 69, 74, 68, 75, 71, 73, 72, 69, 75, 71, 74, 72, 73, 71, 75, 72, 74, 68, 73, 71, 72, 72, 73, 69, 73, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>, -2 <suspect>
	#
	#show-counters for pmFlex:
	#   pmFlexDrbThpTimeDl_Arp0To15=0
	#   pmFlexDrbThpTimeDl_Arp0To15Lcg0To3=0



	#New format in COM 4.0 for sequence of structs:
	#From :
	#authenticationMethodOrder <read-only>
	#   methodReference="ManagedElement=1,SystemFunctions=1,SecM=1,UserManagement=1,LdapAuthenticationMethod=1" <read-only>
	#   orderNumber=1 <read-only>
	#   userLabel="" <read-only>
	#to:
        #authorizationMethodOrder[@1]
        #   methodReference="ManagedElement=1,SystemFunctions=1,SecM=1,UserManagement=1,LocalAuthorizationMethod=1" <read-only>
        #   orderNumber=1 <read-only>
        #   userLabel="" <read-only>

        #Problem to handle quotes in the attribute value
        # description="A \"subframe\" is a 2 ms TTI for HS-DSCH." <read-only>

        #ERROR: Get attributes failed for 'progressReport', error code: ComFailure

        if (showmoc==1 && comcli_use_showmoc==2) showmoc=2
        if (pm=="pm") gsub(/ <suspect>/,"")

	gsub(/[\\]["]/,"")
	if (($1=="no" && (moclass":"$2 in MoAttributesType && MoAttributesType[moclass":"$2]!="")) || \
	    (showall_instruct!=1 && $1~/=\[\]$/ && ($2=="<empty>" || showmoc==1) && moclass":"gensub(/=..$/,"",1,$1) in MoAttributesType && MoAttributesType[moclass":"gensub(/=..$/,"",1,$1)]!=""))
	{
		if ($1=="no") t_attr=$2 ; else t_attr=gensub(/=..$/,"",1,$1)
		if (MoAttributesType[moclass":"t_attr] ~ "EcimEmpty") mib_table[proxy,t_attr]="false"
		else if (MoAttributesType[moclass":"t_attr] ~ /^sequence:/) mib_table[proxy,t_attr]=gensub(/^ar?/,"",1,MoAttributesTypeJava[moclass":"t_attr])"[0] = "
		else mib_table[proxy,t_attr]="" #<undef>
	}
	else if ($1 ~ /^[^="]+\(\)$/ || ($1 ~ /^[A-Z].*=/ && gensub(/=.*$/,"",1,$1) in com_moclass_list && com_moclass_list[gensub(/=.*$/,"",1,$1)]!=""))
	{
		showall_instruct=0
	}
	else if ((moclass":"$1 in MoAttributesType && MoAttributesType[moclass":"$1]!="")||\
	         (moclass":"gensub(/\[@[0-9]+\]$/,"",1,$1) in MoAttributesType && MoAttributesType[moclass":"gensub(/\[@[0-9]+\]$/,"",1,$1)]!=""))
	{
		sub(/\[@[0-9]+\]$/,"",$1)
		if (moclass":"$1 in MoAttributesType && MoAttributesType[moclass":"$1] ~ "EcimEmpty") mib_table[proxy,$1]="true"
		else showall_attr=$1
		if (MoAttributesType[moclass":"$1] ~ /structRef/)
		{
			showall_instruct=1
			if (showmoc==1)
			{
				#must initialise the value in this case as sometimes nothing will be printed if it has default value
				if ((MoAttributesType[moclass":"$1] ~ /^structRef/) || (!((proxy,showall_attr) in mib_table))) mib_table[proxy,showall_attr]=""
			}
		}
	}
	else if (moclass":"gensub(/=.*$/,"",1,$1) in MoAttributesType && MoAttributesType[moclass":"gensub(/=.*$/,"",1,$1)] ~ /structRef/ && \
	(MoAttributesType[moclass":"gensub(/=.*$/,"",1,$1)] !~ /\.EcimPassword$/))
	{
		#special case, the name of a struct attribute can have the equal sign if it has members of type key
		#TestClass2=1
		# class1="ManagedElement=1,TestRoot=1,TestClass1=1"
		# testClass2Id="1"
		# struct2=1
		#    struct2key=1 <key>
		#    struct2mem1="init"

	        #certificateContent="C=SE,O=Ericsson,CN=cmp1" <read-only>

		#   measurementSpecification
		#      groupRef=[] <empty>
		#      measurementTypeRef="ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=ROPGroup1,MeasurementType=ROPType1Sum"

		#   reportProgress=[] <empty> <read-only>

		#special case, the struct EcimPassword in COMCLI is written on one line, eg: password="iv", so for EcimPassword we don't go here
		showall_attr=gensub(/=.*$/,"",1,$1)
		showall_instruct=1
		t_structname=gensub(/^.*structRef./,"",1,MoAttributesType[moclass":"showall_attr])
		#special case of empty struct like:
		# reportProgress=[] <empty> <read-only>
		#special case of empty sequence of struct like:
		# agentAddressDtls=[] <empty>

		if ($1 ~ /=\[\]$/)
		{
			if (MoAttributesType[moclass":"showall_attr] ~ /^sequence.structRef/) mib_table[proxy,showall_attr]="t[0] = "
			else mib_table[proxy,showall_attr]=""
		}
		else if (showmoc==1 && t_structname in struct_key && struct_key[t_structname]!="")
		{
			#we must include the value of the key attribute because it will not appear among the struct members if "-v" option is not supported (comcli_use_showmoc=1 instead of 2)
			if (MoAttributesType[moclass":"showall_attr] ~ /^structRef/) mib_table[proxy,showall_attr]=SUBSEP struct_key[t_structname]"="gensub(/^[^=]+=["]?|["]?$/,"","g",$0)
			else if (MoAttributesType[moclass":"showall_attr] ~ /^sequence:structRef/) currStructKey=gensub(/^[^=]+=["]?|["]?$/,"","g",$0)
		}
	}
	else if ((moclass":"gensub(/=.*$/,"",1,$1) in MoAttributesType && MoAttributesType[moclass":"gensub(/=.*$/,"",1,$1)]!="" && showall_instruct!=1)||\
	         (pm=="pm" && moclass":"gensub(/=.*$/,"",1,$1) in PmAttributesType && PmAttributesType[moclass":"gensub(/=.*$/,"",1,$1)]!="")||\
	         (pm=="pm" && moclass":"$1 in PmAttributesType && PmAttributesType[moclass":"$1]!="")||\
	         (pm=="pm" && $1 ~ /^pmFlex/ && moclass":"gensub(/_.*$/,"",1,$1) in PmAttributesType && PmAttributesType[moclass":"gensub(/_.*$/,"",1,$1)]!=""))
	{
		#Here the tags are automatically removed for regular attributes
		#List of tags: <default> <deprecated> <empty> <key> <preliminary> <read-only>
		if ("pm"=="pm" && $1 ~ /^pmFlex[^_]+_[^_]+=/)
		{
			t_flex=gensub(/_.*$/,"",1,$1)
			mib_table[proxy,t_flex]=mib_table[proxy,t_flex] SUBSEP gensub(/^[ \t"]*|[ \t"]*$/,"","g",$0)
		}
		else if ($1 ~ /=\"/)
		{
			split($1,array,"=")
			showall_attr=array[1]
			split($0,part,/\"/)
			mib_table[proxy,showall_attr]=part[2]
		}
		#rxPkts=598, 599, 600, 600, 600, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2
		else if (pm=="pm" && $0~/(, -?[0-9]+)+$/)
		{
			split($0,array,"=")
			sub(/^[ \t]+/,"",array[1])
			mib_table[proxy,array[1]]=SUBSEP gensub(/, /,SUBSEP,"g",array[2])
		}
		else if ($1 ~ /=/)
		{
			split($1,array,"=")
			if (array[2]=="[]") array[2]=""
			mib_table[proxy,array[1]]=array[2]
		}
		else
		{
			#   pmUsedHsPdschCodes
			#      600
			#      0
			#      0
			showall_attr=$1
		}
	}
	else if (moclass":"$NF in MoAttributesType && MoAttributesType[moclass":"$NF]!="" && tolower($0) ~ /read error/)
	{
		#   [Read error code -1] administrativeState
		mib_table[proxy,$NF]="!!!! "gensub(/^[ \t]+|[ \t]+[^ ]+$/,"","g",$0)
	}
	else if ($1=="ERROR:" && moclass":"gensub(/\x27|,/,"","g",$6) in MoAttributesType && MoAttributesType[moclass":"gensub(/\x27|,/,"","g",$6)]!="" && tolower($0) ~ /get attributes failed for .*, error code/)
	{
		#ERROR: Get attributes failed for 'progressReport', error code: ComFailure
		mib_table[proxy,gensub(/\x27|,/,"","g",$6)]="!!!! "gensub(/^[ \t]+|[ \t]+$/,"","g",$0)
	}
	else if (NF==0 || tolower($0) ~ /messages from transaction participants:/ || $0 ~ /^Log close: /)
	{
		#Messages from transaction participants:
		#Invalid return from getMoAttribute of ManagedElement=1,NodeBFunction=1,NodeBLocalCellGroup=1,NodeBLocalCell=1,administrativeState
		showall_attr=""
	}
	else if (showall_attr!="")
	{
		t_line=gensub(/=\"/,"=",1,gensub(/^[ \t"]*|[ \t"]*$/,"","g",$0))
		#special handling for sequnce of struct containing key when printed with showmoc=1 and comcli_use_showmoc=1 (instead of 2)
		#we must include the value of the key attribute because it will not appear among the struct members
		if (showmoc==1 && MoAttributesType[moclass":"showall_attr] ~ /^sequence:structRef/)
		{
			t_structname=gensub(/^.*structRef./,"",1,MoAttributesType[moclass":"showall_attr])
			if (t_structname in struct_key && struct_key[t_structname]!="")
			{
				#key,v,x
				#x,key,v
				#x,v,key
				t_memb=gensub(/=.*$/,"",1,t_line)
				if (sorted_struct_contents[t_structname]~ sprintf("(^|,)%s,%s(,|$)",struct_key[t_structname],t_memb))  t_line=struct_key[t_structname]"="currStructKey SUBSEP t_line
				else if (sorted_struct_contents[t_structname]~ sprintf("(^|,)%s,%s$",t_memb,struct_key[t_structname])) t_line=t_line SUBSEP struct_key[t_structname]"="currStructKey
			}
		}
		#now the general processing
		mib_table[proxy,showall_attr]=mib_table[proxy,showall_attr] SUBSEP t_line
	}
	else if (/^ERROR: (Specific element|MO|Command) not found|^ERROR: The DN is invalid/)
	{
		split(sorted_attribute_list[moclass],array,",")
		for (i in array) mib_table[proxy,array[i]]="!!!! "$0
	}
	#clear showall_attr if we know it is an attribute that can only contain one line, eg, the moId attribute
	#otherwise, some other lines might end up in this attribute, eg, if there are more attributes printed that are not in the MOM
	#In the case below, the attribute userLabel was not part of the MOM and ended up in the value of iubDataStreamsId
	#IubDataStreams=1
	#   hsDataFrameDelayThreshold=60 <default>
	#   iubDataStreamsId="1"
	#   maxHsRate=15 <default>
	#   noOfCommonStreams=[] <empty> <read-only>
	#   noOfDedicatedStreams=0 <read-only>
	#   userLabel=[] <empty>
	if (showall_attr!="" && attr_comments[moclass,showall_attr]~/key/) showall_attr=""

}
function remove_comcli_attribute_tags(val)
{
	#List of tags:
	#<default> <deprecated> <empty> <key> <preliminary> <read-only>
	#List of tag combinations:
	#<default>
	#<default> <deprecated>
	#<default> <preliminary>
	#<default> <read-only>
	#<empty>
	#<empty> <deprecated>
	#<empty> <preliminary>
	#<empty> <read-only>
	#<empty> <read-only> <deprecated>
	#<empty> <read-only> <preliminary>
	#<key> <read-only>
	#<key> <read-only> <deprecated>
	#<read-only>
	#<read-only> <deprecated>
	#<read-only> <preliminary>

	#remove end quote and tags
	sub(/["]?( *<(key|read-only|deprecated|default|preliminary|default> <deprecated)>)*$/,"",val)
	return val
}
function populate_mib_table(  proxy,i,j,array,last,moclass,attr,this_is_an_attr_line,proxyCount,part,tmp_type,k,mib_index,readmib_command)
{
	customPrint("Preparing offline MIB:","","force")
	customPrint(sprintf("%-47s%-47s%s","0%","~50%","~100%"),"","force")
	delete mib_table  #global table containing all attribute values
	mibline=0
	if (mibfile ~ /\.(gz|GZ)$/) readmib_command="gzip -dc "mibfile ; else readmib_command="cat "mibfile
	if (mosdebug==1) print mibtype,mibline_FIRST,mib_maxProxy,mib_eline[mib_maxProxy]
	while (readmib_command |& getline)
	{
		gsub("\r","") ; gsub("\x000","") ; mibline++
		if (mibline < mibline_FIRST) continue
		if (mibline > mib_eline[mib_maxProxy]) break
		if (mibline in mib_sline_proxy)
		{
			proxy=mib_sline_proxy[mibline]
			proxyCount++
			if ((100*proxyCount - mib_maxProxy) >=0) { printf "." ; proxyCount=0 }
			moclass=p2s("MoType",proxy)
			attr=""
			showall_attr=""
		}
		if (mibline > mib_eline[proxy]) continue
		if (comcli>0 && com_mibtype=="showall")
		{
			process_showall_line(moclass,proxy)
			continue
		}
		if ($1 != ">>>")
		{
			if (mibtype=="kget")
			{
				if ($1 == "Struct")
				{
					attr=$2
					mib_table[proxy,attr]="Struct{"gensub(/^.* has +| +members: *$/,"","g",$0)"}"
					continue
				}
				else if (moclass":"$1 in ExtendedMoAttributesType)
				{
					attr=$1
					mib_table[proxy,attr]=gensub(/^[^ ]+ +/,"",1,$0)
					continue
				}
				else if ($1 ~ /\]$/)
				{
					split($1,part,/\[|\]/)
					if (moclass":"part[1] in ExtendedMoAttributesType)
					{
						attr=part[1]
						tmp_type=""
						if (moclass":"attr in MoAttributesTypeJava) tmp_type=gensub(/^a*r*/,"",1,MoAttributesTypeJava[moclass":"attr])
						mib_table[proxy,attr]=tmp_type"["part[2]"] = "gensub(/^[^ ]+ +/,"",1,$0)
						if (translate_sequence_enum==1 && ExtendedMoAttributesType[moclass":"attr]~/^sequence:enumRef/ && mib_table[proxy,attr]!~/ \(.*\)/) mib_table[proxy,attr]=parse_attribute(moclass,attr,mib_table[proxy,attr])
						continue
					}
				}
			}
			else if (mibtype=="geta" && moclass":"$1 in ExtendedMoAttributesType)
			{
				attr=$1
				mib_table[proxy,attr]=gensub(/^[^ ]+ +/,"",1,$0)
				if (translate_sequence_enum==1 && ExtendedMoAttributesType[moclass":"attr]~/^sequence:enumRef/ && mib_table[proxy,attr]!~/ \(.*\)/) mib_table[proxy,attr]=parse_attribute(moclass,attr,mib_table[proxy,attr])
				continue
			}
			else if (mibtype=="get" && moclass":"$2 in ExtendedMoAttributesType)
			{
				attr=$2
				mib_table[proxy,attr]=gensub(/^[^ ]+ +[^ ]+ +/,"",1,$0)
				if (translate_sequence_enum==1 && ExtendedMoAttributesType[moclass":"attr]~/^sequence:enumRef/ && mib_table[proxy,attr]!~/ \(.*\)/) mib_table[proxy,attr]=parse_attribute(moclass,attr,mib_table[proxy,attr])
				continue
			}
			else if (mibtype=="getp" && moclass":"$3 in ExtendedMoAttributesType)
			{
				attr=$3
				mib_table[proxy,attr]=gensub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +/,"",1,$0)
				if (translate_sequence_enum==1 && ExtendedMoAttributesType[moclass":"attr]~/^sequence:enumRef/ && mib_table[proxy,attr]!~/ \(.*\)/) mib_table[proxy,attr]=parse_attribute(moclass,attr,mib_table[proxy,attr])
				continue
			}
		}
		mib_table[proxy,attr]=mib_table[proxy,attr]"\n"$0
	}
	close(readmib_command)
	if (comcli>0 && com_mibtype=="showall")
	{
		process_com_mib()
		if (MibPrefix=="") MibPrefix=fix_mibprefix(mib_table[0,"dnPrefix"])
	}
	print ""
	#for (i in mib_table) if (i~ /^0/) print i,mib_table[i]
	delete mib_sline_proxy
	delete mib_eline
	if (check_append_testmom()==0) append_testmomdump_attributes()
	#SQL method:do the last MO
	#for (mib_index in mib_table)
	#{
	#	split(mib_index,array,SUBSEP)
	#	print array[1]"|"array[2]"|"gensub(/\n/,"","g",mib_table[mib_index]) >> "/cygdrive/c/3"
	#}
	#delete mib_table
}
function process_com_mib(pm,notranslate,showmoc,   i,array,moclass,last,part,j,attr,tmpenum,nr_elems,members,k,m,structname,structmember,structval,z,y,a,b,c,addmemb,nr_empty,tsmember,arry,firstmember)
{
	if (comcli==0) return
	if (causeTableMade!=1) make_causeTable()
	if (showmoc==1 && comcli_use_showmoc==2) showmoc=2
	for (i in mib_table)
	{
		split(i,array,SUBSEP)
		moclass=p2s("MoType",array[1])
		attr=array[2]
		#print i,moclass,attr,gensub(SUBSEP,"<SUBSEP>","g",mib_table[i])
		if (mib_table[i] ~ /^!!!! /) {} # the value contains an exception
		#else if (pm=="pm" && moclass":"attr in PmAttributesType) {print moclass,attr,mib_table[i]}
		else if (moclass":"attr in MoAttributesType && MoAttributesType[moclass":"attr] ~ /^structRef/)
		{
			z=0
			structname=gensub(/^structRef./,"",1,MoAttributesType[moclass":"attr])
			nr_members=split(struct_contents[structname],members,",")
			last=split(mib_table[i],part,SUBSEP)
			for (j in part)
			{
				#   lastModification=OPERATOR_MODIFICATION <read-only>
				#      a5Thr2RsrqFreqQciOffset=0 <default>
				#      lbA4ThresholdRsrpOffset=0 <default> <deprecated>
				#   fingerprintUpdateable=true <read-only> <preliminary>
				#   capacityAlarmHysteresis=5 <default> <preliminary>
				#   referenceToLicenseServer=[] <empty> <preliminary>
				#sub(/ <preliminary>$/,"",part[j])
				#sub(/["]?( *<(key|read-only|deprecated|default|default> <deprecated)>)*$/,"",part[j]) #remove end quote and tags
				part[j]=remove_comcli_attribute_tags(part[j])
				#print j,part[j]
			}
			if (use_netconf==0 && structname ~ /EcimPassword$/)
			{
				mib_table[i]="Struct{2}\n >>> 1.cleartext = "(part[1]~/^1:/||length(part[1])>=30?"false":"true")"\n >>> 2.password = "part[1]
			}
			else
			{
				#   reportProgress
				#      actionName="" <read-only>
				#      additionalInfo[]
				#         "" <read-only>
				#      progressInfo="" <read-only>
				#      no progressPercentage <read-only>

				#   measurementSpecification
				#      groupRef=[] <empty>
				#      measurementTypeRef="ManagedElement=1,SystemFunctions=1,Pm=1,PmGroup=ROPGroup1,MeasurementType=ROPType1Sum"

			        #struct containing a sequence member
		                #certificateContent="C=SE,O=Ericsson,CN=cmp1" <read-only>
		                #   extensionContent
		                #      "SubjectKeyIdentifier: 3b:d2:be:67:99:0e:5f:dc:88:7e:94:98:15:80:bd:c6:61:8e:58:e8"
		                #      "AuthorityKeyIdentifier.keyIdentifier: 3b:d2:be:67:99:0e:5f:dc:88:7e:94:98:15:80:bd:c6:61:8e:58:e8"
		                #      "BasicConstraints.CA: true" <read-only>
		                #   issuer="C=SE,O=Ericsson,CN=cmp1" <read-only>
		                #   keyUsage=[] <empty>

			        #A struct member of type sequence:
			        # acBarringForMoSignalling
			        #    acBarringFactor=95 <default>
			        #    acBarringForSpecialAC <default>
			        #       false
			        #       false
			        #       false
			        #       false
			        #       false
			        #    acBarringTime=64 <default>

				#A struct member of type type sequence containing moRefs:
				#   lowLoadDistributionInfo
				#      eUtranFreqRefList
				#         "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1,EUtranFrequency=1"
				#         "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1,EUtranFrequency=2"
				#         "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1,EUtranFrequency=3"
				#      freqDistributionList
				#         20
				#         30
				#         50

				mib_table[i]="Struct{"(last>1?nr_members:0)"}"
				for (j=2;j<=last;j++)
				{
					#handling of structmember of type EcimEmpty, eg DMXC_T_L3_InterfaceIPv4.InterfaceIPv4::encapsulation::loopback in BSP MOM
					tsmember=gensub(/=.*$/,"",1,part[j])
					if ((structname,tsmember) in struct_type && struct_type[structname,tsmember]~/\.EcimEmpty$/)
					{
						#Example when the struct member has value true
						#   encapsulation
						#      loopback
						#Example when the struct member has value false
						#   encapsulation
						#      loopback=[] <empty>
						if (part[j]!~/=/) part[j]=tsmember"=true"
						else part[j]=tsmember"=false"
					}

					if (part[j] ~ /^no /) part[j]=gensub(/^no /,"",1,part[j])"="
					else if (part[j] ~ /\[\] <empty>$/) part[j]=gensub(/\[\] <empty>$/,"",1,part[j])
					else if ((part[j] ~ /^[^ \t"=]+=/ && part[j]!~/^ManagedElement=/)||\
					         ((structname,part[j]) in struct_type && struct_type[structname,part[j]] ~ /sequence/))
					{
						if ((structname,part[j]) in struct_type && struct_type[structname,part[j]] ~ /sequence/)
						{
							#a struct member of type sequence does not have a equal sign after the member name. We add it here
							part[j]=part[j]"="
						}
						structmember=gensub(/=.*$/,"",1,part[j])
						structval=gensub(/^[^=]+=/,"",1,part[j])
						if ((structname,structmember) in struct_type && struct_type[structname,structmember] ~ /enumRef/)
						{
							tmpenum=gensub(/^enumRef:/,"",1,struct_type[structname,structmember])
							if ((tmpenum,structval) in enum && enum[tmpenum,structval]!="") part[j]=structmember"="enum[tmpenum,structval] (notranslate=="notranslate"?"":" ("structval")")

						}
						#This part seems not necessary, the ManagedElement is already getting cut off , eg in attribute like MeasurementReader::measurementSpecification
						#else if ((structname,structmember) in struct_type && struct_type[structname,structmember] ~ /^moRef/)
						#{
						#	part[j]=structmember"="gensub(/^.*ManagedElement=[^,]+,/,"",1,structval)
						#}
					}
					else if (part[j] ~ /^[^ \t\["]+\[\]$/)
					{
						part[j]=gensub(/\[.*$/,"",1,part[j])"="
					}
					else
					{
						mib_table[i]=gensub(/ $/,"",1,mib_table[i])" "part[j]
						continue
					}
					mib_table[i]=mib_table[i]"\n >>> "++z"."gensub(/= */," = ",1,part[j])
				}
				if (showmoc==1 && z<nr_members)
				{
					delete addmemb
					k=0
					nr_empty=0
					c=split(mib_table[i],b,"\n")
					for (j in b) sub(/^ >>> [0-9]+\./,"",b[j])
					delete b[1]  #the part with Struct{xx}
					c=asort(b)
					#the show -m/-p does not show the struct members with default value so we put them here
					for (y in attr_default)
					{
						split(y,a,SUBSEP)
						if (a[1]!=structname) continue
						ok=0
						for (j in b) { if (b[j] ~ sprintf("^%s =",a[2])) ok=1 }
						if (ok==1) continue
						addmemb[++k]=a[2]" = "gensub(/,/," ","g",attr_default[y])
						if (attr_default[y]=="") nr_empty++
					}
					if (k>0)
					{
						z=0
						for (j=1;j<=k;j++) b[++c]=addmemb[j]
						c=aisort(b)
						for (j=1;j<=c;j++) if (b[j]!="") z++
						if (z!=nr_empty) #if the number of added empty members is equal to the number of struct members then put Struc{0}
						{
							z=0
							mib_table[i]="Struct{"nr_members"}"
							for (j=1;j<=c;j++) if (b[j]!="") mib_table[i]=mib_table[i] "\n >>> "++z"."b[j]
						}
					}
				}
				else if (showmoc==1 && structname in struct_key && struct_key[structname]!="")
				{
					z=0
					c=split(mib_table[i],b,"\n")
					for (j in b) sub(/^ >>> [0-9]+\./,"",b[j])
					delete b[1]  #the part with Struct{xx}
					c=aisort(b)
					mib_table[i]="Struct{"nr_members"}"
					for (j=1;j<=c;j++) if (b[j]!="") mib_table[i]=mib_table[i] "\n >>> "++z"."b[j]
				}
			}
		}
		if (mib_table[i] ~ SUBSEP && moclass":"attr in PmAttributesType && (PmAttributesType[moclass":"attr] ~ /^sequence:/ || attr ~ /^pmFlex/))
		{
			last=split(mib_table[i],part,SUBSEP)
			nr_elems=last-1
			if (attr ~ /^pmFlex/)
			{
				mib_table[i]="Struct{"nr_elems"}"
				for (j=2;j<=last;j++) mib_table[i]=mib_table[i] "\n >>> "j-1"." gensub(/=/," = ",1,part[j])
			}
			else
			{
				mib_table[i]=(PmAttributesType[moclass":"attr] ~ /^sequence:longlong/?"l":"i")"["nr_elems"] = "
				for (j=2;j<=last;j++) mib_table[i]=mib_table[i] part[j]" "
			}
		}
		else if (mib_table[i] ~ SUBSEP && moclass":"attr in MoAttributesType && MoAttributesType[moclass":"attr] ~ /^sequence:/)
		{
			last=split(mib_table[i],part,SUBSEP)
			for (j in part)
			{
				#sub(/ <preliminary>$/,"",part[j])
				#sub(/["]?( *<(key|read-only|default|default> <deprecated)>)*$/,"",part[j]) #remove end quote and tags
				part[j]=remove_comcli_attribute_tags(part[j])
			}
			#print moclass,attr,MoAttributesType[moclass":"attr]
			if (MoAttributesType[moclass":"attr] ~ /^sequence:structRef/)
			{
				structname=gensub(/^sequence:structRef./,"",1,MoAttributesType[moclass":"attr])
				nr_members=split(struct_contents[gensub(/^.*structRef./,"",1,MoAttributesType[moclass":"attr])],members,",")
				#nr_elems=sprintf("%.0f",mDiv(last-1,nr_members))
				firstmember=gensub(/,.*$/,"",1,sorted_struct_contents[gensub(/^.*structRef./,"",1,MoAttributesType[moclass":"attr])])
				nr_elems=split(mib_table[i],arry,sprintf("%s%s(%s|=| )",SUBSEP,firstmember,SUBSEP))-1
				k=-1
				m=0
			}
			else nr_elems=last-1
			mib_table[i]=gensub(/^a?r?/,"",1,MoAttributesTypeJava[moclass":"attr])"["nr_elems"] = "
			if (MoAttributesType[moclass":"attr] ~ /^sequence:moRef/)
			{
				for (j=2;j<=last;j++) mib_table[i]=mib_table[i]"\n >>> "attr" = "part[j]
			}
			else if (MoAttributesType[moclass":"attr] ~ /^sequence:structRef/)
			{
				for (j=2;j<=last;j++)
				{
					#if (((j-2)%nr_members)==0)
					if (part[j] ~ sprintf("^%s($|=| )",firstmember))
					{
						mib_table[i]=mib_table[i]"\n >>> Struct["++k"]  has "nr_members" members:"
						m=0
					}
					if (part[j] ~ /^no /) part[j]=gensub(/^no /,"",1,part[j])"="
					else if (part[j] ~ /\[\] <empty>$/) part[j]=gensub(/\[\] <empty>$/,"",1,part[j])
					else if ((part[j] ~ /^[^ \t"=]+=/)||\
					         ((structname,part[j]) in struct_type && struct_type[structname,part[j]] ~ /sequence/))
					{
						structmember=gensub(/=.*$/,"",1,part[j])
						structval=gensub(/^[^=]+=/,"",1,part[j])
						if ((structname,structmember) in struct_type && struct_type[structname,structmember] ~ /enumRef/)
						{
							tmpenum=gensub(/^enumRef:/,"",1,struct_type[structname,structmember])
							if ((tmpenum,structval) in enum && enum[tmpenum,structval]!="") part[j]=structmember"="enum[tmpenum,structval] (notranslate=="notranslate"?"":" ("structval")")
						}
						else if (structmember ~ /^(subframeAllocationFourFrame|subframeAllocationOneFrame)$/) part[j]=structmember"="structval ((notranslate=="notranslate"||translate_sequence_enum==0)?"":" ("b2d_function(structval)")")
						else if (structmember ~ /^(sfAllocationOneFrame)$/) part[j]=structmember"="structval ((notranslate=="notranslate"||translate_sequence_enum==0)?"":" ("d2b_function(structval,6)")")
						else if (structmember ~ /^(sfAllocationFourFrame)$/) part[j]=structmember"="structval ((notranslate=="notranslate"||translate_sequence_enum==0)?"":" ("d2b_function(structval,24)")")
					}
					else if (part[j] ~ /^[^ \t\["]+\[\]$/)
					{
						part[j]=gensub(/\[.*$/,"",1,part[j])"="
					}
					else
					{
						mib_table[i]=mib_table[i]" "part[j]
						continue
					}
					mib_table[i]=mib_table[i]"\n >>> "++m"."gensub(/=/," = ",1,part[j])
				}
			}
			else if (MoAttributesType[moclass":"attr] ~ /^sequence:enumRef-/)
			{
				tmpenum=gensub(/^sequence:enumRef-/,"",1,MoAttributesType[moclass":"attr])
				for (j=2;j<=last;j++)
				{
					if ((tmpenum,part[j]) in enum && enum[tmpenum,part[j]]!="") mib_table[i]=mib_table[i] enum[tmpenum,part[j]]" "
					else mib_table[i]=mib_table[i] part[j]" "
				}
				if (translate_sequence_enum==1 && notranslate!="notranslate")
				{
					mib_table[i]=mib_table[i] "("
					for (j=2;j<=last;j++)
					{
						mib_table[i]=mib_table[i] part[j]" "
					}
					mib_table[i]=gensub(/ +$/,"",1,mib_table[i])")"
				}
			}
			else
			{
				for (j=2;j<=last;j++) mib_table[i]=mib_table[i] part[j]" "
			}
		}
		else if (mib_table[i] ~ /ManagedElement=[^,]+, /)
		{
			#source                               ManagedElement=1, Epg=1, Pgw=PPL9, Board=gc-0/16/1, Shared=Shared-Radius
			gsub(/, /,",",mib_table[i])
		}
		else if (attr=="probableCause" && mib_table[i] ~ /^[0-9]+$/) mib_table[i]=mib_table[i]" ("causeTable[mib_table[i]+0]")"
		else if (attr=="iuantDeviceType" && mib_table[i] ~ /^[0-9]+$/) mib_table[i]=mib_table[i]" ("iuantdevtypeText[mib_table[i]+0]")"
		else if (moclass":"attr in MoAttributesType && MoAttributesType[moclass":"attr] ~ /^enumRef:/)
		{
			tmpenum=gensub(/^enumRef:/,"",1,MoAttributesType[moclass":"attr])
			if ((tmpenum,mib_table[i]) in enum && enum[tmpenum,mib_table[i]]!="")
			{
				if (notranslate=="notranslate") mib_table[i]=enum[tmpenum,mib_table[i]]
				else mib_table[i]=enum[tmpenum,mib_table[i]]" ("mib_table[i]")"
			}
		}
		else if (showmoc==1 && mib_table[i]=="" && moclass":"attr in MoAttributesType && MoAttributesType[moclass":"attr] ~ /^sequence:structRef/) mib_table[i]="t[0] = "
		sub(/(\x1c)*(["]? *<(key|read-only|default|default> <deprecated)>)*$/,"",mib_table[i])
		gsub(/\x1c/,", ",mib_table[i]) # in attribute BrmBackup::backupDescriptor we have the \x1c characters as separator
	}
}
function append_testmomdump_attributes()
{
	customPrint("\nAppending testmomdump attributes...","","force","noLF")
	while (getline < tempintmomlog3)
	{
		#EUtranCellFDD=ENB006c1,Etws=1                                 dataCodingScheme     0
		if (NF<3 || $1!~/^[A-Z][^=]+=[^=]+/) continue
		if (!($1 in MoProxy && MoProxy[$1]~/^[1-9][0-9]*$/)) continue
		mib_table[MoProxy[$1],$2]=gensub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+/,"",1,$0)
	}
	close(tempintmomlog3)
	customPrint("Done.","","force")
}
function aisort(arr,   old_ignorecase,res)
{
	old_ignorecase=IGNORECASE
	IGNORECASE=1
	res=asort(arr)
	IGNORECASE=old_ignorecase
	return res
}
function nrOfMoType(moclass,what,getsnOption,    proxy,nrofmotype)
{
	#return the number of mo instances for a certain moclass
	if (what=="") return nrOfMoTypes[tolower(moclass)]+0
	if (moclass=="UtranRelation")
	{
		if (tolower(what) ~ "cnhho") return nrOfMoTypes[tolower(moclass)]+0
		else if (tolower(what) ~ "inter|ifho") what="(INTER_FREQ)"
		else if (tolower(what) !~ "cnhho|inter|ifho") what="(INTRA_FREQ)"
		if (getsnOption !~ "r" && what in pgetsNrOfMoTypes) return pgetsNrOfMoTypes[what]+0
		pgetsNrOfMoTypes[what]=0
		mo_log(temppgetsnlog,"open","mute","overwrite","silent")
		muteFactor=nrOfMoTypes["utranrelation"]
		$0="get ^utranrelation= ^frequencyRelationType$" ; get("short")
		mo_log(temppgetsnlog,"close")
		customPrint("")
		while (getline < temppgetsnlog) pgetsNrOfMoTypes[$4]++
		close(temppgetsnlog)
		return pgetsNrOfMoTypes[what]+0
	}
	if (moclass":counterActivation" in MoAttributesType && MoAttributesType[moclass":counterActivation"]=="boolean")
	{
		if (getsnOption !~ "r" && moclass in pgetsNrOfMoTypes) return pgetsNrOfMoTypes[moclass]+0
		pgetsNrOfMoTypes[what]=0
		mo_log(temppgetsnlog,"open","mute","overwrite","silent")
		muteFactor=nrOfMoTypes[tolower(moclass)]+0
		$0="get ^"moclass"= counteractivation true" ; get("short")
		mo_log(temppgetsnlog,"close")
		customPrint("")
		while (getline < temppgetsnlog) { if ($1=="Total:" && $3=="MOs") pgetsNrOfMoTypes[moclass]=$2 }
		close(temppgetsnlog)
		return pgetsNrOfMoTypes[moclass]+0
	}
	return nrOfMoTypes[tolower(moclass)]+0
	#Too slow
	#for (proxy in Ldn)
	#{
	#	if (p2s("MoType",proxy)==moclass || tolower(p2s("MoType",proxy))==tolower(moclass)) nrofmotype++
	#}
	#return nrofmotype
}

#DN conversion functions found in funcs.awk:
#function s2me(string) : give Me of a DN
#function l2m(string,force,   array,last,i,dn,thisisaldn,me) : give mediumMo of LDN
#function m2l(string, rootclass) : give LDN of a medium MO
#function s2p(string,   l2m_string) : give proxy of a DN
#function s2t(string, last,array,res) : give moclass of a DN

function p2s(what,proxy,  last,array,dn,i,res)
{
	#return an ldn/sortmo/mediummo/fdn/motype for the proxy
	#in multi mode, it can also return the node of a proxy (Me=<node>)
	if (!(proxy in Ldn)) return ""
	if (what=="Mo") return gensub("ManagedElement=[^,]+,","",1,Ldn[proxy])
	else if (what=="ShortMo")
	{
		last=split(Ldn[proxy],array,",")
		if ((multi || multioffline)&& last > 0) return p2s("Me",proxy)"," array[last]
		return array[last]
	}
	else if (what=="MoType")
	{
		if (proxy in MoType && MoType[proxy] != "") return MoType[proxy]
		return s2t(Ldn[proxy])
	}
	else if (what=="MediumMo") return l2m(Ldn[proxy])
	else if (what=="Me" && Ldn[proxy]~/^Me=/) return gensub(/,.*$/,"",1,Ldn[proxy])
	else if (what=="FdnMo")
	{
		if ((multi || multioffline) && MibPrefixTable[p2s("Me",proxy)]!="") return p2s("Me",proxy)"," MibPrefixTable[p2s("Me",proxy)] gensub(/^Me=[^,]+,/,"",1,Ldn[proxy])
		if (MibPrefix != "") return sprintf("%s,%s",MibPrefix,Ldn[proxy])
		return Ldn[proxy]
	}
	else if (what=="LdnMo") return Ldn[proxy]
	else if (what=="origLdnMo") return origLdn[proxy]
	else if (what=="MoTypeFull") return gensub(/,/,".","g",gensub(/=[^=,]+/,"","g",Ldn[proxy]))  #returns the LDN with only MO classes, no MOids: ManagedElement,ENodeBFunction,EUtranCellFDD
}

function log_command()
{
	if (logging == 1) { close(logfile) ; print "\n"prompt"> "$0 >> logfile}
}
function log_command_result(what,text,   nrMoCreated)
{
	if ("$command_result" in customVar && customVar["$command_result"] ~ /^[01]$/)
	{
		if (customVar["$command_result"]==0) nrMoCreated=1 ; else nrMoCreated=0
		#if (text != "") add_to_moscomlog("",text)
		#else add_to_moscomlog("","%@> "nrMoCreated" MO created" (undoMode==2?" (Simulated)":""))
		if (what=="cr") add_to_moscomlog("",sprintf("%@> %s (%s%s)",(customVar["$command_result"]==0?"OK":"Fail"),(text!=""?text:nrMoCreated" MO created"),(undoMode==2?" - Simulated":"")))
		else add_to_moscomlog("",sprintf("%@> %s%s",(customVar["$command_result"]==0?"OK":"Fail"),(text!=""?" ("text")":"")))
	}
	return ""
}
function create(option,  \
z,i,j,mo,parent,already_loaded,parent_proxy,array,array2,motype,moid,attribute_name,attribute_type,\
attribute_value,abort,value,b,motype_found,last,last2,comb,subcomb,structreference,substruct,number_of_attributes,\
number_of_restricted_attributes,number_of_restricted_attributes_entered,restricted_attribute_name,restricted_attribute_type,\
restricted_attribute_value,Filter1,attrTable,moclass,Me,vproxy,newdn,ok,inres,tmpresult,split_the_mo,parentLdn,part,k,pat,theProxy,inputPrefix,\
tline,aname,aval,alist,word,allocAuto,tval,createParentError,createParentMoTypeError,incorrectAttributes,incorrectAttrList,parnewdn,tres,thenetconfstring,run_with_netconf)
{
	assignCustomVar("$command_result",1)
	Filter1=$2
	if (Filter1 ~ ",") parent=gensub(/,[^,]+$/,"","g",Filter1)
	else parent=""
	mo=gensub(sprintf("%s,",parent),"","g",Filter1)
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	#Handling of MO types that are directly under the ManagedElement MO (e.g. SectorEquipmentFunction, EthernetSwitchingAdm, Epg, etc
	if (parent=="" && multi!=1) parent=Ldn[0]
	if (multi && tolower(parent) ~ /^me=[^,]+$/) parent=parent",managedelement=1"
	#if (tolower(Filter1) ~ /(sectorequipmentfunction|ethernetswitchingadm|mgwapplication|context|epg)=[^,]+$/)
	#{
	#	#This MO is directly under the ManagedElement and is not systemCreated
	#	if (parent=="") parent="managedelement=1"          #online mode sectorequipmentfunction=z
	#	else if (tolower(parent) !~ /managedelement=1$/) parent=parent",managedelement=1"  #multi mode me=xxx,sectorequipmentfunction=z
	#}
	parent_proxy=giveMoProxy(parent,"","ignorecase")
	parentLdn=Ldn[parent_proxy]
	#print "parent="parent,"parent_proxy="parent_proxy,"parent_type="tolower(s2t(parent))
	if (parent_proxy == 0 && tolower(parent) !~ /managedelement=[^,]+$/)
	{
		if (comcli>0 && tolower(s2t(parent)) ~ /(^|\.)pmjob$/)
		{
			#The MO type can be "PmJob" or "EPIC_PM.PmJob"
			#Special case for MeasurementReader, eg: creation of SystemFunctions=1,Pm=1,PmJob=2,MeasurementReader=1
			#If the PmJob does not exist then it has to be created at the same time as the MeasurementReader
			parent_proxy=giveMoProxy(gensub(/,[^,]+$/,"",1,parent),"","ignorecase")
			#print "parent_proxy="parent_proxy
			if (parent_proxy > 0) parentLdn=Ldn[parent_proxy]",PmJob="gensub(/^.*=/,"",1,parent)
			split_the_mo=1
			if (mosdebug==1) print "DEBUG: parentLdn="parentLdn
		}
		if (parent_proxy == 0 && tolower(parent) !~ /managedelement=[^,]+$/)
		{
			if (reading_script==0)
			{
				customPrint("\nERROR: Parent MO not found: "parent)
				if (multi && tolower(parent) !~ /^me=/) customPrint("The LDN must start with the Me field, eg: me=rnc2,transportnetwork=1,atmport=34")
				return log_command_result("cr","Parent MO not found")
			}
			else createParentError=1
		}
	}
	split(mo,array,"=")
	moclass=array[1]
	#allow empty MO id, for some MO types like UpgradePackage or IubLink it is allowed and the node will select a default MO id
	#if (array[2]=="" || array[2] ~ /^[ \t]/)
	#{
	#	customPrint("\nERROR: Invalid MO identity.")
	#	return log_command_result("cr","Invalid MO identity")
	#}

	if (multi)
	{
		Me=s2me(parent)
		moclass=sprintf("%s%s%s",momVersion[Me],SUBSEP,moclass)
	}
	if (comcli>0)
	{
		if (tolower(moclass) in com_moclass_list && com_moclass_list[tolower(moclass)]!="")
		{
			motype=com_moclass_list[tolower(moclass)]
			newdn=parentLdn","motype"="array[2]
			moclass=s2t(newdn)
			motype_found=1
			moid=array[2]  #needed only in offline mode
		}
		if (mosdebug==1) print "DEBUG: newdn="newdn
	}
	else
	{
		for (b in attribute_list)
		{
			if (tolower(b)==tolower(moclass))
			{
				motype=b
				moclass=b
				motype_found=1
				if (multi)
				{
					#in multimode, moclass is made of momversion,motype
					motype=gensub(sprintf("^.*%s",SUBSEP),"",1,motype)
				}
				break
			}
		}
	}
	if (motype_found != 1)
	{
		motype=array[1]
		if (reading_script==0)
		{
			customPrint("\nERROR: MO type "motype" not found in MOM.")
			return log_command_result("cr","MO type not found in MOM")
		}
	}
	if (comcli==0)
	{
		if (!multi)
		{
			parentClass=p2s("MoType",parent_proxy)
			if (sprintf("%s;",parentList[motype]) !~ sprintf(";%s;",parentClass) )
			{
				if (reading_script==0)
				{
					customPrint("\nERROR: MO type "parentClass" is not a valid parent for MO type "motype".")
					return log_command_result("cr","Invalid parent")
				}
				else createParentMoTypeError=1
			}
		}
		moid=array[2]
		if (mospace_convert==1 && moid ~ space_sign) moid=gensub(space_sign," ","g",moid)
		newdn=sprintf("%s,%s=%s",Ldn[parent_proxy],motype,moid)
	}

	if (reading_script==0 && giveMoProxy(newdn,"","","",(comcli==0?"conditional":"")) > 0)
	{
		#the check is at the beginning when interactive mode and at the end when running a script
		#(otherwise all the parameters of the MO will be entered by the script and sent to the node as COLI commands
		customPrint("\nERROR: MO already exists: "newdn)
		return log_command_result("cr","MO already exists")
	}
	if (option ~ "n")
	{
		delete alist
		split(sorted_attribute_list[moclass],word,",")
		for (i in word)
		{
			if (attr_comments[moclass,word[i]] !~ /readOnly|key/) alist[word[i]]=alist[tolower(word[i])]=word[i]
		}
		if (reading_script==0) customPrint("Please enter each attribute on a separate line in the format \"<attributename> <value>\". Type \"end\" to commit or <enter> to abort.")
		i=j=0
		while (1)
		{
			tline=Read_Answer("","","","","","","")
			gsub(/^[ \t]+|[ \t]+$/,"",tline)
			if (tline=="") continue   #the user typed an empty line, ignore this
			if (tolower(tline)=="end") break #the user has finished entering all the attributes
			aname=gensub(/[ \t].*$/,"",1,tline)
			aval=gensub(/^[^ \t]+/,"",1,tline)
			gsub(/^[ \t]+|[ \t]+$/,"",aval)
			if (aname=="")
			{
				customPrint("Empty value! Aborting...")
				return log_command_result("cr","Command aborted")
			}
			if (aname~/^(#|\/\/)/) continue  #an attribute was commented out
			#the user entered an attribute that does not exist
			if (alist[tolower(aname)]=="")
			{
				if (reading_script==0)
				{
					customPrint("\nERROR: incorrect attribute: "aname)
					return log_command_result("cr","Incorrect attribute")
				}
				else incorrectAttributes[aname]=aname
			}
			else
			{
				aname=alist[tolower(aname)]
				abort=processAttribute(aval,MoAttributesType[moclass":"aname],attrTable,"",Me,aname,motype)
				if (abort == 1)
				{
					if (reading_script==0) return log_command_result("cr")
					else incorrectAttributes[aname]=aname
				}
			}
			if (attr_comments[moclass,aname] ~ "mandatory")
			{
				i++
				attribute_name[i]=aname
				attribute_value[i]=attrTable["value"]
				attribute_type[i]=attrTable["type"]
				number_of_attributes=i
			}
			else
			{
				if (check_for_empty(moclass,aname,attrTable["value"],attrTable["type"])==1) continue  #dont include non-mandatory attributes with empty value as long as their default value is not something different than empty
				if (attrTable["value"]=="d") continue  #dont include attributes with value "d" , means default
				j++
				restricted_attribute_name[j]=aname
				restricted_attribute_value[j]=attrTable["value"]
				restricted_attribute_type[j]=attrTable["type"]
				#print j,restricted_attribute_name[j],restricted_attribute_value[j],"X"
				number_of_restricted_attributes=j
			}
		}
		if (reading_script==1)
		{
			#the errors motype not found, parent not found, or wrong parent type can lead to incorrect attribute error
			#show these errors first in order to clear any confusion
			if (motype_found != 1)
			{
				customPrint("\nERROR: MO type "motype" not found in MOM.")
				return log_command_result("cr","MO type not found in MOM")
			}
			if (createParentError==1)
			{
				customPrint("\nERROR: Parent MO not found: "parent)
				if (multi && tolower(parent) !~ /^me=/) customPrint("The LDN must start with the Me field, eg: me=rnc2,transportnetwork=1,atmport=34")
				return log_command_result("cr","Parent MO not found")
			}
			if (createParentMoTypeError==1)
			{
				customPrint("\nERROR: MO type "parentClass" is not a valid parent for MO type "motype".")
				return log_command_result("cr","Invalid parent")
			}
			z=asort(incorrectAttributes)
			if (z>0)
			{
				for (j=1;j<=z;j++) incorrectAttrList=incorrectAttrList","incorrectAttributes[j]
				customPrint("\nERROR: incorrect attributes: "gensub(/^,/,"",1,incorrectAttrList))
				return log_command_result("cr","Incorrect attribute")
			}
		}
	}
	else
	{
		number_of_attributes=split(mandatory_attributes[moclass],attribute_name,",")
		if (number_of_attributes > 0)
		{
			for (i=1;i<=number_of_attributes;i++)
			{
				#customPrint(sprintf("\nAttribute %s of %s, %s",i,number_of_attributes,attribute_name[i]),"","","noLF")
				inputPrefix=sprintf("\nAttribute %s of %s, %s",i,number_of_attributes,attribute_name[i])
				abort=inputAttribute(attribute_value[i],MoAttributesType[moclass":"attribute_name[i]],attrTable,"",Me,attribute_name[i],motype,option,inputPrefix)
				if (abort != 1)
				{
					attribute_value[i]=attrTable["value"]
					attribute_type[i]=attrTable["type"]
				}
				else return log_command_result("cr")
			}
		}
		number_of_restricted_attributes=split(restricted_attributes[moclass],restricted_attribute_name,",")
		if (number_of_restricted_attributes > 0)
		{
		 	customPrint(sprintf("\nFollowing attributes are optional. \
Enter attribute value or \"d\" for default.\n\
Once the MO is created, these attributes cannot be changed (they are restricted).\n"),"","","noLF")
			for (i=1;i<=number_of_restricted_attributes;i++)
			{
				#customPrint(sprintf("\nAttribute %s of %s, %s",i,number_of_restricted_attributes,restricted_attribute_name[i]),"","","noLF")
				inputPrefix=sprintf("\nAttribute %s of %s, %s",i,number_of_restricted_attributes,restricted_attribute_name[i])
				abort=inputAttribute(restricted_attribute_value[i],MoAttributesType[moclass":"restricted_attribute_name[i]],attrTable,"restricted",Me,restricted_attribute_name[i],motype,option,inputPrefix)
				if (abort != 1)
				{
					restricted_attribute_value[i]=attrTable["value"]
					restricted_attribute_type[i]=attrTable["type"]
					if (motype=="Program" && restricted_attribute_name[i]=="loaderType" && parentClass != "PlugInUnit")
					{
						#the attribute Program::loaderType is only valid for children of PlugInUnit
						restricted_attribute_value[i]="d"
					}
				}
				else return log_command_result("cr")
			}
		}
	}
	if (motype=="Aal2PathDistributionUnit" && \
	    sprintf("%s%s:%s",(multi?sprintf("%s%s",momVersion[Me],SUBSEP):""),"Aal2Ap","allocationMode") in MoAttributesType && \
	    getMoAttribute(parent_proxy,"allocationMode") ~ /^1/)
	{
		#do not include the attribute rpuId if the parent Aal2Ap has allocationMode automatic
		for (i in restricted_attribute_name) { if (restricted_attribute_name[i]=="rpuId") restricted_attribute_value[i]="d" }
	}
	if (abort ==1) return log_command_result("cr")
	if (reading_script==1)
	{
		#these checks are at the beginning when interactive mode and at the end when running a script
		#otherwise all the parameters of the MO will be entered by the script and sent to the node as COLI commands
		if (motype_found != 1)
		{
			return log_command_result("cr","MO type not found in MOM")
		}
		if (giveMoProxy(newdn,"","","",(comcli==0?"noload":"")) > 0)
		{
			customPrint("\nERROR: MO already exists: "newdn)
			return log_command_result("cr","MO already exists")
		}
		if (createParentError==1)
		{
			customPrint("\nERROR: Parent MO not found: "parent)
			if (multi && tolower(parent) !~ /^me=/) customPrint("The LDN must start with the Me field, eg: me=rnc2,transportnetwork=1,atmport=34")
			return log_command_result("cr","Parent MO not found")
		}
		if (createParentMoTypeError==1)
		{
			customPrint("\nERROR: MO type "parentClass" is not a valid parent for MO type "motype".")
			return log_command_result("cr","Invalid parent")
		}
	}
	if (undoMode == 2)
	{
		customPrint(sprintf("\n>>> Simulated MO creation: %s,%s=%s",Ldn[parent_proxy],motype,moid),undoMode)
		assignCustomVar("$command_result",0)
		return log_command_result("cr")
	}
	if (node ~ /^OFFLINE_/)
	{
		maxProxy++
		value=sprintf(">>>  [Proxy ID = %s] MO name :%s,%s=%s",maxProxy,Ldn[parent_proxy],(comcli>0?shortmoc(moclass):moclass),moid)
		add_Proxys_to_table(value)
		populate_origLdn()
		assignCustomVar("$command_result",0)
		customPrint("\n"value,undoMode)
		for (i=1;i<=number_of_attributes;i++)
		{
			#print i,attribute_name[i],attribute_value[i]
			mib_table[maxProxy,attribute_name[i]]=make_mib_value(maxProxy,attribute_name[i],attribute_value[i])
		}
		for (i=1;i<=number_of_restricted_attributes;i++)
		{
			if (tolower(restricted_attribute_value[i]) != "d") mib_table[maxProxy,restricted_attribute_name[i]]=make_mib_value(maxProxy,restricted_attribute_name[i],restricted_attribute_value[i])
		}
		mib_table[maxProxy,moclass"Id"]=moid
		if (moclass":reservedBy" in MoAttributesType && MoAttributesType[moclass":reservedBy"]~/^sequence:/) mib_table[maxProxy,"reservedBy"]="[0] ="
		last=split(sorted_attribute_list[moclass],array,",")
		for (i=1;i<=last;i++)
		{
			if (sprintf("%s%s%s",maxProxy,SUBSEP,array[i]) in mib_table) continue
			if (sprintf("%s:%s",moclass,array[i]) in struct_default_value) { mib_table[maxProxy,array[i]]=struct_default_value[moclass":"array[i]] ; continue }
			if (sprintf("%s%s%s",moclass,SUBSEP,array[i]) in attr_default) mib_table[maxProxy,array[i]]=attr_default[moclass,array[i]]
			if (sprintf("%s:%s",moclass,array[i]) in MoAttributesType && MoAttributesType[moclass":"array[i]] ~ /^sequence:/)
			{
				last2=split(mib_table[maxProxy,array[i]],array2," ")
				mib_table[maxProxy,array[i]]=gensub(/^ar?/,"",1,MoAttributesTypeJava[moclass":"array[i]])"["last2"] = "mib_table[maxProxy,array[i]]
			}
			if (sprintf("%s%s%s",maxProxy,SUBSEP,array[i]) in mib_table) continue
			#populate attributes without a default value
			if (!(sprintf("%s:%s",moclass,array[i]) in MoAttributesType)) continue
			if (MoAttributesType[moclass":"array[i]] == "enumRef:AvailabilityStatus") mib_table[maxProxy,array[i]]="0 (NO_STATUS)"
			else if (array[i] == "usageState") mib_table[maxProxy,"usageState"]="0 (IDLE)"
			else if (MoAttributesType[moclass":"array[i]] ~ /OperState/) mib_table[maxProxy,array[i]]="1 (ENABLED)"
			else if (MoAttributesType[moclass":"array[i]] ~ /Adm(in)?State/) mib_table[maxProxy,array[i]]="1 (UNLOCKED)"
			else if (array[i] == "availabilityStatus") mib_table[maxProxy,"availabilityStatus"]="0 (NO_STATUS)"
			else if (moclass=="UtranRelation")
			{
				if (array[i]=="nodeRelationType")
				{
					if (mib_table[maxProxy,"utranCellRef"] ~ "ExternalUtranCell=") mib_table[maxProxy,"nodeRelationType"]="1 (INTER_RNC)"
					else mib_table[maxProxy,"nodeRelationType"]="0 (INTRA_RNC)"
				}
				else if (array[i]=="frequencyRelationType")
				{
					if (mib_table[giveMoProxy(mib_table[maxProxy,"utranCellRef"]),"uarfcnDl"] != mib_table[parent_proxy,"uarfcnDl"]) mib_table[maxProxy,"frequencyRelationType"]="1 (INTER_FREQ)"
					else mib_table[maxProxy,"frequencyRelationType"]="0 (INTRA_FREQ)"
				}
			}
			else if (comcli>0)
			{
				if (attr_comments[moclass,array[i]] ~ /key(,|$)/) mib_table[maxProxy,array[i]]=moid
				else mib_table[maxProxy,array[i]]="" #<undef>
			}
		}
		return log_command_result("cr")
	}
	number_of_restricted_attributes_entered=number_of_restricted_attributes
	for (i in restricted_attribute_value)
	{
		if (tolower(restricted_attribute_value[i]) == "d")
		{
			number_of_restricted_attributes_entered--
			#print restricted_attribute_name[i]
		}
	}
	if (comcli>0)
	{
		if (comcli>0 && comcli_netconf_cre==1 && runOneTransaction!=1 && split_the_mo!=1)
		{
			make_moc_key_attributes()
			if (netconf_function("","start")=="NetconfOK")
			{
				thenetconfstring=make_netconf_create(moclass,newdn,number_of_attributes,attribute_name,attribute_value,number_of_restricted_attributes,restricted_attribute_name,restricted_attribute_value)
				if (thenetconfstring!="") run_with_netconf=1
			}
		}
		if (run_with_netconf==1)
		{
			tmpresult=sendNetconfCommand("create",thenetconfstring)
		}
		else
		{
			if (start_config_mode()==1) return log_command_result("cr")
			ok=0 ; inres=0
			if (mosdebug==1) print "DEBUG: newdn="newdn
			if (split_the_mo==1)
			{
				print gensub(/,[^,]+$/,"",1,newdn) |& SshClient
				while (SshClient |& getline)
				{
					gsub("\r","") ; gsub("\x000","")
					if (mosdebug==1) print $0
					if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
					if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
					if ($1 ~ /^>ManagedElement=/ && inres==0) { inres=1 ; continue }
					if (inres==1) value=value" "$0
				}
				sub(/^ /,"",value)
				ok=0 ; inres=0
				print gensub(/^.*,/,"",1,newdn) |& SshClient
			}
			else
			{
				print newdn |& SshClient
			}
			while (SshClient |& getline)
			{
				gsub("\r","") ; gsub("\x000","")
				if (mosdebug==1) print $0
				if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($1 ~ /^>ManagedElement=/ && inres==0) { inres=1 ; continue }
				if (mosdebug==1) print "DEBUG: split_the_mo="split_the_mo", $1="$1", inres="inres", value="value
				if (split_the_mo==1 && $1 ~ /^>MeasurementReader=/ && inres==0) { inres=1 ; continue }
				if (inres==1) value=value" "$0
			}
			sub(/^ /,"",value)
			if (mosdebug==1) print "DEBUG: value="value,"cliDN="cliDN,"newdn="newdn
			if (value=="" && cliDN==newdn)
			{
				value=comcli_create_mo(moclass,number_of_attributes,attribute_name,attribute_type,attribute_value)
				if (value=="") value=comcli_create_mo(moclass,number_of_restricted_attributes,restricted_attribute_name,restricted_attribute_type,restricted_attribute_value,"restricted")
			}
			if (value=="") tmpresult=stop_config_mode()
			else
			{
				tmpresult=1
				stop_config_mode("","abort")
			}
		}
		#print 1,tmpresult
		if ((tmpresult==0 && value=="")||(is_mo_there(newdn)))
		{
			if (comcli>0 && split_the_mo==1)
			{
				parnewdn=gensub(/,[^,]+$/,"",1,newdn)
				add_Proxys_to_table(transform_mib_line(1" "gensub(/ManagedElement=[^,]+,/,"",1,parnewdn),"geta"))
				value=sprintf("\n>>>  [Proxy ID = %s] MO name :%s",maxProxy,parnewdn)
				customPrint(value,undoMode)
			}
			add_Proxys_to_table(transform_mib_line(1" "gensub(/ManagedElement=[^,]+,/,"",1,newdn),"geta"))
			value=sprintf("\n>>>  [Proxy ID = %s] MO name :%s",maxProxy,newdn)
			customPrint(value,undoMode)

			populate_origLdn()
			assignCustomVar("$command_result",0)
		}
		else
		{
			value=sprintf("\n!!!! %s%s",(value!=""?value" ":""),(tmpresult!=0?tmpresult:""))
			customPrint(value)
			parentClass=p2s("MoType",parent_proxy)
			if (moclass!~/^[^.]+\.[^.]+/) moclass=t2ecimt(moclass)
			if (moclass in parentList && parentList[moclass]!="" && sprintf("%s;",parentList[moclass]) !~ sprintf(";%s;",parentClass) )
			{
				customPrint("MO type "parentClass" is not a valid parent for MO type "moclass".")
			}
		}
		return log_command_result("cr")
	}

	#---- CPP ONLY ---------

	print "5" 				|& TestClient
	print  parent_proxy			|& TestClient
	print  moid		 		|& TestClient
	print  motype				|& TestClient
	print  number_of_restricted_attributes_entered + number_of_attributes	|& TestClient
	#print  number_of_restricted_attributes_entered + number_of_attributes
	if (number_of_attributes > 0)
	{
		for (i=1;i<=number_of_attributes;i++)
		{
			#print attribute_name[i]" "attribute_type[i]" "attribute_value[i]
			print attribute_name[i]		|& TestClient
			print attribute_type[i]		|& TestClient
			print attribute_value[i]	|& TestClient
		}
	}
	if (number_of_restricted_attributes > 0)
	{
		for (i=1;i<=number_of_restricted_attributes;i++)
		{
			if (tolower(restricted_attribute_value[i]) != "d")
			{
				#print restricted_attribute_name[i]" "restricted_attribute_type[i]" "restricted_attribute_value[i]
				print restricted_attribute_name[i]		|& TestClient
				print restricted_attribute_type[i]		|& TestClient
				print restricted_attribute_value[i]		|& TestClient
			}
		}
	}
	while (TestClient |& getline)
	{
		gsub("\r","") ; if (corba_debug >= 1) customPrint($0)
		if ($1 == "Enter_choice_or_type_8_for_help") break
		else if (NF > 0) value = sprintf("%s\n%s",value,$0)
	}
	#value = gensub(/.*>>>/,"  >>>","g",value) ; #value = gensub(/.*!!!!/,"!!!!","g",value)
	value = gensub(/(Your choice: .*(No of attributes: |.*Attribute value: |Illegal choice\n))|[\n]+$/,"","g",value)
	if (value ~ />>>  \[Proxy ID/)
	{
		add_Proxys_to_table(value)
		populate_origLdn()
		assignCustomVar("$command_result",0)
		customPrint(value,undoMode)
		if (reading_script==0 && comcli==0 && motype in has_syscreated_children && has_syscreated_children[motype]!="")
		{
			theProxy=maxProxy
			$0="lcc "theProxy  ; Load_Proxys("childrenlong",20,"","silent","noconfirm")
			for (i=(theProxy+1);i<=maxProxy;i++) customPrint(">>>  [Proxy ID = "i"] MO name :"Ldn[i])
		}
	}
	else
	{
		customPrint(value)
		if (comcli==0)
		{
			#the creation failed but we try to load the proxy anyway to see if the MO had previously gotten created automatically , e.g. when creating AuxPlugInUnit MO on ERBS and autoConfigurationAllowed==true , its children get created automatically eventhough they are not marked as "systemCreated"
			$0="ld "Filter1;Load_Proxys("ldn")
		}
	}
	if (makeScriptSummary==1)
	{
		summaryCommand[++summaryIndex]="cr "Filter1
		summaryResult[summaryIndex]=gensub(/\] MO name :.*$/,"]",1,gensub("\n","",1,value))
	}
	jvm_gc()
	if (moscommandlog==1 && multi==1)
	{
		tres=gensub(/^\n/,"",1,value)
		add_multi_command(parent_proxy," cr "p2s("Mo",parent_proxy)","motype"="moid" "gensub(/\n.*$/,"",1,tres))
	}
	return log_command_result("cr")
}
function check_for_empty(moclass,aname,val,type,    def,res)
{
	res=0
	def=""
	if ((moclass,aname) in attr_default && attr_default[moclass,aname]!="") def=attr_default[moclass,aname]
	if (val=="" && def=="") res=1
	#also dont include empty morefs , eg IpAccessHostGpb:autoConfigIdentity
	if (type ~ /^r/ && val=="-1") res=1
	#print "DEBUG: "moclass,aname,type,val," -> "res
	return res
}
function comcli_create_mo(moclass,number_of_attributes,attribute_name,attribute_type,attribute_value,what,                      value,ok,inres,z,part,k,pat,tval,subpart,y,m,theval,thesuf)
{
	value=""
	if (!(number_of_attributes > 0)) return value
	for (i=1;i<=number_of_attributes;i++)
	{
		ok=0; inres=0
		if (mosdebug==1) print "DEBUG: "attribute_name[i]" "attribute_type[i]" "attribute_value[i]
		if (what=="restricted" && tolower(attribute_value[i])=="d") continue
		if (attribute_type[i]~"t" && attribute_value[i]!="" && MoAttributesType[moclass":"attribute_name[i]] !~ ".EcimPassword")
		{
			#special handling for struct or sequence of struct
			theval=com_process_value(attribute_value[i],MoAttributesType[moclass":"attribute_name[i]],"noquotes")
			if (attribute_type[i]~"at" && attribute_value[i]~";") y=split(theval,subpart,";")
			else { y=1 ; subpart[1]=theval }
			for (m=1;m<=y;m++)
			{
				#print m,what,moclass,attribute_name[i],MoAttributesType[moclass":"attribute_name[i]],attribute_type[i],subpart[m]
				z=split(subpart[m],part,"\n")
				for (k=0;k<=(z+1);k++)
				{
					ok=0; inres=0
					if (k==0)
					{
						thesuf=""
						if (attribute_type[i]~"at"&&what==""&&m==1) thesuf="[@1]"
						print attribute_name[i] thesuf |& SshClient
						pat=sprintf(">%s%s",attribute_name[i],thesuf)
					}
					else if (k<=z)
					{
						print part[k] |& SshClient
						pat=sprintf(">%s",part[k])
					}
					else if (k>z)
					{
						print "up" |& SshClient   #after the struct is all entered, go back up to the MO
						pat="up"
					}
					if (mosdebug==1) print "DEBUG: pat="pat
					while (SshClient |& getline)
					{
						gsub("\r","") ; gsub("\x000","")
						if (mosdebug==1) print $0
						if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
						if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
						if ($1==pat || $0==pat) { inres=1 ; continue }
						if (inres==1) value=value" "$0
					}
					sub(/^ /,"",value)
				}
				if (value != "") break
			}
			if (value != "") break
		}
		else
		{
			if (MoAttributesType[moclass":"attribute_name[i]] ~ "EcimEmpty")
			{
				if (attribute_value[i]=="true") print attribute_name[i]      |& SshClient
				else                            print "no "attribute_name[i] |& SshClient
			}
			else if (attribute_type[i]~"t" && attribute_value[i]=="") print "no "attribute_name[i] |& SshClient
			else
			{
				tval=com_process_value(attribute_value[i],MoAttributesType[moclass":"attribute_name[i]])
				if (MoAttributesType[moclass":"attribute_name[i]] ~ ".EcimPassword") gsub(/^.*ECIMPW=|\nECIMPW.*$/,"",tval)
				if (tval~/^(|\"\")$/ && MoAttributesType[moclass":"attribute_name[i]] ~ /moRef/) print "no "attribute_name[i] |& SshClient
				else print attribute_name[i]"="tval |& SshClient
			}
			while (SshClient |& getline)
			{
				gsub("\r","") ; gsub("\x000","")
				if (mosdebug==1) print $0
				if ($1 == "EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($1 ~ sprintf("^>%s=",attribute_name[i])) { inres=1 ; continue }
				if (inres==1) value=value" "$0
			}
			sub(/^ /,"",value)
			if (value != "") break
		}
	}
	if (mosdebug==1 && value != "") print "DEBUG: value="value
	return value
}
function buildProxyList(molength,proxyList,otherVars,deletion,safemode,rdel,fset,  \
p,Filter1,Filter2,Filter3,j,syntaxOk,array,start,stop,neg,Proxy,Value_to_Set,a,b,Type,groupInput,last,\
tempProxyList,bProxy,motypes,tmp_string,reverseProxyList,i,rev,tmp_what,dnList,tmpdn,pList,tmpClass,childrenLoaded,z,\
tmp_done,tmp_children_types,tmp_children_list,w,specialcase,specialCases,tmpmo,tmpFilterString,numFilter,k,part,doneDel,mList,t_parent,fList,zList,lnhFilterString)
{
	p=0
	if (disabled_confirmation>0 && safemode>0) safemode=0
	if (tolower($2)=="all") $2="."
	if (mom_version ~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/) lnhFilterString="^(0[0-1][0-2][0-9]00$|BXP_)"
	else if (mom_version ~ "RBS_NODE_MODEL") lnhFilterString="^0[0-1][0-2][0-9]00$"
	else if (mom_version ~ "RNC_NODE_MODEL") lnhFilterString="^[0-1][0-9][0-2][0-9]00(/(sp[0-9].lnh|d0000[0-9]))?$"
	else lnhFilterString="^[0-9][0-9][0-2][0-9]00(/d00001)?$"
	#so that a number starting with a 0 (eg: 0997) will not seen as a proxy but as a regexp
	#note: using proxy or board group is blocked in safe mode
	if ((safemode!=1)&&(($2+0 <= maxProxy && $2 ~ /^([0-9]|[1-9][0-9]+)$/) || ($2 ~ /^[0-9]+-(|[0-9]+)$/)))
	{
		syntaxOk=1
		for (j=2;j<=NF;j++)
		{
			if ($j+0 <= maxProxy && $j ~ /^[0-9]+$/ )
			{
				if (p2s("Mo",$j) != "") proxyList[++p]=$j
			}
			else if ($j ~ /^[0-9]+-(|[0-9]+)$/)
			{
				split($j,array,"-") ; start=array[1] ; stop=array[2]
				if (stop !~ /[0-9]+/) { stop = maxProxy }
				if (stop < start)
				{
			       		for (Proxy=start;Proxy>=stop;Proxy--) if (p2s("Mo",Proxy) != "") proxyList[++p]=Proxy
			       	}
			       	else
			       	{
					for (Proxy=start;Proxy<=stop;Proxy++) if (p2s("Mo",Proxy) != "") proxyList[++p]=Proxy
				}
			}
			else
			{
				Filter2=tolower($j) ; Filter3=tolower($(j+1))
				split(make_value_to_set(j+1,fset),array,SUBSEP) ; Value_to_Set=array[1] ; Type=array[2]
				break
			}
		}
	}
	else if ((safemode!=1)&&($2 ~ lnhFilterString || ($2 in bdGroup && bdGroup[$2]!="" && $2!~/^(aal2ap|asc|xp|ru|xmu|piudev)$/ && (!($2 in moGroup)))))
	{
		#note: the board groups aal2ap/asc/xp/ru/xmu are the only ones  that are not mapped against the PlugInUnits: http://utran01.epa.ericsson.se/moshell/e107_plugins/suggestions_menu/suggestions.php?0.view.127.3.0
		Filter1=$2""  #force Filter1 to be a string otherwise with some linkhandler values like 000600 it can get viewed as a integer and converted to 600
		Filter2=tolower($3) ; Filter3=tolower($4)
		split(make_value_to_set(4,fset),array,SUBSEP) ; Value_to_Set=array[1] ; Type=array[2]
		buildBoardGroup()
		if (comcli==0)
		{
			motypes["pluginunit"]=motypes["spm"]=1
			ConditionalLoad(motypes)
		}
		if (Filter1 ~ /^[0-9][0-9][0-2][0-9]00(|\/(sp[0-9].lnh|d0000[0-9]))$|^BXP_[0-9_]+$/)
		{
			if (s2p(moLnhTable[Filter1]) !="") proxyList[++p]=s2p(moLnhTable[Filter1])
		}
		else if (Filter1 in bdGroup && bdGroup[Filter1] != "")
		{
			last=split(bdGroup[Filter1],array,";")
			for (j=1;j<=last;j++)
			{
				if (s2p(moLnhTable[array[j]]) != "") proxyList[++p]=s2p(moLnhTable[array[j]])
			}
		}
	}
	else
	{
		Filter1=tolower($2) ; Filter2=tolower($3) ; Filter3=tolower($4)
		split(make_value_to_set(4,fset),array,SUBSEP) ; Value_to_Set=array[1] ; Type=array[2]
		if (Filter1 ~ /^(!|%)/)
		{
			if (Filter1 ~ /^!/) neg=1
			else if (Filter1 ~ /^%/) rev=1
			Filter1=gensub(/^(!|%)/,"","1",Filter1)
		}
		#in COM nodes, some LDNs may contain a backslash, eg:
		#HSS-RoamingConfiguration=HSS-RoamingConfiguration,HSS-NetworkAccess=adsl2\2B
		if (comcli>0 && Filter1 ~ /[^\\]?[\\][^\\]?/) gsub(/\\/,"\\\\",Filter1)
               	for (mogroup in moGroup)
               	{
               		if (Filter1==tolower(mogroup))
               		{
               			 if (moGroup[mogroup] != "") groupInput=mogroup
               		}
               	}
               	if (molength=="short" && safemode!=1 && Filter1 !~ /\|/ && multi!=1)
               	{
	               	#autocorrection:
	               	#if the user gave an LDN (identified by the comma sign or two equal signs) and forgot the l prefix in front of the command
	               	#only supported when: the user gave one LDN only, not currently supported when putting several LDN separated by pipe sign

			#we analyse if the search string contains two equal signs or one comma sign, then it means it should be matched against LDN
			#but first take away signs like [^,] or [^=] from the string that we will analyse

			tmpFilterString=gensub(/\[\^[^\]]*[=,][^\]]*\]/,"","g",Filter1)
			if (tmpFilterString ~ /,|=.*=/)
			{
	               		molength="long"
	               		Filter1=sprintf("%s[^,]*$",Filter1)
	               	}
               	}
               	if (groupInput in moGroup && moGroup[groupInput] != "")
               	{
               		last=split(moGroup[groupInput],array,SUBSEP)
			for (b=1;b<=last;b++)
			{
				if (array[b] != "")
				{
					bProxy=giveMoProxy(array[b],"silent")
					#print bProxy,array[b]
					#Cope for cases where the MO is not found (eg has been deleted) and the function returns the value 0
 					if (!(bProxy==0 && array[b] !~ /ManagedElement=[^,]+$/)) tempProxyList[bProxy]=bProxy
 				}
 			}
 			p=asort(tempProxyList,proxyList)
		}
		else if (molength=="long" && Filter1 ~ /(^|,)[^,]+=[^,]+\$$/ && neg !=1 && giveMoProxy(gensub(/\$$/,"",1,Filter1),"silent","ignorecase","","noload") > 0)
		{
			#in case an LDN was typed with the $ at the end, then only one MO can be matched
			#saves time when running moshell command files, undo files, etc
			proxyList[++p]=giveMoProxy(gensub(/\$$/,"",1,Filter1),"silent","ignorecase","","noload")
		}
		else
		{
			#TR HM55362 : prevent use of (| and || and |) to avoid matching unwanted MOs, eg: cell=(|iub22|iub23) or cell=(iub21||iub22) matches all iub
			#removing pipe at the beginning or end of Filter1 : http://newtran01.au.ao.ericsson.se/moshell/e107_plugins/suggestions_menu/suggestions.php?0.view.455.3.0
			if (Filter1 ~ /\(\||\|\|+|\|\)|^\||\|$/)
			{
				customPrint("Warning: empty regexp found in between pipes, removed unwanted pipes.")
				gsub(/\|\|+/,"|",Filter1)
				gsub(/\(\|/,"(",Filter1)
				gsub(/\|\)/,")",Filter1)
				gsub(/^\||\|$/,"",Filter1)
			}
			if (safemode==1)
			{
				#only the exact ldn or rdn must be written. pipe can be used to specify several MOs on one line.
				#bl utrancell=123
				#bl utrancell=11|utrancell=12|utrancell=13
				#bl utrancell=11|12|13
				#bl utrancell=11|12|13|iublink=11
				last=split(Filter1,array,"|")
				for (j=1;j<=last;j++)
				{
					if (array[j] ~ "=")
					{
						currmo=giveMoProxy(array[j],"silent","ignorecase","","noload")
						if (currmo > 0) proxyList[++p]=currmo
					}
					else if (currmo > 0)
					{
						tmpmo=giveMoProxy(gensub(/=[^,=]+$/,"",1,p2s("Mo",currmo))"="array[j],"silent","ignorecase","","noload")
						if (tmpmo > 0) proxyList[++p]=tmpmo
					}
				}
			}
			else
			{
	        		if (molength=="long") tmp_what="LdnMo"   #used to be "Mo"
	        		else if (molength=="short") tmp_what="ShortMo"
		        	for (Proxy = 0; Proxy <= maxProxy; Proxy++)
		        	{
		        		tmp_string=tolower(p2s(tmp_what,Proxy))
		        		if (tmp_string != "")
		        		{
			        		if (neg == 1)
			        		{
			        			if (tmp_string !~ Filter1) proxyList[++p]=Proxy
			        		}
			 			else if ((tmp_string ~ Filter1)||(multi==1 && gensub(/,managedelement=1,/,",",1,tmp_string)~Filter1)) proxyList[++p]=Proxy
			 		}
			 	}
			 }
		}
		if (rev==1)
		{
			#put the proxy list in reverse order
			for (j=p;j>=1;j--) reverseProxyList[++i]=proxyList[j]
			for (i=1;i<=p;i++) proxyList[i]=reverseProxyList[i]
		}
		else if (sort_proxy>=1)
		{
			#sort the proxy list in alphabetical order
			if (nrOfMoTypes["uerc"]>9 || nrOfMoTypes["slot"]>9 || nrOfMoTypes["rbsslot"]>9 || nrOfMoTypes["almdevice"]>9 || nrOfMoTypes["sectorantenna"]>9 || nrOfMoTypes["tstone"]>9 || nrOfMoTypes["tnlqosclass"]>9 || nrOfMoTypes["spiqosclass"]>9 || nrOfMoTypes["sector"]>9 || nrOfMoTypes["reqfieldreplaceableunit.fieldreplaceableunit"]>9)
			{
				specialcase=1
				specialCases["UeRc"]=specialCases["Slot"]=specialCases["RbsSlot"]=specialCases["AlmDevice"]=specialCases["SectorAntenna"]=specialCases["TsTone"]=specialCases["TnlQosClass"]=specialCases["SpiQosClass"]=specialCases["Sector"]=specialCases["FieldReplaceableUnit"]=1
				numFilter=",(UeRc|Slot|RbsSlot|AlmDevice|SectorAntenna|TsTone|TnlQosClass|SpiQosClass|Sector|FieldReplaceableUnit)="
			}
			if (sort_proxy==1)
			{
				for (i=1;i<=p;i++)
				{
					tmpdn=p2s("Mo",proxyList[i])
					if (specialcase==1 && tmpdn ~ numFilter)
					{
						last=split(tmpdn,array,",")
						tmpdn=""
						for (k=1;k<=last;k++)
						{
							split(array[k],part,"=")
							if (specialCases[part[1]]==1 && part[2]~/^[0-9]+$/) tmpdn=sprintf("%s,%s=%03d",tmpdn,part[1],part[2])
							else tmpdn=sprintf("%s,%s=%s",tmpdn,part[1],part[2])
						}
						dnList[i]=gensub(/^,/,"",1,tmpdn)
					}
					else dnList[i]=tmpdn
					pList[dnList[i]]=proxyList[i]
				}
				p=asort(dnList)
				for (i=1;i<=p;i++)
				{
					#proxyList[i]=s2p(dnList[i])
					proxyList[i]=pList[dnList[i]]
				}
			}
			else if (sort_proxy==2)
			{
				#sort by MO type
				for (i=1;i<=p;i++)
				{
					tmpdn=p2s("Mo",proxyList[i])
					if (specialcase==1 && tmpdn ~ numFilter)
					{
						last=split(tmpdn,array,",")
						tmpdn=""
						for (k=1;k<=last;k++)
						{
							split(array[k],part,"=")
							if (specialCases[part[1]]==1 && part[2]~/^[0-9]+$/) tmpdn=sprintf("%s,%s=%03d",tmpdn,part[1],part[2])
							else tmpdn=sprintf("%s,%s=%s",tmpdn,part[1],part[2])
						}
						dnList[i]=s2t(tmpdn) SUBSEP gensub(/^,/,"",1,tmpdn)
					}
					else dnList[i]=s2t(tmpdn) SUBSEP tmpdn
					pList[dnList[i]]=proxyList[i]
				}
				p=asort(dnList)
				for (i=1;i<=p;i++)
				{
					#proxyList[i]=s2p(dnList[i])
					proxyList[i]=pList[dnList[i]]
				}
			}
		}
	}
	if (deletion=="deletion")
	{
		delete pList
		j=0
		#for MOs who have system created children, we put the systemcreated children just before the parent
		#so we know that if the parent was deleted, then the systemcreated children are also deleted
		for (i=1;i<=p;i++)
		{
			tmpClass=p2s("MoType",proxyList[i])
			if (tmpClass in class_syscreated) continue
			if (tmpClass in tmp_done) continue
			if (tmpClass in has_syscreated_children)
			{
				delete motypes
				split(has_syscreated_children[tmpClass],array,",")
				for (z in array)
				{
					motypes[array[z]]=1
					tmp_children_types[array[z]]=1
				}
				if ((comcli==0) && (!(tmpClass in childrenLoaded)))
				{
					#only do this for CPP nodes otherwise in COM nodes it does a lt all and changes the proxy table
					#load the children systemcreated proxies
					ConditionalLoad(motypes)
					childrenLoaded[tmpClass]=1
				}
				tmp_done[tmpClass]=1
			}
		}
		#make the proxy list of system created MOs
		for (z=1;z<=maxProxy;z++)
		{
			if (p2s("MoType",z) in tmp_children_types) tmp_children_list[++w]=z
		}
		for (i=1;i<=p;i++)
		{
			tmpClass=p2s("MoType",proxyList[i])
			if (tmpClass in class_syscreated) continue
			if (tmpClass in has_syscreated_children)
			{
				for (z=1;z<=w;z++)
				{
					if (Ldn[tmp_children_list[z]] ~ Ldn[proxyList[i]]",") pList[++j]=tmp_children_list[z]
				}
			}
			pList[++j]=proxyList[i]
		}
		p=j
		j=0
		for (i=1;i<=p;i++)
		{
			# avoid putting the same MO twice, this could otherwise happen where there are syscreated children of syscreated children, eg "ldel %ethernetswitchmoduleport=" - correction done in 10.0n
			if (doneDel[pList[i]]==1) continue
			doneDel[pList[i]]=1
			mList[++j]=pList[i]
		}
		p=j
		for (i=1;i<=p;i++)
		{
			proxyList[i]=mList[i]
		}
		if (rdel=="rec")
		{
			j=0
			#dont include the children if the function was called by rdel, this is to avoid the case when users do lrdel <mo> it should only take the MO not its children
			for (i in proxyList) zList[proxyList[i]]=proxyList[i]
			for (i=1;i<=p;i++)
			{
				t_parent=s2p(gensub(/,[^,]+$/,"",1,p2s("LdnMo",proxyList[i])))
				if (t_parent in zList && zList[t_parent]==t_parent) continue # if the MO has a parent in the proxy list we dont include it, only keep the highest parent since rdel deletes also the children
				fList[++j]=proxyList[i]
			}
			delete proxyList
			p=j
			for (i=1;i<=p;i++) proxyList[i]=fList[i]
		}
	}
	otherVars["p"]=p
	otherVars["Filter1"]=Filter1
	otherVars["Filter2"]=Filter2
	otherVars["Filter3"]=Filter3
	otherVars["syntaxOk"]=syntaxOk
	otherVars["Value_to_Set"]=Value_to_Set
	otherVars["Type"]=Type
}
function make_value_to_set(start,fset,  a,Value_to_Set,Type)
{
	if ($NF ~ /^a*[ilsbrft]$/ && fset=="force")
	{
		for (a=start;a<NF;a++) Value_to_Set = sprintf("%s %s",Value_to_Set,$a)
		Type=$NF
	}
	else
	{
		for (a=start;a<=NF;a++) Value_to_Set= sprintf("%s %s",Value_to_Set,$a)
	}
       	sub(/^ */,"",Value_to_Set)
	return sprintf("%s%s%s",Value_to_Set,SUBSEP,Type)
}
function buildMoGroup(what,molength,silent,   \
mogroup,Filter1,Filter2,Filter3,n,dest,i,p,proxyList,otherVars,max,l,ldnList,ldn,\
array,last,nr_of_groups,thisProxy,nr_of_ldn,z,tempTable,moclass,Me)
{
	if (extraMute=="extraMute") silent="silent"
	#what=add/remove/list
	nr_of_ldn=0
	mogroup=tolower($2)
	Filter1=$3
	Filter2=$4
	Filter3=$5
	if (mogroup=="")
	{
		if (what=="add" && Filter1=="")
		{
			if (silent != "silent") customPrint("Syntax: ma/lma <mogroup> <mogroup>|<proxys>|<mo-filter>|all [<attribute-filter>] [<value-filter>]")
			return
		}
		else if (what=="remove")
		{
			if (silent != "silent") customPrint("Syntax: mr/lmr <mogroup> [<mogroup>|<proxys>|<mo-filter>|all] [<attribute-filter>] [<value-filter>]")
			return
		}
	}
	if (what=="list")
	{
		n=asort(moGroupList,dest)
		customPrint(sprintf("====================================================\n%-20s  %s\n====================================================","MO-Group","Nr of MOs"))
		for (i=1;i<=n;i++)
		{
			if (dest[i] in moGroup && moGroup[dest[i]] != "")
			{
				last=split(moGroup[dest[i]],array,SUBSEP)
				customPrint(sprintf("%2s.  %-15s  %s",++nr_of_groups,dest[i],last))
			}
		}
		if (nr_of_groups >0) customPrint("\nTo view the contents of an MO group, type \"pr <mogroup>\"")
	}
	else
	{
		if (Filter1 != "" && Filter2=="")
		{
			$0="" ; $2=Filter1
			#Adding many proxys with comma in between eg ma 12,34,56
			if (Filter1 ~ /^[0-9]+(,[0-9]+)+$/) $0="pr "gensub(/,/," ","g",Filter1)
			buildProxyList(molength,proxyList,otherVars)
			p=otherVars["p"]
			for (i=1;i<=p;i++) ldnList[p2s("Mo",proxyList[i])]=p2s("Mo",proxyList[i])
		}
		else if (Filter1 != "")
		{
			old_get_printoutformat=get_printoutformat
			#get_printoutformat="proxy"
			#old_get_unit=get_unit
			#get_unit="nounits"
			mo_log(tempgalog,"open","mute","overwrite",silent)
			$0="" ; $2=Filter1 ; $3=Filter2 ; $4=Filter3 ;
			if (Filter2 ~ /^pm/) get(molength,"","","","","pm","mget")
			else get(molength,"","","","","","mget")
			mo_log(tempgalog,"close")
			get_printoutformat=old_get_printoutformat
			while (getline < tempgalog)
			{
				gsub("\r","") ; gsub("\x000","")
				if ($1 ~ /^[A-Z].*=/)
				{
					moclass=s2t($1)
					if (multi || multioffline)
					{
						Me=gensub(/,.*$/,"",1,$1)
						if (multi) moclass=sprintf("%s%s%s",momVersion[Me],SUBSEP,moclass)
					}
					#print $1,$3,p2s("MoType",$1),MoAttributesTypeJava[p2s("MoType",$1)":"$3]
					if (MoAttributesTypeJava[moclass":"$2]~ /^a*r$/ && Filter3 =="")
					{
						if ($3 ~ /^[A-Z].*=/)
						{
							thisProxy=giveMoProxy($3,"silent","",Me)
							ldnList[p2s("Mo",thisProxy)]=p2s("Mo",thisProxy)
						}
						else if ($3 ~ /^\[/)
						{
							max=gensub(/\[|\]/,"","g",$3)+0
							for (l=1;l<=max;l++)
							{
								getline < tempgalog
								gsub("\r","") ; gsub("\x000","")
								if (NF == 4)
								{
									thisProxy=giveMoProxy(gensub(/^ >>> .* = /,"",1,$0),"silent","",Me)
									ldnList[p2s("Mo",thisProxy)]=p2s("Mo",thisProxy)
								}
							}
						}
					}
					else if (Filter3 != "") ldnList[$1]=$1
				}
			}
			close(tempgalog)
		}
		if (what=="add")
		{
			last=split(moGroup[mogroup],array,SUBSEP)
			for (z in array) tempTable[array[z]]=1
			for (ldn in ldnList)
			{
				if (!(ldn in tempTable))
				{
					moGroup[mogroup]=moGroup[mogroup] SUBSEP ldn
					nr_of_ldn++
				}
			}
			sub(sprintf("%s$",SUBSEP),"",moGroup[mogroup])
			if (silent != "silent") customPrint(sprintf("\nAdded %s MOs to group: %s",nr_of_ldn,mogroup))
		}
		else if (what=="remove")
		{
			if (! (mogroup in moGroup))
			{
				if (silent != "silent") customPrint(sprintf("\nMO group %s does not exist.",mogroup))
				return
			}
			if (Filter1=="")
			{
				delete moGroup[mogroup]
				delete moGroupList[mogroup]
				if (silent != "silent") customPrint(sprintf("\nRemoved group: %s",mogroup))
			}
			else
			{
				last=split(moGroup[mogroup],array,SUBSEP)
				delete moGroup[mogroup]
				for (i=1;i<=last;i++)
				{
					if (array[i] in ldnList)
					{
						delete array[i]
						nr_of_ldn++
					}
				}
				for (i=1;i<=last;i++)
				{
					if (i in array && array[i] != "") moGroup[mogroup]=sprintf("%s%s%s",moGroup[mogroup],SUBSEP,array[i])
				}
				if (silent != "silent") customPrint(sprintf("\nRemoved %s MOs from group: %s",nr_of_ldn,mogroup))
			}
		}
		if (what != "list")
		{
			moGroupList[mogroup]=mogroup
			sub(sprintf("^%s",SUBSEP),"",moGroup[mogroup])
		}
		#print mogroup,moGroup[mogroup]
	}
}
function giveLdn(moDN,    proxy)
{
	proxy=giveMoProxy(moDN,"silent","ignorecase")
	if (proxy>0 && proxy in Ldn && Ldn[proxy]!="") moDN=Ldn[proxy]
	else if (comcli>0 && node_address!~/^OFFLINE_/ && moDN!="" && moDN!~/^ManagedElement=/) moDN=ComMe","moDN   #in case we gave a MO ref that does not exist then it should at least look like a LDN with ManagedElement in front, otherwise the exception will be confusing
	return moDN
}
function giveMoProxy(moDN,silent,ignorecase,Me,noload,   array,proxy,motypes,origMoDN)
{
	#if (mosdebug==1) print "giveMoProxy: "moDN
	#moDN can be of format FDN/LDN or of format mediumMo (without transportNetwork/Equipment/etc.)
	#the Me parameter is only used in multi mode, to know to which node the MO belongs to
	#it will be in the format: Me=xxx
	if (multi || multioffline)
	{
		if (tolower(moDN) ~ /^me=/) Me=s2me(moDN)"," ; else if (Me!="") Me=Me","
		if (moDN ~ /[Mm]anaged[eE]lement=[^,]+,/) moDN=Me gensub(/^.*[Mm]anaged[eE]lement=[^,]+,/,"",1,moDN)
		else if (tolower(moDN) !~ /^me=/) moDN=Me moDN
	}
	else moDN=gensub(/^.*[Mm]anaged[eE]lement=[^,]+,/,"",1,moDN)
	if (moDN !~ /^[^,= ]+=[^,= ]+/) return 0
	origMoDN=moDN
	if (ignorecase=="ignorecase") moDN=tolower(moDN)
	old_PrintProxySilent=PrintProxySilent
	if (silent=="silent") PrintProxySilent=2
	proxy=s2p(moDN)
	#print "here",moDN,s2p(moDN)
	if (proxy=="" && noload!="noload")
	{
		if (noload=="conditional")
		{
			motypes[s2t(moDN)]=1
			ConditionalLoad(motypes)
		}
		else if (node !~ /^OFFLINE/)
		{
			if (comcli>0)
			{
				$0="ld "origMoDN
				Load_Proxys("ldn","","","silent")
			}
			else
			{
				$0="lt "sprintf("^%s$",s2t(moDN))
				#print "loading ldn for type " $2
				Load_Proxys("type",0,"","silent","noconfirm")
			}
		}
		proxy=s2p(moDN)
	}
	PrintProxySilent=old_PrintProxySilent
	#in case we didn't find the proxy, we return the value 0 which is the ManagedElement
	#this MO is normally never looked up by the giveMoProxy function, so if we return 0 it means the MO was not found
	#if we would return some other dummy value (like -999) it would crash the mobrowser prematurely, therefore we return 0
	return proxy+0
}
function make_rbs_comcli(what,   xpList,xpCom)
{
	if (mom_version !~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/) return
	if (what~"c" && fileOps("test -s "temprbslog)==0) return
	if (node ~ /^OFFLINE/) return

	customPrint("\nCollecting RCS board data ...","","force")
	#makeRcsColiPath()
	mo_log(temprbslog,"open","mute","overwrite","silent")
	run_rcscoli_cmd("/diagm/bbte la -v;/misc/cmds;/board/hwpid;/fruacc/lhlist short;/fruacc/lhlist ldn")
	mo_log(temprbslog,"close")
	while (getline < temprbslog)
	{
		#Product Number: KDU137925/3
		#Product Revision: R4A
		#Product Name: DUS 52 01
		#Market Name:
		#Product Date: 2014-11-28T00:00:00.000+02:00
		#Product Serial Number: D16K827010
		#15B:
		#BXP_0                     RUS                  KRC 118 59/1              R2B             C823489602           20100426
		#BXP_0                     XMU 03 01            KDU 137 949/1             R1D             D16K187678           20141105
		#BXP_1                     XMU 03 01            KDU 137 949/1             R1D             D16K187678           20141105
		#16A:
		#BXP_0
		#BXP_1
		#fru_2048
		#bbEqm000001    EMCA1   01/00   xRATdefaultName/1     TRINITY3         0x6d99a6fe
		#bbEqm000002    EMCA2   01/01   xRATdefaultName/0     GratBb           0x6dc1eab5
		#bbEqm000003    EMCA3   01/02   xRATdefaultName/0     TRINITY3         0x6d99a6fe
		#bbEqm000004    EMCA4   01/03   xRATdefaultName/0     GratBb           0x6dc1eab5

		#ManagedElement=1,Equipment=1,FieldReplaceableUnit=9           BXP_3_1

		if ($1~/^BXP_[0-9]|^fru_[0-9]+$/) xpList[$1]=$1
	}
	close(temprbslog)
	n=xpsort(xpList)
	for (i=n;i>=1;i--) xpCom=xpCom "/fruacc/lhsh "xpList[i]" par get SYS_HW*;"
	old_muteFactor=muteFactor
	muteFactor=2
	mo_log(temprbslog,"open","mute","","silent")
	run_rcscoli_cmd(xpCom)
	mo_log(temprbslog,"close")
	muteFactor=old_muteFactor
	print ""
}
function xpsort(xpList,   i,a,n,x,j)
{
	for (i in xpList)
	{
		x=xpList[i]
		if (x !~ /^BXP_|^fru_[0-9]+$/) continue
		n=split(x,a,"_")
		x=""
		for (j=1;j<=n;j++) x=sprintf("%s%3s_",x,a[j])
		sub(/_$/,"",x)
		xpList[i]=x
	}
	n=asort(xpList)
	for (i=1;i<=n;i++) gsub(/ /,"",xpList[i])
	return n
}
function parse_rcsColiLine(   thecom,thepath)
{
	RcsColiPath[$1]=$1
	thecom=gensub(/^.*\//,"",1,$1)
	thepath=gensub(/\/[^/]+$/,"",1,$1)
	#if the same command exists in several paths, we take the first occurrence , not the last one
	#the reason is for the commands te/llog/dump/ts which exist in /diagm , /ee, /wrat.  We want to take those in /diagm (/ee is deprecated)
	#but in some cases we want to take the later occurrence, for instance if the Linux based RU had registered some commands in /bin or
	#/bin/ps
	#/opt/radio/bin/core
	#/opt/radio/bin/pmd
	#/opt/radio/bin/te
	#/usr/bin/od
	#/usr/bin/uptime
	#/usr/local/bin/restart

	if (RcsColiPath[thecom]!="" && RcsColiPath[thecom]!~/\/bin$/) return
	#If there is access to linux shell then we take the commands ls/cd/grep/pwd from unix shell not coli shell
	if (checkIpContactPort22Refused!=1 && thecom ~ /^(ls|cd|grep|pwd)$/) return
	#we dont take the commands under /fruacc/ru and /fruacc/xmu
	if (thepath~/^\/fruacc\/(ru|xmu)$/) return
	RcsColiPath[thecom]=thepath
	RcsColiDir[thepath]=1
	rcsColiPath_done=1
	rcsColiDir_done=1
}
function parse_rbs_comcli(     currXp,a,xpList,i,thecom,thepath,tPid,haveBd,t_mo,notCtx)
{
	clear_rbs_comcli()
	pdrFetched=1
	if (fileOps("test -s "temprbslog)!=0) return 0
	rcsColiDir_done=1
	while (getline < temprbslog)
	{
		#/board/vii
		#/wrat/upt/aichmon
		#Product Name: DUS 52 01
		#Product Serial Number: D16N444124
		#coli>/fruacc/lhsh BXP_4 par get SYS_HW*
		#'SYS_HW_PID'         = 'KRC 161 254/1'
		#'SYS_HW_NAME'        = 'RRUS 12mB1'
		#'SYS_HW_SERIAL'      = 'D16N894536'
		#XMU:
		#productname='XMU 03 01'
		#serialnumber='D16K187678'
		#RRUL11:
		#Product name: RRUL 11 B13
		#Serial number: C84A000586

		if ($1=="coli>/board/hwpid") currXp="000100"
		else if ($1=="coli>/fruacc/lhsh") currXp=$2
		else if (NF==1 && $1~/^[/][^/]+[/][^/]+/) parse_rcsColiLine()
		else if ($1~/^bbEqm[0-9]+$/)
		{
			#bbEqm000001    EMCA1   01/00   xRATdefaultName/1     TRINITY3         0x6d99a6fe
			#bbEqm000002    EMCA2   01/01   xRATdefaultName/0     GratBb           0x6dc1eab5
			#bbEqm000003    EMCA3   01/02   xRATdefaultName/0     TRINITY3         0x6d99a6fe
			#bbEqm000004    EMCA4   01/03   xRATdefaultName/0     GratBb           0x6dc1eab5
			GcpuList["000100/"$1]="000100/"$1
			GcpuSwList["000100/"$1]=$5
		}
		#ManagedElement=1,Equipment=1,FieldReplaceableUnit=9          BXP_3_1
		#ManagedElement=1,Equipment=1,FieldReplaceableUnit=AAS-1          fru_2048             AIR 6468 B41E          KRD 901 055/1          R1A          C82A579070          20170208
		else if ($1~/^ManagedElement=[^,]+,Equipment=1,/ && $2~/^BXP_|^fru_[0-9]+$/)
		{
			#If a board has several BXP addresses, take the lowest one
			#ManagedElement=1,Equipment=1,FieldReplaceableUnit=2          BXP_0                XMU 03 01          KDU 137 949/1          R1F          Undefined          Undefined
			#ManagedElement=1,Equipment=1,FieldReplaceableUnit=2          BXP_1                XMU 03 01          KDU 137 949/1          R1F          Undefined          Undefined
			t_mo=gensub(/ManagedElement=[^,]+,/,"",1,$1)
			if (lhlistLdn[t_mo]~/BXP_[0-9]|^fru_[0-9]+$/ && $2>lhlistLdn[t_mo]) continue
			lhlistLdn[t_mo]=$2
			#special handling for BB R518 and vRU
			#ManagedElement=1,Equipment=1,FieldReplaceableUnit=2          BXP_0                Baseband R518          KDU 137 971/1          R1A          D16R635509          20151211
			#ManagedElement=1,Equipment=1,FieldReplaceableUnit=3          BXP_0_15             vRU                    KRC 161 295/1          R1A          9999999915          20160628
			if ($0 ~ / KDU ?137 ?971\/1 /)      { BoardType[$2]="XMU0318"  ; haveBd[$2]=1 }
			else if ($0 ~ / KDU ?137 ?949\/1 /) { BoardType[$2]="XMU0301"  ; haveBd[$2]=1 }
			else if ($0 ~ / KRC ?161 ?295\/1 /) { BoardType[$2]="vRU"    ; haveBd[$2]=1 }
		}
		else
		{
			#Product Name: Baseband 6303
			#Product Name: Baseband 6502
			if ($1=="Product" && $2=="Name:" && tolower($0) ~ /product name: .*baseband.*(6303|6502)/)
			{
				if ($NF ~ "6303") $0="Product Name: ODS6303"
				else if ($NF ~ "6502") $0="Product Name: ODS6502"
			}
			split($0,a,/[:=]/)
			gsub(/[ ']/,"",a[2])
			if ($0~/^'SYS_HW_(DATE|REV)'/) notCtx[currXp]=1
			if ($0~/^('SYS_HW_NAME' *=|productname=|Product Name:|Product name:)/)
			{
				if (haveBd[currXp]!=1) BoardType[currXp]=a[2]
			}
			else if ($0~/^'SYS_HW_PID' *=/) tPid[currXp]=a[2]
			else if ($0~/^('SYS_HW_SERIAL' *=|serialnumber=|Product Serial Number:|Serial number:)/)
			{
				#'SYS_HW_SERIAL'      = 'BXP_1_10'
				if (a[2] ~ /^BXP_/) sub(/^BXP_/,"XP_",a[2])
				if ($0~/^'SYS_HW_SERIAL' *=/ && notCtx[currXp]!=1) #&& a[2] in XpSerial && XpSerial[a[2]]!=""
				{
					#special case for CTX where all the XP boards have the same serial number so we make the serial number unique by appending the BXP
					a[2]=a[2]"_"gensub(/^BXP_/,"XP_",1,currXp)
				}
				XpSerial[currXp]=a[2]
				XpSerial[a[2]]=currXp
				xpList[a[2]]=currXp
			}
		}
	}
	close(temprbslog)
	rcsColiDir_done=1
	n=asort(xpList)
	for (i in xpList)
	{
		BoardLnhList[xpList[i]]=xpList[i]
		availableBoardList[xpList[i]]=xpList[i]
	}
	fix_BoardType_table(tPid)
}
function fix_BoardType_table(tPid,   i,tpn)
{
	for (i in BoardType)
	{
		if (BoardType[i]~/^(TRANSCEIVER|R?RU([LWS]([01]1)?)?)$/ && tPid[i]!="")
		{
			tpn=translate_hw(tPid[i],BoardType[i],"replace")
			if (tpn ~ "RU") BoardType[i]=tpn
		}
	}
}
function replace_bdtype(prodnr,prodname,   res)
{
	res=prodname
	if (prodname ~ /^(TRANSCEIVER|R?RU([LWS]([01]1)?)?)$/) res=translate_hw(prodnr,prodname,"replace")
	return res
}

function clear_rbs_comcli()
{
	delete GcpuList
	delete GcpuSwList
	delete XpSerial
	delete BoardType
	delete BoardLnhList
	delete RcsColiPath
	delete RcsColiDir
	delete lnhMoTable
	delete moLnhTable
	delete lhlistLdn
}
function makeRcsColiPath(      old_dollar0,thecom,thepath,vfru)
{
	if (is_rcs()==0) return
	if (length(RcsColiPath)>1 && rcsColiPath_done==1) return
	rcsColiPath_done=1
	old_dollar0=$0
	if (node ~ /^OFFLINE/ && fileOps("test -s "temprbslog)==0) fileOps("cp "temprbslog" "temprbscmdslog)
	else
	{
		delete RcsColiPath
		delete RcsColiDir
		mo_log(temprbscmdslog,"open","mute","overwrite","silent")
		comclimode("y")
		comclimode("1")
		$0="\\t" ; cmd()
		$0="/misc/cmds" ; cmd()
		comclimode("z")
		mo_log(temprbscmdslog,"close")
	}
	while (getline < temprbscmdslog)
	{
		#/board/vii
		#/wrat/upt/aichmon
		#/ antm/ board/ cli/ cm/ com/ cram/ diagm/ fruacc/ frum/ grat/ ipt/ labonly/ license/ log/ lrat/ misc/ netsync/ os/ pms/ secm/ swm/ sysm/ tn/ wrat/
		#ManagedElement=1,Equipment=1,FieldReplaceableUnit=1
		#/ board/ cli/ cm/ com/ consul/ diagm/ labonly/ license/ log/ lrat/ misc/ os/ pms/ secm/ swm/ sysm/ tn/
		#'$default_fru_id' MpId = 1
		#ppf/

		if (NF==1 && $1~/^[/][^/]+[/][^/]+/) parse_rcsColiLine()
		else if ($1~/^[a-z]+[/]$/)
		{
			#ppf/
			RcsColiPath[$1]=$1
			RcsColiDir[$1]=1
			vfru=$1
		}
		else if ($1~/^[/][^/]+$/)
		{
			#/getRbStateCounters
			RcsColiPath[$1]=RcsColiPath[gensub(/^[/]/,"",1,$1)]=vfru" "
		}
	}
	close(temprbscmdslog)
	rcsColiDir_done=1
	$0=old_dollar0
}
function makeComcliCommandString(      old_dollar0,cTable,n,i,thecom)
{
	if (comcli==0) return
	if (length(comcliCommandString)>0 && comcliCommandString_done==1) return
	comcliCommandString_done=1
	old_dollar0=$0
	delete cTable
	mo_log(tempcomclicmdslog,"open","mute","overwrite","silent")
	comclimode("y")
	comclimode("+")
	$0="?" ; cmd()
	$0="\\t" ; cmd()
	comclimode("z")
	mo_log(tempcomclicmdslog,"close")
	while (getline < tempcomclicmdslog)
	{
		#show()
		#ManagedElement=PRBS414
		#femtolog
		if (($1~/\(\)$/)||(NF==1 && $1~/^[a-z]/))
		{
			thecom=gensub(/\(\)$/,"",1,$1)
			cTable[thecom]=thecom
		}
	}
	close(tempcomclicmdslog)
	n=asort(cTable)
	#if (n==0) comcliCommandString="^(configure|dn|help|history|length|prompt|scriptmode|show|show-[^ ]+|top|up|version|width)$"
	comcliCommandString="^(\\\\t|"
	for (i=1;i<=n;i++) if (cTable[i]~/^[a-zA-Z]/) comcliCommandString=comcliCommandString cTable[i] "|"
	sub(/\|$/,"",comcliCommandString)
	comcliCommandString=comcliCommandString ")$"
	$0=old_dollar0
}
function make_grpboardlist(    array,i,last)
{
	#grpBoardList[001100]=coremp;mp
	#grpBoardList[001900/sp0.lnh]=pdr;pdr1
	delete grpBoardList
	for (i in bdGroup)
	{
		split(bdGroup[i],array,";")
		for (j in array) grpBoardList[array[j]]=grpBoardList[array[j]]";"i
	}
	for (i in grpBoardList)
	{
		split(grpBoardList[i],array,";")
		delete grpBoardList[i]
		last=asort(array)
		for (j=1;j<=last;j++) if (array[j]!="") grpBoardList[i]=grpBoardList[i]" "array[j]
		sub(/^ */,"",grpBoardList[i])
	}
}
function make_posTable(posTable,  i)
{
	#posTable[1]=1
	#...
	#posTable[28]=28
	#posTable[29]=0
	for (i=1;i<=28;i++) posTable[i]=i
	posTable[29]=0
}
function buildBoardGroup(what,bswitch,cswitch,oswitch,force, \
silent,i,bdgroup,j,board,bdList,addSpms,k,array,last,word,maxword,smn,apn,n,smnList,bd,output,\
bdListOrig,unwantedBoard,NrOfRemovedBoards,bdApn,tempLnh,howMany,b,d,ok,m,tmpfro,posTable,z,tmpPiu,arraySpm,tBoard,brNeg,mfield,dest,arrayw)
{
	#the force parameter is needed when adding boards based on board type which are not in availableBoardList table and not yet part of any board group
	#this is currently the case for for cmxb in 3820/mgwv4 , TR HT48511
	#it is also used for the case of any XB boards in EvoC (CMXB, SCXB, SMXB, CCIB) since they dont appear in "csti topology" after active core MP restart , CSR2860213
	if (multi || multioffline) return multi_error()
	if (comcli>0)
	{
		if (Start_moMode()==1) return 1
		if (mom_version !~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/)  return comcli_error("rcs")
	}
	if (refreshBoardTables==1)
	{
		#this variable is set by Start_moMode in case the loaded CV has changed
		#at the next occurrence of this function, the data will be refreshed
		oswitch="r"
		refreshBoardTables=0
	}
	#BoardLnhList[000100]=000100
	#BoardLnhList[002000/sp0.lnh]=002000/sp0.lnh
	#BoardType[002000]=SPB
	#SpmList[002000]=sp0.lnh;sp1.lnh;sp2.lnh
	#availableBoardList[002000]=002000
	#bdGroup["mod"]=001400;001500;....
	#what=add/remove/list
	if (node == "OFFLINE" || (node ~ /^OFFLINE_/ && OffOk != 1))
	{
		customPrint("\nCommand unavailable in offline mode.")
		return
	}
	if (cswitch ~ "m") silent=1
	if ($1 != "" && silent < 1) customPrint("")
	bdgroup=tolower($2)
	if (tolower($1) ~ "s") addSpms=1
	for (i=3;i<=NF;i++) word[i]=$i
	maxword=NF
	if (oswitch ~ "r")
	{
		pdrFetched=0 ; boRefresh=1 ; defaultGroupsMade=0 ; uerTablesMade=0 ; rcsColiPath_done=0 ; rcsColiDir_done=0 ; comcliCommandString_done=0 ; comcli_use_showmoc_HasBeenSet=0
		rcs_mainfru_done=0
		#remove the cabHwInfoFile to force cab to re-read the boards
		fileOps("rm "tempcabhw)
	}
	availableBoards()
	#if (what ~ /^(add|remove|extract:[0-9]+)$/ && defaultGroupsMade==1)
	#{
	#	if (tolower(mom_version) ~ "rnc" && bdgroup ~ /^(all|allp|mp|bp|coremp|mod[0-9]*|dc[0-9]*|cc[0-9]*|pdr[0-9]*|spb[0-9]*)$/)
	#	{
	#		customPrint(sprintf("Board group name \"%s\" is reserved. Please choose a different name.",bdgroup))
	#		return
	#	}
	#	else if (bdgroup ~ /^(all|allp|mp|bp|coremp)$/)
	#	{
	#		customPrint(sprintf("Board group name \"%s\" is reserved. Please choose a different name.",bdgroup))
	#		return
	#	}
	#}
	if (what == "xyz1")
	{
		make_rnc_coli()
		system("cat "temprnclog)
		return
	}
	else if (what == "xyz2")
	{
		make_rft_coli()
		system("cat "temprftlog)
		return
	}
	if (what ~ /^extract/)
	{
		j=0
		howMany=gensub(/extract:/,"",1,what)+0
		if (word[3] in bdGroup && bdGroup[word[3]] != "")
		{
			split(bdGroup[word[3]],array,";")
			for (i in array)
			{
				j++
				if (j > howMany) break
				bdList[array[i]]=array[i]
				#print "DEBUG:"j,howMany,array[i]
			}
		}
		n=asort(bdList,dest)
		NrOfBoards[bdgroup]=n
		delete bdGroup[bdgroup]
		for (i=1;i<=n;i++) bdGroup[bdgroup]=sprintf("%s;%s",bdGroup[bdgroup],dest[i])
		sub(/^;/,"",bdGroup[bdgroup])
		if (NrOfBoards[bdgroup] != 0)
		{
			bdGroupList[bdgroup]=bdgroup
			if (silent < 1) customPrint(sprintf("Extracted %s boards to group: %s",n,bdgroup))
		}
		return
	}
	if (what != "" && bswitch=="mo")  #bam[s]/brm
	{
		for (i=3;i<=maxword;i++)
		{
			if (word[i] in moGroup && moGroup[word[i]] ~ "PlugInUnit=")
			{
				split(moGroup[word[i]],array,SUBSEP)
				for (j in array)
				{
					#lnhMoTable[Equipment=1,Subrack=MS,Slot=14,PlugInUnit=1]=001400
					#lnhMoTable[Equipment=1,Subrack=MS,Slot=19,PlugInUnit=1,Spu=1,Spm=1]=001900/sp0.lnh
					#lnhMoTable[Equipment=1,Subrack=MS,Slot=19,PlugInUnit=1,PiuDevice=1]=002100/d00001
					#Subrack=MSE2,Slot=16,PlugInUnit=1,MsbAmcCarrierUnit=1
					if (s2t(array[j]) !~ /^(PlugInUnit|PiuDevice|Spm|MsbAmcCarrierUnit)$/) continue
					if (s2t(array[j]) == "MsbAmcCarrierUnit") sub(/,MsbAmcCarrierUnit=.*$/,"",array[j])
					if (!(array[j] in lnhMoTable && lnhMoTable[array[j]] != "")) continue
					tBoard=lnhMoTable[array[j]]
					bdList[tBoard]=tBoard
					if (addSpms==1 && tBoard ~ /00$/)
					{
						last=split(spmList[tBoard],arraySpm,";")
						for (z=1;z<=last;z++) bdList[sprintf("%s/%s",tBoard,arraySpm[z])]=sprintf("%s/%s",tBoard,arraySpm[z])
					}
				}
			}
		}
	}
	else if (what != "" && bswitch=="")
	{
		for (i=3;i<=maxword;i++)
		{
			#handle the case where we put a negative filter in the br command to remove all boards except those matching the script
			#eg: br etip !000600
			if (what=="remove" && word[3] ~ /^!.+/ && maxword==3)
			{
				sub(/^!/,"",word[3])
				brNeg=1
			}
			if (word[i] ~ /^[0-9][0-9][0-2][0-9]00\/(sp[0-9].lnh|d0000[0-9])$/)
			{
				if (word[i] in BoardLnhList && BoardLnhList[word[i]]==word[i]) bdList[word[i]]=word[i]
			}
			else if (word[i] ~ /^[0-9]+$/ || word[i] ~ /^([0-9][0-9][0-9][0-9]00\/)?(gcpu[0-9][0-9][0-9][0-9][0-9]|BXP_[0-9]+(_[0-9]+)*|port_(xcu|[0-9]+)_dev_.*)$/)
			{
				if (word[i] ~ /^[0-9]+$/)
				{
					if (length(word[i]) > 4) sub(/00$/,"",word[i])
					board=sprintf("%04d00",word[i])
				}
				else board=word[i]
				if ((board in availableBoardList && availableBoardList[board]==board)||(board in grpBoardList && grpBoardList[board]!=""))
				{
					bdList[board]=board
					if (addSpms==1)
					{
						last=split(spmList[board],array,";")
						for (j=1;j<=last;j++) bdList[sprintf("%s/%s",board,array[j])]=sprintf("%s/%s",board,array[j])
					}
				}
			}
			else if (word[i] ~ /^[0-9]+-[0-9]+$/)
			{
				split(word[i],arrayw,"-")
				for (z in arrayw) { if (length(arrayw[z]) > 4) sub(/00$/,"",arrayw[z]) }
				for (k=arrayw[1];k<=arrayw[2];k++)
				{
					board=sprintf("%04d00",k)
					if (board in availableBoardList && availableBoardList[board]==board)
					{
						bdList[board]=board
						if (addSpms==1)
						{
							last=split(spmList[board],array,";")
							for (j=1;j<=last;j++) bdList[sprintf("%s/%s",board,array[j])]=sprintf("%s/%s",board,array[j])
						}
					}
				}
			}
			else if (word[i] in bdGroup && bdGroup[word[i]] != "")
			{
				split(bdGroup[word[i]],array,";")
				for (j in array)
				{
					bdList[array[j]]=array[j]
					if (addSpms==1)
					{
						last=split(spmList[array[j]],arraySpm,";")
						for (z=1;z<=last;z++) bdList[sprintf("%s/%s",array[j],arraySpm[z])]=sprintf("%s/%s",array[j],arraySpm[z])
					}
				}
			}
			else if (tolower(word[i]) ~ /^[a-z]+/)
			{
				for (board in BoardType)
				{
					if ((tolower(BoardType[board]) ~ tolower(word[i])) && \
					   ((board in availableBoardList && availableBoardList[board]==board)||(board in grpBoardList && grpBoardList[board]!="")||(force=="force")))
					{
						bdList[board]=board
						if (addSpms==1)
						{
							last=split(spmList[board],array,";")
							for (j=1;j<=last;j++) bdList[sprintf("%s/%s",board,array[j])]=sprintf("%s/%s",board,array[j])
						}
					}
				}
			}
		}
	}
	else if (what != "" && word[3] != "")
	{
		for (board in BoardLnhList)
		{
			if ( (tolower(SwaBoTable[board]) ~ tolower(word[3]) && bswitch=="swa" && SwaBoTable[board] != "") || \
			     (tolower(deviceTypeTableLnh[board]) ~ tolower(word[3]) && bswitch=="dev" && deviceTypeTableLnh[board] != "") || \
			     (tolower(BoardProgramList[board]) ~ tolower(word[3]) && bswitch=="pgm" && BoardProgramList[board] != "") || \
			     (tolower(BoardRpuList[board]) ~ tolower(word[3]) && bswitch=="rpu" && BoardRpuList[board] != "") )
			{
				ok=0
				if (word[4] == "") ok=1
				else if (word[4] != "")
				{
					if (bswitch=="dev" && board ~ "/d0000" && tolower(word[3])=="cc" && maxCoreModule<4)
					{
						#special case on SPB4, the cc devices usually do not have the same module as the pdr that is on the same spm
						#but dont do this on EvoC8300 with CPEff
						if ((board":2") in rncModBoTable && rncModBoTable[board":2"]==word[4]) ok=1
					}
					else if (board in rncModBoTable && rncModBoTable[board]  == word[4])
					{
						ok=1
					}
					else
					{
						for (m=1;m<=maxCoreModule;m++)
						{
							if ((board,m) in rncModBoTable && rncModBoTable[board,m] == word[4]) ok=1
						}
					}
					#special case for EPB, add the PiuDevice to all dc and pdr MO groups. But dont do this on EvoC8300
					tmpPiu=gensub(/\/d0000.*$/,"",1,board)
					if (bswitch=="dev" && board ~ "/d0000" && tolower(word[3]) ~ /^(dc|pdr)$/ && BoardType[tmpPiu]~/^EPB/ && cpplinux!=1)
					{
						if ((tmpPiu) in rncModBoTable && rncModBoTable[tmpPiu]==word[4]) ok=1
					}
				}
				if (ok==0) continue
				bdList[board]=board
				if (addSpms==1)
				{
					last=split(spmList[board],array,";")
					for (j=1;j<=last;j++) bdList[sprintf("%s/%s",board,array[j])]=sprintf("%s/%s",board,array[j])
				}
			}
		}
	}
	if (what=="add")
	{
		if (bdgroup in bdGroup && bdGroup[bdgroup] != "")
		{
			last=split(bdGroup[bdgroup],array,";")
			for (i=1;i<=last;i++) bdList[array[i]]=array[i]
		}
		n=mysort(bdList,dest,1)
		NrOfBoards[bdgroup]=n
		delete bdGroup[bdgroup]
		for (i=1;i<=n;i++) bdGroup[bdgroup]=sprintf("%s;%s",bdGroup[bdgroup],dest[i])
		sub(/^;/,"",bdGroup[bdgroup])
		if (NrOfBoards[bdgroup] != 0)
		{
			bdGroupList[bdgroup]=bdgroup
			if (silent < 1) customPrint(sprintf("Added %s boards to group: %s",n,bdgroup))
		}
	}
	else if (what=="remove")
	{
		if (maxword > 2 && bdgroup in bdGroup && bdGroup[bdgroup] != "")
		{
			last=split(bdGroup[bdgroup],array,";")
			for (i=1;i<=last;i++) bdListOrig[array[i]]=array[i]
			if (brNeg==1)
			{
				for (unwantedBoard in bdListOrig)
				{
					if (!(unwantedBoard in bdList && bdList[unwantedBoard]!=""))
					{
						NrOfRemovedBoards++
						delete bdListOrig[unwantedBoard]
					}
				}
			}
			else
			{
				for (unwantedBoard in bdList)
				{
					if (bdListOrig[unwantedBoard] != "") NrOfRemovedBoards++
					delete bdListOrig[unwantedBoard]
				}
			}
			n=mysort(bdListOrig,dest,1)
			NrOfBoards[bdgroup]=n
			delete bdGroup[bdgroup]
			for (i=1;i<=n;i++) bdGroup[bdgroup]=sprintf("%s;%s",bdGroup[bdgroup],dest[i])
			sub(/^;/,"",bdGroup[bdgroup])
			if (NrOfRemovedBoards > 0 && silent < 1) customPrint(sprintf("Removed %s boards from group: %s",NrOfRemovedBoards,bdgroup))
		}
		else
		{
			delete bdGroup[bdgroup]
			delete bdGroupList[bdgroup]
			delete NrOfBoards[bdgroup]
			if (silent < 1) customPrint(sprintf("Removed group: %s",bdgroup))
		}
	}
	else if ((what=="list")||(comcli>0 && what=="overview"))  #on MSRBS, bo does the same as "bp all"
	{
		if (comcli>0 && what=="overview") bdgroup="all"
		make_grpboardlist()
		if (bdgroup == "")
		{
			n=asort(bdGroupList,dest)
			customPrint(sprintf("====================================================\n%-20s  %s\n====================================================","Board-Group","Nr of Boards"))
			for (i=1;i<=n;i++)
			{
				if (NrOfBoards[dest[i]] < 1) continue
				customPrint(sprintf("%-20s  %s",dest[i],NrOfBoards[dest[i]]))
			}
			customPrint(sprintf("====================================================\nTotal: %s groups",n))
		}
		else
		{
			customPrint("===============================================================================================")
			customPrint(sprintf("%-6s  %-*s  %s%s%s  %s","Board",(mom_version~/^RBS/?28:13),"BoardType",\
			(mom_version~"RNC"?sprintf("%10s  ","Mod  (fro)"):""),(useRncModuleName==1?sprintf("%-9s  ","ModName"):""),\
			(mom_version~"RNC"?sprintf("%-20s","SwAllocation/DevType"):sprintf("%-30s","SwAllocation")),"BoardGroups"))
			customPrint("===============================================================================================")
			last=split(bdGroup[bdgroup],array,";")
			b=0 ; d=0
			for (i=1;i<=last;i++)
			{
				tmpfro=""
				if (rncModBoTable[array[i]] != "")
				{
					tmpfro=rncModMoFro["RncModule="rncModuleName[rncModBoTable[array[i]]]]
					if (tmpfro != "") tmpfro="("tmpfro")"
				}
				if (array[i] ~ /\/|_|gcpu|bbEqm/)
				{
					if (mom_version~"RNC") mfield=sprintf("**%-*s",18,deviceTypeTableLnh[array[i]])
					else if (array[i] in BoardType && BoardType[array[i]]!="") mfield=sprintf("**%-*s",28,BoardType[array[i]])
					else if (array[i] in GcpuSwList && GcpuSwList[array[i]]!="") mfield=sprintf("**%-*s",28,GcpuSwList[array[i]])
					else mfield=sprintf("**%-*s",28,"")
					customPrint(sprintf("%-*s  %s%s%s  %s",(mom_version~/^RBS/?36:21),array[i],\
					(mom_version~"RNC"?sprintf("%4s %5s  ",rncModBoTable[array[i]],tmpfro):""),\
					(useRncModuleName==1?sprintf("%-9s  ",rncModuleName[rncModBoTable[array[i]]]):""),mfield,grpBoardList[array[i]]))
					if (array[i]~/\/(sp|d|gcpu|bbEqm)/) d++ ; else b++
				}
				else
				{
					customPrint(sprintf("%-6s  %-*s  %s%s%-*s  %s",\
					array[i],(mom_version~/^RBS/?28:13),BoardType[array[i]],\
					(mom_version~"RNC"?sprintf("%4s %5s  ",rncModBoTable[array[i]],tmpfro):""),\
					(useRncModuleName==1?sprintf("%-9s  ",rncModuleName[rncModBoTable[array[i]]]):""),\
					(mom_version~"RNC"?20:30),SwaBoTable[array[i]],grpBoardList[array[i]]))
					b++
				}
			}
			customPrint(sprintf("===============================================================================================\nTotal: %s boards%s",b,(d>0?", "d" devices":"")))
			assignCustomVar("$nr_of_boards",b)
		}
		show_coli_warning()
	}
	else if (what=="overview")
	{
		if (node ~ /^OFFLINE_/ && OffOk==1) last=asort(BoardLnhList,array)
		else last=split(bdGroup["all"],array,";")
		for (i=1;i<=last;i++)
		{
			if (array[i] ~ /sp..lnh|port_(xcu|[0-9]+)_dev/) continue
			smn=gensub(/....$/,"",1,array[i])
			apn=gensub(/^..|..$/,"","g",array[i])
			bd[smn,apn]=array[i]
			bdApn[smn,apn]=apn
			smnList[smn]=smn
		}
		if (nocorba==1)
		{
			n=asort(smnList,dest)
			customPrint("=================================================================================================================")
			for (j=1;j<=n;j++)output=sprintf("%s  SMN=%02d       ",output,dest[j])
			sub(/^  /,"",output)
			customPrint(output"\n=================================================================================================================")
			make_posTable(posTable)
			for (z=1;z<=29;z++)
			{
				i=posTable[z]
				output=""
				for (j=1;j<=n;j++)
				{
					tempLnh=sprintf("%s%s%s",dest[j],SUBSEP,sprintf("%02d",i))
					output=sprintf("%s  %2s %-10s",output,bdApn[tempLnh],BoardType[bd[tempLnh]])
				}
				sub(/^  /,"",output)
				if (output !~ /^ *$/) customPrint(output)
			}
		}
		else
		{
			delete dest
			n=NrOfSubracks
			for (i=1;i<=n;i++) dest[i]=sprintf("%02d",SortedSmnTable[i])
			if (n<=3) printBoTable(1,n,smnList,dest,bdApn,bd,oswitch)
			else if (n>3 && n<=6)
			{
				printBoTable(1,3,smnList,dest,bdApn,bd,oswitch)
				printBoTable(4,n,smnList,dest,bdApn,bd,oswitch)
			}
			else if (n>6 )
			{
				printBoTable(1,3,smnList,dest,bdApn,bd,oswitch)
				printBoTable(4,6,smnList,dest,bdApn,bd,oswitch)
				printBoTable(7,n,smnList,dest,bdApn,bd,oswitch)
			}
		}
		#printBoTables()
	}
}
function process_swa(string)
{
	if (string !~ /^3GSIM_/) return string
	sub(/^3GSIM_/,"",string)
	gsub(/_RBS/,"_R",string)
	return string
}
function printBoTable(start,stop,smnList,dest,bdApn,bd,what,  output,i,j,z,posTable,k)
{
	customPrint("================================================================================================================================")
	for (j=start;j<=stop;j++)
	{
		if (tolower(mom_version) ~ "rnc") output=sprintf("%s  %02d    M BoardType %-*s %-*s",output,dest[j],fieldLength["devs"],"Devs",fieldLength["swa"],"SwAllocation")
		else output=sprintf("%s  %02d BoardType %-*s",output,dest[j],fieldLength["swa"],"SwAllocation")
	}
	sub(/^  /,"",output)
	customPrint(output"\n================================================================================================================================")
	make_posTable(posTable)
	for (k=1;k<=29;k++)
	{
		i=posTable[k]
		output=""
		for (j=start;j<=stop;j++)
		{
			tempLnh=sprintf("%s%s%s",dest[j],SUBSEP,sprintf("%02d",i))
			#workaround for cmxb, does not appear in board group "all" due to not accessible via linkhandler
			z=sprintf("%02d%02d00",dest[j],i)
			if (z in BoardType && BoardType[z]~/^(CMXB|SCXB|CCIB|SMXB)/) { bdApn[tempLnh]=sprintf("%02d",i) ; bd[tempLnh]=z }
			if (what~"a" && (!(tempLnh in bdApn)))
			{
				bdApn[tempLnh]=sprintf("%02d",i) ; bd[tempLnh]=z ; BoardType[bd[tempLnh]]="UNCONF"
			}
			if (tolower(mom_version) ~ "rnc") output=sprintf("%s  %2s %4s %-9s %-*s %-*s",output,bdApn[tempLnh],rncModBoTable[bd[tempLnh]],BoardType[bd[tempLnh]],fieldLength["devs"],deviceTypeTableShort[bd[tempLnh]],fieldLength["swa"],SwaBoTable[bd[tempLnh]])
			else output=sprintf("%s  %2s %-9s %-*s",output,bdApn[tempLnh],BoardType[bd[tempLnh]],fieldLength["swa"],process_swa(SwaBoTable[bd[tempLnh]]))
		}
		sub(/^  /,"",output)
		if (output !~ /^ *$/) customPrint(output)
	}
}
function numerize_portdev(string,    array)
{
	#for sorting purposes, the first number is multiplied by 1000 and added to the second number.
	#port_2_dev_4   --->  2004
	#port_10_dev_2  ---> 10002

	#Previously it was multiplied by 10 and added to the second number but the problem arises for some combinations which then give the same value, eg: port_2_dev_25 and port_4_dev_5 gives same result --> 45

	if (string !~ /^port_(xcu|[0-9]+)_dev_[0-9]+/) return 0
	split(string,array,"_")
	return sprintf("%s000",array[2])+array[4]
}
function parse_drh(       devlast,devarray,modPos,currlnh,lnharray,last,i,ok,devOffset)
{
	set_rnc_type()
	rncModFroMo["-1"]="RncModule=0"
	rncModuleNumber["RncModule=0"]="0"
	if (fileOps("test -s "tempdrhlog)!=0) return
	ok=0
	modPos=8
	if (mosdebug==1)
	{
		print "BEFORE DRH PROCESSING"
		tablePrint(rncModBoTable       ,"rncModBoTable")
		tablePrint(rncModTable         ,"rncModTable")
		tablePrint(firstModProgInstanceId,"firstModProgInstanceId")
	}
	while (getline < tempdrhlog)
	{
		#==============================================CC POOL===============================================
		#spmFroId  devFroId  spPid  admStateUnlocked  opStateEnabled  capability  subrack  servingRhModuleId  msgBoard
		#      66        13  71050                 1               1           1        2                  2  [attached synced allocated ]
		#==============================================DC POOL===============================================
		#spmFroId  devFroId  spPid  admStateUnlocked  opStateEnabled  capability  subrack  servingRhModuleId  msgBoard
		#      67        47  71124                 1               1        5100        2                  2  [attached synced allocated ]
		#==============================================PDR POOL==============================================
		#Summary of devices:
		#spmFroId  devFroId  spPid  admStateUnlocked  opStateEnabled  capability  subrack  servingRhModuleId  msgBoard
		#      11         2  71072                 1               1           1        1                 -1  [attached dscpSent ]

		#In W11, the spmFroId is replaced by <devtype>:s|p:<spmFroId>:<processorCoreId>  (where s=spb3 and below, p=spb4)
		#deviceId   devFroId       lmPid  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable msgBoard
		#dc:s:3:0          0       66527  unlocked   enabled        9180        1                  0   001900/sp2.lnh  alloc          [] [linkEstablished synced allocatedSp allocatedRh ]
		#dc:p:19:1         1       66553  unlocked  disabled       11050        1                  0  000900/d00002/1  exist       [ds ] [allocatedRh spDown ]
		#pdr:p:95:0        3      132814  unlocked   enabled         430        2                 14    010500/d00001    n/a          [] [linkEstablished allocatedSp allocatedRh ]
		#cc:p:95:0        11      133319  unlocked   enabled         140        2                 15    010500/d00001    n/a          [] [linkEstablished synced allocatedSp allocatedRh ]

		#In W12, an extra column, boardPiuFroId
		#deviceId  	 devFroId  boardPiuFroId       lmPid  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable msgBoard
		#  cc:s:32769:0         0             16       66524  unlocked   enabled         140        1                  0   001900/sp1.lnh    n/a          [] [linkEstablished synced allocatedSp allocatedRh ]

		#on Evo, the CC device is on the MP
		#0004:      deviceId  devFroId  boardPiuFroId       lmPid  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable msgBoard
		#0004:      cc:p:9:0         0              9      983731  unlocked  disabled         244        1                 -1           000500    n/a       [ds ] [spDown ]
		#0004:     cc:p:10:0         1             10      459683  unlocked   enabled         244        1                  5           000600    n/a          [] [linkEstablished synced allocatedSp allocatedRh ]
		#0004:     cc:p:11:0         2             11      525268  unlocked   enabled         244        1                  9           002400    n/a          [] [linkEstablished synced allocatedSp allocatedRh ]

		#0004:      deviceId  devFroId  boardPiuFroId  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable    state msgBoard
		#0004:      cc:p:9:0         0              9  unlocked   enabled         244        1                  0 000500/CommonChMainPT    n/a          []   active [linkEstablished synced allocatedSp allocatedRh ]

		#rncModBoTable[010900/sp2.lnh]=6
		#rncModTable[SpDevicePool=DcDevice,DcDevice=MS-21-3]=RncModule=7
		#deviceTable[Subrack=MS,Slot=23,PlugInUnit=1,Spu=1,Spm=2]=SpDevicePool=CcDevice,CcDevice=MS-23-2$

		#find out the column of servingRhModuleId
		if ($2=="devFroId" && $8 != "servingRhModuleId" && modPos==8)
		{
			ok=1
			for (i=9;i<=NF;i++) { if ($i == "servingRhModuleId") { modPos=i ; break } }
			continue
		}
		else if ($1=="moduleId" && $2=="boardPiuFroId")
		{
			#ignore this part of the printout
			#moduleId  boardPiuFroId   moduleRole connected subrack noSpDev capability allocatedShare properShare pendingRebalance
			# 0              9        owner         1       1       1        192            244          -1                0
			# 1              9       client         1       1       0        192              0          -1                0
			ok=0
			continue
		}
		else if ($2=="devFroId") ok=1
		if (ok==0) continue
		#print

		devlast=split($1,devarray,":")
		if (devlast==4)
		{
			$1=devarray[3]
			use_deviceId=1
			if (devarray[2]=="p")
			{
				for (i=9;i<=NF;i++)
				{
					if ($i ~ /\/d0000|^[0-9][0-9][0-9][0-9]00(\/.*)?$/)
					{
						#    deviceId  devFroId  boardPiuFroId       lmPid  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable msgBoard
						#   cc:p:10:0         1             10       66310  unlocked   enabled         244        1                 -1           002400    n/a          [] [linkEstablished synced ]
						#    deviceId  devFroId  boardPiuFroId       lmPid  admState   opState  capability  subrack  servingRhModuleId  linkHandlerName  ptmLm  faultTable msgBoard
						#   dc:p:15:5         6              9      131864  unlocked   enabled       11659        1                  4  000500/d00001/5    n/a          [] [linkEstablished synced al

						#new format W13A evo
						#   cc:p:9:0         0              9  unlocked   enabled         244        1    0 000500/CommonChMainPT    n/a          []   active [linkEstablished synced allocatedSp allocatedRh ]
						#   dc:p:30:1       120             30  unlocked   enabled       11659        2   46 012600/1/DedicatedChMainPT    n/a          []   active [linkEstablished synced a
						#   dc:p:67:1       122             30  unlocked   enabled       11659        2   46 012600/d00001/1/DedicatedChMainPT    n/a          []   active [linkEstablished s
						#  pdr:p:33:0         0              9  unlocked   enabled         546        1    2 000500/d00001/PDRMUX_server    n/a          []   active [linkEstablished allocat

						#new format SPB4 TYPE B (Two CC devices on SPM 1)
						# cc:p:62:1         0             61  unlocked   enabled         236        1     4 000900/d00001/1/CommonChMainPT    n/a          []   active [linkEstablished synced allocatedSp allocatedRh ]
						# cc:p:62:2         7             61  unlocked   enabled         236        1     4 000900/d00001/2/CommonChMainPT    n/a          []   active [linkEstablished synced allocatedSp allocatedRh ]

						#Evoc8300
						#   pdr:p:6:0        0             6  unlocked  enabled        546       1                 2                000400/PDRMUX_server   n/a         []     active [linkEstablished allocatedSp allocatedRh ]
						#  pdr:p:11:0        2            11  unlocked  enabled        546       1                 4         000400/d00001/PDRMUX_server   n/a         []       idle [linkEstablished allocatedSp allocatedRh ]
						#    cc:p:6:1        0             6  unlocked  enabled        300       1                 0             000400/1/CommonChMainPT   n/a         []     active [linkEstablished synced allocatedSp allocatedRh ]
						#    cc:p:6:2        1             6  unlocked  enabled        300       1                 0             000400/2/CommonChMainPT   n/a         []     active [linkEstablished synced allocatedSp allocatedRh ]
						#   cc:p:11:1        4            11  unlocked  enabled        300       1                 5      000400/d00001/1/CommonChMainPT   n/a         []       idle [linkEstablished synced allocatedSp allocatedRh ]
						#   cc:p:11:2        5            11  unlocked  enabled        300       1                 5      000400/d00001/2/CommonChMainPT   n/a         []       idle [linkEstablished synced allocatedSp allocatedRh ]
						#   dc:p:6:15       14             6  unlocked  enabled      10726       1                 1         000400/15/DedicatedChMainPT   n/a         []     active [linkEstablished synced allocatedSp allocatedRh ]
						#  dc:p:11:15       44            11  unlocked  enabled      10726       1                 4  000400/d00001/15/DedicatedChMainPT   n/a         []       idle [linkEstablished synced allocatedSp allocatedRh ]


						rncSpmFroMo[devarray[3]]=gensub(/^.*Equipment=1,/,"",1,moLnhTable[gensub(/\/[^d].*$/,"",1,$i)])
						#print "rncSpmFroMo["devarray[3]"]="rncSpmFroMo[devarray[3]]
						if (devarray[1] ~ /^(cc|pdr)$/)
						{
							currlnh=deviceLnhTable[spFullLnhTable[rncSpmFroMo[$1]],devarray[1]]
							if (devarray[4]~/^[1-2]$/)
							{
								#workaround for SPB4 TYPE B/C swallocation SPB_TYPE_B / SPB_TYPE_C with two CC/PDR devices on first SPM
								#also EPB2 has two CC devices on one processor, called :2 and :3
								if (cpplinux==1)
								{
									if (devarray[1]=="cc") sub(/:[1-3]$/,":"devarray[4]+1,currlnh)
								}
								else sub(/:[1-2]$/,":"devarray[4],currlnh)
								#print $0
								#print $1,"rncSpmFroMo="rncSpmFroMo[$1],"spFullLnh="spFullLnhTable[rncSpmFroMo[$1]],"currlnh="currlnh
							}
						}
						else #dc
						{
							last=split($i,lnharray,"/")
							if (last>=2 && lnharray[1] ~ /^[0-9][0-9][0-9][0-9]00$/ && lnharray[2] ~ /^[1-9][0-9]?$/)
							{
								#dc:p:9:1      0      9  unlocked   enabled       11659    1    0  000500/1    n/a          []
								#dc:p:30:1       120             30  unlocked   enabled       11659        2                 46 012600/1/DedicatedChMainPT    n/a          []   active [linkEstablished synced a
								#dc:p:5:1        0                5  unlocked   enabled       10726        1                 0  000400/1/DedicatedChMainPT    n/a         []       idle [linkEstablished synced allocatedSp
								if (BoardType[lnharray[1]]~"EPB2" && maxCoreModule<4) devOffset=2
								else if (BoardType[lnharray[1]]~"EPB2") devOffset=3
								else devOffset=1
								currlnh=lnharray[1]":"lnharray[2]+devOffset   #(BoardType[lnharray[1]]~"EPB2"?3:1)
							}
							else
							{
								#dc:p:175:1    74     67345  unlocked   enabled       11050     2     6  011900/d00001/1  alloc          []
								if (BoardType[lnharray[1]]~"EPB2" && maxCoreModule<4) devOffset=2
								else if (BoardType[lnharray[1]]~"EPB2") devOffset=3
								else if (BoardType[lnharray[1]]~"EPB")  devOffset=1
								else devOffset=0
								currlnh=lnharray[1]"/"lnharray[2]":"lnharray[3]+devOffset #(BoardType[lnharray[1]]~"EPB2"?3:(BoardType[lnharray[1]]~"EPB"?1:0))
							}
						}
						if ($modPos == "-1" && currlnh in rncModBoTable && rncModBoTable[currlnh] != "")
						{
							#in case the device already shows as allocated in one pool but shows as unallocated in another pool
							#for instance if we have reconfigured a SPB from type D to type A then the old DC devices will show as unallocated and that would overwrite the module info for the CC device
							continue
						}
						rncModBoTable[currlnh]=rncModuleNumber[rncModFroMo[$modPos]]
						rncModTable[deviceTable[deviceLnhTable[currlnh]]]=rncModFroMo[$modPos]
						#print currlnh,modPos,$modPos,rncModFroMo[$modPos],rncModuleNumber[rncModFroMo[$modPos]]
						#workaround where we assign the module id of the first Core in PiuDevice to the whole PiuDevice
						#in long term we should have individual entries for each CPU core in the "bp" table
						if (currlnh ~ /\/d0000.:1$/) rncModBoTable[gensub(/:1$/,"",1,currlnh)]=rncModBoTable[currlnh]
						#if (rncModBoTable[currlnh]=="") print currlnh,modPos,$modPos,rncModFroMo[$modPos],$0
						#print currlnh,rncModBoTable[currlnh]
						break
					}
				}
			}
		}
		#This part is for the SPMs only
		if ($0 ~ /00\/sp[0-9]\.lnh/ && $1 in rncSpmFroMo && $modPos in rncModFroMo && spFullLnhTable[rncSpmFroMo[$1]] !~ "d0000")
		{
			rncModBoTable[spFullLnhTable[rncSpmFroMo[$1]]]=rncModuleNumber[rncModFroMo[$modPos]]
			rncModTable[deviceTable[rncSpmFroMo[$1]]]=rncModFroMo[$modPos]
		}
	}
	close(tempdrhlog)
	#Clean up, remove entries with empty index:
	delete rncModBoTable[""]
	delete rncModTable[""]
	#update the table firstModProgInstanceId to map board lnh to first programinstanceid
	for (i in firstModProgInstanceId)
	{
		if (i in rncModTable && rncModTable[i] != "")
		{
			#print i,rncModTable[i],slotLnhTable[rncModTable[i]]
			firstModProgInstanceId[slotLnhTable[rncModTable[i]]"00"]=firstModProgInstanceId[i]
			#print "firstModProgInstanceId["slotLnhTable[rncModTable[i]]"00]="firstModProgInstanceId[i]
		}
		#rncModTable[RncModule=7]=Subrack=ES-1,Slot=17
		#slotLnhTable[Subrack=MS,Slot=28]=0000
	}
	fix_evo8300_botables()
	if (mosdebug==1)
	{
		print "\nAFTER DRH PROCESSING"
		tablePrint(rncModBoTable       ,"rncModBoTable")
		tablePrint(rncModTable         ,"rncModTable")
		tablePrint(firstModProgInstanceId,"firstModProgInstanceId")
	}
}
function make_drh(what,     telnet_session,board,i,j,apn,smn,coremp,spAddress,array,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,a,bds,last,qh)
{
	if (what~"c" && fileOps("test -s "tempdrhlog)==0) return
	if (mom_version !~ "RNC") return
	if (use_bocache==1 && check_bocache_validity(drhtablescache)==0)
	{
		fileOps("cp "drhtablescache" "tempdrhlog)
		return
	}
	set_rnc_type()
	if (cpplinux==1) qh="clihelp" ; else qh="?"
	customPrint("\nCollecting DRH data...","","force")
	nrUeRegBoards=0
	fileOps("rm "tempdrhlog)
	print_date(tempdrhlog,"","","loaded")
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}
	#find out position of the ueregprint and drhcendh commands. note: 000200 is on quicklink RNC, 000400/002600 is Evo8200, 000700/002200 is 3820, 0010/11 is P4
	#tmp_table[1]="001000" ; tmp_table[2]="001100"  #Obsolete, not checked
	#tmp_table[3]="001700" ; tmp_table[4]="001800";
	#tmp_table[5]="000200" ; tmp_table[6]="000700" ; tmp_table[7]="002200"
	#tmp_table[8]="000400" ; tmp_table[9]="002600"
	#for (i=3;i<=9;i++) print "echo \"currentBoard "tmp_table[i]"\"\nlhsh "tmp_table[i]" ? ueregprint\nlhsh "tmp_table[i]" ? drhcendh" |& telnet_session
	if (rncType=="3810") bds="001700:001800"
	else if (rncType=="3820") bds="000700:002200"
	else if (rncType=="8200") bds="000400:002600"
	else if (rncType=="8300") bds="000300:002500"
	else bds="000200"
	last=split(bds,tmp_table,":")
	for (i=1;i<=last;i++) print "echo \"currentBoard "tmp_table[i]"\"\nlhsh "tmp_table[i]" "qh" ueregprint\nlhsh "tmp_table[i]" "qh" drhcendh" |& telnet_session
	print "echo \"EndOfPrint\"" |& telnet_session
	while (telnet_session |& getline)
	{
		gsub("\r","") ; gsub("\x000","") #;print
		#$ lhsh 001700 ueregprint
		#usage: drhcendh [help|cc|dc|ptmiub|pdr|ptmiu|router]
		#ueregprint  ?|imsi|rnti|urnti|uectxt|all <Ue identifier> Print Ue register data for an Ue or for all Ues.
		if (/(^|[^\"])EndOfPrint$/) break
		if (/(^|[^\"])currentBoard 00/) currentBoard=gensub(/^.*currentBoard */,"",1,$0)  #00(1[0178]|02)00
		else if (/[Uu]sage: *drhcendh/) DrhCenBoard=currentBoard
		else if (/ueregprint.*imsi/)
		{
			UeRegBoard=currentBoard
			if (UeRegBoard=="001700") UeRegBoardSB="001800"
			else if (UeRegBoard=="001800") UeRegBoardSB="001700"
			else if (UeRegBoard=="000700") UeRegBoardSB="002200"
			else if (UeRegBoard=="002200") UeRegBoardSB="000700"
			else if (UeRegBoard=="000400") UeRegBoardSB="002600"
			else if (UeRegBoard=="002600") UeRegBoardSB="000400"
			else if (UeRegBoard=="000300") UeRegBoardSB="002500"
			else if (UeRegBoard=="002500") UeRegBoardSB="000300"
			nrUeRegBoards++
		}
	}
	if ((rncType=="8200" && UeRegBoard !~ /^00(04|26)00$/)||(rncType=="3820" && UeRegBoard !~ /^00(07|22)00$/)||(rncType=="8300" && UeRegBoard !~ /^00(03|25)00$/))
	{
		if (mosdebug==1) print "distributed UeReg Evo"
		nrUeRegBoards=0  #this is a distributed UeReg node
	}

	if (mosdebug==1) print "DrhCenBoard="DrhCenBoard",UeRegBoard="UeRegBoard",UeRegBoardSB="UeRegBoardSB",nrUeRegBoards="nrUeRegBoards",isEvo="isEvo",rncType="rncType
	a[1]="pdr"
	a[2]="cc"
	a[3]="dc"
	for (i=1;i<=3;i++)
	{
		print "lhsh -v "DrhCenBoard" drhcendh "a[i] |& telnet_session
		while (telnet_session |& getline)
		{
			gsub("\r","") ; gsub("\x000","")#;print
			if (/returned with status.*, errno/) break
			print $0 >> tempdrhlog
		}
	}
	print "exit" |& telnet_session
	while (telnet_session |& getline) print $0 >> tempdrhlog
	close(telnet_session)
	close(tempdrhlog)
	print_date(tempdrhlog)
	if (use_bocache==1)
	{
		fileOps("cp "tempdrhlog" "drhtablescache)
		chmod(00666,drhtablescache)
	}
}
function parse_cpp(    board,i,j,apn,smn,coremp,spAddress,array,n,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,havexmu,currSerial,tmp_xmu_list,tmpboard,tmp_hubsmn,tmp_hubapn,dest,a)
{
	if (fileOps("test -s "tempcpplog)!=0) return 99
	#global variables initialisations
	delete lastSlotApnIsZero
	delete ignorePortDev
	delete ignorePortDev2
	while (getline < tempcpplog)
	{
		#pdr
		#0x01823320   8    0   8    0 0x00080000    338           0
		#0x0180f940   2    0  10    0 0x000a0000      0   001000  0

		#arm print
		#0,13,ROJ1192106/3,R2,MP,3,CXC1320785_R61BJ02,100,h=0,p=0
		#0,10,ROJ1192106/3,R2,MP,3,CXC1320785_R61BJ02,100,h=0,p=0

		#csti topology
		#0       2       0       PRESENT         0x020000020000  ROJ 208 392/1                   R6A
		#0       4       0       ICP_CONNECTED   0x020000040000
		#

		#this type of printout from csti command messes up things so we need to have more strict check
		# TOPOLOGY SUBSCRIBERS
		#   0x10060 - Cs_icpHandler_proc
		# APN 1  -  META_CONNECTED
		# APN 2  -  ICP_CONNECTED

		#OWN LOCATION DETAILS are:
		#SMN is [0]
		#APN is [3]
		#ERN is [0]
		#
		#Other boards in the node are:
		#smn     apn     ern     status             mac_addr     product-number                  product-revision
		#0       1       0       PRESENT         0x020000010000  ROJ 208 395/1                   R4B
		#0       2       0       PRESENT         0x020000020000  ROJ 208 392/1                   P6B
		#0       4       0       ICP_CONNECTED   0x020000040000
		#0       5       0       ICP_CONNECTED   0x020000050000

		gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
		if (($1 ~ /^0x/ && $3 ~ /^[0-9]+$/ && $4 ~ /^[0-9]+$/) || ($1 ~ /^[0-9]+,[0-9]+,/) || ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/ && $4 ~ /^(PRESENT|ICP_CONNECTED)$/) || ($1=="APN" && $2 ~ /^[0-9]+$/ && $4 =="ICP_CONNECTED"))
		{
		        # Handle the SMXB virtual PIU
		        if ($4 == "PRESENT" && ($2 == "2" || $2 == "28") && $0 ~ /ROJ *208 *482\/4/) continue
			if ($4 ~ /^(PRESENT|ICP_CONNECTED)$/)
			{
				if ($1=="APN") smn=tmp_hubsmn
				else smn=$1
				apn=$2
			}
			else if ($1 ~ /^0x/) { smn=$3 ; apn=$4 ; if ($2==2) currentHubMp=sprintf("%02d%02d00",smn,apn) }
			else if ($1 ~ /^[0-9]+,[0-9]+,/) { split($1,array,","); smn=array[1] ; apn=array[2] }
			board=sprintf("%02d%02d00",smn,apn)
			availableBoardList[board]=board
			if (apn==0) lastSlotApnIsZero[smn]=1
			if ($1 ~ /,CXC(1320785|1732001(%[0-9]+)?|1732469)_/) hubMpList[board]=board
			if (nocorba==1 && $1 ~ /,CXC/)
			{
				match($1,/,(CXC[^_]+)_/,array)
				BoardProgramList[board]=BoardProgramList[board]";"array[1]
			}
		}
		else if (/SMN is \[[0-9]+\]/) tmp_hubsmn=gensub(/^.*\[|\].*$/,"","g",$0)+0
		else if (/APN is \[[0-9]+\]/)
		{
			tmp_hubapn=gensub(/^.*\[|\].*$/,"","g",$0)+0
			board=sprintf("%02d%02d00",tmp_hubsmn,tmp_hubapn)
			availableBoardList[board]=board
			hubMpList[board]=board
			theHubMp=board
		}
		#004704a0 000900/port_2_dev_8/XcbcServer          ph  CXC1725383_R71AE34            0 -   (IcsPqiiMp)
		#006c05d5 000000/port_0_dev_7/ ph  Main               0 -
		#000105f1 001200/port_8_dev_20 ph  CXC1725383_R71T3   0 -               (IcsPqiiMp)
		#00010338 BXP_3_1/radioTrDcSer ph  BXP_3_1            0 -
		#Ports ending with Pht should not be used !! They hang and can be accessed via another RU instead of via DU
		#000105a9 port_18_dev_12Pht                    ph  CXC1323891%4_R14E01   0 -   (lmbpp_4)
		#000105f0 000100/port_24_dev_7/port_0_dev_13/tmaCdciServer   ph  port_24_dev_7         0 -
		#000105e1 port_xcu_dev_7/port_0_dev_8/aiServer         ph  port_xcu_dev_7        0 -
		#we put the address as an integer to be able to do a numeric sorting. otherwise, port_10_dev_7 would be before port_2_dev_4
		else if ($2 ~ /^port_(xcu|[0-9]+)_dev_[0-9]+Pht/)
		{
			match($2,/(port_[^_]+_dev_[0-9]+)Pht/,array)
			ignorePortDev[array[1]]=array[1]  #global table
		}
		else if ($2 ~ /^[0-9][0-9][0-2][0-9]00\/port_(xcu|[0-9]+)_dev_[0-9]+($|\/)/)
		{
			#sub(/\/[^\/_]*$/,"",$2)
			last=split($2,array,"/")
			#port_0_dev_239 --> the ports where the last number is 239 or greater represent the common support system boards (HwUnit MOs) and are not reachable via ose shell
			if (array[2] ~ /_dev_[2-9][0-9][0-9]$/) continue
			tmp_xp_address=sprintf("%.6f",sprintf("%s0000",array[1])+numerize_portdev(array[2])+sprintf("%.6f",numerize_portdev(array[3])/1000))
			$2=array[1]"/"array[2] (array[3]~/^port_(xcu|[0-9]+)_dev_[0-9]+$/?"/"array[3]:"")
			tmp_xp_list1[$2]=tmp_xp_address
			tmp_xp_list2[tmp_xp_address]=$2
			#if (mosdebug==1) print "debug1: " $2,tmp_xp_address,numerize_portdev(array[3])
		}
		#else if ($2 ~ /^BXP_[0-9]+_[0-9]+/)
		#{
		#	sub(/\/.*$/,"",$2)
		#	split($2,array,"_")
		#	tmp_xp_address=000100+sprintf("%s0",array[2])+array[3]
		#	tmp_xp_list1["000100/"$2]=tmp_xp_address
		#	tmp_xp_list2[tmp_xp_address]="000100/"$2
		#}
		else if (/Disconnecting: Corrupted MAC on input/) break
		#$ cat /d/systemfiles/virtual_map/vmap.txt
		#{[0],[6]}:{[0],[3]}
		#{[0],[8]}:{[0],[4]}
		#{[0],[7]}:{[0],[5]}
		#{[0],[5]}:{[0],[11]}
		#{[0],[5]}:{[0],[11]}$ Unknown command 'pdr'.    (if carriage return is missing on the last line of the file)
		else if ($1~/^\{\[([0-9]+)\],\[([0-9]+)\]\}:\{\[([0-9]+)\],\[([0-9]+)\]\}.?$/)
		{
			match($1,/\{\[([0-9]+)\],\[([0-9]+)\]\}:\{\[([0-9]+)\],\[([0-9]+)\]\}/,a)
			virtualBoardMap[sprintf("%02d%02d00",a[3]+0,a[4]+0)]=sprintf("%02d%02d00",a[1]+0,a[2]+0)
		}
	}
	close(tempcpplog)
	#check if tmp_xp_list1 contains some forbidden addresses (those that hang)
	for (i in tmp_xp_list1)
	{
		split(i,array,"/")
		if (array[2] in ignorePortDev) delete tmp_xp_list1[i]
	}

	n=asort(tmp_xp_list1,dest)
	delete bdGroup["xp"]
	NrOfBoards["xp"]=n
	bdGroupList["xp"]="xp"
	for (i=1;i<=n;i++)
	{
		board=tmp_xp_list2[dest[i]]
		bdGroup["xp"]=bdGroup["xp"]";"board
		BoardType[board]=""
		availableBoardList[board]=board
	}
	sub(/^;/,"",bdGroup["xp"])

	return 0

}
function make_cpp(what,    telnet_session,array,cmpTable,t_cmp,i,k,pscommand)
{
	if (what~"c" && fileOps("test -s "tempcpplog)==0) return
	if (use_bocache==1 && check_bocache_validity(cpptablescache)==0)
	{
		fileOps("cp "cpptablescache" "tempcpplog)
		parse_cpp()
		return
	}

	customPrint("\nCollecting CPP board data...","","force")
	fileOps("rm "tempcpplog)
	print_date(tempcpplog,"","","loaded")
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}
	print "getAttrObj me\necho \"EndOfPrint\"" |& telnet_session
	while (telnet_session |& getline)
	{
		gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
		print $0 >> tempcpplog
		#FTC State   : PiuId 2 on Slot 10 has cmState PassiveReady
              	#	      PiuId 10 on Slot 11 has cmState Active
		#FTC State   : PiuId 1 on Slot 1 has cmState Active
		#              PiuId 0 on Slot -- has cmState NotConfigured
		if (/(^|[^\"])EndOfPrint$/) break
		match($0,/on Slot ([0-9]+) has cmState/,array)
		if (array[1]~/^[0-9]+$/) cmpTable[sprintf("00%02d00",array[1])]=1
	}
	for (i in cmpTable) k++
	pscommand=""
	if (k>1) for(i in cmpTable) pscommand=pscommand"lhsh "i" ps\nlhsh "i" csti topology\n"

	print "cat /d/systemfiles/virtual_map/vmap.txt\npdr\narm print\ncsti info\ncsti topology\nps\n"pscommand"exit" |& telnet_session
	while (telnet_session |& getline)
	{
		gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
		print $0 >> tempcpplog
	}
	close(telnet_session)
	close(tempcpplog)
	print_date(tempcpplog)
	if (use_bocache==1)
	{
		fileOps("cp "tempcpplog" "cpptablescache)
		chmod(00666,cpptablescache)
	}
	parse_cpp()
}
function make_rbs(what,    telnet_session,board,i,j,apn,smn,coremp,spAddress,array,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,havexmu,currSerial,tmp_xmu_list,tmpboard,tmp_hubsmn,tmp_hubapn,addCommand,dest,bufferedLine,is_xmu03,is_xmu03_ok,serialPrinted,bufferedLine2)
{
	if (what~"c" && fileOps("test -s "temprbslog)==0) return
	if (tolower(mom_version) !~ "rbs") return

	customPrint("\nCollecting RBS board data...","","force")
	delete addCommand
	fileOps("rm "temprbslog)
	print_date(temprbslog)
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}
	for (i in availableBoardList)
	{
		if (i !~ /^0[01][0-9][0-9]00$/) continue
		if (i in BoardType && BoardType[i] ~ /^(RAX|TX|ET|TU)/) continue
		#if (BoardType[i] !~ /^(RUIF|OBIF|AIU|REIF|DUW|ODW|DUL|DUS|ODS)/) continue
		print "echo currentBoard "i"\nlhsh "i" ps\necho \"EndOfPrint\"" |& telnet_session
		while (telnet_session |& getline)
		{
			gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
			print $0 >> temprbslog
			if (/(^|[^\"])EndOfPrint$/) break
		}
	}
	close(temprbslog)
	print_date(temprbslog)
	havexmu=parse_rbs()
	fileOps("rm "tempxmulog)
	print_date(tempxmulog)
	n=asort(XcuList,dest)
	for (i=n;i>=1;i--)
	{
		bufferedLine=""
		serialPrinted=0
		print "echo currentBoard "XcuBoard[dest[i]]"\nlhsh -v "XcuBoard[dest[i]]" par get SYS_HW_*" |& telnet_session
		while (telnet_session |& getline)
		{
			gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
			#The line SYS_HW_NAME must always be after the line SYS_HW_SERIAL
			if (/SYS_HW_NAME/ && serialPrinted==0) bufferedLine=$0
			else
			{
				print $0 >> tempxmulog
				if (/SYS_HW_SERIAL/)
				{
					if (bufferedLine!="")
					{
						print bufferedLine >> tempxmulog
						bufferedLine=""
					}
					serialPrinted=1
				}
			}
			if (/(^|[^\"])EndOfPrint$/) break
			if (/ returned with status .*, errno/) break
		}
	}
	close(tempxmulog)
	n=asort(RuList,dest)
	for (i=n;i>=1;i--)
	{
		#old method:
		#print "echo currentBoard "RuBoard[dest[i]]"\nlhsh "RuBoard[dest[i]]" par get SYS_HW_SERIAL\nlhsh "RuBoard[dest[i]]" par get SYS_HW_NAME" |& telnet_session
		#print "echo \"EndOfPrint\"" |& telnet_session
		#New method: we use lhsh -v  because of XMU03 which does not support to send two commands in a row so we cannot send the echo command
		is_xmu03=is_xmu03_ok=0
		bufferedLine=""
		bufferedLine2=""
		serialPrinted=0
		print "echo currentBoard "RuBoard[dest[i]]"\nlhsh -v "RuBoard[dest[i]]" par get SYS_HW_*" |& telnet_session
		while (telnet_session |& getline)
		{
			gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
			#The line SYS_HW_NAME must always be after the line SYS_HW_SERIAL
			if (/SYS_HW_NAME/ && serialPrinted==0) bufferedLine=$0
			else
			{
				print $0 >> tempxmulog
				if (/SYS_HW_SERIAL/)
				{
					if (bufferedLine!="")
					{
						print bufferedLine >> tempxmulog
						bufferedLine=""
					}
					serialPrinted=1
				}
			}
			if (/(^|[^\"])EndOfPrint$/) break
			if (/ returned with status .*, errno/) break
			if (/^(sys_mode|sys_debug|sys_current_lmc|sys_sw_pid)=/) is_xmu03=1
			else if (/^productname=/) bufferedLine2=sprintf("'SYS_HW_NAME'        = %s",gensub(/^.*=/,"","g",$0))
			else if (/^serialnumber=/)
			{
				printf("'SYS_HW_SERIAL' = %s\n",gensub(/^.*=/,"","g",$0)) >> tempxmulog
				print bufferedLine2 >> tempxmulog
				is_xmu03_ok=1
			}
			if (/SYS_HW_NAME.*RRUS/)
			{
				t_command=sprintf("lhsh %s par get CONTAINER_HW*",RuBoard[dest[i]])
				addCommand[t_command]=t_command
			}
		}
		if (is_xmu03==1 && is_xmu03_ok!=1) #A XMU03 whose product info has not been flashed in the EEPROM
		{
			print "'SYS_HW_SERIAL'        = '0000000000'" >> tempxmulog
			print "'SYS_HW_NAME'        = 'XMU 03'" >> tempxmulog
		}

	}
	close(tempxmulog)
	n=asort(addCommand)
	for (i=1;i<=n;i++)
	{
		print "echo "addCommand[i]"\n"addCommand[i]"\necho \"EndOfPrint\"" |& telnet_session
		while (telnet_session |& getline)
		{
			gsub("\r","") ; gsub("\x000","") ; gsub(/^( *\$ *)+/,"")
			print $0 >> tempxmulog
			if (/(^|[^\"])EndOfPrint$/) break
		}
	}
	close(tempxmulog)
	print_date(tempxmulog)
	print "exit" |& telnet_session
	while (telnet_session |& getline) {}
	close(telnet_session)
	parse_xmu()
	finish_rbs()
}
function clear_rbs()
{
	delete GcpuList
	delete RuList  ; delete RuBoard
	delete AscList ; delete AscBoard
	delete XcuList ; delete XcuBoard
	delete XmuList ; delete XmuBoard
	delete XpSerial; delete AirSerial
	delete PimcuList ; delete PimcuBoard
	delete AirInfo
}
function parse_rbs(   telnet_session,board,i,j,apn,smn,coremp,spAddress,array,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,havexmu,currSerial,tmp_xmu_list,tmpboard,tmp_hubsmn,tmp_hubapn,z)
{
	havexmu=0
	if (fileOps("test -s "temprbslog)!=0) return 0
	#make board group for RU (connects to RUIF), RRU (connects to OBIF), ASC (connects to RUIF or AIU)
	clear_rbs()
	for (i in BoardType)
	{
		if (BoardType[i] ~ /^(RUIF|OBIF|AIU|REIF|DUW|ODW|DUL|DUS|ODS)/)
		{
			ruif_count++
		}
	}
	close(temprbslog)
	while (getline < temprbslog)
	{
		#currentBoard 001200
		#00030109 port_8_dev_8/ose_she ph  CXC1323891%1_R32   0 -
		#00050105 port_4_dev_7/ose_she ph  CXC1323891%1_R32   0 -
		#00030107 port_0_dev_6/ose_she ph  CXC1323891%1_R32   0 -
		#00020116 port_1_dev_19/tmaCdc ph  CXC1323891%1_R33   0 -
		#000105b9 port_12_dev_6/port_0_dev_12/tmaCdciServer     ph  port_12_dev_6                 0 -
		#00010338 BXP_3_1/radioTrDcSer ph  BXP_3_1            0 -
		#00040378 BXP_0_1/XmuDcServer     ph  BXP_0_1    0 -
		#003003cb BXP_0/RICR              ph  BXP_0                          0 -
		#00030360 gcpu01/ose_shelld    ph  gcpu01             0 -
		#0002034f gcpu00256/ose_shelld ph  gcpu00256          0 -
		#The ports which end with Pht hang:
		#000105a9 port_18_dev_12Pht                           ph  CXC1323891%4_R14E01   0 -   (lmbpp_4)
		#RuList[001200/port_10_dev_7]=1200+100+7=1307
		#RuList[001200/port_8_dev_12]=1200+80+12=1292
		#RuList[001200/port_1_dev_19]=1200+10+19=1229
		#if ($1 == "$" && $2 == "currentBoard") sub("\\$","")
		if ($1 == "currentBoard") currentBoard=$2
		else if ($2 ~ /^port_(xcu|[0-9]+)_dev_[0-9]+Pht/)
		{
			match($2,/(port_[^_]+_dev_[0-9]+)Pht/,array)
			ignorePortDev2[currentBoard"/"array[1]]=1  #global table
		}
		else if ($2 ~ /^port_(xcu|[0-9]+)_dev_[0-9]+($|\/)/)
		{
			#sub(/\/[^\/_]*$/,"",$2)
			last=split($2,array,"/")
			#port_0_dev_239 --> the ports where the last number is 239 or greater represent the common support system boards (HwUnit MOs) and are not reachable via ose shell
			if (array[1] ~ /_dev_[2-9][0-9][0-9]$/) continue
			tmp_xp_address=sprintf("%.6f",sprintf("%s0000",currentBoard)+numerize_portdev(array[1])+sprintf("%.6f",numerize_portdev(array[2])/1000))
			$2=currentBoard"/"array[1] (array[2]~/^port_(xcu|[0-9]+)_dev_[0-9]+$/?"/"array[2]:"")
			if (array[last]~"tma")
			{
				AscList[$2]=tmp_xp_address
				AscBoard[tmp_xp_address]=$2
			}
			else if ($2 ~ /port_xcu_dev_[0-9]+$/)
			{
				XcuList[$2]=tmp_xp_address
				XcuBoard[tmp_xp_address]=$2
			}
			else
			{
				RuList[$2]=tmp_xp_address
				RuBoard[tmp_xp_address]=$2
			}
			#if (mosdebug==1) print "debug2: "$2,tmp_xp_address,numerize_portdev(array[2])
		}
		else if ($2 ~ /^BXP_[0-9]+.*\//)
		{
			if (tolower($2) ~ "xmu") havexmu=1
			sub(/\/.*$/,"",$2)
			z=split($2,array,"_")
			tmp_xp_address=currentBoard
			#for (i=2;i<=11;i++) tmp_xp_address=sprintf("%s%02d",tmp_xp_address,array[i])  #-> we change from 11 to z otherwise it cannot differentiate between BXP_1 and BXP_1_0
			for (i=2;i<=z;i++) tmp_xp_address=sprintf("%s%02d",tmp_xp_address,array[i])
			#print tmp_xp_address,$2
			tmpboard=currentBoard"/"$2
			#in a single DUL node, for backwards compatibility purpose, remove 000100 in front of the BXP address
			#this does not work at the moment, commented out
			#if (ruif_count == 1) sub(/^000100\//,"",tmpboard)
			RuList[tmpboard]=tmp_xp_address
			RuBoard[tmp_xp_address]=tmpboard

		}
		else if ($2 ~ /^gcpu0[0-9]/)
		{
			sub(/\/.*$/,"",$2)
			tmpboard=currentBoard"/"$2
			#for backwards compatibility purpose. in a single DUL node, remove 000100 in front of the gcpu address
			#this works on gcpu but not on RU, disabled for the moment.
			#if (ruif_count == 1) sub(/^000100\//,"",tmpboard)
			GcpuList[tmpboard]=tmpboard
		}
	}
	close(temprbslog)
	for (i in RuList) { if (i in ignorePortDev2) delete RuList[i] }
	return havexmu
}
function parse_xmu(    array,currSerial,val,currentBoard,airInfo,i,tPid)
{
	if (fileOps("test -s "tempxmulog)!=0) return
	close(tempxmulog)
	while (getline < tempxmulog)
	{
		if ($1 == "currentBoard") currentBoard=$2
		else if ($1=="lhsh" && $3=="par" && $5=="CONTAINER_HW*") currentBoard=$2

		#RRUL11 Nortel based
		#Product name: RRUL 11 B13
		#Serial number: C84A0003D8
		if (/^(Product name:|Serial number:)/)
		{
			split($0,array,":")
			val=gensub(/ /,"","g",array[2])
			if (/Serial/)
			{
				currSerial=val
				XpSerial[currentBoard]=currSerial
			}
			else if (/name/) BoardType[currentBoard]=val
		}

		#other
		#'SYS_HW_PID'         = 'KRC 161 254/1'
		#'SYS_HW_SERIAL'      = 'C825499213'
		#'SYS_HW_NAME'        = 'XMU 02 01'

		#AIR
		#'CONTAINER_HW_PID'   = 'KRC 118 93/3'
		#'CONTAINER_HW_REV'   = 'R2A'
		#'CONTAINER_HW_NAME'  = 'AIR 11 B20a B8p'
		#'CONTAINER_HW_DATE'  = '20130418'
		#'CONTAINER_HW_SERIAL' = 'CQ30097999'

		if (/(SYS_HW_SERIAL|SYS_HW_NAME|SYS_HW_PID|CONTAINER_HW_SERIAL).*=/)
		{
			split($0,array,"=")
			split(array[2],array,"'")
			val=gensub(/ /,"","g",array[2])
			if (val!="")
			{
				if (/SYS_HW_SERIAL/)
				{
					currSerial=val
					XpSerial[currentBoard]=currSerial
				}
				else if (/SYS_HW_NAME/) BoardType[currentBoard]=val
				else if (/SYS_HW_PID/) tPid[currentBoard]=val
				else if (/CONTAINER_HW_SERIAL/)
				{
					AirSerial[val]=AirSerial[val]" "currentBoard
					sub(/^ +/,"",AirSerial[val])
					AirInfo[val]=airInfo
					airInfo=""
				}
				#else if (/CONTAINER_HW_/) airInfo=airInfo SUBSEP val
			}
		}
		else if (/CONTAINER_HW_(PID|REV|NAME|DATE).*=/)
		{
			split($0,array,"=")
			split(array[2],array,"'")
			val=gensub(/ /,"","g",array[2])
			airInfo=airInfo SUBSEP val
		}
		if (/NAME.*=.*XMU/)
		{
			delete RuBoard[RuList[currentBoard]]
			delete RuList[currentBoard]
			XmuBoard[currSerial]=currentBoard
		}
		if (/NAME.*=.*(BB|Baseband) *P614/)
		{
			#'SYS_HW_NAME'            = 'BB P614'
			#'SYS_HW_MARKET_NAME'     = 'Baseband P614'
			delete RuBoard[RuList[currentBoard]]
			delete RuList[currentBoard]
			PimcuBoard[currSerial]=currentBoard
		}
	}
	close(tempxmulog)
	#Sort the AirSerial so the lowest linkhandler must be in first position
	#AirSerial[D240033091] = 000100/port_13_dev_19 000100/port_1_dev_18
	for (i in AirSerial) if (AirSerial[i] ~ " ") AirSerial[i]=sortLnh(AirSerial[i])
	fix_BoardType_table(tPid)
}
function sortLnh(lnhlist,  port_dev_list,sorted_port_dev_list,a,i,n)
{
	split(lnhlist,a," ")
	for (i in a) if (a[i]!="") port_dev_list[a[i]]=a[i]
	n=sortportdev(port_dev_list,sorted_port_dev_list)
	lnhlist=""
	for (i=1;i<=n;i++) lnhlist=lnhlist" "sorted_port_dev_list[i]
	sub(/^ +/,"",lnhlist)
	return lnhlist
}
function finish_rbs(  telnet_session,board,i,j,apn,smn,coremp,spAddress,array,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,havexmu,currSerial,tmp_xmu_list,tmpboard,tmp_hubsmn,tmp_hubapn,dest,foundXp,tmp_pimcu_list)
{
	for (i in PimcuBoard) tmp_pimcu_list[PimcuBoard[i]]=PimcuBoard[i]
	for (i in XmuBoard) tmp_xmu_list[XmuBoard[i]]=XmuBoard[i]
	for (i in AscList) delete RuList[i]
	for (i in AscBoard) delete RuBoard[i]
	for (i in XcuList) delete RuList[i]
	for (i in XcuBoard) delete RuBoard[i]
	#check if the lists contains some forbidden addresses (those that hang)
	for (i in AscList) if (i in ignorePortDev2) delete AscList[i]
	for (i in XcuList) if (i in ignorePortDev2) delete XcuList[i]
	for (i in RuList)
	{
		if (i in ignorePortDev2) delete RuList[i]
		if ((RuBoard[RuList[i]] in BoardType && BoardType[RuBoard[RuList[i]]]!~ /RU|TRANSCEIVER|^RR2/)||(!(RuBoard[RuList[i]] in BoardType)))
		{
			#print RuBoard[RuList[i]],BoardType[RuBoard[RuList[i]]]
			delete RuList[i]
		}
	}
	n=asort(RuList,dest)
	if (n > 0)
	{
		delete bdGroup["ru"]
		NrOfBoards["ru"]=n
		bdGroupList["ru"]="ru"
		for (i=1;i<=n;i++)
		{
			#print i,dest[i],RuBoard[dest[i]],BoardType[RuBoard[dest[i]]]
			if (foundXp[XpSerial[RuBoard[dest[i]]]]==1) continue
			bdGroup["ru"]=bdGroup["ru"]";"RuBoard[dest[i]]
			#BoardType[RuBoard[dest[i]]]=(obif==1 ? "RRU" : "RU")
			bdGroup["ru"i]=RuBoard[dest[i]]
			NrOfBoards["ru"i]=1
			bdGroupList["ru"i]="ru"i
			if (XpSerial[RuBoard[dest[i]]]!="")
			{
				foundXp[XpSerial[RuBoard[dest[i]]]]=1
				XpSerial[XpSerial[RuBoard[dest[i]]]]=RuBoard[dest[i]]
			}
		}
		sub(/^;/,"",bdGroup["ru"])
	}
	n=asort(AscList,dest)
	if (n > 0)
	{
		delete bdGroup["asc"]
		NrOfBoards["asc"]=n
		bdGroupList["asc"]="asc"
		for (i=1;i<=n;i++)
		{
			bdGroup["asc"]=bdGroup["asc"]";"AscBoard[dest[i]]
			bdGroup["asc"i]=AscBoard[dest[i]]
			BoardType[AscBoard[dest[i]]]="ASC"
			NrOfBoards["asc"i]=1
			bdGroupList["asc"i]="asc"i
			if (XpSerial[AscBoard[dest[i]]]!="")
			{
				XpSerial[XpSerial[AscBoard[dest[i]]]]=AscBoard[dest[i]]
			}
		}
		sub(/^;/,"",bdGroup["asc"])
	}
	n=asort(XcuList,dest)
	if (n > 0)
	{
		delete bdGroup["xcu"]
		NrOfBoards["xcu"]=n
		bdGroupList["xcu"]="xcu"
		for (i=1;i<=n;i++)
		{
			bdGroup["xcu"]=bdGroup["xcu"]";"XcuBoard[dest[i]]
			bdGroup["xcu"i]=XcuBoard[dest[i]]
			BoardType[XcuBoard[dest[i]]]="XCU"
			NrOfBoards["xcu"i]=1
			bdGroupList["xcu"i]="xcu"i
			if (XpSerial[XcuBoard[dest[i]]]!="")
			{
				XpSerial[XpSerial[XcuBoard[dest[i]]]]=XcuBoard[dest[i]]
			}
		}
		sub(/^;/,"",bdGroup["xcu"])
	}
	n=asort(GcpuList)
	if (n > 0)
	{
		delete bdGroup["gcpu"]
		NrOfBoards["gcpu"]=n
		bdGroupList["gcpu"]="gcpu"
		for (i=1;i<=n;i++)
		{
			board=GcpuList[i]
			bdGroup["gcpu"]=bdGroup["gcpu"]";"board
			bdGroup["gcpu"i]=board
			bdGroupList["gcpu"i]="gcpu"i
			NrOfBoards["gcpu"i]=1
			BoardType[board]=""
			availableBoardList[board]=board
		}
		sub(/^;/,"",bdGroup["gcpu"])
	}
	n=asort(tmp_xmu_list)
	if (n > 0)
	{
		delete bdGroup["xmu"]
		NrOfBoards["xmu"]=n
		bdGroupList["xmu"]="xmu"
		for (i=1;i<=n;i++)
		{
			board=tmp_xmu_list[i]
			bdGroup["xmu"]=bdGroup["xmu"]";"board
			bdGroup["xmu"i]=board
			bdGroupList["xmu"i]="xmu"i
			NrOfBoards["xmu"i]=1
			#BoardType[board]=""
			availableBoardList[board]=board
			if (XpSerial[board]!="")
			{
				XpSerial[XpSerial[board]]=board
			}
		}
		sub(/^;/,"",bdGroup["xmu"])
	}
	n=asort(tmp_pimcu_list)
	if (n > 0)
	{
		delete bdGroup["pimcu"]
		NrOfBoards["pimcu"]=n
		bdGroupList["pimcu"]="pimcu"
		for (i=1;i<=n;i++)
		{
			board=tmp_pimcu_list[i]
			bdGroup["pimcu"]=bdGroup["pimcu"]";"board
			bdGroup["pimcu"i]=board
			bdGroupList["pimcu"i]="pimcu"i
			NrOfBoards["pimcu"i]=1
			#BoardType[board]=""
			availableBoardList[board]=board
			if (XpSerial[board]!="")
			{
				XpSerial[XpSerial[board]]=board
			}
		}
		sub(/^;/,"",bdGroup["pimcu"])
	}
}
function parse_rbs_all()
{
	parse_rbs()
	parse_xmu()
	finish_rbs()
}
function make_rnc_coli(what,   bercmdlist,n,i,tpcom,berbdlist)
{
	if (what~"c" && fileOps("test -s "temprnclog)==0) return
	#if (comcli>0) return
	if (comcli>0 && is_rcs()==0) return
	if (tolower(mom_version) !~ "(rnc|rbs)_node_model") return
	check_node_password()
	if (node_password == "") return
	if (tolower(mom_version) ~ "rnc_node_model")
	{
		customPrint("\nCollecting RNC board data...","","force")
		mo_log(temprnclog,"open","mute","overwrite","silent")
		print_date(temprnclog)
		muteFactor=80
		$0="lh mod drh_ccrh_topdata;drh_dcrh_topdata;drh_pdrrh";lh()
		$0="lh pdr capi prio; capi core 0";lh()
		$0="lh cc celllist -d ccs";lh()
		mo_log(temprnclog,"close")
	}
	else if (mom_version ~ /^MSRBS_NODE_MODEL/)
	{
		if (!("mp" in bdGroup && bdGroup["mp"]!="")) return
		customPrint("\nCollecting RBS data...","","force")
		mo_log(temprnclog,"open","mute","overwrite","silent")
		print_date(temprnclog)
		muteFactor=80
		#$0="lh mp rdsfp -d 1;rdsfp -d 2;rdsfp -d 3;rdsfp -d 4;rdsfp -d 5;rdsfp -d 6;ricm -a;boardtemp";lh()
		$0="lh mp sysconread;ncdbi;icdbi;sfpdump 0;sfpdump 1;sfpdump 2;sfpdump 3;sfpdump 4;sfpdump 5;sfpdump 6;sfpdump 7;sfpdump 8;sfpdump 9;sfpdump 10;sfpdump 11;sfpdump 12;sfpdump 13;sfpdump 14";lh()
		$0="lh xmu03 ric -a;sfp -d 0 -m;sfp -d 1 -m;sfp -d 2 -m;sfp -d 3 -m;sfp -d 4 -m;sfp -d 5 -m;sfp -d 6 -m;sfp -d 8 -m;sfp -d 9 -m;sfp -d 10 -m;sfp -d 11 -m;sfp -d 12 -m;sfp -d 13 -m;sfp -d 14 -m;sfp -d 15 -m" ; lh()
		$0="lh pimcu ricr -a;sfp -d 0;sfp -d 1;sfp -d 2;sfp -d 3;sfp -d 4;sfp -d 5;sfp -d 6;sfp -d 7;sfp -d 8;sfp -d 9;sfp -d 10;sfp -d 11" ; lh()
		$0="lh ru par get CONTAINER_HW*;carrierListHandler print;sfp -d 0; sfp -d 1;ricr -a;rrs 0;rrs 1" ; lh()
		$0="lh iru rdc dump all;rdsh all vind;rdsh all hal ltu lock;rdsh all temp dot;eqpm cblMeasSv il dump all;eqpm rdFault dump;eqpm rdPoe status all" ; lh()
	}
	else if (tolower(mom_version) ~ "rbs_node_model")
	{
		customPrint("\nCollecting RBS data...","","force")
		mo_log(temprnclog,"open","mute","overwrite","silent")
		print_date(temprnclog)
		muteFactor=80
		$0="lh mp ncdbi;icdbi;rdsfp -d 1;rdsfp -d 2;rdsfp -d 3;rdsfp -d 4;rdsfp -d 5;rdsfp -d 6;ricm -a;readPower;boardtemp";lh()
		$0="lh ru carrierListHandler print;sfp -d 0; sfp -d 1;ricr -a;rrs 0;rrs 1";lh()
		$0="lh iru rdc dump all;rdsh all vind;rdsh all hal ltu lock;rdsh all temp dot;eqpm cblMeasSv il dump all;eqpm rdFault dump;eqpm rdPoe status all" ; lh()
		#rrs <port> is for RRUx82
		#xmu02 : sfp -d 0..11
		#xmu03 : sfp -d 0,1 8..15 -m
		$0="lh xmu sfp -d 0;sfp -d 1;sfp -d 2;sfp -d 3;sfp -d 4;sfp -d 5;sfp -d 6;sfp -d 7;sfp -d 8;sfp -d 9;sfp -d 10;sfp -d 11;sfp -d 0 -m ;sfp -d 1 -m ;sfp -d 2 -m;sfp -d 3 -m;sfp -d 4 -m;sfp -d 5 -m;sfp -d 6 -m;sfp -d 8 -m ;sfp -d 9 -m ;sfp -d 10 -m ;sfp -d 11 -m ;sfp -d 12 -m ;sfp -d 13 -m ;sfp -d 14 -m ;sfp -d 15 -m;ricr -a;ric -a";lh()
		$0="lh pimcu ricr -a;sfp -d 0;sfp -d 1;sfp -d 2;sfp -d 3;sfp -d 4;sfp -d 5;sfp -d 6;sfp -d 7;sfp -d 8;sfp -d 9;sfp -d 10;sfp -d 11" ; lh()
	}
	if (tolower(mom_version) ~ "rbs_node_model")
	{
		if (include_ber==1) #not a uv, can only be set with command gvm
		{
			n=parse_berfile(commonjardir"/pm/HW_RBS4.csv",bercmdlist,berbdlist)
			print_date(temprnclog)
			for (i=1;i<=n;i++)
			{
				$0="br "berbdlist[i] ; customPrint($0) ; buildBoardGroup("remove","","m")
				$0="ba "berbdlist[i]" "berbdlist[i] ; customPrint($0) ; buildBoardGroup("add","","m")
				$0=bercmdlist[i] ; customPrint($0) ; lh()
			}
		}
		mo_log(temprnclog,"close")
	}
}
function parse_berfile(sfpfile,rescmdlist,bdlist,      cmdlist,line,array,i,last,n)
{
	if (fileOps("test -s "sfpfile) != 0) { customPrint("ERROR: file "sfpfile" not found.") ; return 0}
	delete rescmdlist
	while (getline line < sfpfile)
	{
		#dul21;1;rdfpga 1C14
		gsub("\r","",line)
		last=split(line,array,";")
		if (last!=3) continue
		if (array[1]~/^#/) continue
		for (i in array) gsub(/^[ \t]+|[ \t]+$/,"",array[i])
		cmdlist[array[1]]=cmdlist[array[1]] "echo BERPORT "array[2]";"array[3]";"
		bdlist[array[1]]=array[1]
	}
	close(sfpfile)
	n=asort(bdlist)
	for (i=1;i<=n;i++)
	{
		rescmdlist[i]="lh "bdlist[i]" "cmdlist[bdlist[i]]
	}
	return n+0
}
function availableBoards_comcli()
{
	if (mom_version !~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/) return
	make_rbs_comcli()
	parse_rbs_comcli()
	makeBoTables_comcli()
	make_default_boardgroups()
}
function clear_default_boardgroups_comcli(   i)
{
	$0="br mp"; buildBoardGroup("remove","","m")
	$0="br coremp"; buildBoardGroup("remove","","m")
	$0="br ru"; buildBoardGroup("remove","","m")
	$0="br xp"; buildBoardGroup("remove","","m")
	$0="br xmu"; buildBoardGroup("remove","","m")
	$0="br xmu02"; buildBoardGroup("remove","","m")
	$0="br xmu03"; buildBoardGroup("remove","","m")
	$0="br all"; buildBoardGroup("remove","","m")
	$0="br gcpu"; buildBoardGroup("remove","","m")
	$0="br du"; buildBoardGroup("remove","","m")
	$0="br iru"; buildBoardGroup("remove","","m")
	$0="br allb"; buildBoardGroup("remove","","m")
	for (i=1;i<=24;i++)
	{
		$0="br ru"i ; buildBoardGroup("remove","","m")
		$0="br gcpu"i ; buildBoardGroup("remove","","m")
	}
}
function make_default_boardgroups_comcli(    a,i,n)
{
	make_gcpu_comcli()
	$0="ba mp 1"; buildBoardGroup("add","","m")
	$0="ba coremp 1"; buildBoardGroup("add","","m")
	$0="ba ru rr|ru|air"; buildBoardGroup("add","","m")
	$0="ba xmu xmu"; buildBoardGroup("add","","m")
	$0="ba xmu02 xmu02"; buildBoardGroup("add","","m")
	$0="ba xmu03 xmu03"; buildBoardGroup("add","","m")
	$0="ba all mp"; buildBoardGroup("add","","m")
	$0="ba all xmu"; buildBoardGroup("add","","m")
	$0="ba all ru"; buildBoardGroup("add","","m")
	$0="ba all gcpu"; buildBoardGroup("add","","m")
	$0="ba du mp gcpu" ; buildBoardGroup("add","","m")
	$0="ba xp xmu"; buildBoardGroup("add","","m")
	$0="ba xp ru"; buildBoardGroup("add","","m")
	$0="ba iru iru"; buildBoardGroup("add","","m")
	$0="ba allb all"; buildBoardGroup("add","","m")
	$0="br allb gcpu"; buildBoardGroup("remove","","m")
	if ("ru" in bdGroup && bdGroup["ru"]!="")
	{
		n=split(bdGroup["ru"],a,";")
		for (i=1;i<=n;i++)
		{
			$0="ba ru"i" "a[i]
			buildBoardGroup("add","","m")
		}
	}
	assignCustomVar("$coremp_pos","000100","","system")
	assignCustomVar("$coremp_type",BoardType["000100"],"","system")
}
function make_gcpu_comcli(    i,n,board)
{
	n=asort(GcpuList)
	if (n==0) return
	delete bdGroup["gcpu"]
	NrOfBoards["gcpu"]=n
	bdGroupList["gcpu"]="gcpu"
	for (i=1;i<=n;i++)
	{
		board=GcpuList[i]
		bdGroup["gcpu"]=bdGroup["gcpu"]";"board
		bdGroup["gcpu"i]=board
		bdGroupList["gcpu"i]="gcpu"i
		NrOfBoards["gcpu"i]=1
		BoardType[board]=""
		#availableBoardList[board]=board
	}
	sub(/^;/,"",bdGroup["gcpu"])
}
function makeBoTables_comcli(   currmo,serialMo,i,motypes,fruList,n,k,fk)
{
	motypes["fieldreplaceableunit"]=1
	ConditionalLoad(motypes)
	mo_log(tempfrulog,"open","mute","overwrite","silent")
	$0="kget ^fieldreplaceableunit= productdata" ; kget("short")
	mo_log(tempfrulog,"close","","silent")
	print ""
	while (getline < tempfrulog)
	{
		#MO                                   ManagedElement=TCU03_61,Equipment=1,FieldReplaceableUnit=1
		# >>> 5.serialNumber = D16F521424
		# >>> 5.serialNumber = BXP_1_10_1_1
		if ($1=="MO" && NF==2)
		{
			currmo=gensub(/^.*ManagedElement=[^,]+,/,"",1,$2)
			fruList[currmo]=currmo
		}
		else if ($1==">>>" && $2 ~ /\.serialNumber$/) serialMo[gensub(/^BXP_/,"XP_",1,$4)]=currmo
	}
	close(tempfrulog)
	#lnhMoTable[Equipment=1,FieldReplaceableUnit=1] = 000100
	#moLnhTable[000100] = Equipment=1,FieldReplaceableUnit=1

	for (i in XpSerial)
	{
		#XpSerial[D16F521424]=000100
		if (i in serialMo && serialMo[i] ~ /,FieldReplaceableUnit=/)
		{
			lnhMoTable[serialMo[i]]=XpSerial[i]
			moLnhTable[XpSerial[i]]=serialMo[i]
		}
	}
	n=asort(fruList)
	for (i=1;i<=n;i++)
	{
		if (lnhMoTable[fruList[i]]=="")
		{
			if (lhlistLdn[fruList[i]]!="")
			{
				lnhMoTable[fruList[i]]=lhlistLdn[fruList[i]]
				moLnhTable[lhlistLdn[fruList[i]]]=fruList[i]
			}
			else
			{
				fk=sprintf("Z??_%02d",++k)
				lnhMoTable[fruList[i]]=fk
				moLnhTable[fk]=fruList[i]
			}
		}
	}
	#Correction where a FRU can get the wrong BXP if it had been moved from one CPRI link to another
	for (i in lnhMoTable)
	{
		if (i in lhlistLdn && lhlistLdn[i]!="" && lnhMoTable[i]!="" && lnhMoTable[i]!=lhlistLdn[i])
		{
			lnhMoTable[i]=lhlistLdn[i]
			for (j in lnhMoTable)
			{
				if (lnhMoTable[j]==lnhMoTable[i])
				{
					fk=sprintf("Z??_%02d",++k)
					lnhMoTable[i]=fk
					moLnhTable[fk]=i
				}
			}
		}
	}


}
function availableBoards(    telnet_session,board,i,j,apn,smn,coremp,spAddress,array,\
ruif_list,ruif_count,currentBoard,tmp_ruboard,temp_mod,temp_devtype,temp_mogroup,tmp_ruaddress,obif,tmp_table,peer,array1,\
tmp_xp_address,tmp_xp_list1,tmp_xp_list2,tmp_gcpu_list,devarray,devlast,havexmu,currSerial,tmp_xmu_list,tmpboard,tmp_hubsmn,tmp_hubapn,cppres)
{
	if (pdrFetched!=0) return
	customPrint("Checking available boards on node...","","force")
	if (comcli>0)
	{
		availableBoards_comcli()
		return
	}
	if (node ~ /^OFFLINE_/ && OffOk==1)
	{
		if (defaultGroupsMade!=1 || boRefresh==1 )
		{
			boRefresh=1
			cppres=parse_cpp()
			makeBoTables()
			parse_drh()
			parse_rbs_all()
			coremp=""
			delete hubMpList
			if (cppres=="99")
			{
				#there was not cpp coli file so we use the MO data
				for (i in BoardLnhList) { if (i ~ /00$/) availableBoardList[i]=i }
			}
			for (i in CoreBoardList) { hubMpList[i]=i ; coremp=coremp" "i }
			pdrFetched=1
			make_default_boardgroups(coremp)
		}
	}
	check_node_password()
	if (node_password == "") return
	if (nocorba==1)
	{
		if (mom_version=="") Get_Mom()
		if (mom_version=="") mom_version=find_node_type_coli()
		assignCustomVar("$momversion",mom_version,   "","system")
	}
	else if (Start_moMode()==1) return
	make_cpp()

	coremp=""
	for (i in hubMpList) coremp=coremp" "gensub(/00$/,"",1,i)

	if (nocorba==1) bs_pboot(telnet_session)

	if (nocorba==0 && (boTablesMade != 1 || boRefresh==1))
	{
		makeBoTables()
		#In case the arm print command failed, the hubMpList will only contain the active core MP
		#So we populate hubMpList and coremp again but with the CoreBoardList table that was got in makeBoTables
		coremp=""
		for (i in CoreBoardList) hubMpList[i]=i
		for (i in hubMpList) coremp=coremp" "gensub(/00$/,"",1,i)
	}


	DrhCenBoard=UeRegBoard="001000"
	if (nocorba==0 && tolower(mom_version) ~ "rnc" && "SpDevicePool" in sorted_attribute_list)
	{
		make_drh()
		parse_drh()
		if (fileOps("test -s "rnctablesfile)==0)
		{
			for (i in devGroupList) { $0="mr "i ; buildMoGroup("remove","short","silent") }
			while (getline < rnctablesfile)
			{
				gsub("\r","")
				if ($1 ~ /SpbDeviceSet=|SpDevicePool=/ && $2=="spmReference")
				{
					#!!!!! This part in also in makeBoTables() !!!!!!
					#Subrack=ES-1,Slot=8,PlugInUnit=1,SpbDeviceGroup=1,SpbDeviceSet=Pdr,PdrDevice=1   spmReference       Subrack=ES-1,Slot=8,PlugInUnit=1,Spu=1,Spm=1
					#SpDevicePool=PdrDevice,PdrDevice=MS-20-1     spmReference      Subrack=MS,Slot=20,PlugInUnit=1,Spu=1,Spm=1
					#SPB4:
					#SpDevicePool=CcDevice,CcDevice=1             spmReference      Subrack=MS,Slot=9,PlugInUnit=1,PiuDevice=1
					deviceTable[$3]=$1
					#Make mogroups for dc1dev,dc2dev,cc1dev,cc2dev,pdr1dev,pdr2dev
					temp_mod=rncModuleNumber[rncModTable[gensub(/,SpbDeviceSet.*$/,"",1,$1)]]+0
					temp_devtype=tolower(gensub(/^.*,|Device=.*$/,"","g",$1))
					temp_mogroup=sprintf("%s%sdev",temp_devtype,temp_mod)
					moGroup[temp_mogroup]=sprintf("%s%sEquipment=1,%s",moGroup[temp_mogroup],SUBSEP,$1)
					moGroupList[temp_mogroup]=temp_mogroup
					devGroupList[temp_mogroup]=temp_mogroup
					sub(sprintf("^%s",SUBSEP),"",moGroup[temp_mogroup])
				}
			}
			close(rnctablesfile)
		}
	}

	make_rbs()

	pdrFetched=1
	make_default_boardgroups(coremp)
}
function clear_default_boardgroups()
{
	#current limitation: mod, blade, and cc/dc/pdr module groups not cleared
	$0="br aal2ap"       ; buildBoardGroup("remove","","m")
	$0="br aal2cpsrc"    ; buildBoardGroup("remove","","m")
	$0="br aal2ncc"      ; buildBoardGroup("remove","","m")
	$0="br aal2nccadm"   ; buildBoardGroup("remove","","m")
	$0="br aal2rh"       ; buildBoardGroup("remove","","m")
	$0="br admmp"        ; buildBoardGroup("remove","","m")
	$0="br all"          ; buildBoardGroup("remove","","m")
	$0="br alld"         ; buildBoardGroup("remove","","m")
	$0="br allp"         ; buildBoardGroup("remove","","m")
	$0="br allpd"        ; buildBoardGroup("remove","","m")
	$0="br blade"        ; buildBoardGroup("remove","","m")
	$0="br bp"           ; buildBoardGroup("remove","","m")
	$0="br c1"           ; buildBoardGroup("remove","","m")
	$0="br c1mp"         ; buildBoardGroup("remove","","m")
	$0="br c2"           ; buildBoardGroup("remove","","m")
	$0="br c2mp"         ; buildBoardGroup("remove","","m")
	$0="br cenmp"        ; buildBoardGroup("remove","","m")
	$0="br ch"           ; buildBoardGroup("remove","","m")
	$0="br cmxb"         ; buildBoardGroup("remove","","m")
	$0="br cnmp"         ; buildBoardGroup("remove","","m")
	$0="br confmgr"      ; buildBoardGroup("remove","","m")
	$0="br epb"          ; buildBoardGroup("remove","","m")
	$0="br et"           ; buildBoardGroup("remove","","m")
	$0="br etatm"        ; buildBoardGroup("remove","","m")
	$0="br etip"         ; buildBoardGroup("remove","","m")
	$0="br etipcbm"      ; buildBoardGroup("remove","","m")
	$0="br etipcbm3"     ; buildBoardGroup("remove","","m")
	$0="br etipg"        ; buildBoardGroup("remove","","m")
	$0="br etmfg"        ; buildBoardGroup("remove","","m")
	$0="br etmfx"        ; buildBoardGroup("remove","","m")
	$0="br gra"          ; buildBoardGroup("remove","","m")
	$0="br imra"         ; buildBoardGroup("remove","","m")
	$0="br iru"          ; buildBoardGroup("remove","","m")
	$0="br licdb"        ; buildBoardGroup("remove","","m")
	$0="br mesc"         ; buildBoardGroup("remove","","m")
	$0="br mod"          ; buildBoardGroup("remove","","m")
	$0="br modmp"        ; buildBoardGroup("remove","","m")
	$0="br modpdr"       ; buildBoardGroup("remove","","m")
	$0="br modsb"        ; buildBoardGroup("remove","","m")
	$0="br mp"           ; buildBoardGroup("remove","","m")
	$0="br msb"          ; buildBoardGroup("remove","","m")
	$0="br msb3"         ; buildBoardGroup("remove","","m")
	$0="br msb4"         ; buildBoardGroup("remove","","m")
	$0="br mtp2hslbp"    ; buildBoardGroup("remove","","m")
	$0="br mtp2mp"       ; buildBoardGroup("remove","","m")
	$0="br nsaalmp"      ; buildBoardGroup("remove","","m")
	$0="br ommp"         ; buildBoardGroup("remove","","m")
	$0="br piudev"       ; buildBoardGroup("remove","","m")
	$0="br raa"          ; buildBoardGroup("remove","","m")
	$0="br ranapmp"      ; buildBoardGroup("remove","","m")
	$0="br rax"          ; buildBoardGroup("remove","","m")
	$0="br rnsapmp"      ; buildBoardGroup("remove","","m")
	$0="br ruif"         ; buildBoardGroup("remove","","m")
	$0="br scb"          ; buildBoardGroup("remove","","m")
	$0="br sccpmp"       ; buildBoardGroup("remove","","m")
	$0="br sctpmp"       ; buildBoardGroup("remove","","m")
	$0="br scx"          ; buildBoardGroup("remove","","m")
	$0="br scxb"         ; buildBoardGroup("remove","","m")
	$0="br smxb"         ; buildBoardGroup("remove","","m")
	$0="br spb"          ; buildBoardGroup("remove","","m")
	$0="br ss7mp"        ; buildBoardGroup("remove","","m")
	$0="br stc"          ; buildBoardGroup("remove","","m")
	$0="br sxb"          ; buildBoardGroup("remove","","m")
	$0="br tmmp"         ; buildBoardGroup("remove","","m")
	$0="br trx"          ; buildBoardGroup("remove","","m")
	$0="br tu"           ; buildBoardGroup("remove","","m")
	$0="br tx"           ; buildBoardGroup("remove","","m")
	$0="br tx3"          ; buildBoardGroup("remove","","m")
	$0="br tx6"          ; buildBoardGroup("remove","","m")
	$0="br usaalmp"      ; buildBoardGroup("remove","","m")
	$0="br xb"           ; buildBoardGroup("remove","","m")
	#$0="br xp"           ; buildBoardGroup("remove","","m")  -> this group is cleared and made in the function parse_cpp()
	$0="br ccib"         ; buildBoardGroup("remove","","m")
	$0="br gep"          ; buildBoardGroup("remove","","m")
	$0="br cax1501"      ; buildBoardGroup("remove","","m")
	$0="br cax1503"      ; buildBoardGroup("remove","","m")
	$0="br cax1504"      ; buildBoardGroup("remove","","m")
	$0="br cax1506"      ; buildBoardGroup("remove","","m")
}
function set_rnc_type(   i)
{
	if (mom_version !~ "RNC_NODE_MODEL") return
	for (i in hubMpList)
	{
		if (i ~ /^001[01]00$/) rncType="3810"
		else if (i ~ /^00(05|24)00$/) rncType="3820"
		else if (i ~ /^00(03|25)00$/ && cpplinux==1) rncType="8300"
		else if (i ~ /^00(03|25)00$/) rncType="8200"
	}
	assignCustomVar("$rnc_type",rncType,"","system")
}
function make_default_boardgroups(coremp,          array,i,tempTable,j,extragroupslist,last,tmppdrmodlist,tmppdrmodLIST)
{
	if (comcli>0)
	{
		clear_default_boardgroups_comcli()
		make_default_boardgroups_comcli()
		make_bdtypes_file()
		defaultGroupsMade=1
		return
	}

	clear_default_boardgroups()
	split(coremp,array," ")
	$0=sprintf("ba coremp %s %s",array[1],array[2]) ; buildBoardGroup("add","","m")
	last=split(bdGroup["coremp"],array,";")  #split again because the boards in the coremp variable sometimes have 00 at the end (in offline mode), sometimes not (in online mode)
	assignCustomVar("$coremp_pos",sprintf("%s%s",array[1],(array[2]!=""?":"array[2]:"")),"","system")
	assignCustomVar("$coremp_type",sprintf("%s%s",BoardType[array[1]],((array[2]!="" && array[2] in BoardType && BoardType[array[2]]!="") ?":"BoardType[array[2]]:"")),"","system")
	$0="bas all 0-9999"    ; buildBoardGroup("add","","m")
	$0="ba allp 0-9999"    ; buildBoardGroup("add","","m")
	$0="ba mp gpb|cbu|dul|duw|dug|epb|cbm|odw|dus|tp5|cetb|evoet|ods" ; buildBoardGroup("add","","m")
	$0="ba bp 0-9999"      ; buildBoardGroup("add","","m")
	$0="br bp gpb|cbu|dul|duw|dug|epb|cbm|c1mp|c2mp|blade|odw|dus|tp5|cetb|evoet|gep|ods" ; buildBoardGroup("remove","","m")
	$0="ba tu tub|cbu|dul|duw|dug|cbm|odw|dus|tp5|ods"     ; buildBoardGroup("add","","m")
	$0="ba et et-|cbu|dul|duw|dug|epb|cbm|odw|dus|tp5|ods|cetb|evoet" ; buildBoardGroup("add","","m")
	$0="ba etmfg et-mfg"    ; buildBoardGroup("add","","m")
	$0="ba etmfx et-mfx"    ; buildBoardGroup("add","","m")
	$0="ba etipg et-ipg"    ; buildBoardGroup("add","","m")
	$0="ba etip et-(mfg|mfx|ipg)|dul|duw|dug|epb|cbm|odw|dus|tp5|ods" ; buildBoardGroup("add","","m")
	#On EPB, the device processor is also a ETIP
	#$0="bas etipg epb"      ; buildBoardGroup("add","","m")
	$0="bas etip epb"       ; buildBoardGroup("add","","m")
	$0="bas et   epb"       ; buildBoardGroup("add","","m")
	$0="ba etatm et"    ; buildBoardGroup("add","","m")
	$0="br etatm etip"      ; buildBoardGroup("remove","","m")
	$0="ba scb scb|cbu"     ; buildBoardGroup("add","","m")
	$0="ba sxb sxb"         ; buildBoardGroup("add","","m")
	$0="ba scx scb|sxb|cbu" ; buildBoardGroup("add","","m")
	$0="ba spb spb"         ; buildBoardGroup("add","","m")
	$0="bas alld spb|epb"       ; buildBoardGroup("add","","m")
	$0="br alld spb|epb"        ; buildBoardGroup("remove","","m")
	$0="bas piudev spb4|epb"       ; buildBoardGroup("add","","m")
	$0="br  piudev spb4|epb"       ; buildBoardGroup("remove","","m")
	$0="bap etipcbm CXC172(8120|6212|8262|9957)" ; buildBoardGroup("add","pgm","m")
	$0="bap etipcbm3 CXC173(2029|1602)"          ; buildBoardGroup("add","pgm","m")
	$0="bap ommp cxc1320784|jvm|CXC1732844"           ; buildBoardGroup("add","pgm","m")
	$0="bau ommp osa_jvm" ; buildBoardGroup("add","rpu","m")
	$0="bau tmmp target_monitor" ; buildBoardGroup("add","rpu","m")
	$0="bap aal2ap CXC1322417|aal2ap|CXC1721300"        ; buildBoardGroup("add","pgm","m")
	$0="bap aal2ncc CXC1322419|aal2distncc"  ; buildBoardGroup("add","pgm","m")
	$0="bap aal2nccadm CXC1322420|aal2nccadm"; buildBoardGroup("add","pgm","m")
	$0="bap aal2cpsrc CXC1322418|aal2cpsrc"  ; buildBoardGroup("add","pgm","m")
	$0="bap aal2rh CXC1320993|aal2_*rh"      ; buildBoardGroup("add","pgm","m")
	$0="bau sccpmp scc_server" ; buildBoardGroup("add","rpu","m")
	#$0="bap sccpmp cxc132(1142|4304|1962|3502)|cxc172(0925|5368)|scc[^;]*server" ; buildBoardGroup("add","pgm","m")
	$0="bap mtp2mp CXC1323658" ; buildBoardGroup("add","pgm","m")
	$0="bap ss7mp CXC1322811"  ; buildBoardGroup("add","pgm","m")
	$0="bap usaalmp CXC1320997"  ; buildBoardGroup("add","pgm","m")
	$0="bap nsaalmp CXC1321172"  ; buildBoardGroup("add","pgm","m")
	$0="bap mtp2hslbp CXC1723008"  ; buildBoardGroup("add","pgm","m")
	$0="bap sctpmp CXC1325241|CXC1732006|CXC1731354" ; buildBoardGroup("add","pgm","m")
	$0="bau sctpmp sctp_host" ; buildBoardGroup("add","rpu","m")
	$0="bap admmp CXC0002420|CXC1320992|CXC1320996|CXC1321143|CXC1321171|CXC1321963|CXC1322208|CXC1322209|CXC1322210|CXC1322211|CXC1322420|CXC1323092|CXC1323491|CXC1323657|CXC1324801|CXC1325240|CXC1327798|CXC1327846|CXC1327943|CXC1723007|CXC1728281" ; ; buildBoardGroup("add","pgm","m")
	$0="baw c1mp [ge]pb_c1|c1mp"    ; buildBoardGroup("add","swa","m")
	$0="baw c2mp [ge]pb_c2|c2mp"    ; buildBoardGroup("add","swa","m")
	$0="baws c1 [ge]pb_c1|c1mp"    ; buildBoardGroup("add","swa","m")
	$0="baws c2 [ge]pb_c2|c2mp"    ; buildBoardGroup("add","swa","m")
	$0="baw blade blade"    ; buildBoardGroup("add","swa","m")
	$0="bas blade blade"    ; buildBoardGroup("add","","m")
	$0="ba cmxb cmxb"     ; buildBoardGroup("add","","m","","force")
	$0="ba ccib ccib"     ; buildBoardGroup("add","","m","","force")
	#3gsim:
	$0="bap modmp CXC1122560[/%]1" ; buildBoardGroup("add","pgm","m")
	$0="bap cnmp  CXC1123811[/%]1" ; buildBoardGroup("add","pgm","m")
	last=split(bdGroup["blade"],array,";")
	for (j=1;j<=last;j++)
	{
		if (array[j] !~ /^[0-9][0-9][0-9][0-9]00$/) continue
		$0="bas bl"gensub(/^0|00$/,"","g",array[j])" "array[j] ; buildBoardGroup("add","","m")
	}

	if (isEvo == 1)
	{
		$0="ba scxb scxb"    ; buildBoardGroup("add","","m","","force")
		$0="ba smxb smxb"    ; buildBoardGroup("add","","m","","force")
		$0="ba xb scxb cmxb ccib smxb" ; buildBoardGroup("add","","m")
		$0="ba epbmp epb" ; buildBoardGroup("add","","m")
		$0="bas epb epb"  ; buildBoardGroup("add","","m")
		$0="ba gep gep"   ; buildBoardGroup("add","","m")

		$0="br bp cmxb"   ; buildBoardGroup("remove","","m")
		$0="br bp scxb"   ; buildBoardGroup("remove","","m")
		$0="br bp smxb"   ; buildBoardGroup("remove","","m")
		$0="br bp ccib"   ; buildBoardGroup("remove","","m")
		$0="br bp xb"     ; buildBoardGroup("remove","","m")
		$0="br all cmxb"  ; buildBoardGroup("remove","","m")
		$0="br all scxb"  ; buildBoardGroup("remove","","m")
		$0="br all smxb"  ; buildBoardGroup("remove","","m")
		$0="br all ccib"  ; buildBoardGroup("remove","","m")
		$0="br all xb"    ; buildBoardGroup("remove","","m")
		$0="br allp cmxb" ; buildBoardGroup("remove","","m")
		$0="br allp scxb" ; buildBoardGroup("remove","","m")
		$0="br allp smxb" ; buildBoardGroup("remove","","m")
		$0="br allp ccib" ; buildBoardGroup("remove","","m")
		$0="br allp xb"   ; buildBoardGroup("remove","","m")
	}
	if (cpplinux == 1)
	{
		$0="bas sctpmp sctpmp" ; buildBoardGroup("add","","m")
		$0="bas sccpmp sccpmp" ; buildBoardGroup("add","","m")
		$0="ba c2 c1"          ; buildBoardGroup("add","","m")
		$0="ba c2mp c1mp"      ; buildBoardGroup("add","","m")
		if (mom_version ~ /^CPP/)
		{
			$0="ba blade 000300/d00001" ; buildBoardGroup("add","","m")
			$0="ba blade 002500/d00001" ; buildBoardGroup("add","","m")
		}
	}
	#must be after the removal of xb boards from allp in order to not include the xb's in allpd
	$0="ba allpd allp"    ; buildBoardGroup("add","","m")
	$0="ba allpd piudev"  ; buildBoardGroup("add","","m")
	if (tolower(mom_version) ~ "rnc")
	{
		if (nocorba==1)
		{
			$0="bap ranapmp "make_pgm_string("RncLmRanap") ; buildBoardGroup("add","pgm","m")
			$0="bap mod "make_pgm_string("RncLmCell")      ; buildBoardGroup("add","pgm","m")
		}
		#NOTE: on quicklink RNC, the swallocation is called GPB_Central_SCCP_ANSI_RANAP_RNSAP_OM and contains the module as well
		#      on RNC3820, the ranaprnsap MP swallocation is called GPB_C2 and on Evo it is called EPB_C2
		$0="baw sccpmp gpb_(central_)?sccp"  ; buildBoardGroup("add","swa","m")
		$0="baw ranapmp ranap"    ; buildBoardGroup("add","swa","m")
		$0="baw rnsapmp rnsap"    ; buildBoardGroup("add","swa","m")
		$0="bau ranapmp rnc_ranap"  ; buildBoardGroup("add","rpu","m")
		$0="bau rnsapmp rnc_rnsap"  ; buildBoardGroup("add","rpu","m")
		$0="bau cenmp rnc_cen_drh"  ; buildBoardGroup("add","rpu","m")
		if (cpplinux==1)
		{
			$0="bas ranapmp ranapmp" ; buildBoardGroup("add","","m")
			$0="bas rnsapmp rnsapmp" ; buildBoardGroup("add","","m")
		}
		#$0="bap ranapmp "make_pgm_string("RncLmRanap") ; buildBoardGroup("add","pgm","m")
		#$0="bap rnsapmp "make_pgm_string("RncLmRnsap") ; buildBoardGroup("add","pgm","m")
		#$0="bap cenmp "make_pgm_string("RncLmCenDrh")  ; buildBoardGroup("add","pgm","m")
		$0="ba modsb gpb_module -"; buildBoardGroup("add","swa","m")
		for (i in rncModuleList) if (i+0 > rncModMax) rncModMax=i+0
		delete tempTable
		tempTable["mod"]="gpb_module|ranap_rnsap_om|epb_blade"
		tempTable["spb"]="spb"
		for (j in tempTable)
		{
			$0="" ; $2=j ; $3="^"tempTable[j] ; buildBoardGroup("add","swa","m")
			#if (cpplinux==1 && maxCoreModule > 4)
			#{
			#	$0=""; $2="mod" ; $3="^epb_c1" ; buildBoardGroup("add","dev","m")  #bad mod epb_c1
			#}
			for (i=1;i<=rncModMax;i++)
			{
				if (i in rncModuleList && rncModuleList[i]==i)
				{
					$0="" ; $2=j i ; $3="^"tempTable[j] ; $4=i ; buildBoardGroup("add","swa","m")
					$0="" ; $2="modact"; $3="gpb_module"; $4=i ; buildBoardGroup("add","swa","m")
					#if (cpplinux==1 && maxCoreModule > 4)
					#{
					#	$0="" ; $2="mod"i ; $3="^epb_c1" ; $4=i ; buildBoardGroup("add","dev","m")  #bad modX epb_c1 X
					#}
				}
			}
		}
		delete tempTable
		tempTable["dc"]="dc" ; tempTable["cc"]="cc" ; tempTable["pdr"]="pdr"
		for (j in tempTable)
		{
			#bad dc dc
			$0="" ; $2=j ; $3=j ; buildBoardGroup("add","dev","m")
			for (i=1;i<=rncModMax;i++)
			{
				if (i in rncModuleList && rncModuleList[i]==i)
				{
					$0="" ; $2=j i ; buildBoardGroup("remove","","m")
					$0="" ; $2=j i ; $3=j ; $4=i ; buildBoardGroup("add","dev","m")
					#workaround on evo8200, some dc board groups don't contain all the piudevices
					if (isEvo==1 && j=="dc" && i~/^[0-9][0-9][0-9].$/ && cpplinux!=1)
					{
						$0="bas "j i" "j i ; buildBoardGroup("add","","m")
					}
				}
			}
			#also make board groups containing the unallocated devices
			$0="" ; $2=j 0 ; buildBoardGroup("remove","","m")
			$0="" ; $2=j 0 ; $3=j ; $4=0 ; buildBoardGroup("add","dev","m")
		}
		make_subrackBoardGroups("mod")
		make_subrackBoardGroups("spb")
		make_subrackBoardGroups("cc")
		make_subrackBoardGroups("dc")
		make_subrackBoardGroups("pdr")
		make_subrackBoardGroups("blade")
		$0="ba alld cc dc pdr" ; buildBoardGroup("add","","m")
		$0="br alld spb|epb"   ; buildBoardGroup("remove","","m")
		#make the board group modpdr which contains all the modules that handle PDR devices
		for (i in deviceTypeTableLnh)
		{
			if (deviceTypeTableLnh[i]~"PDR" && i in rncModBoTable && rncModBoTable[i] > 0) tmppdrmodlist[rncModBoTable[i]]=rncModBoTable[i]
		}
		for (i in tmppdrmodlist) tmppdrmodLIST=tmppdrmodLIST" mod"i
		$0="ba modpdr "tmppdrmodLIST ; buildBoardGroup("add","","m")
		extragroupslist=sprintf(", cenmp, ranapmp, rnsapmp, mod, modact, modsb, modpdr, mod<sr>, mod<mod>,\n%32scc, cc<sr>, cc<mod>, dc, dc<sr>, dc<mod>, pdr, pdr<sr>, pdr<mod>, alld, spb, spb<sr>, spb<mob>."," ")
	}
	else if (tolower(mom_version) ~ "rbs")
	{
		$0="ba ruif ruif|obif" ; buildBoardGroup("add","","m")
		$0="ba rax rax" ; buildBoardGroup("add","","m")
		$0="ba tx tx"   ; buildBoardGroup("add","","m")  #all tx boards
		$0="ba trx trx" ; buildBoardGroup("add","","m")  #all trx boards
		$0="ba tx6 tx6" ; buildBoardGroup("add","","m")  #only tx6
		$0="ba tx3 tx"  ; buildBoardGroup("add","","m")  #only tx3. The productname is txb so we create the group by removing tx6 from the group of all tx
		$0="br tx3 tx6" ; buildBoardGroup("remove","","m")
		extragroupslist=", rax, tx"
		if (NrOfBoards["tx3"] >0) extragroupslist=extragroupslist", tx3"
		if (NrOfBoards["tx6"] >0) extragroupslist=extragroupslist", tx6"
		if (NrOfBoards["ru"] > 0)
		{
			extragroupslist=extragroupslist", ru, ru[0-6]"
			$0="ba all ru"  ; buildBoardGroup("add","","m")
			$0="ba xp  ru"  ; buildBoardGroup("add","","m")
			#the method below can cause duplicates after doing "bor"
			#bdGroup["all"]=bdGroup["all"]";"bdGroup["ru"]
			#NrOfBoards["all"]=NrOfBoards["all"]+NrOfBoards["ru"]
		}
		if (NrOfBoards["asc"] > 0)
		{
			extragroupslist=extragroupslist", asc, asc[0-6]"
			$0="ba xp asc" ; buildBoardGroup("add","","m")
			#do not include the asc boards in "all" because they are too slow
		}
		if (NrOfBoards["xcu"] > 0)
		{
			extragroupslist=extragroupslist", xcu, xcu[0-6]"
			$0="ba all xcu" ; buildBoardGroup("add","","m")
			$0="ba xp  xcu" ; buildBoardGroup("add","","m")
		}
		if (NrOfBoards["gcpu"] > 0)
		{
			extragroupslist=extragroupslist", gcpu"
			$0="ba all gcpu" ; buildBoardGroup("add","","m")
		}

		extragroupslist=extragroupslist"."
		if (tolower(mom_version) ~ "erbs")
		{
			$0="ba xp pimcu" ; buildBoardGroup("add","","m")
			$0="ba xp ru"    ; buildBoardGroup("add","","m")
			$0="ba xp xmu"   ; buildBoardGroup("add","","m")
			$0="ba all xp"   ; buildBoardGroup("add","","m")
			$0="br xmu02"    ; buildBoardGroup("remove","","m")
			$0="br xmu03"    ; buildBoardGroup("remove","","m")
			$0="ba xmu02 xmu" ; buildBoardGroup("add","","m")
			$0="br xmu02 xmu03" ; buildBoardGroup("remove","","m")
			$0="ba xmu03 xmu03" ; buildBoardGroup("add","","m")
			#last=split(bdGroup["ru"],array,";")
			#for (i=1;i<=last;i++) { array[array[i]]=array[i] ; delete array[i] }
			#last=asort(array)
			#for (i=1;i<=last;i++)
			#{
			#	bdGroup["ru"i]=array[i]
			#	bdGroupList["ru"i]="ru"i
			#	NrOfBoards["ru"i]=1
			#}
		}
	}
	else if (tolower(mom_version) ~ "mgw")
	{
		$0="ba  msb msb"                              ; buildBoardGroup("add","","m")
		$0="ba  msb3 msb3"                            ; buildBoardGroup("add","","m")
		$0="ba  msb4 msb"                             ; buildBoardGroup("add","","m")
		$0="br  msb4 msb3"                            ; buildBoardGroup("remove","","m") #msbamccr is also part of msb4
		#define board groups with bap (pgm)
		$0="bap mesc cxc1324881|upcf_*mesc"           ; buildBoardGroup("add","pgm","m")
		$0="bap licdb  cxc1324878|upcf_*db"           ; buildBoardGroup("add","pgm","m")
		$0="bap ch   CXC1324876|upcf_*ch"             ; buildBoardGroup("add","pgm","m")
		$0="bap stc  CXC1324877|upcf_*stc"            ; buildBoardGroup("add","pgm","m")
		$0="bap gra  CXC1327888|msf_*gra|msp_crh_gra" ; buildBoardGroup("add","pgm","m")
		$0="bap imra CXC1327803|im_*ra|im_*session"   ; buildBoardGroup("add","pgm","m")
		$0="bap raa  CXC1327887|msf_*ra|msp_crh_raa"  ; buildBoardGroup("add","pgm","m")
		$0="bap confmgr cxc1324879|upcfconfmgr"       ; buildBoardGroup("add","pgm","m")
		#$0="bap msffro CXC1327783|msffro"             ; buildBoardGroup("add","pgm","m") (not needed: same as ommp)

		#same board groups defined with bau (rpu)
		$0="bau mesc upcf_mesc"                       ; buildBoardGroup("add","rpu","m")
		$0="bau licdb upcf_db"                        ; buildBoardGroup("add","rpu","m")
		$0="bau ch upcf_ch"                           ; buildBoardGroup("add","rpu","m")
		$0="bau stc upcf_stc"                         ; buildBoardGroup("add","rpu","m")
		$0="bau gra  msf_gra"                         ; buildBoardGroup("add","rpu","m")
		#$0="bau imra CXC1327803|im_*ra|im_*session"   ; buildBoardGroup("add","rpu","m")  (no rpu for this program?)
		$0="bau raa msp_crh_raa"                      ; buildBoardGroup("add","rpu","m")
		$0="bau confmgr upcf_confmgr"                 ; buildBoardGroup("add","rpu","m")
		#$0="bau msffro msp_oam_msf"                   ; buildBoardGroup("add","rpu","m")  (not needed: same as ommp)
		$0="bau mrfc mrfc_appl"                       ; buildBoardGroup("add","rpu","m")
		$0="bau mrfp mrfp_appl"                       ; buildBoardGroup("add","rpu","m")
		$0="bau imst im_streamer"                     ; buildBoardGroup("add","rpu","m")
		$0="bau bgf bgf_appl"                         ; buildBoardGroup("add","rpu","m")
		$0="baw vpp vpp_base"                         ; buildBoardGroup("add","swa","m")
		extragroupslist=extragroupslist", mesc, licdb, ch, stc, gra, raa, imra, confmgr, msb, msb3, msb4, mrfc, mrfp, imst, bgf, vpp."
	}
	else extragroupslist="."
	customPrint(sprintf("\nCreated following board-groups: all, allp, mp, bp, tu, coremp, ommp, scb, sxb, scx, sccpmp, et, etmfg, etmfx, aal2ap, aal2ncc, aal2cpsrc, aal2rh, xp%s",extragroupslist))
	customPrint(">>> Type \"bp\" to view available board-groups and \"bp <group>\" to view group contents.")
	if (tolower(mom_version) ~ "rnc")
	{
		customPrint("\nCreated following MO-groups: cc[0-9]dev, dc[0-9]dev, pdr[0-9]dev.")
		customPrint(">>> Type \"mp\" to view available MO-groups and \"pr <group>\" to view group contents.\n")
	}
	make_bdtypes_file()
	make_grpboardlist()
	#after running the function make_grpboardlist(), we can make board groups using linkhandlers that are not part of the table "availableBoardList" , eg XB or XP boards
	$0="ba cax1501 150100"    ; buildBoardGroup("add","","m")
	$0="ba cax1503 150300"    ; buildBoardGroup("add","","m")
	$0="ba cax1504 150400"    ; buildBoardGroup("add","","m")
	$0="ba cax1506 150600"    ; buildBoardGroup("add","","m")
	if (tolower(mom_version) ~ "rbs")
	{
		$0="ba iru iru"           ; buildBoardGroup("add","","m")
	}

	defaultGroupsMade=1
}
function make_pgm_string(string, i,array,j,res)
{
	buildLmidTable()
	for (i in lmidRevLookupTable)
	{
		if (tolower(i) ~ tolower(string))
		{
			split(lmidRevLookupTable[i],array,";")
			for (j in array)
			{
				if (array[j] ~ "CXC") res=res"|"array[j]
			}
		}
	}
	sub(/^\|/,"",res)
	return res
}
function make_subrackBoardGroups(what,   array,last,i,sr,tmp,j)
{
	last=split(bdGroup[what],array,";")
	for (i in SmnTable)
	{
		sr=tolower(gensub(/Subrack=|-/,"","g",i))
		tmp=""
		for (j in array)
		{
			if (array[j] ~ sprintf("^%02d",SmnTable[i])) tmp=tmp" "array[j]
		}
		$0="ba "what sr" "tmp  #; print $0 ;
		buildBoardGroup("add","","m")
	}
}
function bs_pboot(telnet_session,   i,apn,currentBoard,boardtype,z,hwfile)
{
	#this is for making the board tables when there is no access to MO service (when moshell is started with the "-l" option or with nocorba=1)
	#we use the telnet_session that had been opened previously
	if (boTablesMade != 1) boRefresh=1
	if (boRefresh != 1) return
	mo_log(tempgalog,"open","mute","overwrite","silent")
	$0=""; cabv("z")
	mo_log(tempgalog,"close")
	if (fileOps("test -s "tempcabhw)==0) hwfile=tempcabhw
	else hwfile=tempgalog
	while (getline < hwfile)
	{
		# 0   1  SCB3                         ROJ1192108/4   R1B    T013394368 20040917
		if (!($1~/^[0-9]+$/ && $2~/^[0-9]+$/ && NF>=6)) continue
		currentBoard=sprintf("%02d%02d00",$1,$2)
		boardtype=$3
		BoardType[currentBoard]=boardtype
		BoardLnhList[currentBoard]=currentBoard
		if (boardtype ~ /^SPB$/)
		{
			spmList[currentBoard]="sp0.lnh;sp1.lnh;sp2.lnh"
			for (z=0;z<=2;z++) BoardLnhList[currentBoard"/sp"z".lnh"]=currentBoard"/sp"z".lnh"
		}
		else if (boardtype ~ /^SPB[23]/)
		{
			spmList[currentBoard]="sp0.lnh;sp1.lnh;sp2.lnh;sp3.lnh;sp4.lnh"
			for (z=0;z<=4;z++) BoardLnhList[currentBoard"/sp"z".lnh"]=currentBoard"/sp"z".lnh"
		}
		else if (boardtype ~ /^EPB/)
		{
			spmList[currentBoard]="d00001"
			BoardLnhList[currentBoard"/d00001"]=currentBoard"/d00001"
		}
		else if (boardtype ~ /^SPB4/)
		{
			spmList[currentBoard]="d00001;d00002;d00003"
			for (z=1;z<=3;z++) BoardLnhList[currentBoard"/d0000"z]=currentBoard"/d0000"z
		}
	}
	close(hwfile)

	#print "bs -g -c \"pboot sh par\"\necho \"EndOfPrint\"" |& telnet_session
	#while (telnet_session |& getline)
	#{
	#	gsub("\r","") ; gsub("\x000","")
	#	if (/(^|[^\"])EndOfPrint$/) break
	#	else
	#	{
	#		i++
	#		if (i%100==0) printf "."
	#		#============== STATUS FROM SMN=000 APN= 7 PIU  ===============
	#		if (/====+ STATUS FROM SMN=[0-9]+ APN= *[0-9]+ /)
	#		{
	#			apn=gensub(/APN=/,"",1,$5)
	#			if (apn=="") apn=$6
	#			currentBoard=sprintf("%02d%02d00",gensub(/SMN=0+/,"",1,$4),apn)
	#		}
	#		else if (/productname=/)
	#		{
	#			boardtype=gensub(/^.*productname=/,"",1,$0)
	#			BoardType[currentBoard]=gensub(" ","","g",boardtype)
	#			BoardLnhList[currentBoard]=currentBoard
	#			if (boardtype ~ /^SPB$/)
	#			{
	#				spmList[currentBoard]="sp0.lnh;sp1.lnh;sp2.lnh"
	#				for (z=0;z<=2;z++) BoardLnhList[currentBoard"/sp"z".lnh"]=currentBoard"/sp"z".lnh"
	#			}
	#			else if (boardtype ~ /^SPB2/)
	#			{
	#				spmList[currentBoard]="sp0.lnh;sp1.lnh;sp2.lnh;sp3.lnh;sp4.lnh"
	#				for (z=0;z<=4;z++) BoardLnhList[currentBoard"/sp"z".lnh"]=currentBoard"/sp"z".lnh"
	#			}
	#		}
	#		else if (/productnumber=.*ROJ ?119 ?2103.5/)
	#		{
	#			#workaround for SPB3 whose productname is only "SPB" instead of "SPB3"
	#			if (/2103.51/) BoardType[currentBoard]="SPB31"
	#			else BoardType[currentBoard]="SPB3"
	#			spmList[currentBoard]="sp0.lnh;sp1.lnh;sp2.lnh;sp3.lnh;sp4.lnh"
	#			for (z=0;z<=4;z++) BoardLnhList[currentBoard"/sp"z".lnh"]=currentBoard"/sp"z".lnh"
	#		}
	#		else if (/productnumber=.*ROJ ?208 ?394.1/)   #EPB1
	#		{
	#			spmList[currentBoard]="d00001"
	#			BoardLnhList[currentBoard"/d00001"]=currentBoard"/d00001"
	#		}
	#		else if (/productnumber=.*ROJ ?119 ?2403.1/)
	#		{
	#			#workaround for SPB4 whose productname is only "SPB" instead of "SPB4"
	#			BoardType[currentBoard]="SPB4"
	#			spmList[currentBoard]="d00001;d00002;d00003"
	#			for (z=1;z<=3;z++) BoardLnhList[currentBoard"/d0000"z]=currentBoard"/d0000"z
	#		}
	#		else if (/productnumber=.*ROJ ?119 ?2106.[6-9]/ && BoardType[currentBoard]=="GPB")
	#		{
	#			#workaround for later GPB versions whose productname is only "GPB" instead of "GPBXX"
	#			BoardType[currentBoard]="GPB"gensub(/^.*\//,"",1,$0)
	#		}
	#		else if (/productnumber=.*ROJ ?119 ?2104.4/ && BoardType[currentBoard]=="TUB")
	#		{
	#			#workaround for later TUB versions whose productname is only "TUB" instead of "GPBXX"
	#			BoardType[currentBoard]="TUB2"
	#		}
	#		else if (/No connection of board/)
	#		{
	#			BoardType[currentBoard]="NOCONTACT"
	#		}
	#	}
	#}
	boTablesMade=1
	for (i in availableBoardList) if (!(i in BoardType)) BoardType[i]="UNDEF"
}
function lh(coremponly,what,option,nores,    bdgroup,command,i,j,last,array,hubMp,thisisahubmp,pipeCommand,telnode_inputvars,ok,tcmd,z,\
ftreeDir,arraysp,userCmdFile,commandList,nr_of_commands,total_nr_of_commands,lhoptions,old_muting,old_logging,old_show_colors,tmpflag,result,incremented_lhlog,lhzCount,\
fcoliawk,teanon,comcli_changed,a,increase_timeout,inputoptions,telnode_session,thelast,y)
{
	#option can take the value "z" for lhz
	#the option coremponly is not used anymore, can take any value
	if (use_lhz==0) option=""
	tmpflag=""
	if (multi) return multi_error()
	bdgroup=tolower($2)
	command=$0 ; pipeCommand=""
	if (command ~ /\|/)
	{
		pipeCommand=sprintf("| %s",gensub(/^[^\|]*\|/,"",1,command))
		sub(/\|.*$/,"",command)
	}
	sub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]*/,"",command)
	if (command=="" || bdgroup=="")
	{
		customPrint("Syntax: lh[z] <boardGroup> <COLI-command> [ | <unix commands>]")
		return (what=="user"?add_to_moscomlog("","%@> Fail (Syntax error)"):"")
	}
	if (comcli==0 && command ~ /te +log +read/ && option=="") option=eval_z(2)  #lhz is used by default with te log read
	if (comcli>0)
	{
		OffOk=1
		if (Start_moMode()==1) return 1
		if (mom_version !~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/)  return comcli_error("rcs")
	}
	if (node ~ /^OFFLINE_/)
	{
		if (NColi>0)
		{
			OffOk=1
		}
		else
		{
			customPrint("No COLI files were loaded.")
			customPrint("Please load individual COLI files with the \"lfc\" command or store the coli files (xxx_dcg_<y>.log.gz) in the same folder as modump.zip or offline.zip.")
			return
		}
	}
	else
	{
		check_node_password()
		if (node_password == "") return (what=="user"?add_to_moscomlog("","%@> Fail (Connection failure or wrong password)"):"")
	}
	#if (bdGroup["all"]=="") buildBoardGroup()
	if (defaultGroupsMade!=1 || boRefresh==1 ) buildBoardGroup() #in case there had previously been a restart on a different CV, the board groups have to be refreshed
	if (use_lhz==0) option=""  #the use_lhz can be set by reading the MOM if the CPP version is less than CPP7

	if (what=="user" && show_coli_warning()!=1 && esci_warning("lh")==1) return add_to_moscomlog("","%@> Fail (Command aborted)")

	#The lh command should also work on MO groups containing PlugInUnits/Spm/PiuDevice
	if (bdgroup in moGroup && moGroup[bdgroup] ~ "PlugInUnit=")
	{
		$0="br "bdgroup ; buildBoardGroup("remove","","m")
		$0="bam "bdgroup" "bdgroup ; buildBoardGroup("add","mo","m")
	}

	if (print_lmid > 0 && command ~ /te +log +read/ && mom_version ~ "RNC_NODE_MODEL" && pipeCommand !~ "concat_segmented_rlib_traces.pl")
	{
		teanon=""
		if (anon_ue==1&&node!~/^OFFLINE/) teanon=sprintf(" | %s -I %s/pmxcel/lib -w %s/te_anonymizer.pl",perl,commonjardir,moshelldir)
		pipeCommand=sprintf("| %s -w %s/concat_segmented_rlib_traces.pl%s%s",perl,moshelldir,teanon,pipeCommand)
	}
	if (command ~ /^(ftree|cmxbsh|dpci +dpio +start)/ || (bdgroup ~ /^(cmxb|scxb|smxb|xb)$/ && isEvo==1))
	{
		if (command ~ /\|/) pipeCommand=sprintf("| %s",gensub(/^[^\|]*\|/,"",1,command))
		split(command,array," ")
		ftreeDir=array[2]
		fileOps("rm "templhshcmd)
		last=split(bdGroup[bdgroup],array,";")
		if (command ~ /^(cmxbsh +|dpci +dpio +start +)[^ ;]/)
		{
			sub(/cmxbsh/,"cmxbsh;",command)
			sub(/dpci +dpio +start/,"dpci dpio start;",command)
		}
		#in dpci dpio, always start from the root menu by executing the / command:
		sub(/dpci +dpio +start/,"dpci dpio start;/",command)
		for (i=1;i<=last;i++)
		{
			#if (array[i]==currentHubMp) printf("ftree %s %s\n",ftreeDir,pipeCommand) >> templhshcmd
			#else
			{
				if (command ~ /^(cmxbsh|dpci +dpio +start)/) printf("lhsh %s %s %s\n",array[i],command,pipeCommand) >> templhshcmd
				else if (command ~ /^ftree/) printf("ftree %s %s %s\n",ftreeDir,array[i],pipeCommand) >> templhshcmd
				else if (bdgroup ~ /^(cmxb|scxb|smxb|xb)$/) printf("xbsh %s %s %s\n",array[i],command,pipeCommand) >> templhshcmd
			}
		}
		close(templhshcmd)
		old_show_timestamp=show_timestamp ; show_timestamp=0
		Read_script(templhshcmd)
		show_timestamp=old_show_timestamp
		close(templhshcmd)
		return
	}
	nr_of_commands=0
	if (command ~ /^run /)
	{
		if (split(command,array," ") != 2)
		{
			customPrint("Usage: lh[z] <bdGroup> run <commandFile>. Type \"h lh\" for more info.")
			return (what=="user"?add_to_moscomlog("","%@> Fail (Syntax error)"):"")
		}
		userCmdFile=array[2]
		if (fileOps("test -s "userCmdFile)!=0)
		{
			customPrint("File not found: "userCmdFile)
			return (what=="user"?add_to_moscomlog("","%@> Fail (Syntax error)"):"")
		}
		close(userCmdFile)
		while (getline < userCmdFile)
		{
			gsub("\r","") ; gsub("\x000","")
			if (NF > 0) commandList[++nr_of_commands]=gensub(/^[ \t]*|[ \t]*$/,"","g",$0)
		}
		close(userCmdFile)
	}
	else
	{
		last=split(command,array,";")
		for (i=1;i<=last;i++) if (array[i] !~ /^[ \t]*$/) commandList[++nr_of_commands]=gensub(/^[ \t]*|[ \t]*$/,"","g",array[i])
	}
	if (!(bdgroup in bdGroup && bdGroup[bdgroup] != "")) return (what=="user"&&nores==""?add_to_moscomlog("","%@> Fail (Board group not found)"):"")

	close(templhcmd)
	printf "" > templhcmd
	#check if there is an incremented templhlog
	lhzCount=gensub(/^.*\/[^/]+_|\.gz$/,"","g",templhlog)+0
	if (lhzCount<2) lhzCount++ ; else lhzCount=0
	incremented_lhlog=gensub(/_[0-9]+\.gz$/,"",1,templhlog)"_"lhzCount".gz"
	if (fileOps("test -f "incremented_lhlog)==0) templhlog=incremented_lhlog
	fileOps("rm "templhlog)
	last=split(bdGroup[bdgroup],array,";")
	for (i=1;i<=last;i++) for (j=1;j<=nr_of_commands;j++) total_nr_of_commands++
	if (comcli==0 && total_nr_of_commands > fast_lh_threshold) inputoptions="f"
	else
	{
		inputoptions=""
		option=""  #lhz does not take effect if total_nr_of_commands <= fast_lh_threshold
	}
	for (i=1;i<=last;i++)
	{
		if (BoardType[array[i]]=="NOCONTACT") continue
		for (j=1;j<=nr_of_commands;j++)
		{
			command=commandList[j]
			thisisahubmp=0
			for (hubMp in hubMpList)
			{
				if (array[i]==hubMp)
				{
					thisisahubmp=1
				}
			}
			if (command_restriction>0)
			{
				ok=0
				for (z in blockedColiCommands) if (command ~ z) ok=1
				if (ok==1) command="echo Blocked command: "command
			}
			if (cpplinux==1) command=replaceColi(command,BoardType[gensub(/\/.*$/,"",1,array[i])])
			if (command ~ /^(lmcdelete|format)( |$)/) increase_timeout=1

			if (comcli>0)
			{
				if (array[i]=="000100" || array[i]~/^(000100\/)?bbEqm[0-9]+$/)
				{
					thelast=split(command,a," ")
					if (array[i]~/^(000100\/)?bbEqm[0-9]+$/)
					{
						sub(/^000100\//,"",array[i])
						if (a[1]~/te$/)
						{
							a[1]="bbte"
							if (a[2]!="log") a[1]="bbte log"
							command=rebuild_gcpu_command(a,thelast)
							thelast=split(command,a," ")
							if (a[3]!~/^(ldo|listduplicateobjects)$/) a[3]=a[3]" "array[i]  #export|getreport
						}
						command=rebuild_gcpu_command(a,thelast)
						thelast=split(command,a," ")
						array[i]="000100/"array[i]
					}
					if (a[1] !~ "/" && RcsColiPath[a[1]]!="") command=RcsColiPath[a[1]]"/"command
					else if (node !~ /^OFFLINE/ && a[1]~/^[/]?[?]$/)
					{
						if (a[2] ~ /^[/a-z]/)
						{
							if (a[2] !~ "/" && RcsColiPath[a[2]]!="") sub(a[2],RcsColiPath[a[2]]"/"a[2],command)
							sub(a[1],"/misc/help",command)
						}
						else if (array[i]=="000100") command="/misc/cmds"  #dont translate the ? to cmds on the bbEqm
					}
					if (array[i]~/^(000100\/)?bbEqm[0-9]+$/)
					{
						if (command=="?")
						{
							#in offline mode, the "?" is run as is, otherwise it is aliased to "bbte help"
							if (node!~/^OFFLINE_/) command="/diagm/bbte help"
						}
						else if (command !~ /[^ ]*bbte /) command=""
					}
				}
				if (command!="") print "/fruacc/lhsh "array[i]" "command >> templhcmd
			}
			else if (total_nr_of_commands > fast_lh_threshold) printf("lhsh %s%s %s\n",(option~"z"?"-v ":""),array[i],command) >> templhcmd
			else
			{
				# if the commands will be executed one by one then we don't use echo EndOfPrint but the line produced at the end of "lhsh -v"
				printf("lhsh -v %s %s\n",array[i],command) >> templhcmd
				tmpflag="v"
			}
		}
	}
	close(templhcmd)
	if (comcli>0 && fileOps("test -s "templhcmd)!=0)
	{
		#the file is empy, can happen for instance if the user did "lh gcpu vii" because vii is not an applicable command for gcpu
		#then we put an empty line otherwise telnode does not recognise that this is a command file
		print "" >> templhcmd
		close(templhcmd)
	}
	inputoptions=sprintf("%sah%s%s",inputoptions,tmpflag,option)
	if (what=="user" && logging==1 && pipeCommand !~ /\|[ \t]*tee[ \t][^|]+$/)
	{
		#only do this if the command is not already piped to tee _and_ the tee is at the end of the command line
		old_logging=1 ; logging=0 ;
		old_show_colors=show_colors ; show_colors=0
		pipeCommand=pipeCommand" | tee -a "logfile
		#we temporarily turn off the muting otherwise nothing comes in the log
		if (muteLog=="mute")
		{
			old_muting="mute"
			muteLog=""
			pipeCommand=pipeCommand" | grep neverFindThisString"
		}
	}
	if (fileOps("test -s "tempcoliawk)==0) fcoliawk="-f "tempcoliawk ; else fcoliawk=""
	if (comcli==2) { comcli=1 ; comcli_changed=1 }
	if (increase_timeout==1)
	{
		old_ip_inactivity_timeout=ip_inactivity_timeout
		ip_inactivity_timeout=300
	}
	telnode_inputvars=make_inputvars(inputoptions,templhcmd"@@@@"templhlog)
	telnode_session=sprintf("%s -v variables='%s' -l %s %s -f %s -f %s --source \x027 BEGIN{ telnode_function(variables) } \x027 %s",gawk,telnode_inputvars,filefunc,fcoliawk,funcs,extern,pipeCommand)
	if (mosdebug==1) print telnode_session
	result=system(telnode_session)
	if (increase_timeout==1) ip_inactivity_timeout=old_ip_inactivity_timeout
	if (what=="user" && old_logging==1)
	{
		logging=1
		show_colors=old_show_colors
		if (old_muting=="mute") muteLog="mute"
	}
	if (comcli>0 && comcli_changed==1) comcli=2
	if (result==1 && what=="user" && pipeCommand=="") add_to_moscomlog("","%@> Fail (Connection failure or wrong password)")
}
function rebuild_gcpu_command(a,thelast,    command,y)
{
	command=""
	for (y=1;y<=thelast;y++) command=command " "a[y]
	sub(/^ +/,"",command)
	return command
}
function pdiff(molength,what,   dollar0,dollar2,dollar3,pmPre,pmList,pDiff,count,i,array,Filter3,neg,pmUl,total,printedMOs,molistok,proxyList,otherVars,hline,twait)
{
	hline="================================================================================================================="
	if ($2=="")
	{
		Display_help("pdiff")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	Filter3=$4
	if (Filter3 ~ /^!/) { sub(/^!/,"",Filter3) ; neg=1 }
	dollar0=$0
	dollar2=$2
	dollar3=$3
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	$0="" ; $2=dollar2 ; buildProxyList(molength,proxyList,otherVars)
	if (comcli>0)
	{
		if (mom_version ~ /^(RCS|CRBS|MSRBS)_NODE_MODEL/)
		{
			if (comcli_readmom_pm()!=0) return add_to_moscomlog("","%@> Fail (Connection failure)","",1)
		}
		else
		{
			customPrint("\nCommand currently only supported on CPP or RCS nodes (MSRBSv2/TCU)")
			return add_to_moscomlog("","%@> Fail (Syntax error)","",1)
		}
	}
	if (otherVars["p"]>0)
	{
		mo_log(tempbolog,"open","mute","overwrite","silent")
		muteFactor=3000
		start_time=systime()
		$0="" ; $2=dollar2 ; $3=dollar3 ; get(molength,"","","","","pm")
		if (comcli==0)
		{
			$0="" ; $2=dollar2 ; $3="^userlabel$" ; get(molength)
		}
		twait=pm_wait - systime() + start_time
		if (twait < 0) twait=0
		printf("\nwaiting %s seconds before next check...\n",twait)
		mysleep(pm_wait - systime() + start_time) # "pm_wait" seconds should have elapsed between the two amtcells counters checks on vcltp
		$0=""; $2=dollar2 ; $3=dollar3 ; get(molength,"","","","","pm")
		mo_log(tempbolog,"close")
		while (getline < tempbolog)
		{
			gsub("\r","") ; gsub("\x000","")
			if (NF==3 && $1 ~ /^[A-Z]/ && (tolower($2) ~ /^pm/ || comcli>0) && $3 ~ /^-?[0-9]+$/)
			{
				if (sprintf("%s%s%s",$1,SUBSEP,$2) in pmPre)
				{
					if (pmPre[$1,$2] < 0 || $3 < 0) pDiff[$1,$2]="N/A"
					else pDiff[$1,$2]=$3-pmPre[$1,$2]
				}
				else
				{
					pmPre[$1,$2]=$3
					pmList[++count]=$1 SUBSEP $2
				}
			}
			else if ($2=="userLabel") pmUl[$1]=$3
		}
		close(tempbolog)
		customPrint(sprintf("\n%s\n%s%s%-55s %-22s %s\n%s",hline,(get_printoutformat=="proxy" ? sprintf("%5s ","Proxy") : ""),\
(show_userlabel==1 ? sprintf("%-20s ","UserLabel") : ""),"MO","Counter","DiffValue",hline))
		for (i=1;i<=count;i++)
		{
			split(pmList[i],array,SUBSEP)
			if ( (neg==1 && pDiff[array[1],array[2]] !~ Filter3) || (neg !=1 && pDiff[array[1],array[2]] ~ Filter3) )
			{
				customPrint(sprintf("%s%s%-55s %-22s %s",(get_printoutformat=="proxy" ? sprintf("%5s ",MoProxy[array[1]]) : ""),\
							 (show_userlabel==1 ? sprintf("%-20s ",pmUl[array[1]]) : ""),\
							 array[1],array[2],pDiff[array[1],array[2]]))
				printedMOs[array[1]]=1
				molistok[array[1]]=array[1]
			}
		}
	}
	total=asort(printedMOs)
	customPrint(sprintf("%s\nTotal: %s MOs",hline,total))
	assignCustomVar("$nr_of_mos",total)
	$0="mr pdiff_group"  ; buildMoGroup("remove","short","silent")
	moGroupList["pdiff_group"]="pdiff_group"
	for (i in molistok) moGroup["pdiff_group"]=moGroup["pdiff_group"] SUBSEP m2l(molistok[i])
	sub(sprintf("^%s",SUBSEP),"",moGroup["pdiff_group"])
	#$0="lma pdiff_group ("gensub(/^\|/,"",1,ma_string)")$" ; buildMoGroup("add","long","silent")  #too slow
	customPrint(sprintf("\nAdded %s MOs to group: pdiff_group",total))
}


function stc(what,   Filter1,Filter2,motypes,externalVpi,array,i,output,dest,j,n,VpVc,TraffDesc,crossState,\
crossUserLabel,crossAside,vclAcross,crossBside,len,tmp,crossConn,start_time,rec_cell_state,faulty_vcltp_list,\
crossSide,crossStateA,crossStateB,diff_counter_rec,start_counter_rec,diff_counter_trans,start_counter_trans,\
crossStateAp,crossStateBp,tcrossAside,tcrossBside,ds0Across)
{
	if (multi || multioffline) return multi_error()
	if (comcli>0) return comcli_error()
	Filter1=tolower($2)
	Filter2=tolower($3)
	len["cc"]=4
	len["vc"]=6
	len["td"]=4
	len["tcc"]=4
	delete start_counter
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	motypes["vcltp"]=motypes["vpltp"]=motypes["atmcrossconnection"]=motypes["tdmcrossconnection"]=motypes["ds0bundle"]=1
	ConditionalLoad(motypes)
	if (nrOfMoType("atmcrossconnection")<1 && nrOfMoType("tdmcrossconnection")<1)
	{
		customPrint("No CrossConnections are defined in this node.")
		return
	}
	if (stc_done!=1 || what ~ "r")
	{
		mo_log(tempstclog,"open","mute","overwrite","silent")
		muteFactor=3000
		start_time=systime()
		$0="mr tmp_group" ; buildMoGroup("remove","short","silent")
		$0="ma tmp_group atmcrossconnection= vcltp" ; buildMoGroup("add","short","silent")
		if (what ~ "p")
		{
			$0=""; $2="tmp_group"    ; $3="atmcell"  ; get("short","","","","","pm")
		}
		$0=""; $2="crossconnection=" ; $3="userlabel|state|vcl|ds0" ; get("short")
		$0=""; $2="^vpltp="      ; $3="external" ; get("short")
		$0=""; $2="tmp_group"    ; $3="external|trafficdesc" ; get("short")
		$0=""; $2="tmp_group"    ; $3="operationalstate" ; get("short")
		if (what ~ "p")
		{
			printf("waiting %s seconds before next check on counter received/transmitted atmCells on VclTp MOs",pm_wait - systime() + start_time)
			mysleep(pm_wait - systime() + start_time) # "pm_wait" seconds should have elapsed between the two amtcells counters checks on vcltp
			$0=""; $2="tmp_group"    ; $3="atmcell"  ; get("short","","","","","pm")
		}
		$0="mr tmp_group" ; buildMoGroup("remove","short","silent")
		$0="ma tmp_group tdmcrossconnection= ds0bundle" ; buildMoGroup("add","short","silent")
		$0=""; $2="tmp_group" ; $3="timeslots|operationalstate" ; get("short")
		$0="mr tmp_group" ; buildMoGroup("remove","short","silent")
		mo_log(tempstclog,"close")
		stc_done=1
	}
	while (getline < tempstclog)
	{
		gsub("\r","") ; gsub("\x000","")
		#AtmPort=2062,VplTp=1                                      externalVpi        1
		#AtmPort=2051,VplTp=1,VpcTp=1,VclTp=40                     externalVci        40
		#AtmPort=MS-7-1,VplTp=vp4,VpcTp=1,VclTp=vc36               atmTrafficDescriptorId  AtmTrafficDescriptor=U3P2000M750
		#AtmCrossConnection=RNC302_RANAP_B                         operationalState   1 (ENABLED)
		#AtmCrossConnection=RNC302_RANAP_B                         userLabel          RNC302_RANAP_B
		#AtmCrossConnection=RNC302_RANAP_B                         vclTpAId           AtmPort=2062,VplTp=1,VpcTp=1,VclTp=52
		#AtmCrossConnection=RNC302_RANAP_B                         vclTpBId           AtmPort=2061,VplTp=2,VpcTp=2,VclTp=34
		#AtmPort=2051,VplTp=1,VpcTp=1,VclTp=40                     operationalState    0 (DISABLED)
		#AtmPort=1,VplTp=1,VpcTp=1,VclTp=1                         pmReceivedAtmCells  279106
		#AtmPort=1,VplTp=1,VpcTp=1,VclTp=1                         pmTransmittedAtmCells  279106
		if ($2 == "externalVpi") externalVpi[$1]=$3
		else if ($2 == "externalVci")
		{
			split($1,array,",")
			VpVc[sprintf("%s.*%s.*%s",gensub(/^.*=/,"",1,array[1]),gensub(/^.*=/,"",1,array[2]),gensub(/^.*=/,"",1,array[4]))]=sprintf("%s/%-s",externalVpi[sprintf("%s,%s",array[1],array[2])],$3)
		}
		else if ($2 == "atmTrafficDescriptorId")
		{
			split($1,array,",")
			tmp=gensub(/^.*=/,"",1,$3)
			TraffDesc[sprintf("%s.*%s.*%s",gensub(/^.*=/,"",1,array[1]),gensub(/^.*=/,"",1,array[2]),gensub(/^.*=/,"",1,array[4]))]=tmp
			if (length(tmp) > len["td"]) len["td"]=length(tmp)
		}
		else if ($2 == "listOfTimeSlots")
		{
			output=gensub(/,PlugInUnit=1,ExchangeTerminal=1,|PhysPathTerm|Bundle|(Spi)?Ttp/,".*","g",$1)
			sub(/Subrack=/,"",output)
			VpVc[output]=gensub(/^.* i.[0-9]+. = | *$/,"","g",$0)
		}
		else if ($1 ~ /^AtmCrossConnection=/ && $2 == "operationalState")
		{
			tmp=gensub(/^.*=/,"",1,$1)
			if (length(tmp) > len["cc"]) len["cc"]=length(tmp)
			crossState[$1]=$3
		}
		else if ($1 ~ /^TdmCrossConnection=/ && $2 == "operationalState")
		{
			tmp=gensub(/^.*=/,"",1,$1)
			if (length(tmp) > len["tcc"]) len["tcc"]=length(tmp)
			crossState[$1]=$3
		}
		else if ($2 == "userLabel")
		{
			if (NF==3) crossUserLabel[$1]=$3
			else
			{
				crossUserLabel[$1]=""
				for (i=3;i<=NF;i++) crossUserLabel[$1]=sprintf("%s %s",crossUserLabel[$1],$i)
				gsub(/^ +/,"",crossUserLabel[$1])
			}
		}
		else if ($2 ~ /^vclTp/)
		{
			split($3,array,",")
			output=sprintf("%s.*%s.*%s",gensub(/^.*=/,"",1,array[1]),gensub(/^.*=/,"",1,array[2]),gensub(/^.*=/,"",1,array[4]))
			if (length(output) > len["vc"]) len["vc"]=length(output)
			if ($2 ~ /vclTpA/)
			{
				crossAside[$1]=output
				vclAcross[output]=$1
				crossConn[$3]=$1
				crossSide[$3]="A"
			}
			else if ($2 ~ /vclTpB/)
			{
				crossBside[$1]=output
				crossConn[$3]=$1
				crossSide[$3]="B"
			}
		}
		else if ($2 ~ /ds0BundleMoRef/)
		{
			output=gensub(/,PlugInUnit=1,ExchangeTerminal=1,|PhysPathTerm|Bundle|(Spi)?Ttp/,".*","g",$3)
			sub(/Subrack=/,"",output)
			if ($2 ~ /ds0BundleMoRefA/)
			{
				if (length(output) > len["ds0a"]) len["ds0a"]=length(output)
				tcrossAside[$1]=output
				ds0Across[output]=$1
				crossConn[$3]=$1
				crossSide[$3]="A"
			}
			else if ($2 ~ /ds0BundleMoRefB/)
			{
				if (length(output) > len["ds0b"]) len["ds0b"]=length(output)
				tcrossBside[$1]=output
				crossConn[$3]=$1
				crossSide[$3]="B"
			}
		}
		else if ($1 ~ /^AtmPort.*VclTp=/ && $2 == "operationalState")
		{
			if (crossSide[$1]=="A") crossStateA[crossConn[$1]]=$3
			else if (crossSide[$1]=="B") crossStateB[crossConn[$1]]=$3
		}
		else if ($1 ~ /,Ds0Bundle=/ && $2 == "operationalState")
		{
			if (crossSide[$1]=="A") crossStateA[crossConn[$1]]=$3
			else if (crossSide[$1]=="B") crossStateB[crossConn[$1]]=$3
			#print crossConn[$1],crossSide[$1],$3
		}
		else if ($1 ~ /^AtmPort.*VclTp=/ && $2 == "pmReceivedAtmCells")
		{
			if ($1 in start_counter_rec)
			{
				if (start_counter_rec[$1] < 0 || $3 < 0) diff_counter_rec[$1]="?"
				else diff_counter_rec[$1]=$3 - start_counter_rec[$1]
				#rec_cell_state=0
				#if (($3 - start_counter[$1]) > 0) rec_cell_state=1
				#crossState[crossConn[$1]]=crossState[crossConn[$1]] rec_cell_state
				#if (rec_cell_state==0) faulty_vcltp_list[$1]=$1
			}
			else start_counter_rec[$1]=$3
		}
		else if ($1 ~ /^AtmPort.*VclTp=/ && $2 == "pmTransmittedAtmCells")
		{
			if ($1 in start_counter_trans)
			{
				if (start_counter_trans[$1] < 0 || $3 < 0) diff_counter_trans[$1]="?"
				else diff_counter_trans[$1]=$3 - start_counter_trans[$1]
				if (diff_counter_rec[$1]==0 && diff_counter_trans[$1] >0)
				{
					if (crossSide[$1]=="A") crossStateAp[crossConn[$1]]=0
					else if (crossSide[$1]=="B") crossStateBp[crossConn[$1]]=0
				}
				else if (diff_counter_rec[$1]=="?" || diff_counter_trans[$1]=="?")
				{
					if (crossSide[$1]=="A") crossStateAp[crossConn[$1]]="?"
					else if (crossSide[$1]=="B") crossStateBp[crossConn[$1]]="?"
				}
				else
				{
					if (crossSide[$1]=="A" && crossStateA[crossConn[$1]]==1) crossStateAp[crossConn[$1]]=1
					else if (crossSide[$1]=="A" && crossStateA[crossConn[$1]]==0) crossStateAp[crossConn[$1]]=0
					else if (crossSide[$1]=="B" && crossStateB[crossConn[$1]]==1) crossStateBp[crossConn[$1]]=1
					else if (crossSide[$1]=="B" && crossStateB[crossConn[$1]]==0) crossStateBp[crossConn[$1]]=0
				}
			}
			else start_counter_trans[$1]=$3
		}
	}
	close(tempstclog)
	n=asort(crossAside,dest)
	customPrint(sprintf("\n\
=========================================================================================================================\n\
%-*s %-5s %-*s %-*s %7s %7s %-*s %-*s %s\n\
=========================================================================================================================",\
len["cc"],"CCId","CSSPP",len["vc"],"VclTpA",len["vc"],"VclTpB","Vp/VcA","Vp/VcB",len["td"],"TD-A",len["td"],"TD-B","UserLabel"))
	for (j=1;j<=n;j++)
	{
		tempCross=vclAcross[dest[j]]
		crossState[tempCross]=sprintf("%1s%1s%1s%1s%1s",crossState[tempCross],crossStateA[tempCross],crossStateB[tempCross],crossStateAp[tempCross],crossStateBp[tempCross])
		output=sprintf("%-*s %s %-*s %-*s %7s %7s %-*s %-*s %s",\
len["cc"],gensub(/^.*=/,"",1,tempCross),crossState[tempCross],\
len["vc"],crossAside[tempCross],len["vc"],crossBside[tempCross],\
VpVc[crossAside[tempCross]],VpVc[crossBside[tempCross]],len["td"],TraffDesc[crossAside[tempCross]],\
len["td"],TraffDesc[crossBside[tempCross]],crossUserLabel[tempCross])
		if (Filter1=="") customPrint(output)
		else if (Filter2=="" && tolower(output) ~ Filter1) customPrint(output)
		else if (tolower(output) ~ Filter1 && crossState[tempCross] ~ Filter2) customPrint(output)
	}
	customPrint("-------------------------------------------------------------------------------------------------------------------------")
	#TDM cross connections
	if (nrOfMoType("tdmcrossconnection")<1) return
	customPrint(sprintf("\n\
=========================================================================================================================\n\
%-*s %-3s %3s %3s %-*s %-*s %s\n\
=========================================================================================================================",\
len["tcc"],"CCId","CSS","TSA","TSB",len["ds0a"],"Ds0A",len["ds0b"],"Ds0B","UserLabel"))
	n=asort(tcrossAside,dest)
	for (j=1;j<=n;j++)
	{
		tempCross=ds0Across[dest[j]]
		crossState[tempCross]=sprintf("%1s%1s%1s",crossState[tempCross],crossStateA[tempCross],crossStateB[tempCross])
		output=sprintf("%-*s %-3s %3s %3s %-*s %-*s %s",len["tcc"],gensub(/^.*=/,"",1,tempCross),crossState[tempCross],\
VpVc[tcrossAside[tempCross]],VpVc[tcrossBside[tempCross]],\
len["ds0"],tcrossAside[tempCross],len["ds0"],tcrossBside[tempCross],\
crossUserLabel[tempCross])
		if (Filter1=="") customPrint(output)
		else if (Filter2=="" && tolower(output) ~ Filter1) customPrint(output)
		else if (tolower(output) ~ Filter1 && crossState[tempCross] ~ Filter2) customPrint(output)
	}
	customPrint("-------------------------------------------------------------------------------------------------------------------------")

	#disable the following functionality for the moment, will be presented in a different way
	return
	n=asort(faulty_vcltp_list)
	if (n < 1) return
	$0="mr stc_faulty_vcltp" ; buildMoGroup("remove","short","silent")
	customPrint(sprintf("\nFollowing VclTp's are suspected faulty because their pmReceivedAtmCells counter has not incremented in a period of %s seconds:\n\
=========================================================================================================================\n\
%-50s %-8s %s\n\
=========================================================================================================================",\
pm_wait,"Faulty VclTp","CC State","CC MOid"))
	for (j=1;j<=n;j++)
	{
		customPrint(sprintf("%-50s %8s %s",faulty_vcltp_list[j],crossState[crossConn[faulty_vcltp_list[j]]],gensub(/.*=/,"",1,crossConn[faulty_vcltp_list[j]])))
		moGroup["stc_faulty_vcltp"]=sprintf("%s%sTransportNetwork=1,%s",moGroup["stc_faulty_vcltp"],SUBSEP,faulty_vcltp_list[j])
	}
	moGroupList["stc_faulty_vcltp"]="stc_faulty_vcltp"
	sub(sprintf("^%s",SUBSEP),"",moGroup["stc_faulty_vcltp"])
	customPrint("-------------------------------------------------------------------------------------------------------------------------")
	customPrint("\nTO EXECUTE A MORE THOROUGH CHECK, PLEASE RUN THE COMMAND: acc stc_faulty_vcltp eteloopback")
	customPrint("(This will execute the action eteloopback on every suspected faulty vcltp.)")
}
function ete(   Filter1,proxyList,otherVars,p,i,mo,ete_faulty_vcltp,motypes)
{
	customPrint("")
	print_date()
	if (Start_moMode()==1) return
	buildProxyList("long",proxyList,otherVars)
	p=otherVars["p"]
	customPrint("\nRunning end-to-end loopback test on VclTp's, please wait...")
	mo_log(tempetelog,"open","mute","overwrite")
	muteFactor=10000
	disabled_confirmation=1   #cannot turn off/on bldebset_confirmation otherwise interferes with confb+/confb-
	for (i=1;i<=p;i++)
	{
		if (p2s("MoType",proxyList[i]) != "VclTp") continue
		$0="acc "proxyList[i]" eteloopback" ; act("call","short")
		printf "\r"i"/"p
	}
	disabled_confirmation=0
	mo_log(tempetelog,"close")
	while (getline < tempetelog)
	{
		gsub("\r","")
		#  660  AtmPort=MS-11-1,VplTp=vp2,VpcTp=1,VclTp=vc4141                 eteLoopBack                    0
		# >>> Return value = true
		if ($3=="eteLoopBack") mo=$2
		else if ($1==">>>" && $2=="Return" && $3=="value" && $5 != "true") ete_faulty_vcltp[mo]=mo
	}
	close(tempetelog)
	n=asort(ete_faulty_vcltp)
	$0="mr ete_faulty_vcltp" ; buildMoGroup("remove","short","silent")
	for (i=1;i<=n;i++) moGroup["ete_faulty_vcltp"]=sprintf("%s%sTransportNetwork=1,%s",moGroup["ete_faulty_vcltp"],SUBSEP,ete_faulty_vcltp[i])
	if (n>0)
	{
		moGroupList["ete_faulty_vcltp"]="ete_faulty_vcltp"
		sub(sprintf("^%s",SUBSEP),"",moGroup["ete_faulty_vcltp"])
	}
	customPrint("\nCreated MO group \"ete_faulty_vcltp\" containing all VclTp's that failed the end-to-end loopback test.\n\
Running command \"lkv\" on this MO group.")
	$0="lkv ete_faulty_vcltp" ; lkv("short","\n\nFollowing VclTp's have failed the end-to-end loopback test (action eteloopback):")
	customPrint("Faulty VclTp's are saved in the MO group \"ete_faulty_vcltp\".")
}
function stt(what,   Filter1,Filter2,user_list,state_list,tmp_mo,klm_list,n,output,tmp_pos,pos_list,tmp_child,count,\
pp_name,longest,pp_pos,maxlength,mtp3data,extra_data,slc_list,motypes)
{
	if (multi || multioffline) return multi_error()
	if (comcli>0) return comcli_error()
	Filter1=tolower($2)
	Filter2=tolower($3)
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	maxlength=90
	motypes["ds0bundle"]=1
	motypes["sts3cspettp"]=motypes["vt15ttp"]=motypes["t1ttp"]=1
	motypes["vc4ttp"]=motypes["vc12ttp"]=motypes["e1ttp"]=1
	#motypes["vc3ttp"]=motypes["vc11ttp"]=motypes["hgttp"]=1  #not supported yet
	motypes["t1physpathterm"]=motypes["t3physpathterm"]=1
	motypes["e1physpathterm"]=motypes["e3physpathterm"]=1
	motypes["j1physpathterm"]=1
	motypes["imagroup"]=motypes["imalink"]=1
	motypes["mtp3bslitu"]=motypes["mtp3bslansi"]=motypes["mtp3bslttc"]=motypes["mtp3bslchina"]=1
	motypes["mtp2tpitu"]=motypes["mtp2tpansi"]=motypes["mtp2tpttc"]=motypes["mtp2tpchina"]=1
	motypes["mtp2hsltpitu"]=motypes["mtp2hsltpchina"]=1
	ConditionalLoad(motypes)
	if (stt_done!=1 || what ~ "r")
	{
		mo_log(tempsttlog,"open","mute","overwrite","silent")
		muteFactor=2000
		$0="mr tmp_stt_group"                                  ; buildMoGroup("remove","short","silent")
		$0="lma tmp_stt_group os155|physpathterm reservedby"   ; buildMoGroup("add","long","silent")
		$0="lget os155|physpathterm reservedby"                ; 