#!/bin/bash -fp
# defLogDir v1.5 Finn Magnusson
# NOT for general use! This script is called by the other utilities to define the log directory.
# Usage: defLogDir.sh [<scriptname>]
# Syntax 1: defLogDir.sh
# This will define the path to .moshellrc, create it if necessary and print its path.
# Syntax 2: defLogDir.sh mobatch (or moshell or cabview etc.)
# This will define the path to .moshellrc and create it if necessary .
# Then it will print the path to mobatch/moshell/cabview/etc log directory and will create that directory.

######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

#PATH TO MOSHELL AND GAWK, DO NOT EDIT !
moshelldir=`dirname "$0"`
vobsinstallation=0
unamea=$(uname -a)
export PATH=${PATH}:/usr/ucb   #workaround for whoami which is sometimes not found in the PATH
if [[ -z "$USER" ]] ; then export USER=$(whoami) ; fi
if [[ $moshelldir != /* ]] ; then moshelldir=`pwd`/$moshelldir ; fi
moshelldir=${moshelldir%/commonjars}
if [[ $moshelldir = /moshellroot ]] ; then
	gawk=/moshellroot/commonjars/gawk
elif [[ $vobsinstallation = 1 && $unamea = [Ll][iI][nN][uU][xX]*x86_64* ]] ; then
	gawk="$moshelldir/gawk.lin64"
elif [[ $vobsinstallation = 1 && $unamea = [Ll][iI][nN][uU][xX]* ]] ; then
	gawk="$moshelldir/gawk.linux"
elif [[ $vobsinstallation = 1 && $unamea = SunOS*i86pc* ]] ; then
	gawk="$moshelldir/gawk.sol86"
elif [[ $vobsinstallation = 1 && $unamea = SunOS* ]] ; then
	gawk="$moshelldir/gawk.solaris"
else
	gawk="$moshelldir/gawk"
fi

#Set the LD_LIBRARY_PATH so gawk may find some missing libraries
if [[ $unamea = [Ll][iI][nN][uU][xX]*x86_64* ]] ; then gawklib="lin64"   
elif [[ $unamea = [Ll][iI][nN][uU][xX]* ]]      ; then gawklib="linux"   
elif [[ $unamea = SunOS*sparc* ]]               ; then gawklib="solaris" 
elif [[ $unamea = SunOS* ]]                     ; then gawklib="sol86"   
else gawklib="cygwin" 
fi

#special case where moshell has been installed on a linux 32 bit machine but should be run on linux 64 sharing the same file system
if [[ $unamea = [Ll][iI][nN][uU][xX]*x86_64* && $vobsinstallation != 1 && `file "$moshelldir/gawk"` = *32-bit* ]] ; then gawklib="linux" ; fi

export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:$moshelldir/commonjars/lib/${gawklib} 

if [[ -d /opt/ericsson/amos/moshell ]] ; then
        moshellrc="$HOME/.moshellrc"
        logdir="/var/opt/ericsson/amos/moshell_logfiles"
        if [[ $unamea = [Ll][iI][nN][uU][xX]* ]] ; then logdir="/ericsson/log/amos/moshell_logfiles" ; fi
        mkdir -p $logdir
        chmod 1777 $logdir >/dev/null 2>&1
        logdir="$logdir/$USER"
        mkdir -p $logdir
        chmod 1777 $logdir >/dev/null 2>&1        
elif [[ $(uname) = CYG* && "$HOME" != *home* && "$HOME" != *sers* ]] ; then
	moshellrc=$moshelldir/.moshellrc
	logdir=$moshelldir/logfiles
else
	moshellrc=$HOME/.moshellrc
	logdir=$HOME/moshell_logfiles
	if [[ $moshelldir = /moshellroot ]] ; then 
		if [[ -n "$REALHOME" ]] ; then moshellrc=$REALHOME/.moshellrc ; fi
		logdir=$HOME/moshell_logfiles/$USER 
	fi
fi

if ! [[ -r $moshellrc && -f $moshellrc && -w $moshellrc ]] ; then
cat <<EOF > $moshellrc
#Examples of customizable settings (refer to the moshell file to see a complete list
#of supported user variables or print them using the "uv" command)
#take off the # sign at beginning of line to uncomment

#prompt_highlight=1
#set_window_title=1

#Alias examples:
alias ter te log read
alias tec te log clear
alias llc llog -c
alias ll llog
alias lll llog -l
alias err te log read |grep ERROR:
EOF
fi

if [[ $moshelldir = /moshellroot ]] ; then chmod 666 $moshellrc ; fi
if [[ -d /opt/ericsson/amos/moshell ]] ; then chmod 600 $moshellrc ; fi

if [[ -z $1 ]] ; then echo $moshellrc ; fi

if [[ -n $1 ]] ; then
	if [[ $moshelldir = /moshellroot ]] ; then
		umask 000
		mkdir -p $logdir/logs_$1
		echo -n $logdir/logs_$1
		umask 022
	elif [[ -d /opt/ericsson/amos/moshell ]] ; then
		mkdir -p $logdir/logs_$1
		echo -n $logdir/logs_$1
		chmod 1777 $logdir/logs_$1 >/dev/null 2>&1
	else
		$gawk -v moshellrc="$moshellrc" -v script=$1 -v logdir="$logdir" ' BEGIN {
			if (system("test -r "moshellrc)==0) 
			{
				while ((getline < moshellrc)>0)
				{
		        		gsub("\r","") ; gsub(/#.*$/,"") ; gsub("\"","")
		        		if (/^[ \t]*(logdir)[ \t]*=/) gsub(/[ \t]/,"")
		        		if ($1 ~ /^logdir=/) 
		        		{ 
		        			split($1,array,"=") 
			        		gsub(/\$HOME/,ENVIRON["HOME"],array[2])
						gsub(/\$USER/,ENVIRON["USER"],array[2])
		        			if (system("test -d "array[2])==0 && system("test -w "array[2])==0) logdir=array[2] 
		        			break 
		        		}
				}
				close(moshellrc)
			}
			sublogdir=sprintf("%s/logs_%s",logdir,script)
			if (system("mkdir -p "sublogdir)==0) printf sublogdir
			} '
	fi
fi

