package RfPort;

use strict;
use warnings;

sub new {
	my $class = shift;
	my $input = shift;
	
	my @input_array = @$input;
	
	my $id = $input_array[0] . $input_array[3];
	my $bridge_desc = $input_array[1];
	
	#000100/port_xcu_dev_14/port_5_dev_20 blir 000100/px_d14/p5_d20
	if($bridge_desc =~ m/^\S+\/port_\S+_\S+_\S+\/port_\S+_\S+_\S+$/){
		$bridge_desc = join("", ($bridge_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	elsif($bridge_desc =~ m/^\S+\/port_\S+_\S+_\S+$/) {
		$bridge_desc = join("", ($bridge_desc =~ m/^(\S+\/p)ort_(\S)\S*(_\S)\S*_(\S+)$/));
	}
	
	my $port = $input_array[3];
	my $cell = "";
	if(!($input_array[7] eq "")){
		$cell = (split(/\(/, $input_array[7]))[0];
	}
		
	my $self = {
		_id				=> 	$id,
		_bridge_desc	=>	$bridge_desc,
		_port			=>	$port,
		_cell			=>	$cell,
		_ports			=> [$port],
	};

	bless $self, $class;

	return $self;
}

sub getBridgeDesc {
	my ($self) = @_;
	return $self->{_bridge_desc};
}

sub getPort {
	my ($self) = @_;
	return $self->{_port};
}

sub getCell {
	my ($self) = @_;
	return $self->{_cell};
}

sub getPortIdentifier {
	my ($self) = @_;
	return $self->{_id};
}

sub getPorts {
	my ($self) = @_;
	return $self->{_ports};
}

1;
